// vim: filetype=xs
#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include "const-c.inc"

GV * a_GV, * b_GV;

#include "tree_common.h"

#define KV_PASTER(NAME, KEY, VALUE) NAME ## _ ## KEY ## _ ## VALUE
#define KV_EVALUATOR(NAME, KEY, VALUE) KV_PASTER(NAME, KEY, VALUE)
#define KV(NAME) KV_EVALUATOR(NAME, KEY, VALUE)

#define K_PASTER(NAME, KEY) NAME ## _ ## KEY
#define K_EVALUATOR(NAME, KEY) K_PASTER(NAME, KEY)
#define K(NAME) K_EVALUATOR(NAME, KEY)
#define V(NAME) K_EVALUATOR(NAME, VALUE)

#define I_EVALUATOR(NAME) NAME ## _id
#define I(NAME) I_EVALUATOR(NAME)

#define T_EVALUATOR(NAME) NAME ## _t
#define T(NAME) T_EVALUATOR(NAME)

#include "tree_customize.h"

#define KEY int
#  include "include_tree_with_different_value_type.h"
#undef KEY

#define KEY num
#  include "include_tree_with_different_value_type.h"
#undef KEY

#define KEY str
#  include "include_tree_with_different_value_type.h"
#undef KEY

#define KEY any
#  include "include_tree_with_different_value_type.h"
#undef KEY

MODULE = Tree::SizeBalanced		PACKAGE = Tree::SizeBalanced::Core		

BOOT:
    a_GV = gv_fetchpvn_flags("::a", 3, 1, SVt_PV);
    b_GV = gv_fetchpvn_flags("::b", 3, 1, SVt_PV);

INCLUDE: const-xs.inc

void
new_int_void(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_int_void(aTHX_ SP, class,cmp);

void
DESTROY_int_void(SV * obj)
    PPCODE:
        SP = DESTROY_int_void(aTHX_ SP, obj);


void
size_int_void(SV *obj)
    PPCODE:
        SP = size_int_void(aTHX_ SP, obj);

void
insert_int_void(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_int_void(aTHX_ SP, obj,key,value);

void
delete_int_void(SV * obj, SV * key)
    PPCODE:
        SP = delete_int_void(aTHX_ SP, obj,key);


void
find_int_void(SV * obj, SV * key)
    PPCODE:
        SP = find_int_void(aTHX_ SP, obj,key);

void
find_lt_int_void(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_int_void(aTHX_ SP, obj,key);

void
find_le_int_void(SV * obj, SV * key)
    PPCODE:
        SP = find_le_int_void(aTHX_ SP, obj,key);

void
find_gt_int_void(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_int_void(aTHX_ SP, obj,key);

void
find_ge_int_void(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_int_void(aTHX_ SP, obj,key);


void
count_lt_int_void(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_int_void(aTHX_ SP, obj,key);

void
count_le_int_void(SV * obj, SV * key)
    PPCODE:
        SP = count_le_int_void(aTHX_ SP, obj,key);

void
count_gt_int_void(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_int_void(aTHX_ SP, obj,key);

void
count_ge_int_void(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_int_void(aTHX_ SP, obj,key);


void
find_min_int_void(SV * obj)
    PPCODE:
        SP = find_min_int_void(aTHX_ SP, obj);

void
find_max_int_void(SV * obj)
    PPCODE:
        SP = find_max_int_void(aTHX_ SP, obj);


void
skip_l_int_void(SV * obj, int offset)
    PPCODE:
        SP = skip_l_int_void(aTHX_ SP, obj,offset);

void
skip_g_int_void(SV * obj, int offset)
    PPCODE:
        SP = skip_g_int_void(aTHX_ SP, obj,offset);


void
dump_int_void(SV *obj)
    PPCODE:
        SP = dump_int_void(aTHX_ SP, obj);

void
check_int_void(SV * obj)
    PPCODE:
        SP = check_int_void(aTHX_ SP, obj);


void
new_int_int(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_int_int(aTHX_ SP, class,cmp);

void
DESTROY_int_int(SV * obj)
    PPCODE:
        SP = DESTROY_int_int(aTHX_ SP, obj);


void
size_int_int(SV *obj)
    PPCODE:
        SP = size_int_int(aTHX_ SP, obj);

void
insert_int_int(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_int_int(aTHX_ SP, obj,key,value);

void
delete_int_int(SV * obj, SV * key)
    PPCODE:
        SP = delete_int_int(aTHX_ SP, obj,key);


void
find_int_int(SV * obj, SV * key)
    PPCODE:
        SP = find_int_int(aTHX_ SP, obj,key);

void
find_lt_int_int(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_int_int(aTHX_ SP, obj,key);

void
find_le_int_int(SV * obj, SV * key)
    PPCODE:
        SP = find_le_int_int(aTHX_ SP, obj,key);

void
find_gt_int_int(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_int_int(aTHX_ SP, obj,key);

void
find_ge_int_int(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_int_int(aTHX_ SP, obj,key);


void
count_lt_int_int(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_int_int(aTHX_ SP, obj,key);

void
count_le_int_int(SV * obj, SV * key)
    PPCODE:
        SP = count_le_int_int(aTHX_ SP, obj,key);

void
count_gt_int_int(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_int_int(aTHX_ SP, obj,key);

void
count_ge_int_int(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_int_int(aTHX_ SP, obj,key);


void
find_min_int_int(SV * obj)
    PPCODE:
        SP = find_min_int_int(aTHX_ SP, obj);

void
find_max_int_int(SV * obj)
    PPCODE:
        SP = find_max_int_int(aTHX_ SP, obj);


void
skip_l_int_int(SV * obj, int offset)
    PPCODE:
        SP = skip_l_int_int(aTHX_ SP, obj,offset);

void
skip_g_int_int(SV * obj, int offset)
    PPCODE:
        SP = skip_g_int_int(aTHX_ SP, obj,offset);


void
dump_int_int(SV *obj)
    PPCODE:
        SP = dump_int_int(aTHX_ SP, obj);

void
check_int_int(SV * obj)
    PPCODE:
        SP = check_int_int(aTHX_ SP, obj);


void
new_int_num(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_int_num(aTHX_ SP, class,cmp);

void
DESTROY_int_num(SV * obj)
    PPCODE:
        SP = DESTROY_int_num(aTHX_ SP, obj);


void
size_int_num(SV *obj)
    PPCODE:
        SP = size_int_num(aTHX_ SP, obj);

void
insert_int_num(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_int_num(aTHX_ SP, obj,key,value);

void
delete_int_num(SV * obj, SV * key)
    PPCODE:
        SP = delete_int_num(aTHX_ SP, obj,key);


void
find_int_num(SV * obj, SV * key)
    PPCODE:
        SP = find_int_num(aTHX_ SP, obj,key);

void
find_lt_int_num(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_int_num(aTHX_ SP, obj,key);

void
find_le_int_num(SV * obj, SV * key)
    PPCODE:
        SP = find_le_int_num(aTHX_ SP, obj,key);

void
find_gt_int_num(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_int_num(aTHX_ SP, obj,key);

void
find_ge_int_num(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_int_num(aTHX_ SP, obj,key);


void
count_lt_int_num(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_int_num(aTHX_ SP, obj,key);

void
count_le_int_num(SV * obj, SV * key)
    PPCODE:
        SP = count_le_int_num(aTHX_ SP, obj,key);

void
count_gt_int_num(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_int_num(aTHX_ SP, obj,key);

void
count_ge_int_num(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_int_num(aTHX_ SP, obj,key);


void
find_min_int_num(SV * obj)
    PPCODE:
        SP = find_min_int_num(aTHX_ SP, obj);

void
find_max_int_num(SV * obj)
    PPCODE:
        SP = find_max_int_num(aTHX_ SP, obj);


void
skip_l_int_num(SV * obj, int offset)
    PPCODE:
        SP = skip_l_int_num(aTHX_ SP, obj,offset);

void
skip_g_int_num(SV * obj, int offset)
    PPCODE:
        SP = skip_g_int_num(aTHX_ SP, obj,offset);


void
dump_int_num(SV *obj)
    PPCODE:
        SP = dump_int_num(aTHX_ SP, obj);

void
check_int_num(SV * obj)
    PPCODE:
        SP = check_int_num(aTHX_ SP, obj);


void
new_int_any(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_int_any(aTHX_ SP, class,cmp);

void
DESTROY_int_any(SV * obj)
    PPCODE:
        SP = DESTROY_int_any(aTHX_ SP, obj);


void
size_int_any(SV *obj)
    PPCODE:
        SP = size_int_any(aTHX_ SP, obj);

void
insert_int_any(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_int_any(aTHX_ SP, obj,key,value);

void
delete_int_any(SV * obj, SV * key)
    PPCODE:
        SP = delete_int_any(aTHX_ SP, obj,key);


void
find_int_any(SV * obj, SV * key)
    PPCODE:
        SP = find_int_any(aTHX_ SP, obj,key);

void
find_lt_int_any(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_int_any(aTHX_ SP, obj,key);

void
find_le_int_any(SV * obj, SV * key)
    PPCODE:
        SP = find_le_int_any(aTHX_ SP, obj,key);

void
find_gt_int_any(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_int_any(aTHX_ SP, obj,key);

void
find_ge_int_any(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_int_any(aTHX_ SP, obj,key);


void
count_lt_int_any(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_int_any(aTHX_ SP, obj,key);

void
count_le_int_any(SV * obj, SV * key)
    PPCODE:
        SP = count_le_int_any(aTHX_ SP, obj,key);

void
count_gt_int_any(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_int_any(aTHX_ SP, obj,key);

void
count_ge_int_any(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_int_any(aTHX_ SP, obj,key);


void
find_min_int_any(SV * obj)
    PPCODE:
        SP = find_min_int_any(aTHX_ SP, obj);

void
find_max_int_any(SV * obj)
    PPCODE:
        SP = find_max_int_any(aTHX_ SP, obj);


void
skip_l_int_any(SV * obj, int offset)
    PPCODE:
        SP = skip_l_int_any(aTHX_ SP, obj,offset);

void
skip_g_int_any(SV * obj, int offset)
    PPCODE:
        SP = skip_g_int_any(aTHX_ SP, obj,offset);


void
dump_int_any(SV *obj)
    PPCODE:
        SP = dump_int_any(aTHX_ SP, obj);

void
check_int_any(SV * obj)
    PPCODE:
        SP = check_int_any(aTHX_ SP, obj);


void
new_num_void(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_num_void(aTHX_ SP, class,cmp);

void
DESTROY_num_void(SV * obj)
    PPCODE:
        SP = DESTROY_num_void(aTHX_ SP, obj);


void
size_num_void(SV *obj)
    PPCODE:
        SP = size_num_void(aTHX_ SP, obj);

void
insert_num_void(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_num_void(aTHX_ SP, obj,key,value);

void
delete_num_void(SV * obj, SV * key)
    PPCODE:
        SP = delete_num_void(aTHX_ SP, obj,key);


void
find_num_void(SV * obj, SV * key)
    PPCODE:
        SP = find_num_void(aTHX_ SP, obj,key);

void
find_lt_num_void(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_num_void(aTHX_ SP, obj,key);

void
find_le_num_void(SV * obj, SV * key)
    PPCODE:
        SP = find_le_num_void(aTHX_ SP, obj,key);

void
find_gt_num_void(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_num_void(aTHX_ SP, obj,key);

void
find_ge_num_void(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_num_void(aTHX_ SP, obj,key);


void
count_lt_num_void(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_num_void(aTHX_ SP, obj,key);

void
count_le_num_void(SV * obj, SV * key)
    PPCODE:
        SP = count_le_num_void(aTHX_ SP, obj,key);

void
count_gt_num_void(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_num_void(aTHX_ SP, obj,key);

void
count_ge_num_void(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_num_void(aTHX_ SP, obj,key);


void
find_min_num_void(SV * obj)
    PPCODE:
        SP = find_min_num_void(aTHX_ SP, obj);

void
find_max_num_void(SV * obj)
    PPCODE:
        SP = find_max_num_void(aTHX_ SP, obj);


void
skip_l_num_void(SV * obj, int offset)
    PPCODE:
        SP = skip_l_num_void(aTHX_ SP, obj,offset);

void
skip_g_num_void(SV * obj, int offset)
    PPCODE:
        SP = skip_g_num_void(aTHX_ SP, obj,offset);


void
dump_num_void(SV *obj)
    PPCODE:
        SP = dump_num_void(aTHX_ SP, obj);

void
check_num_void(SV * obj)
    PPCODE:
        SP = check_num_void(aTHX_ SP, obj);


void
new_num_int(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_num_int(aTHX_ SP, class,cmp);

void
DESTROY_num_int(SV * obj)
    PPCODE:
        SP = DESTROY_num_int(aTHX_ SP, obj);


void
size_num_int(SV *obj)
    PPCODE:
        SP = size_num_int(aTHX_ SP, obj);

void
insert_num_int(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_num_int(aTHX_ SP, obj,key,value);

void
delete_num_int(SV * obj, SV * key)
    PPCODE:
        SP = delete_num_int(aTHX_ SP, obj,key);


void
find_num_int(SV * obj, SV * key)
    PPCODE:
        SP = find_num_int(aTHX_ SP, obj,key);

void
find_lt_num_int(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_num_int(aTHX_ SP, obj,key);

void
find_le_num_int(SV * obj, SV * key)
    PPCODE:
        SP = find_le_num_int(aTHX_ SP, obj,key);

void
find_gt_num_int(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_num_int(aTHX_ SP, obj,key);

void
find_ge_num_int(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_num_int(aTHX_ SP, obj,key);


void
count_lt_num_int(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_num_int(aTHX_ SP, obj,key);

void
count_le_num_int(SV * obj, SV * key)
    PPCODE:
        SP = count_le_num_int(aTHX_ SP, obj,key);

void
count_gt_num_int(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_num_int(aTHX_ SP, obj,key);

void
count_ge_num_int(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_num_int(aTHX_ SP, obj,key);


void
find_min_num_int(SV * obj)
    PPCODE:
        SP = find_min_num_int(aTHX_ SP, obj);

void
find_max_num_int(SV * obj)
    PPCODE:
        SP = find_max_num_int(aTHX_ SP, obj);


void
skip_l_num_int(SV * obj, int offset)
    PPCODE:
        SP = skip_l_num_int(aTHX_ SP, obj,offset);

void
skip_g_num_int(SV * obj, int offset)
    PPCODE:
        SP = skip_g_num_int(aTHX_ SP, obj,offset);


void
dump_num_int(SV *obj)
    PPCODE:
        SP = dump_num_int(aTHX_ SP, obj);

void
check_num_int(SV * obj)
    PPCODE:
        SP = check_num_int(aTHX_ SP, obj);


void
new_num_num(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_num_num(aTHX_ SP, class,cmp);

void
DESTROY_num_num(SV * obj)
    PPCODE:
        SP = DESTROY_num_num(aTHX_ SP, obj);


void
size_num_num(SV *obj)
    PPCODE:
        SP = size_num_num(aTHX_ SP, obj);

void
insert_num_num(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_num_num(aTHX_ SP, obj,key,value);

void
delete_num_num(SV * obj, SV * key)
    PPCODE:
        SP = delete_num_num(aTHX_ SP, obj,key);


void
find_num_num(SV * obj, SV * key)
    PPCODE:
        SP = find_num_num(aTHX_ SP, obj,key);

void
find_lt_num_num(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_num_num(aTHX_ SP, obj,key);

void
find_le_num_num(SV * obj, SV * key)
    PPCODE:
        SP = find_le_num_num(aTHX_ SP, obj,key);

void
find_gt_num_num(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_num_num(aTHX_ SP, obj,key);

void
find_ge_num_num(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_num_num(aTHX_ SP, obj,key);


void
count_lt_num_num(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_num_num(aTHX_ SP, obj,key);

void
count_le_num_num(SV * obj, SV * key)
    PPCODE:
        SP = count_le_num_num(aTHX_ SP, obj,key);

void
count_gt_num_num(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_num_num(aTHX_ SP, obj,key);

void
count_ge_num_num(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_num_num(aTHX_ SP, obj,key);


void
find_min_num_num(SV * obj)
    PPCODE:
        SP = find_min_num_num(aTHX_ SP, obj);

void
find_max_num_num(SV * obj)
    PPCODE:
        SP = find_max_num_num(aTHX_ SP, obj);


void
skip_l_num_num(SV * obj, int offset)
    PPCODE:
        SP = skip_l_num_num(aTHX_ SP, obj,offset);

void
skip_g_num_num(SV * obj, int offset)
    PPCODE:
        SP = skip_g_num_num(aTHX_ SP, obj,offset);


void
dump_num_num(SV *obj)
    PPCODE:
        SP = dump_num_num(aTHX_ SP, obj);

void
check_num_num(SV * obj)
    PPCODE:
        SP = check_num_num(aTHX_ SP, obj);


void
new_num_any(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_num_any(aTHX_ SP, class,cmp);

void
DESTROY_num_any(SV * obj)
    PPCODE:
        SP = DESTROY_num_any(aTHX_ SP, obj);


void
size_num_any(SV *obj)
    PPCODE:
        SP = size_num_any(aTHX_ SP, obj);

void
insert_num_any(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_num_any(aTHX_ SP, obj,key,value);

void
delete_num_any(SV * obj, SV * key)
    PPCODE:
        SP = delete_num_any(aTHX_ SP, obj,key);


void
find_num_any(SV * obj, SV * key)
    PPCODE:
        SP = find_num_any(aTHX_ SP, obj,key);

void
find_lt_num_any(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_num_any(aTHX_ SP, obj,key);

void
find_le_num_any(SV * obj, SV * key)
    PPCODE:
        SP = find_le_num_any(aTHX_ SP, obj,key);

void
find_gt_num_any(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_num_any(aTHX_ SP, obj,key);

void
find_ge_num_any(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_num_any(aTHX_ SP, obj,key);


void
count_lt_num_any(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_num_any(aTHX_ SP, obj,key);

void
count_le_num_any(SV * obj, SV * key)
    PPCODE:
        SP = count_le_num_any(aTHX_ SP, obj,key);

void
count_gt_num_any(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_num_any(aTHX_ SP, obj,key);

void
count_ge_num_any(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_num_any(aTHX_ SP, obj,key);


void
find_min_num_any(SV * obj)
    PPCODE:
        SP = find_min_num_any(aTHX_ SP, obj);

void
find_max_num_any(SV * obj)
    PPCODE:
        SP = find_max_num_any(aTHX_ SP, obj);


void
skip_l_num_any(SV * obj, int offset)
    PPCODE:
        SP = skip_l_num_any(aTHX_ SP, obj,offset);

void
skip_g_num_any(SV * obj, int offset)
    PPCODE:
        SP = skip_g_num_any(aTHX_ SP, obj,offset);


void
dump_num_any(SV *obj)
    PPCODE:
        SP = dump_num_any(aTHX_ SP, obj);

void
check_num_any(SV * obj)
    PPCODE:
        SP = check_num_any(aTHX_ SP, obj);


void
new_str_void(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_str_void(aTHX_ SP, class,cmp);

void
DESTROY_str_void(SV * obj)
    PPCODE:
        SP = DESTROY_str_void(aTHX_ SP, obj);


void
size_str_void(SV *obj)
    PPCODE:
        SP = size_str_void(aTHX_ SP, obj);

void
insert_str_void(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_str_void(aTHX_ SP, obj,key,value);

void
delete_str_void(SV * obj, SV * key)
    PPCODE:
        SP = delete_str_void(aTHX_ SP, obj,key);


void
find_str_void(SV * obj, SV * key)
    PPCODE:
        SP = find_str_void(aTHX_ SP, obj,key);

void
find_lt_str_void(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_str_void(aTHX_ SP, obj,key);

void
find_le_str_void(SV * obj, SV * key)
    PPCODE:
        SP = find_le_str_void(aTHX_ SP, obj,key);

void
find_gt_str_void(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_str_void(aTHX_ SP, obj,key);

void
find_ge_str_void(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_str_void(aTHX_ SP, obj,key);


void
count_lt_str_void(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_str_void(aTHX_ SP, obj,key);

void
count_le_str_void(SV * obj, SV * key)
    PPCODE:
        SP = count_le_str_void(aTHX_ SP, obj,key);

void
count_gt_str_void(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_str_void(aTHX_ SP, obj,key);

void
count_ge_str_void(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_str_void(aTHX_ SP, obj,key);


void
find_min_str_void(SV * obj)
    PPCODE:
        SP = find_min_str_void(aTHX_ SP, obj);

void
find_max_str_void(SV * obj)
    PPCODE:
        SP = find_max_str_void(aTHX_ SP, obj);


void
skip_l_str_void(SV * obj, int offset)
    PPCODE:
        SP = skip_l_str_void(aTHX_ SP, obj,offset);

void
skip_g_str_void(SV * obj, int offset)
    PPCODE:
        SP = skip_g_str_void(aTHX_ SP, obj,offset);


void
dump_str_void(SV *obj)
    PPCODE:
        SP = dump_str_void(aTHX_ SP, obj);

void
check_str_void(SV * obj)
    PPCODE:
        SP = check_str_void(aTHX_ SP, obj);


void
new_str_int(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_str_int(aTHX_ SP, class,cmp);

void
DESTROY_str_int(SV * obj)
    PPCODE:
        SP = DESTROY_str_int(aTHX_ SP, obj);


void
size_str_int(SV *obj)
    PPCODE:
        SP = size_str_int(aTHX_ SP, obj);

void
insert_str_int(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_str_int(aTHX_ SP, obj,key,value);

void
delete_str_int(SV * obj, SV * key)
    PPCODE:
        SP = delete_str_int(aTHX_ SP, obj,key);


void
find_str_int(SV * obj, SV * key)
    PPCODE:
        SP = find_str_int(aTHX_ SP, obj,key);

void
find_lt_str_int(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_str_int(aTHX_ SP, obj,key);

void
find_le_str_int(SV * obj, SV * key)
    PPCODE:
        SP = find_le_str_int(aTHX_ SP, obj,key);

void
find_gt_str_int(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_str_int(aTHX_ SP, obj,key);

void
find_ge_str_int(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_str_int(aTHX_ SP, obj,key);


void
count_lt_str_int(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_str_int(aTHX_ SP, obj,key);

void
count_le_str_int(SV * obj, SV * key)
    PPCODE:
        SP = count_le_str_int(aTHX_ SP, obj,key);

void
count_gt_str_int(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_str_int(aTHX_ SP, obj,key);

void
count_ge_str_int(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_str_int(aTHX_ SP, obj,key);


void
find_min_str_int(SV * obj)
    PPCODE:
        SP = find_min_str_int(aTHX_ SP, obj);

void
find_max_str_int(SV * obj)
    PPCODE:
        SP = find_max_str_int(aTHX_ SP, obj);


void
skip_l_str_int(SV * obj, int offset)
    PPCODE:
        SP = skip_l_str_int(aTHX_ SP, obj,offset);

void
skip_g_str_int(SV * obj, int offset)
    PPCODE:
        SP = skip_g_str_int(aTHX_ SP, obj,offset);


void
dump_str_int(SV *obj)
    PPCODE:
        SP = dump_str_int(aTHX_ SP, obj);

void
check_str_int(SV * obj)
    PPCODE:
        SP = check_str_int(aTHX_ SP, obj);


void
new_str_num(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_str_num(aTHX_ SP, class,cmp);

void
DESTROY_str_num(SV * obj)
    PPCODE:
        SP = DESTROY_str_num(aTHX_ SP, obj);


void
size_str_num(SV *obj)
    PPCODE:
        SP = size_str_num(aTHX_ SP, obj);

void
insert_str_num(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_str_num(aTHX_ SP, obj,key,value);

void
delete_str_num(SV * obj, SV * key)
    PPCODE:
        SP = delete_str_num(aTHX_ SP, obj,key);


void
find_str_num(SV * obj, SV * key)
    PPCODE:
        SP = find_str_num(aTHX_ SP, obj,key);

void
find_lt_str_num(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_str_num(aTHX_ SP, obj,key);

void
find_le_str_num(SV * obj, SV * key)
    PPCODE:
        SP = find_le_str_num(aTHX_ SP, obj,key);

void
find_gt_str_num(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_str_num(aTHX_ SP, obj,key);

void
find_ge_str_num(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_str_num(aTHX_ SP, obj,key);


void
count_lt_str_num(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_str_num(aTHX_ SP, obj,key);

void
count_le_str_num(SV * obj, SV * key)
    PPCODE:
        SP = count_le_str_num(aTHX_ SP, obj,key);

void
count_gt_str_num(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_str_num(aTHX_ SP, obj,key);

void
count_ge_str_num(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_str_num(aTHX_ SP, obj,key);


void
find_min_str_num(SV * obj)
    PPCODE:
        SP = find_min_str_num(aTHX_ SP, obj);

void
find_max_str_num(SV * obj)
    PPCODE:
        SP = find_max_str_num(aTHX_ SP, obj);


void
skip_l_str_num(SV * obj, int offset)
    PPCODE:
        SP = skip_l_str_num(aTHX_ SP, obj,offset);

void
skip_g_str_num(SV * obj, int offset)
    PPCODE:
        SP = skip_g_str_num(aTHX_ SP, obj,offset);


void
dump_str_num(SV *obj)
    PPCODE:
        SP = dump_str_num(aTHX_ SP, obj);

void
check_str_num(SV * obj)
    PPCODE:
        SP = check_str_num(aTHX_ SP, obj);


void
new_str_any(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_str_any(aTHX_ SP, class,cmp);

void
DESTROY_str_any(SV * obj)
    PPCODE:
        SP = DESTROY_str_any(aTHX_ SP, obj);


void
size_str_any(SV *obj)
    PPCODE:
        SP = size_str_any(aTHX_ SP, obj);

void
insert_str_any(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_str_any(aTHX_ SP, obj,key,value);

void
delete_str_any(SV * obj, SV * key)
    PPCODE:
        SP = delete_str_any(aTHX_ SP, obj,key);


void
find_str_any(SV * obj, SV * key)
    PPCODE:
        SP = find_str_any(aTHX_ SP, obj,key);

void
find_lt_str_any(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_str_any(aTHX_ SP, obj,key);

void
find_le_str_any(SV * obj, SV * key)
    PPCODE:
        SP = find_le_str_any(aTHX_ SP, obj,key);

void
find_gt_str_any(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_str_any(aTHX_ SP, obj,key);

void
find_ge_str_any(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_str_any(aTHX_ SP, obj,key);


void
count_lt_str_any(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_str_any(aTHX_ SP, obj,key);

void
count_le_str_any(SV * obj, SV * key)
    PPCODE:
        SP = count_le_str_any(aTHX_ SP, obj,key);

void
count_gt_str_any(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_str_any(aTHX_ SP, obj,key);

void
count_ge_str_any(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_str_any(aTHX_ SP, obj,key);


void
find_min_str_any(SV * obj)
    PPCODE:
        SP = find_min_str_any(aTHX_ SP, obj);

void
find_max_str_any(SV * obj)
    PPCODE:
        SP = find_max_str_any(aTHX_ SP, obj);


void
skip_l_str_any(SV * obj, int offset)
    PPCODE:
        SP = skip_l_str_any(aTHX_ SP, obj,offset);

void
skip_g_str_any(SV * obj, int offset)
    PPCODE:
        SP = skip_g_str_any(aTHX_ SP, obj,offset);


void
dump_str_any(SV *obj)
    PPCODE:
        SP = dump_str_any(aTHX_ SP, obj);

void
check_str_any(SV * obj)
    PPCODE:
        SP = check_str_any(aTHX_ SP, obj);


void
new_any_void(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_any_void(aTHX_ SP, class,cmp);

void
DESTROY_any_void(SV * obj)
    PPCODE:
        SP = DESTROY_any_void(aTHX_ SP, obj);


void
size_any_void(SV *obj)
    PPCODE:
        SP = size_any_void(aTHX_ SP, obj);

void
insert_any_void(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_any_void(aTHX_ SP, obj,key,value);

void
delete_any_void(SV * obj, SV * key)
    PPCODE:
        SP = delete_any_void(aTHX_ SP, obj,key);


void
find_any_void(SV * obj, SV * key)
    PPCODE:
        SP = find_any_void(aTHX_ SP, obj,key);

void
find_lt_any_void(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_any_void(aTHX_ SP, obj,key);

void
find_le_any_void(SV * obj, SV * key)
    PPCODE:
        SP = find_le_any_void(aTHX_ SP, obj,key);

void
find_gt_any_void(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_any_void(aTHX_ SP, obj,key);

void
find_ge_any_void(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_any_void(aTHX_ SP, obj,key);


void
count_lt_any_void(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_any_void(aTHX_ SP, obj,key);

void
count_le_any_void(SV * obj, SV * key)
    PPCODE:
        SP = count_le_any_void(aTHX_ SP, obj,key);

void
count_gt_any_void(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_any_void(aTHX_ SP, obj,key);

void
count_ge_any_void(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_any_void(aTHX_ SP, obj,key);


void
find_min_any_void(SV * obj)
    PPCODE:
        SP = find_min_any_void(aTHX_ SP, obj);

void
find_max_any_void(SV * obj)
    PPCODE:
        SP = find_max_any_void(aTHX_ SP, obj);


void
skip_l_any_void(SV * obj, int offset)
    PPCODE:
        SP = skip_l_any_void(aTHX_ SP, obj,offset);

void
skip_g_any_void(SV * obj, int offset)
    PPCODE:
        SP = skip_g_any_void(aTHX_ SP, obj,offset);


void
dump_any_void(SV *obj)
    PPCODE:
        SP = dump_any_void(aTHX_ SP, obj);

void
check_any_void(SV * obj)
    PPCODE:
        SP = check_any_void(aTHX_ SP, obj);


void
new_any_int(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_any_int(aTHX_ SP, class,cmp);

void
DESTROY_any_int(SV * obj)
    PPCODE:
        SP = DESTROY_any_int(aTHX_ SP, obj);


void
size_any_int(SV *obj)
    PPCODE:
        SP = size_any_int(aTHX_ SP, obj);

void
insert_any_int(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_any_int(aTHX_ SP, obj,key,value);

void
delete_any_int(SV * obj, SV * key)
    PPCODE:
        SP = delete_any_int(aTHX_ SP, obj,key);


void
find_any_int(SV * obj, SV * key)
    PPCODE:
        SP = find_any_int(aTHX_ SP, obj,key);

void
find_lt_any_int(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_any_int(aTHX_ SP, obj,key);

void
find_le_any_int(SV * obj, SV * key)
    PPCODE:
        SP = find_le_any_int(aTHX_ SP, obj,key);

void
find_gt_any_int(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_any_int(aTHX_ SP, obj,key);

void
find_ge_any_int(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_any_int(aTHX_ SP, obj,key);


void
count_lt_any_int(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_any_int(aTHX_ SP, obj,key);

void
count_le_any_int(SV * obj, SV * key)
    PPCODE:
        SP = count_le_any_int(aTHX_ SP, obj,key);

void
count_gt_any_int(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_any_int(aTHX_ SP, obj,key);

void
count_ge_any_int(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_any_int(aTHX_ SP, obj,key);


void
find_min_any_int(SV * obj)
    PPCODE:
        SP = find_min_any_int(aTHX_ SP, obj);

void
find_max_any_int(SV * obj)
    PPCODE:
        SP = find_max_any_int(aTHX_ SP, obj);


void
skip_l_any_int(SV * obj, int offset)
    PPCODE:
        SP = skip_l_any_int(aTHX_ SP, obj,offset);

void
skip_g_any_int(SV * obj, int offset)
    PPCODE:
        SP = skip_g_any_int(aTHX_ SP, obj,offset);


void
dump_any_int(SV *obj)
    PPCODE:
        SP = dump_any_int(aTHX_ SP, obj);

void
check_any_int(SV * obj)
    PPCODE:
        SP = check_any_int(aTHX_ SP, obj);


void
new_any_num(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_any_num(aTHX_ SP, class,cmp);

void
DESTROY_any_num(SV * obj)
    PPCODE:
        SP = DESTROY_any_num(aTHX_ SP, obj);


void
size_any_num(SV *obj)
    PPCODE:
        SP = size_any_num(aTHX_ SP, obj);

void
insert_any_num(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_any_num(aTHX_ SP, obj,key,value);

void
delete_any_num(SV * obj, SV * key)
    PPCODE:
        SP = delete_any_num(aTHX_ SP, obj,key);


void
find_any_num(SV * obj, SV * key)
    PPCODE:
        SP = find_any_num(aTHX_ SP, obj,key);

void
find_lt_any_num(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_any_num(aTHX_ SP, obj,key);

void
find_le_any_num(SV * obj, SV * key)
    PPCODE:
        SP = find_le_any_num(aTHX_ SP, obj,key);

void
find_gt_any_num(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_any_num(aTHX_ SP, obj,key);

void
find_ge_any_num(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_any_num(aTHX_ SP, obj,key);


void
count_lt_any_num(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_any_num(aTHX_ SP, obj,key);

void
count_le_any_num(SV * obj, SV * key)
    PPCODE:
        SP = count_le_any_num(aTHX_ SP, obj,key);

void
count_gt_any_num(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_any_num(aTHX_ SP, obj,key);

void
count_ge_any_num(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_any_num(aTHX_ SP, obj,key);


void
find_min_any_num(SV * obj)
    PPCODE:
        SP = find_min_any_num(aTHX_ SP, obj);

void
find_max_any_num(SV * obj)
    PPCODE:
        SP = find_max_any_num(aTHX_ SP, obj);


void
skip_l_any_num(SV * obj, int offset)
    PPCODE:
        SP = skip_l_any_num(aTHX_ SP, obj,offset);

void
skip_g_any_num(SV * obj, int offset)
    PPCODE:
        SP = skip_g_any_num(aTHX_ SP, obj,offset);


void
dump_any_num(SV *obj)
    PPCODE:
        SP = dump_any_num(aTHX_ SP, obj);

void
check_any_num(SV * obj)
    PPCODE:
        SP = check_any_num(aTHX_ SP, obj);


void
new_any_any(SV * class, SV * cmp = &PL_sv_undef)
    PPCODE:
        SP = new_any_any(aTHX_ SP, class,cmp);

void
DESTROY_any_any(SV * obj)
    PPCODE:
        SP = DESTROY_any_any(aTHX_ SP, obj);


void
size_any_any(SV *obj)
    PPCODE:
        SP = size_any_any(aTHX_ SP, obj);

void
insert_any_any(SV * obj, SV * key, SV * value = &PL_sv_undef)
    PPCODE:
        SP = insert_any_any(aTHX_ SP, obj,key,value);

void
delete_any_any(SV * obj, SV * key)
    PPCODE:
        SP = delete_any_any(aTHX_ SP, obj,key);


void
find_any_any(SV * obj, SV * key)
    PPCODE:
        SP = find_any_any(aTHX_ SP, obj,key);

void
find_lt_any_any(SV * obj, SV * key)
    PPCODE:
        SP = find_lt_any_any(aTHX_ SP, obj,key);

void
find_le_any_any(SV * obj, SV * key)
    PPCODE:
        SP = find_le_any_any(aTHX_ SP, obj,key);

void
find_gt_any_any(SV * obj, SV * key)
    PPCODE:
        SP = find_gt_any_any(aTHX_ SP, obj,key);

void
find_ge_any_any(SV * obj, SV * key)
    PPCODE:
        SP = find_ge_any_any(aTHX_ SP, obj,key);


void
count_lt_any_any(SV * obj, SV * key)
    PPCODE:
        SP = count_lt_any_any(aTHX_ SP, obj,key);

void
count_le_any_any(SV * obj, SV * key)
    PPCODE:
        SP = count_le_any_any(aTHX_ SP, obj,key);

void
count_gt_any_any(SV * obj, SV * key)
    PPCODE:
        SP = count_gt_any_any(aTHX_ SP, obj,key);

void
count_ge_any_any(SV * obj, SV * key)
    PPCODE:
        SP = count_ge_any_any(aTHX_ SP, obj,key);


void
find_min_any_any(SV * obj)
    PPCODE:
        SP = find_min_any_any(aTHX_ SP, obj);

void
find_max_any_any(SV * obj)
    PPCODE:
        SP = find_max_any_any(aTHX_ SP, obj);


void
skip_l_any_any(SV * obj, int offset)
    PPCODE:
        SP = skip_l_any_any(aTHX_ SP, obj,offset);

void
skip_g_any_any(SV * obj, int offset)
    PPCODE:
        SP = skip_g_any_any(aTHX_ SP, obj,offset);


void
dump_any_any(SV *obj)
    PPCODE:
        SP = dump_any_any(aTHX_ SP, obj);

void
check_any_any(SV * obj)
    PPCODE:
        SP = check_any_any(aTHX_ SP, obj);

