## $Id: /mirror/trunk/languages/perl6/src/classes/Bool.pir 27676 2008-05-20T16:25:15.520855Z particle  $

=head1 TITLE

Bool - Perl 6 boolean class

=head1 DESCRIPTION

This file sets up the Perl 6 C<Bool> class, and initializes
symbols for C<Bool::True> and C<Bool::False>.

=cut

.namespace ['Bool']

.sub 'onload' :anon :init :load
    .local pmc protoobject
    $P0 = subclass 'Boolean', 'Bool'
    $P1 = get_hll_global 'Any'
    $P1 = $P1.HOW()
    addparent $P0, $P1
    $P1 = get_hll_global ['Perl6Object'], 'make_proto'
    protoobject = $P1($P0, 'Bool')

    $P0 = protoobject.'new'()
    $P0 = 0
    set_hll_global [ 'Bool' ], 'False', $P0
    set_hll_global 'False', $P0 # TODO remove when we can do 'our bit enum'

    $P0 = protoobject.'new'()
    $P0 = 1
    set_hll_global [ 'Bool' ], 'True', $P0
    set_hll_global 'True', $P0  # TODO remove when we can do 'our bit enum'
.end


.sub 'ACCEPTS' :method
    .param pmc topic
    .return (self)
.end

.sub 'increment' :method :vtable
    self = 1
.end

.sub 'decrement' :method :vtable
    self = 0
.end

# Local Variables:
#   mode: pir
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4 ft=pir:
