package HTML::Dojo::editions;
1;
__DATA__
__CPAN_EDITION__ ajax dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:2,flag:"",revision:Number("$Rev: 7616 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
function dj_load_init(e){
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_f4,_f5){
var out="";
for(var i=0;i<_f4;i++){
out+=str;
if(_f5&&i<_f4-1){
out+=_f5;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_103,_104){
if(!dojo.lang.isFunction(_104)){
dojo.raise("dojo.inherits: superclass argument ["+_104+"] must be a function (subclass: ["+_103+"']");
}
_103.prototype=new _104();
_103.prototype.constructor=_103;
_103.superclass=_104.prototype;
_103["super"]=_104.prototype;
};
dojo.lang._mixin=function(obj,_106){
var tobj={};
for(var x in _106){
if((typeof tobj[x]=="undefined")||(tobj[x]!=_106[x])){
obj[x]=_106[x];
}
}
if(dojo.render.html.ie&&(typeof (_106["toString"])=="function")&&(_106["toString"]!=obj["toString"])&&(_106["toString"]!=tobj["toString"])){
obj.toString=_106.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_10a){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_10d,_10e){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_10d.prototype,arguments[i]);
}
return _10d;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_111,_112,_113,_114){
if(!dojo.lang.isArrayLike(_111)&&dojo.lang.isArrayLike(_112)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_111;
_111=_112;
_112=temp;
}
var _116=dojo.lang.isString(_111);
if(_116){
_111=_111.split("");
}
if(_114){
var step=-1;
var i=_111.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_111.length;
}
if(_113){
while(i!=end){
if(_111[i]===_112){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_111[i]==_112){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_11a,_11b,_11c){
return dojo.lang.find(_11a,_11b,_11c,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_11d,_11e){
return dojo.lang.find(_11d,_11e)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_12a){
var _12b=window,_12c=2;
if(!dojo.lang.isFunction(func)){
_12b=func;
func=_12a;
_12a=arguments[2];
_12c++;
}
if(dojo.lang.isString(func)){
func=_12b[func];
}
var args=[];
for(var i=_12c;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_12b,args);
},_12a);
};
dojo.lang.clearTimeout=function(_12f){
dojo.global().clearTimeout(_12f);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_138,_139,_13a){
with(dojo.parseObjPath(_138,_139,_13a)){
return dojo.evalProp(prop,obj,_13a);
}
};
dojo.lang.setObjPathValue=function(_13b,_13c,_13d,_13e){
dojo.deprecated("dojo.lang.setObjPathValue","use dojo.parseObjPath and the '=' operator","0.6");
if(arguments.length<4){
_13e=true;
}
with(dojo.parseObjPath(_13b,_13d,_13e)){
if(obj&&(_13e||(prop in obj))){
obj[prop]=_13c;
}
}
};
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_140,_141,_142){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_140){
this.mimetype=_140;
}
if(_141){
this.transport=_141;
}
if(arguments.length>=4){
this.changeUrl=_142;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,load:function(type,data,_145,_146){
},error:function(type,_148,_149,_14a){
},timeout:function(type,_14c,_14d,_14e){
},handle:function(type,data,_151,_152){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_153){
if(_153["url"]){
_153.url=_153.url.toString();
}
if(_153["formNode"]){
_153.formNode=dojo.byId(_153.formNode);
}
if(!_153["method"]&&_153["formNode"]&&_153["formNode"].method){
_153.method=_153["formNode"].method;
}
if(!_153["handle"]&&_153["handler"]){
_153.handle=_153.handler;
}
if(!_153["load"]&&_153["loaded"]){
_153.load=_153.loaded;
}
if(!_153["changeUrl"]&&_153["changeURL"]){
_153.changeUrl=_153.changeURL;
}
_153.encoding=dojo.lang.firstValued(_153["encoding"],djConfig["bindEncoding"],"");
_153.sendTransport=dojo.lang.firstValued(_153["sendTransport"],djConfig["ioSendTransport"],false);
var _154=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_153[fn]&&_154(_153[fn])){
continue;
}
if(_153["handle"]&&_154(_153["handle"])){
_153[fn]=_153.handle;
}
}
dojo.lang.mixin(this,_153);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_15b){
if(!(_15b instanceof dojo.io.Request)){
try{
_15b=new dojo.io.Request(_15b);
}
catch(e){
dojo.debug(e);
}
}
var _15c="";
if(_15b["transport"]){
_15c=_15b["transport"];
if(!this[_15c]){
dojo.io.sendBindError(_15b,"No dojo.io.bind() transport with name '"+_15b["transport"]+"'.");
return _15b;
}
if(!this[_15c].canHandle(_15b)){
dojo.io.sendBindError(_15b,"dojo.io.bind() transport with name '"+_15b["transport"]+"' cannot handle this type of request.");
return _15b;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_15b))){
_15c=tmp;
break;
}
}
if(_15c==""){
dojo.io.sendBindError(_15b,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _15b;
}
}
this[_15c].bind(_15b);
_15b.bindSuccess=true;
return _15b;
};
dojo.io.sendBindError=function(_15f,_160){
if((typeof _15f.error=="function"||typeof _15f.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _161=new dojo.io.Error(_160);
setTimeout(function(){
_15f[(typeof _15f.error=="function")?"error":"handle"]("error",_161,null,_15f);
},50);
}else{
dojo.raise(_160);
}
};
dojo.io.queueBind=function(_162){
if(!(_162 instanceof dojo.io.Request)){
try{
_162=new dojo.io.Request(_162);
}
catch(e){
dojo.debug(e);
}
}
var _163=_162.load;
_162.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_163.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _165=_162.error;
_162.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_165.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_162);
dojo.io._dispatchNextQueueBind();
return _162;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_168,last){
var enc=/utf/i.test(_168||"")?encodeURIComponent:dojo.string.encodeAscii;
var _16b=[];
var _16c=new Object();
for(var name in map){
var _16e=function(elt){
var val=enc(name)+"="+enc(elt);
_16b[(last==name)?"push":"unshift"](val);
};
if(!_16c[name]){
var _171=map[name];
if(dojo.lang.isArray(_171)){
dojo.lang.forEach(_171,_16e);
}else{
_16e(_171);
}
}
}
return _16b.join("&");
};
dojo.io.setIFrameSrc=function(_172,src,_174){
try{
var r=dojo.render.html;
if(!_174){
if(r.safari){
_172.location=src;
}else{
frames[_172.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_172.contentWindow.document;
}else{
if(r.safari){
idoc=_172.document;
}else{
idoc=_172.contentWindow;
}
}
if(!idoc){
_172.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _17b=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_17b++;
break;
}
}
return _17b==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
},map:function(arr,obj,_17f){
var _180=dojo.lang.isString(arr);
if(_180){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_17f)){
_17f=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_17f){
var _181=obj;
obj=_17f;
_17f=_181;
}
}
if(Array.map){
var _182=Array.map(arr,_17f,obj);
}else{
var _182=[];
for(var i=0;i<arr.length;++i){
_182.push(_17f.call(obj,arr[i]));
}
}
if(_180){
return _182.join("");
}else{
return _182;
}
},reduce:function(arr,_185,obj,_187){
var _188=_185;
if(arguments.length==2){
_187=_185;
_188=arr[0];
arr=arr.slice(1);
}else{
if(arguments.length==3){
if(dojo.lang.isFunction(obj)){
_187=obj;
obj=null;
}
}else{
if(dojo.lang.isFunction(obj)){
var tmp=_187;
_187=obj;
obj=tmp;
}
}
}
var ob=obj||dj_global;
dojo.lang.map(arr,function(val){
_188=_187.call(ob,_188,val);
});
return _188;
},forEach:function(_18c,_18d,_18e){
if(dojo.lang.isString(_18c)){
_18c=_18c.split("");
}
if(Array.forEach){
Array.forEach(_18c,_18d,_18e);
}else{
if(!_18e){
_18e=dj_global;
}
for(var i=0,l=_18c.length;i<l;i++){
_18d.call(_18e,_18c[i],i,_18c);
}
}
},_everyOrSome:function(_191,arr,_193,_194){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_191?"every":"some"](arr,_193,_194);
}else{
if(!_194){
_194=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _197=_193.call(_194,arr[i],i,arr);
if(_191&&!_197){
return false;
}else{
if((!_191)&&(_197)){
return true;
}
}
}
return Boolean(_191);
}
},every:function(arr,_199,_19a){
return this._everyOrSome(true,arr,_199,_19a);
},some:function(arr,_19c,_19d){
return this._everyOrSome(false,arr,_19c,_19d);
},filter:function(arr,_19f,_1a0){
var _1a1=dojo.lang.isString(arr);
if(_1a1){
arr=arr.split("");
}
var _1a2;
if(Array.filter){
_1a2=Array.filter(arr,_19f,_1a0);
}else{
if(!_1a0){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_1a0=dj_global;
}
_1a2=[];
for(var i=0;i<arr.length;i++){
if(_19f.call(_1a0,arr[i],i,arr)){
_1a2.push(arr[i]);
}
}
}
if(_1a1){
return _1a2.join("");
}else{
return _1a2;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_1a7,_1a8){
var _1a9=[];
for(var i=_1a8||0;i<_1a7.length;i++){
_1a9.push(_1a7[i]);
}
return _1a9;
}});
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_1ab,_1ac){
var fcn=(dojo.lang.isString(_1ac)?_1ab[_1ac]:_1ac)||function(){
};
return function(){
return fcn.apply(_1ab,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_1ae,_1af,_1b0){
var nso=(_1af||dojo.lang.anon);
if((_1b0)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_1ae){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_1ae;
return ret;
};
dojo.lang.forward=function(_1b4){
return function(){
return this[_1b4].apply(this,arguments);
};
};
dojo.lang.curry=function(_1b5,func){
var _1b7=[];
_1b5=_1b5||dj_global;
if(dojo.lang.isString(func)){
func=_1b5[func];
}
for(var x=2;x<arguments.length;x++){
_1b7.push(arguments[x]);
}
var _1b9=(func["__preJoinArity"]||func.length)-_1b7.length;
function gather(_1ba,_1bb,_1bc){
var _1bd=_1bc;
var _1be=_1bb.slice(0);
for(var x=0;x<_1ba.length;x++){
_1be.push(_1ba[x]);
}
_1bc=_1bc-_1ba.length;
if(_1bc<=0){
var res=func.apply(_1b5,_1be);
_1bc=_1bd;
return res;
}else{
return function(){
return gather(arguments,_1be,_1bc);
};
}
}
return gather([],_1b7,_1b9);
};
dojo.lang.curryArguments=function(_1c1,func,args,_1c4){
var _1c5=[];
var x=_1c4||0;
for(x=_1c4;x<args.length;x++){
_1c5.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_1c1,func].concat(_1c5));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_1cb,_1cc){
if(!farr.length){
if(typeof _1cc=="function"){
_1cc();
}
return;
}
if((typeof _1cb=="undefined")&&(typeof cb=="number")){
_1cb=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_1cb){
_1cb=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_1cb,_1cc);
},_1cb);
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_1cd,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _1cd.replace(/\%\{(\w+)\}/g,function(_1d0,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _1d3=str.split(" ");
for(var i=0;i<_1d3.length;i++){
_1d3[i]=_1d3[i].charAt(0).toUpperCase()+_1d3[i].substring(1);
}
return _1d3.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _1d8=escape(str);
var _1d9,re=/%u([0-9A-F]{4})/i;
while((_1d9=_1d8.match(re))){
var num=Number("0x"+_1d9[1]);
var _1dc=escape("&#"+num+";");
ret+=_1d8.substring(0,_1d9.index)+_1dc;
_1d8=_1d8.substring(_1d9.index+_1d9[0].length);
}
ret+=_1d8.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_1e1){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_1e1){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_1ea){
if(_1ea){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_1ee,_1ef){
if(_1ef){
str=str.toLowerCase();
_1ee=_1ee.toLowerCase();
}
return str.indexOf(_1ee)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_1f5){
if(_1f5=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_1f5=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_1f7){
var _1f8=[];
for(var i=0,_1fa=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_1f7){
_1f8.push(str.substring(_1fa,i));
_1fa=i+1;
}
}
_1f8.push(str.substr(_1fa));
return _1f8;
};
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _1fc=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_1fc.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_1fe,_1ff){
var node=_1fe.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_1ff&&node&&node.tagName&&node.tagName.toLowerCase()!=_1ff.toLowerCase()){
node=dojo.dom.nextElement(node,_1ff);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_201,_202){
var node=_201.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_202&&node&&node.tagName&&node.tagName.toLowerCase()!=_202.toLowerCase()){
node=dojo.dom.prevElement(node,_202);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_205){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_205&&_205.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_205);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_207){
if(!node){
return null;
}
if(_207){
_207=_207.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_207&&_207.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_207);
}
return node;
};
dojo.dom.moveChildren=function(_208,_209,trim){
var _20b=0;
if(trim){
while(_208.hasChildNodes()&&_208.firstChild.nodeType==dojo.dom.TEXT_NODE){
_208.removeChild(_208.firstChild);
}
while(_208.hasChildNodes()&&_208.lastChild.nodeType==dojo.dom.TEXT_NODE){
_208.removeChild(_208.lastChild);
}
}
while(_208.hasChildNodes()){
_209.appendChild(_208.firstChild);
_20b++;
}
return _20b;
};
dojo.dom.copyChildren=function(_20c,_20d,trim){
var _20f=_20c.cloneNode(true);
return this.moveChildren(_20f,_20d,trim);
};
dojo.dom.replaceChildren=function(node,_211){
var _212=[];
if(dojo.render.html.ie){
for(var i=0;i<node.childNodes.length;i++){
_212.push(node.childNodes[i]);
}
}
dojo.dom.removeChildren(node);
node.appendChild(_211);
for(var i=0;i<_212.length;i++){
dojo.dom.destroyNode(_212[i]);
}
};
dojo.dom.removeChildren=function(node){
var _215=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _215;
};
dojo.dom.replaceNode=function(node,_217){
return node.parentNode.replaceChild(_217,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.evalObjPath("dojo.event.browser.clean",false)){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_21b,_21c){
var _21d=[];
var _21e=(_21b&&(_21b instanceof Function||typeof _21b=="function"));
while(node){
if(!_21e||_21b(node)){
_21d.push(node);
}
if(_21c&&_21d.length>0){
return _21d[0];
}
node=node.parentNode;
}
if(_21c){
return null;
}
return _21d;
};
dojo.dom.getAncestorsByTag=function(node,tag,_221){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_221);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_226,_227){
if(_227&&node){
node=node.parentNode;
}
while(node){
if(node==_226){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _22a=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _22b=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_22b.length;i++){
try{
doc=new ActiveXObject(_22b[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_22a.implementation)&&(_22a.implementation.createDocument)){
doc=_22a.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_22e){
if(!_22e){
_22e="text/xml";
}
if(!dj_undef("DOMParser")){
var _22f=new DOMParser();
return _22f.parseFromString(str,_22e);
}else{
if(!dj_undef("ActiveXObject")){
var _230=dojo.dom.createDocument();
if(_230){
_230.async=false;
_230.loadXML(str);
return _230;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _231=dojo.doc();
if(_231.createElement){
var tmp=_231.createElement("xml");
tmp.innerHTML=str;
if(_231.implementation&&_231.implementation.createDocument){
var _233=_231.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_233.importNode(tmp.childNodes.item(i),true);
}
return _233;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_236){
if(_236.firstChild){
_236.insertBefore(node,_236.firstChild);
}else{
_236.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_239){
if((_239!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _23a=ref.parentNode;
_23a.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_23d){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_23d!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_23d);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_241){
if((!node)||(!ref)||(!_241)){
return false;
}
switch(_241.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_243,_244){
var _245=_243.childNodes;
if(!_245.length||_245.length==_244){
_243.appendChild(node);
return true;
}
if(_244==0){
return dojo.dom.prependChild(node,_243);
}
return dojo.dom.insertAfter(node,_245[_244-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _248=dojo.doc();
dojo.dom.replaceChildren(node,_248.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _249="";
if(node==null){
return _249;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_249+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_249+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _249;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_24f,_250,_251){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_24f,_250,_251);
}else{
var _252=elem.ownerDocument;
var _253=_252.createNode(2,_250,_24f);
_253.nodeValue=_251;
elem.setAttributeNode(_253);
}
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:(!dj_undef("window"))?window.location.href:"",initialHash:(!dj_undef("window"))?window.location.hash:"",moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
if(djConfig["useXDomain"]&&!djConfig["dojoIframeHistoryUrl"]){
dojo.debug("dojo.undo.browser: When using cross-domain Dojo builds,"+" please save iframe_history.html to your domain and set djConfig.dojoIframeHistoryUrl"+" to the path on your domain to iframe_history.html");
}
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _258=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_25a){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_258.apply(this,[_25a]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _25b=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_25d){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_25b){
_25b.apply(this,[_25d]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_260){
if(!dojo.render.html.opera){
var _261=this._getUrlQuery(_260.href);
if(_261==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_261==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_261==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _262=this.historyStack.pop();
if(!_262){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_262);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _269=url.split("?");
if(_269.length<2){
return null;
}else{
return _269[1];
}
},_loadIframeHistory:function(){
var url=(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
if(!dj_undef("window")){
dojo.io.checkChildrenForFile=function(node){
var _26c=false;
var _26d=node.getElementsByTagName("input");
dojo.lang.forEach(_26d,function(_26e){
if(_26c){
return;
}
if(_26e.getAttribute("type")=="file"){
_26c=true;
}
});
return _26c;
};
dojo.io.formHasFile=function(_26f){
return dojo.io.checkChildrenForFile(_26f);
};
dojo.io.updateNode=function(node,_271){
node=dojo.byId(node);
var args=_271;
if(dojo.lang.isString(_271)){
args={url:_271};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
dojo.dom.destroyNode(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_278,_279,_27a){
if((!_278)||(!_278.tagName)||(!_278.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_27a){
_27a=dojo.io.formFilter;
}
var enc=/utf/i.test(_279||"")?encodeURIComponent:dojo.string.encodeAscii;
var _27c=[];
for(var i=0;i<_278.elements.length;i++){
var elm=_278.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_27a(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_27c.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_27c.push(name+"="+enc(elm.value));
}
}else{
_27c.push(name+"="+enc(elm.value));
}
}
}
var _282=_278.getElementsByTagName("input");
for(var i=0;i<_282.length;i++){
var _283=_282[i];
if(_283.type.toLowerCase()=="image"&&_283.form==_278&&_27a(_283)){
var name=enc(_283.name);
_27c.push(name+"="+enc(_283.value));
_27c.push(name+".x=0");
_27c.push(name+".y=0");
}
}
return _27c.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _289=form.getElementsByTagName("input");
for(var i=0;i<_289.length;i++){
var _28a=_289[i];
if(_28a.type.toLowerCase()=="image"&&_28a.form==form){
this.connect(_28a,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _291=false;
if(node.disabled||!node.name){
_291=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_291=node==this.clickedButton;
}else{
_291=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _291;
},connect:function(_292,_293,_294){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_292,_293,this,_294);
}else{
var fcn=dojo.lang.hitch(this,_294);
_292[_293]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _297=this;
var _298={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_29a,_29b){
return url+"|"+_29a+"|"+_29b.toLowerCase();
}
function addToCache(url,_29d,_29e,http){
_298[getCacheKey(url,_29d,_29e)]=http;
}
function getFromCache(url,_2a1,_2a2){
return _298[getCacheKey(url,_2a1,_2a2)];
}
this.clearCache=function(){
_298={};
};
function doLoad(_2a3,http,url,_2a6,_2a7){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_2a3.method.toLowerCase()=="head"){
var _2a9=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _2a9;
};
var _2aa=_2a9.split(/[\r\n]+/g);
for(var i=0;i<_2aa.length;i++){
var pair=_2aa[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_2a3.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_2a3.mimetype=="text/json"||_2a3.mimetype=="application/json"){
try{
ret=dj_eval("("+http.responseText+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_2a3.mimetype=="application/xml")||(_2a3.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_2a7){
addToCache(url,_2a6,_2a3.method,http);
}
_2a3[(typeof _2a3.load=="function")?"load":"handle"]("load",ret,http,_2a3);
}else{
var _2ad=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_2a3[(typeof _2a3.error=="function")?"error":"handle"]("error",_2ad,http,_2a3);
}
}
function setHeaders(http,_2af){
if(_2af["headers"]){
for(var _2b0 in _2af["headers"]){
if(_2b0.toLowerCase()=="content-type"&&!_2af["contentType"]){
_2af["contentType"]=_2af["headers"][_2b0];
}else{
http.setRequestHeader(_2b0,_2af["headers"][_2b0]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_297._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _2b4=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_2b4,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _2b5=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_2b6){
return _2b5&&dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript","text/json","application/json"],(_2b6["mimetype"].toLowerCase()||""))&&!(_2b6["formNode"]&&dojo.io.formHasFile(_2b6["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_2b7){
if(!_2b7["url"]){
if(!_2b7["formNode"]&&(_2b7["backButton"]||_2b7["back"]||_2b7["changeUrl"]||_2b7["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_2b7);
return true;
}
}
var url=_2b7.url;
var _2b9="";
if(_2b7["formNode"]){
var ta=_2b7.formNode.getAttribute("action");
if((ta)&&(!_2b7["url"])){
url=ta;
}
var tp=_2b7.formNode.getAttribute("method");
if((tp)&&(!_2b7["method"])){
_2b7.method=tp;
}
_2b9+=dojo.io.encodeForm(_2b7.formNode,_2b7.encoding,_2b7["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_2b7["file"]){
_2b7.method="post";
}
if(!_2b7["method"]){
_2b7.method="get";
}
if(_2b7.method.toLowerCase()=="get"){
_2b7.multipart=false;
}else{
if(_2b7["file"]){
_2b7.multipart=true;
}else{
if(!_2b7["multipart"]){
_2b7.multipart=false;
}
}
}
if(_2b7["backButton"]||_2b7["back"]||_2b7["changeUrl"]){
dojo.undo.browser.addToHistory(_2b7);
}
var _2bc=_2b7["content"]||{};
if(_2b7.sendTransport){
_2bc["dojo.transport"]="xmlhttp";
}
do{
if(_2b7.postContent){
_2b9=_2b7.postContent;
break;
}
if(_2bc){
_2b9+=dojo.io.argsFromMap(_2bc,_2b7.encoding);
}
if(_2b7.method.toLowerCase()=="get"||!_2b7.multipart){
break;
}
var t=[];
if(_2b9.length){
var q=_2b9.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_2b7.file){
if(dojo.lang.isArray(_2b7.file)){
for(var i=0;i<_2b7.file.length;++i){
var o=_2b7.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_2b7.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_2b9=t.join("\r\n");
}
}while(false);
var _2c2=_2b7["sync"]?false:true;
var _2c3=_2b7["preventCache"]||(this.preventCache==true&&_2b7["preventCache"]!=false);
var _2c4=_2b7["useCache"]==true||(this.useCache==true&&_2b7["useCache"]!=false);
if(!_2c3&&_2c4){
var _2c5=getFromCache(url,_2b9,_2b7.method);
if(_2c5){
doLoad(_2b7,_2c5,url,_2b9,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_2b7);
var _2c7=false;
if(_2c2){
var _2c8=this.inFlight.push({"req":_2b7,"http":http,"url":url,"query":_2b9,"useCache":_2c4,"startTime":_2b7.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_297._blockAsync=true;
}
if(_2b7.method.toLowerCase()=="post"){
if(!_2b7.user){
http.open("POST",url,_2c2);
}else{
http.open("POST",url,_2c2,_2b7.user,_2b7.password);
}
setHeaders(http,_2b7);
http.setRequestHeader("Content-Type",_2b7.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_2b7.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_2b9);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2b7,{status:404},url,_2b9,_2c4);
}
}else{
var _2c9=url;
if(_2b9!=""){
_2c9+=(_2c9.indexOf("?")>-1?"&":"?")+_2b9;
}
if(_2c3){
_2c9+=(dojo.string.endsWithAny(_2c9,"?","&")?"":(_2c9.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_2b7.user){
http.open(_2b7.method.toUpperCase(),_2c9,_2c2);
}else{
http.open(_2b7.method.toUpperCase(),_2c9,_2c2,_2b7.user,_2b7.password);
}
setHeaders(http,_2b7);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2b7,{status:404},url,_2b9,_2c4);
}
}
if(!_2c2){
doLoad(_2b7,http,url,_2b9,_2c4);
_297._blockAsync=false;
}
_2b7.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
}
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_2cb,days,path,_2ce,_2cf){
var _2d0=-1;
if((typeof days=="number")&&(days>=0)){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_2d0=d.toGMTString();
}
_2cb=escape(_2cb);
document.cookie=name+"="+_2cb+";"+(_2d0!=-1?" expires="+_2d0+";":"")+(path?"path="+path:"")+(_2ce?"; domain="+_2ce:"")+(_2cf?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _2d4=document.cookie.substring(idx+name.length+1);
var end=_2d4.indexOf(";");
if(end==-1){
end=_2d4.length;
}
_2d4=_2d4.substring(0,end);
_2d4=unescape(_2d4);
return _2d4;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_2db,_2dc,_2dd){
if(arguments.length==5){
_2dd=_2db;
_2db=null;
_2dc=null;
}
var _2de=[],_2df,_2e0="";
if(!_2dd){
_2df=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_2df){
_2df={};
}
for(var prop in obj){
if(obj[prop]==null){
delete _2df[prop];
}else{
if((typeof obj[prop]=="string")||(typeof obj[prop]=="number")){
_2df[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _2df){
_2de.push(escape(prop)+"="+escape(_2df[prop]));
}
_2e0=_2de.join("&");
}
dojo.io.cookie.setCookie(name,_2e0,days,path,_2db,_2dc);
};
dojo.io.cookie.getObjectCookie=function(name){
var _2e3=null,_2e4=dojo.io.cookie.getCookie(name);
if(_2e4){
_2e3={};
var _2e5=_2e4.split("&");
for(var i=0;i<_2e5.length;i++){
var pair=_2e5[i].split("=");
var _2e8=pair[1];
if(isNaN(_2e8)){
_2e8=unescape(pair[1]);
}
_2e3[unescape(pair[0])]=_2e8;
}
}
return _2e3;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _2e9=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_2e9=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.kwCompoundRequire({common:["dojo.io.common"],rhino:["dojo.io.RhinoIO"],browser:["dojo.io.BrowserIO","dojo.io.cookie"],dashboard:["dojo.io.BrowserIO","dojo.io.cookie"]});
dojo.provide("dojo.io.*");
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_2eb){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false,maxCalls:-1};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _2ee=dl.nameAnonFunc(args[2],ao.adviceObj,_2eb);
ao.adviceFunc=_2ee;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _2ee=dl.nameAnonFunc(args[0],ao.srcObj,_2eb);
ao.srcFunc=_2ee;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _2ee=dl.nameAnonFunc(args[1],dj_global,_2eb);
ao.srcFunc=_2ee;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _2ee=dl.nameAnonFunc(args[3],dj_global,_2eb);
ao.adviceObj=dj_global;
ao.adviceFunc=_2ee;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
ao.maxCalls=(!isNaN(parseInt(args[11])))?args[11]:-1;
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _2ee=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_2eb);
ao.aroundFunc=_2ee;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _2f0={};
for(var x in ao){
_2f0[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_2f0.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_2f0));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _2f8;
if((arguments.length==1)&&(typeof a1=="object")){
_2f8=a1;
}else{
_2f8={srcObj:a1,srcFunc:a2};
}
_2f8.adviceFunc=function(){
var _2f9=[];
for(var x=0;x<arguments.length;x++){
_2f9.push(arguments[x]);
}
dojo.debug("("+_2f8.srcObj+")."+_2f8.srcFunc,":",_2f9.join(", "));
};
this.kwConnect(_2f8);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this.connectRunOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.maxCalls=1;
return this.connect(ao);
};
this._kwConnectImpl=function(_301,_302){
var fn=(_302)?"disconnect":"connect";
if(typeof _301["srcFunc"]=="function"){
_301.srcObj=_301["srcObj"]||dj_global;
var _304=dojo.lang.nameAnonFunc(_301.srcFunc,_301.srcObj,true);
_301.srcFunc=_304;
}
if(typeof _301["adviceFunc"]=="function"){
_301.adviceObj=_301["adviceObj"]||dj_global;
var _304=dojo.lang.nameAnonFunc(_301.adviceFunc,_301.adviceObj,true);
_301.adviceFunc=_304;
}
_301.srcObj=_301["srcObj"]||dj_global;
_301.adviceObj=_301["adviceObj"]||_301["targetObj"]||dj_global;
_301.adviceFunc=_301["adviceFunc"]||_301["targetFunc"];
return dojo.event[fn](_301);
};
this.kwConnect=function(_305){
return this._kwConnectImpl(_305,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
if(!ao.srcObj[ao.srcFunc]){
return null;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc,true);
mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
return mjp;
};
this.kwDisconnect=function(_308){
return this._kwConnectImpl(_308,true);
};
};
dojo.event.MethodInvocation=function(_309,obj,args){
this.jp_=_309;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_311){
this.object=obj||dj_global;
this.methodname=_311;
this.methodfunc=this.object[_311];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_313){
if(!obj){
obj=dj_global;
}
var ofn=obj[_313];
if(!ofn){
ofn=obj[_313]=function(){
};
if(!obj[_313]){
dojo.raise("Cannot set do-nothing method on that object "+_313);
}
}else{
if((typeof ofn!="function")&&(!dojo.lang.isFunction(ofn))&&(!dojo.lang.isAlien(ofn))){
return null;
}
}
var _315=_313+"$joinpoint";
var _316=_313+"$joinpoint$method";
var _317=obj[_315];
if(!_317){
var _318=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_318=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_315,_316,_313]);
}
}
var _319=ofn.length;
obj[_316]=ofn;
_317=obj[_315]=new dojo.event.MethodJoinPoint(obj,_316);
if(!_318){
obj[_313]=function(){
return _317.run.apply(_317,arguments);
};
}else{
obj[_313]=function(){
var args=[];
if(!arguments.length){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _317.run.apply(_317,args);
};
}
obj[_313].__preJoinArity=_319;
}
return _317;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{squelch:false,unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _31f=[];
for(var x=0;x<args.length;x++){
_31f[x]=args[x];
}
var _321=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _323=marr[0]||dj_global;
var _324=marr[1];
if(!_323[_324]){
dojo.raise("function \""+_324+"\" does not exist on \""+_323+"\"");
}
var _325=marr[2]||dj_global;
var _326=marr[3];
var msg=marr[6];
var _328=marr[7];
if(_328>-1){
if(_328==0){
return;
}
marr[7]--;
}
var _329;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _323[_324].apply(_323,to.args);
}};
to.args=_31f;
var _32b=parseInt(marr[4]);
var _32c=((!isNaN(_32b))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _32f=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_321(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_326){
_325[_326].call(_325,to);
}else{
if((_32c)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_323[_324].call(_323,to);
}else{
_323[_324].apply(_323,args);
}
},_32b);
}else{
if(msg){
_323[_324].call(_323,to);
}else{
_323[_324].apply(_323,args);
}
}
}
};
var _332=function(){
if(this.squelch){
try{
return _321.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _321.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_332);
}
var _333;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_333=mi.proceed();
}else{
if(this.methodfunc){
_333=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.debug(e,"when calling",this.methodname,"on",this.object,"with arguments",args);
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_332);
}
return (this.methodfunc)?_333:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"],args["maxCalls"]);
},addAdvice:function(_338,_339,_33a,_33b,_33c,_33d,once,_33f,rate,_341,_342){
var arr=this.getArr(_33c);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_338,_339,_33a,_33b,_33f,rate,_341,_342];
if(once){
if(this.hasAdvice(_338,_339,_33c,arr)>=0){
return;
}
}
if(_33d=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_345,_346,_347,arr){
if(!arr){
arr=this.getArr(_347);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _346=="object")?(new String(_346)).toString():_346;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_345)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_34d,_34e,_34f,once){
var arr=this.getArr(_34f);
var ind=this.hasAdvice(_34d,_34e,_34f,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_34d,_34e,_34f,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_353){
if(!this.topics[_353]){
this.topics[_353]=new this.TopicImpl(_353);
}
return this.topics[_353];
};
this.registerPublisher=function(_354,obj,_356){
var _354=this.getTopic(_354);
_354.registerPublisher(obj,_356);
};
this.subscribe=function(_357,obj,_359){
var _357=this.getTopic(_357);
_357.subscribe(obj,_359);
};
this.unsubscribe=function(_35a,obj,_35c){
var _35a=this.getTopic(_35a);
_35a.unsubscribe(obj,_35c);
};
this.destroy=function(_35d){
this.getTopic(_35d).destroy();
delete this.topics[_35d];
};
this.publishApply=function(_35e,args){
var _35e=this.getTopic(_35e);
_35e.sendMessage.apply(_35e,args);
};
this.publish=function(_360,_361){
var _360=this.getTopic(_360);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_360.sendMessage.apply(_360,args);
};
};
dojo.event.topic.TopicImpl=function(_364){
this.topicName=_364;
this.subscribe=function(_365,_366){
var tf=_366||_365;
var to=(!_366)?dj_global:_365;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_369,_36a){
var tf=(!_36a)?_369:_36a;
var to=(!_36a)?null:_369;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_36d){
this._getJoinPoint().squelch=_36d;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_36e,_36f){
dojo.event.connect(_36e,_36f,this,"sendMessage");
};
this.sendMessage=function(_370){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_373){
var na;
var tna;
if(_373){
tna=_373.all||_373.getElementsByTagName("*");
na=[_373];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _377={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
if(dojo.widget){
for(var name in dojo.widget._templateCache){
if(dojo.widget._templateCache[name].node){
dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
dojo.widget._templateCache[name].node=null;
delete dojo.widget._templateCache[name].node;
}
}
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _37c=0;
this.normalizedEventName=function(_37d){
switch(_37d){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _37d;
break;
default:
var lcn=_37d.toLowerCase();
return (lcn.indexOf("on")==0)?lcn.substr(2):lcn;
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_382){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_382.length;x++){
node.__clobberAttrs__.push(_382[x]);
}
};
this.removeListener=function(node,_385,fp,_387){
if(!_387){
var _387=false;
}
_385=dojo.event.browser.normalizedEventName(_385);
if(_385=="key"){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_387);
}
_385="keypress";
}
if(node.removeEventListener){
node.removeEventListener(_385,fp,_387);
}
};
this.addListener=function(node,_389,fp,_38b,_38c){
if(!node){
return;
}
if(!_38b){
var _38b=false;
}
_389=dojo.event.browser.normalizedEventName(_389);
if(_389=="key"){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_38b,_38c);
}
_389="keypress";
}
if(!_38c){
var _38d=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_38b){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_38d=fp;
}
if(node.addEventListener){
node.addEventListener(_389,_38d,_38b);
return _38d;
}else{
_389="on"+_389;
if(typeof node[_389]=="function"){
var _390=node[_389];
node[_389]=function(e){
_390(e);
return _38d(e);
};
}else{
node[_389]=_38d;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_389]);
}
return _38d;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(obj)&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_393,_394){
if(typeof _393!="function"){
dojo.raise("listener not a function: "+_393);
}
dojo.event.browser.currentEvent.currentTarget=_394;
return _393.call(_394,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_397){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _399=evt.keyCode;
if(_399>=65&&_399<=90&&evt.shiftKey==false){
_399+=32;
}
if(_399>=1&&_399<=26&&evt.ctrlKey){
_399+=96;
}
evt.key=String.fromCharCode(_399);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _399=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_399+=32;
}
evt.key=String.fromCharCode(_399);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 25:
evt.key=evt.KEY_TAB;
evt.shift=true;
break;
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
case 63236:
evt.key=evt.KEY_F1;
break;
case 63237:
evt.key=evt.KEY_F2;
break;
case 63238:
evt.key=evt.KEY_F3;
break;
case 63239:
evt.key=evt.KEY_F4;
break;
case 63240:
evt.key=evt.KEY_F5;
break;
case 63241:
evt.key=evt.KEY_F6;
break;
case 63242:
evt.key=evt.KEY_F7;
break;
case 63243:
evt.key=evt.KEY_F8;
break;
case 63244:
evt.key=evt.KEY_F9;
break;
case 63245:
evt.key=evt.KEY_F10;
break;
case 63246:
evt.key=evt.KEY_F11;
break;
case 63247:
evt.key=evt.KEY_F12;
break;
case 63250:
evt.key=evt.KEY_PAUSE;
break;
case 63272:
evt.key=evt.KEY_DELETE;
break;
case 63273:
evt.key=evt.KEY_HOME;
break;
case 63275:
evt.key=evt.KEY_END;
break;
case 63276:
evt.key=evt.KEY_PAGE_UP;
break;
case 63277:
evt.key=evt.KEY_PAGE_DOWN;
break;
case 63302:
evt.key=evt.KEY_INSERT;
break;
case 63248:
case 63249:
case 63289:
break;
default:
evt.key=evt.charCode>=evt.KEY_SPACE?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_397?_397:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _39b=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_39b.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_39b.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.cancelBubble=true;
evt.returnValue=false;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.kwCompoundRequire({common:["dojo.event.common","dojo.event.topic"],browser:["dojo.event.browser"],dashboard:["dojo.event.browser"]});
dojo.provide("dojo.event.*");
dojo.provide("dojo.gfx.color");
dojo.gfx.color.Color=function(r,g,b,a){
if(dojo.lang.isArray(r)){
this.r=r[0];
this.g=r[1];
this.b=r[2];
this.a=r[3]||1;
}else{
if(dojo.lang.isString(r)){
var rgb=dojo.gfx.color.extractRGB(r);
this.r=rgb[0];
this.g=rgb[1];
this.b=rgb[2];
this.a=g||1;
}else{
if(r instanceof dojo.gfx.color.Color){
this.r=r.r;
this.b=r.b;
this.g=r.g;
this.a=r.a;
}else{
this.r=r;
this.g=g;
this.b=b;
this.a=a;
}
}
}
};
dojo.gfx.color.Color.fromArray=function(arr){
return new dojo.gfx.color.Color(arr[0],arr[1],arr[2],arr[3]);
};
dojo.extend(dojo.gfx.color.Color,{toRgb:function(_3a3){
if(_3a3){
return this.toRgba();
}else{
return [this.r,this.g,this.b];
}
},toRgba:function(){
return [this.r,this.g,this.b,this.a];
},toHex:function(){
return dojo.gfx.color.rgb2hex(this.toRgb());
},toCss:function(){
return "rgb("+this.toRgb().join()+")";
},toString:function(){
return this.toHex();
},blend:function(_3a4,_3a5){
var rgb=null;
if(dojo.lang.isArray(_3a4)){
rgb=_3a4;
}else{
if(_3a4 instanceof dojo.gfx.color.Color){
rgb=_3a4.toRgb();
}else{
rgb=new dojo.gfx.color.Color(_3a4).toRgb();
}
}
return dojo.gfx.color.blend(this.toRgb(),rgb,_3a5);
}});
dojo.gfx.color.named={white:[255,255,255],black:[0,0,0],red:[255,0,0],green:[0,255,0],lime:[0,255,0],blue:[0,0,255],navy:[0,0,128],gray:[128,128,128],silver:[192,192,192]};
dojo.gfx.color.blend=function(a,b,_3a9){
if(typeof a=="string"){
return dojo.gfx.color.blendHex(a,b,_3a9);
}
if(!_3a9){
_3a9=0;
}
_3a9=Math.min(Math.max(-1,_3a9),1);
_3a9=((_3a9+1)/2);
var c=[];
for(var x=0;x<3;x++){
c[x]=parseInt(b[x]+((a[x]-b[x])*_3a9));
}
return c;
};
dojo.gfx.color.blendHex=function(a,b,_3ae){
return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a),dojo.gfx.color.hex2rgb(b),_3ae));
};
dojo.gfx.color.extractRGB=function(_3af){
var hex="0123456789abcdef";
_3af=_3af.toLowerCase();
if(_3af.indexOf("rgb")==0){
var _3b1=_3af.match(/rgba*\((\d+), *(\d+), *(\d+)/i);
var ret=_3b1.splice(1,3);
return ret;
}else{
var _3b3=dojo.gfx.color.hex2rgb(_3af);
if(_3b3){
return _3b3;
}else{
return dojo.gfx.color.named[_3af]||[255,255,255];
}
}
};
dojo.gfx.color.hex2rgb=function(hex){
var _3b5="0123456789ABCDEF";
var rgb=new Array(3);
if(hex.indexOf("#")==0){
hex=hex.substring(1);
}
hex=hex.toUpperCase();
if(hex.replace(new RegExp("["+_3b5+"]","g"),"")!=""){
return null;
}
if(hex.length==3){
rgb[0]=hex.charAt(0)+hex.charAt(0);
rgb[1]=hex.charAt(1)+hex.charAt(1);
rgb[2]=hex.charAt(2)+hex.charAt(2);
}else{
rgb[0]=hex.substring(0,2);
rgb[1]=hex.substring(2,4);
rgb[2]=hex.substring(4);
}
for(var i=0;i<rgb.length;i++){
rgb[i]=_3b5.indexOf(rgb[i].charAt(0))*16+_3b5.indexOf(rgb[i].charAt(1));
}
return rgb;
};
dojo.gfx.color.rgb2hex=function(r,g,b){
if(dojo.lang.isArray(r)){
g=r[1]||0;
b=r[2]||0;
r=r[0]||0;
}
var ret=dojo.lang.map([r,g,b],function(x){
x=new Number(x);
var s=x.toString(16);
while(s.length<2){
s="0"+s;
}
return s;
});
ret.unshift("#");
return ret.join("");
};
dojo.provide("dojo.lfx.Animation");
dojo.lfx.Line=function(_3be,end){
this.start=_3be;
this.end=end;
if(dojo.lang.isArray(_3be)){
var diff=[];
dojo.lang.forEach(this.start,function(s,i){
diff[i]=this.end[i]-s;
},this);
this.getValue=function(n){
var res=[];
dojo.lang.forEach(this.start,function(s,i){
res[i]=(diff[i]*n)+s;
},this);
return res;
};
}else{
var diff=end-_3be;
this.getValue=function(n){
return (diff*n)+this.start;
};
}
};
if((dojo.render.html.khtml)&&(!dojo.render.html.safari)){
dojo.lfx.easeDefault=function(n){
return (parseFloat("0.5")+((Math.sin((n+parseFloat("1.5"))*Math.PI))/2));
};
}else{
dojo.lfx.easeDefault=function(n){
return (0.5+((Math.sin((n+1.5)*Math.PI))/2));
};
}
dojo.lfx.easeIn=function(n){
return Math.pow(n,3);
};
dojo.lfx.easeOut=function(n){
return (1-Math.pow(1-n,3));
};
dojo.lfx.easeInOut=function(n){
return ((3*Math.pow(n,2))-(2*Math.pow(n,3)));
};
dojo.lfx.IAnimation=function(){
};
dojo.lang.extend(dojo.lfx.IAnimation,{curve:null,duration:1000,easing:null,repeatCount:0,rate:10,handler:null,beforeBegin:null,onBegin:null,onAnimate:null,onEnd:null,onPlay:null,onPause:null,onStop:null,play:null,pause:null,stop:null,connect:function(evt,_3ce,_3cf){
if(!_3cf){
_3cf=_3ce;
_3ce=this;
}
_3cf=dojo.lang.hitch(_3ce,_3cf);
var _3d0=this[evt]||function(){
};
this[evt]=function(){
var ret=_3d0.apply(this,arguments);
_3cf.apply(this,arguments);
return ret;
};
return this;
},fire:function(evt,args){
if(this[evt]){
this[evt].apply(this,(args||[]));
}
return this;
},repeat:function(_3d4){
this.repeatCount=_3d4;
return this;
},_active:false,_paused:false});
dojo.lfx.Animation=function(_3d5,_3d6,_3d7,_3d8,_3d9,rate){
dojo.lfx.IAnimation.call(this);
if(dojo.lang.isNumber(_3d5)||(!_3d5&&_3d6.getValue)){
rate=_3d9;
_3d9=_3d8;
_3d8=_3d7;
_3d7=_3d6;
_3d6=_3d5;
_3d5=null;
}else{
if(_3d5.getValue||dojo.lang.isArray(_3d5)){
rate=_3d8;
_3d9=_3d7;
_3d8=_3d6;
_3d7=_3d5;
_3d6=null;
_3d5=null;
}
}
if(dojo.lang.isArray(_3d7)){
this.curve=new dojo.lfx.Line(_3d7[0],_3d7[1]);
}else{
this.curve=_3d7;
}
if(_3d6!=null&&_3d6>0){
this.duration=_3d6;
}
if(_3d9){
this.repeatCount=_3d9;
}
if(rate){
this.rate=rate;
}
if(_3d5){
dojo.lang.forEach(["handler","beforeBegin","onBegin","onEnd","onPlay","onStop","onAnimate"],function(item){
if(_3d5[item]){
this.connect(item,_3d5[item]);
}
},this);
}
if(_3d8&&dojo.lang.isFunction(_3d8)){
this.easing=_3d8;
}
};
dojo.inherits(dojo.lfx.Animation,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Animation,{_startTime:null,_endTime:null,_timer:null,_percent:0,_startRepeatCount:0,play:function(_3dc,_3dd){
if(_3dd){
clearTimeout(this._timer);
this._active=false;
this._paused=false;
this._percent=0;
}else{
if(this._active&&!this._paused){
return this;
}
}
this.fire("handler",["beforeBegin"]);
this.fire("beforeBegin");
if(_3dc>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_3dd);
}),_3dc);
return this;
}
this._startTime=new Date().valueOf();
if(this._paused){
this._startTime-=(this.duration*this._percent/100);
}
this._endTime=this._startTime+this.duration;
this._active=true;
this._paused=false;
var step=this._percent/100;
var _3df=this.curve.getValue(step);
if(this._percent==0){
if(!this._startRepeatCount){
this._startRepeatCount=this.repeatCount;
}
this.fire("handler",["begin",_3df]);
this.fire("onBegin",[_3df]);
}
this.fire("handler",["play",_3df]);
this.fire("onPlay",[_3df]);
this._cycle();
return this;
},pause:function(){
clearTimeout(this._timer);
if(!this._active){
return this;
}
this._paused=true;
var _3e0=this.curve.getValue(this._percent/100);
this.fire("handler",["pause",_3e0]);
this.fire("onPause",[_3e0]);
return this;
},gotoPercent:function(pct,_3e2){
clearTimeout(this._timer);
this._active=true;
this._paused=true;
this._percent=pct;
if(_3e2){
this.play();
}
return this;
},stop:function(_3e3){
clearTimeout(this._timer);
var step=this._percent/100;
if(_3e3){
step=1;
}
var _3e5=this.curve.getValue(step);
this.fire("handler",["stop",_3e5]);
this.fire("onStop",[_3e5]);
this._active=false;
this._paused=false;
return this;
},status:function(){
if(this._active){
return this._paused?"paused":"playing";
}else{
return "stopped";
}
return this;
},_cycle:function(){
clearTimeout(this._timer);
if(this._active){
var curr=new Date().valueOf();
var step=(curr-this._startTime)/(this._endTime-this._startTime);
if(step>=1){
step=1;
this._percent=100;
}else{
this._percent=step*100;
}
if((this.easing)&&(dojo.lang.isFunction(this.easing))){
step=this.easing(step);
}
var _3e8=this.curve.getValue(step);
this.fire("handler",["animate",_3e8]);
this.fire("onAnimate",[_3e8]);
if(step<1){
this._timer=setTimeout(dojo.lang.hitch(this,"_cycle"),this.rate);
}else{
this._active=false;
this.fire("handler",["end"]);
this.fire("onEnd");
if(this.repeatCount>0){
this.repeatCount--;
this.play(null,true);
}else{
if(this.repeatCount==-1){
this.play(null,true);
}else{
if(this._startRepeatCount){
this.repeatCount=this._startRepeatCount;
this._startRepeatCount=0;
}
}
}
}
}
return this;
}});
dojo.lfx.Combine=function(_3e9){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._animsEnded=0;
var _3ea=arguments;
if(_3ea.length==1&&(dojo.lang.isArray(_3ea[0])||dojo.lang.isArrayLike(_3ea[0]))){
_3ea=_3ea[0];
}
dojo.lang.forEach(_3ea,function(anim){
this._anims.push(anim);
anim.connect("onEnd",dojo.lang.hitch(this,"_onAnimsEnded"));
},this);
};
dojo.inherits(dojo.lfx.Combine,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Combine,{_animsEnded:0,play:function(_3ec,_3ed){
if(!this._anims.length){
return this;
}
this.fire("beforeBegin");
if(_3ec>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_3ed);
}),_3ec);
return this;
}
if(_3ed||this._anims[0].percent==0){
this.fire("onBegin");
}
this.fire("onPlay");
this._animsCall("play",null,_3ed);
return this;
},pause:function(){
this.fire("onPause");
this._animsCall("pause");
return this;
},stop:function(_3ee){
this.fire("onStop");
this._animsCall("stop",_3ee);
return this;
},_onAnimsEnded:function(){
this._animsEnded++;
if(this._animsEnded>=this._anims.length){
this.fire("onEnd");
}
return this;
},_animsCall:function(_3ef){
var args=[];
if(arguments.length>1){
for(var i=1;i<arguments.length;i++){
args.push(arguments[i]);
}
}
var _3f2=this;
dojo.lang.forEach(this._anims,function(anim){
anim[_3ef](args);
},_3f2);
return this;
}});
dojo.lfx.Chain=function(_3f4){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._currAnim=-1;
var _3f5=arguments;
if(_3f5.length==1&&(dojo.lang.isArray(_3f5[0])||dojo.lang.isArrayLike(_3f5[0]))){
_3f5=_3f5[0];
}
var _3f6=this;
dojo.lang.forEach(_3f5,function(anim,i,_3f9){
this._anims.push(anim);
if(i<_3f9.length-1){
anim.connect("onEnd",dojo.lang.hitch(this,"_playNext"));
}else{
anim.connect("onEnd",dojo.lang.hitch(this,function(){
this.fire("onEnd");
}));
}
},this);
};
dojo.inherits(dojo.lfx.Chain,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Chain,{_currAnim:-1,play:function(_3fa,_3fb){
if(!this._anims.length){
return this;
}
if(_3fb||!this._anims[this._currAnim]){
this._currAnim=0;
}
var _3fc=this._anims[this._currAnim];
this.fire("beforeBegin");
if(_3fa>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_3fb);
}),_3fa);
return this;
}
if(_3fc){
if(this._currAnim==0){
this.fire("handler",["begin",this._currAnim]);
this.fire("onBegin",[this._currAnim]);
}
this.fire("onPlay",[this._currAnim]);
_3fc.play(null,_3fb);
}
return this;
},pause:function(){
if(this._anims[this._currAnim]){
this._anims[this._currAnim].pause();
this.fire("onPause",[this._currAnim]);
}
return this;
},playPause:function(){
if(this._anims.length==0){
return this;
}
if(this._currAnim==-1){
this._currAnim=0;
}
var _3fd=this._anims[this._currAnim];
if(_3fd){
if(!_3fd._active||_3fd._paused){
this.play();
}else{
this.pause();
}
}
return this;
},stop:function(){
var _3fe=this._anims[this._currAnim];
if(_3fe){
_3fe.stop();
this.fire("onStop",[this._currAnim]);
}
return _3fe;
},_playNext:function(){
if(this._currAnim==-1||this._anims.length==0){
return this;
}
this._currAnim++;
if(this._anims[this._currAnim]){
this._anims[this._currAnim].play(null,true);
}
return this;
}});
dojo.lfx.combine=function(_3ff){
var _400=arguments;
if(dojo.lang.isArray(arguments[0])){
_400=arguments[0];
}
if(_400.length==1){
return _400[0];
}
return new dojo.lfx.Combine(_400);
};
dojo.lfx.chain=function(_401){
var _402=arguments;
if(dojo.lang.isArray(arguments[0])){
_402=arguments[0];
}
if(_402.length==1){
return _402[0];
}
return new dojo.lfx.Chain(_402);
};
dojo.provide("dojo.html.common");
dojo.lang.mixin(dojo.html,dojo.dom);
dojo.html.body=function(){
dojo.deprecated("dojo.html.body() moved to dojo.body()","0.5");
return dojo.body();
};
dojo.html.getEventTarget=function(evt){
if(!evt){
evt=dojo.global().event||{};
}
var t=(evt.srcElement?evt.srcElement:(evt.target?evt.target:null));
while((t)&&(t.nodeType!=1)){
t=t.parentNode;
}
return t;
};
dojo.html.getViewport=function(){
var _405=dojo.global();
var _406=dojo.doc();
var w=0;
var h=0;
if(dojo.render.html.mozilla){
w=_406.documentElement.clientWidth;
h=_405.innerHeight;
}else{
if(!dojo.render.html.opera&&_405.innerWidth){
w=_405.innerWidth;
h=_405.innerHeight;
}else{
if(!dojo.render.html.opera&&dojo.exists(_406,"documentElement.clientWidth")){
var w2=_406.documentElement.clientWidth;
if(!w||w2&&w2<w){
w=w2;
}
h=_406.documentElement.clientHeight;
}else{
if(dojo.body().clientWidth){
w=dojo.body().clientWidth;
h=dojo.body().clientHeight;
}
}
}
}
return {width:w,height:h};
};
dojo.html.getScroll=function(){
var _40a=dojo.global();
var _40b=dojo.doc();
var top=_40a.pageYOffset||_40b.documentElement.scrollTop||dojo.body().scrollTop||0;
var left=_40a.pageXOffset||_40b.documentElement.scrollLeft||dojo.body().scrollLeft||0;
return {top:top,left:left,offset:{x:left,y:top}};
};
dojo.html.getParentByType=function(node,type){
var _410=dojo.doc();
var _411=dojo.byId(node);
type=type.toLowerCase();
while((_411)&&(_411.nodeName.toLowerCase()!=type)){
if(_411==(_410["body"]||_410["documentElement"])){
return null;
}
_411=_411.parentNode;
}
return _411;
};
dojo.html.getAttribute=function(node,attr){
node=dojo.byId(node);
if((!node)||(!node.getAttribute)){
return null;
}
var ta=typeof attr=="string"?attr:new String(attr);
var v=node.getAttribute(ta.toUpperCase());
if((v)&&(typeof v=="string")&&(v!="")){
return v;
}
if(v&&v.value){
return v.value;
}
if((node.getAttributeNode)&&(node.getAttributeNode(ta))){
return (node.getAttributeNode(ta)).value;
}else{
if(node.getAttribute(ta)){
return node.getAttribute(ta);
}else{
if(node.getAttribute(ta.toLowerCase())){
return node.getAttribute(ta.toLowerCase());
}
}
}
return null;
};
dojo.html.hasAttribute=function(node,attr){
return dojo.html.getAttribute(dojo.byId(node),attr)?true:false;
};
dojo.html.getCursorPosition=function(e){
e=e||dojo.global().event;
var _419={x:0,y:0};
if(e.pageX||e.pageY){
_419.x=e.pageX;
_419.y=e.pageY;
}else{
var de=dojo.doc().documentElement;
var db=dojo.body();
_419.x=e.clientX+((de||db)["scrollLeft"])-((de||db)["clientLeft"]);
_419.y=e.clientY+((de||db)["scrollTop"])-((de||db)["clientTop"]);
}
return _419;
};
dojo.html.isTag=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName.toLowerCase()==String(arguments[i]).toLowerCase()){
return String(arguments[i]).toLowerCase();
}
}
}
return "";
};
if(dojo.render.html.ie&&!dojo.render.html.ie70){
if(window.location.href.substr(0,6).toLowerCase()!="https:"){
(function(){
var _41e=dojo.doc().createElement("script");
_41e.src="javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
dojo.doc().getElementsByTagName("head")[0].appendChild(_41e);
})();
}
}else{
dojo.html.createExternalElement=function(doc,tag){
return doc.createElement(tag);
};
}
dojo.html._callDeprecated=function(_421,_422,args,_424,_425){
dojo.deprecated("dojo.html."+_421,"replaced by dojo.html."+_422+"("+(_424?"node, {"+_424+": "+_424+"}":"")+")"+(_425?"."+_425:""),"0.5");
var _426=[];
if(_424){
var _427={};
_427[_424]=args[1];
_426.push(args[0]);
_426.push(_427);
}else{
_426=args;
}
var ret=dojo.html[_422].apply(dojo.html,args);
if(_425){
return ret[_425];
}else{
return ret;
}
};
dojo.html.getViewportWidth=function(){
return dojo.html._callDeprecated("getViewportWidth","getViewport",arguments,null,"width");
};
dojo.html.getViewportHeight=function(){
return dojo.html._callDeprecated("getViewportHeight","getViewport",arguments,null,"height");
};
dojo.html.getViewportSize=function(){
return dojo.html._callDeprecated("getViewportSize","getViewport",arguments);
};
dojo.html.getScrollTop=function(){
return dojo.html._callDeprecated("getScrollTop","getScroll",arguments,null,"top");
};
dojo.html.getScrollLeft=function(){
return dojo.html._callDeprecated("getScrollLeft","getScroll",arguments,null,"left");
};
dojo.html.getScrollOffset=function(){
return dojo.html._callDeprecated("getScrollOffset","getScroll",arguments,null,"offset");
};
dojo.provide("dojo.uri.Uri");
dojo.uri=new function(){
this.dojoUri=function(uri){
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri(),uri);
};
this.moduleUri=function(_42a,uri){
var loc=dojo.hostenv.getModuleSymbols(_42a).join("/");
if(!loc){
return null;
}
if(loc.lastIndexOf("/")!=loc.length-1){
loc+="/";
}
var _42d=loc.indexOf(":");
var _42e=loc.indexOf("/");
if(loc.charAt(0)!="/"&&(_42d==-1||_42d>_42e)){
loc=dojo.hostenv.getBaseScriptUri()+loc;
}
return new dojo.uri.Uri(loc,uri);
};
this.Uri=function(){
var uri=arguments[0];
for(var i=1;i<arguments.length;i++){
if(!arguments[i]){
continue;
}
var _431=new dojo.uri.Uri(arguments[i].toString());
var _432=new dojo.uri.Uri(uri.toString());
if((_431.path=="")&&(_431.scheme==null)&&(_431.authority==null)&&(_431.query==null)){
if(_431.fragment!=null){
_432.fragment=_431.fragment;
}
_431=_432;
}else{
if(_431.scheme==null){
_431.scheme=_432.scheme;
if(_431.authority==null){
_431.authority=_432.authority;
if(_431.path.charAt(0)!="/"){
var path=_432.path.substring(0,_432.path.lastIndexOf("/")+1)+_431.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==segs.length-1){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_431.path=segs.join("/");
}
}
}
}
uri="";
if(_431.scheme!=null){
uri+=_431.scheme+":";
}
if(_431.authority!=null){
uri+="//"+_431.authority;
}
uri+=_431.path;
if(_431.query!=null){
uri+="?"+_431.query;
}
if(_431.fragment!=null){
uri+="#"+_431.fragment;
}
}
this.uri=uri.toString();
var _436="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=this.uri.match(new RegExp(_436));
this.scheme=r[2]||(r[1]?"":null);
this.authority=r[4]||(r[3]?"":null);
this.path=r[5];
this.query=r[7]||(r[6]?"":null);
this.fragment=r[9]||(r[8]?"":null);
if(this.authority!=null){
_436="^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$";
r=this.authority.match(new RegExp(_436));
this.user=r[3]||null;
this.password=r[4]||null;
this.host=r[5];
this.port=r[7]||null;
}
this.toString=function(){
return this.uri;
};
};
};
dojo.provide("dojo.html.style");
dojo.html.getClass=function(node){
node=dojo.byId(node);
if(!node){
return "";
}
var cs="";
if(node.className){
cs=node.className;
}else{
if(dojo.html.hasAttribute(node,"class")){
cs=dojo.html.getAttribute(node,"class");
}
}
return cs.replace(/^\s+|\s+$/g,"");
};
dojo.html.getClasses=function(node){
var c=dojo.html.getClass(node);
return (c=="")?[]:c.split(/\s+/g);
};
dojo.html.hasClass=function(node,_43d){
return (new RegExp("(^|\\s+)"+_43d+"(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass=function(node,_43f){
_43f+=" "+dojo.html.getClass(node);
return dojo.html.setClass(node,_43f);
};
dojo.html.addClass=function(node,_441){
if(dojo.html.hasClass(node,_441)){
return false;
}
_441=(dojo.html.getClass(node)+" "+_441).replace(/^\s+|\s+$/g,"");
return dojo.html.setClass(node,_441);
};
dojo.html.setClass=function(node,_443){
node=dojo.byId(node);
var cs=new String(_443);
try{
if(typeof node.className=="string"){
node.className=cs;
}else{
if(node.setAttribute){
node.setAttribute("class",_443);
node.className=cs;
}else{
return false;
}
}
}
catch(e){
dojo.debug("dojo.html.setClass() failed",e);
}
return true;
};
dojo.html.removeClass=function(node,_446,_447){
try{
if(!_447){
var _448=dojo.html.getClass(node).replace(new RegExp("(^|\\s+)"+_446+"(\\s+|$)"),"$1$2");
}else{
var _448=dojo.html.getClass(node).replace(_446,"");
}
dojo.html.setClass(node,_448);
}
catch(e){
dojo.debug("dojo.html.removeClass() failed",e);
}
return true;
};
dojo.html.replaceClass=function(node,_44a,_44b){
dojo.html.removeClass(node,_44b);
dojo.html.addClass(node,_44a);
};
dojo.html.classMatchType={ContainsAll:0,ContainsAny:1,IsOnly:2};
dojo.html.getElementsByClass=function(_44c,_44d,_44e,_44f,_450){
_450=false;
var _451=dojo.doc();
_44d=dojo.byId(_44d)||_451;
var _452=_44c.split(/\s+/g);
var _453=[];
if(_44f!=1&&_44f!=2){
_44f=0;
}
var _454=new RegExp("(\\s|^)(("+_452.join(")|(")+"))(\\s|$)");
var _455=_452.join(" ").length;
var _456=[];
if(!_450&&_451.evaluate){
var _457=".//"+(_44e||"*")+"[contains(";
if(_44f!=dojo.html.classMatchType.ContainsAny){
_457+="concat(' ',@class,' '), ' "+_452.join(" ') and contains(concat(' ',@class,' '), ' ")+" ')";
if(_44f==2){
_457+=" and string-length(@class)="+_455+"]";
}else{
_457+="]";
}
}else{
_457+="concat(' ',@class,' '), ' "+_452.join(" ') or contains(concat(' ',@class,' '), ' ")+" ')]";
}
var _458=_451.evaluate(_457,_44d,null,XPathResult.ANY_TYPE,null);
var _459=_458.iterateNext();
while(_459){
try{
_456.push(_459);
_459=_458.iterateNext();
}
catch(e){
break;
}
}
return _456;
}else{
if(!_44e){
_44e="*";
}
_456=_44d.getElementsByTagName(_44e);
var node,i=0;
outer:
while(node=_456[i++]){
var _45c=dojo.html.getClasses(node);
if(_45c.length==0){
continue outer;
}
var _45d=0;
for(var j=0;j<_45c.length;j++){
if(_454.test(_45c[j])){
if(_44f==dojo.html.classMatchType.ContainsAny){
_453.push(node);
continue outer;
}else{
_45d++;
}
}else{
if(_44f==dojo.html.classMatchType.IsOnly){
continue outer;
}
}
}
if(_45d==_452.length){
if((_44f==dojo.html.classMatchType.IsOnly)&&(_45d==_45c.length)){
_453.push(node);
}else{
if(_44f==dojo.html.classMatchType.ContainsAll){
_453.push(node);
}
}
}
}
return _453;
}
};
dojo.html.getElementsByClassName=dojo.html.getElementsByClass;
dojo.html.toCamelCase=function(_45f){
var arr=_45f.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.html.toSelectorCase=function(_463){
return _463.replace(/([A-Z])/g,"-$1").toLowerCase();
};
if(dojo.render.html.ie){
dojo.html.getComputedStyle=function(node,_465,_466){
node=dojo.byId(node);
if(!node||!node.style){
return _466;
}
return node.currentStyle[dojo.html.toCamelCase(_465)];
};
dojo.html.getComputedStyles=function(node){
return node.currentStyle;
};
}else{
dojo.html.getComputedStyle=function(node,_469,_46a){
node=dojo.byId(node);
if(!node||!node.style){
return _46a;
}
var s=document.defaultView.getComputedStyle(node,null);
return (s&&s[dojo.html.toCamelCase(_469)])||"";
};
dojo.html.getComputedStyles=function(node){
return document.defaultView.getComputedStyle(node,null);
};
}
dojo.html.getStyleProperty=function(node,_46e){
node=dojo.byId(node);
return (node&&node.style?node.style[dojo.html.toCamelCase(_46e)]:undefined);
};
dojo.html.getStyle=function(node,_470){
var _471=dojo.html.getStyleProperty(node,_470);
return (_471?_471:dojo.html.getComputedStyle(node,_470));
};
dojo.html.setStyle=function(node,_473,_474){
node=dojo.byId(node);
if(node&&node.style){
var _475=dojo.html.toCamelCase(_473);
node.style[_475]=_474;
}
};
dojo.html.setStyleText=function(_476,text){
try{
_476.style.cssText=text;
}
catch(e){
_476.setAttribute("style",text);
}
};
dojo.html.copyStyle=function(_478,_479){
if(!_479.style.cssText){
_478.setAttribute("style",_479.getAttribute("style"));
}else{
_478.style.cssText=_479.style.cssText;
}
dojo.html.addClass(_478,dojo.html.getClass(_479));
};
dojo.html.getUnitValue=function(node,_47b,_47c){
var s=dojo.html.getComputedStyle(node,_47b);
if((!s)||((s=="auto")&&(_47c))){
return {value:0,units:"px"};
}
var _47e=s.match(/(\-?[\d.]+)([a-z%]*)/i);
if(!_47e){
return dojo.html.getUnitValue.bad;
}
return {value:Number(_47e[1]),units:_47e[2].toLowerCase()};
};
dojo.html.getUnitValue.bad={value:NaN,units:""};
if(dojo.render.html.ie){
dojo.html.toPixelValue=function(_47f,_480){
if(!_480){
return 0;
}
if(_480.slice(-2)=="px"){
return parseFloat(_480);
}
var _481=0;
with(_47f){
var _482=style.left;
var _483=runtimeStyle.left;
runtimeStyle.left=currentStyle.left;
try{
style.left=_480||0;
_481=style.pixelLeft;
style.left=_482;
runtimeStyle.left=_483;
}
catch(e){
}
}
return _481;
};
}else{
dojo.html.toPixelValue=function(_484,_485){
return (_485&&(_485.slice(-2)=="px")?parseFloat(_485):0);
};
}
dojo.html.getPixelValue=function(node,_487,_488){
return dojo.html.toPixelValue(node,dojo.html.getComputedStyle(node,_487));
};
dojo.html.setPositivePixelValue=function(node,_48a,_48b){
if(isNaN(_48b)){
return false;
}
node.style[_48a]=Math.max(0,_48b)+"px";
return true;
};
dojo.html.styleSheet=null;
dojo.html.insertCssRule=function(_48c,_48d,_48e){
if(!dojo.html.styleSheet){
if(document.createStyleSheet){
dojo.html.styleSheet=document.createStyleSheet();
}else{
if(document.styleSheets[0]){
dojo.html.styleSheet=document.styleSheets[0];
}else{
return null;
}
}
}
if(arguments.length<3){
if(dojo.html.styleSheet.cssRules){
_48e=dojo.html.styleSheet.cssRules.length;
}else{
if(dojo.html.styleSheet.rules){
_48e=dojo.html.styleSheet.rules.length;
}else{
return null;
}
}
}
if(dojo.html.styleSheet.insertRule){
var rule=_48c+" { "+_48d+" }";
return dojo.html.styleSheet.insertRule(rule,_48e);
}else{
if(dojo.html.styleSheet.addRule){
return dojo.html.styleSheet.addRule(_48c,_48d,_48e);
}else{
return null;
}
}
};
dojo.html.removeCssRule=function(_490){
if(!dojo.html.styleSheet){
dojo.debug("no stylesheet defined for removing rules");
return false;
}
if(dojo.render.html.ie){
if(!_490){
_490=dojo.html.styleSheet.rules.length;
dojo.html.styleSheet.removeRule(_490);
}
}else{
if(document.styleSheets[0]){
if(!_490){
_490=dojo.html.styleSheet.cssRules.length;
}
dojo.html.styleSheet.deleteRule(_490);
}
}
return true;
};
dojo.html._insertedCssFiles=[];
dojo.html.insertCssFile=function(URI,doc,_493,_494){
if(!URI){
return;
}
if(!doc){
doc=document;
}
var _495=dojo.hostenv.getText(URI,false,_494);
if(_495===null){
return;
}
_495=dojo.html.fixPathsInCssText(_495,URI);
if(_493){
var idx=-1,node,ent=dojo.html._insertedCssFiles;
for(var i=0;i<ent.length;i++){
if((ent[i].doc==doc)&&(ent[i].cssText==_495)){
idx=i;
node=ent[i].nodeRef;
break;
}
}
if(node){
var _49a=doc.getElementsByTagName("style");
for(var i=0;i<_49a.length;i++){
if(_49a[i]==node){
return;
}
}
dojo.html._insertedCssFiles.shift(idx,1);
}
}
var _49b=dojo.html.insertCssText(_495,doc);
dojo.html._insertedCssFiles.push({"doc":doc,"cssText":_495,"nodeRef":_49b});
if(_49b&&djConfig.isDebug){
_49b.setAttribute("dbgHref",URI);
}
return _49b;
};
dojo.html.insertCssText=function(_49c,doc,URI){
if(!_49c){
return;
}
if(!doc){
doc=document;
}
if(URI){
_49c=dojo.html.fixPathsInCssText(_49c,URI);
}
var _49f=doc.createElement("style");
_49f.setAttribute("type","text/css");
var head=doc.getElementsByTagName("head")[0];
if(!head){
dojo.debug("No head tag in document, aborting styles");
return;
}else{
head.appendChild(_49f);
}
if(_49f.styleSheet){
var _4a1=function(){
try{
_49f.styleSheet.cssText=_49c;
}
catch(e){
dojo.debug(e);
}
};
if(_49f.styleSheet.disabled){
setTimeout(_4a1,10);
}else{
_4a1();
}
}else{
var _4a2=doc.createTextNode(_49c);
_49f.appendChild(_4a2);
}
return _49f;
};
dojo.html.fixPathsInCssText=function(_4a3,URI){
if(!_4a3||!URI){
return;
}
var _4a5,str="",url="",_4a8="[\\t\\s\\w\\(\\)\\/\\.\\\\'\"-:#=&?~]+";
var _4a9=new RegExp("url\\(\\s*("+_4a8+")\\s*\\)");
var _4aa=/(file|https?|ftps?):\/\//;
regexTrim=new RegExp("^[\\s]*(['\"]?)("+_4a8+")\\1[\\s]*?$");
if(dojo.render.html.ie55||dojo.render.html.ie60){
var _4ab=new RegExp("AlphaImageLoader\\((.*)src=['\"]("+_4a8+")['\"]");
while(_4a5=_4ab.exec(_4a3)){
url=_4a5[2].replace(regexTrim,"$2");
if(!_4aa.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_4a3.substring(0,_4a5.index)+"AlphaImageLoader("+_4a5[1]+"src='"+url+"'";
_4a3=_4a3.substr(_4a5.index+_4a5[0].length);
}
_4a3=str+_4a3;
str="";
}
while(_4a5=_4a9.exec(_4a3)){
url=_4a5[1].replace(regexTrim,"$2");
if(!_4aa.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_4a3.substring(0,_4a5.index)+"url("+url+")";
_4a3=_4a3.substr(_4a5.index+_4a5[0].length);
}
return str+_4a3;
};
dojo.html.setActiveStyleSheet=function(_4ac){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")){
a.disabled=true;
if(a.getAttribute("title")==_4ac){
a.disabled=false;
}
}
}
};
dojo.html.getActiveStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")&&!a.disabled){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.getPreferredStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("rel").indexOf("alt")==-1&&a.getAttribute("title")){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.applyBrowserClass=function(node){
var drh=dojo.render.html;
var _4b8={dj_ie:drh.ie,dj_ie55:drh.ie55,dj_ie6:drh.ie60,dj_ie7:drh.ie70,dj_iequirks:drh.ie&&drh.quirks,dj_opera:drh.opera,dj_opera8:drh.opera&&(Math.floor(dojo.render.version)==8),dj_opera9:drh.opera&&(Math.floor(dojo.render.version)==9),dj_khtml:drh.khtml,dj_safari:drh.safari,dj_gecko:drh.mozilla};
for(var p in _4b8){
if(_4b8[p]){
dojo.html.addClass(node,p);
}
}
};
dojo.provide("dojo.html.display");
dojo.html._toggle=function(node,_4bb,_4bc){
node=dojo.byId(node);
_4bc(node,!_4bb(node));
return _4bb(node);
};
dojo.html.show=function(node){
node=dojo.byId(node);
if(dojo.html.getStyleProperty(node,"display")=="none"){
dojo.html.setStyle(node,"display",(node.dojoDisplayCache||""));
node.dojoDisplayCache=undefined;
}
};
dojo.html.hide=function(node){
node=dojo.byId(node);
if(typeof node["dojoDisplayCache"]=="undefined"){
var d=dojo.html.getStyleProperty(node,"display");
if(d!="none"){
node.dojoDisplayCache=d;
}
}
dojo.html.setStyle(node,"display","none");
};
dojo.html.setShowing=function(node,_4c1){
dojo.html[(_4c1?"show":"hide")](node);
};
dojo.html.isShowing=function(node){
return (dojo.html.getStyleProperty(node,"display")!="none");
};
dojo.html.toggleShowing=function(node){
return dojo.html._toggle(node,dojo.html.isShowing,dojo.html.setShowing);
};
dojo.html.displayMap={tr:"",td:"",th:"",img:"inline",span:"inline",input:"inline",button:"inline"};
dojo.html.suggestDisplayByTagName=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
var tag=node.tagName.toLowerCase();
return (tag in dojo.html.displayMap?dojo.html.displayMap[tag]:"block");
}
};
dojo.html.setDisplay=function(node,_4c7){
dojo.html.setStyle(node,"display",((_4c7 instanceof String||typeof _4c7=="string")?_4c7:(_4c7?dojo.html.suggestDisplayByTagName(node):"none")));
};
dojo.html.isDisplayed=function(node){
return (dojo.html.getComputedStyle(node,"display")!="none");
};
dojo.html.toggleDisplay=function(node){
return dojo.html._toggle(node,dojo.html.isDisplayed,dojo.html.setDisplay);
};
dojo.html.setVisibility=function(node,_4cb){
dojo.html.setStyle(node,"visibility",((_4cb instanceof String||typeof _4cb=="string")?_4cb:(_4cb?"visible":"hidden")));
};
dojo.html.isVisible=function(node){
return (dojo.html.getComputedStyle(node,"visibility")!="hidden");
};
dojo.html.toggleVisibility=function(node){
return dojo.html._toggle(node,dojo.html.isVisible,dojo.html.setVisibility);
};
dojo.html.setOpacity=function(node,_4cf,_4d0){
node=dojo.byId(node);
var h=dojo.render.html;
if(!_4d0){
if(_4cf>=1){
if(h.ie){
dojo.html.clearOpacity(node);
return;
}else{
_4cf=0.999999;
}
}else{
if(_4cf<0){
_4cf=0;
}
}
}
if(h.ie){
if(node.nodeName.toLowerCase()=="tr"){
var tds=node.getElementsByTagName("td");
for(var x=0;x<tds.length;x++){
tds[x].style.filter="Alpha(Opacity="+_4cf*100+")";
}
}
node.style.filter="Alpha(Opacity="+_4cf*100+")";
}else{
if(h.moz){
node.style.opacity=_4cf;
node.style.MozOpacity=_4cf;
}else{
if(h.safari){
node.style.opacity=_4cf;
node.style.KhtmlOpacity=_4cf;
}else{
node.style.opacity=_4cf;
}
}
}
};
dojo.html.clearOpacity=function(node){
node=dojo.byId(node);
var ns=node.style;
var h=dojo.render.html;
if(h.ie){
try{
if(node.filters&&node.filters.alpha){
ns.filter="";
}
}
catch(e){
}
}else{
if(h.moz){
ns.opacity=1;
ns.MozOpacity=1;
}else{
if(h.safari){
ns.opacity=1;
ns.KhtmlOpacity=1;
}else{
ns.opacity=1;
}
}
}
};
dojo.html.getOpacity=function(node){
node=dojo.byId(node);
var h=dojo.render.html;
if(h.ie){
var opac=(node.filters&&node.filters.alpha&&typeof node.filters.alpha.opacity=="number"?node.filters.alpha.opacity:100)/100;
}else{
var opac=node.style.opacity||node.style.MozOpacity||node.style.KhtmlOpacity||1;
}
return opac>=0.999999?1:Number(opac);
};
dojo.provide("dojo.html.color");
dojo.html.getBackgroundColor=function(node){
node=dojo.byId(node);
var _4db;
do{
_4db=dojo.html.getStyle(node,"background-color");
if(_4db.toLowerCase()=="rgba(0, 0, 0, 0)"){
_4db="transparent";
}
if(node==document.getElementsByTagName("body")[0]){
node=null;
break;
}
node=node.parentNode;
}while(node&&dojo.lang.inArray(["transparent",""],_4db));
if(_4db=="transparent"){
_4db=[255,255,255,0];
}else{
_4db=dojo.gfx.color.extractRGB(_4db);
}
return _4db;
};
dojo.provide("dojo.html.layout");
dojo.html.sumAncestorProperties=function(node,prop){
node=dojo.byId(node);
if(!node){
return 0;
}
var _4de=0;
while(node){
if(dojo.html.getComputedStyle(node,"position")=="fixed"){
return 0;
}
var val=node[prop];
if(val){
_4de+=val-0;
if(node==dojo.body()){
break;
}
}
node=node.parentNode;
}
return _4de;
};
dojo.html.setStyleAttributes=function(node,_4e1){
node=dojo.byId(node);
var _4e2=_4e1.replace(/(;)?\s*$/,"").split(";");
for(var i=0;i<_4e2.length;i++){
var _4e4=_4e2[i].split(":");
var name=_4e4[0].replace(/\s*$/,"").replace(/^\s*/,"").toLowerCase();
var _4e6=_4e4[1].replace(/\s*$/,"").replace(/^\s*/,"");
switch(name){
case "opacity":
dojo.html.setOpacity(node,_4e6);
break;
case "content-height":
dojo.html.setContentBox(node,{height:_4e6});
break;
case "content-width":
dojo.html.setContentBox(node,{width:_4e6});
break;
case "outer-height":
dojo.html.setMarginBox(node,{height:_4e6});
break;
case "outer-width":
dojo.html.setMarginBox(node,{width:_4e6});
break;
default:
node.style[dojo.html.toCamelCase(name)]=_4e6;
}
}
};
dojo.html.boxSizing={MARGIN_BOX:"margin-box",BORDER_BOX:"border-box",PADDING_BOX:"padding-box",CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition=dojo.html.abs=function(node,_4e8,_4e9){
node=dojo.byId(node,node.ownerDocument);
var ret={x:0,y:0};
var bs=dojo.html.boxSizing;
if(!_4e9){
_4e9=bs.CONTENT_BOX;
}
var _4ec=2;
var _4ed;
switch(_4e9){
case bs.MARGIN_BOX:
_4ed=3;
break;
case bs.BORDER_BOX:
_4ed=2;
break;
case bs.PADDING_BOX:
default:
_4ed=1;
break;
case bs.CONTENT_BOX:
_4ed=0;
break;
}
var h=dojo.render.html;
var db=document["body"]||document["documentElement"];
if(h.ie){
with(node.getBoundingClientRect()){
ret.x=left-2;
ret.y=top-2;
}
}else{
if(document.getBoxObjectFor){
_4ec=1;
try{
var bo=document.getBoxObjectFor(node);
ret.x=bo.x-dojo.html.sumAncestorProperties(node,"scrollLeft");
ret.y=bo.y-dojo.html.sumAncestorProperties(node,"scrollTop");
}
catch(e){
}
}else{
if(node["offsetParent"]){
var _4f1;
if((h.safari)&&(node.style.getPropertyValue("position")=="absolute")&&(node.parentNode==db)){
_4f1=db;
}else{
_4f1=db.parentNode;
}
if(node.parentNode!=db){
var nd=node;
if(dojo.render.html.opera){
nd=db;
}
ret.x-=dojo.html.sumAncestorProperties(nd,"scrollLeft");
ret.y-=dojo.html.sumAncestorProperties(nd,"scrollTop");
}
var _4f3=node;
do{
var n=_4f3["offsetLeft"];
if(!h.opera||n>0){
ret.x+=isNaN(n)?0:n;
}
var m=_4f3["offsetTop"];
ret.y+=isNaN(m)?0:m;
_4f3=_4f3.offsetParent;
}while((_4f3!=_4f1)&&(_4f3!=null));
}else{
if(node["x"]&&node["y"]){
ret.x+=isNaN(node.x)?0:node.x;
ret.y+=isNaN(node.y)?0:node.y;
}
}
}
}
if(_4e8){
var _4f6=dojo.html.getScroll();
ret.y+=_4f6.top;
ret.x+=_4f6.left;
}
var _4f7=[dojo.html.getPaddingExtent,dojo.html.getBorderExtent,dojo.html.getMarginExtent];
if(_4ec>_4ed){
for(var i=_4ed;i<_4ec;++i){
ret.y+=_4f7[i](node,"top");
ret.x+=_4f7[i](node,"left");
}
}else{
if(_4ec<_4ed){
for(var i=_4ed;i>_4ec;--i){
ret.y-=_4f7[i-1](node,"top");
ret.x-=_4f7[i-1](node,"left");
}
}
}
ret.top=ret.y;
ret.left=ret.x;
return ret;
};
dojo.html.isPositionAbsolute=function(node){
return (dojo.html.getComputedStyle(node,"position")=="absolute");
};
dojo.html._sumPixelValues=function(node,_4fb,_4fc){
var _4fd=0;
for(var x=0;x<_4fb.length;x++){
_4fd+=dojo.html.getPixelValue(node,_4fb[x],_4fc);
}
return _4fd;
};
dojo.html.getMargin=function(node){
return {width:dojo.html._sumPixelValues(node,["margin-left","margin-right"],(dojo.html.getComputedStyle(node,"position")=="absolute")),height:dojo.html._sumPixelValues(node,["margin-top","margin-bottom"],(dojo.html.getComputedStyle(node,"position")=="absolute"))};
};
dojo.html.getBorder=function(node){
return {width:dojo.html.getBorderExtent(node,"left")+dojo.html.getBorderExtent(node,"right"),height:dojo.html.getBorderExtent(node,"top")+dojo.html.getBorderExtent(node,"bottom")};
};
dojo.html.getBorderExtent=function(node,side){
return (dojo.html.getStyle(node,"border-"+side+"-style")=="none"?0:dojo.html.getPixelValue(node,"border-"+side+"-width"));
};
dojo.html.getMarginExtent=function(node,side){
return dojo.html._sumPixelValues(node,["margin-"+side],dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent=function(node,side){
return dojo.html._sumPixelValues(node,["padding-"+side],true);
};
dojo.html.getPadding=function(node){
return {width:dojo.html._sumPixelValues(node,["padding-left","padding-right"],true),height:dojo.html._sumPixelValues(node,["padding-top","padding-bottom"],true)};
};
dojo.html.getPadBorder=function(node){
var pad=dojo.html.getPadding(node);
var _50a=dojo.html.getBorder(node);
return {width:pad.width+_50a.width,height:pad.height+_50a.height};
};
dojo.html.getBoxSizing=function(node){
var h=dojo.render.html;
var bs=dojo.html.boxSizing;
if(((h.ie)||(h.opera))&&node.nodeName.toLowerCase()!="img"){
var cm=document["compatMode"];
if((cm=="BackCompat")||(cm=="QuirksMode")){
return bs.BORDER_BOX;
}else{
return bs.CONTENT_BOX;
}
}else{
if(arguments.length==0){
node=document.documentElement;
}
var _50f;
if(!h.ie){
_50f=dojo.html.getStyle(node,"-moz-box-sizing");
if(!_50f){
_50f=dojo.html.getStyle(node,"box-sizing");
}
}
return (_50f?_50f:bs.CONTENT_BOX);
}
};
dojo.html.isBorderBox=function(node){
return (dojo.html.getBoxSizing(node)==dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox=function(node){
node=dojo.byId(node);
return {width:node.offsetWidth,height:node.offsetHeight};
};
dojo.html.getPaddingBox=function(node){
var box=dojo.html.getBorderBox(node);
var _514=dojo.html.getBorder(node);
return {width:box.width-_514.width,height:box.height-_514.height};
};
dojo.html.getContentBox=function(node){
node=dojo.byId(node);
var _516=dojo.html.getPadBorder(node);
return {width:node.offsetWidth-_516.width,height:node.offsetHeight-_516.height};
};
dojo.html.setContentBox=function(node,args){
node=dojo.byId(node);
var _519=0;
var _51a=0;
var isbb=dojo.html.isBorderBox(node);
var _51c=(isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var ret={};
if(typeof args.width!="undefined"){
_519=args.width+_51c.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_519);
}
if(typeof args.height!="undefined"){
_51a=args.height+_51c.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_51a);
}
return ret;
};
dojo.html.getMarginBox=function(node){
var _51f=dojo.html.getBorderBox(node);
var _520=dojo.html.getMargin(node);
return {width:_51f.width+_520.width,height:_51f.height+_520.height};
};
dojo.html.setMarginBox=function(node,args){
node=dojo.byId(node);
var _523=0;
var _524=0;
var isbb=dojo.html.isBorderBox(node);
var _526=(!isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var _527=dojo.html.getMargin(node);
var ret={};
if(typeof args.width!="undefined"){
_523=args.width-_526.width;
_523-=_527.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_523);
}
if(typeof args.height!="undefined"){
_524=args.height-_526.height;
_524-=_527.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_524);
}
return ret;
};
dojo.html.getElementBox=function(node,type){
var bs=dojo.html.boxSizing;
switch(type){
case bs.MARGIN_BOX:
return dojo.html.getMarginBox(node);
case bs.BORDER_BOX:
return dojo.html.getBorderBox(node);
case bs.PADDING_BOX:
return dojo.html.getPaddingBox(node);
case bs.CONTENT_BOX:
default:
return dojo.html.getContentBox(node);
}
};
dojo.html.toCoordinateObject=dojo.html.toCoordinateArray=function(_52c,_52d,_52e){
if(_52c instanceof Array||typeof _52c=="array"){
dojo.deprecated("dojo.html.toCoordinateArray","use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead","0.5");
while(_52c.length<4){
_52c.push(0);
}
while(_52c.length>4){
_52c.pop();
}
var ret={left:_52c[0],top:_52c[1],width:_52c[2],height:_52c[3]};
}else{
if(!_52c.nodeType&&!(_52c instanceof String||typeof _52c=="string")&&("width" in _52c||"height" in _52c||"left" in _52c||"x" in _52c||"top" in _52c||"y" in _52c)){
var ret={left:_52c.left||_52c.x||0,top:_52c.top||_52c.y||0,width:_52c.width||0,height:_52c.height||0};
}else{
var node=dojo.byId(_52c);
var pos=dojo.html.abs(node,_52d,_52e);
var _532=dojo.html.getMarginBox(node);
var ret={left:pos.left,top:pos.top,width:_532.width,height:_532.height};
}
}
ret.x=ret.left;
ret.y=ret.top;
return ret;
};
dojo.html.setMarginBoxWidth=dojo.html.setOuterWidth=function(node,_534){
return dojo.html._callDeprecated("setMarginBoxWidth","setMarginBox",arguments,"width");
};
dojo.html.setMarginBoxHeight=dojo.html.setOuterHeight=function(){
return dojo.html._callDeprecated("setMarginBoxHeight","setMarginBox",arguments,"height");
};
dojo.html.getMarginBoxWidth=dojo.html.getOuterWidth=function(){
return dojo.html._callDeprecated("getMarginBoxWidth","getMarginBox",arguments,null,"width");
};
dojo.html.getMarginBoxHeight=dojo.html.getOuterHeight=function(){
return dojo.html._callDeprecated("getMarginBoxHeight","getMarginBox",arguments,null,"height");
};
dojo.html.getTotalOffset=function(node,type,_537){
return dojo.html._callDeprecated("getTotalOffset","getAbsolutePosition",arguments,null,type);
};
dojo.html.getAbsoluteX=function(node,_539){
return dojo.html._callDeprecated("getAbsoluteX","getAbsolutePosition",arguments,null,"x");
};
dojo.html.getAbsoluteY=function(node,_53b){
return dojo.html._callDeprecated("getAbsoluteY","getAbsolutePosition",arguments,null,"y");
};
dojo.html.totalOffsetLeft=function(node,_53d){
return dojo.html._callDeprecated("totalOffsetLeft","getAbsolutePosition",arguments,null,"left");
};
dojo.html.totalOffsetTop=function(node,_53f){
return dojo.html._callDeprecated("totalOffsetTop","getAbsolutePosition",arguments,null,"top");
};
dojo.html.getMarginWidth=function(node){
return dojo.html._callDeprecated("getMarginWidth","getMargin",arguments,null,"width");
};
dojo.html.getMarginHeight=function(node){
return dojo.html._callDeprecated("getMarginHeight","getMargin",arguments,null,"height");
};
dojo.html.getBorderWidth=function(node){
return dojo.html._callDeprecated("getBorderWidth","getBorder",arguments,null,"width");
};
dojo.html.getBorderHeight=function(node){
return dojo.html._callDeprecated("getBorderHeight","getBorder",arguments,null,"height");
};
dojo.html.getPaddingWidth=function(node){
return dojo.html._callDeprecated("getPaddingWidth","getPadding",arguments,null,"width");
};
dojo.html.getPaddingHeight=function(node){
return dojo.html._callDeprecated("getPaddingHeight","getPadding",arguments,null,"height");
};
dojo.html.getPadBorderWidth=function(node){
return dojo.html._callDeprecated("getPadBorderWidth","getPadBorder",arguments,null,"width");
};
dojo.html.getPadBorderHeight=function(node){
return dojo.html._callDeprecated("getPadBorderHeight","getPadBorder",arguments,null,"height");
};
dojo.html.getBorderBoxWidth=dojo.html.getInnerWidth=function(){
return dojo.html._callDeprecated("getBorderBoxWidth","getBorderBox",arguments,null,"width");
};
dojo.html.getBorderBoxHeight=dojo.html.getInnerHeight=function(){
return dojo.html._callDeprecated("getBorderBoxHeight","getBorderBox",arguments,null,"height");
};
dojo.html.getContentBoxWidth=dojo.html.getContentWidth=function(){
return dojo.html._callDeprecated("getContentBoxWidth","getContentBox",arguments,null,"width");
};
dojo.html.getContentBoxHeight=dojo.html.getContentHeight=function(){
return dojo.html._callDeprecated("getContentBoxHeight","getContentBox",arguments,null,"height");
};
dojo.html.setContentBoxWidth=dojo.html.setContentWidth=function(node,_549){
return dojo.html._callDeprecated("setContentBoxWidth","setContentBox",arguments,"width");
};
dojo.html.setContentBoxHeight=dojo.html.setContentHeight=function(node,_54b){
return dojo.html._callDeprecated("setContentBoxHeight","setContentBox",arguments,"height");
};
dojo.provide("dojo.lfx.html");
dojo.lfx.html._byId=function(_54c){
if(!_54c){
return [];
}
if(dojo.lang.isArrayLike(_54c)){
if(!_54c.alreadyChecked){
var n=[];
dojo.lang.forEach(_54c,function(node){
n.push(dojo.byId(node));
});
n.alreadyChecked=true;
return n;
}else{
return _54c;
}
}else{
var n=[];
n.push(dojo.byId(_54c));
n.alreadyChecked=true;
return n;
}
};
dojo.lfx.html.propertyAnimation=function(_54f,_550,_551,_552,_553){
_54f=dojo.lfx.html._byId(_54f);
var _554={"propertyMap":_550,"nodes":_54f,"duration":_551,"easing":_552||dojo.lfx.easeDefault};
var _555=function(args){
if(args.nodes.length==1){
var pm=args.propertyMap;
if(!dojo.lang.isArray(args.propertyMap)){
var parr=[];
for(var _559 in pm){
pm[_559].property=_559;
parr.push(pm[_559]);
}
pm=args.propertyMap=parr;
}
dojo.lang.forEach(pm,function(prop){
if(dj_undef("start",prop)){
if(prop.property!="opacity"){
prop.start=parseInt(dojo.html.getComputedStyle(args.nodes[0],prop.property));
}else{
prop.start=dojo.html.getOpacity(args.nodes[0]);
}
}
});
}
};
var _55b=function(_55c){
var _55d=[];
dojo.lang.forEach(_55c,function(c){
_55d.push(Math.round(c));
});
return _55d;
};
var _55f=function(n,_561){
n=dojo.byId(n);
if(!n||!n.style){
return;
}
for(var s in _561){
try{
if(s=="opacity"){
dojo.html.setOpacity(n,_561[s]);
}else{
n.style[s]=_561[s];
}
}
catch(e){
dojo.debug(e);
}
}
};
var _563=function(_564){
this._properties=_564;
this.diffs=new Array(_564.length);
dojo.lang.forEach(_564,function(prop,i){
if(dojo.lang.isFunction(prop.start)){
prop.start=prop.start(prop,i);
}
if(dojo.lang.isFunction(prop.end)){
prop.end=prop.end(prop,i);
}
if(dojo.lang.isArray(prop.start)){
this.diffs[i]=null;
}else{
if(prop.start instanceof dojo.gfx.color.Color){
prop.startRgb=prop.start.toRgb();
prop.endRgb=prop.end.toRgb();
}else{
this.diffs[i]=prop.end-prop.start;
}
}
},this);
this.getValue=function(n){
var ret={};
dojo.lang.forEach(this._properties,function(prop,i){
var _56b=null;
if(dojo.lang.isArray(prop.start)){
}else{
if(prop.start instanceof dojo.gfx.color.Color){
_56b=(prop.units||"rgb")+"(";
for(var j=0;j<prop.startRgb.length;j++){
_56b+=Math.round(((prop.endRgb[j]-prop.startRgb[j])*n)+prop.startRgb[j])+(j<prop.startRgb.length-1?",":"");
}
_56b+=")";
}else{
_56b=((this.diffs[i])*n)+prop.start+(prop.property!="opacity"?prop.units||"px":"");
}
}
ret[dojo.html.toCamelCase(prop.property)]=_56b;
},this);
return ret;
};
};
var anim=new dojo.lfx.Animation({beforeBegin:function(){
_555(_554);
anim.curve=new _563(_554.propertyMap);
},onAnimate:function(_56e){
dojo.lang.forEach(_554.nodes,function(node){
_55f(node,_56e);
});
}},_554.duration,null,_554.easing);
if(_553){
for(var x in _553){
if(dojo.lang.isFunction(_553[x])){
anim.connect(x,anim,_553[x]);
}
}
}
return anim;
};
dojo.lfx.html._makeFadeable=function(_571){
var _572=function(node){
if(dojo.render.html.ie){
if((node.style.zoom.length==0)&&(dojo.html.getStyle(node,"zoom")=="normal")){
node.style.zoom="1";
}
if((node.style.width.length==0)&&(dojo.html.getStyle(node,"width")=="auto")){
node.style.width="auto";
}
}
};
if(dojo.lang.isArrayLike(_571)){
dojo.lang.forEach(_571,_572);
}else{
_572(_571);
}
};
dojo.lfx.html.fade=function(_574,_575,_576,_577,_578){
_574=dojo.lfx.html._byId(_574);
var _579={property:"opacity"};
if(!dj_undef("start",_575)){
_579.start=_575.start;
}else{
_579.start=function(){
return dojo.html.getOpacity(_574[0]);
};
}
if(!dj_undef("end",_575)){
_579.end=_575.end;
}else{
dojo.raise("dojo.lfx.html.fade needs an end value");
}
var anim=dojo.lfx.propertyAnimation(_574,[_579],_576,_577);
anim.connect("beforeBegin",function(){
dojo.lfx.html._makeFadeable(_574);
});
if(_578){
anim.connect("onEnd",function(){
_578(_574,anim);
});
}
return anim;
};
dojo.lfx.html.fadeIn=function(_57b,_57c,_57d,_57e){
return dojo.lfx.html.fade(_57b,{end:1},_57c,_57d,_57e);
};
dojo.lfx.html.fadeOut=function(_57f,_580,_581,_582){
return dojo.lfx.html.fade(_57f,{end:0},_580,_581,_582);
};
dojo.lfx.html.fadeShow=function(_583,_584,_585,_586){
_583=dojo.lfx.html._byId(_583);
dojo.lang.forEach(_583,function(node){
dojo.html.setOpacity(node,0);
});
var anim=dojo.lfx.html.fadeIn(_583,_584,_585,_586);
anim.connect("beforeBegin",function(){
if(dojo.lang.isArrayLike(_583)){
dojo.lang.forEach(_583,dojo.html.show);
}else{
dojo.html.show(_583);
}
});
return anim;
};
dojo.lfx.html.fadeHide=function(_589,_58a,_58b,_58c){
var anim=dojo.lfx.html.fadeOut(_589,_58a,_58b,function(){
if(dojo.lang.isArrayLike(_589)){
dojo.lang.forEach(_589,dojo.html.hide);
}else{
dojo.html.hide(_589);
}
if(_58c){
_58c(_589,anim);
}
});
return anim;
};
dojo.lfx.html.wipeIn=function(_58e,_58f,_590,_591){
_58e=dojo.lfx.html._byId(_58e);
var _592=[];
dojo.lang.forEach(_58e,function(node){
var _594={};
var _595,_596,_597;
with(node.style){
_595=top;
_596=left;
_597=position;
top="-9999px";
left="-9999px";
position="absolute";
display="";
}
var _598=dojo.html.getBorderBox(node).height;
with(node.style){
top=_595;
left=_596;
position=_597;
display="none";
}
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:1,end:function(){
return _598;
}}},_58f,_590);
anim.connect("beforeBegin",function(){
_594.overflow=node.style.overflow;
_594.height=node.style.height;
with(node.style){
overflow="hidden";
height="1px";
}
dojo.html.show(node);
});
anim.connect("onEnd",function(){
with(node.style){
overflow=_594.overflow;
height=_594.height;
}
if(_591){
_591(node,anim);
}
});
_592.push(anim);
});
return dojo.lfx.combine(_592);
};
dojo.lfx.html.wipeOut=function(_59a,_59b,_59c,_59d){
_59a=dojo.lfx.html._byId(_59a);
var _59e=[];
dojo.lang.forEach(_59a,function(node){
var _5a0={};
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:function(){
return dojo.html.getContentBox(node).height;
},end:1}},_59b,_59c,{"beforeBegin":function(){
_5a0.overflow=node.style.overflow;
_5a0.height=node.style.height;
with(node.style){
overflow="hidden";
}
dojo.html.show(node);
},"onEnd":function(){
dojo.html.hide(node);
with(node.style){
overflow=_5a0.overflow;
height=_5a0.height;
}
if(_59d){
_59d(node,anim);
}
}});
_59e.push(anim);
});
return dojo.lfx.combine(_59e);
};
dojo.lfx.html.slideTo=function(_5a2,_5a3,_5a4,_5a5,_5a6){
_5a2=dojo.lfx.html._byId(_5a2);
var _5a7=[];
var _5a8=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_5a3)){
dojo.deprecated("dojo.lfx.html.slideTo(node, array)","use dojo.lfx.html.slideTo(node, {top: value, left: value});","0.5");
_5a3={top:_5a3[0],left:_5a3[1]};
}
dojo.lang.forEach(_5a2,function(node){
var top=null;
var left=null;
var init=(function(){
var _5ad=node;
return function(){
var pos=_5a8(_5ad,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_5a8(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_5a8(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_5ad,true);
dojo.html.setStyleAttributes(_5ad,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:(_5a3.top||0)},"left":{start:left,end:(_5a3.left||0)}},_5a4,_5a5,{"beforeBegin":init});
if(_5a6){
anim.connect("onEnd",function(){
_5a6(_5a2,anim);
});
}
_5a7.push(anim);
});
return dojo.lfx.combine(_5a7);
};
dojo.lfx.html.slideBy=function(_5b1,_5b2,_5b3,_5b4,_5b5){
_5b1=dojo.lfx.html._byId(_5b1);
var _5b6=[];
var _5b7=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_5b2)){
dojo.deprecated("dojo.lfx.html.slideBy(node, array)","use dojo.lfx.html.slideBy(node, {top: value, left: value});","0.5");
_5b2={top:_5b2[0],left:_5b2[1]};
}
dojo.lang.forEach(_5b1,function(node){
var top=null;
var left=null;
var init=(function(){
var _5bc=node;
return function(){
var pos=_5b7(_5bc,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_5b7(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_5b7(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_5bc,true);
dojo.html.setStyleAttributes(_5bc,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:top+(_5b2.top||0)},"left":{start:left,end:left+(_5b2.left||0)}},_5b3,_5b4).connect("beforeBegin",init);
if(_5b5){
anim.connect("onEnd",function(){
_5b5(_5b1,anim);
});
}
_5b6.push(anim);
});
return dojo.lfx.combine(_5b6);
};
dojo.lfx.html.explode=function(_5c0,_5c1,_5c2,_5c3,_5c4){
var h=dojo.html;
_5c0=dojo.byId(_5c0);
_5c1=dojo.byId(_5c1);
var _5c6=h.toCoordinateObject(_5c0,true);
var _5c7=document.createElement("div");
h.copyStyle(_5c7,_5c1);
if(_5c1.explodeClassName){
_5c7.className=_5c1.explodeClassName;
}
with(_5c7.style){
position="absolute";
display="none";
var _5c8=h.getStyle(_5c0,"background-color");
backgroundColor=_5c8?_5c8.toLowerCase():"transparent";
backgroundColor=(backgroundColor=="transparent")?"rgb(221, 221, 221)":backgroundColor;
}
dojo.body().appendChild(_5c7);
with(_5c1.style){
visibility="hidden";
display="block";
}
var _5c9=h.toCoordinateObject(_5c1,true);
with(_5c1.style){
display="none";
visibility="visible";
}
var _5ca={opacity:{start:0.5,end:1}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_5ca[type]={start:_5c6[type],end:_5c9[type]};
});
var anim=new dojo.lfx.propertyAnimation(_5c7,_5ca,_5c2,_5c3,{"beforeBegin":function(){
h.setDisplay(_5c7,"block");
},"onEnd":function(){
h.setDisplay(_5c1,"block");
_5c7.parentNode.removeChild(_5c7);
}});
if(_5c4){
anim.connect("onEnd",function(){
_5c4(_5c1,anim);
});
}
return anim;
};
dojo.lfx.html.implode=function(_5cd,end,_5cf,_5d0,_5d1){
var h=dojo.html;
_5cd=dojo.byId(_5cd);
end=dojo.byId(end);
var _5d3=dojo.html.toCoordinateObject(_5cd,true);
var _5d4=dojo.html.toCoordinateObject(end,true);
var _5d5=document.createElement("div");
dojo.html.copyStyle(_5d5,_5cd);
if(_5cd.explodeClassName){
_5d5.className=_5cd.explodeClassName;
}
dojo.html.setOpacity(_5d5,0.3);
with(_5d5.style){
position="absolute";
display="none";
backgroundColor=h.getStyle(_5cd,"background-color").toLowerCase();
}
dojo.body().appendChild(_5d5);
var _5d6={opacity:{start:1,end:0.5}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_5d6[type]={start:_5d3[type],end:_5d4[type]};
});
var anim=new dojo.lfx.propertyAnimation(_5d5,_5d6,_5cf,_5d0,{"beforeBegin":function(){
dojo.html.hide(_5cd);
dojo.html.show(_5d5);
},"onEnd":function(){
_5d5.parentNode.removeChild(_5d5);
}});
if(_5d1){
anim.connect("onEnd",function(){
_5d1(_5cd,anim);
});
}
return anim;
};
dojo.lfx.html.highlight=function(_5d9,_5da,_5db,_5dc,_5dd){
_5d9=dojo.lfx.html._byId(_5d9);
var _5de=[];
dojo.lang.forEach(_5d9,function(node){
var _5e0=dojo.html.getBackgroundColor(node);
var bg=dojo.html.getStyle(node,"background-color").toLowerCase();
var _5e2=dojo.html.getStyle(node,"background-image");
var _5e3=(bg=="transparent"||bg=="rgba(0, 0, 0, 0)");
while(_5e0.length>3){
_5e0.pop();
}
var rgb=new dojo.gfx.color.Color(_5da);
var _5e5=new dojo.gfx.color.Color(_5e0);
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:rgb,end:_5e5}},_5db,_5dc,{"beforeBegin":function(){
if(_5e2){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+rgb.toRgb().join(",")+")";
},"onEnd":function(){
if(_5e2){
node.style.backgroundImage=_5e2;
}
if(_5e3){
node.style.backgroundColor="transparent";
}
if(_5dd){
_5dd(node,anim);
}
}});
_5de.push(anim);
});
return dojo.lfx.combine(_5de);
};
dojo.lfx.html.unhighlight=function(_5e7,_5e8,_5e9,_5ea,_5eb){
_5e7=dojo.lfx.html._byId(_5e7);
var _5ec=[];
dojo.lang.forEach(_5e7,function(node){
var _5ee=new dojo.gfx.color.Color(dojo.html.getBackgroundColor(node));
var rgb=new dojo.gfx.color.Color(_5e8);
var _5f0=dojo.html.getStyle(node,"background-image");
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:_5ee,end:rgb}},_5e9,_5ea,{"beforeBegin":function(){
if(_5f0){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+_5ee.toRgb().join(",")+")";
},"onEnd":function(){
if(_5eb){
_5eb(node,anim);
}
}});
_5ec.push(anim);
});
return dojo.lfx.combine(_5ec);
};
dojo.lang.mixin(dojo.lfx,dojo.lfx.html);
dojo.kwCompoundRequire({browser:["dojo.lfx.html"],dashboard:["dojo.lfx.html"]});
dojo.provide("dojo.lfx.*");


__CPAN_EDITION__ ajax build.txt
Files baked into this build:
dojoGuardStart.js
../src/bootstrap1.js
../src/loader.js
dojoGuardEnd.js
../src/hostenv_browser.js
../src/string/common.js
../src/string.js
../src/lang/common.js
../src/lang/extras.js
../src/io/common.js
../src/lang/array.js
../src/lang/func.js
../src/string/extras.js
../src/dom.js
../src/undo/browser.js
../src/io/BrowserIO.js
../src/io/cookie.js
../src/io/__package__.js
../src/event/common.js
../src/event/topic.js
../src/event/browser.js
../src/event/__package__.js
../src/gfx/color.js
../src/lfx/Animation.js
../src/html/common.js
../src/uri/Uri.js
../src/html/style.js
../src/html/display.js
../src/html/color.js
../src/html/layout.js
../src/lfx/html.js
../src/lfx/__package__.js
__CPAN_EDITION__ charting dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:2,flag:"",revision:Number("$Rev: 7616 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
function dj_load_init(e){
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_ee,_ef){
if(!dojo.lang.isFunction(_ef)){
dojo.raise("dojo.inherits: superclass argument ["+_ef+"] must be a function (subclass: ["+_ee+"']");
}
_ee.prototype=new _ef();
_ee.prototype.constructor=_ee;
_ee.superclass=_ef.prototype;
_ee["super"]=_ef.prototype;
};
dojo.lang._mixin=function(obj,_f1){
var _f2={};
for(var x in _f1){
if((typeof _f2[x]=="undefined")||(_f2[x]!=_f1[x])){
obj[x]=_f1[x];
}
}
if(dojo.render.html.ie&&(typeof (_f1["toString"])=="function")&&(_f1["toString"]!=obj["toString"])&&(_f1["toString"]!=_f2["toString"])){
obj.toString=_f1.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_f5){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_f8,_f9){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_f8.prototype,arguments[i]);
}
return _f8;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_fc,_fd,_fe,_ff){
if(!dojo.lang.isArrayLike(_fc)&&dojo.lang.isArrayLike(_fd)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_fc;
_fc=_fd;
_fd=temp;
}
var _101=dojo.lang.isString(_fc);
if(_101){
_fc=_fc.split("");
}
if(_ff){
var step=-1;
var i=_fc.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_fc.length;
}
if(_fe){
while(i!=end){
if(_fc[i]===_fd){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_fc[i]==_fd){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_105,_106,_107){
return dojo.lang.find(_105,_106,_107,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_108,_109){
return dojo.lang.find(_108,_109)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_114,_115){
var fcn=(dojo.lang.isString(_115)?_114[_115]:_115)||function(){
};
return function(){
return fcn.apply(_114,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_117,_118,_119){
var nso=(_118||dojo.lang.anon);
if((_119)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_117){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_117;
return ret;
};
dojo.lang.forward=function(_11d){
return function(){
return this[_11d].apply(this,arguments);
};
};
dojo.lang.curry=function(_11e,func){
var _120=[];
_11e=_11e||dj_global;
if(dojo.lang.isString(func)){
func=_11e[func];
}
for(var x=2;x<arguments.length;x++){
_120.push(arguments[x]);
}
var _122=(func["__preJoinArity"]||func.length)-_120.length;
function gather(_123,_124,_125){
var _126=_125;
var _127=_124.slice(0);
for(var x=0;x<_123.length;x++){
_127.push(_123[x]);
}
_125=_125-_123.length;
if(_125<=0){
var res=func.apply(_11e,_127);
_125=_126;
return res;
}else{
return function(){
return gather(arguments,_127,_125);
};
}
}
return gather([],_120,_122);
};
dojo.lang.curryArguments=function(_12a,func,args,_12d){
var _12e=[];
var x=_12d||0;
for(x=_12d;x<args.length;x++){
_12e.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_12a,func].concat(_12e));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_134,_135){
if(!farr.length){
if(typeof _135=="function"){
_135();
}
return;
}
if((typeof _134=="undefined")&&(typeof cb=="number")){
_134=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_134){
_134=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_134,_135);
},_134);
};
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_13c,_13d){
var out="";
for(var i=0;i<_13c;i++){
out+=str;
if(_13d&&i<_13c-1){
out+=_13d;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _14f=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_14f++;
break;
}
}
return _14f==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
},map:function(arr,obj,_153){
var _154=dojo.lang.isString(arr);
if(_154){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_153)){
_153=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_153){
var _155=obj;
obj=_153;
_153=_155;
}
}
if(Array.map){
var _156=Array.map(arr,_153,obj);
}else{
var _156=[];
for(var i=0;i<arr.length;++i){
_156.push(_153.call(obj,arr[i]));
}
}
if(_154){
return _156.join("");
}else{
return _156;
}
},reduce:function(arr,_159,obj,_15b){
var _15c=_159;
if(arguments.length==2){
_15b=_159;
_15c=arr[0];
arr=arr.slice(1);
}else{
if(arguments.length==3){
if(dojo.lang.isFunction(obj)){
_15b=obj;
obj=null;
}
}else{
if(dojo.lang.isFunction(obj)){
var tmp=_15b;
_15b=obj;
obj=tmp;
}
}
}
var ob=obj||dj_global;
dojo.lang.map(arr,function(val){
_15c=_15b.call(ob,_15c,val);
});
return _15c;
},forEach:function(_160,_161,_162){
if(dojo.lang.isString(_160)){
_160=_160.split("");
}
if(Array.forEach){
Array.forEach(_160,_161,_162);
}else{
if(!_162){
_162=dj_global;
}
for(var i=0,l=_160.length;i<l;i++){
_161.call(_162,_160[i],i,_160);
}
}
},_everyOrSome:function(_165,arr,_167,_168){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_165?"every":"some"](arr,_167,_168);
}else{
if(!_168){
_168=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _16b=_167.call(_168,arr[i],i,arr);
if(_165&&!_16b){
return false;
}else{
if((!_165)&&(_16b)){
return true;
}
}
}
return Boolean(_165);
}
},every:function(arr,_16d,_16e){
return this._everyOrSome(true,arr,_16d,_16e);
},some:function(arr,_170,_171){
return this._everyOrSome(false,arr,_170,_171);
},filter:function(arr,_173,_174){
var _175=dojo.lang.isString(arr);
if(_175){
arr=arr.split("");
}
var _176;
if(Array.filter){
_176=Array.filter(arr,_173,_174);
}else{
if(!_174){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_174=dj_global;
}
_176=[];
for(var i=0;i<arr.length;i++){
if(_173.call(_174,arr[i],i,arr)){
_176.push(arr[i]);
}
}
}
if(_175){
return _176.join("");
}else{
return _176;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_17b,_17c){
var _17d=[];
for(var i=_17c||0;i<_17b.length;i++){
_17d.push(_17b[i]);
}
return _17d;
}});
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_17f,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _17f.replace(/\%\{(\w+)\}/g,function(_182,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _185=str.split(" ");
for(var i=0;i<_185.length;i++){
_185[i]=_185[i].charAt(0).toUpperCase()+_185[i].substring(1);
}
return _185.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _18a=escape(str);
var _18b,re=/%u([0-9A-F]{4})/i;
while((_18b=_18a.match(re))){
var num=Number("0x"+_18b[1]);
var _18e=escape("&#"+num+";");
ret+=_18a.substring(0,_18b.index)+_18e;
_18a=_18a.substring(_18b.index+_18b[0].length);
}
ret+=_18a.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_193){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_193){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_19c){
if(_19c){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_1a0,_1a1){
if(_1a1){
str=str.toLowerCase();
_1a0=_1a0.toLowerCase();
}
return str.indexOf(_1a0)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_1a7){
if(_1a7=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_1a7=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_1a9){
var _1aa=[];
for(var i=0,_1ac=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_1a9){
_1aa.push(str.substring(_1ac,i));
_1ac=i+1;
}
}
_1aa.push(str.substr(_1ac));
return _1aa;
};
dojo.provide("dojo.AdapterRegistry");
dojo.AdapterRegistry=function(_1ad){
this.pairs=[];
this.returnWrappers=_1ad||false;
};
dojo.lang.extend(dojo.AdapterRegistry,{register:function(name,_1af,wrap,_1b1,_1b2){
var type=(_1b2)?"unshift":"push";
this.pairs[type]([name,_1af,wrap,_1b1]);
},match:function(){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[1].apply(this,arguments)){
if((pair[3])||(this.returnWrappers)){
return pair[2];
}else{
return pair[2].apply(this,arguments);
}
}
}
throw new Error("No match found");
},unregister:function(name){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[0]==name){
this.pairs.splice(i,1);
return true;
}
}
return false;
}});
dojo.provide("dojo.json");
dojo.json={jsonRegistry:new dojo.AdapterRegistry(),register:function(name,_1ba,wrap,_1bc){
dojo.json.jsonRegistry.register(name,_1ba,wrap,_1bc);
},evalJson:function(json){
try{
return eval("("+json+")");
}
catch(e){
dojo.debug(e);
return json;
}
},serialize:function(o){
var _1bf=typeof (o);
if(_1bf=="undefined"){
return "undefined";
}else{
if((_1bf=="number")||(_1bf=="boolean")){
return o+"";
}else{
if(o===null){
return "null";
}
}
}
if(_1bf=="string"){
return dojo.string.escapeString(o);
}
var me=arguments.callee;
var _1c1;
if(typeof (o.__json__)=="function"){
_1c1=o.__json__();
if(o!==_1c1){
return me(_1c1);
}
}
if(typeof (o.json)=="function"){
_1c1=o.json();
if(o!==_1c1){
return me(_1c1);
}
}
if(_1bf!="function"&&typeof (o.length)=="number"){
var res=[];
for(var i=0;i<o.length;i++){
var val=me(o[i]);
if(typeof (val)!="string"){
val="undefined";
}
res.push(val);
}
return "["+res.join(",")+"]";
}
try{
window.o=o;
_1c1=dojo.json.jsonRegistry.match(o);
return me(_1c1);
}
catch(e){
}
if(_1bf=="function"){
return null;
}
res=[];
for(var k in o){
var _1c6;
if(typeof (k)=="number"){
_1c6="\""+k+"\"";
}else{
if(typeof (k)=="string"){
_1c6=dojo.string.escapeString(k);
}else{
continue;
}
}
val=me(o[k]);
if(typeof (val)!="string"){
continue;
}
res.push(_1c6+":"+val);
}
return "{"+res.join(",")+"}";
}};
dojo.provide("dojo.collections.Store");
dojo.collections.Store=function(_1c7){
var data=[];
var _1c9={};
this.keyField="Id";
this.get=function(){
return data;
};
this.getByKey=function(key){
return _1c9[key];
};
this.getByIndex=function(idx){
return data[idx];
};
this.getIndexOf=function(key){
for(var i=0;i<data.length;i++){
if(data[i].key==key){
return i;
}
}
return -1;
};
this.getData=function(){
var arr=[];
for(var i=0;i<data.length;i++){
arr.push(data[i].src);
}
return arr;
};
this.getDataByKey=function(key){
if(_1c9[key]!=null){
return _1c9[key].src;
}
return null;
};
this.getIndexOfData=function(obj){
for(var i=0;i<data.length;i++){
if(data[i].src==obj){
return i;
}
}
return -1;
};
this.getDataByIndex=function(idx){
if(data[idx]){
return data[idx].src;
}
return null;
};
this.update=function(obj,_1d5,val,_1d7){
var _1d8=_1d5.split("."),i=0,o=obj,_1db;
if(_1d8.length>1){
_1db=_1d8.pop();
do{
if(_1d8[i].indexOf("()")>-1){
var temp=_1d8[i++].split("()")[0];
if(!o[temp]){
dojo.raise("dojo.collections.Store.getField(obj, '"+_1db+"'): '"+temp+"' is not a property of the passed object.");
}else{
o=o[temp]();
}
}else{
o=o[_1d8[i++]];
}
}while(i<_1d8.length&&o!=null);
}else{
_1db=_1d8[0];
}
obj[_1db]=val;
if(!_1d7){
this.onUpdateField(obj,_1d5,val);
}
};
this.forEach=function(fn){
if(Array.forEach){
Array.forEach(data,fn,this);
}else{
for(var i=0;i<data.length;i++){
fn.call(this,data[i]);
}
}
};
this.forEachData=function(fn){
if(Array.forEach){
Array.forEach(this.getData(),fn,this);
}else{
var a=this.getData();
for(var i=0;i<a.length;i++){
fn.call(this,a[i]);
}
}
};
this.setData=function(arr,_1e3){
data=[];
for(var i=0;i<arr.length;i++){
var o={key:arr[i][this.keyField],src:arr[i]};
data.push(o);
_1c9[o.key]=o;
}
if(!_1e3){
this.onSetData();
}
};
this.clearData=function(_1e6){
data=[];
_1c9={};
if(!_1e6){
this.onClearData();
}
};
this.addData=function(obj,key,_1e9){
var k=key||obj[this.keyField];
if(_1c9[k]!=null){
var o=_1c9[k];
o.src=obj;
}else{
var o={key:k,src:obj};
data.push(o);
_1c9[o.key]=o;
}
if(!_1e9){
this.onAddData(o);
}
};
this.addDataRange=function(arr,_1ed){
var _1ee=[];
for(var i=0;i<arr.length;i++){
var k=arr[i][this.keyField];
if(_1c9[k]!=null){
var o=_1c9[k];
o.src=arr[i];
}else{
var o={key:k,src:arr[i]};
data.push(o);
_1c9[k]=o;
}
_1ee.push(o);
}
if(!_1ed){
this.onAddDataRange(_1ee);
}
};
this.addDataByIndex=function(obj,idx,key,_1f5){
var k=key||obj[this.keyField];
if(_1c9[k]!=null){
var i=this.getIndexOf(k);
var o=data.splice(i,1);
o.src=obj;
}else{
var o={key:k,src:obj};
_1c9[k]=o;
}
data.splice(idx,0,o);
if(!_1f5){
this.onAddData(o);
}
};
this.addDataRangeByIndex=function(arr,idx,_1fb){
var _1fc=[];
for(var i=0;i<arr.length;i++){
var k=arr[i][this.keyField];
if(_1c9[k]!=null){
var j=this.getIndexOf(k);
var o=data.splice(j,1);
o.src=arr[i];
}else{
var o={key:k,src:arr[i]};
_1c9[k]=o;
}
_1fc.push(o);
}
data.splice(idx,0,_1fc);
if(!_1fb){
this.onAddDataRange(_1fc);
}
};
this.removeData=function(obj,_202){
var idx=-1;
var o=null;
for(var i=0;i<data.length;i++){
if(data[i].src==obj){
idx=i;
o=data[i];
break;
}
}
if(!_202){
this.onRemoveData(o);
}
if(idx>-1){
data.splice(idx,1);
delete _1c9[o.key];
}
};
this.removeDataRange=function(idx,_207,_208){
var ret=data.splice(idx,_207);
for(var i=0;i<ret.length;i++){
delete _1c9[ret[i].key];
}
if(!_208){
this.onRemoveDataRange(ret);
}
return ret;
};
this.removeDataByKey=function(key,_20c){
this.removeData(this.getDataByKey(key),_20c);
};
this.removeDataByIndex=function(idx,_20e){
this.removeData(this.getDataByIndex(idx),_20e);
};
if(_1c7&&_1c7.length&&_1c7[0]){
this.setData(_1c7,true);
}
};
dojo.extend(dojo.collections.Store,{getField:function(obj,_210){
var _211=_210.split("."),i=0,o=obj;
do{
if(_211[i].indexOf("()")>-1){
var temp=_211[i++].split("()")[0];
if(!o[temp]){
dojo.raise("dojo.collections.Store.getField(obj, '"+_210+"'): '"+temp+"' is not a property of the passed object.");
}else{
o=o[temp]();
}
}else{
o=o[_211[i++]];
}
}while(i<_211.length&&o!=null);
if(i<_211.length){
dojo.raise("dojo.collections.Store.getField(obj, '"+_210+"'): '"+_210+"' is not a property of the passed object.");
}
return o;
},getFromHtml:function(meta,body,_217){
var rows=body.rows;
var ctor=function(row){
var obj={};
for(var i=0;i<meta.length;i++){
var o=obj;
var data=row.cells[i].innerHTML;
var p=meta[i].getField();
if(p.indexOf(".")>-1){
p=p.split(".");
while(p.length>1){
var pr=p.shift();
o[pr]={};
o=o[pr];
}
p=p[0];
}
var type=meta[i].getType();
if(type==String){
o[p]=data;
}else{
if(data){
o[p]=new type(data);
}else{
o[p]=new type();
}
}
}
return obj;
};
var arr=[];
for(var i=0;i<rows.length;i++){
var o=ctor(rows[i]);
if(_217){
_217(o,rows[i]);
}
arr.push(o);
}
return arr;
},onSetData:function(){
},onClearData:function(){
},onAddData:function(obj){
},onAddDataRange:function(arr){
},onRemoveData:function(obj){
},onRemoveDataRange:function(arr){
},onUpdateField:function(obj,_22a,val){
}});
dojo.provide("dojo.gfx.color");
dojo.gfx.color.Color=function(r,g,b,a){
if(dojo.lang.isArray(r)){
this.r=r[0];
this.g=r[1];
this.b=r[2];
this.a=r[3]||1;
}else{
if(dojo.lang.isString(r)){
var rgb=dojo.gfx.color.extractRGB(r);
this.r=rgb[0];
this.g=rgb[1];
this.b=rgb[2];
this.a=g||1;
}else{
if(r instanceof dojo.gfx.color.Color){
this.r=r.r;
this.b=r.b;
this.g=r.g;
this.a=r.a;
}else{
this.r=r;
this.g=g;
this.b=b;
this.a=a;
}
}
}
};
dojo.gfx.color.Color.fromArray=function(arr){
return new dojo.gfx.color.Color(arr[0],arr[1],arr[2],arr[3]);
};
dojo.extend(dojo.gfx.color.Color,{toRgb:function(_232){
if(_232){
return this.toRgba();
}else{
return [this.r,this.g,this.b];
}
},toRgba:function(){
return [this.r,this.g,this.b,this.a];
},toHex:function(){
return dojo.gfx.color.rgb2hex(this.toRgb());
},toCss:function(){
return "rgb("+this.toRgb().join()+")";
},toString:function(){
return this.toHex();
},blend:function(_233,_234){
var rgb=null;
if(dojo.lang.isArray(_233)){
rgb=_233;
}else{
if(_233 instanceof dojo.gfx.color.Color){
rgb=_233.toRgb();
}else{
rgb=new dojo.gfx.color.Color(_233).toRgb();
}
}
return dojo.gfx.color.blend(this.toRgb(),rgb,_234);
}});
dojo.gfx.color.named={white:[255,255,255],black:[0,0,0],red:[255,0,0],green:[0,255,0],lime:[0,255,0],blue:[0,0,255],navy:[0,0,128],gray:[128,128,128],silver:[192,192,192]};
dojo.gfx.color.blend=function(a,b,_238){
if(typeof a=="string"){
return dojo.gfx.color.blendHex(a,b,_238);
}
if(!_238){
_238=0;
}
_238=Math.min(Math.max(-1,_238),1);
_238=((_238+1)/2);
var c=[];
for(var x=0;x<3;x++){
c[x]=parseInt(b[x]+((a[x]-b[x])*_238));
}
return c;
};
dojo.gfx.color.blendHex=function(a,b,_23d){
return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a),dojo.gfx.color.hex2rgb(b),_23d));
};
dojo.gfx.color.extractRGB=function(_23e){
var hex="0123456789abcdef";
_23e=_23e.toLowerCase();
if(_23e.indexOf("rgb")==0){
var _240=_23e.match(/rgba*\((\d+), *(\d+), *(\d+)/i);
var ret=_240.splice(1,3);
return ret;
}else{
var _242=dojo.gfx.color.hex2rgb(_23e);
if(_242){
return _242;
}else{
return dojo.gfx.color.named[_23e]||[255,255,255];
}
}
};
dojo.gfx.color.hex2rgb=function(hex){
var _244="0123456789ABCDEF";
var rgb=new Array(3);
if(hex.indexOf("#")==0){
hex=hex.substring(1);
}
hex=hex.toUpperCase();
if(hex.replace(new RegExp("["+_244+"]","g"),"")!=""){
return null;
}
if(hex.length==3){
rgb[0]=hex.charAt(0)+hex.charAt(0);
rgb[1]=hex.charAt(1)+hex.charAt(1);
rgb[2]=hex.charAt(2)+hex.charAt(2);
}else{
rgb[0]=hex.substring(0,2);
rgb[1]=hex.substring(2,4);
rgb[2]=hex.substring(4);
}
for(var i=0;i<rgb.length;i++){
rgb[i]=_244.indexOf(rgb[i].charAt(0))*16+_244.indexOf(rgb[i].charAt(1));
}
return rgb;
};
dojo.gfx.color.rgb2hex=function(r,g,b){
if(dojo.lang.isArray(r)){
g=r[1]||0;
b=r[2]||0;
r=r[0]||0;
}
var ret=dojo.lang.map([r,g,b],function(x){
x=new Number(x);
var s=x.toString(16);
while(s.length<2){
s="0"+s;
}
return s;
});
ret.unshift("#");
return ret.join("");
};
dojo.provide("dojo.gfx.color.hsl");
dojo.lang.extend(dojo.gfx.color.Color,{toHsl:function(){
return dojo.gfx.color.rgb2hsl(this.toRgb());
}});
dojo.gfx.color.rgb2hsl=function(r,g,b){
if(dojo.lang.isArray(r)){
b=r[2]||0;
g=r[1]||0;
r=r[0]||0;
}
r/=255;
g/=255;
b/=255;
var h=null;
var s=null;
var l=null;
var min=Math.min(r,g,b);
var max=Math.max(r,g,b);
var _255=max-min;
l=(min+max)/2;
s=0;
if((l>0)&&(l<1)){
s=_255/((l<0.5)?(2*l):(2-2*l));
}
h=0;
if(_255>0){
if((max==r)&&(max!=g)){
h+=(g-b)/_255;
}
if((max==g)&&(max!=b)){
h+=(2+(b-r)/_255);
}
if((max==b)&&(max!=r)){
h+=(4+(r-g)/_255);
}
h*=60;
}
h=(h==0)?360:Math.ceil((h/360)*255);
s=Math.ceil(s*255);
l=Math.ceil(l*255);
return [h,s,l];
};
dojo.gfx.color.hsl2rgb=function(h,s,l){
if(dojo.lang.isArray(h)){
l=h[2]||0;
s=h[1]||0;
h=h[0]||0;
}
h=(h/255)*360;
if(h==360){
h=0;
}
s=s/255;
l=l/255;
while(h<0){
h+=360;
}
while(h>360){
h-=360;
}
var r,g,b;
if(h<120){
r=(120-h)/60;
g=h/60;
b=0;
}else{
if(h<240){
r=0;
g=(240-h)/60;
b=(h-120)/60;
}else{
r=(h-240)/60;
g=0;
b=(360-h)/60;
}
}
r=Math.min(r,1);
g=Math.min(g,1);
b=Math.min(b,1);
r=2*s*r+(1-s);
g=2*s*g+(1-s);
b=2*s*b+(1-s);
if(l<0.5){
r=l*r;
g=l*g;
b=l*b;
}else{
r=(1-l)*r+2*l-1;
g=(1-l)*g+2*l-1;
b=(1-l)*b+2*l-1;
}
r=Math.ceil(r*255);
g=Math.ceil(g*255);
b=Math.ceil(b*255);
return [r,g,b];
};
dojo.gfx.color.hsl2hex=function(h,s,l){
var rgb=dojo.gfx.color.hsl2rgb(h,s,l);
return dojo.gfx.color.rgb2hex(rgb[0],rgb[1],rgb[2]);
};
dojo.gfx.color.hex2hsl=function(hex){
var rgb=dojo.gfx.color.hex2rgb(hex);
return dojo.gfx.color.rgb2hsl(rgb[0],rgb[1],rgb[2]);
};
dojo.provide("dojo.charting.*");
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _263=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_263.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_265,_266){
var node=_265.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_266&&node&&node.tagName&&node.tagName.toLowerCase()!=_266.toLowerCase()){
node=dojo.dom.nextElement(node,_266);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_268,_269){
var node=_268.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_269&&node&&node.tagName&&node.tagName.toLowerCase()!=_269.toLowerCase()){
node=dojo.dom.prevElement(node,_269);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_26c){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_26c&&_26c.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_26c);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_26e){
if(!node){
return null;
}
if(_26e){
_26e=_26e.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_26e&&_26e.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_26e);
}
return node;
};
dojo.dom.moveChildren=function(_26f,_270,trim){
var _272=0;
if(trim){
while(_26f.hasChildNodes()&&_26f.firstChild.nodeType==dojo.dom.TEXT_NODE){
_26f.removeChild(_26f.firstChild);
}
while(_26f.hasChildNodes()&&_26f.lastChild.nodeType==dojo.dom.TEXT_NODE){
_26f.removeChild(_26f.lastChild);
}
}
while(_26f.hasChildNodes()){
_270.appendChild(_26f.firstChild);
_272++;
}
return _272;
};
dojo.dom.copyChildren=function(_273,_274,trim){
var _276=_273.cloneNode(true);
return this.moveChildren(_276,_274,trim);
};
dojo.dom.replaceChildren=function(node,_278){
var _279=[];
if(dojo.render.html.ie){
for(var i=0;i<node.childNodes.length;i++){
_279.push(node.childNodes[i]);
}
}
dojo.dom.removeChildren(node);
node.appendChild(_278);
for(var i=0;i<_279.length;i++){
dojo.dom.destroyNode(_279[i]);
}
};
dojo.dom.removeChildren=function(node){
var _27c=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _27c;
};
dojo.dom.replaceNode=function(node,_27e){
return node.parentNode.replaceChild(_27e,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.evalObjPath("dojo.event.browser.clean",false)){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_282,_283){
var _284=[];
var _285=(_282&&(_282 instanceof Function||typeof _282=="function"));
while(node){
if(!_285||_282(node)){
_284.push(node);
}
if(_283&&_284.length>0){
return _284[0];
}
node=node.parentNode;
}
if(_283){
return null;
}
return _284;
};
dojo.dom.getAncestorsByTag=function(node,tag,_288){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_288);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_28d,_28e){
if(_28e&&node){
node=node.parentNode;
}
while(node){
if(node==_28d){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _291=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _292=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_292.length;i++){
try{
doc=new ActiveXObject(_292[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_291.implementation)&&(_291.implementation.createDocument)){
doc=_291.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_295){
if(!_295){
_295="text/xml";
}
if(!dj_undef("DOMParser")){
var _296=new DOMParser();
return _296.parseFromString(str,_295);
}else{
if(!dj_undef("ActiveXObject")){
var _297=dojo.dom.createDocument();
if(_297){
_297.async=false;
_297.loadXML(str);
return _297;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _298=dojo.doc();
if(_298.createElement){
var tmp=_298.createElement("xml");
tmp.innerHTML=str;
if(_298.implementation&&_298.implementation.createDocument){
var _29a=_298.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_29a.importNode(tmp.childNodes.item(i),true);
}
return _29a;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_29d){
if(_29d.firstChild){
_29d.insertBefore(node,_29d.firstChild);
}else{
_29d.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_2a0){
if((_2a0!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _2a1=ref.parentNode;
_2a1.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_2a4){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_2a4!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_2a4);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_2a8){
if((!node)||(!ref)||(!_2a8)){
return false;
}
switch(_2a8.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_2aa,_2ab){
var _2ac=_2aa.childNodes;
if(!_2ac.length||_2ac.length==_2ab){
_2aa.appendChild(node);
return true;
}
if(_2ab==0){
return dojo.dom.prependChild(node,_2aa);
}
return dojo.dom.insertAfter(node,_2ac[_2ab-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _2af=dojo.doc();
dojo.dom.replaceChildren(node,_2af.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _2b0="";
if(node==null){
return _2b0;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_2b0+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_2b0+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _2b0;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_2b6,_2b7,_2b8){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_2b6,_2b7,_2b8);
}else{
var _2b9=elem.ownerDocument;
var _2ba=_2b9.createNode(2,_2b7,_2b6);
_2ba.nodeValue=_2b8;
elem.setAttributeNode(_2ba);
}
};
dojo.provide("dojo.svg");
dojo.mixin(dojo.svg,dojo.dom);
dojo.svg.graphics=dojo.svg.g=new function(d){
this.suspend=function(){
try{
d.documentElement.suspendRedraw(0);
}
catch(e){
}
};
this.resume=function(){
try{
d.documentElement.unsuspendRedraw(0);
}
catch(e){
}
};
this.force=function(){
try{
d.documentElement.forceRedraw();
}
catch(e){
}
};
}(document);
dojo.svg.animations=dojo.svg.anim=new function(d){
this.arePaused=function(){
try{
return d.documentElement.animationsPaused();
}
catch(e){
return false;
}
};
this.pause=function(){
try{
d.documentElement.pauseAnimations();
}
catch(e){
}
};
this.resume=function(){
try{
d.documentElement.unpauseAnimations();
}
catch(e){
}
};
}(document);
dojo.svg.toCamelCase=function(_2bd){
var arr=_2bd.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.svg.toSelectorCase=function(_2c1){
return _2c1.replace(/([A-Z])/g,"-$1").toLowerCase();
};
dojo.svg.getStyle=function(node,_2c3){
return document.defaultView.getComputedStyle(node,_2c3);
};
dojo.svg.getNumericStyle=function(node,_2c5){
return parseFloat(dojo.svg.getStyle(node,_2c5));
};
dojo.svg.getOpacity=function(node){
return Math.min(1,dojo.svg.getNumericStyle(node,"fill-opacity"));
};
dojo.svg.setOpacity=function(node,_2c8){
node.setAttributeNS(this.xmlns.svg,"fill-opacity",_2c8);
node.setAttributeNS(this.xmlns.svg,"stroke-opacity",_2c8);
};
dojo.svg.clearOpacity=function(node){
node.setAttributeNS(this.xmlns.svg,"fill-opacity","1.0");
node.setAttributeNS(this.xmlns.svg,"stroke-opacity","1.0");
};
dojo.svg.getCoords=function(node){
if(node.getBBox){
var box=node.getBBox();
return {x:box.x,y:box.y};
}
return null;
};
dojo.svg.setCoords=function(node,_2cd){
var p=dojo.svg.getCoords();
if(!p){
return;
}
var dx=p.x-_2cd.x;
var dy=p.y-_2cd.y;
dojo.svg.translate(node,dx,dy);
};
dojo.svg.getDimensions=function(node){
if(node.getBBox){
var box=node.getBBox();
return {width:box.width,height:box.height};
}
return null;
};
dojo.svg.setDimensions=function(node,dim){
if(node.width){
node.width.baseVal.value=dim.width;
node.height.baseVal.value=dim.height;
}else{
if(node.r){
node.r.baseVal.value=Math.min(dim.width,dim.height)/2;
}else{
if(node.rx){
node.rx.baseVal.value=dim.width/2;
node.ry.baseVal.value=dim.height/2;
}
}
}
};
dojo.svg.translate=function(node,dx,dy){
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var t=node.ownerSVGElement.createSVGTransform();
t.setTranslate(dx,dy);
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.scale=function(node,_2da,_2db){
if(!_2db){
var _2db=_2da;
}
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var t=node.ownerSVGElement.createSVGTransform();
t.setScale(_2da,_2db);
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.rotate=function(node,ang,cx,cy){
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var t=node.ownerSVGElement.createSVGTransform();
if(cx==null){
t.setMatrix(t.matrix.rotate(ang));
}else{
t.setRotate(ang,cx,cy);
}
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.skew=function(node,ang,axis){
var dir=axis||"x";
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var t=node.ownerSVGElement.createSVGTransform();
if(dir!="x"){
t.setSkewY(ang);
}else{
t.setSkewX(ang);
}
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.flip=function(node,axis){
var dir=axis||"x";
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var t=node.ownerSVGElement.createSVGTransform();
t.setMatrix((dir!="x")?t.matrix.flipY():t.matrix.flipX());
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.invert=function(node){
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var t=node.ownerSVGElement.createSVGTransform();
t.setMatrix(t.matrix.inverse());
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.applyMatrix=function(node,a,b,c,d,e,f){
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var m;
if(b){
var m=node.ownerSVGElement.createSVGMatrix();
m.a=a;
m.b=b;
m.c=c;
m.d=d;
m.e=e;
m.f=f;
}else{
m=a;
}
var t=node.ownerSVGElement.createSVGTransform();
t.setMatrix(m);
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.group=function(_2f6){
var p=_2f6.item(0).parentNode;
var g=document.createElementNS(this.xmlns.svg,"g");
for(var i=0;i<_2f6.length;i++){
g.appendChild(_2f6.item(i));
}
p.appendChild(g);
return g;
};
dojo.svg.ungroup=function(g){
var p=g.parentNode;
while(g.childNodes.length>0){
p.appendChild(g.childNodes.item(0));
}
p.removeChild(g);
};
dojo.svg.getGroup=function(node){
var a=this.getAncestors(node);
for(var i=0;i<a.length;i++){
if(a[i].nodeType==this.ELEMENT_NODE&&a[i].nodeName.toLowerCase()=="g"){
return a[i];
}
}
return null;
};
dojo.svg.bringToFront=function(node){
var n=this.getGroup(node)||node;
n.ownerSVGElement.appendChild(n);
};
dojo.svg.sendToBack=function(node){
var n=this.getGroup(node)||node;
n.ownerSVGElement.insertBefore(n,n.ownerSVGElement.firstChild);
};
dojo.svg.bringForward=function(node){
var n=this.getGroup(node)||node;
if(this.getLastChildElement(n.parentNode)!=n){
this.insertAfter(n,this.getNextSiblingElement(n),true);
}
};
dojo.svg.sendBackward=function(node){
var n=this.getGroup(node)||node;
if(this.getFirstChildElement(n.parentNode)!=n){
this.insertBefore(n,this.getPreviousSiblingElement(n),true);
}
};
dojo.svg.createNodesFromText=function(txt,wrap){
var _309=(new DOMParser()).parseFromString(txt,"text/xml").normalize();
if(wrap){
return [_309.firstChild.cloneNode(true)];
}
var _30a=[];
for(var x=0;x<_309.childNodes.length;x++){
_30a.push(_309.childNodes.item(x).cloneNode(true));
}
return _30a;
};
dojo.provide("dojo.charting.Axis");
dojo.charting.Axis=function(_30c,_30d,_30e){
var id="dojo-charting-axis-"+dojo.charting.Axis.count++;
this.getId=function(){
return id;
};
this.setId=function(key){
id=key;
};
this.scale=_30d||"linear";
this.label=_30c||"";
this.showLabel=true;
this.showLabels=true;
this.showLines=false;
this.showTicks=false;
this.range={upper:100,lower:0};
this.origin="min";
this._origin=null;
this.labels=_30e||[];
this._labels=[];
this.nodes={main:null,axis:null,label:null,labels:null,lines:null,ticks:null};
this._rerender=false;
};
dojo.charting.Axis.count=0;
dojo.extend(dojo.charting.Axis,{getCoord:function(val,_312,plot){
val=parseFloat(val,10);
var area=_312.getArea();
if(plot.axisX==this){
var _315=0-this.range.lower;
var min=this.range.lower+_315;
var max=this.range.upper+_315;
val+=_315;
return (val*((area.right-area.left)/max))+area.left;
}else{
var max=this.range.upper;
var min=this.range.lower;
var _315=0;
if(min<0){
_315+=Math.abs(min);
}
max+=_315;
min+=_315;
val+=_315;
var pmin=area.bottom;
var pmax=area.top;
return (((pmin-pmax)/(max-min))*(max-val))+pmax;
}
},initializeOrigin:function(_31a,_31b){
if(this._origin==null){
this._origin=this.origin;
}
if(isNaN(this._origin)){
if(this._origin.toLowerCase()=="max"){
this.origin=_31a.range[(_31b=="y")?"upper":"lower"];
}else{
if(this._origin.toLowerCase()=="min"){
this.origin=_31a.range[(_31b=="y")?"lower":"upper"];
}else{
this.origin=0;
}
}
}
},initializeLabels:function(){
this._labels=[];
if(this.labels.length==0){
this.showLabels=false;
this.showLines=false;
this.showTicks=false;
}else{
if(this.labels[0].label&&this.labels[0].value!=null){
for(var i=0;i<this.labels.length;i++){
this._labels.push(this.labels[i]);
}
}else{
if(!isNaN(this.labels[0])){
for(var i=0;i<this.labels.length;i++){
this._labels.push({label:this.labels[i],value:this.labels[i]});
}
}else{
var a=[];
for(var i=0;i<this.labels.length;i++){
a.push(this.labels[i]);
}
var s=a.shift();
this._labels.push({label:s,value:this.range.lower});
if(a.length>0){
var s=a.pop();
this._labels.push({label:s,value:this.range.upper});
}
if(a.length>0){
var _31f=this.range.upper-this.range.lower;
var step=_31f/(this.labels.length-1);
for(var i=1;i<=a.length;i++){
this._labels.push({label:a[i-1],value:this.range.lower+(step*i)});
}
}
}
}
}
},initialize:function(_321,plot,_323,_324){
this.destroy();
this.initializeOrigin(_323,_324);
this.initializeLabels();
var node=this.render(_321,plot,_323,_324);
return node;
},destroy:function(){
for(var p in this.nodes){
while(this.nodes[p]&&this.nodes[p].childNodes.length>0){
this.nodes[p].removeChild(this.nodes[p].childNodes[0]);
}
if(this.nodes[p]&&this.nodes[p].parentNode){
this.nodes[p].parentNode.removeChild(this.nodes[p]);
}
this.nodes[p]=null;
}
}});
dojo.requireIf(dojo.render.svg.capable,"dojo.charting.svg.Axis");
dojo.requireIf(dojo.render.vml.capable,"dojo.charting.vml.Axis");
dojo.provide("dojo.charting.svg.Axis");
if(dojo.render.svg.capable){
dojo.extend(dojo.charting.Axis,{renderLines:function(_327,plot,_329){
if(this.nodes.lines){
while(this.nodes.lines.childNodes.length>0){
this.nodes.lines.removeChild(this.nodes.lines.childNodes[0]);
}
if(this.nodes.lines.parentNode){
this.nodes.lines.parentNode.removeChild(this.nodes.lines);
this.nodes.lines=null;
}
}
var area=_327.getArea();
var g=this.nodes.lines=document.createElementNS(dojo.svg.xmlns.svg,"g");
g.setAttribute("id",this.getId()+"-lines");
for(var i=0;i<this._labels.length;i++){
if(this._labels[i].value==this.origin){
continue;
}
var v=this.getCoord(this._labels[i].value,_327,plot);
var l=document.createElementNS(dojo.svg.xmlns.svg,"line");
l.setAttribute("style","stroke:#999;stroke-width:1px;stroke-dasharray:1,4;");
if(_329=="x"){
l.setAttribute("y1",area.top);
l.setAttribute("y2",area.bottom);
l.setAttribute("x1",v);
l.setAttribute("x2",v);
}else{
if(_329=="y"){
l.setAttribute("y1",v);
l.setAttribute("y2",v);
l.setAttribute("x1",area.left);
l.setAttribute("x2",area.right);
}
}
g.appendChild(l);
}
return g;
},renderTicks:function(_32f,plot,_331,_332){
if(this.nodes.ticks){
while(this.nodes.ticks.childNodes.length>0){
this.nodes.ticks.removeChild(this.nodes.ticks.childNodes[0]);
}
if(this.nodes.ticks.parentNode){
this.nodes.ticks.parentNode.removeChild(this.nodes.ticks);
this.nodes.ticks=null;
}
}
var g=this.nodes.ticks=document.createElementNS(dojo.svg.xmlns.svg,"g");
g.setAttribute("id",this.getId()+"-ticks");
for(var i=0;i<this._labels.length;i++){
var v=this.getCoord(this._labels[i].value,_32f,plot);
var l=document.createElementNS(dojo.svg.xmlns.svg,"line");
l.setAttribute("style","stroke:#000;stroke-width:1pt;");
if(_331=="x"){
l.setAttribute("y1",_332);
l.setAttribute("y2",_332+3);
l.setAttribute("x1",v);
l.setAttribute("x2",v);
}else{
if(_331=="y"){
l.setAttribute("y1",v);
l.setAttribute("y2",v);
l.setAttribute("x1",_332-2);
l.setAttribute("x2",_332+2);
}
}
g.appendChild(l);
}
return g;
},renderLabels:function(_337,plot,_339,_33a,_33b,_33c){
function createLabel(_33d,x,y,_340,_341){
var text=document.createElementNS(dojo.svg.xmlns.svg,"text");
text.setAttribute("x",x);
text.setAttribute("y",(_339=="x"?y:y+2));
text.setAttribute("style","text-anchor:"+_341+";font-family:sans-serif;font-size:"+_340+"px;fill:#000;");
text.appendChild(document.createTextNode(_33d));
return text;
}
if(this.nodes.labels){
while(this.nodes.labels.childNodes.length>0){
this.nodes.labels.removeChild(this.nodes.labels.childNodes[0]);
}
if(this.nodes.labels.parentNode){
this.nodes.labels.parentNode.removeChild(this.nodes.labels);
this.nodes.labels=null;
}
}
var g=this.nodes.labels=document.createElementNS(dojo.svg.xmlns.svg,"g");
g.setAttribute("id",this.getId()+"-labels");
for(var i=0;i<this._labels.length;i++){
var v=this.getCoord(this._labels[i].value,_337,plot);
if(_339=="x"){
g.appendChild(createLabel(this._labels[i].label,v,_33a,_33b,_33c));
}else{
if(_339=="y"){
g.appendChild(createLabel(this._labels[i].label,_33a,v,_33b,_33c));
}
}
}
return g;
},render:function(_346,plot,_348,_349){
if(!this._rerender&&this.nodes.main){
return this.nodes.main;
}
this._rerender=false;
var area=_346.getArea();
var _34b=1;
var _34c="stroke:#000;stroke-width:"+_34b+"px;";
var _34d=10;
var _34e=_348.getCoord(this.origin,_346,plot);
this.nodes.main=document.createElementNS(dojo.svg.xmlns.svg,"g");
var g=this.nodes.main;
g.setAttribute("id",this.getId());
var line=this.nodes.axis=document.createElementNS(dojo.svg.xmlns.svg,"line");
if(_349=="x"){
line.setAttribute("y1",_34e);
line.setAttribute("y2",_34e);
line.setAttribute("x1",area.left-_34b);
line.setAttribute("x2",area.right+_34b);
line.setAttribute("style",_34c);
var y=_34e+_34d+2;
if(this.showLines){
g.appendChild(this.renderLines(_346,plot,_349,y));
}
if(this.showTicks){
g.appendChild(this.renderTicks(_346,plot,_349,_34e));
}
if(this.showLabels){
g.appendChild(this.renderLabels(_346,plot,_349,y,_34d,"middle"));
}
if(this.showLabel&&this.label){
var x=_346.size.width/2;
var text=document.createElementNS(dojo.svg.xmlns.svg,"text");
text.setAttribute("x",x);
text.setAttribute("y",(_34e+(_34d*2)+(_34d/2)));
text.setAttribute("style","text-anchor:middle;font-family:sans-serif;font-weight:bold;font-size:"+(_34d+2)+"px;fill:#000;");
text.appendChild(document.createTextNode(this.label));
g.appendChild(text);
}
}else{
line.setAttribute("x1",_34e);
line.setAttribute("x2",_34e);
line.setAttribute("y1",area.top);
line.setAttribute("y2",area.bottom);
line.setAttribute("style",_34c);
var _354=this.origin==_348.range.upper;
var x=_34e+(_354?4:-4);
var _355=_354?"start":"end";
if(this.showLines){
g.appendChild(this.renderLines(_346,plot,_349,x));
}
if(this.showTicks){
g.appendChild(this.renderTicks(_346,plot,_349,_34e));
}
if(this.showLabels){
g.appendChild(this.renderLabels(_346,plot,_349,x,_34d,_355));
}
if(this.showLabel&&this.label){
var x=_354?(_34e+(_34d*2)+(_34d/2)):(_34e-(_34d*4));
var y=_346.size.height/2;
var text=document.createElementNS(dojo.svg.xmlns.svg,"text");
text.setAttribute("x",x);
text.setAttribute("y",y);
text.setAttribute("transform","rotate(90, "+x+", "+y+")");
text.setAttribute("style","text-anchor:middle;font-family:sans-serif;font-weight:bold;font-size:"+(_34d+2)+"px;fill:#000;");
text.appendChild(document.createTextNode(this.label));
g.appendChild(text);
}
}
g.appendChild(line);
return g;
}});
}
dojo.provide("dojo.charting.vml.Axis");
if(dojo.render.vml.capable){
dojo.extend(dojo.charting.Axis,{renderLines:function(_356,plot,_358){
if(this.nodes.lines){
while(this.nodes.lines.childNodes.length>0){
this.nodes.lines.removeChild(this.nodes.lines.childNodes[0]);
}
if(this.nodes.lines.parentNode){
this.nodes.lines.parentNode.removeChild(this.nodes.lines);
this.nodes.lines=null;
}
}
var area=_356.getArea();
var g=this.nodes.lines=document.createElement("div");
g.setAttribute("id",this.getId()+"-lines");
for(var i=0;i<this._labels.length;i++){
if(this._labels[i].value==this.origin){
continue;
}
var v=this.getCoord(this._labels[i].value,_356,plot);
var l=document.createElement("v:line");
var str=document.createElement("v:stroke");
str.dashstyle="dot";
l.appendChild(str);
l.setAttribute("strokecolor","#666");
l.setAttribute("strokeweight","1px");
var s=l.style;
s.position="absolute";
s.top="0px";
s.left="0px";
s.antialias="false";
if(_358=="x"){
l.setAttribute("from",v+"px,"+area.top+"px");
l.setAttribute("to",v+"px,"+area.bottom+"px");
}else{
if(_358=="y"){
l.setAttribute("from",area.left+"px,"+v+"px");
l.setAttribute("to",area.right+"px,"+v+"px");
}
}
g.appendChild(l);
}
return g;
},renderTicks:function(_360,plot,_362,_363){
if(this.nodes.ticks){
while(this.nodes.ticks.childNodes.length>0){
this.nodes.ticks.removeChild(this.nodes.ticks.childNodes[0]);
}
if(this.nodes.ticks.parentNode){
this.nodes.ticks.parentNode.removeChild(this.nodes.ticks);
this.nodes.ticks=null;
}
}
var g=this.nodes.ticks=document.createElement("div");
g.setAttribute("id",this.getId()+"-ticks");
for(var i=0;i<this._labels.length;i++){
var v=this.getCoord(this._labels[i].value,_360,plot);
var l=document.createElement("v:line");
l.setAttribute("strokecolor","#000");
l.setAttribute("strokeweight","1px");
var s=l.style;
s.position="absolute";
s.top="0px";
s.left="0px";
s.antialias="false";
if(_362=="x"){
l.setAttribute("from",v+"px,"+_363+"px");
l.setAttribute("to",v+"px,"+(_363+3)+"px");
}else{
if(_362=="y"){
l.setAttribute("from",(_363-2)+"px,"+v+"px");
l.setAttribute("to",(_363+2)+"px,"+v+"px");
}
}
g.appendChild(l);
}
return g;
},renderLabels:function(_369,plot,_36b,_36c,_36d,_36e){
function createLabel(_36f,x,y,_372,_373){
var text=document.createElement("div");
var s=text.style;
text.innerHTML=_36f;
s.fontSize=_372+"px";
s.fontFamily="sans-serif";
s.position="absolute";
s.top=y+"px";
if(_373=="center"){
s.left=x+"px";
s.textAlign="center";
}else{
if(_373=="left"){
s.left=x+"px";
s.textAlign="left";
}else{
if(_373=="right"){
s.right=x+"px";
s.textAlign="right";
}
}
}
return text;
}
if(this.nodes.labels){
while(this.nodes.labels.childNodes.length>0){
this.nodes.labels.removeChild(this.nodes.labels.childNodes[0]);
}
if(this.nodes.labels.parentNode){
this.nodes.labels.parentNode.removeChild(this.nodes.labels);
this.nodes.labels=null;
}
}
var g=this.nodes.labels=document.createElement("div");
g.setAttribute("id",this.getId()+"-labels");
for(var i=0;i<this._labels.length;i++){
var v=this.getCoord(this._labels[i].value,_369,plot);
if(_36b=="x"){
var node=createLabel(this._labels[i].label,v,_36c,_36d,_36e);
document.body.appendChild(node);
node.style.left=v-(node.offsetWidth/2)+"px";
g.appendChild(node);
}else{
if(_36b=="y"){
var node=createLabel(this._labels[i].label,_36c,v,_36d,_36e);
document.body.appendChild(node);
node.style.top=v-(node.offsetHeight/2)+"px";
g.appendChild(node);
}
}
}
return g;
},render:function(_37a,plot,_37c,_37d){
if(!this._rerender&&this.nodes.main){
return this.nodes.main;
}
this._rerender=false;
var area=_37a.getArea();
var _37f=1;
var _380="stroke:#000;stroke-width:"+_37f+"px;";
var _381=10;
var _382=_37c.getCoord(this.origin,_37a,plot);
var g=this.nodes.main=document.createElement("div");
g.setAttribute("id",this.getId());
var line=this.nodes.axis=document.createElement("v:line");
line.setAttribute("strokecolor","#000");
line.setAttribute("strokeweight",_37f+"px");
var s=line.style;
s.position="absolute";
s.top="0px";
s.left="0px";
s.antialias="false";
if(_37d=="x"){
line.setAttribute("from",area.left+"px,"+_382+"px");
line.setAttribute("to",area.right+"px,"+_382+"px");
var y=_382+Math.floor(_381/2);
if(this.showLines){
g.appendChild(this.renderLines(_37a,plot,_37d,y));
}
if(this.showTicks){
g.appendChild(this.renderTicks(_37a,plot,_37d,_382));
}
if(this.showLabels){
g.appendChild(this.renderLabels(_37a,plot,_37d,y,_381,"center"));
}
if(this.showLabel&&this.label){
var x=_37a.size.width/2;
var y=_382+Math.round(_381*1.5);
var text=document.createElement("div");
var s=text.style;
text.innerHTML=this.label;
s.fontSize=(_381+2)+"px";
s.fontFamily="sans-serif";
s.fontWeight="bold";
s.position="absolute";
s.top=y+"px";
s.left=x+"px";
s.textAlign="center";
document.body.appendChild(text);
text.style.left=x-(text.offsetWidth/2)+"px";
g.appendChild(text);
}
}else{
line.setAttribute("from",_382+"px,"+area.top+"px");
line.setAttribute("to",_382+"px,"+area.bottom+"px");
var _389=this.origin==_37c.range.upper;
var x=_382+4;
var _38a="left";
if(!_389){
x=area.right-_382+_381+4;
_38a="right";
if(_382==area.left){
x+=(_381*2)-(_381/2);
}
}
if(this.showLines){
g.appendChild(this.renderLines(_37a,plot,_37d,x));
}
if(this.showTicks){
g.appendChild(this.renderTicks(_37a,plot,_37d,_382));
}
if(this.showLabels){
g.appendChild(this.renderLabels(_37a,plot,_37d,x,_381,_38a));
}
if(this.showLabel&&this.label){
x+=(_381*2)-2;
var y=_37a.size.height/2;
var text=document.createElement("div");
var s=text.style;
text.innerHTML=this.label;
s.fontSize=(_381+2)+"px";
s.fontFamily="sans-serif";
s.fontWeight="bold";
s.position="absolute";
s.height=_37a.size.height+"px";
s.writingMode="tb-rl";
s.textAlign="center";
s[_38a]=x+"px";
document.body.appendChild(text);
s.top=y-(text.offsetHeight/2)+"px";
g.appendChild(text);
}
}
g.appendChild(line);
return g;
}});
}
dojo.provide("dojo.charting.Plotters");
dojo.requireIf(dojo.render.svg.capable,"dojo.charting.svg.Plotters");
dojo.requireIf(dojo.render.vml.capable,"dojo.charting.vml.Plotters");
dojo.provide("dojo.charting.svg.Plotters");
if(dojo.render.svg.capable){
dojo.mixin(dojo.charting.Plotters,{Bar:function(_38b,plot,_38d,_38e){
var area=_38b.getArea();
var _390=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=plot.series.length;
var data=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_38d);
data.push(tmp);
}
var _395=8;
var _396=data[0].length;
if(_396==0){
return _390;
}
var _397=((area.right-area.left)-(_395*(_396-1)))/_396;
var _398=_397/n;
var _399=plot.axisY.getCoord(plot.axisX.origin,_38b,plot);
for(var i=0;i<_396;i++){
var _39a=area.left+(_397*i)+(_395*i);
for(var j=0;j<n;j++){
var _39c=data[j][i].y;
var yA=_399;
var x=_39a+(_398*j);
var y=plot.axisY.getCoord(_39c,_38b,plot);
var h=Math.abs(yA-y);
if(_39c<plot.axisX.origin){
yA=y;
y=_399;
}
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[j][i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",x);
bar.setAttribute("y",y);
bar.setAttribute("width",_398);
bar.setAttribute("height",h);
bar.setAttribute("fill-opacity","0.6");
if(_38e){
_38e(bar,data[j][i].src);
}
_390.appendChild(bar);
}
}
return _390;
},HorizontalBar:function(_3a2,plot,_3a4,_3a5){
var area=_3a2.getArea();
var _3a7=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=plot.series.length;
var data=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_3a4);
data.push(tmp);
}
var _3ac=6;
var _3ad=data[0].length;
if(_3ad==0){
return _3a7;
}
var h=((area.bottom-area.top)-(_3ac*(_3ad-1)))/_3ad;
var barH=h/n;
var _3b0=plot.axisX.getCoord(0,_3a2,plot);
for(var i=0;i<_3ad;i++){
var _3b1=area.top+(h*i)+(_3ac*i);
for(var j=0;j<n;j++){
var _3b3=data[j][i].y;
var y=_3b1+(barH*j);
var xA=_3b0;
var x=plot.axisX.getCoord(_3b3,_3a2,plot);
var w=Math.abs(x-xA);
if(_3b3>0){
x=_3b0;
}
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[j][i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",xA);
bar.setAttribute("y",y);
bar.setAttribute("width",w);
bar.setAttribute("height",barH);
bar.setAttribute("fill-opacity","0.6");
if(_3a5){
_3a5(bar,data[j][i].src);
}
_3a7.appendChild(bar);
}
}
return _3a7;
},Gantt:function(_3b9,plot,_3bb,_3bc){
var area=_3b9.getArea();
var _3be=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=plot.series.length;
var data=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_3bb);
data.push(tmp);
}
var _3c3=2;
var _3c4=data[0].length;
if(_3c4==0){
return _3be;
}
var h=((area.bottom-area.top)-(_3c3*(_3c4-1)))/_3c4;
var barH=h/n;
for(var i=0;i<_3c4;i++){
var _3c7=area.top+(h*i)+(_3c3*i);
for(var j=0;j<n;j++){
var high=data[j][i].high;
var low=data[j][i].low;
if(low>high){
var t=high;
high=low;
low=t;
}
var x=plot.axisX.getCoord(low,_3b9,plot);
var w=plot.axisX.getCoord(high,_3b9,plot)-x;
var y=_3c7+(barH*j);
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[j][i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",x);
bar.setAttribute("y",y);
bar.setAttribute("width",w);
bar.setAttribute("height",barH);
bar.setAttribute("fill-opacity","0.6");
if(_3bc){
_3bc(bar,data[j][i].src);
}
_3be.appendChild(bar);
}
}
return _3be;
},StackedArea:function(_3d0,plot,_3d2,_3d3){
var area=_3d0.getArea();
var _3d5=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=plot.series.length;
var data=[];
var _3d8=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_3d2);
for(var j=0;j<tmp.length;j++){
if(i==0){
_3d8.push(tmp[j].y);
}else{
_3d8[j]+=tmp[j].y;
}
tmp[j].y=_3d8[j];
}
data.push(tmp);
}
for(var i=n-1;i>=0;i--){
var path=document.createElementNS(dojo.svg.xmlns.svg,"path");
path.setAttribute("fill",data[i][0].series.color);
path.setAttribute("fill-opacity","0.4");
path.setAttribute("stroke",data[i][0].series.color);
path.setAttribute("stroke-width","1");
path.setAttribute("stroke-opacity","0.85");
var cmd=[];
var r=3;
for(var j=0;j<data[i].length;j++){
var _3df=data[i];
var x=plot.axisX.getCoord(_3df[j].x,_3d0,plot);
var y=plot.axisY.getCoord(_3df[j].y,_3d0,plot);
if(j==0){
cmd.push("M");
}else{
cmd.push("L");
}
cmd.push(x+","+y);
var c=document.createElementNS(dojo.svg.xmlns.svg,"circle");
c.setAttribute("cx",x);
c.setAttribute("cy",y);
c.setAttribute("r","3");
c.setAttribute("fill",_3df[j].series.color);
c.setAttribute("fill-opacity","0.6");
c.setAttribute("stroke-width","1");
c.setAttribute("stroke-opacity","0.85");
_3d5.appendChild(c);
if(_3d3){
_3d3(c,data[i].src);
}
}
if(i==0){
cmd.push("L");
cmd.push(x+","+plot.axisY.getCoord(plot.axisX.origin,_3d0,plot));
cmd.push("L");
cmd.push(plot.axisX.getCoord(data[0][0].x,_3d0,plot)+","+plot.axisY.getCoord(plot.axisX.origin,_3d0,plot));
cmd.push("Z");
}else{
var _3df=data[i-1];
cmd.push("L");
cmd.push(x+","+Math.round(plot.axisY.getCoord(_3df[_3df.length-1].y,_3d0,plot)));
for(var j=_3df.length-2;j>=0;j--){
var x=plot.axisX.getCoord(_3df[j].x,_3d0,plot);
var y=plot.axisY.getCoord(_3df[j].y,_3d0,plot);
cmd.push("L");
cmd.push(x+","+y);
}
}
path.setAttribute("d",cmd.join(" ")+" Z");
_3d5.appendChild(path);
}
return _3d5;
},StackedCurvedArea:function(_3e3,plot,_3e5,_3e6){
var _3e7=3;
var area=_3e3.getArea();
var _3e9=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=plot.series.length;
var data=[];
var _3ec=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_3e5);
for(var j=0;j<tmp.length;j++){
if(i==0){
_3ec.push(tmp[j].y);
}else{
_3ec[j]+=tmp[j].y;
}
tmp[j].y=_3ec[j];
}
data.push(tmp);
}
for(var i=n-1;i>=0;i--){
var path=document.createElementNS(dojo.svg.xmlns.svg,"path");
path.setAttribute("fill",data[i][0].series.color);
path.setAttribute("fill-opacity","0.4");
path.setAttribute("stroke",data[i][0].series.color);
path.setAttribute("stroke-width","1");
path.setAttribute("stroke-opacity","0.85");
var cmd=[];
var r=3;
for(var j=0;j<data[i].length;j++){
var _3f3=data[i];
var x=plot.axisX.getCoord(_3f3[j].x,_3e3,plot);
var y=plot.axisY.getCoord(_3f3[j].y,_3e3,plot);
var dx=area.left+1;
var dy=area.bottom;
if(j>0){
dx=x-plot.axisX.getCoord(_3f3[j-1].x,_3e3,plot);
dy=plot.axisY.getCoord(_3f3[j-1].y,_3e3,plot);
}
if(j==0){
cmd.push("M");
}else{
cmd.push("C");
var cx=x-(_3e7-1)*(dx/_3e7);
cmd.push(cx+","+dy);
cx=x-(dx/_3e7);
cmd.push(cx+","+y);
}
cmd.push(x+","+y);
var c=document.createElementNS(dojo.svg.xmlns.svg,"circle");
c.setAttribute("cx",x);
c.setAttribute("cy",y);
c.setAttribute("r","3");
c.setAttribute("fill",_3f3[j].series.color);
c.setAttribute("fill-opacity","0.6");
c.setAttribute("stroke-width","1");
c.setAttribute("stroke-opacity","0.85");
_3e9.appendChild(c);
if(_3e6){
_3e6(c,data[i].src);
}
}
if(i==0){
cmd.push("L");
cmd.push(x+","+plot.axisY.getCoord(plot.axisX.origin,_3e3,plot));
cmd.push("L");
cmd.push(plot.axisX.getCoord(data[0][0].x,_3e3,plot)+","+plot.axisY.getCoord(plot.axisX.origin,_3e3,plot));
cmd.push("Z");
}else{
var _3f3=data[i-1];
cmd.push("L");
cmd.push(x+","+Math.round(plot.axisY.getCoord(_3f3[_3f3.length-1].y,_3e3,plot)));
for(var j=_3f3.length-2;j>=0;j--){
var x=plot.axisX.getCoord(_3f3[j].x,_3e3,plot);
var y=plot.axisY.getCoord(_3f3[j].y,_3e3,plot);
var dx=x-plot.axisX.getCoord(_3f3[j+1].x,_3e3,plot);
var dy=plot.axisY.getCoord(_3f3[j+1].y,_3e3,plot);
cmd.push("C");
var cx=x-(_3e7-1)*(dx/_3e7);
cmd.push(cx+","+dy);
cx=x-(dx/_3e7);
cmd.push(cx+","+y);
cmd.push(x+","+y);
}
}
path.setAttribute("d",cmd.join(" ")+" Z");
_3e9.appendChild(path);
}
return _3e9;
},DataBar:function(data,_3fb,plot,_3fd){
var area=_3fb.getArea();
var _3ff=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=data.length;
var w=(area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower);
var _402=plot.axisY.getCoord(plot.axisX.origin,_3fb,plot);
for(var i=0;i<n;i++){
var _404=data[i].y;
var yA=_402;
var x=plot.axisX.getCoord(data[i].x,_3fb,plot)-(w/2);
var y=plot.axisY.getCoord(_404,_3fb,plot);
var h=Math.abs(yA-y);
if(_404<plot.axisX.origin){
yA=y;
y=_402;
}
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",x);
bar.setAttribute("y",y);
bar.setAttribute("width",w);
bar.setAttribute("height",h);
bar.setAttribute("fill-opacity","0.6");
if(_3fd){
_3fd(bar,data[i].src);
}
_3ff.appendChild(bar);
}
return _3ff;
},Line:function(data,_40b,plot,_40d){
var area=_40b.getArea();
var line=document.createElementNS(dojo.svg.xmlns.svg,"g");
if(data.length==0){
return line;
}
var path=document.createElementNS(dojo.svg.xmlns.svg,"path");
line.appendChild(path);
path.setAttribute("fill","none");
path.setAttribute("stroke",data[0].series.color);
path.setAttribute("stroke-width","2");
path.setAttribute("stroke-opacity","0.85");
if(data[0].series.label!=null){
path.setAttribute("title",data[0].series.label);
}
var cmd=[];
for(var i=0;i<data.length;i++){
var x=plot.axisX.getCoord(data[i].x,_40b,plot);
var y=plot.axisY.getCoord(data[i].y,_40b,plot);
if(i==0){
cmd.push("M");
}else{
cmd.push("L");
}
cmd.push(x+","+y);
var c=document.createElementNS(dojo.svg.xmlns.svg,"circle");
c.setAttribute("cx",x);
c.setAttribute("cy",y);
c.setAttribute("r","3");
c.setAttribute("fill",data[i].series.color);
c.setAttribute("fill-opacity","0.6");
c.setAttribute("stroke-width","1");
c.setAttribute("stroke-opacity","0.85");
line.appendChild(c);
if(_40d){
_40d(c,data[i].src);
}
}
path.setAttribute("d",cmd.join(" "));
return line;
},CurvedLine:function(data,_417,plot,_419){
var _41a=3;
var area=_417.getArea();
var line=document.createElementNS(dojo.svg.xmlns.svg,"g");
if(data.length==0){
return line;
}
var path=document.createElementNS(dojo.svg.xmlns.svg,"path");
line.appendChild(path);
path.setAttribute("fill","none");
path.setAttribute("stroke",data[0].series.color);
path.setAttribute("stroke-width","2");
path.setAttribute("stroke-opacity","0.85");
if(data[0].series.label!=null){
path.setAttribute("title",data[0].series.label);
}
var cmd=[];
for(var i=0;i<data.length;i++){
var x=plot.axisX.getCoord(data[i].x,_417,plot);
var y=plot.axisY.getCoord(data[i].y,_417,plot);
var dx=area.left+1;
var dy=area.bottom;
if(i>0){
dx=x-plot.axisX.getCoord(data[i-1].x,_417,plot);
dy=plot.axisY.getCoord(data[i-1].y,_417,plot);
}
if(i==0){
cmd.push("M");
}else{
cmd.push("C");
var cx=x-(_41a-1)*(dx/_41a);
cmd.push(cx+","+dy);
cx=x-(dx/_41a);
cmd.push(cx+","+y);
}
cmd.push(x+","+y);
var c=document.createElementNS(dojo.svg.xmlns.svg,"circle");
c.setAttribute("cx",x);
c.setAttribute("cy",y);
c.setAttribute("r","3");
c.setAttribute("fill",data[i].series.color);
c.setAttribute("fill-opacity","0.6");
c.setAttribute("stroke-width","1");
c.setAttribute("stroke-opacity","0.85");
line.appendChild(c);
if(_419){
_419(c,data[i].src);
}
}
path.setAttribute("d",cmd.join(" "));
return line;
},Area:function(data,_427,plot,_429){
var area=_427.getArea();
var line=document.createElementNS(dojo.svg.xmlns.svg,"g");
if(data.length==0){
return line;
}
var path=document.createElementNS(dojo.svg.xmlns.svg,"path");
line.appendChild(path);
path.setAttribute("fill",data[0].series.color);
path.setAttribute("fill-opacity","0.4");
path.setAttribute("stroke",data[0].series.color);
path.setAttribute("stroke-width","1");
path.setAttribute("stroke-opacity","0.85");
if(data[0].series.label!=null){
path.setAttribute("title",data[0].series.label);
}
var cmd=[];
for(var i=0;i<data.length;i++){
var x=plot.axisX.getCoord(data[i].x,_427,plot);
var y=plot.axisY.getCoord(data[i].y,_427,plot);
if(i==0){
cmd.push("M");
}else{
cmd.push("L");
}
cmd.push(x+","+y);
var c=document.createElementNS(dojo.svg.xmlns.svg,"circle");
c.setAttribute("cx",x);
c.setAttribute("cy",y);
c.setAttribute("r","3");
c.setAttribute("fill",data[i].series.color);
c.setAttribute("fill-opacity","0.6");
c.setAttribute("stroke-width","1");
c.setAttribute("stroke-opacity","0.85");
line.appendChild(c);
if(_429){
_429(c,data[i].src);
}
}
cmd.push("L");
cmd.push(x+","+plot.axisY.getCoord(plot.axisX.origin,_427,plot));
cmd.push("L");
cmd.push(plot.axisX.getCoord(data[0].x,_427,plot)+","+plot.axisY.getCoord(plot.axisX.origin,_427,plot));
cmd.push("Z");
path.setAttribute("d",cmd.join(" "));
return line;
},CurvedArea:function(data,_433,plot,_435){
var _436=3;
var area=_433.getArea();
var line=document.createElementNS(dojo.svg.xmlns.svg,"g");
if(data.length==0){
return line;
}
var path=document.createElementNS(dojo.svg.xmlns.svg,"path");
line.appendChild(path);
path.setAttribute("fill",data[0].series.color);
path.setAttribute("fill-opacity","0.4");
path.setAttribute("stroke",data[0].series.color);
path.setAttribute("stroke-width","1");
path.setAttribute("stroke-opacity","0.85");
if(data[0].series.label!=null){
path.setAttribute("title",data[0].series.label);
}
var cmd=[];
for(var i=0;i<data.length;i++){
var x=plot.axisX.getCoord(data[i].x,_433,plot);
var y=plot.axisY.getCoord(data[i].y,_433,plot);
var dx=area.left+1;
var dy=area.bottom;
if(i>0){
dx=x-plot.axisX.getCoord(data[i-1].x,_433,plot);
dy=plot.axisY.getCoord(data[i-1].y,_433,plot);
}
if(i==0){
cmd.push("M");
}else{
cmd.push("C");
var cx=x-(_436-1)*(dx/_436);
cmd.push(cx+","+dy);
cx=x-(dx/_436);
cmd.push(cx+","+y);
}
cmd.push(x+","+y);
var c=document.createElementNS(dojo.svg.xmlns.svg,"circle");
c.setAttribute("cx",x);
c.setAttribute("cy",y);
c.setAttribute("r","3");
c.setAttribute("fill",data[i].series.color);
c.setAttribute("fill-opacity","0.6");
c.setAttribute("stroke-width","1");
c.setAttribute("stroke-opacity","0.85");
line.appendChild(c);
if(_435){
_435(c,data[i].src);
}
}
cmd.push("L");
cmd.push(x+","+plot.axisY.getCoord(plot.axisX.origin,_433,plot));
cmd.push("L");
cmd.push(plot.axisX.getCoord(data[0].x,_433,plot)+","+plot.axisY.getCoord(plot.axisX.origin,_433,plot));
cmd.push("Z");
path.setAttribute("d",cmd.join(" "));
return line;
},HighLow:function(data,_443,plot,_445){
var area=_443.getArea();
var _447=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=data.length;
var part=((area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower))/4;
var w=part*2;
for(var i=0;i<n;i++){
var high=data[i].high;
var low=data[i].low;
if(low>high){
var t=low;
low=high;
high=t;
}
var x=plot.axisX.getCoord(data[i].x,_443,plot)-(w/2);
var y=plot.axisY.getCoord(high,_443,plot);
var h=plot.axisY.getCoord(low,_443,plot)-y;
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",x);
bar.setAttribute("y",y);
bar.setAttribute("width",w);
bar.setAttribute("height",h);
bar.setAttribute("fill-opacity","0.6");
if(_445){
_445(bar,data[i].src);
}
_447.appendChild(bar);
}
return _447;
},HighLowClose:function(data,_454,plot,_456){
var area=_454.getArea();
var _458=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=data.length;
var part=((area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower))/4;
var w=part*2;
for(var i=0;i<n;i++){
var high=data[i].high;
var low=data[i].low;
if(low>high){
var t=low;
low=high;
high=t;
}
var c=data[i].close;
var x=plot.axisX.getCoord(data[i].x,_454,plot)-(w/2);
var y=plot.axisY.getCoord(high,_454,plot);
var h=plot.axisY.getCoord(low,_454,plot)-y;
var _464=plot.axisY.getCoord(c,_454,plot);
var g=document.createElementNS(dojo.svg.xmlns.svg,"g");
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",x);
bar.setAttribute("y",y);
bar.setAttribute("width",w);
bar.setAttribute("height",h);
bar.setAttribute("fill-opacity","0.6");
g.appendChild(bar);
var line=document.createElementNS(dojo.svg.xmlns.svg,"line");
line.setAttribute("x1",x);
line.setAttribute("x2",x+w+(part*2));
line.setAttribute("y1",_464);
line.setAttribute("y2",_464);
line.setAttribute("style","stroke:"+data[i].series.color+";stroke-width:1px;stroke-opacity:0.6;");
g.appendChild(line);
if(_456){
_456(g,data[i].src);
}
_458.appendChild(g);
}
return _458;
},HighLowOpenClose:function(data,_469,plot,_46b){
var area=_469.getArea();
var _46d=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=data.length;
var part=((area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower))/4;
var w=part*2;
for(var i=0;i<n;i++){
var high=data[i].high;
var low=data[i].low;
if(low>high){
var t=low;
low=high;
high=t;
}
var o=data[i].open;
var c=data[i].close;
var x=plot.axisX.getCoord(data[i].x,_469,plot)-(w/2);
var y=plot.axisY.getCoord(high,_469,plot);
var h=plot.axisY.getCoord(low,_469,plot)-y;
var open=plot.axisY.getCoord(o,_469,plot);
var _47b=plot.axisY.getCoord(c,_469,plot);
var g=document.createElementNS(dojo.svg.xmlns.svg,"g");
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",x);
bar.setAttribute("y",y);
bar.setAttribute("width",w);
bar.setAttribute("height",h);
bar.setAttribute("fill-opacity","0.6");
g.appendChild(bar);
var line=document.createElementNS(dojo.svg.xmlns.svg,"line");
line.setAttribute("x1",x-(part*2));
line.setAttribute("x2",x+w);
line.setAttribute("y1",open);
line.setAttribute("y2",open);
line.setAttribute("style","stroke:"+data[i].series.color+";stroke-width:1px;stroke-opacity:0.6;");
g.appendChild(line);
var line=document.createElementNS(dojo.svg.xmlns.svg,"line");
line.setAttribute("x1",x);
line.setAttribute("x2",x+w+(part*2));
line.setAttribute("y1",_47b);
line.setAttribute("y2",_47b);
line.setAttribute("style","stroke:"+data[i].series.color+";stroke-width:1px;stroke-opacity:0.6;");
g.appendChild(line);
if(_46b){
_46b(g,data[i].src);
}
_46d.appendChild(g);
}
return _46d;
},Scatter:function(data,_480,plot,_482){
var r=7;
var _484=document.createElementNS(dojo.svg.xmlns.svg,"g");
for(var i=0;i<data.length;i++){
var x=plot.axisX.getCoord(data[i].x,_480,plot);
var y=plot.axisY.getCoord(data[i].y,_480,plot);
var _488=document.createElementNS(dojo.svg.xmlns.svg,"path");
_488.setAttribute("fill",data[i].series.color);
_488.setAttribute("stroke-width","0");
_488.setAttribute("d","M "+x+","+(y-r)+" "+"Q "+x+","+y+" "+(x+r)+","+y+" "+"Q "+x+","+y+" "+x+","+(y+r)+" "+"Q "+x+","+y+" "+(x-r)+","+y+" "+"Q "+x+","+y+" "+x+","+(y-r)+" "+"Z");
if(_482){
_482(_488,data[i].src);
}
_484.appendChild(_488);
}
return _484;
},Bubble:function(data,_48a,plot,_48c){
var _48d=document.createElementNS(dojo.svg.xmlns.svg,"g");
var _48e=1;
for(var i=0;i<data.length;i++){
var x=plot.axisX.getCoord(data[i].x,_48a,plot);
var y=plot.axisY.getCoord(data[i].y,_48a,plot);
if(i==0){
var raw=data[i].size;
var dy=plot.axisY.getCoord(data[i].y+raw,_48a,plot)-y;
_48e=dy/raw;
}
if(_48e<1){
_48e=1;
}
var _494=document.createElementNS(dojo.svg.xmlns.svg,"circle");
_494.setAttribute("fill",data[i].series.color);
_494.setAttribute("fill-opacity","0.8");
_494.setAttribute("stroke",data[i].series.color);
_494.setAttribute("stroke-width","1");
_494.setAttribute("cx",x);
_494.setAttribute("cy",y);
_494.setAttribute("r",(data[i].size/2)*_48e);
if(_48c){
_48c(_494,data[i].src);
}
_48d.appendChild(_494);
}
return _48d;
}});
dojo.charting.Plotters["Default"]=dojo.charting.Plotters.Line;
}
dojo.provide("dojo.charting.vml.Plotters");
if(dojo.render.vml.capable){
dojo.mixin(dojo.charting.Plotters,{_group:function(_495){
var _496=document.createElement("div");
_496.style.position="absolute";
_496.style.top="0px";
_496.style.left="0px";
_496.style.width=_495.size.width+"px";
_496.style.height=_495.size.height+"px";
return _496;
},Bar:function(_497,plot,_499,_49a){
var area=_497.getArea();
var _49c=dojo.charting.Plotters._group(_497);
var n=plot.series.length;
var data=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_499);
data.push(tmp);
}
var _4a1=8;
var _4a2=data[0].length;
if(_4a2==0){
return _49c;
}
var _4a3=((area.right-area.left)-(_4a1*(_4a2-1)))/_4a2;
var _4a4=Math.round(_4a3/n);
var _4a5=plot.axisY.getCoord(plot.axisX.origin,_497,plot);
for(var i=0;i<_4a2;i++){
var _4a6=area.left+(_4a3*i)+(_4a1*i);
for(var j=0;j<n;j++){
var _4a8=data[j][i].y;
var yA=_4a5;
var x=_4a6+(_4a4*j);
var y=plot.axisY.getCoord(_4a8,_497,plot);
var h=Math.abs(yA-y);
if(_4a8<plot.axisX.origin){
yA=y;
y=_4a5;
}
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=x+"px";
bar.style.width=_4a4+"px";
bar.style.height=h+"px";
bar.setAttribute("fillColor",data[j][i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
if(_49a){
_49a(bar,data[j][i].src);
}
_49c.appendChild(bar);
}
}
return _49c;
},HorizontalBar:function(_4af,plot,_4b1,_4b2){
var area=_4af.getArea();
var _4b4=dojo.charting.Plotters._group(_4af);
var n=plot.series.length;
var data=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_4b1);
data.push(tmp);
}
var _4b9=6;
var _4ba=data[0].length;
if(_4ba==0){
return _4b4;
}
var h=((area.bottom-area.top)-(_4b9*(_4ba-1)))/_4ba;
var barH=h/n;
var _4bd=plot.axisX.getCoord(0,_4af,plot);
for(var i=0;i<_4ba;i++){
var _4be=area.top+(h*i)+(_4b9*i);
for(var j=0;j<n;j++){
var _4c0=data[j][i].y;
var y=_4be+(barH*j);
var xA=_4bd;
var x=plot.axisX.getCoord(_4c0,_4af,plot);
var w=Math.abs(x-xA);
if(_4c0>0){
x=_4bd;
}
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=xA+"px";
bar.style.width=w+"px";
bar.style.height=barH+"px";
bar.setAttribute("fillColor",data[j][i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
if(_4b2){
_4b2(bar,data[j][i].src);
}
_4b4.appendChild(bar);
}
}
var _4b9=4;
var n=plot.series.length;
var h=((area.bottom-area.top)-(_4b9*(n-1)))/n;
var _4bd=plot.axisX.getCoord(0,_4af,plot);
for(var i=0;i<n;i++){
var _4c7=plot.series[i];
var data=_4c7.data.evaluate(_4b1);
var y=area.top+(h*i)+(_4b9*i);
var _4c0=data[data.length-1].y;
var xA=_4bd;
var x=plot.axisX.getCoord(_4c0,_4af,plot);
var w=Math.abs(xA-x);
if(_4c0>0){
xA=x;
x=_4bd;
}
}
return _4b4;
},Gantt:function(_4c8,plot,_4ca,_4cb){
var area=_4c8.getArea();
var _4cd=dojo.charting.Plotters._group(_4c8);
var n=plot.series.length;
var data=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_4ca);
data.push(tmp);
}
var _4d2=2;
var _4d3=data[0].length;
if(_4d3==0){
return _4cd;
}
var h=((area.bottom-area.top)-(_4d2*(_4d3-1)))/_4d3;
var barH=h/n;
for(var i=0;i<_4d3;i++){
var _4d6=area.top+(h*i)+(_4d2*i);
for(var j=0;j<n;j++){
var high=data[j][i].high;
var low=data[j][i].low;
if(low>high){
var t=high;
high=low;
low=t;
}
var x=plot.axisX.getCoord(low,_4c8,plot);
var w=plot.axisX.getCoord(high,_4c8,plot)-x;
var y=_4d6+(barH*j);
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=x+"px";
bar.style.width=w+"px";
bar.style.height=barH+"px";
bar.setAttribute("fillColor",data[j][i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
if(_4cb){
_4cb(bar,data[j][i].src);
}
_4cd.appendChild(bar);
}
}
return _4cd;
},StackedArea:function(_4e0,plot,_4e2,_4e3){
var area=_4e0.getArea();
var _4e5=dojo.charting.Plotters._group(_4e0);
var n=plot.series.length;
var data=[];
var _4e8=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_4e2);
for(var j=0;j<tmp.length;j++){
if(i==0){
_4e8.push(tmp[j].y);
}else{
_4e8[j]+=tmp[j].y;
}
tmp[j].y=_4e8[j];
}
data.push(tmp);
}
for(var i=n-1;i>=0;i--){
var path=document.createElement("v:shape");
path.setAttribute("strokeweight","1px");
path.setAttribute("strokecolor",data[i][0].series.color);
path.setAttribute("fillcolor",data[i][0].series.color);
path.setAttribute("coordsize",(area.right-area.left)+","+(area.bottom-area.top));
path.style.position="absolute";
path.style.top="0px";
path.style.left="0px";
path.style.width=area.right-area.left+"px";
path.style.height=area.bottom-area.top+"px";
var _4ed=document.createElement("v:stroke");
_4ed.setAttribute("opacity","0.8");
path.appendChild(_4ed);
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.4");
path.appendChild(fill);
var cmd=[];
var r=3;
for(var j=0;j<data[i].length;j++){
var _4f1=data[i];
var x=Math.round(plot.axisX.getCoord(_4f1[j].x,_4e0,plot));
var y=Math.round(plot.axisY.getCoord(_4f1[j].y,_4e0,plot));
if(j==0){
cmd.push("m");
cmd.push(x+","+y);
}else{
cmd.push("l");
cmd.push(x+","+y);
}
var c=document.createElement("v:oval");
c.setAttribute("strokeweight","1px");
c.setAttribute("strokecolor",_4f1[j].series.color);
c.setAttribute("fillcolor",_4f1[j].series.color);
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.8");
c.appendChild(str);
str=document.createElement("v:fill");
str.setAttribute("opacity","0.6");
c.appendChild(str);
var s=c.style;
s.position="absolute";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_4e5.appendChild(c);
if(_4e3){
_4e3(c,data[j].src);
}
}
if(i==0){
cmd.push("l");
cmd.push(x+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_4e0,plot)));
cmd.push("l");
cmd.push(Math.round(plot.axisX.getCoord(data[0][0].x,_4e0,plot))+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_4e0,plot)));
}else{
var _4f1=data[i-1];
cmd.push("l");
cmd.push(x+","+Math.round(plot.axisY.getCoord(_4f1[_4f1.length-1].y,_4e0,plot)));
for(var j=_4f1.length-2;j>=0;j--){
var x=Math.round(plot.axisX.getCoord(_4f1[j].x,_4e0,plot));
var y=Math.round(plot.axisY.getCoord(_4f1[j].y,_4e0,plot));
cmd.push("l");
cmd.push(x+","+y);
}
}
path.setAttribute("path",cmd.join(" ")+" x e");
_4e5.appendChild(path);
}
return _4e5;
},StackedCurvedArea:function(_4f7,plot,_4f9,_4fa){
var _4fb=3;
var area=_4f7.getArea();
var _4fd=dojo.charting.Plotters._group(_4f7);
var n=plot.series.length;
var data=[];
var _500=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_4f9);
for(var j=0;j<tmp.length;j++){
if(i==0){
_500.push(tmp[j].y);
}else{
_500[j]+=tmp[j].y;
}
tmp[j].y=_500[j];
}
data.push(tmp);
}
for(var i=n-1;i>=0;i--){
var path=document.createElement("v:shape");
path.setAttribute("strokeweight","1px");
path.setAttribute("strokecolor",data[i][0].series.color);
path.setAttribute("fillcolor",data[i][0].series.color);
path.setAttribute("coordsize",(area.right-area.left)+","+(area.bottom-area.top));
path.style.position="absolute";
path.style.top="0px";
path.style.left="0px";
path.style.width=area.right-area.left+"px";
path.style.height=area.bottom-area.top+"px";
var _505=document.createElement("v:stroke");
_505.setAttribute("opacity","0.8");
path.appendChild(_505);
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.4");
path.appendChild(fill);
var cmd=[];
var r=3;
for(var j=0;j<data[i].length;j++){
var _509=data[i];
var x=Math.round(plot.axisX.getCoord(_509[j].x,_4f7,plot));
var y=Math.round(plot.axisY.getCoord(_509[j].y,_4f7,plot));
if(j==0){
cmd.push("m");
cmd.push(x+","+y);
}else{
var _50c=Math.round(plot.axisX.getCoord(_509[j-1].x,_4f7,plot));
var _50d=Math.round(plot.axisY.getCoord(_509[j-1].y,_4f7,plot));
var dx=x-_50c;
var dy=y-_50d;
cmd.push("c");
var cx=Math.round((x-(_4fb-1)*(dx/_4fb)));
cmd.push(cx+","+_50d);
cx=Math.round((x-(dx/_4fb)));
cmd.push(cx+","+y);
cmd.push(x+","+y);
}
var c=document.createElement("v:oval");
c.setAttribute("strokeweight","1px");
c.setAttribute("strokecolor",_509[j].series.color);
c.setAttribute("fillcolor",_509[j].series.color);
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.8");
c.appendChild(str);
str=document.createElement("v:fill");
str.setAttribute("opacity","0.6");
c.appendChild(str);
var s=c.style;
s.position="absolute";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_4fd.appendChild(c);
if(_4fa){
_4fa(c,data[j].src);
}
}
if(i==0){
cmd.push("l");
cmd.push(x+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_4f7,plot)));
cmd.push("l");
cmd.push(Math.round(plot.axisX.getCoord(data[0][0].x,_4f7,plot))+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_4f7,plot)));
}else{
var _509=data[i-1];
cmd.push("l");
cmd.push(x+","+Math.round(plot.axisY.getCoord(_509[_509.length-1].y,_4f7,plot)));
for(var j=_509.length-2;j>=0;j--){
var x=Math.round(plot.axisX.getCoord(_509[j].x,_4f7,plot));
var y=Math.round(plot.axisY.getCoord(_509[j].y,_4f7,plot));
var _50c=Math.round(plot.axisX.getCoord(_509[j+1].x,_4f7,plot));
var _50d=Math.round(plot.axisY.getCoord(_509[j+1].y,_4f7,plot));
var dx=x-_50c;
var dy=y-_50d;
cmd.push("c");
var cx=Math.round((x-(_4fb-1)*(dx/_4fb)));
cmd.push(cx+","+_50d);
cx=Math.round((x-(dx/_4fb)));
cmd.push(cx+","+y);
cmd.push(x+","+y);
}
}
path.setAttribute("path",cmd.join(" ")+" x e");
_4fd.appendChild(path);
}
return _4fd;
},DataBar:function(data,_515,plot,_517){
var area=_515.getArea();
var _519=dojo.charting.Plotters._group(_515);
var n=data.length;
var w=(area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower);
var _51c=plot.axisY.getCoord(plot.axisX.origin,_515,plot);
for(var i=0;i<n;i++){
var _51e=data[i].y;
var yA=_51c;
var x=plot.axisX.getCoord(data[i].x,_515,plot)-(w/2)+1;
var y=plot.axisY.getCoord(_51e,_515,plot);
var h=Math.abs(yA-y);
if(_51e<plot.axisX.origin){
yA=y;
y=_51c;
}
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=x+"px";
bar.style.width=w+"px";
bar.style.height=h+"px";
bar.setAttribute("fillColor",data[i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
if(_517){
_517(bar,data[i].src);
}
_519.appendChild(bar);
}
return _519;
},Line:function(data,_526,plot,_528){
var area=_526.getArea();
var _52a=dojo.charting.Plotters._group(_526);
if(data.length==0){
return _52a;
}
var path=document.createElement("v:shape");
path.setAttribute("strokeweight","2px");
path.setAttribute("strokecolor",data[0].series.color);
path.setAttribute("fillcolor","none");
path.setAttribute("filled","false");
path.setAttribute("coordsize",(area.right-area.left)+","+(area.bottom-area.top));
path.style.position="absolute";
path.style.top="0px";
path.style.left="0px";
path.style.width=area.right-area.left+"px";
path.style.height=area.bottom-area.top+"px";
var _52c=document.createElement("v:stroke");
_52c.setAttribute("opacity","0.8");
path.appendChild(_52c);
var cmd=[];
var r=3;
for(var i=0;i<data.length;i++){
var x=Math.round(plot.axisX.getCoord(data[i].x,_526,plot));
var y=Math.round(plot.axisY.getCoord(data[i].y,_526,plot));
if(i==0){
cmd.push("m");
cmd.push(x+","+y);
}else{
cmd.push("l");
cmd.push(x+","+y);
}
var c=document.createElement("v:oval");
c.setAttribute("strokeweight","1px");
c.setAttribute("strokecolor",data[i].series.color);
c.setAttribute("fillcolor",data[i].series.color);
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.8");
c.appendChild(str);
str=document.createElement("v:fill");
str.setAttribute("opacity","0.6");
c.appendChild(str);
var s=c.style;
s.position="absolute";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_52a.appendChild(c);
if(_528){
_528(c,data[i].src);
}
}
path.setAttribute("path",cmd.join(" ")+" e");
_52a.appendChild(path);
return _52a;
},CurvedLine:function(data,_536,plot,_538){
var _539=3;
var area=_536.getArea();
var _53b=dojo.charting.Plotters._group(_536);
if(data.length==0){
return _53b;
}
var path=document.createElement("v:shape");
path.setAttribute("strokeweight","2px");
path.setAttribute("strokecolor",data[0].series.color);
path.setAttribute("fillcolor","none");
path.setAttribute("filled","false");
path.setAttribute("coordsize",(area.right-area.left)+","+(area.bottom-area.top));
path.style.position="absolute";
path.style.top="0px";
path.style.left="0px";
path.style.width=area.right-area.left+"px";
path.style.height=area.bottom-area.top+"px";
var _53d=document.createElement("v:stroke");
_53d.setAttribute("opacity","0.8");
path.appendChild(_53d);
var cmd=[];
var r=3;
for(var i=0;i<data.length;i++){
var x=Math.round(plot.axisX.getCoord(data[i].x,_536,plot));
var y=Math.round(plot.axisY.getCoord(data[i].y,_536,plot));
if(i==0){
cmd.push("m");
cmd.push(x+","+y);
}else{
var _543=Math.round(plot.axisX.getCoord(data[i-1].x,_536,plot));
var _544=Math.round(plot.axisY.getCoord(data[i-1].y,_536,plot));
var dx=x-_543;
var dy=y-_544;
cmd.push("c");
var cx=Math.round((x-(_539-1)*(dx/_539)));
cmd.push(cx+","+_544);
cx=Math.round((x-(dx/_539)));
cmd.push(cx+","+y);
cmd.push(x+","+y);
}
var c=document.createElement("v:oval");
c.setAttribute("strokeweight","1px");
c.setAttribute("strokecolor",data[i].series.color);
c.setAttribute("fillcolor",data[i].series.color);
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.8");
c.appendChild(str);
str=document.createElement("v:fill");
str.setAttribute("opacity","0.6");
c.appendChild(str);
var s=c.style;
s.position="absolute";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_53b.appendChild(c);
if(_538){
_538(c,data[i].src);
}
}
path.setAttribute("path",cmd.join(" ")+" e");
_53b.appendChild(path);
return _53b;
},Area:function(data,_54c,plot,_54e){
var area=_54c.getArea();
var _550=dojo.charting.Plotters._group(_54c);
if(data.length==0){
return _550;
}
var path=document.createElement("v:shape");
path.setAttribute("strokeweight","1px");
path.setAttribute("strokecolor",data[0].series.color);
path.setAttribute("fillcolor",data[0].series.color);
path.setAttribute("coordsize",(area.right-area.left)+","+(area.bottom-area.top));
path.style.position="absolute";
path.style.top="0px";
path.style.left="0px";
path.style.width=area.right-area.left+"px";
path.style.height=area.bottom-area.top+"px";
var _552=document.createElement("v:stroke");
_552.setAttribute("opacity","0.8");
path.appendChild(_552);
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.4");
path.appendChild(fill);
var cmd=[];
var r=3;
for(var i=0;i<data.length;i++){
var x=Math.round(plot.axisX.getCoord(data[i].x,_54c,plot));
var y=Math.round(plot.axisY.getCoord(data[i].y,_54c,plot));
if(i==0){
cmd.push("m");
cmd.push(x+","+y);
}else{
cmd.push("l");
cmd.push(x+","+y);
}
var c=document.createElement("v:oval");
c.setAttribute("strokeweight","1px");
c.setAttribute("strokecolor",data[i].series.color);
c.setAttribute("fillcolor",data[i].series.color);
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.8");
c.appendChild(str);
str=document.createElement("v:fill");
str.setAttribute("opacity","0.6");
c.appendChild(str);
var s=c.style;
s.position="absolute";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_550.appendChild(c);
if(_54e){
_54e(c,data[i].src);
}
}
cmd.push("l");
cmd.push(x+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_54c,plot)));
cmd.push("l");
cmd.push(Math.round(plot.axisX.getCoord(data[0].x,_54c,plot))+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_54c,plot)));
path.setAttribute("path",cmd.join(" ")+" x e");
_550.appendChild(path);
return _550;
},CurvedArea:function(data,_55d,plot,_55f){
var _560=3;
var area=_55d.getArea();
var _562=dojo.charting.Plotters._group(_55d);
if(data.length==0){
return _562;
}
var path=document.createElement("v:shape");
path.setAttribute("strokeweight","1px");
path.setAttribute("strokecolor",data[0].series.color);
path.setAttribute("fillcolor",data[0].series.color);
path.setAttribute("coordsize",(area.right-area.left)+","+(area.bottom-area.top));
path.style.position="absolute";
path.style.top="0px";
path.style.left="0px";
path.style.width=area.right-area.left+"px";
path.style.height=area.bottom-area.top+"px";
var _564=document.createElement("v:stroke");
_564.setAttribute("opacity","0.8");
path.appendChild(_564);
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.4");
path.appendChild(fill);
var cmd=[];
var r=3;
for(var i=0;i<data.length;i++){
var x=Math.round(plot.axisX.getCoord(data[i].x,_55d,plot));
var y=Math.round(plot.axisY.getCoord(data[i].y,_55d,plot));
if(i==0){
cmd.push("m");
cmd.push(x+","+y);
}else{
var _56b=Math.round(plot.axisX.getCoord(data[i-1].x,_55d,plot));
var _56c=Math.round(plot.axisY.getCoord(data[i-1].y,_55d,plot));
var dx=x-_56b;
var dy=y-_56c;
cmd.push("c");
var cx=Math.round((x-(_560-1)*(dx/_560)));
cmd.push(cx+","+_56c);
cx=Math.round((x-(dx/_560)));
cmd.push(cx+","+y);
cmd.push(x+","+y);
}
var c=document.createElement("v:oval");
c.setAttribute("strokeweight","1px");
c.setAttribute("strokecolor",data[i].series.color);
c.setAttribute("fillcolor",data[i].series.color);
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.8");
c.appendChild(str);
str=document.createElement("v:fill");
str.setAttribute("opacity","0.6");
c.appendChild(str);
var s=c.style;
s.position="absolute";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_562.appendChild(c);
if(_55f){
_55f(c,data[i].src);
}
}
cmd.push("l");
cmd.push(x+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_55d,plot)));
cmd.push("l");
cmd.push(Math.round(plot.axisX.getCoord(data[0].x,_55d,plot))+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_55d,plot)));
path.setAttribute("path",cmd.join(" ")+" x e");
_562.appendChild(path);
return _562;
},HighLow:function(data,_574,plot,_576){
var area=_574.getArea();
var _578=dojo.charting.Plotters._group(_574);
var n=data.length;
var part=((area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower))/4;
var w=part*2;
for(var i=0;i<n;i++){
var high=data[i].high;
var low=data[i].low;
if(low>high){
var t=low;
low=high;
high=t;
}
var x=plot.axisX.getCoord(data[i].x,_574,plot)-(w/2);
var y=plot.axisY.getCoord(high,_574,plot);
var h=plot.axisY.getCoord(low,_574,plot)-y;
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=x+"px";
bar.style.width=w+"px";
bar.style.height=h+"px";
bar.setAttribute("fillColor",data[i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
if(_576){
_576(bar,data[i].src);
}
_578.appendChild(bar);
}
return _578;
},HighLowClose:function(data,_586,plot,_588){
var area=_586.getArea();
var _58a=dojo.charting.Plotters._group(_586);
var n=data.length;
var part=((area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower))/4;
var w=part*2;
for(var i=0;i<n;i++){
var high=data[i].high;
var low=data[i].low;
if(low>high){
var t=low;
low=high;
high=t;
}
var c=data[i].close;
var x=plot.axisX.getCoord(data[i].x,_586,plot)-(w/2);
var y=plot.axisY.getCoord(high,_586,plot);
var h=plot.axisY.getCoord(low,_586,plot)-y;
var _596=plot.axisY.getCoord(c,_586,plot);
var g=document.createElement("div");
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=x+"px";
bar.style.width=w+"px";
bar.style.height=h+"px";
bar.setAttribute("fillColor",data[i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
g.appendChild(bar);
var line=document.createElement("v:line");
line.setAttribute("strokecolor",data[i].series.color);
line.setAttribute("strokeweight","1px");
line.setAttribute("from",x+"px,"+_596+"px");
line.setAttribute("to",(x+w+(part*2)-2)+"px,"+_596+"px");
var s=line.style;
s.position="absolute";
s.top="0px";
s.left="0px";
s.antialias="false";
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.6");
line.appendChild(str);
g.appendChild(line);
if(_588){
_588(g,data[i].src);
}
_58a.appendChild(g);
}
return _58a;
},HighLowOpenClose:function(data,_59e,plot,_5a0){
var area=_59e.getArea();
var _5a2=dojo.charting.Plotters._group(_59e);
var n=data.length;
var part=((area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower))/4;
var w=part*2;
for(var i=0;i<n;i++){
var high=data[i].high;
var low=data[i].low;
if(low>high){
var t=low;
low=high;
high=t;
}
var o=data[i].open;
var c=data[i].close;
var x=plot.axisX.getCoord(data[i].x,_59e,plot)-(w/2);
var y=plot.axisY.getCoord(high,_59e,plot);
var h=plot.axisY.getCoord(low,_59e,plot)-y;
var open=plot.axisY.getCoord(o,_59e,plot);
var _5b0=plot.axisY.getCoord(c,_59e,plot);
var g=document.createElement("div");
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=x+"px";
bar.style.width=w+"px";
bar.style.height=h+"px";
bar.setAttribute("fillColor",data[i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
g.appendChild(bar);
var line=document.createElement("v:line");
line.setAttribute("strokecolor",data[i].series.color);
line.setAttribute("strokeweight","1px");
line.setAttribute("from",(x-(part*2))+"px,"+open+"px");
line.setAttribute("to",(x+w-2)+"px,"+open+"px");
var s=line.style;
s.position="absolute";
s.top="0px";
s.left="0px";
s.antialias="false";
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.6");
line.appendChild(str);
g.appendChild(line);
var line=document.createElement("v:line");
line.setAttribute("strokecolor",data[i].series.color);
line.setAttribute("strokeweight","1px");
line.setAttribute("from",x+"px,"+_5b0+"px");
line.setAttribute("to",(x+w+(part*2)-2)+"px,"+_5b0+"px");
var s=line.style;
s.position="absolute";
s.top="0px";
s.left="0px";
s.antialias="false";
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.6");
line.appendChild(str);
g.appendChild(line);
if(_5a0){
_5a0(g,data[i].src);
}
_5a2.appendChild(g);
}
return _5a2;
},Scatter:function(data,_5b8,plot,_5ba){
var r=6;
var mod=r/2;
var area=_5b8.getArea();
var _5be=dojo.charting.Plotters._group(_5b8);
for(var i=0;i<data.length;i++){
var x=Math.round(plot.axisX.getCoord(data[i].x,_5b8,plot));
var y=Math.round(plot.axisY.getCoord(data[i].y,_5b8,plot));
var _5c2=document.createElement("v:rect");
_5c2.setAttribute("strokecolor",data[i].series.color);
_5c2.setAttribute("fillcolor",data[i].series.color);
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
_5c2.appendChild(fill);
var s=_5c2.style;
s.position="absolute";
s.rotation="45";
s.top=(y-mod)+"px";
s.left=(x-mod)+"px";
s.width=r+"px";
s.height=r+"px";
_5be.appendChild(_5c2);
if(_5ba){
_5ba(_5c2,data[i].src);
}
}
return _5be;
},Bubble:function(data,_5c6,plot,_5c8){
var _5c9=1;
var area=_5c6.getArea();
var _5cb=dojo.charting.Plotters._group(_5c6);
for(var i=0;i<data.length;i++){
var x=Math.round(plot.axisX.getCoord(data[i].x,_5c6,plot));
var y=Math.round(plot.axisY.getCoord(data[i].y,_5c6,plot));
if(i==0){
var raw=data[i].size;
var dy=plot.axisY.getCoord(data[i].y+raw,_5c6,plot)-y;
_5c9=dy/raw;
}
if(_5c9<1){
_5c9=1;
}
var r=(data[i].size/2)*_5c9;
var _5d2=document.createElement("v:oval");
_5d2.setAttribute("strokecolor",data[i].series.color);
_5d2.setAttribute("fillcolor",data[i].series.color);
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
_5d2.appendChild(fill);
var s=_5d2.style;
s.position="absolute";
s.rotation="45";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_5cb.appendChild(_5d2);
if(_5c8){
_5c8(_5d2,data[i].src);
}
}
return _5cb;
}});
dojo.charting.Plotters["Default"]=dojo.charting.Plotters.Line;
}
dojo.provide("dojo.charting.Series");
dojo.charting.Series=function(_5d5){
var args=_5d5||{length:1};
this.dataSource=args.dataSource||null;
this.bindings={};
this.color=args.color;
this.label=args.label;
if(args.bindings){
for(var p in args.bindings){
this.addBinding(p,args.bindings[p]);
}
}
};
dojo.extend(dojo.charting.Series,{bind:function(src,_5d9){
this.dataSource=src;
this.bindings=_5d9;
},addBinding:function(name,_5db){
this.bindings[name]=_5db;
},evaluate:function(_5dc){
var ret=[];
var a=this.dataSource.getData();
var l=a.length;
var _5e0=0;
var end=l;
if(_5dc){
if(_5dc.between){
for(var i=0;i<l;i++){
var fld=this.dataSource.getField(a[i],_5dc.between.field);
if(fld>=_5dc.between.low&&fld<=_5dc.between.high){
var o={src:a[i],series:this};
for(var p in this.bindings){
o[p]=this.dataSource.getField(a[i],this.bindings[p]);
}
ret.push(o);
}
}
}else{
if(_5dc.from||_5dc.length){
if(_5dc.from){
_5e0=Math.max(_5dc.from,0);
if(_5dc.to){
end=Math.min(_5dc.to,end);
}
}else{
if(_5dc.length<0){
_5e0=Math.max((end+length),0);
}else{
end=Math.min((_5e0+length),end);
}
}
for(var i=_5e0;i<end;i++){
var o={src:a[i],series:this};
for(var p in this.bindings){
o[p]=this.dataSource.getField(a[i],this.bindings[p]);
}
ret.push(o);
}
}
}
}else{
for(var i=_5e0;i<end;i++){
var o={src:a[i],series:this};
for(var p in this.bindings){
o[p]=this.dataSource.getField(a[i],this.bindings[p]);
}
ret.push(o);
}
}
if(ret.length>0&&typeof (ret[0].x)!="undefined"){
ret.sort(function(a,b){
if(a.x>b.x){
return 1;
}
if(a.x<b.x){
return -1;
}
return 0;
});
}
return ret;
},trends:{createRange:function(_5e8,len){
var idx=_5e8.length-1;
var _5eb=(len||_5e8.length);
return {"index":idx,"length":_5eb,"start":Math.max(idx-_5eb,0)};
},mean:function(_5ec,len){
var _5ee=this.createRange(_5ec,len);
if(_5ee.index<0){
return 0;
}
var _5ef=0;
var _5f0=0;
for(var i=_5ee.index;i>=_5ee.start;i--){
_5ef+=_5ec[i].y;
_5f0++;
}
_5ef/=Math.max(_5f0,1);
return _5ef;
},variance:function(_5f2,len){
var _5f4=this.createRange(_5f2,len);
if(_5f4.index<0){
return 0;
}
var _5f5=0;
var _5f6=0;
var _5f7=0;
for(var i=_5f4.index;i>=_5f4.start;i--){
_5f5+=_5f2[i].y;
_5f6+=Math.pow(_5f2[i].y,2);
_5f7++;
}
return (_5f6/_5f7)-Math.pow(_5f5/_5f7,2);
},standardDeviation:function(_5f9,len){
return Math.sqrt(this.getVariance(_5f9,len));
},max:function(_5fb,len){
var _5fd=this.createRange(_5fb,len);
if(_5fd.index<0){
return 0;
}
var max=Number.MIN_VALUE;
for(var i=_5fd.index;i>=_5fd.start;i--){
max=Math.max(_5fb[i].y,max);
}
return max;
},min:function(_600,len){
var _602=this.createRange(_600,len);
if(_602.index<0){
return 0;
}
var min=Number.MAX_VALUE;
for(var i=_602.index;i>=_602.start;i--){
min=Math.min(_600[i].y,min);
}
return min;
},median:function(_605,len){
var _607=this.createRange(_605,len);
if(_607.index<0){
return 0;
}
var a=[];
for(var i=_607.index;i>=_607.start;i--){
var b=false;
for(var j=0;j<a.length;j++){
if(_605[i].y==a[j]){
b=true;
break;
}
}
if(!b){
a.push(_605[i].y);
}
}
a.sort();
if(a.length>0){
return a[Math.ceil(a.length/2)];
}
return 0;
},mode:function(_60c,len){
var _60e=this.createRange(_60c,len);
if(_60e.index<0){
return 0;
}
var o={};
var ret=0;
var _611=Number.MIN_VALUE;
for(var i=_60e.index;i>=_60e.start;i--){
if(!o[_60c[i].y]){
o[_60c[i].y]=1;
}else{
o[_60c[i].y]++;
}
}
for(var p in o){
if(_611<o[p]){
_611=o[p];
ret=p;
}
}
return ret;
}}});
dojo.provide("dojo.charting.Plot");
dojo.charting.RenderPlotSeries={Singly:"single",Grouped:"grouped"};
dojo.charting.Plot=function(_614,_615,_616){
var id="dojo-charting-plot-"+dojo.charting.Plot.count++;
this.getId=function(){
return id;
};
this.setId=function(key){
id=key;
};
this.axisX=null;
this.axisY=null;
this.series=[];
this.dataNode=null;
this.renderType=dojo.charting.RenderPlotSeries.Singly;
if(_614){
this.setAxis(_614,"x");
}
if(_615){
this.setAxis(_615,"y");
}
if(_616){
for(var i=0;i<_616.length;i++){
this.addSeries(_616[i]);
}
}
};
dojo.charting.Plot.count=0;
dojo.extend(dojo.charting.Plot,{addSeries:function(_61a,_61b){
if(_61a.plotter){
this.series.push(_61a);
}else{
this.series.push({data:_61a,plotter:_61b||dojo.charting.Plotters["Default"]});
}
},setAxis:function(axis,_61d){
if(_61d.toLowerCase()=="x"){
this.axisX=axis;
}else{
if(_61d.toLowerCase()=="y"){
this.axisY=axis;
}
}
},getRanges:function(){
var xmin,xmax,ymin,ymax;
xmin=ymin=Number.MAX_VALUE;
xmax=ymax=Number.MIN_VALUE;
for(var i=0;i<this.series.length;i++){
var _623=this.series[i].data.evaluate();
for(var j=0;j<_623.length;j++){
var comp=_623[j];
xmin=Math.min(comp.x,xmin);
ymin=Math.min(comp.y,ymin);
xmax=Math.max(comp.x,xmax);
ymax=Math.max(comp.y,ymax);
}
}
return {x:{upper:xmax,lower:xmin},y:{upper:ymax,lower:ymin},toString:function(){
return "[ x:"+xmax+" - "+xmin+", y:"+ymax+" - "+ymin+"]";
}};
},destroy:function(){
var node=this.dataNode;
while(node&&node.childNodes&&node.childNodes.length>0){
node.removeChild(node.childNodes[0]);
}
this.dataNode=null;
}});
dojo.provide("dojo.charting.PlotArea");
dojo.charting.PlotArea=function(){
var id="dojo-charting-plotarea-"+dojo.charting.PlotArea.count++;
this.getId=function(){
return id;
};
this.setId=function(key){
id=key;
};
this.areaType="standard";
this.plots=[];
this.size={width:600,height:400};
this.padding={top:10,right:10,bottom:20,left:20};
this.nodes={main:null,area:null,background:null,axes:null,plots:null};
this._color={h:140,s:120,l:120,step:27};
};
dojo.charting.PlotArea.count=0;
dojo.extend(dojo.charting.PlotArea,{nextColor:function(){
var rgb=dojo.gfx.color.hsl2rgb(this._color.h,this._color.s,this._color.l);
this._color.h=(this._color.h+this._color.step)%360;
while(this._color.h<140){
this._color.h+=this._color.step;
}
return dojo.gfx.color.rgb2hex(rgb[0],rgb[1],rgb[2]);
},getArea:function(){
return {left:this.padding.left,right:this.size.width-this.padding.right,top:this.padding.top,bottom:this.size.height-this.padding.bottom,toString:function(){
var a=[this.top,this.right,this.bottom,this.left];
return "["+a.join()+"]";
}};
},getAxes:function(){
var axes={};
for(var i=0;i<this.plots.length;i++){
var plot=this.plots[i];
axes[plot.axisX.getId()]={axis:plot.axisX,drawAgainst:plot.axisY,plot:plot,plane:"x"};
axes[plot.axisY.getId()]={axis:plot.axisY,drawAgainst:plot.axisX,plot:plot,plane:"y"};
}
return axes;
},getLegendInfo:function(){
var a=[];
for(var i=0;i<this.plots.length;i++){
for(var j=0;j<this.plots[i].series.length;j++){
var data=this.plots[i].series[j].data;
a.push({label:data.label,color:data.color});
}
}
return a;
},setAxesRanges:function(){
var _632={};
var axes={};
for(var i=0;i<this.plots.length;i++){
var plot=this.plots[i];
var _632=plot.getRanges();
var x=_632.x;
var y=_632.y;
var ax,ay;
if(!axes[plot.axisX.getId()]){
axes[plot.axisX.getId()]=plot.axisX;
_632[plot.axisX.getId()]={upper:x.upper,lower:x.lower};
}
ax=_632[plot.axisX.getId()];
ax.upper=Math.max(ax.upper,x.upper);
ax.lower=Math.min(ax.lower,x.lower);
if(!axes[plot.axisY.getId()]){
axes[plot.axisY.getId()]=plot.axisY;
_632[plot.axisY.getId()]={upper:y.upper,lower:y.lower};
}
ay=_632[plot.axisY.getId()];
ay.upper=Math.max(ay.upper,y.upper);
ay.lower=Math.min(ay.lower,y.lower);
}
for(var p in axes){
axes[p].range=_632[p];
}
},render:function(_63b,_63c){
if(!this.nodes.main||!this.nodes.area||!this.nodes.background||!this.nodes.plots||!this.nodes.axes){
this.initialize();
}
this.resize();
for(var i=0;i<this.plots.length;i++){
var plot=this.plots[i];
if(plot.dataNode){
this.nodes.plots.removeChild(plot.dataNode);
}
var _63f=this.initializePlot(plot);
switch(plot.renderType){
case dojo.charting.RenderPlotSeries.Grouped:
if(plot.series[0]){
_63f.appendChild(plot.series[0].plotter(this,plot,_63b,_63c));
}
break;
case dojo.charting.RenderPlotSeries.Singly:
default:
for(var j=0;j<plot.series.length;j++){
var _641=plot.series[j];
var data=_641.data.evaluate(_63b);
_63f.appendChild(_641.plotter(data,this,plot,_63c));
}
}
this.nodes.plots.appendChild(_63f);
}
},destroy:function(){
for(var i=0;i<this.plots.length;i++){
this.plots[i].destroy();
}
for(var p in this.nodes){
var node=this.nodes[p];
if(!node){
continue;
}
if(!node.childNodes){
continue;
}
while(node.childNodes.length>0){
node.removeChild(node.childNodes[0]);
}
this.nodes[p]=null;
}
}});
dojo.requireIf(dojo.render.svg.capable,"dojo.charting.svg.PlotArea");
dojo.requireIf(dojo.render.vml.capable,"dojo.charting.vml.PlotArea");
dojo.provide("dojo.charting.svg.PlotArea");
if(dojo.render.svg.capable){
dojo.extend(dojo.charting.PlotArea,{resize:function(){
var area=this.getArea();
this.nodes.area.setAttribute("width",this.size.width);
this.nodes.area.setAttribute("height",this.size.height);
var rect=this.nodes.area.getElementsByTagName("rect")[0];
rect.setAttribute("x",area.left);
rect.setAttribute("y",area.top);
rect.setAttribute("width",area.right-area.left);
rect.setAttribute("height",area.bottom-area.top);
this.nodes.background.setAttribute("width",this.size.width);
this.nodes.background.setAttribute("height",this.size.height);
if(this.nodes.plots){
this.nodes.area.removeChild(this.nodes.plots);
this.nodes.plots=null;
}
this.nodes.plots=document.createElementNS(dojo.svg.xmlns.svg,"g");
this.nodes.plots.setAttribute("id",this.getId()+"-plots");
this.nodes.plots.setAttribute("style","clip-path:url(#"+this.getId()+"-clip);");
this.nodes.area.appendChild(this.nodes.plots);
for(var i=0;i<this.plots.length;i++){
this.nodes.plots.appendChild(this.initializePlot(this.plots[i]));
}
if(this.nodes.axes){
this.nodes.area.removeChild(this.nodes.axes);
this.nodes.axes=null;
}
this.nodes.axes=document.createElementNS(dojo.svg.xmlns.svg,"g");
this.nodes.axes.setAttribute("id",this.getId()+"-axes");
this.nodes.area.appendChild(this.nodes.axes);
var axes=this.getAxes();
for(var p in axes){
var obj=axes[p];
this.nodes.axes.appendChild(obj.axis.initialize(this,obj.plot,obj.drawAgainst,obj.plane));
}
},initializePlot:function(plot){
plot.destroy();
plot.dataNode=document.createElementNS(dojo.svg.xmlns.svg,"g");
plot.dataNode.setAttribute("id",plot.getId());
return plot.dataNode;
},initialize:function(){
this.destroy();
this.nodes.main=document.createElement("div");
this.nodes.area=document.createElementNS(dojo.svg.xmlns.svg,"svg");
this.nodes.area.setAttribute("id",this.getId());
this.nodes.main.appendChild(this.nodes.area);
var defs=document.createElementNS(dojo.svg.xmlns.svg,"defs");
var clip=document.createElementNS(dojo.svg.xmlns.svg,"clipPath");
clip.setAttribute("id",this.getId()+"-clip");
var rect=document.createElementNS(dojo.svg.xmlns.svg,"rect");
clip.appendChild(rect);
defs.appendChild(clip);
this.nodes.area.appendChild(defs);
this.nodes.background=document.createElementNS(dojo.svg.xmlns.svg,"rect");
this.nodes.background.setAttribute("id",this.getId()+"-background");
this.nodes.background.setAttribute("fill","#fff");
this.nodes.area.appendChild(this.nodes.background);
this.resize();
return this.nodes.main;
}});
}
dojo.provide("dojo.charting.vml.PlotArea");
if(dojo.render.vml.capable){
dojo.extend(dojo.charting.PlotArea,{resize:function(){
var a=this.getArea();
this.nodes.area.style.width=this.size.width+"px";
this.nodes.area.style.height=this.size.height+"px";
this.nodes.background.style.width=this.size.width+"px";
this.nodes.background.style.height=this.size.height+"px";
this.nodes.plots.width=this.size.width+"px";
this.nodes.plots.height=this.size.height+"px";
this.nodes.plots.style.clip="rect("+a.top+" "+a.right+" "+a.bottom+" "+a.left+")";
if(this.nodes.axes){
this.nodes.area.removeChild(this.nodes.axes);
}
var axes=this.nodes.axes=document.createElement("div");
axes.id=this.getId()+"-axes";
this.nodes.area.appendChild(axes);
var ax=this.getAxes();
for(var p in ax){
var obj=ax[p];
axes.appendChild(obj.axis.initialize(this,obj.plot,obj.drawAgainst,obj.plane));
}
},initializePlot:function(plot){
plot.destroy();
plot.dataNode=document.createElement("div");
plot.dataNode.id=plot.getId();
return plot.dataNode;
},initialize:function(){
this.destroy();
var main=this.nodes.main=document.createElement("div");
var area=this.nodes.area=document.createElement("div");
area.id=this.getId();
area.style.position="absolute";
main.appendChild(area);
var bg=this.nodes.background=document.createElement("div");
bg.id=this.getId()+"-background";
bg.style.position="absolute";
bg.style.top="0px";
bg.style.left="0px";
bg.style.backgroundColor="#fff";
area.appendChild(bg);
var a=this.getArea();
var _65a=this.nodes.plots=document.createElement("div");
_65a.id=this.getId()+"-plots";
_65a.style.position="absolute";
_65a.style.top="0px";
_65a.style.left="0px";
area.appendChild(_65a);
for(var i=0;i<this.plots.length;i++){
_65a.appendChild(this.initializePlot(this.plots[i]));
}
this.resize();
return main;
}});
}
dojo.provide("dojo.charting.Chart");
dojo.charting.Chart=function(node,_65d,_65e){
this.node=node||null;
this.title=_65d||"Chart";
this.description=_65e||"";
this.plotAreas=[];
};
dojo.extend(dojo.charting.Chart,{addPlotArea:function(obj,_660){
if(obj.x!=null&&obj.left==null){
obj.left=obj.x;
}
if(obj.y!=null&&obj.top==null){
obj.top=obj.y;
}
this.plotAreas.push(obj);
if(_660){
this.render();
}
},onInitialize:function(_661){
},onRender:function(_662){
},onDestroy:function(_663){
},initialize:function(){
if(!this.node){
dojo.raise("dojo.charting.Chart.initialize: there must be a root node defined for the Chart.");
}
this.destroy();
this.render();
this.onInitialize(this);
},render:function(){
if(this.node.style.position!="absolute"){
this.node.style.position="relative";
}
for(var i=0;i<this.plotAreas.length;i++){
var area=this.plotAreas[i].plotArea;
var node=area.initialize();
node.style.position="absolute";
node.style.top=this.plotAreas[i].top+"px";
node.style.left=this.plotAreas[i].left+"px";
this.node.appendChild(node);
area.render();
}
},destroy:function(){
for(var i=0;i<this.plotAreas.length;i++){
this.plotAreas[i].plotArea.destroy();
}
while(this.node&&this.node.childNodes&&this.node.childNodes.length>0){
this.node.removeChild(this.node.childNodes[0]);
}
}});


__CPAN_EDITION__ charting build.txt
Files baked into this build:
dojoGuardStart.js
../src/bootstrap1.js
../src/loader.js
dojoGuardEnd.js
../src/hostenv_browser.js
../src/lang/common.js
../src/lang/func.js
../src/string/common.js
../src/lang/array.js
../src/string/extras.js
../src/AdapterRegistry.js
../src/json.js
../src/collections/Store.js
../src/gfx/color.js
../src/gfx/color/hsl.js
../src/charting/__package__.js
../src/dom.js
../src/svg.js
../src/charting/Axis.js
../src/charting/svg/Axis.js
../src/charting/vml/Axis.js
../src/charting/Plotters.js
../src/charting/svg/Plotters.js
../src/charting/vml/Plotters.js
../src/charting/Series.js
../src/charting/Plot.js
../src/charting/PlotArea.js
../src/charting/svg/PlotArea.js
../src/charting/vml/PlotArea.js
../src/charting/Chart.js
__CPAN_EDITION__ core dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:2,flag:"",revision:Number("$Rev: 7616 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
function dj_load_init(e){
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_ee,_ef){
if(!dojo.lang.isFunction(_ef)){
dojo.raise("dojo.inherits: superclass argument ["+_ef+"] must be a function (subclass: ["+_ee+"']");
}
_ee.prototype=new _ef();
_ee.prototype.constructor=_ee;
_ee.superclass=_ef.prototype;
_ee["super"]=_ef.prototype;
};
dojo.lang._mixin=function(obj,_f1){
var _f2={};
for(var x in _f1){
if((typeof _f2[x]=="undefined")||(_f2[x]!=_f1[x])){
obj[x]=_f1[x];
}
}
if(dojo.render.html.ie&&(typeof (_f1["toString"])=="function")&&(_f1["toString"]!=obj["toString"])&&(_f1["toString"]!=_f2["toString"])){
obj.toString=_f1.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_f5){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_f8,_f9){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_f8.prototype,arguments[i]);
}
return _f8;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_fc,_fd,_fe,_ff){
if(!dojo.lang.isArrayLike(_fc)&&dojo.lang.isArrayLike(_fd)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_fc;
_fc=_fd;
_fd=temp;
}
var _101=dojo.lang.isString(_fc);
if(_101){
_fc=_fc.split("");
}
if(_ff){
var step=-1;
var i=_fc.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_fc.length;
}
if(_fe){
while(i!=end){
if(_fc[i]===_fd){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_fc[i]==_fd){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_105,_106,_107){
return dojo.lang.find(_105,_106,_107,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_108,_109){
return dojo.lang.find(_108,_109)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _118=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_118++;
break;
}
}
return _118==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
},map:function(arr,obj,_11c){
var _11d=dojo.lang.isString(arr);
if(_11d){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_11c)){
_11c=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_11c){
var _11e=obj;
obj=_11c;
_11c=_11e;
}
}
if(Array.map){
var _11f=Array.map(arr,_11c,obj);
}else{
var _11f=[];
for(var i=0;i<arr.length;++i){
_11f.push(_11c.call(obj,arr[i]));
}
}
if(_11d){
return _11f.join("");
}else{
return _11f;
}
},reduce:function(arr,_122,obj,_124){
var _125=_122;
if(arguments.length==2){
_124=_122;
_125=arr[0];
arr=arr.slice(1);
}else{
if(arguments.length==3){
if(dojo.lang.isFunction(obj)){
_124=obj;
obj=null;
}
}else{
if(dojo.lang.isFunction(obj)){
var tmp=_124;
_124=obj;
obj=tmp;
}
}
}
var ob=obj||dj_global;
dojo.lang.map(arr,function(val){
_125=_124.call(ob,_125,val);
});
return _125;
},forEach:function(_129,_12a,_12b){
if(dojo.lang.isString(_129)){
_129=_129.split("");
}
if(Array.forEach){
Array.forEach(_129,_12a,_12b);
}else{
if(!_12b){
_12b=dj_global;
}
for(var i=0,l=_129.length;i<l;i++){
_12a.call(_12b,_129[i],i,_129);
}
}
},_everyOrSome:function(_12e,arr,_130,_131){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_12e?"every":"some"](arr,_130,_131);
}else{
if(!_131){
_131=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _134=_130.call(_131,arr[i],i,arr);
if(_12e&&!_134){
return false;
}else{
if((!_12e)&&(_134)){
return true;
}
}
}
return Boolean(_12e);
}
},every:function(arr,_136,_137){
return this._everyOrSome(true,arr,_136,_137);
},some:function(arr,_139,_13a){
return this._everyOrSome(false,arr,_139,_13a);
},filter:function(arr,_13c,_13d){
var _13e=dojo.lang.isString(arr);
if(_13e){
arr=arr.split("");
}
var _13f;
if(Array.filter){
_13f=Array.filter(arr,_13c,_13d);
}else{
if(!_13d){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_13d=dj_global;
}
_13f=[];
for(var i=0;i<arr.length;i++){
if(_13c.call(_13d,arr[i],i,arr)){
_13f.push(arr[i]);
}
}
}
if(_13e){
return _13f.join("");
}else{
return _13f;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_144,_145){
var _146=[];
for(var i=_145||0;i<_144.length;i++){
_146.push(_144[i]);
}
return _146;
}});
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_149){
var _14a=window,_14b=2;
if(!dojo.lang.isFunction(func)){
_14a=func;
func=_149;
_149=arguments[2];
_14b++;
}
if(dojo.lang.isString(func)){
func=_14a[func];
}
var args=[];
for(var i=_14b;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_14a,args);
},_149);
};
dojo.lang.clearTimeout=function(_14e){
dojo.global().clearTimeout(_14e);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_157,_158,_159){
with(dojo.parseObjPath(_157,_158,_159)){
return dojo.evalProp(prop,obj,_159);
}
};
dojo.lang.setObjPathValue=function(_15a,_15b,_15c,_15d){
dojo.deprecated("dojo.lang.setObjPathValue","use dojo.parseObjPath and the '=' operator","0.6");
if(arguments.length<4){
_15d=true;
}
with(dojo.parseObjPath(_15a,_15c,_15d)){
if(obj&&(_15d||(prop in obj))){
obj[prop]=_15b;
}
}
};
dojo.provide("dojo.lang.declare");
dojo.lang.declare=function(_15e,_15f,init,_161){
if((dojo.lang.isFunction(_161))||((!_161)&&(!dojo.lang.isFunction(init)))){
var temp=_161;
_161=init;
init=temp;
}
var _163=[];
if(dojo.lang.isArray(_15f)){
_163=_15f;
_15f=_163.shift();
}
if(!init){
init=dojo.evalObjPath(_15e,false);
if((init)&&(!dojo.lang.isFunction(init))){
init=null;
}
}
var ctor=dojo.lang.declare._makeConstructor();
var scp=(_15f?_15f.prototype:null);
if(scp){
scp.prototyping=true;
ctor.prototype=new _15f();
scp.prototyping=false;
}
ctor.superclass=scp;
ctor.mixins=_163;
for(var i=0,l=_163.length;i<l;i++){
dojo.lang.extend(ctor,_163[i].prototype);
}
ctor.prototype.initializer=null;
ctor.prototype.declaredClass=_15e;
if(dojo.lang.isArray(_161)){
dojo.lang.extend.apply(dojo.lang,[ctor].concat(_161));
}else{
dojo.lang.extend(ctor,(_161)||{});
}
dojo.lang.extend(ctor,dojo.lang.declare._common);
ctor.prototype.constructor=ctor;
ctor.prototype.initializer=(ctor.prototype.initializer)||(init)||(function(){
});
var _168=dojo.parseObjPath(_15e,null,true);
_168.obj[_168.prop]=ctor;
return ctor;
};
dojo.lang.declare._makeConstructor=function(){
return function(){
var self=this._getPropContext();
var s=self.constructor.superclass;
if((s)&&(s.constructor)){
if(s.constructor==arguments.callee){
this._inherited("constructor",arguments);
}else{
this._contextMethod(s,"constructor",arguments);
}
}
var ms=(self.constructor.mixins)||([]);
for(var i=0,m;(m=ms[i]);i++){
(((m.prototype)&&(m.prototype.initializer))||(m)).apply(this,arguments);
}
if((!this.prototyping)&&(self.initializer)){
self.initializer.apply(this,arguments);
}
};
};
dojo.lang.declare._common={_getPropContext:function(){
return (this.___proto||this);
},_contextMethod:function(_16e,_16f,args){
var _171,_172=this.___proto;
this.___proto=_16e;
try{
_171=_16e[_16f].apply(this,(args||[]));
}
catch(e){
throw e;
}
finally{
this.___proto=_172;
}
return _171;
},_inherited:function(prop,args){
var p=this._getPropContext();
do{
if((!p.constructor)||(!p.constructor.superclass)){
return;
}
p=p.constructor.superclass;
}while(!(prop in p));
return (dojo.lang.isFunction(p[prop])?this._contextMethod(p,prop,args):p[prop]);
},inherited:function(prop,args){
dojo.deprecated("'inherited' method is dangerous, do not up-call! 'inherited' is slated for removal in 0.5; name your super class (or use superclass property) instead.","0.5");
this._inherited(prop,args);
}};
dojo.declare=dojo.lang.declare;
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_178,_179){
var fcn=(dojo.lang.isString(_179)?_178[_179]:_179)||function(){
};
return function(){
return fcn.apply(_178,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_17b,_17c,_17d){
var nso=(_17c||dojo.lang.anon);
if((_17d)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_17b){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_17b;
return ret;
};
dojo.lang.forward=function(_181){
return function(){
return this[_181].apply(this,arguments);
};
};
dojo.lang.curry=function(_182,func){
var _184=[];
_182=_182||dj_global;
if(dojo.lang.isString(func)){
func=_182[func];
}
for(var x=2;x<arguments.length;x++){
_184.push(arguments[x]);
}
var _186=(func["__preJoinArity"]||func.length)-_184.length;
function gather(_187,_188,_189){
var _18a=_189;
var _18b=_188.slice(0);
for(var x=0;x<_187.length;x++){
_18b.push(_187[x]);
}
_189=_189-_187.length;
if(_189<=0){
var res=func.apply(_182,_18b);
_189=_18a;
return res;
}else{
return function(){
return gather(arguments,_18b,_189);
};
}
}
return gather([],_184,_186);
};
dojo.lang.curryArguments=function(_18e,func,args,_191){
var _192=[];
var x=_191||0;
for(x=_191;x<args.length;x++){
_192.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_18e,func].concat(_192));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_198,_199){
if(!farr.length){
if(typeof _199=="function"){
_199();
}
return;
}
if((typeof _198=="undefined")&&(typeof cb=="number")){
_198=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_198){
_198=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_198,_199);
},_198);
};
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_19b){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false,maxCalls:-1};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _19e=dl.nameAnonFunc(args[2],ao.adviceObj,_19b);
ao.adviceFunc=_19e;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _19e=dl.nameAnonFunc(args[0],ao.srcObj,_19b);
ao.srcFunc=_19e;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _19e=dl.nameAnonFunc(args[1],dj_global,_19b);
ao.srcFunc=_19e;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _19e=dl.nameAnonFunc(args[3],dj_global,_19b);
ao.adviceObj=dj_global;
ao.adviceFunc=_19e;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
ao.maxCalls=(!isNaN(parseInt(args[11])))?args[11]:-1;
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _19e=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_19b);
ao.aroundFunc=_19e;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _1a0={};
for(var x in ao){
_1a0[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_1a0.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_1a0));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _1a8;
if((arguments.length==1)&&(typeof a1=="object")){
_1a8=a1;
}else{
_1a8={srcObj:a1,srcFunc:a2};
}
_1a8.adviceFunc=function(){
var _1a9=[];
for(var x=0;x<arguments.length;x++){
_1a9.push(arguments[x]);
}
dojo.debug("("+_1a8.srcObj+")."+_1a8.srcFunc,":",_1a9.join(", "));
};
this.kwConnect(_1a8);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this.connectRunOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.maxCalls=1;
return this.connect(ao);
};
this._kwConnectImpl=function(_1b1,_1b2){
var fn=(_1b2)?"disconnect":"connect";
if(typeof _1b1["srcFunc"]=="function"){
_1b1.srcObj=_1b1["srcObj"]||dj_global;
var _1b4=dojo.lang.nameAnonFunc(_1b1.srcFunc,_1b1.srcObj,true);
_1b1.srcFunc=_1b4;
}
if(typeof _1b1["adviceFunc"]=="function"){
_1b1.adviceObj=_1b1["adviceObj"]||dj_global;
var _1b4=dojo.lang.nameAnonFunc(_1b1.adviceFunc,_1b1.adviceObj,true);
_1b1.adviceFunc=_1b4;
}
_1b1.srcObj=_1b1["srcObj"]||dj_global;
_1b1.adviceObj=_1b1["adviceObj"]||_1b1["targetObj"]||dj_global;
_1b1.adviceFunc=_1b1["adviceFunc"]||_1b1["targetFunc"];
return dojo.event[fn](_1b1);
};
this.kwConnect=function(_1b5){
return this._kwConnectImpl(_1b5,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
if(!ao.srcObj[ao.srcFunc]){
return null;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc,true);
mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
return mjp;
};
this.kwDisconnect=function(_1b8){
return this._kwConnectImpl(_1b8,true);
};
};
dojo.event.MethodInvocation=function(_1b9,obj,args){
this.jp_=_1b9;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_1c1){
this.object=obj||dj_global;
this.methodname=_1c1;
this.methodfunc=this.object[_1c1];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_1c3){
if(!obj){
obj=dj_global;
}
var ofn=obj[_1c3];
if(!ofn){
ofn=obj[_1c3]=function(){
};
if(!obj[_1c3]){
dojo.raise("Cannot set do-nothing method on that object "+_1c3);
}
}else{
if((typeof ofn!="function")&&(!dojo.lang.isFunction(ofn))&&(!dojo.lang.isAlien(ofn))){
return null;
}
}
var _1c5=_1c3+"$joinpoint";
var _1c6=_1c3+"$joinpoint$method";
var _1c7=obj[_1c5];
if(!_1c7){
var _1c8=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_1c8=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_1c5,_1c6,_1c3]);
}
}
var _1c9=ofn.length;
obj[_1c6]=ofn;
_1c7=obj[_1c5]=new dojo.event.MethodJoinPoint(obj,_1c6);
if(!_1c8){
obj[_1c3]=function(){
return _1c7.run.apply(_1c7,arguments);
};
}else{
obj[_1c3]=function(){
var args=[];
if(!arguments.length){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _1c7.run.apply(_1c7,args);
};
}
obj[_1c3].__preJoinArity=_1c9;
}
return _1c7;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{squelch:false,unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _1cf=[];
for(var x=0;x<args.length;x++){
_1cf[x]=args[x];
}
var _1d1=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _1d3=marr[0]||dj_global;
var _1d4=marr[1];
if(!_1d3[_1d4]){
dojo.raise("function \""+_1d4+"\" does not exist on \""+_1d3+"\"");
}
var _1d5=marr[2]||dj_global;
var _1d6=marr[3];
var msg=marr[6];
var _1d8=marr[7];
if(_1d8>-1){
if(_1d8==0){
return;
}
marr[7]--;
}
var _1d9;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _1d3[_1d4].apply(_1d3,to.args);
}};
to.args=_1cf;
var _1db=parseInt(marr[4]);
var _1dc=((!isNaN(_1db))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _1df=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_1d1(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_1d6){
_1d5[_1d6].call(_1d5,to);
}else{
if((_1dc)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_1d3[_1d4].call(_1d3,to);
}else{
_1d3[_1d4].apply(_1d3,args);
}
},_1db);
}else{
if(msg){
_1d3[_1d4].call(_1d3,to);
}else{
_1d3[_1d4].apply(_1d3,args);
}
}
}
};
var _1e2=function(){
if(this.squelch){
try{
return _1d1.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _1d1.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_1e2);
}
var _1e3;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_1e3=mi.proceed();
}else{
if(this.methodfunc){
_1e3=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.debug(e,"when calling",this.methodname,"on",this.object,"with arguments",args);
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_1e2);
}
return (this.methodfunc)?_1e3:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"],args["maxCalls"]);
},addAdvice:function(_1e8,_1e9,_1ea,_1eb,_1ec,_1ed,once,_1ef,rate,_1f1,_1f2){
var arr=this.getArr(_1ec);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_1e8,_1e9,_1ea,_1eb,_1ef,rate,_1f1,_1f2];
if(once){
if(this.hasAdvice(_1e8,_1e9,_1ec,arr)>=0){
return;
}
}
if(_1ed=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_1f5,_1f6,_1f7,arr){
if(!arr){
arr=this.getArr(_1f7);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _1f6=="object")?(new String(_1f6)).toString():_1f6;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_1f5)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_1fd,_1fe,_1ff,once){
var arr=this.getArr(_1ff);
var ind=this.hasAdvice(_1fd,_1fe,_1ff,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_1fd,_1fe,_1ff,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_203){
if(!this.topics[_203]){
this.topics[_203]=new this.TopicImpl(_203);
}
return this.topics[_203];
};
this.registerPublisher=function(_204,obj,_206){
var _204=this.getTopic(_204);
_204.registerPublisher(obj,_206);
};
this.subscribe=function(_207,obj,_209){
var _207=this.getTopic(_207);
_207.subscribe(obj,_209);
};
this.unsubscribe=function(_20a,obj,_20c){
var _20a=this.getTopic(_20a);
_20a.unsubscribe(obj,_20c);
};
this.destroy=function(_20d){
this.getTopic(_20d).destroy();
delete this.topics[_20d];
};
this.publishApply=function(_20e,args){
var _20e=this.getTopic(_20e);
_20e.sendMessage.apply(_20e,args);
};
this.publish=function(_210,_211){
var _210=this.getTopic(_210);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_210.sendMessage.apply(_210,args);
};
};
dojo.event.topic.TopicImpl=function(_214){
this.topicName=_214;
this.subscribe=function(_215,_216){
var tf=_216||_215;
var to=(!_216)?dj_global:_215;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_219,_21a){
var tf=(!_21a)?_219:_21a;
var to=(!_21a)?null:_219;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_21d){
this._getJoinPoint().squelch=_21d;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_21e,_21f){
dojo.event.connect(_21e,_21f,this,"sendMessage");
};
this.sendMessage=function(_220){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_223){
var na;
var tna;
if(_223){
tna=_223.all||_223.getElementsByTagName("*");
na=[_223];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _227={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
if(dojo.widget){
for(var name in dojo.widget._templateCache){
if(dojo.widget._templateCache[name].node){
dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
dojo.widget._templateCache[name].node=null;
delete dojo.widget._templateCache[name].node;
}
}
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _22c=0;
this.normalizedEventName=function(_22d){
switch(_22d){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _22d;
break;
default:
var lcn=_22d.toLowerCase();
return (lcn.indexOf("on")==0)?lcn.substr(2):lcn;
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_232){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_232.length;x++){
node.__clobberAttrs__.push(_232[x]);
}
};
this.removeListener=function(node,_235,fp,_237){
if(!_237){
var _237=false;
}
_235=dojo.event.browser.normalizedEventName(_235);
if(_235=="key"){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_237);
}
_235="keypress";
}
if(node.removeEventListener){
node.removeEventListener(_235,fp,_237);
}
};
this.addListener=function(node,_239,fp,_23b,_23c){
if(!node){
return;
}
if(!_23b){
var _23b=false;
}
_239=dojo.event.browser.normalizedEventName(_239);
if(_239=="key"){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_23b,_23c);
}
_239="keypress";
}
if(!_23c){
var _23d=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_23b){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_23d=fp;
}
if(node.addEventListener){
node.addEventListener(_239,_23d,_23b);
return _23d;
}else{
_239="on"+_239;
if(typeof node[_239]=="function"){
var _240=node[_239];
node[_239]=function(e){
_240(e);
return _23d(e);
};
}else{
node[_239]=_23d;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_239]);
}
return _23d;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(obj)&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_243,_244){
if(typeof _243!="function"){
dojo.raise("listener not a function: "+_243);
}
dojo.event.browser.currentEvent.currentTarget=_244;
return _243.call(_244,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_247){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _249=evt.keyCode;
if(_249>=65&&_249<=90&&evt.shiftKey==false){
_249+=32;
}
if(_249>=1&&_249<=26&&evt.ctrlKey){
_249+=96;
}
evt.key=String.fromCharCode(_249);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _249=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_249+=32;
}
evt.key=String.fromCharCode(_249);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 25:
evt.key=evt.KEY_TAB;
evt.shift=true;
break;
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
case 63236:
evt.key=evt.KEY_F1;
break;
case 63237:
evt.key=evt.KEY_F2;
break;
case 63238:
evt.key=evt.KEY_F3;
break;
case 63239:
evt.key=evt.KEY_F4;
break;
case 63240:
evt.key=evt.KEY_F5;
break;
case 63241:
evt.key=evt.KEY_F6;
break;
case 63242:
evt.key=evt.KEY_F7;
break;
case 63243:
evt.key=evt.KEY_F8;
break;
case 63244:
evt.key=evt.KEY_F9;
break;
case 63245:
evt.key=evt.KEY_F10;
break;
case 63246:
evt.key=evt.KEY_F11;
break;
case 63247:
evt.key=evt.KEY_F12;
break;
case 63250:
evt.key=evt.KEY_PAUSE;
break;
case 63272:
evt.key=evt.KEY_DELETE;
break;
case 63273:
evt.key=evt.KEY_HOME;
break;
case 63275:
evt.key=evt.KEY_END;
break;
case 63276:
evt.key=evt.KEY_PAGE_UP;
break;
case 63277:
evt.key=evt.KEY_PAGE_DOWN;
break;
case 63302:
evt.key=evt.KEY_INSERT;
break;
case 63248:
case 63249:
case 63289:
break;
default:
evt.key=evt.charCode>=evt.KEY_SPACE?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_247?_247:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _24b=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_24b.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_24b.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.cancelBubble=true;
evt.returnValue=false;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.kwCompoundRequire({common:["dojo.event.common","dojo.event.topic"],browser:["dojo.event.browser"],dashboard:["dojo.event.browser"]});
dojo.provide("dojo.event.*");
dojo.provide("dojo.event");
dojo.deprecated("dojo.event","replaced by dojo.event.*","0.5");
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_253,_254){
var out="";
for(var i=0;i<_253;i++){
out+=str;
if(_254&&i<_253-1){
out+=_254;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_262,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _262.replace(/\%\{(\w+)\}/g,function(_265,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _268=str.split(" ");
for(var i=0;i<_268.length;i++){
_268[i]=_268[i].charAt(0).toUpperCase()+_268[i].substring(1);
}
return _268.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _26d=escape(str);
var _26e,re=/%u([0-9A-F]{4})/i;
while((_26e=_26d.match(re))){
var num=Number("0x"+_26e[1]);
var _271=escape("&#"+num+";");
ret+=_26d.substring(0,_26e.index)+_271;
_26d=_26d.substring(_26e.index+_26e[0].length);
}
ret+=_26d.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_276){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_276){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_27f){
if(_27f){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_283,_284){
if(_284){
str=str.toLowerCase();
_283=_283.toLowerCase();
}
return str.indexOf(_283)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_28a){
if(_28a=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_28a=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_28c){
var _28d=[];
for(var i=0,_28f=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_28c){
_28d.push(str.substring(_28f,i));
_28f=i+1;
}
}
_28d.push(str.substr(_28f));
return _28d;
};
dojo.provide("dojo.string");
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_291,_292,_293){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_291){
this.mimetype=_291;
}
if(_292){
this.transport=_292;
}
if(arguments.length>=4){
this.changeUrl=_293;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,load:function(type,data,_296,_297){
},error:function(type,_299,_29a,_29b){
},timeout:function(type,_29d,_29e,_29f){
},handle:function(type,data,_2a2,_2a3){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_2a4){
if(_2a4["url"]){
_2a4.url=_2a4.url.toString();
}
if(_2a4["formNode"]){
_2a4.formNode=dojo.byId(_2a4.formNode);
}
if(!_2a4["method"]&&_2a4["formNode"]&&_2a4["formNode"].method){
_2a4.method=_2a4["formNode"].method;
}
if(!_2a4["handle"]&&_2a4["handler"]){
_2a4.handle=_2a4.handler;
}
if(!_2a4["load"]&&_2a4["loaded"]){
_2a4.load=_2a4.loaded;
}
if(!_2a4["changeUrl"]&&_2a4["changeURL"]){
_2a4.changeUrl=_2a4.changeURL;
}
_2a4.encoding=dojo.lang.firstValued(_2a4["encoding"],djConfig["bindEncoding"],"");
_2a4.sendTransport=dojo.lang.firstValued(_2a4["sendTransport"],djConfig["ioSendTransport"],false);
var _2a5=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_2a4[fn]&&_2a5(_2a4[fn])){
continue;
}
if(_2a4["handle"]&&_2a5(_2a4["handle"])){
_2a4[fn]=_2a4.handle;
}
}
dojo.lang.mixin(this,_2a4);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_2ac){
if(!(_2ac instanceof dojo.io.Request)){
try{
_2ac=new dojo.io.Request(_2ac);
}
catch(e){
dojo.debug(e);
}
}
var _2ad="";
if(_2ac["transport"]){
_2ad=_2ac["transport"];
if(!this[_2ad]){
dojo.io.sendBindError(_2ac,"No dojo.io.bind() transport with name '"+_2ac["transport"]+"'.");
return _2ac;
}
if(!this[_2ad].canHandle(_2ac)){
dojo.io.sendBindError(_2ac,"dojo.io.bind() transport with name '"+_2ac["transport"]+"' cannot handle this type of request.");
return _2ac;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_2ac))){
_2ad=tmp;
break;
}
}
if(_2ad==""){
dojo.io.sendBindError(_2ac,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _2ac;
}
}
this[_2ad].bind(_2ac);
_2ac.bindSuccess=true;
return _2ac;
};
dojo.io.sendBindError=function(_2b0,_2b1){
if((typeof _2b0.error=="function"||typeof _2b0.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _2b2=new dojo.io.Error(_2b1);
setTimeout(function(){
_2b0[(typeof _2b0.error=="function")?"error":"handle"]("error",_2b2,null,_2b0);
},50);
}else{
dojo.raise(_2b1);
}
};
dojo.io.queueBind=function(_2b3){
if(!(_2b3 instanceof dojo.io.Request)){
try{
_2b3=new dojo.io.Request(_2b3);
}
catch(e){
dojo.debug(e);
}
}
var _2b4=_2b3.load;
_2b3.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_2b4.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _2b6=_2b3.error;
_2b3.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_2b6.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_2b3);
dojo.io._dispatchNextQueueBind();
return _2b3;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_2b9,last){
var enc=/utf/i.test(_2b9||"")?encodeURIComponent:dojo.string.encodeAscii;
var _2bc=[];
var _2bd=new Object();
for(var name in map){
var _2bf=function(elt){
var val=enc(name)+"="+enc(elt);
_2bc[(last==name)?"push":"unshift"](val);
};
if(!_2bd[name]){
var _2c2=map[name];
if(dojo.lang.isArray(_2c2)){
dojo.lang.forEach(_2c2,_2bf);
}else{
_2bf(_2c2);
}
}
}
return _2bc.join("&");
};
dojo.io.setIFrameSrc=function(_2c3,src,_2c5){
try{
var r=dojo.render.html;
if(!_2c5){
if(r.safari){
_2c3.location=src;
}else{
frames[_2c3.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_2c3.contentWindow.document;
}else{
if(r.safari){
idoc=_2c3.document;
}else{
idoc=_2c3.contentWindow;
}
}
if(!idoc){
_2c3.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _2c9=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_2c9.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_2cb,_2cc){
var node=_2cb.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_2cc&&node&&node.tagName&&node.tagName.toLowerCase()!=_2cc.toLowerCase()){
node=dojo.dom.nextElement(node,_2cc);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_2ce,_2cf){
var node=_2ce.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_2cf&&node&&node.tagName&&node.tagName.toLowerCase()!=_2cf.toLowerCase()){
node=dojo.dom.prevElement(node,_2cf);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_2d2){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_2d2&&_2d2.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_2d2);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_2d4){
if(!node){
return null;
}
if(_2d4){
_2d4=_2d4.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_2d4&&_2d4.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_2d4);
}
return node;
};
dojo.dom.moveChildren=function(_2d5,_2d6,trim){
var _2d8=0;
if(trim){
while(_2d5.hasChildNodes()&&_2d5.firstChild.nodeType==dojo.dom.TEXT_NODE){
_2d5.removeChild(_2d5.firstChild);
}
while(_2d5.hasChildNodes()&&_2d5.lastChild.nodeType==dojo.dom.TEXT_NODE){
_2d5.removeChild(_2d5.lastChild);
}
}
while(_2d5.hasChildNodes()){
_2d6.appendChild(_2d5.firstChild);
_2d8++;
}
return _2d8;
};
dojo.dom.copyChildren=function(_2d9,_2da,trim){
var _2dc=_2d9.cloneNode(true);
return this.moveChildren(_2dc,_2da,trim);
};
dojo.dom.replaceChildren=function(node,_2de){
var _2df=[];
if(dojo.render.html.ie){
for(var i=0;i<node.childNodes.length;i++){
_2df.push(node.childNodes[i]);
}
}
dojo.dom.removeChildren(node);
node.appendChild(_2de);
for(var i=0;i<_2df.length;i++){
dojo.dom.destroyNode(_2df[i]);
}
};
dojo.dom.removeChildren=function(node){
var _2e2=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _2e2;
};
dojo.dom.replaceNode=function(node,_2e4){
return node.parentNode.replaceChild(_2e4,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.evalObjPath("dojo.event.browser.clean",false)){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_2e8,_2e9){
var _2ea=[];
var _2eb=(_2e8&&(_2e8 instanceof Function||typeof _2e8=="function"));
while(node){
if(!_2eb||_2e8(node)){
_2ea.push(node);
}
if(_2e9&&_2ea.length>0){
return _2ea[0];
}
node=node.parentNode;
}
if(_2e9){
return null;
}
return _2ea;
};
dojo.dom.getAncestorsByTag=function(node,tag,_2ee){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_2ee);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_2f3,_2f4){
if(_2f4&&node){
node=node.parentNode;
}
while(node){
if(node==_2f3){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _2f7=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _2f8=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_2f8.length;i++){
try{
doc=new ActiveXObject(_2f8[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_2f7.implementation)&&(_2f7.implementation.createDocument)){
doc=_2f7.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_2fb){
if(!_2fb){
_2fb="text/xml";
}
if(!dj_undef("DOMParser")){
var _2fc=new DOMParser();
return _2fc.parseFromString(str,_2fb);
}else{
if(!dj_undef("ActiveXObject")){
var _2fd=dojo.dom.createDocument();
if(_2fd){
_2fd.async=false;
_2fd.loadXML(str);
return _2fd;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _2fe=dojo.doc();
if(_2fe.createElement){
var tmp=_2fe.createElement("xml");
tmp.innerHTML=str;
if(_2fe.implementation&&_2fe.implementation.createDocument){
var _300=_2fe.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_300.importNode(tmp.childNodes.item(i),true);
}
return _300;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_303){
if(_303.firstChild){
_303.insertBefore(node,_303.firstChild);
}else{
_303.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_306){
if((_306!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _307=ref.parentNode;
_307.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_30a){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_30a!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_30a);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_30e){
if((!node)||(!ref)||(!_30e)){
return false;
}
switch(_30e.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_310,_311){
var _312=_310.childNodes;
if(!_312.length||_312.length==_311){
_310.appendChild(node);
return true;
}
if(_311==0){
return dojo.dom.prependChild(node,_310);
}
return dojo.dom.insertAfter(node,_312[_311-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _315=dojo.doc();
dojo.dom.replaceChildren(node,_315.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _316="";
if(node==null){
return _316;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_316+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_316+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _316;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_31c,_31d,_31e){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_31c,_31d,_31e);
}else{
var _31f=elem.ownerDocument;
var _320=_31f.createNode(2,_31d,_31c);
_320.nodeValue=_31e;
elem.setAttributeNode(_320);
}
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:(!dj_undef("window"))?window.location.href:"",initialHash:(!dj_undef("window"))?window.location.hash:"",moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
if(djConfig["useXDomain"]&&!djConfig["dojoIframeHistoryUrl"]){
dojo.debug("dojo.undo.browser: When using cross-domain Dojo builds,"+" please save iframe_history.html to your domain and set djConfig.dojoIframeHistoryUrl"+" to the path on your domain to iframe_history.html");
}
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _325=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_327){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_325.apply(this,[_327]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _328=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_32a){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_328){
_328.apply(this,[_32a]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_32d){
if(!dojo.render.html.opera){
var _32e=this._getUrlQuery(_32d.href);
if(_32e==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_32e==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_32e==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _32f=this.historyStack.pop();
if(!_32f){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_32f);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _336=url.split("?");
if(_336.length<2){
return null;
}else{
return _336[1];
}
},_loadIframeHistory:function(){
var url=(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
if(!dj_undef("window")){
dojo.io.checkChildrenForFile=function(node){
var _339=false;
var _33a=node.getElementsByTagName("input");
dojo.lang.forEach(_33a,function(_33b){
if(_339){
return;
}
if(_33b.getAttribute("type")=="file"){
_339=true;
}
});
return _339;
};
dojo.io.formHasFile=function(_33c){
return dojo.io.checkChildrenForFile(_33c);
};
dojo.io.updateNode=function(node,_33e){
node=dojo.byId(node);
var args=_33e;
if(dojo.lang.isString(_33e)){
args={url:_33e};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
dojo.dom.destroyNode(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_345,_346,_347){
if((!_345)||(!_345.tagName)||(!_345.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_347){
_347=dojo.io.formFilter;
}
var enc=/utf/i.test(_346||"")?encodeURIComponent:dojo.string.encodeAscii;
var _349=[];
for(var i=0;i<_345.elements.length;i++){
var elm=_345.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_347(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_349.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_349.push(name+"="+enc(elm.value));
}
}else{
_349.push(name+"="+enc(elm.value));
}
}
}
var _34f=_345.getElementsByTagName("input");
for(var i=0;i<_34f.length;i++){
var _350=_34f[i];
if(_350.type.toLowerCase()=="image"&&_350.form==_345&&_347(_350)){
var name=enc(_350.name);
_349.push(name+"="+enc(_350.value));
_349.push(name+".x=0");
_349.push(name+".y=0");
}
}
return _349.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _356=form.getElementsByTagName("input");
for(var i=0;i<_356.length;i++){
var _357=_356[i];
if(_357.type.toLowerCase()=="image"&&_357.form==form){
this.connect(_357,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _35e=false;
if(node.disabled||!node.name){
_35e=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_35e=node==this.clickedButton;
}else{
_35e=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _35e;
},connect:function(_35f,_360,_361){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_35f,_360,this,_361);
}else{
var fcn=dojo.lang.hitch(this,_361);
_35f[_360]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _364=this;
var _365={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_367,_368){
return url+"|"+_367+"|"+_368.toLowerCase();
}
function addToCache(url,_36a,_36b,http){
_365[getCacheKey(url,_36a,_36b)]=http;
}
function getFromCache(url,_36e,_36f){
return _365[getCacheKey(url,_36e,_36f)];
}
this.clearCache=function(){
_365={};
};
function doLoad(_370,http,url,_373,_374){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_370.method.toLowerCase()=="head"){
var _376=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _376;
};
var _377=_376.split(/[\r\n]+/g);
for(var i=0;i<_377.length;i++){
var pair=_377[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_370.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_370.mimetype=="text/json"||_370.mimetype=="application/json"){
try{
ret=dj_eval("("+http.responseText+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_370.mimetype=="application/xml")||(_370.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_374){
addToCache(url,_373,_370.method,http);
}
_370[(typeof _370.load=="function")?"load":"handle"]("load",ret,http,_370);
}else{
var _37a=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_370[(typeof _370.error=="function")?"error":"handle"]("error",_37a,http,_370);
}
}
function setHeaders(http,_37c){
if(_37c["headers"]){
for(var _37d in _37c["headers"]){
if(_37d.toLowerCase()=="content-type"&&!_37c["contentType"]){
_37c["contentType"]=_37c["headers"][_37d];
}else{
http.setRequestHeader(_37d,_37c["headers"][_37d]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_364._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _381=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_381,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _382=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_383){
return _382&&dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript","text/json","application/json"],(_383["mimetype"].toLowerCase()||""))&&!(_383["formNode"]&&dojo.io.formHasFile(_383["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_384){
if(!_384["url"]){
if(!_384["formNode"]&&(_384["backButton"]||_384["back"]||_384["changeUrl"]||_384["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_384);
return true;
}
}
var url=_384.url;
var _386="";
if(_384["formNode"]){
var ta=_384.formNode.getAttribute("action");
if((ta)&&(!_384["url"])){
url=ta;
}
var tp=_384.formNode.getAttribute("method");
if((tp)&&(!_384["method"])){
_384.method=tp;
}
_386+=dojo.io.encodeForm(_384.formNode,_384.encoding,_384["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_384["file"]){
_384.method="post";
}
if(!_384["method"]){
_384.method="get";
}
if(_384.method.toLowerCase()=="get"){
_384.multipart=false;
}else{
if(_384["file"]){
_384.multipart=true;
}else{
if(!_384["multipart"]){
_384.multipart=false;
}
}
}
if(_384["backButton"]||_384["back"]||_384["changeUrl"]){
dojo.undo.browser.addToHistory(_384);
}
var _389=_384["content"]||{};
if(_384.sendTransport){
_389["dojo.transport"]="xmlhttp";
}
do{
if(_384.postContent){
_386=_384.postContent;
break;
}
if(_389){
_386+=dojo.io.argsFromMap(_389,_384.encoding);
}
if(_384.method.toLowerCase()=="get"||!_384.multipart){
break;
}
var t=[];
if(_386.length){
var q=_386.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_384.file){
if(dojo.lang.isArray(_384.file)){
for(var i=0;i<_384.file.length;++i){
var o=_384.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_384.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_386=t.join("\r\n");
}
}while(false);
var _38f=_384["sync"]?false:true;
var _390=_384["preventCache"]||(this.preventCache==true&&_384["preventCache"]!=false);
var _391=_384["useCache"]==true||(this.useCache==true&&_384["useCache"]!=false);
if(!_390&&_391){
var _392=getFromCache(url,_386,_384.method);
if(_392){
doLoad(_384,_392,url,_386,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_384);
var _394=false;
if(_38f){
var _395=this.inFlight.push({"req":_384,"http":http,"url":url,"query":_386,"useCache":_391,"startTime":_384.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_364._blockAsync=true;
}
if(_384.method.toLowerCase()=="post"){
if(!_384.user){
http.open("POST",url,_38f);
}else{
http.open("POST",url,_38f,_384.user,_384.password);
}
setHeaders(http,_384);
http.setRequestHeader("Content-Type",_384.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_384.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_386);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_384,{status:404},url,_386,_391);
}
}else{
var _396=url;
if(_386!=""){
_396+=(_396.indexOf("?")>-1?"&":"?")+_386;
}
if(_390){
_396+=(dojo.string.endsWithAny(_396,"?","&")?"":(_396.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_384.user){
http.open(_384.method.toUpperCase(),_396,_38f);
}else{
http.open(_384.method.toUpperCase(),_396,_38f,_384.user,_384.password);
}
setHeaders(http,_384);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_384,{status:404},url,_386,_391);
}
}
if(!_38f){
doLoad(_384,http,url,_386,_391);
_364._blockAsync=false;
}
_384.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
}
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_398,days,path,_39b,_39c){
var _39d=-1;
if((typeof days=="number")&&(days>=0)){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_39d=d.toGMTString();
}
_398=escape(_398);
document.cookie=name+"="+_398+";"+(_39d!=-1?" expires="+_39d+";":"")+(path?"path="+path:"")+(_39b?"; domain="+_39b:"")+(_39c?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _3a1=document.cookie.substring(idx+name.length+1);
var end=_3a1.indexOf(";");
if(end==-1){
end=_3a1.length;
}
_3a1=_3a1.substring(0,end);
_3a1=unescape(_3a1);
return _3a1;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_3a8,_3a9,_3aa){
if(arguments.length==5){
_3aa=_3a8;
_3a8=null;
_3a9=null;
}
var _3ab=[],_3ac,_3ad="";
if(!_3aa){
_3ac=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_3ac){
_3ac={};
}
for(var prop in obj){
if(obj[prop]==null){
delete _3ac[prop];
}else{
if((typeof obj[prop]=="string")||(typeof obj[prop]=="number")){
_3ac[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _3ac){
_3ab.push(escape(prop)+"="+escape(_3ac[prop]));
}
_3ad=_3ab.join("&");
}
dojo.io.cookie.setCookie(name,_3ad,days,path,_3a8,_3a9);
};
dojo.io.cookie.getObjectCookie=function(name){
var _3b0=null,_3b1=dojo.io.cookie.getCookie(name);
if(_3b1){
_3b0={};
var _3b2=_3b1.split("&");
for(var i=0;i<_3b2.length;i++){
var pair=_3b2[i].split("=");
var _3b5=pair[1];
if(isNaN(_3b5)){
_3b5=unescape(pair[1]);
}
_3b0[unescape(pair[0])]=_3b5;
}
}
return _3b0;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _3b6=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_3b6=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.kwCompoundRequire({common:["dojo.io.common"],rhino:["dojo.io.RhinoIO"],browser:["dojo.io.BrowserIO","dojo.io.cookie"],dashboard:["dojo.io.BrowserIO","dojo.io.cookie"]});
dojo.provide("dojo.io.*");
dojo.provide("dojo.io");
dojo.deprecated("dojo.io","replaced by dojo.io.*","0.5");
dojo.provide("dojo.AdapterRegistry");
dojo.AdapterRegistry=function(_3b7){
this.pairs=[];
this.returnWrappers=_3b7||false;
};
dojo.lang.extend(dojo.AdapterRegistry,{register:function(name,_3b9,wrap,_3bb,_3bc){
var type=(_3bc)?"unshift":"push";
this.pairs[type]([name,_3b9,wrap,_3bb]);
},match:function(){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[1].apply(this,arguments)){
if((pair[3])||(this.returnWrappers)){
return pair[2];
}else{
return pair[2].apply(this,arguments);
}
}
}
throw new Error("No match found");
},unregister:function(name){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[0]==name){
this.pairs.splice(i,1);
return true;
}
}
return false;
}});
dojo.provide("dojo.json");
dojo.json={jsonRegistry:new dojo.AdapterRegistry(),register:function(name,_3c4,wrap,_3c6){
dojo.json.jsonRegistry.register(name,_3c4,wrap,_3c6);
},evalJson:function(json){
try{
return eval("("+json+")");
}
catch(e){
dojo.debug(e);
return json;
}
},serialize:function(o){
var _3c9=typeof (o);
if(_3c9=="undefined"){
return "undefined";
}else{
if((_3c9=="number")||(_3c9=="boolean")){
return o+"";
}else{
if(o===null){
return "null";
}
}
}
if(_3c9=="string"){
return dojo.string.escapeString(o);
}
var me=arguments.callee;
var _3cb;
if(typeof (o.__json__)=="function"){
_3cb=o.__json__();
if(o!==_3cb){
return me(_3cb);
}
}
if(typeof (o.json)=="function"){
_3cb=o.json();
if(o!==_3cb){
return me(_3cb);
}
}
if(_3c9!="function"&&typeof (o.length)=="number"){
var res=[];
for(var i=0;i<o.length;i++){
var val=me(o[i]);
if(typeof (val)!="string"){
val="undefined";
}
res.push(val);
}
return "["+res.join(",")+"]";
}
try{
window.o=o;
_3cb=dojo.json.jsonRegistry.match(o);
return me(_3cb);
}
catch(e){
}
if(_3c9=="function"){
return null;
}
res=[];
for(var k in o){
var _3d0;
if(typeof (k)=="number"){
_3d0="\""+k+"\"";
}else{
if(typeof (k)=="string"){
_3d0=dojo.string.escapeString(k);
}else{
continue;
}
}
val=me(o[k]);
if(typeof (val)!="string"){
continue;
}
res.push(_3d0+":"+val);
}
return "{"+res.join(",")+"}";
}};
dojo.provide("dojo.html.common");
dojo.lang.mixin(dojo.html,dojo.dom);
dojo.html.body=function(){
dojo.deprecated("dojo.html.body() moved to dojo.body()","0.5");
return dojo.body();
};
dojo.html.getEventTarget=function(evt){
if(!evt){
evt=dojo.global().event||{};
}
var t=(evt.srcElement?evt.srcElement:(evt.target?evt.target:null));
while((t)&&(t.nodeType!=1)){
t=t.parentNode;
}
return t;
};
dojo.html.getViewport=function(){
var _3d3=dojo.global();
var _3d4=dojo.doc();
var w=0;
var h=0;
if(dojo.render.html.mozilla){
w=_3d4.documentElement.clientWidth;
h=_3d3.innerHeight;
}else{
if(!dojo.render.html.opera&&_3d3.innerWidth){
w=_3d3.innerWidth;
h=_3d3.innerHeight;
}else{
if(!dojo.render.html.opera&&dojo.exists(_3d4,"documentElement.clientWidth")){
var w2=_3d4.documentElement.clientWidth;
if(!w||w2&&w2<w){
w=w2;
}
h=_3d4.documentElement.clientHeight;
}else{
if(dojo.body().clientWidth){
w=dojo.body().clientWidth;
h=dojo.body().clientHeight;
}
}
}
}
return {width:w,height:h};
};
dojo.html.getScroll=function(){
var _3d8=dojo.global();
var _3d9=dojo.doc();
var top=_3d8.pageYOffset||_3d9.documentElement.scrollTop||dojo.body().scrollTop||0;
var left=_3d8.pageXOffset||_3d9.documentElement.scrollLeft||dojo.body().scrollLeft||0;
return {top:top,left:left,offset:{x:left,y:top}};
};
dojo.html.getParentByType=function(node,type){
var _3de=dojo.doc();
var _3df=dojo.byId(node);
type=type.toLowerCase();
while((_3df)&&(_3df.nodeName.toLowerCase()!=type)){
if(_3df==(_3de["body"]||_3de["documentElement"])){
return null;
}
_3df=_3df.parentNode;
}
return _3df;
};
dojo.html.getAttribute=function(node,attr){
node=dojo.byId(node);
if((!node)||(!node.getAttribute)){
return null;
}
var ta=typeof attr=="string"?attr:new String(attr);
var v=node.getAttribute(ta.toUpperCase());
if((v)&&(typeof v=="string")&&(v!="")){
return v;
}
if(v&&v.value){
return v.value;
}
if((node.getAttributeNode)&&(node.getAttributeNode(ta))){
return (node.getAttributeNode(ta)).value;
}else{
if(node.getAttribute(ta)){
return node.getAttribute(ta);
}else{
if(node.getAttribute(ta.toLowerCase())){
return node.getAttribute(ta.toLowerCase());
}
}
}
return null;
};
dojo.html.hasAttribute=function(node,attr){
return dojo.html.getAttribute(dojo.byId(node),attr)?true:false;
};
dojo.html.getCursorPosition=function(e){
e=e||dojo.global().event;
var _3e7={x:0,y:0};
if(e.pageX||e.pageY){
_3e7.x=e.pageX;
_3e7.y=e.pageY;
}else{
var de=dojo.doc().documentElement;
var db=dojo.body();
_3e7.x=e.clientX+((de||db)["scrollLeft"])-((de||db)["clientLeft"]);
_3e7.y=e.clientY+((de||db)["scrollTop"])-((de||db)["clientTop"]);
}
return _3e7;
};
dojo.html.isTag=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName.toLowerCase()==String(arguments[i]).toLowerCase()){
return String(arguments[i]).toLowerCase();
}
}
}
return "";
};
if(dojo.render.html.ie&&!dojo.render.html.ie70){
if(window.location.href.substr(0,6).toLowerCase()!="https:"){
(function(){
var _3ec=dojo.doc().createElement("script");
_3ec.src="javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
dojo.doc().getElementsByTagName("head")[0].appendChild(_3ec);
})();
}
}else{
dojo.html.createExternalElement=function(doc,tag){
return doc.createElement(tag);
};
}
dojo.html._callDeprecated=function(_3ef,_3f0,args,_3f2,_3f3){
dojo.deprecated("dojo.html."+_3ef,"replaced by dojo.html."+_3f0+"("+(_3f2?"node, {"+_3f2+": "+_3f2+"}":"")+")"+(_3f3?"."+_3f3:""),"0.5");
var _3f4=[];
if(_3f2){
var _3f5={};
_3f5[_3f2]=args[1];
_3f4.push(args[0]);
_3f4.push(_3f5);
}else{
_3f4=args;
}
var ret=dojo.html[_3f0].apply(dojo.html,args);
if(_3f3){
return ret[_3f3];
}else{
return ret;
}
};
dojo.html.getViewportWidth=function(){
return dojo.html._callDeprecated("getViewportWidth","getViewport",arguments,null,"width");
};
dojo.html.getViewportHeight=function(){
return dojo.html._callDeprecated("getViewportHeight","getViewport",arguments,null,"height");
};
dojo.html.getViewportSize=function(){
return dojo.html._callDeprecated("getViewportSize","getViewport",arguments);
};
dojo.html.getScrollTop=function(){
return dojo.html._callDeprecated("getScrollTop","getScroll",arguments,null,"top");
};
dojo.html.getScrollLeft=function(){
return dojo.html._callDeprecated("getScrollLeft","getScroll",arguments,null,"left");
};
dojo.html.getScrollOffset=function(){
return dojo.html._callDeprecated("getScrollOffset","getScroll",arguments,null,"offset");
};
dojo.provide("dojo.uri.Uri");
dojo.uri=new function(){
this.dojoUri=function(uri){
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri(),uri);
};
this.moduleUri=function(_3f8,uri){
var loc=dojo.hostenv.getModuleSymbols(_3f8).join("/");
if(!loc){
return null;
}
if(loc.lastIndexOf("/")!=loc.length-1){
loc+="/";
}
var _3fb=loc.indexOf(":");
var _3fc=loc.indexOf("/");
if(loc.charAt(0)!="/"&&(_3fb==-1||_3fb>_3fc)){
loc=dojo.hostenv.getBaseScriptUri()+loc;
}
return new dojo.uri.Uri(loc,uri);
};
this.Uri=function(){
var uri=arguments[0];
for(var i=1;i<arguments.length;i++){
if(!arguments[i]){
continue;
}
var _3ff=new dojo.uri.Uri(arguments[i].toString());
var _400=new dojo.uri.Uri(uri.toString());
if((_3ff.path=="")&&(_3ff.scheme==null)&&(_3ff.authority==null)&&(_3ff.query==null)){
if(_3ff.fragment!=null){
_400.fragment=_3ff.fragment;
}
_3ff=_400;
}else{
if(_3ff.scheme==null){
_3ff.scheme=_400.scheme;
if(_3ff.authority==null){
_3ff.authority=_400.authority;
if(_3ff.path.charAt(0)!="/"){
var path=_400.path.substring(0,_400.path.lastIndexOf("/")+1)+_3ff.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==segs.length-1){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_3ff.path=segs.join("/");
}
}
}
}
uri="";
if(_3ff.scheme!=null){
uri+=_3ff.scheme+":";
}
if(_3ff.authority!=null){
uri+="//"+_3ff.authority;
}
uri+=_3ff.path;
if(_3ff.query!=null){
uri+="?"+_3ff.query;
}
if(_3ff.fragment!=null){
uri+="#"+_3ff.fragment;
}
}
this.uri=uri.toString();
var _404="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=this.uri.match(new RegExp(_404));
this.scheme=r[2]||(r[1]?"":null);
this.authority=r[4]||(r[3]?"":null);
this.path=r[5];
this.query=r[7]||(r[6]?"":null);
this.fragment=r[9]||(r[8]?"":null);
if(this.authority!=null){
_404="^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$";
r=this.authority.match(new RegExp(_404));
this.user=r[3]||null;
this.password=r[4]||null;
this.host=r[5];
this.port=r[7]||null;
}
this.toString=function(){
return this.uri;
};
};
};
dojo.provide("dojo.html.style");
dojo.html.getClass=function(node){
node=dojo.byId(node);
if(!node){
return "";
}
var cs="";
if(node.className){
cs=node.className;
}else{
if(dojo.html.hasAttribute(node,"class")){
cs=dojo.html.getAttribute(node,"class");
}
}
return cs.replace(/^\s+|\s+$/g,"");
};
dojo.html.getClasses=function(node){
var c=dojo.html.getClass(node);
return (c=="")?[]:c.split(/\s+/g);
};
dojo.html.hasClass=function(node,_40b){
return (new RegExp("(^|\\s+)"+_40b+"(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass=function(node,_40d){
_40d+=" "+dojo.html.getClass(node);
return dojo.html.setClass(node,_40d);
};
dojo.html.addClass=function(node,_40f){
if(dojo.html.hasClass(node,_40f)){
return false;
}
_40f=(dojo.html.getClass(node)+" "+_40f).replace(/^\s+|\s+$/g,"");
return dojo.html.setClass(node,_40f);
};
dojo.html.setClass=function(node,_411){
node=dojo.byId(node);
var cs=new String(_411);
try{
if(typeof node.className=="string"){
node.className=cs;
}else{
if(node.setAttribute){
node.setAttribute("class",_411);
node.className=cs;
}else{
return false;
}
}
}
catch(e){
dojo.debug("dojo.html.setClass() failed",e);
}
return true;
};
dojo.html.removeClass=function(node,_414,_415){
try{
if(!_415){
var _416=dojo.html.getClass(node).replace(new RegExp("(^|\\s+)"+_414+"(\\s+|$)"),"$1$2");
}else{
var _416=dojo.html.getClass(node).replace(_414,"");
}
dojo.html.setClass(node,_416);
}
catch(e){
dojo.debug("dojo.html.removeClass() failed",e);
}
return true;
};
dojo.html.replaceClass=function(node,_418,_419){
dojo.html.removeClass(node,_419);
dojo.html.addClass(node,_418);
};
dojo.html.classMatchType={ContainsAll:0,ContainsAny:1,IsOnly:2};
dojo.html.getElementsByClass=function(_41a,_41b,_41c,_41d,_41e){
_41e=false;
var _41f=dojo.doc();
_41b=dojo.byId(_41b)||_41f;
var _420=_41a.split(/\s+/g);
var _421=[];
if(_41d!=1&&_41d!=2){
_41d=0;
}
var _422=new RegExp("(\\s|^)(("+_420.join(")|(")+"))(\\s|$)");
var _423=_420.join(" ").length;
var _424=[];
if(!_41e&&_41f.evaluate){
var _425=".//"+(_41c||"*")+"[contains(";
if(_41d!=dojo.html.classMatchType.ContainsAny){
_425+="concat(' ',@class,' '), ' "+_420.join(" ') and contains(concat(' ',@class,' '), ' ")+" ')";
if(_41d==2){
_425+=" and string-length(@class)="+_423+"]";
}else{
_425+="]";
}
}else{
_425+="concat(' ',@class,' '), ' "+_420.join(" ') or contains(concat(' ',@class,' '), ' ")+" ')]";
}
var _426=_41f.evaluate(_425,_41b,null,XPathResult.ANY_TYPE,null);
var _427=_426.iterateNext();
while(_427){
try{
_424.push(_427);
_427=_426.iterateNext();
}
catch(e){
break;
}
}
return _424;
}else{
if(!_41c){
_41c="*";
}
_424=_41b.getElementsByTagName(_41c);
var node,i=0;
outer:
while(node=_424[i++]){
var _42a=dojo.html.getClasses(node);
if(_42a.length==0){
continue outer;
}
var _42b=0;
for(var j=0;j<_42a.length;j++){
if(_422.test(_42a[j])){
if(_41d==dojo.html.classMatchType.ContainsAny){
_421.push(node);
continue outer;
}else{
_42b++;
}
}else{
if(_41d==dojo.html.classMatchType.IsOnly){
continue outer;
}
}
}
if(_42b==_420.length){
if((_41d==dojo.html.classMatchType.IsOnly)&&(_42b==_42a.length)){
_421.push(node);
}else{
if(_41d==dojo.html.classMatchType.ContainsAll){
_421.push(node);
}
}
}
}
return _421;
}
};
dojo.html.getElementsByClassName=dojo.html.getElementsByClass;
dojo.html.toCamelCase=function(_42d){
var arr=_42d.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.html.toSelectorCase=function(_431){
return _431.replace(/([A-Z])/g,"-$1").toLowerCase();
};
if(dojo.render.html.ie){
dojo.html.getComputedStyle=function(node,_433,_434){
node=dojo.byId(node);
if(!node||!node.style){
return _434;
}
return node.currentStyle[dojo.html.toCamelCase(_433)];
};
dojo.html.getComputedStyles=function(node){
return node.currentStyle;
};
}else{
dojo.html.getComputedStyle=function(node,_437,_438){
node=dojo.byId(node);
if(!node||!node.style){
return _438;
}
var s=document.defaultView.getComputedStyle(node,null);
return (s&&s[dojo.html.toCamelCase(_437)])||"";
};
dojo.html.getComputedStyles=function(node){
return document.defaultView.getComputedStyle(node,null);
};
}
dojo.html.getStyleProperty=function(node,_43c){
node=dojo.byId(node);
return (node&&node.style?node.style[dojo.html.toCamelCase(_43c)]:undefined);
};
dojo.html.getStyle=function(node,_43e){
var _43f=dojo.html.getStyleProperty(node,_43e);
return (_43f?_43f:dojo.html.getComputedStyle(node,_43e));
};
dojo.html.setStyle=function(node,_441,_442){
node=dojo.byId(node);
if(node&&node.style){
var _443=dojo.html.toCamelCase(_441);
node.style[_443]=_442;
}
};
dojo.html.setStyleText=function(_444,text){
try{
_444.style.cssText=text;
}
catch(e){
_444.setAttribute("style",text);
}
};
dojo.html.copyStyle=function(_446,_447){
if(!_447.style.cssText){
_446.setAttribute("style",_447.getAttribute("style"));
}else{
_446.style.cssText=_447.style.cssText;
}
dojo.html.addClass(_446,dojo.html.getClass(_447));
};
dojo.html.getUnitValue=function(node,_449,_44a){
var s=dojo.html.getComputedStyle(node,_449);
if((!s)||((s=="auto")&&(_44a))){
return {value:0,units:"px"};
}
var _44c=s.match(/(\-?[\d.]+)([a-z%]*)/i);
if(!_44c){
return dojo.html.getUnitValue.bad;
}
return {value:Number(_44c[1]),units:_44c[2].toLowerCase()};
};
dojo.html.getUnitValue.bad={value:NaN,units:""};
if(dojo.render.html.ie){
dojo.html.toPixelValue=function(_44d,_44e){
if(!_44e){
return 0;
}
if(_44e.slice(-2)=="px"){
return parseFloat(_44e);
}
var _44f=0;
with(_44d){
var _450=style.left;
var _451=runtimeStyle.left;
runtimeStyle.left=currentStyle.left;
try{
style.left=_44e||0;
_44f=style.pixelLeft;
style.left=_450;
runtimeStyle.left=_451;
}
catch(e){
}
}
return _44f;
};
}else{
dojo.html.toPixelValue=function(_452,_453){
return (_453&&(_453.slice(-2)=="px")?parseFloat(_453):0);
};
}
dojo.html.getPixelValue=function(node,_455,_456){
return dojo.html.toPixelValue(node,dojo.html.getComputedStyle(node,_455));
};
dojo.html.setPositivePixelValue=function(node,_458,_459){
if(isNaN(_459)){
return false;
}
node.style[_458]=Math.max(0,_459)+"px";
return true;
};
dojo.html.styleSheet=null;
dojo.html.insertCssRule=function(_45a,_45b,_45c){
if(!dojo.html.styleSheet){
if(document.createStyleSheet){
dojo.html.styleSheet=document.createStyleSheet();
}else{
if(document.styleSheets[0]){
dojo.html.styleSheet=document.styleSheets[0];
}else{
return null;
}
}
}
if(arguments.length<3){
if(dojo.html.styleSheet.cssRules){
_45c=dojo.html.styleSheet.cssRules.length;
}else{
if(dojo.html.styleSheet.rules){
_45c=dojo.html.styleSheet.rules.length;
}else{
return null;
}
}
}
if(dojo.html.styleSheet.insertRule){
var rule=_45a+" { "+_45b+" }";
return dojo.html.styleSheet.insertRule(rule,_45c);
}else{
if(dojo.html.styleSheet.addRule){
return dojo.html.styleSheet.addRule(_45a,_45b,_45c);
}else{
return null;
}
}
};
dojo.html.removeCssRule=function(_45e){
if(!dojo.html.styleSheet){
dojo.debug("no stylesheet defined for removing rules");
return false;
}
if(dojo.render.html.ie){
if(!_45e){
_45e=dojo.html.styleSheet.rules.length;
dojo.html.styleSheet.removeRule(_45e);
}
}else{
if(document.styleSheets[0]){
if(!_45e){
_45e=dojo.html.styleSheet.cssRules.length;
}
dojo.html.styleSheet.deleteRule(_45e);
}
}
return true;
};
dojo.html._insertedCssFiles=[];
dojo.html.insertCssFile=function(URI,doc,_461,_462){
if(!URI){
return;
}
if(!doc){
doc=document;
}
var _463=dojo.hostenv.getText(URI,false,_462);
if(_463===null){
return;
}
_463=dojo.html.fixPathsInCssText(_463,URI);
if(_461){
var idx=-1,node,ent=dojo.html._insertedCssFiles;
for(var i=0;i<ent.length;i++){
if((ent[i].doc==doc)&&(ent[i].cssText==_463)){
idx=i;
node=ent[i].nodeRef;
break;
}
}
if(node){
var _468=doc.getElementsByTagName("style");
for(var i=0;i<_468.length;i++){
if(_468[i]==node){
return;
}
}
dojo.html._insertedCssFiles.shift(idx,1);
}
}
var _469=dojo.html.insertCssText(_463,doc);
dojo.html._insertedCssFiles.push({"doc":doc,"cssText":_463,"nodeRef":_469});
if(_469&&djConfig.isDebug){
_469.setAttribute("dbgHref",URI);
}
return _469;
};
dojo.html.insertCssText=function(_46a,doc,URI){
if(!_46a){
return;
}
if(!doc){
doc=document;
}
if(URI){
_46a=dojo.html.fixPathsInCssText(_46a,URI);
}
var _46d=doc.createElement("style");
_46d.setAttribute("type","text/css");
var head=doc.getElementsByTagName("head")[0];
if(!head){
dojo.debug("No head tag in document, aborting styles");
return;
}else{
head.appendChild(_46d);
}
if(_46d.styleSheet){
var _46f=function(){
try{
_46d.styleSheet.cssText=_46a;
}
catch(e){
dojo.debug(e);
}
};
if(_46d.styleSheet.disabled){
setTimeout(_46f,10);
}else{
_46f();
}
}else{
var _470=doc.createTextNode(_46a);
_46d.appendChild(_470);
}
return _46d;
};
dojo.html.fixPathsInCssText=function(_471,URI){
if(!_471||!URI){
return;
}
var _473,str="",url="",_476="[\\t\\s\\w\\(\\)\\/\\.\\\\'\"-:#=&?~]+";
var _477=new RegExp("url\\(\\s*("+_476+")\\s*\\)");
var _478=/(file|https?|ftps?):\/\//;
regexTrim=new RegExp("^[\\s]*(['\"]?)("+_476+")\\1[\\s]*?$");
if(dojo.render.html.ie55||dojo.render.html.ie60){
var _479=new RegExp("AlphaImageLoader\\((.*)src=['\"]("+_476+")['\"]");
while(_473=_479.exec(_471)){
url=_473[2].replace(regexTrim,"$2");
if(!_478.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_471.substring(0,_473.index)+"AlphaImageLoader("+_473[1]+"src='"+url+"'";
_471=_471.substr(_473.index+_473[0].length);
}
_471=str+_471;
str="";
}
while(_473=_477.exec(_471)){
url=_473[1].replace(regexTrim,"$2");
if(!_478.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_471.substring(0,_473.index)+"url("+url+")";
_471=_471.substr(_473.index+_473[0].length);
}
return str+_471;
};
dojo.html.setActiveStyleSheet=function(_47a){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")){
a.disabled=true;
if(a.getAttribute("title")==_47a){
a.disabled=false;
}
}
}
};
dojo.html.getActiveStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")&&!a.disabled){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.getPreferredStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("rel").indexOf("alt")==-1&&a.getAttribute("title")){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.applyBrowserClass=function(node){
var drh=dojo.render.html;
var _486={dj_ie:drh.ie,dj_ie55:drh.ie55,dj_ie6:drh.ie60,dj_ie7:drh.ie70,dj_iequirks:drh.ie&&drh.quirks,dj_opera:drh.opera,dj_opera8:drh.opera&&(Math.floor(dojo.render.version)==8),dj_opera9:drh.opera&&(Math.floor(dojo.render.version)==9),dj_khtml:drh.khtml,dj_safari:drh.safari,dj_gecko:drh.mozilla};
for(var p in _486){
if(_486[p]){
dojo.html.addClass(node,p);
}
}
};
dojo.kwCompoundRequire({common:["dojo.html.common","dojo.html.style"]});
dojo.provide("dojo.html.*");
dojo.provide("dojo.html.display");
dojo.html._toggle=function(node,_489,_48a){
node=dojo.byId(node);
_48a(node,!_489(node));
return _489(node);
};
dojo.html.show=function(node){
node=dojo.byId(node);
if(dojo.html.getStyleProperty(node,"display")=="none"){
dojo.html.setStyle(node,"display",(node.dojoDisplayCache||""));
node.dojoDisplayCache=undefined;
}
};
dojo.html.hide=function(node){
node=dojo.byId(node);
if(typeof node["dojoDisplayCache"]=="undefined"){
var d=dojo.html.getStyleProperty(node,"display");
if(d!="none"){
node.dojoDisplayCache=d;
}
}
dojo.html.setStyle(node,"display","none");
};
dojo.html.setShowing=function(node,_48f){
dojo.html[(_48f?"show":"hide")](node);
};
dojo.html.isShowing=function(node){
return (dojo.html.getStyleProperty(node,"display")!="none");
};
dojo.html.toggleShowing=function(node){
return dojo.html._toggle(node,dojo.html.isShowing,dojo.html.setShowing);
};
dojo.html.displayMap={tr:"",td:"",th:"",img:"inline",span:"inline",input:"inline",button:"inline"};
dojo.html.suggestDisplayByTagName=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
var tag=node.tagName.toLowerCase();
return (tag in dojo.html.displayMap?dojo.html.displayMap[tag]:"block");
}
};
dojo.html.setDisplay=function(node,_495){
dojo.html.setStyle(node,"display",((_495 instanceof String||typeof _495=="string")?_495:(_495?dojo.html.suggestDisplayByTagName(node):"none")));
};
dojo.html.isDisplayed=function(node){
return (dojo.html.getComputedStyle(node,"display")!="none");
};
dojo.html.toggleDisplay=function(node){
return dojo.html._toggle(node,dojo.html.isDisplayed,dojo.html.setDisplay);
};
dojo.html.setVisibility=function(node,_499){
dojo.html.setStyle(node,"visibility",((_499 instanceof String||typeof _499=="string")?_499:(_499?"visible":"hidden")));
};
dojo.html.isVisible=function(node){
return (dojo.html.getComputedStyle(node,"visibility")!="hidden");
};
dojo.html.toggleVisibility=function(node){
return dojo.html._toggle(node,dojo.html.isVisible,dojo.html.setVisibility);
};
dojo.html.setOpacity=function(node,_49d,_49e){
node=dojo.byId(node);
var h=dojo.render.html;
if(!_49e){
if(_49d>=1){
if(h.ie){
dojo.html.clearOpacity(node);
return;
}else{
_49d=0.999999;
}
}else{
if(_49d<0){
_49d=0;
}
}
}
if(h.ie){
if(node.nodeName.toLowerCase()=="tr"){
var tds=node.getElementsByTagName("td");
for(var x=0;x<tds.length;x++){
tds[x].style.filter="Alpha(Opacity="+_49d*100+")";
}
}
node.style.filter="Alpha(Opacity="+_49d*100+")";
}else{
if(h.moz){
node.style.opacity=_49d;
node.style.MozOpacity=_49d;
}else{
if(h.safari){
node.style.opacity=_49d;
node.style.KhtmlOpacity=_49d;
}else{
node.style.opacity=_49d;
}
}
}
};
dojo.html.clearOpacity=function(node){
node=dojo.byId(node);
var ns=node.style;
var h=dojo.render.html;
if(h.ie){
try{
if(node.filters&&node.filters.alpha){
ns.filter="";
}
}
catch(e){
}
}else{
if(h.moz){
ns.opacity=1;
ns.MozOpacity=1;
}else{
if(h.safari){
ns.opacity=1;
ns.KhtmlOpacity=1;
}else{
ns.opacity=1;
}
}
}
};
dojo.html.getOpacity=function(node){
node=dojo.byId(node);
var h=dojo.render.html;
if(h.ie){
var opac=(node.filters&&node.filters.alpha&&typeof node.filters.alpha.opacity=="number"?node.filters.alpha.opacity:100)/100;
}else{
var opac=node.style.opacity||node.style.MozOpacity||node.style.KhtmlOpacity||1;
}
return opac>=0.999999?1:Number(opac);
};
dojo.provide("dojo.html.layout");
dojo.html.sumAncestorProperties=function(node,prop){
node=dojo.byId(node);
if(!node){
return 0;
}
var _4aa=0;
while(node){
if(dojo.html.getComputedStyle(node,"position")=="fixed"){
return 0;
}
var val=node[prop];
if(val){
_4aa+=val-0;
if(node==dojo.body()){
break;
}
}
node=node.parentNode;
}
return _4aa;
};
dojo.html.setStyleAttributes=function(node,_4ad){
node=dojo.byId(node);
var _4ae=_4ad.replace(/(;)?\s*$/,"").split(";");
for(var i=0;i<_4ae.length;i++){
var _4b0=_4ae[i].split(":");
var name=_4b0[0].replace(/\s*$/,"").replace(/^\s*/,"").toLowerCase();
var _4b2=_4b0[1].replace(/\s*$/,"").replace(/^\s*/,"");
switch(name){
case "opacity":
dojo.html.setOpacity(node,_4b2);
break;
case "content-height":
dojo.html.setContentBox(node,{height:_4b2});
break;
case "content-width":
dojo.html.setContentBox(node,{width:_4b2});
break;
case "outer-height":
dojo.html.setMarginBox(node,{height:_4b2});
break;
case "outer-width":
dojo.html.setMarginBox(node,{width:_4b2});
break;
default:
node.style[dojo.html.toCamelCase(name)]=_4b2;
}
}
};
dojo.html.boxSizing={MARGIN_BOX:"margin-box",BORDER_BOX:"border-box",PADDING_BOX:"padding-box",CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition=dojo.html.abs=function(node,_4b4,_4b5){
node=dojo.byId(node,node.ownerDocument);
var ret={x:0,y:0};
var bs=dojo.html.boxSizing;
if(!_4b5){
_4b5=bs.CONTENT_BOX;
}
var _4b8=2;
var _4b9;
switch(_4b5){
case bs.MARGIN_BOX:
_4b9=3;
break;
case bs.BORDER_BOX:
_4b9=2;
break;
case bs.PADDING_BOX:
default:
_4b9=1;
break;
case bs.CONTENT_BOX:
_4b9=0;
break;
}
var h=dojo.render.html;
var db=document["body"]||document["documentElement"];
if(h.ie){
with(node.getBoundingClientRect()){
ret.x=left-2;
ret.y=top-2;
}
}else{
if(document.getBoxObjectFor){
_4b8=1;
try{
var bo=document.getBoxObjectFor(node);
ret.x=bo.x-dojo.html.sumAncestorProperties(node,"scrollLeft");
ret.y=bo.y-dojo.html.sumAncestorProperties(node,"scrollTop");
}
catch(e){
}
}else{
if(node["offsetParent"]){
var _4bd;
if((h.safari)&&(node.style.getPropertyValue("position")=="absolute")&&(node.parentNode==db)){
_4bd=db;
}else{
_4bd=db.parentNode;
}
if(node.parentNode!=db){
var nd=node;
if(dojo.render.html.opera){
nd=db;
}
ret.x-=dojo.html.sumAncestorProperties(nd,"scrollLeft");
ret.y-=dojo.html.sumAncestorProperties(nd,"scrollTop");
}
var _4bf=node;
do{
var n=_4bf["offsetLeft"];
if(!h.opera||n>0){
ret.x+=isNaN(n)?0:n;
}
var m=_4bf["offsetTop"];
ret.y+=isNaN(m)?0:m;
_4bf=_4bf.offsetParent;
}while((_4bf!=_4bd)&&(_4bf!=null));
}else{
if(node["x"]&&node["y"]){
ret.x+=isNaN(node.x)?0:node.x;
ret.y+=isNaN(node.y)?0:node.y;
}
}
}
}
if(_4b4){
var _4c2=dojo.html.getScroll();
ret.y+=_4c2.top;
ret.x+=_4c2.left;
}
var _4c3=[dojo.html.getPaddingExtent,dojo.html.getBorderExtent,dojo.html.getMarginExtent];
if(_4b8>_4b9){
for(var i=_4b9;i<_4b8;++i){
ret.y+=_4c3[i](node,"top");
ret.x+=_4c3[i](node,"left");
}
}else{
if(_4b8<_4b9){
for(var i=_4b9;i>_4b8;--i){
ret.y-=_4c3[i-1](node,"top");
ret.x-=_4c3[i-1](node,"left");
}
}
}
ret.top=ret.y;
ret.left=ret.x;
return ret;
};
dojo.html.isPositionAbsolute=function(node){
return (dojo.html.getComputedStyle(node,"position")=="absolute");
};
dojo.html._sumPixelValues=function(node,_4c7,_4c8){
var _4c9=0;
for(var x=0;x<_4c7.length;x++){
_4c9+=dojo.html.getPixelValue(node,_4c7[x],_4c8);
}
return _4c9;
};
dojo.html.getMargin=function(node){
return {width:dojo.html._sumPixelValues(node,["margin-left","margin-right"],(dojo.html.getComputedStyle(node,"position")=="absolute")),height:dojo.html._sumPixelValues(node,["margin-top","margin-bottom"],(dojo.html.getComputedStyle(node,"position")=="absolute"))};
};
dojo.html.getBorder=function(node){
return {width:dojo.html.getBorderExtent(node,"left")+dojo.html.getBorderExtent(node,"right"),height:dojo.html.getBorderExtent(node,"top")+dojo.html.getBorderExtent(node,"bottom")};
};
dojo.html.getBorderExtent=function(node,side){
return (dojo.html.getStyle(node,"border-"+side+"-style")=="none"?0:dojo.html.getPixelValue(node,"border-"+side+"-width"));
};
dojo.html.getMarginExtent=function(node,side){
return dojo.html._sumPixelValues(node,["margin-"+side],dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent=function(node,side){
return dojo.html._sumPixelValues(node,["padding-"+side],true);
};
dojo.html.getPadding=function(node){
return {width:dojo.html._sumPixelValues(node,["padding-left","padding-right"],true),height:dojo.html._sumPixelValues(node,["padding-top","padding-bottom"],true)};
};
dojo.html.getPadBorder=function(node){
var pad=dojo.html.getPadding(node);
var _4d6=dojo.html.getBorder(node);
return {width:pad.width+_4d6.width,height:pad.height+_4d6.height};
};
dojo.html.getBoxSizing=function(node){
var h=dojo.render.html;
var bs=dojo.html.boxSizing;
if(((h.ie)||(h.opera))&&node.nodeName.toLowerCase()!="img"){
var cm=document["compatMode"];
if((cm=="BackCompat")||(cm=="QuirksMode")){
return bs.BORDER_BOX;
}else{
return bs.CONTENT_BOX;
}
}else{
if(arguments.length==0){
node=document.documentElement;
}
var _4db;
if(!h.ie){
_4db=dojo.html.getStyle(node,"-moz-box-sizing");
if(!_4db){
_4db=dojo.html.getStyle(node,"box-sizing");
}
}
return (_4db?_4db:bs.CONTENT_BOX);
}
};
dojo.html.isBorderBox=function(node){
return (dojo.html.getBoxSizing(node)==dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox=function(node){
node=dojo.byId(node);
return {width:node.offsetWidth,height:node.offsetHeight};
};
dojo.html.getPaddingBox=function(node){
var box=dojo.html.getBorderBox(node);
var _4e0=dojo.html.getBorder(node);
return {width:box.width-_4e0.width,height:box.height-_4e0.height};
};
dojo.html.getContentBox=function(node){
node=dojo.byId(node);
var _4e2=dojo.html.getPadBorder(node);
return {width:node.offsetWidth-_4e2.width,height:node.offsetHeight-_4e2.height};
};
dojo.html.setContentBox=function(node,args){
node=dojo.byId(node);
var _4e5=0;
var _4e6=0;
var isbb=dojo.html.isBorderBox(node);
var _4e8=(isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var ret={};
if(typeof args.width!="undefined"){
_4e5=args.width+_4e8.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_4e5);
}
if(typeof args.height!="undefined"){
_4e6=args.height+_4e8.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_4e6);
}
return ret;
};
dojo.html.getMarginBox=function(node){
var _4eb=dojo.html.getBorderBox(node);
var _4ec=dojo.html.getMargin(node);
return {width:_4eb.width+_4ec.width,height:_4eb.height+_4ec.height};
};
dojo.html.setMarginBox=function(node,args){
node=dojo.byId(node);
var _4ef=0;
var _4f0=0;
var isbb=dojo.html.isBorderBox(node);
var _4f2=(!isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var _4f3=dojo.html.getMargin(node);
var ret={};
if(typeof args.width!="undefined"){
_4ef=args.width-_4f2.width;
_4ef-=_4f3.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_4ef);
}
if(typeof args.height!="undefined"){
_4f0=args.height-_4f2.height;
_4f0-=_4f3.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_4f0);
}
return ret;
};
dojo.html.getElementBox=function(node,type){
var bs=dojo.html.boxSizing;
switch(type){
case bs.MARGIN_BOX:
return dojo.html.getMarginBox(node);
case bs.BORDER_BOX:
return dojo.html.getBorderBox(node);
case bs.PADDING_BOX:
return dojo.html.getPaddingBox(node);
case bs.CONTENT_BOX:
default:
return dojo.html.getContentBox(node);
}
};
dojo.html.toCoordinateObject=dojo.html.toCoordinateArray=function(_4f8,_4f9,_4fa){
if(_4f8 instanceof Array||typeof _4f8=="array"){
dojo.deprecated("dojo.html.toCoordinateArray","use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead","0.5");
while(_4f8.length<4){
_4f8.push(0);
}
while(_4f8.length>4){
_4f8.pop();
}
var ret={left:_4f8[0],top:_4f8[1],width:_4f8[2],height:_4f8[3]};
}else{
if(!_4f8.nodeType&&!(_4f8 instanceof String||typeof _4f8=="string")&&("width" in _4f8||"height" in _4f8||"left" in _4f8||"x" in _4f8||"top" in _4f8||"y" in _4f8)){
var ret={left:_4f8.left||_4f8.x||0,top:_4f8.top||_4f8.y||0,width:_4f8.width||0,height:_4f8.height||0};
}else{
var node=dojo.byId(_4f8);
var pos=dojo.html.abs(node,_4f9,_4fa);
var _4fe=dojo.html.getMarginBox(node);
var ret={left:pos.left,top:pos.top,width:_4fe.width,height:_4fe.height};
}
}
ret.x=ret.left;
ret.y=ret.top;
return ret;
};
dojo.html.setMarginBoxWidth=dojo.html.setOuterWidth=function(node,_500){
return dojo.html._callDeprecated("setMarginBoxWidth","setMarginBox",arguments,"width");
};
dojo.html.setMarginBoxHeight=dojo.html.setOuterHeight=function(){
return dojo.html._callDeprecated("setMarginBoxHeight","setMarginBox",arguments,"height");
};
dojo.html.getMarginBoxWidth=dojo.html.getOuterWidth=function(){
return dojo.html._callDeprecated("getMarginBoxWidth","getMarginBox",arguments,null,"width");
};
dojo.html.getMarginBoxHeight=dojo.html.getOuterHeight=function(){
return dojo.html._callDeprecated("getMarginBoxHeight","getMarginBox",arguments,null,"height");
};
dojo.html.getTotalOffset=function(node,type,_503){
return dojo.html._callDeprecated("getTotalOffset","getAbsolutePosition",arguments,null,type);
};
dojo.html.getAbsoluteX=function(node,_505){
return dojo.html._callDeprecated("getAbsoluteX","getAbsolutePosition",arguments,null,"x");
};
dojo.html.getAbsoluteY=function(node,_507){
return dojo.html._callDeprecated("getAbsoluteY","getAbsolutePosition",arguments,null,"y");
};
dojo.html.totalOffsetLeft=function(node,_509){
return dojo.html._callDeprecated("totalOffsetLeft","getAbsolutePosition",arguments,null,"left");
};
dojo.html.totalOffsetTop=function(node,_50b){
return dojo.html._callDeprecated("totalOffsetTop","getAbsolutePosition",arguments,null,"top");
};
dojo.html.getMarginWidth=function(node){
return dojo.html._callDeprecated("getMarginWidth","getMargin",arguments,null,"width");
};
dojo.html.getMarginHeight=function(node){
return dojo.html._callDeprecated("getMarginHeight","getMargin",arguments,null,"height");
};
dojo.html.getBorderWidth=function(node){
return dojo.html._callDeprecated("getBorderWidth","getBorder",arguments,null,"width");
};
dojo.html.getBorderHeight=function(node){
return dojo.html._callDeprecated("getBorderHeight","getBorder",arguments,null,"height");
};
dojo.html.getPaddingWidth=function(node){
return dojo.html._callDeprecated("getPaddingWidth","getPadding",arguments,null,"width");
};
dojo.html.getPaddingHeight=function(node){
return dojo.html._callDeprecated("getPaddingHeight","getPadding",arguments,null,"height");
};
dojo.html.getPadBorderWidth=function(node){
return dojo.html._callDeprecated("getPadBorderWidth","getPadBorder",arguments,null,"width");
};
dojo.html.getPadBorderHeight=function(node){
return dojo.html._callDeprecated("getPadBorderHeight","getPadBorder",arguments,null,"height");
};
dojo.html.getBorderBoxWidth=dojo.html.getInnerWidth=function(){
return dojo.html._callDeprecated("getBorderBoxWidth","getBorderBox",arguments,null,"width");
};
dojo.html.getBorderBoxHeight=dojo.html.getInnerHeight=function(){
return dojo.html._callDeprecated("getBorderBoxHeight","getBorderBox",arguments,null,"height");
};
dojo.html.getContentBoxWidth=dojo.html.getContentWidth=function(){
return dojo.html._callDeprecated("getContentBoxWidth","getContentBox",arguments,null,"width");
};
dojo.html.getContentBoxHeight=dojo.html.getContentHeight=function(){
return dojo.html._callDeprecated("getContentBoxHeight","getContentBox",arguments,null,"height");
};
dojo.html.setContentBoxWidth=dojo.html.setContentWidth=function(node,_515){
return dojo.html._callDeprecated("setContentBoxWidth","setContentBox",arguments,"width");
};
dojo.html.setContentBoxHeight=dojo.html.setContentHeight=function(node,_517){
return dojo.html._callDeprecated("setContentBoxHeight","setContentBox",arguments,"height");
};
dojo.provide("dojo.html.util");
dojo.html.getElementWindow=function(_518){
return dojo.html.getDocumentWindow(_518.ownerDocument);
};
dojo.html.getDocumentWindow=function(doc){
if(dojo.render.html.safari&&!doc._parentWindow){
var fix=function(win){
win.document._parentWindow=win;
for(var i=0;i<win.frames.length;i++){
fix(win.frames[i]);
}
};
fix(window.top);
}
if(dojo.render.html.ie&&window!==document.parentWindow&&!doc._parentWindow){
doc.parentWindow.execScript("document._parentWindow = window;","Javascript");
var win=doc._parentWindow;
doc._parentWindow=null;
return win;
}
return doc._parentWindow||doc.parentWindow||doc.defaultView;
};
dojo.html.gravity=function(node,e){
node=dojo.byId(node);
var _520=dojo.html.getCursorPosition(e);
with(dojo.html){
var _521=getAbsolutePosition(node,true);
var bb=getBorderBox(node);
var _523=_521.x+(bb.width/2);
var _524=_521.y+(bb.height/2);
}
with(dojo.html.gravity){
return ((_520.x<_523?WEST:EAST)|(_520.y<_524?NORTH:SOUTH));
}
};
dojo.html.gravity.NORTH=1;
dojo.html.gravity.SOUTH=1<<1;
dojo.html.gravity.EAST=1<<2;
dojo.html.gravity.WEST=1<<3;
dojo.html.overElement=function(_525,e){
_525=dojo.byId(_525);
var _527=dojo.html.getCursorPosition(e);
var bb=dojo.html.getBorderBox(_525);
var _529=dojo.html.getAbsolutePosition(_525,true,dojo.html.boxSizing.BORDER_BOX);
var top=_529.y;
var _52b=top+bb.height;
var left=_529.x;
var _52d=left+bb.width;
return (_527.x>=left&&_527.x<=_52d&&_527.y>=top&&_527.y<=_52b);
};
dojo.html.renderedTextContent=function(node){
node=dojo.byId(node);
var _52f="";
if(node==null){
return _52f;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
var _531="unknown";
try{
_531=dojo.html.getStyle(node.childNodes[i],"display");
}
catch(E){
}
switch(_531){
case "block":
case "list-item":
case "run-in":
case "table":
case "table-row-group":
case "table-header-group":
case "table-footer-group":
case "table-row":
case "table-column-group":
case "table-column":
case "table-cell":
case "table-caption":
_52f+="\n";
_52f+=dojo.html.renderedTextContent(node.childNodes[i]);
_52f+="\n";
break;
case "none":
break;
default:
if(node.childNodes[i].tagName&&node.childNodes[i].tagName.toLowerCase()=="br"){
_52f+="\n";
}else{
_52f+=dojo.html.renderedTextContent(node.childNodes[i]);
}
break;
}
break;
case 3:
case 2:
case 4:
var text=node.childNodes[i].nodeValue;
var _533="unknown";
try{
_533=dojo.html.getStyle(node,"text-transform");
}
catch(E){
}
switch(_533){
case "capitalize":
var _534=text.split(" ");
for(var i=0;i<_534.length;i++){
_534[i]=_534[i].charAt(0).toUpperCase()+_534[i].substring(1);
}
text=_534.join(" ");
break;
case "uppercase":
text=text.toUpperCase();
break;
case "lowercase":
text=text.toLowerCase();
break;
default:
break;
}
switch(_533){
case "nowrap":
break;
case "pre-wrap":
break;
case "pre-line":
break;
case "pre":
break;
default:
text=text.replace(/\s+/," ");
if(/\s$/.test(_52f)){
text.replace(/^\s/,"");
}
break;
}
_52f+=text;
break;
default:
break;
}
}
return _52f;
};
dojo.html.createNodesFromText=function(txt,trim){
if(trim){
txt=txt.replace(/^\s+|\s+$/g,"");
}
var tn=dojo.doc().createElement("div");
tn.style.visibility="hidden";
dojo.body().appendChild(tn);
var _538="none";
if((/^<t[dh][\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody><tr>"+txt+"</tr></tbody></table>";
_538="cell";
}else{
if((/^<tr[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody>"+txt+"</tbody></table>";
_538="row";
}else{
if((/^<(thead|tbody|tfoot)[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table>"+txt+"</table>";
_538="section";
}
}
}
tn.innerHTML=txt;
if(tn["normalize"]){
tn.normalize();
}
var _539=null;
switch(_538){
case "cell":
_539=tn.getElementsByTagName("tr")[0];
break;
case "row":
_539=tn.getElementsByTagName("tbody")[0];
break;
case "section":
_539=tn.getElementsByTagName("table")[0];
break;
default:
_539=tn;
break;
}
var _53a=[];
for(var x=0;x<_539.childNodes.length;x++){
_53a.push(_539.childNodes[x].cloneNode(true));
}
tn.style.display="none";
dojo.html.destroyNode(tn);
return _53a;
};
dojo.html.placeOnScreen=function(node,_53d,_53e,_53f,_540,_541,_542){
if(_53d instanceof Array||typeof _53d=="array"){
_542=_541;
_541=_540;
_540=_53f;
_53f=_53e;
_53e=_53d[1];
_53d=_53d[0];
}
if(_541 instanceof String||typeof _541=="string"){
_541=_541.split(",");
}
if(!isNaN(_53f)){
_53f=[Number(_53f),Number(_53f)];
}else{
if(!(_53f instanceof Array||typeof _53f=="array")){
_53f=[0,0];
}
}
var _543=dojo.html.getScroll().offset;
var view=dojo.html.getViewport();
node=dojo.byId(node);
var _545=node.style.display;
node.style.display="";
var bb=dojo.html.getBorderBox(node);
var w=bb.width;
var h=bb.height;
node.style.display=_545;
if(!(_541 instanceof Array||typeof _541=="array")){
_541=["TL"];
}
var _549,_54a,_54b=Infinity,_54c;
for(var _54d=0;_54d<_541.length;++_54d){
var _54e=_541[_54d];
var _54f=true;
var tryX=_53d-(_54e.charAt(1)=="L"?0:w)+_53f[0]*(_54e.charAt(1)=="L"?1:-1);
var tryY=_53e-(_54e.charAt(0)=="T"?0:h)+_53f[1]*(_54e.charAt(0)=="T"?1:-1);
if(_540){
tryX-=_543.x;
tryY-=_543.y;
}
if(tryX<0){
tryX=0;
_54f=false;
}
if(tryY<0){
tryY=0;
_54f=false;
}
var x=tryX+w;
if(x>view.width){
x=view.width-w;
_54f=false;
}else{
x=tryX;
}
x=Math.max(_53f[0],x)+_543.x;
var y=tryY+h;
if(y>view.height){
y=view.height-h;
_54f=false;
}else{
y=tryY;
}
y=Math.max(_53f[1],y)+_543.y;
if(_54f){
_549=x;
_54a=y;
_54b=0;
_54c=_54e;
break;
}else{
var dist=Math.pow(x-tryX-_543.x,2)+Math.pow(y-tryY-_543.y,2);
if(_54b>dist){
_54b=dist;
_549=x;
_54a=y;
_54c=_54e;
}
}
}
if(!_542){
node.style.left=_549+"px";
node.style.top=_54a+"px";
}
return {left:_549,top:_54a,x:_549,y:_54a,dist:_54b,corner:_54c};
};
dojo.html.placeOnScreenPoint=function(node,_556,_557,_558,_559){
dojo.deprecated("dojo.html.placeOnScreenPoint","use dojo.html.placeOnScreen() instead","0.5");
return dojo.html.placeOnScreen(node,_556,_557,_558,_559,["TL","TR","BL","BR"]);
};
dojo.html.placeOnScreenAroundElement=function(node,_55b,_55c,_55d,_55e,_55f){
var best,_561=Infinity;
_55b=dojo.byId(_55b);
var _562=_55b.style.display;
_55b.style.display="";
var mb=dojo.html.getElementBox(_55b,_55d);
var _564=mb.width;
var _565=mb.height;
var _566=dojo.html.getAbsolutePosition(_55b,true,_55d);
_55b.style.display=_562;
for(var _567 in _55e){
var pos,_569,_56a;
var _56b=_55e[_567];
_569=_566.x+(_567.charAt(1)=="L"?0:_564);
_56a=_566.y+(_567.charAt(0)=="T"?0:_565);
pos=dojo.html.placeOnScreen(node,_569,_56a,_55c,true,_56b,true);
if(pos.dist==0){
best=pos;
break;
}else{
if(_561>pos.dist){
_561=pos.dist;
best=pos;
}
}
}
if(!_55f){
node.style.left=best.left+"px";
node.style.top=best.top+"px";
}
return best;
};
dojo.html.scrollIntoView=function(node){
if(!node){
return;
}
if(dojo.render.html.ie){
if(dojo.html.getBorderBox(node.parentNode).height<=node.parentNode.scrollHeight){
node.scrollIntoView(false);
}
}else{
if(dojo.render.html.mozilla){
node.scrollIntoView(false);
}else{
var _56d=node.parentNode;
var _56e=_56d.scrollTop+dojo.html.getBorderBox(_56d).height;
var _56f=node.offsetTop+dojo.html.getMarginBox(node).height;
if(_56e<_56f){
_56d.scrollTop+=(_56f-_56e);
}else{
if(_56d.scrollTop>node.offsetTop){
_56d.scrollTop-=(_56d.scrollTop-node.offsetTop);
}
}
}
}
};


__CPAN_EDITION__ core build.txt
Files baked into this build:
dojoGuardStart.js
../src/bootstrap1.js
../src/loader.js
dojoGuardEnd.js
../src/hostenv_browser.js
../src/lang/common.js
../src/lang/array.js
../src/lang/extras.js
../src/lang/declare.js
../src/lang/func.js
../src/event/common.js
../src/event/topic.js
../src/event/browser.js
../src/event/__package__.js
../src/event.js
../src/string/common.js
../src/string/extras.js
../src/string.js
../src/io/common.js
../src/dom.js
../src/undo/browser.js
../src/io/BrowserIO.js
../src/io/cookie.js
../src/io/__package__.js
../src/io.js
../src/AdapterRegistry.js
../src/json.js
../src/html/common.js
../src/uri/Uri.js
../src/html/style.js
../src/html/__package__.js
../src/html/display.js
../src/html/layout.js
../src/html/util.js
__CPAN_EDITION__ editor dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:2,flag:"",revision:Number("$Rev: 7616 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
function dj_load_init(e){
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _ef=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_ef.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_f1,_f2){
var _f3=_f1.firstChild;
while(_f3&&_f3.nodeType!=dojo.dom.ELEMENT_NODE){
_f3=_f3.nextSibling;
}
if(_f2&&_f3&&_f3.tagName&&_f3.tagName.toLowerCase()!=_f2.toLowerCase()){
_f3=dojo.dom.nextElement(_f3,_f2);
}
return _f3;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_f4,_f5){
var _f6=_f4.lastChild;
while(_f6&&_f6.nodeType!=dojo.dom.ELEMENT_NODE){
_f6=_f6.previousSibling;
}
if(_f5&&_f6&&_f6.tagName&&_f6.tagName.toLowerCase()!=_f5.toLowerCase()){
_f6=dojo.dom.prevElement(_f6,_f5);
}
return _f6;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(_f7,_f8){
if(!_f7){
return null;
}
do{
_f7=_f7.nextSibling;
}while(_f7&&_f7.nodeType!=dojo.dom.ELEMENT_NODE);
if(_f7&&_f8&&_f8.toLowerCase()!=_f7.tagName.toLowerCase()){
return dojo.dom.nextElement(_f7,_f8);
}
return _f7;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(_f9,_fa){
if(!_f9){
return null;
}
if(_fa){
_fa=_fa.toLowerCase();
}
do{
_f9=_f9.previousSibling;
}while(_f9&&_f9.nodeType!=dojo.dom.ELEMENT_NODE);
if(_f9&&_fa&&_fa.toLowerCase()!=_f9.tagName.toLowerCase()){
return dojo.dom.prevElement(_f9,_fa);
}
return _f9;
};
dojo.dom.moveChildren=function(_fb,_fc,_fd){
var _fe=0;
if(_fd){
while(_fb.hasChildNodes()&&_fb.firstChild.nodeType==dojo.dom.TEXT_NODE){
_fb.removeChild(_fb.firstChild);
}
while(_fb.hasChildNodes()&&_fb.lastChild.nodeType==dojo.dom.TEXT_NODE){
_fb.removeChild(_fb.lastChild);
}
}
while(_fb.hasChildNodes()){
_fc.appendChild(_fb.firstChild);
_fe++;
}
return _fe;
};
dojo.dom.copyChildren=function(_ff,_100,trim){
var _102=_ff.cloneNode(true);
return this.moveChildren(_102,_100,trim);
};
dojo.dom.replaceChildren=function(node,_104){
var _105=[];
if(dojo.render.html.ie){
for(var i=0;i<node.childNodes.length;i++){
_105.push(node.childNodes[i]);
}
}
dojo.dom.removeChildren(node);
node.appendChild(_104);
for(var i=0;i<_105.length;i++){
dojo.dom.destroyNode(_105[i]);
}
};
dojo.dom.removeChildren=function(node){
var _108=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _108;
};
dojo.dom.replaceNode=function(node,_10a){
return node.parentNode.replaceChild(_10a,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.evalObjPath("dojo.event.browser.clean",false)){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_10e,_10f){
var _110=[];
var _111=(_10e&&(_10e instanceof Function||typeof _10e=="function"));
while(node){
if(!_111||_10e(node)){
_110.push(node);
}
if(_10f&&_110.length>0){
return _110[0];
}
node=node.parentNode;
}
if(_10f){
return null;
}
return _110;
};
dojo.dom.getAncestorsByTag=function(node,tag,_114){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_114);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_119,_11a){
if(_11a&&node){
node=node.parentNode;
}
while(node){
if(node==_119){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _11d=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _11e=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_11e.length;i++){
try{
doc=new ActiveXObject(_11e[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_11d.implementation)&&(_11d.implementation.createDocument)){
doc=_11d.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_121){
if(!_121){
_121="text/xml";
}
if(!dj_undef("DOMParser")){
var _122=new DOMParser();
return _122.parseFromString(str,_121);
}else{
if(!dj_undef("ActiveXObject")){
var _123=dojo.dom.createDocument();
if(_123){
_123.async=false;
_123.loadXML(str);
return _123;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _124=dojo.doc();
if(_124.createElement){
var tmp=_124.createElement("xml");
tmp.innerHTML=str;
if(_124.implementation&&_124.implementation.createDocument){
var _126=_124.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_126.importNode(tmp.childNodes.item(i),true);
}
return _126;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_129){
if(_129.firstChild){
_129.insertBefore(node,_129.firstChild);
}else{
_129.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_12c){
if((_12c!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _12d=ref.parentNode;
_12d.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_130){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_130!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_130);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_134){
if((!node)||(!ref)||(!_134)){
return false;
}
switch(_134.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_136,_137){
var _138=_136.childNodes;
if(!_138.length||_138.length==_137){
_136.appendChild(node);
return true;
}
if(_137==0){
return dojo.dom.prependChild(node,_136);
}
return dojo.dom.insertAfter(node,_138[_137-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _13b=dojo.doc();
dojo.dom.replaceChildren(node,_13b.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _13c="";
if(node==null){
return _13c;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_13c+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_13c+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _13c;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_142,_143,_144){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_142,_143,_144);
}else{
var _145=elem.ownerDocument;
var _146=_145.createNode(2,_143,_142);
_146.nodeValue=_144;
elem.setAttributeNode(_146);
}
};
dojo.provide("dojo.xml.Parse");
dojo.xml.Parse=function(){
var isIE=((dojo.render.html.capable)&&(dojo.render.html.ie));
function getTagName(node){
try{
return node.tagName.toLowerCase();
}
catch(e){
return "";
}
}
function getDojoTagName(node){
var _14a=getTagName(node);
if(!_14a){
return "";
}
if((dojo.widget)&&(dojo.widget.tags[_14a])){
return _14a;
}
var p=_14a.indexOf(":");
if(p>=0){
return _14a;
}
if(_14a.substr(0,5)=="dojo:"){
return _14a;
}
if(dojo.render.html.capable&&dojo.render.html.ie&&node.scopeName!="HTML"){
return node.scopeName.toLowerCase()+":"+_14a;
}
if(_14a.substr(0,4)=="dojo"){
return "dojo:"+_14a.substring(4);
}
var djt=node.getAttribute("dojoType")||node.getAttribute("dojotype");
if(djt){
if(djt.indexOf(":")<0){
djt="dojo:"+djt;
}
return djt.toLowerCase();
}
djt=node.getAttributeNS&&node.getAttributeNS(dojo.dom.dojoml,"type");
if(djt){
return "dojo:"+djt.toLowerCase();
}
try{
djt=node.getAttribute("dojo:type");
}
catch(e){
}
if(djt){
return "dojo:"+djt.toLowerCase();
}
if((dj_global["djConfig"])&&(!djConfig["ignoreClassNames"])){
var _14d=node.className||node.getAttribute("class");
if((_14d)&&(_14d.indexOf)&&(_14d.indexOf("dojo-")!=-1)){
var _14e=_14d.split(" ");
for(var x=0,c=_14e.length;x<c;x++){
if(_14e[x].slice(0,5)=="dojo-"){
return "dojo:"+_14e[x].substr(5).toLowerCase();
}
}
}
}
return "";
}
this.parseElement=function(node,_152,_153,_154){
var _155=getTagName(node);
if(isIE&&_155.indexOf("/")==0){
return null;
}
try{
var attr=node.getAttribute("parseWidgets");
if(attr&&attr.toLowerCase()=="false"){
return {};
}
}
catch(e){
}
var _157=true;
if(_153){
var _158=getDojoTagName(node);
_155=_158||_155;
_157=Boolean(_158);
}
var _159={};
_159[_155]=[];
var pos=_155.indexOf(":");
if(pos>0){
var ns=_155.substring(0,pos);
_159["ns"]=ns;
if((dojo.ns)&&(!dojo.ns.allow(ns))){
_157=false;
}
}
if(_157){
var _15c=this.parseAttributes(node);
for(var attr in _15c){
if((!_159[_155][attr])||(typeof _159[_155][attr]!="array")){
_159[_155][attr]=[];
}
_159[_155][attr].push(_15c[attr]);
}
_159[_155].nodeRef=node;
_159.tagName=_155;
_159.index=_154||0;
}
var _15d=0;
for(var i=0;i<node.childNodes.length;i++){
var tcn=node.childNodes.item(i);
switch(tcn.nodeType){
case dojo.dom.ELEMENT_NODE:
var ctn=getDojoTagName(tcn)||getTagName(tcn);
if(!_159[ctn]){
_159[ctn]=[];
}
_159[ctn].push(this.parseElement(tcn,true,_153,_15d));
if((tcn.childNodes.length==1)&&(tcn.childNodes.item(0).nodeType==dojo.dom.TEXT_NODE)){
_159[ctn][_159[ctn].length-1].value=tcn.childNodes.item(0).nodeValue;
}
_15d++;
break;
case dojo.dom.TEXT_NODE:
if(node.childNodes.length==1){
_159[_155].push({value:node.childNodes.item(0).nodeValue});
}
break;
default:
break;
}
}
return _159;
};
this.parseAttributes=function(node){
var _162={};
var atts=node.attributes;
var _164,i=0;
while((_164=atts[i++])){
if(isIE){
if(!_164){
continue;
}
if((typeof _164=="object")&&(typeof _164.nodeValue=="undefined")||(_164.nodeValue==null)||(_164.nodeValue=="")){
continue;
}
}
var nn=_164.nodeName.split(":");
nn=(nn.length==2)?nn[1]:_164.nodeName;
_162[nn]={value:_164.nodeValue};
}
return _162;
};
};
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_167,_168){
if(!dojo.lang.isFunction(_168)){
dojo.raise("dojo.inherits: superclass argument ["+_168+"] must be a function (subclass: ["+_167+"']");
}
_167.prototype=new _168();
_167.prototype.constructor=_167;
_167.superclass=_168.prototype;
_167["super"]=_168.prototype;
};
dojo.lang._mixin=function(obj,_16a){
var tobj={};
for(var x in _16a){
if((typeof tobj[x]=="undefined")||(tobj[x]!=_16a[x])){
obj[x]=_16a[x];
}
}
if(dojo.render.html.ie&&(typeof (_16a["toString"])=="function")&&(_16a["toString"]!=obj["toString"])&&(_16a["toString"]!=tobj["toString"])){
obj.toString=_16a.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_16e){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_171,_172){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_171.prototype,arguments[i]);
}
return _171;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_175,_176,_177,_178){
if(!dojo.lang.isArrayLike(_175)&&dojo.lang.isArrayLike(_176)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_175;
_175=_176;
_176=temp;
}
var _17a=dojo.lang.isString(_175);
if(_17a){
_175=_175.split("");
}
if(_178){
var step=-1;
var i=_175.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_175.length;
}
if(_177){
while(i!=end){
if(_175[i]===_176){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_175[i]==_176){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_17e,_17f,_180){
return dojo.lang.find(_17e,_17f,_180,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_181,_182){
return dojo.lang.find(_181,_182)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_18d,_18e){
var fcn=(dojo.lang.isString(_18e)?_18d[_18e]:_18e)||function(){
};
return function(){
return fcn.apply(_18d,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_190,_191,_192){
var nso=(_191||dojo.lang.anon);
if((_192)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_190){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_190;
return ret;
};
dojo.lang.forward=function(_196){
return function(){
return this[_196].apply(this,arguments);
};
};
dojo.lang.curry=function(_197,func){
var _199=[];
_197=_197||dj_global;
if(dojo.lang.isString(func)){
func=_197[func];
}
for(var x=2;x<arguments.length;x++){
_199.push(arguments[x]);
}
var _19b=(func["__preJoinArity"]||func.length)-_199.length;
function gather(_19c,_19d,_19e){
var _19f=_19e;
var _1a0=_19d.slice(0);
for(var x=0;x<_19c.length;x++){
_1a0.push(_19c[x]);
}
_19e=_19e-_19c.length;
if(_19e<=0){
var res=func.apply(_197,_1a0);
_19e=_19f;
return res;
}else{
return function(){
return gather(arguments,_1a0,_19e);
};
}
}
return gather([],_199,_19b);
};
dojo.lang.curryArguments=function(_1a3,func,args,_1a6){
var _1a7=[];
var x=_1a6||0;
for(x=_1a6;x<args.length;x++){
_1a7.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_1a3,func].concat(_1a7));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_1ad,_1ae){
if(!farr.length){
if(typeof _1ae=="function"){
_1ae();
}
return;
}
if((typeof _1ad=="undefined")&&(typeof cb=="number")){
_1ad=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_1ad){
_1ad=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_1ad,_1ae);
},_1ad);
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _1b3=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_1b3++;
break;
}
}
return _1b3==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
},map:function(arr,obj,_1b7){
var _1b8=dojo.lang.isString(arr);
if(_1b8){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_1b7)){
_1b7=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_1b7){
var _1b9=obj;
obj=_1b7;
_1b7=_1b9;
}
}
if(Array.map){
var _1ba=Array.map(arr,_1b7,obj);
}else{
var _1ba=[];
for(var i=0;i<arr.length;++i){
_1ba.push(_1b7.call(obj,arr[i]));
}
}
if(_1b8){
return _1ba.join("");
}else{
return _1ba;
}
},reduce:function(arr,_1bd,obj,_1bf){
var _1c0=_1bd;
if(arguments.length==2){
_1bf=_1bd;
_1c0=arr[0];
arr=arr.slice(1);
}else{
if(arguments.length==3){
if(dojo.lang.isFunction(obj)){
_1bf=obj;
obj=null;
}
}else{
if(dojo.lang.isFunction(obj)){
var tmp=_1bf;
_1bf=obj;
obj=tmp;
}
}
}
var ob=obj||dj_global;
dojo.lang.map(arr,function(val){
_1c0=_1bf.call(ob,_1c0,val);
});
return _1c0;
},forEach:function(_1c4,_1c5,_1c6){
if(dojo.lang.isString(_1c4)){
_1c4=_1c4.split("");
}
if(Array.forEach){
Array.forEach(_1c4,_1c5,_1c6);
}else{
if(!_1c6){
_1c6=dj_global;
}
for(var i=0,l=_1c4.length;i<l;i++){
_1c5.call(_1c6,_1c4[i],i,_1c4);
}
}
},_everyOrSome:function(_1c9,arr,_1cb,_1cc){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_1c9?"every":"some"](arr,_1cb,_1cc);
}else{
if(!_1cc){
_1cc=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _1cf=_1cb.call(_1cc,arr[i],i,arr);
if(_1c9&&!_1cf){
return false;
}else{
if((!_1c9)&&(_1cf)){
return true;
}
}
}
return Boolean(_1c9);
}
},every:function(arr,_1d1,_1d2){
return this._everyOrSome(true,arr,_1d1,_1d2);
},some:function(arr,_1d4,_1d5){
return this._everyOrSome(false,arr,_1d4,_1d5);
},filter:function(arr,_1d7,_1d8){
var _1d9=dojo.lang.isString(arr);
if(_1d9){
arr=arr.split("");
}
var _1da;
if(Array.filter){
_1da=Array.filter(arr,_1d7,_1d8);
}else{
if(!_1d8){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_1d8=dj_global;
}
_1da=[];
for(var i=0;i<arr.length;i++){
if(_1d7.call(_1d8,arr[i],i,arr)){
_1da.push(arr[i]);
}
}
}
if(_1d9){
return _1da.join("");
}else{
return _1da;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_1df,_1e0){
var _1e1=[];
for(var i=_1e0||0;i<_1df.length;i++){
_1e1.push(_1df[i]);
}
return _1e1;
}});
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_1e4){
var _1e5=window,_1e6=2;
if(!dojo.lang.isFunction(func)){
_1e5=func;
func=_1e4;
_1e4=arguments[2];
_1e6++;
}
if(dojo.lang.isString(func)){
func=_1e5[func];
}
var args=[];
for(var i=_1e6;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_1e5,args);
},_1e4);
};
dojo.lang.clearTimeout=function(_1e9){
dojo.global().clearTimeout(_1e9);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_1f2,_1f3,_1f4){
with(dojo.parseObjPath(_1f2,_1f3,_1f4)){
return dojo.evalProp(prop,obj,_1f4);
}
};
dojo.lang.setObjPathValue=function(_1f5,_1f6,_1f7,_1f8){
dojo.deprecated("dojo.lang.setObjPathValue","use dojo.parseObjPath and the '=' operator","0.6");
if(arguments.length<4){
_1f8=true;
}
with(dojo.parseObjPath(_1f5,_1f7,_1f8)){
if(obj&&(_1f8||(prop in obj))){
obj[prop]=_1f6;
}
}
};
dojo.provide("dojo.lang.declare");
dojo.lang.declare=function(_1f9,_1fa,init,_1fc){
if((dojo.lang.isFunction(_1fc))||((!_1fc)&&(!dojo.lang.isFunction(init)))){
var temp=_1fc;
_1fc=init;
init=temp;
}
var _1fe=[];
if(dojo.lang.isArray(_1fa)){
_1fe=_1fa;
_1fa=_1fe.shift();
}
if(!init){
init=dojo.evalObjPath(_1f9,false);
if((init)&&(!dojo.lang.isFunction(init))){
init=null;
}
}
var ctor=dojo.lang.declare._makeConstructor();
var scp=(_1fa?_1fa.prototype:null);
if(scp){
scp.prototyping=true;
ctor.prototype=new _1fa();
scp.prototyping=false;
}
ctor.superclass=scp;
ctor.mixins=_1fe;
for(var i=0,l=_1fe.length;i<l;i++){
dojo.lang.extend(ctor,_1fe[i].prototype);
}
ctor.prototype.initializer=null;
ctor.prototype.declaredClass=_1f9;
if(dojo.lang.isArray(_1fc)){
dojo.lang.extend.apply(dojo.lang,[ctor].concat(_1fc));
}else{
dojo.lang.extend(ctor,(_1fc)||{});
}
dojo.lang.extend(ctor,dojo.lang.declare._common);
ctor.prototype.constructor=ctor;
ctor.prototype.initializer=(ctor.prototype.initializer)||(init)||(function(){
});
var _203=dojo.parseObjPath(_1f9,null,true);
_203.obj[_203.prop]=ctor;
return ctor;
};
dojo.lang.declare._makeConstructor=function(){
return function(){
var self=this._getPropContext();
var s=self.constructor.superclass;
if((s)&&(s.constructor)){
if(s.constructor==arguments.callee){
this._inherited("constructor",arguments);
}else{
this._contextMethod(s,"constructor",arguments);
}
}
var ms=(self.constructor.mixins)||([]);
for(var i=0,m;(m=ms[i]);i++){
(((m.prototype)&&(m.prototype.initializer))||(m)).apply(this,arguments);
}
if((!this.prototyping)&&(self.initializer)){
self.initializer.apply(this,arguments);
}
};
};
dojo.lang.declare._common={_getPropContext:function(){
return (this.___proto||this);
},_contextMethod:function(_209,_20a,args){
var _20c,_20d=this.___proto;
this.___proto=_209;
try{
_20c=_209[_20a].apply(this,(args||[]));
}
catch(e){
throw e;
}
finally{
this.___proto=_20d;
}
return _20c;
},_inherited:function(prop,args){
var p=this._getPropContext();
do{
if((!p.constructor)||(!p.constructor.superclass)){
return;
}
p=p.constructor.superclass;
}while(!(prop in p));
return (dojo.lang.isFunction(p[prop])?this._contextMethod(p,prop,args):p[prop]);
},inherited:function(prop,args){
dojo.deprecated("'inherited' method is dangerous, do not up-call! 'inherited' is slated for removal in 0.5; name your super class (or use superclass property) instead.","0.5");
this._inherited(prop,args);
}};
dojo.declare=dojo.lang.declare;
dojo.provide("dojo.ns");
dojo.ns={namespaces:{},failed:{},loading:{},loaded:{},register:function(name,_214,_215,_216){
if(!_216||!this.namespaces[name]){
this.namespaces[name]=new dojo.ns.Ns(name,_214,_215);
}
},allow:function(name){
if(this.failed[name]){
return false;
}
if((djConfig.excludeNamespace)&&(dojo.lang.inArray(djConfig.excludeNamespace,name))){
return false;
}
return ((name==this.dojo)||(!djConfig.includeNamespace)||(dojo.lang.inArray(djConfig.includeNamespace,name)));
},get:function(name){
return this.namespaces[name];
},require:function(name){
var ns=this.namespaces[name];
if((ns)&&(this.loaded[name])){
return ns;
}
if(!this.allow(name)){
return false;
}
if(this.loading[name]){
dojo.debug("dojo.namespace.require: re-entrant request to load namespace \""+name+"\" must fail.");
return false;
}
var req=dojo.require;
this.loading[name]=true;
try{
if(name=="dojo"){
req("dojo.namespaces.dojo");
}else{
if(!dojo.hostenv.moduleHasPrefix(name)){
dojo.registerModulePath(name,"../"+name);
}
req([name,"manifest"].join("."),false,true);
}
if(!this.namespaces[name]){
this.failed[name]=true;
}
}
finally{
this.loading[name]=false;
}
return this.namespaces[name];
}};
dojo.ns.Ns=function(name,_21d,_21e){
this.name=name;
this.module=_21d;
this.resolver=_21e;
this._loaded=[];
this._failed=[];
};
dojo.ns.Ns.prototype.resolve=function(name,_220,_221){
if(!this.resolver||djConfig["skipAutoRequire"]){
return false;
}
var _222=this.resolver(name,_220);
if((_222)&&(!this._loaded[_222])&&(!this._failed[_222])){
var req=dojo.require;
req(_222,false,true);
if(dojo.hostenv.findModule(_222,false)){
this._loaded[_222]=true;
}else{
if(!_221){
dojo.raise("dojo.ns.Ns.resolve: module '"+_222+"' not found after loading via namespace '"+this.name+"'");
}
this._failed[_222]=true;
}
}
return Boolean(this._loaded[_222]);
};
dojo.registerNamespace=function(name,_225,_226){
dojo.ns.register.apply(dojo.ns,arguments);
};
dojo.registerNamespaceResolver=function(name,_228){
var n=dojo.ns.namespaces[name];
if(n){
n.resolver=_228;
}
};
dojo.registerNamespaceManifest=function(_22a,path,name,_22d,_22e){
dojo.registerModulePath(name,path);
dojo.registerNamespace(name,_22d,_22e);
};
dojo.registerNamespace("dojo","dojo.widget");
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_230){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false,maxCalls:-1};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _233=dl.nameAnonFunc(args[2],ao.adviceObj,_230);
ao.adviceFunc=_233;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _233=dl.nameAnonFunc(args[0],ao.srcObj,_230);
ao.srcFunc=_233;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _233=dl.nameAnonFunc(args[1],dj_global,_230);
ao.srcFunc=_233;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _233=dl.nameAnonFunc(args[3],dj_global,_230);
ao.adviceObj=dj_global;
ao.adviceFunc=_233;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
ao.maxCalls=(!isNaN(parseInt(args[11])))?args[11]:-1;
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _233=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_230);
ao.aroundFunc=_233;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _235={};
for(var x in ao){
_235[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_235.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_235));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _23d;
if((arguments.length==1)&&(typeof a1=="object")){
_23d=a1;
}else{
_23d={srcObj:a1,srcFunc:a2};
}
_23d.adviceFunc=function(){
var _23e=[];
for(var x=0;x<arguments.length;x++){
_23e.push(arguments[x]);
}
dojo.debug("("+_23d.srcObj+")."+_23d.srcFunc,":",_23e.join(", "));
};
this.kwConnect(_23d);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this.connectRunOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.maxCalls=1;
return this.connect(ao);
};
this._kwConnectImpl=function(_246,_247){
var fn=(_247)?"disconnect":"connect";
if(typeof _246["srcFunc"]=="function"){
_246.srcObj=_246["srcObj"]||dj_global;
var _249=dojo.lang.nameAnonFunc(_246.srcFunc,_246.srcObj,true);
_246.srcFunc=_249;
}
if(typeof _246["adviceFunc"]=="function"){
_246.adviceObj=_246["adviceObj"]||dj_global;
var _249=dojo.lang.nameAnonFunc(_246.adviceFunc,_246.adviceObj,true);
_246.adviceFunc=_249;
}
_246.srcObj=_246["srcObj"]||dj_global;
_246.adviceObj=_246["adviceObj"]||_246["targetObj"]||dj_global;
_246.adviceFunc=_246["adviceFunc"]||_246["targetFunc"];
return dojo.event[fn](_246);
};
this.kwConnect=function(_24a){
return this._kwConnectImpl(_24a,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
if(!ao.srcObj[ao.srcFunc]){
return null;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc,true);
mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
return mjp;
};
this.kwDisconnect=function(_24d){
return this._kwConnectImpl(_24d,true);
};
};
dojo.event.MethodInvocation=function(_24e,obj,args){
this.jp_=_24e;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_256){
this.object=obj||dj_global;
this.methodname=_256;
this.methodfunc=this.object[_256];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_258){
if(!obj){
obj=dj_global;
}
var ofn=obj[_258];
if(!ofn){
ofn=obj[_258]=function(){
};
if(!obj[_258]){
dojo.raise("Cannot set do-nothing method on that object "+_258);
}
}else{
if((typeof ofn!="function")&&(!dojo.lang.isFunction(ofn))&&(!dojo.lang.isAlien(ofn))){
return null;
}
}
var _25a=_258+"$joinpoint";
var _25b=_258+"$joinpoint$method";
var _25c=obj[_25a];
if(!_25c){
var _25d=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_25d=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_25a,_25b,_258]);
}
}
var _25e=ofn.length;
obj[_25b]=ofn;
_25c=obj[_25a]=new dojo.event.MethodJoinPoint(obj,_25b);
if(!_25d){
obj[_258]=function(){
return _25c.run.apply(_25c,arguments);
};
}else{
obj[_258]=function(){
var args=[];
if(!arguments.length){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _25c.run.apply(_25c,args);
};
}
obj[_258].__preJoinArity=_25e;
}
return _25c;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{squelch:false,unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _264=[];
for(var x=0;x<args.length;x++){
_264[x]=args[x];
}
var _266=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _268=marr[0]||dj_global;
var _269=marr[1];
if(!_268[_269]){
dojo.raise("function \""+_269+"\" does not exist on \""+_268+"\"");
}
var _26a=marr[2]||dj_global;
var _26b=marr[3];
var msg=marr[6];
var _26d=marr[7];
if(_26d>-1){
if(_26d==0){
return;
}
marr[7]--;
}
var _26e;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _268[_269].apply(_268,to.args);
}};
to.args=_264;
var _270=parseInt(marr[4]);
var _271=((!isNaN(_270))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _274=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_266(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_26b){
_26a[_26b].call(_26a,to);
}else{
if((_271)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_268[_269].call(_268,to);
}else{
_268[_269].apply(_268,args);
}
},_270);
}else{
if(msg){
_268[_269].call(_268,to);
}else{
_268[_269].apply(_268,args);
}
}
}
};
var _277=function(){
if(this.squelch){
try{
return _266.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _266.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_277);
}
var _278;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_278=mi.proceed();
}else{
if(this.methodfunc){
_278=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.debug(e,"when calling",this.methodname,"on",this.object,"with arguments",args);
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_277);
}
return (this.methodfunc)?_278:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"],args["maxCalls"]);
},addAdvice:function(_27d,_27e,_27f,_280,_281,_282,once,_284,rate,_286,_287){
var arr=this.getArr(_281);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_27d,_27e,_27f,_280,_284,rate,_286,_287];
if(once){
if(this.hasAdvice(_27d,_27e,_281,arr)>=0){
return;
}
}
if(_282=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_28a,_28b,_28c,arr){
if(!arr){
arr=this.getArr(_28c);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _28b=="object")?(new String(_28b)).toString():_28b;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_28a)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_292,_293,_294,once){
var arr=this.getArr(_294);
var ind=this.hasAdvice(_292,_293,_294,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_292,_293,_294,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_298){
if(!this.topics[_298]){
this.topics[_298]=new this.TopicImpl(_298);
}
return this.topics[_298];
};
this.registerPublisher=function(_299,obj,_29b){
var _299=this.getTopic(_299);
_299.registerPublisher(obj,_29b);
};
this.subscribe=function(_29c,obj,_29e){
var _29c=this.getTopic(_29c);
_29c.subscribe(obj,_29e);
};
this.unsubscribe=function(_29f,obj,_2a1){
var _29f=this.getTopic(_29f);
_29f.unsubscribe(obj,_2a1);
};
this.destroy=function(_2a2){
this.getTopic(_2a2).destroy();
delete this.topics[_2a2];
};
this.publishApply=function(_2a3,args){
var _2a3=this.getTopic(_2a3);
_2a3.sendMessage.apply(_2a3,args);
};
this.publish=function(_2a5,_2a6){
var _2a5=this.getTopic(_2a5);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_2a5.sendMessage.apply(_2a5,args);
};
};
dojo.event.topic.TopicImpl=function(_2a9){
this.topicName=_2a9;
this.subscribe=function(_2aa,_2ab){
var tf=_2ab||_2aa;
var to=(!_2ab)?dj_global:_2aa;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_2ae,_2af){
var tf=(!_2af)?_2ae:_2af;
var to=(!_2af)?null:_2ae;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_2b2){
this._getJoinPoint().squelch=_2b2;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_2b3,_2b4){
dojo.event.connect(_2b3,_2b4,this,"sendMessage");
};
this.sendMessage=function(_2b5){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_2b8){
var na;
var tna;
if(_2b8){
tna=_2b8.all||_2b8.getElementsByTagName("*");
na=[_2b8];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _2bc={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
if(dojo.widget){
for(var name in dojo.widget._templateCache){
if(dojo.widget._templateCache[name].node){
dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
dojo.widget._templateCache[name].node=null;
delete dojo.widget._templateCache[name].node;
}
}
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _2c1=0;
this.normalizedEventName=function(_2c2){
switch(_2c2){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _2c2;
break;
default:
var lcn=_2c2.toLowerCase();
return (lcn.indexOf("on")==0)?lcn.substr(2):lcn;
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_2c7){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_2c7.length;x++){
node.__clobberAttrs__.push(_2c7[x]);
}
};
this.removeListener=function(node,_2ca,fp,_2cc){
if(!_2cc){
var _2cc=false;
}
_2ca=dojo.event.browser.normalizedEventName(_2ca);
if(_2ca=="key"){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_2cc);
}
_2ca="keypress";
}
if(node.removeEventListener){
node.removeEventListener(_2ca,fp,_2cc);
}
};
this.addListener=function(node,_2ce,fp,_2d0,_2d1){
if(!node){
return;
}
if(!_2d0){
var _2d0=false;
}
_2ce=dojo.event.browser.normalizedEventName(_2ce);
if(_2ce=="key"){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_2d0,_2d1);
}
_2ce="keypress";
}
if(!_2d1){
var _2d2=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_2d0){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_2d2=fp;
}
if(node.addEventListener){
node.addEventListener(_2ce,_2d2,_2d0);
return _2d2;
}else{
_2ce="on"+_2ce;
if(typeof node[_2ce]=="function"){
var _2d5=node[_2ce];
node[_2ce]=function(e){
_2d5(e);
return _2d2(e);
};
}else{
node[_2ce]=_2d2;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_2ce]);
}
return _2d2;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(obj)&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_2d8,_2d9){
if(typeof _2d8!="function"){
dojo.raise("listener not a function: "+_2d8);
}
dojo.event.browser.currentEvent.currentTarget=_2d9;
return _2d8.call(_2d9,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_2dc){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _2de=evt.keyCode;
if(_2de>=65&&_2de<=90&&evt.shiftKey==false){
_2de+=32;
}
if(_2de>=1&&_2de<=26&&evt.ctrlKey){
_2de+=96;
}
evt.key=String.fromCharCode(_2de);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _2de=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_2de+=32;
}
evt.key=String.fromCharCode(_2de);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 25:
evt.key=evt.KEY_TAB;
evt.shift=true;
break;
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
case 63236:
evt.key=evt.KEY_F1;
break;
case 63237:
evt.key=evt.KEY_F2;
break;
case 63238:
evt.key=evt.KEY_F3;
break;
case 63239:
evt.key=evt.KEY_F4;
break;
case 63240:
evt.key=evt.KEY_F5;
break;
case 63241:
evt.key=evt.KEY_F6;
break;
case 63242:
evt.key=evt.KEY_F7;
break;
case 63243:
evt.key=evt.KEY_F8;
break;
case 63244:
evt.key=evt.KEY_F9;
break;
case 63245:
evt.key=evt.KEY_F10;
break;
case 63246:
evt.key=evt.KEY_F11;
break;
case 63247:
evt.key=evt.KEY_F12;
break;
case 63250:
evt.key=evt.KEY_PAUSE;
break;
case 63272:
evt.key=evt.KEY_DELETE;
break;
case 63273:
evt.key=evt.KEY_HOME;
break;
case 63275:
evt.key=evt.KEY_END;
break;
case 63276:
evt.key=evt.KEY_PAGE_UP;
break;
case 63277:
evt.key=evt.KEY_PAGE_DOWN;
break;
case 63302:
evt.key=evt.KEY_INSERT;
break;
case 63248:
case 63249:
case 63289:
break;
default:
evt.key=evt.charCode>=evt.KEY_SPACE?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_2dc?_2dc:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _2e0=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_2e0.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_2e0.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.cancelBubble=true;
evt.returnValue=false;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.kwCompoundRequire({common:["dojo.event.common","dojo.event.topic"],browser:["dojo.event.browser"],dashboard:["dojo.event.browser"]});
dojo.provide("dojo.event.*");
dojo.provide("dojo.widget.Manager");
dojo.widget.manager=new function(){
this.widgets=[];
this.widgetIds=[];
this.topWidgets={};
var _2e2={};
var _2e3=[];
this.getUniqueId=function(_2e4){
var _2e5;
do{
_2e5=_2e4+"_"+(_2e2[_2e4]!=undefined?++_2e2[_2e4]:_2e2[_2e4]=0);
}while(this.getWidgetById(_2e5));
return _2e5;
};
this.add=function(_2e6){
this.widgets.push(_2e6);
if(!_2e6.extraArgs["id"]){
_2e6.extraArgs["id"]=_2e6.extraArgs["ID"];
}
if(_2e6.widgetId==""){
if(_2e6["id"]){
_2e6.widgetId=_2e6["id"];
}else{
if(_2e6.extraArgs["id"]){
_2e6.widgetId=_2e6.extraArgs["id"];
}else{
_2e6.widgetId=this.getUniqueId(_2e6.ns+"_"+_2e6.widgetType);
}
}
}
if(this.widgetIds[_2e6.widgetId]){
dojo.debug("widget ID collision on ID: "+_2e6.widgetId);
}
this.widgetIds[_2e6.widgetId]=_2e6;
};
this.destroyAll=function(){
for(var x=this.widgets.length-1;x>=0;x--){
try{
this.widgets[x].destroy(true);
delete this.widgets[x];
}
catch(e){
}
}
};
this.remove=function(_2e8){
if(dojo.lang.isNumber(_2e8)){
var tw=this.widgets[_2e8].widgetId;
delete this.topWidgets[tw];
delete this.widgetIds[tw];
this.widgets.splice(_2e8,1);
}else{
this.removeById(_2e8);
}
};
this.removeById=function(id){
if(!dojo.lang.isString(id)){
id=id["widgetId"];
if(!id){
dojo.debug("invalid widget or id passed to removeById");
return;
}
}
for(var i=0;i<this.widgets.length;i++){
if(this.widgets[i].widgetId==id){
this.remove(i);
break;
}
}
};
this.getWidgetById=function(id){
if(dojo.lang.isString(id)){
return this.widgetIds[id];
}
return id;
};
this.getWidgetsByType=function(type){
var lt=type.toLowerCase();
var _2ef=(type.indexOf(":")<0?function(x){
return x.widgetType.toLowerCase();
}:function(x){
return x.getNamespacedType();
});
var ret=[];
dojo.lang.forEach(this.widgets,function(x){
if(_2ef(x)==lt){
ret.push(x);
}
});
return ret;
};
this.getWidgetsByFilter=function(_2f4,_2f5){
var ret=[];
dojo.lang.every(this.widgets,function(x){
if(_2f4(x)){
ret.push(x);
if(_2f5){
return false;
}
}
return true;
});
return (_2f5?ret[0]:ret);
};
this.getAllWidgets=function(){
return this.widgets.concat();
};
this.getWidgetByNode=function(node){
var w=this.getAllWidgets();
node=dojo.byId(node);
for(var i=0;i<w.length;i++){
if(w[i].domNode==node){
return w[i];
}
}
return null;
};
this.byId=this.getWidgetById;
this.byType=this.getWidgetsByType;
this.byFilter=this.getWidgetsByFilter;
this.byNode=this.getWidgetByNode;
var _2fb={};
var _2fc=["dojo.widget"];
for(var i=0;i<_2fc.length;i++){
_2fc[_2fc[i]]=true;
}
this.registerWidgetPackage=function(_2fe){
if(!_2fc[_2fe]){
_2fc[_2fe]=true;
_2fc.push(_2fe);
}
};
this.getWidgetPackageList=function(){
return dojo.lang.map(_2fc,function(elt){
return (elt!==true?elt:undefined);
});
};
this.getImplementation=function(_300,_301,_302,ns){
var impl=this.getImplementationName(_300,ns);
if(impl){
var ret=_301?new impl(_301):new impl();
return ret;
}
};
function buildPrefixCache(){
for(var _306 in dojo.render){
if(dojo.render[_306]["capable"]===true){
var _307=dojo.render[_306].prefixes;
for(var i=0;i<_307.length;i++){
_2e3.push(_307[i].toLowerCase());
}
}
}
}
var _309=function(_30a,_30b){
if(!_30b){
return null;
}
for(var i=0,l=_2e3.length,_30e;i<=l;i++){
_30e=(i<l?_30b[_2e3[i]]:_30b);
if(!_30e){
continue;
}
for(var name in _30e){
if(name.toLowerCase()==_30a){
return _30e[name];
}
}
}
return null;
};
var _310=function(_311,_312){
var _313=dojo.evalObjPath(_312,false);
return (_313?_309(_311,_313):null);
};
this.getImplementationName=function(_314,ns){
var _316=_314.toLowerCase();
ns=ns||"dojo";
var imps=_2fb[ns]||(_2fb[ns]={});
var impl=imps[_316];
if(impl){
return impl;
}
if(!_2e3.length){
buildPrefixCache();
}
var _319=dojo.ns.get(ns);
if(!_319){
dojo.ns.register(ns,ns+".widget");
_319=dojo.ns.get(ns);
}
if(_319){
_319.resolve(_314);
}
impl=_310(_316,_319.module);
if(impl){
return (imps[_316]=impl);
}
_319=dojo.ns.require(ns);
if((_319)&&(_319.resolver)){
_319.resolve(_314);
impl=_310(_316,_319.module);
if(impl){
return (imps[_316]=impl);
}
}
dojo.deprecated("dojo.widget.Manager.getImplementationName","Could not locate widget implementation for \""+_314+"\" in \""+_319.module+"\" registered to namespace \""+_319.name+"\". "+"Developers must specify correct namespaces for all non-Dojo widgets","0.5");
for(var i=0;i<_2fc.length;i++){
impl=_310(_316,_2fc[i]);
if(impl){
return (imps[_316]=impl);
}
}
throw new Error("Could not locate widget implementation for \""+_314+"\" in \""+_319.module+"\" registered to namespace \""+_319.name+"\"");
};
this.resizing=false;
this.onWindowResized=function(){
if(this.resizing){
return;
}
try{
this.resizing=true;
for(var id in this.topWidgets){
var _31c=this.topWidgets[id];
if(_31c.checkSize){
_31c.checkSize();
}
}
}
catch(e){
}
finally{
this.resizing=false;
}
};
if(typeof window!="undefined"){
dojo.addOnLoad(this,"onWindowResized");
dojo.event.connect(window,"onresize",this,"onWindowResized");
}
};
(function(){
var dw=dojo.widget;
var dwm=dw.manager;
var h=dojo.lang.curry(dojo.lang,"hitch",dwm);
var g=function(_321,_322){
dw[(_322||_321)]=h(_321);
};
g("add","addWidget");
g("destroyAll","destroyAllWidgets");
g("remove","removeWidget");
g("removeById","removeWidgetById");
g("getWidgetById");
g("getWidgetById","byId");
g("getWidgetsByType");
g("getWidgetsByFilter");
g("getWidgetsByType","byType");
g("getWidgetsByFilter","byFilter");
g("getWidgetByNode","byNode");
dw.all=function(n){
var _324=dwm.getAllWidgets.apply(dwm,arguments);
if(arguments.length>0){
return _324[n];
}
return _324;
};
g("registerWidgetPackage");
g("getImplementation","getWidgetImplementation");
g("getImplementationName","getWidgetImplementationName");
dw.widgets=dwm.widgets;
dw.widgetIds=dwm.widgetIds;
dw.root=dwm.root;
})();
dojo.provide("dojo.uri.Uri");
dojo.uri=new function(){
this.dojoUri=function(uri){
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri(),uri);
};
this.moduleUri=function(_326,uri){
var loc=dojo.hostenv.getModuleSymbols(_326).join("/");
if(!loc){
return null;
}
if(loc.lastIndexOf("/")!=loc.length-1){
loc+="/";
}
var _329=loc.indexOf(":");
var _32a=loc.indexOf("/");
if(loc.charAt(0)!="/"&&(_329==-1||_329>_32a)){
loc=dojo.hostenv.getBaseScriptUri()+loc;
}
return new dojo.uri.Uri(loc,uri);
};
this.Uri=function(){
var uri=arguments[0];
for(var i=1;i<arguments.length;i++){
if(!arguments[i]){
continue;
}
var _32d=new dojo.uri.Uri(arguments[i].toString());
var _32e=new dojo.uri.Uri(uri.toString());
if((_32d.path=="")&&(_32d.scheme==null)&&(_32d.authority==null)&&(_32d.query==null)){
if(_32d.fragment!=null){
_32e.fragment=_32d.fragment;
}
_32d=_32e;
}else{
if(_32d.scheme==null){
_32d.scheme=_32e.scheme;
if(_32d.authority==null){
_32d.authority=_32e.authority;
if(_32d.path.charAt(0)!="/"){
var path=_32e.path.substring(0,_32e.path.lastIndexOf("/")+1)+_32d.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==segs.length-1){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_32d.path=segs.join("/");
}
}
}
}
uri="";
if(_32d.scheme!=null){
uri+=_32d.scheme+":";
}
if(_32d.authority!=null){
uri+="//"+_32d.authority;
}
uri+=_32d.path;
if(_32d.query!=null){
uri+="?"+_32d.query;
}
if(_32d.fragment!=null){
uri+="#"+_32d.fragment;
}
}
this.uri=uri.toString();
var _332="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=this.uri.match(new RegExp(_332));
this.scheme=r[2]||(r[1]?"":null);
this.authority=r[4]||(r[3]?"":null);
this.path=r[5];
this.query=r[7]||(r[6]?"":null);
this.fragment=r[9]||(r[8]?"":null);
if(this.authority!=null){
_332="^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$";
r=this.authority.match(new RegExp(_332));
this.user=r[3]||null;
this.password=r[4]||null;
this.host=r[5];
this.port=r[7]||null;
}
this.toString=function(){
return this.uri;
};
};
};
dojo.kwCompoundRequire({common:[["dojo.uri.Uri",false,false]]});
dojo.provide("dojo.uri.*");
dojo.provide("dojo.html.common");
dojo.lang.mixin(dojo.html,dojo.dom);
dojo.html.body=function(){
dojo.deprecated("dojo.html.body() moved to dojo.body()","0.5");
return dojo.body();
};
dojo.html.getEventTarget=function(evt){
if(!evt){
evt=dojo.global().event||{};
}
var t=(evt.srcElement?evt.srcElement:(evt.target?evt.target:null));
while((t)&&(t.nodeType!=1)){
t=t.parentNode;
}
return t;
};
dojo.html.getViewport=function(){
var _336=dojo.global();
var _337=dojo.doc();
var w=0;
var h=0;
if(dojo.render.html.mozilla){
w=_337.documentElement.clientWidth;
h=_336.innerHeight;
}else{
if(!dojo.render.html.opera&&_336.innerWidth){
w=_336.innerWidth;
h=_336.innerHeight;
}else{
if(!dojo.render.html.opera&&dojo.exists(_337,"documentElement.clientWidth")){
var w2=_337.documentElement.clientWidth;
if(!w||w2&&w2<w){
w=w2;
}
h=_337.documentElement.clientHeight;
}else{
if(dojo.body().clientWidth){
w=dojo.body().clientWidth;
h=dojo.body().clientHeight;
}
}
}
}
return {width:w,height:h};
};
dojo.html.getScroll=function(){
var _33b=dojo.global();
var _33c=dojo.doc();
var top=_33b.pageYOffset||_33c.documentElement.scrollTop||dojo.body().scrollTop||0;
var left=_33b.pageXOffset||_33c.documentElement.scrollLeft||dojo.body().scrollLeft||0;
return {top:top,left:left,offset:{x:left,y:top}};
};
dojo.html.getParentByType=function(node,type){
var _341=dojo.doc();
var _342=dojo.byId(node);
type=type.toLowerCase();
while((_342)&&(_342.nodeName.toLowerCase()!=type)){
if(_342==(_341["body"]||_341["documentElement"])){
return null;
}
_342=_342.parentNode;
}
return _342;
};
dojo.html.getAttribute=function(node,attr){
node=dojo.byId(node);
if((!node)||(!node.getAttribute)){
return null;
}
var ta=typeof attr=="string"?attr:new String(attr);
var v=node.getAttribute(ta.toUpperCase());
if((v)&&(typeof v=="string")&&(v!="")){
return v;
}
if(v&&v.value){
return v.value;
}
if((node.getAttributeNode)&&(node.getAttributeNode(ta))){
return (node.getAttributeNode(ta)).value;
}else{
if(node.getAttribute(ta)){
return node.getAttribute(ta);
}else{
if(node.getAttribute(ta.toLowerCase())){
return node.getAttribute(ta.toLowerCase());
}
}
}
return null;
};
dojo.html.hasAttribute=function(node,attr){
return dojo.html.getAttribute(dojo.byId(node),attr)?true:false;
};
dojo.html.getCursorPosition=function(e){
e=e||dojo.global().event;
var _34a={x:0,y:0};
if(e.pageX||e.pageY){
_34a.x=e.pageX;
_34a.y=e.pageY;
}else{
var de=dojo.doc().documentElement;
var db=dojo.body();
_34a.x=e.clientX+((de||db)["scrollLeft"])-((de||db)["clientLeft"]);
_34a.y=e.clientY+((de||db)["scrollTop"])-((de||db)["clientTop"]);
}
return _34a;
};
dojo.html.isTag=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName.toLowerCase()==String(arguments[i]).toLowerCase()){
return String(arguments[i]).toLowerCase();
}
}
}
return "";
};
if(dojo.render.html.ie&&!dojo.render.html.ie70){
if(window.location.href.substr(0,6).toLowerCase()!="https:"){
(function(){
var _34f=dojo.doc().createElement("script");
_34f.src="javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
dojo.doc().getElementsByTagName("head")[0].appendChild(_34f);
})();
}
}else{
dojo.html.createExternalElement=function(doc,tag){
return doc.createElement(tag);
};
}
dojo.html._callDeprecated=function(_352,_353,args,_355,_356){
dojo.deprecated("dojo.html."+_352,"replaced by dojo.html."+_353+"("+(_355?"node, {"+_355+": "+_355+"}":"")+")"+(_356?"."+_356:""),"0.5");
var _357=[];
if(_355){
var _358={};
_358[_355]=args[1];
_357.push(args[0]);
_357.push(_358);
}else{
_357=args;
}
var ret=dojo.html[_353].apply(dojo.html,args);
if(_356){
return ret[_356];
}else{
return ret;
}
};
dojo.html.getViewportWidth=function(){
return dojo.html._callDeprecated("getViewportWidth","getViewport",arguments,null,"width");
};
dojo.html.getViewportHeight=function(){
return dojo.html._callDeprecated("getViewportHeight","getViewport",arguments,null,"height");
};
dojo.html.getViewportSize=function(){
return dojo.html._callDeprecated("getViewportSize","getViewport",arguments);
};
dojo.html.getScrollTop=function(){
return dojo.html._callDeprecated("getScrollTop","getScroll",arguments,null,"top");
};
dojo.html.getScrollLeft=function(){
return dojo.html._callDeprecated("getScrollLeft","getScroll",arguments,null,"left");
};
dojo.html.getScrollOffset=function(){
return dojo.html._callDeprecated("getScrollOffset","getScroll",arguments,null,"offset");
};
dojo.provide("dojo.a11y");
dojo.a11y={imgPath:dojo.uri.moduleUri("dojo.widget","templates/images"),doAccessibleCheck:true,accessible:null,checkAccessible:function(){
if(this.accessible===null){
this.accessible=false;
if(this.doAccessibleCheck==true){
this.accessible=this.testAccessible();
}
}
return this.accessible;
},testAccessible:function(){
this.accessible=false;
if(dojo.render.html.ie||dojo.render.html.mozilla){
var div=document.createElement("div");
div.style.backgroundImage="url(\""+this.imgPath+"/tab_close.gif\")";
dojo.body().appendChild(div);
var _35b=null;
if(window.getComputedStyle){
var _35c=getComputedStyle(div,"");
_35b=_35c.getPropertyValue("background-image");
}else{
_35b=div.currentStyle.backgroundImage;
}
var _35d=false;
if(_35b!=null&&(_35b=="none"||_35b=="url(invalid-url:)")){
this.accessible=true;
}
dojo.body().removeChild(div);
}
return this.accessible;
},setCheckAccessible:function(_35e){
this.doAccessibleCheck=_35e;
},setAccessibleMode:function(){
if(this.accessible===null){
if(this.checkAccessible()){
dojo.render.html.prefixes.unshift("a11y");
}
}
return this.accessible;
}};
dojo.provide("dojo.widget.Widget");
dojo.declare("dojo.widget.Widget",null,function(){
this.children=[];
this.extraArgs={};
},{parent:null,isTopLevel:false,disabled:false,isContainer:false,widgetId:"",widgetType:"Widget",ns:"dojo",getNamespacedType:function(){
return (this.ns?this.ns+":"+this.widgetType:this.widgetType).toLowerCase();
},toString:function(){
return "[Widget "+this.getNamespacedType()+", "+(this.widgetId||"NO ID")+"]";
},repr:function(){
return this.toString();
},enable:function(){
this.disabled=false;
},disable:function(){
this.disabled=true;
},onResized:function(){
this.notifyChildrenOfResize();
},notifyChildrenOfResize:function(){
for(var i=0;i<this.children.length;i++){
var _360=this.children[i];
if(_360.onResized){
_360.onResized();
}
}
},create:function(args,_362,_363,ns){
if(ns){
this.ns=ns;
}
this.satisfyPropertySets(args,_362,_363);
this.mixInProperties(args,_362,_363);
this.postMixInProperties(args,_362,_363);
dojo.widget.manager.add(this);
this.buildRendering(args,_362,_363);
this.initialize(args,_362,_363);
this.postInitialize(args,_362,_363);
this.postCreate(args,_362,_363);
return this;
},destroy:function(_365){
if(this.parent){
this.parent.removeChild(this);
}
this.destroyChildren();
this.uninitialize();
this.destroyRendering(_365);
dojo.widget.manager.removeById(this.widgetId);
},destroyChildren:function(){
var _366;
var i=0;
while(this.children.length>i){
_366=this.children[i];
if(_366 instanceof dojo.widget.Widget){
this.removeChild(_366);
_366.destroy();
continue;
}
i++;
}
},getChildrenOfType:function(type,_369){
var ret=[];
var _36b=dojo.lang.isFunction(type);
if(!_36b){
type=type.toLowerCase();
}
for(var x=0;x<this.children.length;x++){
if(_36b){
if(this.children[x] instanceof type){
ret.push(this.children[x]);
}
}else{
if(this.children[x].widgetType.toLowerCase()==type){
ret.push(this.children[x]);
}
}
if(_369){
ret=ret.concat(this.children[x].getChildrenOfType(type,_369));
}
}
return ret;
},getDescendants:function(){
var _36d=[];
var _36e=[this];
var elem;
while((elem=_36e.pop())){
_36d.push(elem);
if(elem.children){
dojo.lang.forEach(elem.children,function(elem){
_36e.push(elem);
});
}
}
return _36d;
},isFirstChild:function(){
return this===this.parent.children[0];
},isLastChild:function(){
return this===this.parent.children[this.parent.children.length-1];
},satisfyPropertySets:function(args){
return args;
},mixInProperties:function(args,frag){
if((args["fastMixIn"])||(frag["fastMixIn"])){
for(var x in args){
this[x]=args[x];
}
return;
}
var _375;
var _376=dojo.widget.lcArgsCache[this.widgetType];
if(_376==null){
_376={};
for(var y in this){
_376[((new String(y)).toLowerCase())]=y;
}
dojo.widget.lcArgsCache[this.widgetType]=_376;
}
var _378={};
for(var x in args){
if(!this[x]){
var y=_376[(new String(x)).toLowerCase()];
if(y){
args[y]=args[x];
x=y;
}
}
if(_378[x]){
continue;
}
_378[x]=true;
if((typeof this[x])!=(typeof _375)){
if(typeof args[x]!="string"){
this[x]=args[x];
}else{
if(dojo.lang.isString(this[x])){
this[x]=args[x];
}else{
if(dojo.lang.isNumber(this[x])){
this[x]=new Number(args[x]);
}else{
if(dojo.lang.isBoolean(this[x])){
this[x]=(args[x].toLowerCase()=="false")?false:true;
}else{
if(dojo.lang.isFunction(this[x])){
if(args[x].search(/[^\w\.]+/i)==-1){
this[x]=dojo.evalObjPath(args[x],false);
}else{
var tn=dojo.lang.nameAnonFunc(new Function(args[x]),this);
dojo.event.kwConnect({srcObj:this,srcFunc:x,adviceObj:this,adviceFunc:tn});
}
}else{
if(dojo.lang.isArray(this[x])){
this[x]=args[x].split(";");
}else{
if(this[x] instanceof Date){
this[x]=new Date(Number(args[x]));
}else{
if(typeof this[x]=="object"){
if(this[x] instanceof dojo.uri.Uri){
this[x]=dojo.uri.dojoUri(args[x]);
}else{
var _37a=args[x].split(";");
for(var y=0;y<_37a.length;y++){
var si=_37a[y].indexOf(":");
if((si!=-1)&&(_37a[y].length>si)){
this[x][_37a[y].substr(0,si).replace(/^\s+|\s+$/g,"")]=_37a[y].substr(si+1);
}
}
}
}else{
this[x]=args[x];
}
}
}
}
}
}
}
}
}else{
this.extraArgs[x.toLowerCase()]=args[x];
}
}
},postMixInProperties:function(args,frag,_37e){
},initialize:function(args,frag,_381){
return false;
},postInitialize:function(args,frag,_384){
return false;
},postCreate:function(args,frag,_387){
return false;
},uninitialize:function(){
return false;
},buildRendering:function(args,frag,_38a){
dojo.unimplemented("dojo.widget.Widget.buildRendering, on "+this.toString()+", ");
return false;
},destroyRendering:function(){
dojo.unimplemented("dojo.widget.Widget.destroyRendering");
return false;
},addedTo:function(_38b){
},addChild:function(_38c){
dojo.unimplemented("dojo.widget.Widget.addChild");
return false;
},removeChild:function(_38d){
for(var x=0;x<this.children.length;x++){
if(this.children[x]===_38d){
this.children.splice(x,1);
_38d.parent=null;
break;
}
}
return _38d;
},getPreviousSibling:function(){
var idx=this.getParentIndex();
if(idx<=0){
return null;
}
return this.parent.children[idx-1];
},getSiblings:function(){
return this.parent.children;
},getParentIndex:function(){
return dojo.lang.indexOf(this.parent.children,this,true);
},getNextSibling:function(){
var idx=this.getParentIndex();
if(idx==this.parent.children.length-1){
return null;
}
if(idx<0){
return null;
}
return this.parent.children[idx+1];
}});
dojo.widget.lcArgsCache={};
dojo.widget.tags={};
dojo.widget.tags.addParseTreeHandler=function(type){
dojo.deprecated("addParseTreeHandler",". ParseTreeHandlers are now reserved for components. Any unfiltered DojoML tag without a ParseTreeHandler is assumed to be a widget","0.5");
};
dojo.widget.tags["dojo:propertyset"]=function(_392,_393,_394){
var _395=_393.parseProperties(_392["dojo:propertyset"]);
};
dojo.widget.tags["dojo:connect"]=function(_396,_397,_398){
var _399=_397.parseProperties(_396["dojo:connect"]);
};
dojo.widget.buildWidgetFromParseTree=function(type,frag,_39c,_39d,_39e,_39f){
dojo.a11y.setAccessibleMode();
var _3a0=type.split(":");
_3a0=(_3a0.length==2)?_3a0[1]:type;
var _3a1=_39f||_39c.parseProperties(frag[frag["ns"]+":"+_3a0]);
var _3a2=dojo.widget.manager.getImplementation(_3a0,null,null,frag["ns"]);
if(!_3a2){
throw new Error("cannot find \""+type+"\" widget");
}else{
if(!_3a2.create){
throw new Error("\""+type+"\" widget object has no \"create\" method and does not appear to implement *Widget");
}
}
_3a1["dojoinsertionindex"]=_39e;
var ret=_3a2.create(_3a1,frag,_39d,frag["ns"]);
return ret;
};
dojo.widget.defineWidget=function(_3a4,_3a5,_3a6,init,_3a8){
if(dojo.lang.isString(arguments[3])){
dojo.widget._defineWidget(arguments[0],arguments[3],arguments[1],arguments[4],arguments[2]);
}else{
var args=[arguments[0]],p=3;
if(dojo.lang.isString(arguments[1])){
args.push(arguments[1],arguments[2]);
}else{
args.push("",arguments[1]);
p=2;
}
if(dojo.lang.isFunction(arguments[p])){
args.push(arguments[p],arguments[p+1]);
}else{
args.push(null,arguments[p]);
}
dojo.widget._defineWidget.apply(this,args);
}
};
dojo.widget.defineWidget.renderers="html|svg|vml";
dojo.widget._defineWidget=function(_3ab,_3ac,_3ad,init,_3af){
var _3b0=_3ab.split(".");
var type=_3b0.pop();
var regx="\\.("+(_3ac?_3ac+"|":"")+dojo.widget.defineWidget.renderers+")\\.";
var r=_3ab.search(new RegExp(regx));
_3b0=(r<0?_3b0.join("."):_3ab.substr(0,r));
dojo.widget.manager.registerWidgetPackage(_3b0);
var pos=_3b0.indexOf(".");
var _3b5=(pos>-1)?_3b0.substring(0,pos):_3b0;
_3af=(_3af)||{};
_3af.widgetType=type;
if((!init)&&(_3af["classConstructor"])){
init=_3af.classConstructor;
delete _3af.classConstructor;
}
dojo.declare(_3ab,_3ad,init,_3af);
};
dojo.provide("dojo.widget.Parse");
dojo.widget.Parse=function(_3b6){
this.propertySetsList=[];
this.fragment=_3b6;
this.createComponents=function(frag,_3b8){
var _3b9=[];
var _3ba=false;
try{
if(frag&&frag.tagName&&(frag!=frag.nodeRef)){
var _3bb=dojo.widget.tags;
var tna=String(frag.tagName).split(";");
for(var x=0;x<tna.length;x++){
var ltn=tna[x].replace(/^\s+|\s+$/g,"").toLowerCase();
frag.tagName=ltn;
var ret;
if(_3bb[ltn]){
_3ba=true;
ret=_3bb[ltn](frag,this,_3b8,frag.index);
_3b9.push(ret);
}else{
if(ltn.indexOf(":")==-1){
ltn="dojo:"+ltn;
}
ret=dojo.widget.buildWidgetFromParseTree(ltn,frag,this,_3b8,frag.index);
if(ret){
_3ba=true;
_3b9.push(ret);
}
}
}
}
}
catch(e){
dojo.debug("dojo.widget.Parse: error:",e);
}
if(!_3ba){
_3b9=_3b9.concat(this.createSubComponents(frag,_3b8));
}
return _3b9;
};
this.createSubComponents=function(_3c0,_3c1){
var frag,_3c3=[];
for(var item in _3c0){
frag=_3c0[item];
if(frag&&typeof frag=="object"&&(frag!=_3c0.nodeRef)&&(frag!=_3c0.tagName)&&(!dojo.dom.isNode(frag))){
_3c3=_3c3.concat(this.createComponents(frag,_3c1));
}
}
return _3c3;
};
this.parsePropertySets=function(_3c5){
return [];
};
this.parseProperties=function(_3c6){
var _3c7={};
for(var item in _3c6){
if((_3c6[item]==_3c6.tagName)||(_3c6[item]==_3c6.nodeRef)){
}else{
var frag=_3c6[item];
if(frag.tagName&&dojo.widget.tags[frag.tagName.toLowerCase()]){
}else{
if(frag[0]&&frag[0].value!=""&&frag[0].value!=null){
try{
if(item.toLowerCase()=="dataprovider"){
var _3ca=this;
this.getDataProvider(_3ca,frag[0].value);
_3c7.dataProvider=this.dataProvider;
}
_3c7[item]=frag[0].value;
var _3cb=this.parseProperties(frag);
for(var _3cc in _3cb){
_3c7[_3cc]=_3cb[_3cc];
}
}
catch(e){
dojo.debug(e);
}
}
}
switch(item.toLowerCase()){
case "checked":
case "disabled":
if(typeof _3c7[item]!="boolean"){
_3c7[item]=true;
}
break;
}
}
}
return _3c7;
};
this.getDataProvider=function(_3cd,_3ce){
dojo.io.bind({url:_3ce,load:function(type,_3d0){
if(type=="load"){
_3cd.dataProvider=_3d0;
}
},mimetype:"text/javascript",sync:true});
};
this.getPropertySetById=function(_3d1){
for(var x=0;x<this.propertySetsList.length;x++){
if(_3d1==this.propertySetsList[x]["id"][0].value){
return this.propertySetsList[x];
}
}
return "";
};
this.getPropertySetsByType=function(_3d3){
var _3d4=[];
for(var x=0;x<this.propertySetsList.length;x++){
var cpl=this.propertySetsList[x];
var cpcc=cpl.componentClass||cpl.componentType||null;
var _3d8=this.propertySetsList[x]["id"][0].value;
if(cpcc&&(_3d8==cpcc[0].value)){
_3d4.push(cpl);
}
}
return _3d4;
};
this.getPropertySets=function(_3d9){
var ppl="dojo:propertyproviderlist";
var _3db=[];
var _3dc=_3d9.tagName;
if(_3d9[ppl]){
var _3dd=_3d9[ppl].value.split(" ");
for(var _3de in _3dd){
if((_3de.indexOf("..")==-1)&&(_3de.indexOf("://")==-1)){
var _3df=this.getPropertySetById(_3de);
if(_3df!=""){
_3db.push(_3df);
}
}else{
}
}
}
return this.getPropertySetsByType(_3dc).concat(_3db);
};
this.createComponentFromScript=function(_3e0,_3e1,_3e2,ns){
_3e2.fastMixIn=true;
var ltn=(ns||"dojo")+":"+_3e1.toLowerCase();
if(dojo.widget.tags[ltn]){
return [dojo.widget.tags[ltn](_3e2,this,null,null,_3e2)];
}
return [dojo.widget.buildWidgetFromParseTree(ltn,_3e2,this,null,null,_3e2)];
};
};
dojo.widget._parser_collection={"dojo":new dojo.widget.Parse()};
dojo.widget.getParser=function(name){
if(!name){
name="dojo";
}
if(!this._parser_collection[name]){
this._parser_collection[name]=new dojo.widget.Parse();
}
return this._parser_collection[name];
};
dojo.widget.createWidget=function(name,_3e7,_3e8,_3e9){
var _3ea=false;
var _3eb=(typeof name=="string");
if(_3eb){
var pos=name.indexOf(":");
var ns=(pos>-1)?name.substring(0,pos):"dojo";
if(pos>-1){
name=name.substring(pos+1);
}
var _3ee=name.toLowerCase();
var _3ef=ns+":"+_3ee;
_3ea=(dojo.byId(name)&&!dojo.widget.tags[_3ef]);
}
if((arguments.length==1)&&(_3ea||!_3eb)){
var xp=new dojo.xml.Parse();
var tn=_3ea?dojo.byId(name):name;
return dojo.widget.getParser().createComponents(xp.parseElement(tn,null,true))[0];
}
function fromScript(_3f2,name,_3f4,ns){
_3f4[_3ef]={dojotype:[{value:_3ee}],nodeRef:_3f2,fastMixIn:true};
_3f4.ns=ns;
return dojo.widget.getParser().createComponentFromScript(_3f2,name,_3f4,ns);
}
_3e7=_3e7||{};
var _3f6=false;
var tn=null;
var h=dojo.render.html.capable;
if(h){
tn=document.createElement("span");
}
if(!_3e8){
_3f6=true;
_3e8=tn;
if(h){
dojo.body().appendChild(_3e8);
}
}else{
if(_3e9){
dojo.dom.insertAtPosition(tn,_3e8,_3e9);
}else{
tn=_3e8;
}
}
var _3f8=fromScript(tn,name.toLowerCase(),_3e7,ns);
if((!_3f8)||(!_3f8[0])||(typeof _3f8[0].widgetType=="undefined")){
throw new Error("createWidget: Creation of \""+name+"\" widget failed.");
}
try{
if(_3f6&&_3f8[0].domNode.parentNode){
_3f8[0].domNode.parentNode.removeChild(_3f8[0].domNode);
}
}
catch(e){
dojo.debug(e);
}
return _3f8[0];
};
dojo.provide("dojo.html.style");
dojo.html.getClass=function(node){
node=dojo.byId(node);
if(!node){
return "";
}
var cs="";
if(node.className){
cs=node.className;
}else{
if(dojo.html.hasAttribute(node,"class")){
cs=dojo.html.getAttribute(node,"class");
}
}
return cs.replace(/^\s+|\s+$/g,"");
};
dojo.html.getClasses=function(node){
var c=dojo.html.getClass(node);
return (c=="")?[]:c.split(/\s+/g);
};
dojo.html.hasClass=function(node,_3fe){
return (new RegExp("(^|\\s+)"+_3fe+"(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass=function(node,_400){
_400+=" "+dojo.html.getClass(node);
return dojo.html.setClass(node,_400);
};
dojo.html.addClass=function(node,_402){
if(dojo.html.hasClass(node,_402)){
return false;
}
_402=(dojo.html.getClass(node)+" "+_402).replace(/^\s+|\s+$/g,"");
return dojo.html.setClass(node,_402);
};
dojo.html.setClass=function(node,_404){
node=dojo.byId(node);
var cs=new String(_404);
try{
if(typeof node.className=="string"){
node.className=cs;
}else{
if(node.setAttribute){
node.setAttribute("class",_404);
node.className=cs;
}else{
return false;
}
}
}
catch(e){
dojo.debug("dojo.html.setClass() failed",e);
}
return true;
};
dojo.html.removeClass=function(node,_407,_408){
try{
if(!_408){
var _409=dojo.html.getClass(node).replace(new RegExp("(^|\\s+)"+_407+"(\\s+|$)"),"$1$2");
}else{
var _409=dojo.html.getClass(node).replace(_407,"");
}
dojo.html.setClass(node,_409);
}
catch(e){
dojo.debug("dojo.html.removeClass() failed",e);
}
return true;
};
dojo.html.replaceClass=function(node,_40b,_40c){
dojo.html.removeClass(node,_40c);
dojo.html.addClass(node,_40b);
};
dojo.html.classMatchType={ContainsAll:0,ContainsAny:1,IsOnly:2};
dojo.html.getElementsByClass=function(_40d,_40e,_40f,_410,_411){
_411=false;
var _412=dojo.doc();
_40e=dojo.byId(_40e)||_412;
var _413=_40d.split(/\s+/g);
var _414=[];
if(_410!=1&&_410!=2){
_410=0;
}
var _415=new RegExp("(\\s|^)(("+_413.join(")|(")+"))(\\s|$)");
var _416=_413.join(" ").length;
var _417=[];
if(!_411&&_412.evaluate){
var _418=".//"+(_40f||"*")+"[contains(";
if(_410!=dojo.html.classMatchType.ContainsAny){
_418+="concat(' ',@class,' '), ' "+_413.join(" ') and contains(concat(' ',@class,' '), ' ")+" ')";
if(_410==2){
_418+=" and string-length(@class)="+_416+"]";
}else{
_418+="]";
}
}else{
_418+="concat(' ',@class,' '), ' "+_413.join(" ') or contains(concat(' ',@class,' '), ' ")+" ')]";
}
var _419=_412.evaluate(_418,_40e,null,XPathResult.ANY_TYPE,null);
var _41a=_419.iterateNext();
while(_41a){
try{
_417.push(_41a);
_41a=_419.iterateNext();
}
catch(e){
break;
}
}
return _417;
}else{
if(!_40f){
_40f="*";
}
_417=_40e.getElementsByTagName(_40f);
var node,i=0;
outer:
while(node=_417[i++]){
var _41d=dojo.html.getClasses(node);
if(_41d.length==0){
continue outer;
}
var _41e=0;
for(var j=0;j<_41d.length;j++){
if(_415.test(_41d[j])){
if(_410==dojo.html.classMatchType.ContainsAny){
_414.push(node);
continue outer;
}else{
_41e++;
}
}else{
if(_410==dojo.html.classMatchType.IsOnly){
continue outer;
}
}
}
if(_41e==_413.length){
if((_410==dojo.html.classMatchType.IsOnly)&&(_41e==_41d.length)){
_414.push(node);
}else{
if(_410==dojo.html.classMatchType.ContainsAll){
_414.push(node);
}
}
}
}
return _414;
}
};
dojo.html.getElementsByClassName=dojo.html.getElementsByClass;
dojo.html.toCamelCase=function(_420){
var arr=_420.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.html.toSelectorCase=function(_424){
return _424.replace(/([A-Z])/g,"-$1").toLowerCase();
};
if(dojo.render.html.ie){
dojo.html.getComputedStyle=function(node,_426,_427){
node=dojo.byId(node);
if(!node||!node.style){
return _427;
}
return node.currentStyle[dojo.html.toCamelCase(_426)];
};
dojo.html.getComputedStyles=function(node){
return node.currentStyle;
};
}else{
dojo.html.getComputedStyle=function(node,_42a,_42b){
node=dojo.byId(node);
if(!node||!node.style){
return _42b;
}
var s=document.defaultView.getComputedStyle(node,null);
return (s&&s[dojo.html.toCamelCase(_42a)])||"";
};
dojo.html.getComputedStyles=function(node){
return document.defaultView.getComputedStyle(node,null);
};
}
dojo.html.getStyleProperty=function(node,_42f){
node=dojo.byId(node);
return (node&&node.style?node.style[dojo.html.toCamelCase(_42f)]:undefined);
};
dojo.html.getStyle=function(node,_431){
var _432=dojo.html.getStyleProperty(node,_431);
return (_432?_432:dojo.html.getComputedStyle(node,_431));
};
dojo.html.setStyle=function(node,_434,_435){
node=dojo.byId(node);
if(node&&node.style){
var _436=dojo.html.toCamelCase(_434);
node.style[_436]=_435;
}
};
dojo.html.setStyleText=function(_437,text){
try{
_437.style.cssText=text;
}
catch(e){
_437.setAttribute("style",text);
}
};
dojo.html.copyStyle=function(_439,_43a){
if(!_43a.style.cssText){
_439.setAttribute("style",_43a.getAttribute("style"));
}else{
_439.style.cssText=_43a.style.cssText;
}
dojo.html.addClass(_439,dojo.html.getClass(_43a));
};
dojo.html.getUnitValue=function(node,_43c,_43d){
var s=dojo.html.getComputedStyle(node,_43c);
if((!s)||((s=="auto")&&(_43d))){
return {value:0,units:"px"};
}
var _43f=s.match(/(\-?[\d.]+)([a-z%]*)/i);
if(!_43f){
return dojo.html.getUnitValue.bad;
}
return {value:Number(_43f[1]),units:_43f[2].toLowerCase()};
};
dojo.html.getUnitValue.bad={value:NaN,units:""};
if(dojo.render.html.ie){
dojo.html.toPixelValue=function(_440,_441){
if(!_441){
return 0;
}
if(_441.slice(-2)=="px"){
return parseFloat(_441);
}
var _442=0;
with(_440){
var _443=style.left;
var _444=runtimeStyle.left;
runtimeStyle.left=currentStyle.left;
try{
style.left=_441||0;
_442=style.pixelLeft;
style.left=_443;
runtimeStyle.left=_444;
}
catch(e){
}
}
return _442;
};
}else{
dojo.html.toPixelValue=function(_445,_446){
return (_446&&(_446.slice(-2)=="px")?parseFloat(_446):0);
};
}
dojo.html.getPixelValue=function(node,_448,_449){
return dojo.html.toPixelValue(node,dojo.html.getComputedStyle(node,_448));
};
dojo.html.setPositivePixelValue=function(node,_44b,_44c){
if(isNaN(_44c)){
return false;
}
node.style[_44b]=Math.max(0,_44c)+"px";
return true;
};
dojo.html.styleSheet=null;
dojo.html.insertCssRule=function(_44d,_44e,_44f){
if(!dojo.html.styleSheet){
if(document.createStyleSheet){
dojo.html.styleSheet=document.createStyleSheet();
}else{
if(document.styleSheets[0]){
dojo.html.styleSheet=document.styleSheets[0];
}else{
return null;
}
}
}
if(arguments.length<3){
if(dojo.html.styleSheet.cssRules){
_44f=dojo.html.styleSheet.cssRules.length;
}else{
if(dojo.html.styleSheet.rules){
_44f=dojo.html.styleSheet.rules.length;
}else{
return null;
}
}
}
if(dojo.html.styleSheet.insertRule){
var rule=_44d+" { "+_44e+" }";
return dojo.html.styleSheet.insertRule(rule,_44f);
}else{
if(dojo.html.styleSheet.addRule){
return dojo.html.styleSheet.addRule(_44d,_44e,_44f);
}else{
return null;
}
}
};
dojo.html.removeCssRule=function(_451){
if(!dojo.html.styleSheet){
dojo.debug("no stylesheet defined for removing rules");
return false;
}
if(dojo.render.html.ie){
if(!_451){
_451=dojo.html.styleSheet.rules.length;
dojo.html.styleSheet.removeRule(_451);
}
}else{
if(document.styleSheets[0]){
if(!_451){
_451=dojo.html.styleSheet.cssRules.length;
}
dojo.html.styleSheet.deleteRule(_451);
}
}
return true;
};
dojo.html._insertedCssFiles=[];
dojo.html.insertCssFile=function(URI,doc,_454,_455){
if(!URI){
return;
}
if(!doc){
doc=document;
}
var _456=dojo.hostenv.getText(URI,false,_455);
if(_456===null){
return;
}
_456=dojo.html.fixPathsInCssText(_456,URI);
if(_454){
var idx=-1,node,ent=dojo.html._insertedCssFiles;
for(var i=0;i<ent.length;i++){
if((ent[i].doc==doc)&&(ent[i].cssText==_456)){
idx=i;
node=ent[i].nodeRef;
break;
}
}
if(node){
var _45b=doc.getElementsByTagName("style");
for(var i=0;i<_45b.length;i++){
if(_45b[i]==node){
return;
}
}
dojo.html._insertedCssFiles.shift(idx,1);
}
}
var _45c=dojo.html.insertCssText(_456,doc);
dojo.html._insertedCssFiles.push({"doc":doc,"cssText":_456,"nodeRef":_45c});
if(_45c&&djConfig.isDebug){
_45c.setAttribute("dbgHref",URI);
}
return _45c;
};
dojo.html.insertCssText=function(_45d,doc,URI){
if(!_45d){
return;
}
if(!doc){
doc=document;
}
if(URI){
_45d=dojo.html.fixPathsInCssText(_45d,URI);
}
var _460=doc.createElement("style");
_460.setAttribute("type","text/css");
var head=doc.getElementsByTagName("head")[0];
if(!head){
dojo.debug("No head tag in document, aborting styles");
return;
}else{
head.appendChild(_460);
}
if(_460.styleSheet){
var _462=function(){
try{
_460.styleSheet.cssText=_45d;
}
catch(e){
dojo.debug(e);
}
};
if(_460.styleSheet.disabled){
setTimeout(_462,10);
}else{
_462();
}
}else{
var _463=doc.createTextNode(_45d);
_460.appendChild(_463);
}
return _460;
};
dojo.html.fixPathsInCssText=function(_464,URI){
if(!_464||!URI){
return;
}
var _466,str="",url="",_469="[\\t\\s\\w\\(\\)\\/\\.\\\\'\"-:#=&?~]+";
var _46a=new RegExp("url\\(\\s*("+_469+")\\s*\\)");
var _46b=/(file|https?|ftps?):\/\//;
regexTrim=new RegExp("^[\\s]*(['\"]?)("+_469+")\\1[\\s]*?$");
if(dojo.render.html.ie55||dojo.render.html.ie60){
var _46c=new RegExp("AlphaImageLoader\\((.*)src=['\"]("+_469+")['\"]");
while(_466=_46c.exec(_464)){
url=_466[2].replace(regexTrim,"$2");
if(!_46b.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_464.substring(0,_466.index)+"AlphaImageLoader("+_466[1]+"src='"+url+"'";
_464=_464.substr(_466.index+_466[0].length);
}
_464=str+_464;
str="";
}
while(_466=_46a.exec(_464)){
url=_466[1].replace(regexTrim,"$2");
if(!_46b.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_464.substring(0,_466.index)+"url("+url+")";
_464=_464.substr(_466.index+_466[0].length);
}
return str+_464;
};
dojo.html.setActiveStyleSheet=function(_46d){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")){
a.disabled=true;
if(a.getAttribute("title")==_46d){
a.disabled=false;
}
}
}
};
dojo.html.getActiveStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")&&!a.disabled){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.getPreferredStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("rel").indexOf("alt")==-1&&a.getAttribute("title")){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.applyBrowserClass=function(node){
var drh=dojo.render.html;
var _479={dj_ie:drh.ie,dj_ie55:drh.ie55,dj_ie6:drh.ie60,dj_ie7:drh.ie70,dj_iequirks:drh.ie&&drh.quirks,dj_opera:drh.opera,dj_opera8:drh.opera&&(Math.floor(dojo.render.version)==8),dj_opera9:drh.opera&&(Math.floor(dojo.render.version)==9),dj_khtml:drh.khtml,dj_safari:drh.safari,dj_gecko:drh.mozilla};
for(var p in _479){
if(_479[p]){
dojo.html.addClass(node,p);
}
}
};
dojo.provide("dojo.widget.DomWidget");
dojo.widget._cssFiles={};
dojo.widget._cssStrings={};
dojo.widget._templateCache={};
dojo.widget.defaultStrings={dojoRoot:dojo.hostenv.getBaseScriptUri(),dojoWidgetModuleUri:dojo.uri.moduleUri("dojo.widget"),baseScriptUri:dojo.hostenv.getBaseScriptUri()};
dojo.widget.fillFromTemplateCache=function(obj,_47c,_47d,_47e){
var _47f=_47c||obj.templatePath;
var _480=dojo.widget._templateCache;
if(!_47f&&!obj["widgetType"]){
do{
var _481="__dummyTemplate__"+dojo.widget._templateCache.dummyCount++;
}while(_480[_481]);
obj.widgetType=_481;
}
var wt=_47f?_47f.toString():obj.widgetType;
var ts=_480[wt];
if(!ts){
_480[wt]={"string":null,"node":null};
if(_47e){
ts={};
}else{
ts=_480[wt];
}
}
if((!obj.templateString)&&(!_47e)){
obj.templateString=_47d||ts["string"];
}
if(obj.templateString){
obj.templateString=this._sanitizeTemplateString(obj.templateString);
}
if((!obj.templateNode)&&(!_47e)){
obj.templateNode=ts["node"];
}
if((!obj.templateNode)&&(!obj.templateString)&&(_47f)){
var _484=this._sanitizeTemplateString(dojo.hostenv.getText(_47f));
obj.templateString=_484;
if(!_47e){
_480[wt]["string"]=_484;
}
}
if((!ts["string"])&&(!_47e)){
ts.string=obj.templateString;
}
};
dojo.widget._sanitizeTemplateString=function(_485){
if(_485){
_485=_485.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");
var _486=_485.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_486){
_485=_486[1];
}
}else{
_485="";
}
return _485;
};
dojo.widget._templateCache.dummyCount=0;
dojo.widget.attachProperties=["dojoAttachPoint","id"];
dojo.widget.eventAttachProperty="dojoAttachEvent";
dojo.widget.onBuildProperty="dojoOnBuild";
dojo.widget.waiNames=["waiRole","waiState"];
dojo.widget.wai={waiRole:{name:"waiRole","namespace":"http://www.w3.org/TR/xhtml2",alias:"x2",prefix:"wairole:"},waiState:{name:"waiState","namespace":"http://www.w3.org/2005/07/aaa",alias:"aaa",prefix:""},setAttr:function(node,ns,attr,_48a){
if(dojo.render.html.ie){
node.setAttribute(this[ns].alias+":"+attr,this[ns].prefix+_48a);
}else{
node.setAttributeNS(this[ns]["namespace"],attr,this[ns].prefix+_48a);
}
},getAttr:function(node,ns,attr){
if(dojo.render.html.ie){
return node.getAttribute(this[ns].alias+":"+attr);
}else{
return node.getAttributeNS(this[ns]["namespace"],attr);
}
},removeAttr:function(node,ns,attr){
var _491=true;
if(dojo.render.html.ie){
_491=node.removeAttribute(this[ns].alias+":"+attr);
}else{
node.removeAttributeNS(this[ns]["namespace"],attr);
}
return _491;
}};
dojo.widget.attachTemplateNodes=function(_492,_493,_494){
var _495=dojo.dom.ELEMENT_NODE;
function trim(str){
return str.replace(/^\s+|\s+$/g,"");
}
if(!_492){
_492=_493.domNode;
}
if(_492.nodeType!=_495){
return;
}
var _497=_492.all||_492.getElementsByTagName("*");
var _498=_493;
for(var x=-1;x<_497.length;x++){
var _49a=(x==-1)?_492:_497[x];
var _49b=[];
if(!_493.widgetsInTemplate||!_49a.getAttribute("dojoType")){
for(var y=0;y<this.attachProperties.length;y++){
var _49d=_49a.getAttribute(this.attachProperties[y]);
if(_49d){
_49b=_49d.split(";");
for(var z=0;z<_49b.length;z++){
if(dojo.lang.isArray(_493[_49b[z]])){
_493[_49b[z]].push(_49a);
}else{
_493[_49b[z]]=_49a;
}
}
break;
}
}
var _49f=_49a.getAttribute(this.eventAttachProperty);
if(_49f){
var evts=_49f.split(";");
for(var y=0;y<evts.length;y++){
if((!evts[y])||(!evts[y].length)){
continue;
}
var _4a1=null;
var tevt=trim(evts[y]);
if(evts[y].indexOf(":")>=0){
var _4a3=tevt.split(":");
tevt=trim(_4a3[0]);
_4a1=trim(_4a3[1]);
}
if(!_4a1){
_4a1=tevt;
}
var tf=function(){
var ntf=new String(_4a1);
return function(evt){
if(_498[ntf]){
_498[ntf](dojo.event.browser.fixEvent(evt,this));
}
};
}();
dojo.event.browser.addListener(_49a,tevt,tf,false,true);
}
}
for(var y=0;y<_494.length;y++){
var _4a7=_49a.getAttribute(_494[y]);
if((_4a7)&&(_4a7.length)){
var _4a1=null;
var _4a8=_494[y].substr(4);
_4a1=trim(_4a7);
var _4a9=[_4a1];
if(_4a1.indexOf(";")>=0){
_4a9=dojo.lang.map(_4a1.split(";"),trim);
}
for(var z=0;z<_4a9.length;z++){
if(!_4a9[z].length){
continue;
}
var tf=function(){
var ntf=new String(_4a9[z]);
return function(evt){
if(_498[ntf]){
_498[ntf](dojo.event.browser.fixEvent(evt,this));
}
};
}();
dojo.event.browser.addListener(_49a,_4a8,tf,false,true);
}
}
}
}
var _4ac=_49a.getAttribute(this.templateProperty);
if(_4ac){
_493[_4ac]=_49a;
}
dojo.lang.forEach(dojo.widget.waiNames,function(name){
var wai=dojo.widget.wai[name];
var val=_49a.getAttribute(wai.name);
if(val){
if(val.indexOf("-")==-1){
dojo.widget.wai.setAttr(_49a,wai.name,"role",val);
}else{
var _4b0=val.split("-");
dojo.widget.wai.setAttr(_49a,wai.name,_4b0[0],_4b0[1]);
}
}
},this);
var _4b1=_49a.getAttribute(this.onBuildProperty);
if(_4b1){
eval("var node = baseNode; var widget = targetObj; "+_4b1);
}
}
};
dojo.widget.getDojoEventsFromStr=function(str){
var re=/(dojoOn([a-z]+)(\s?))=/gi;
var evts=str?str.match(re)||[]:[];
var ret=[];
var lem={};
for(var x=0;x<evts.length;x++){
if(evts[x].length<1){
continue;
}
var cm=evts[x].replace(/\s/,"");
cm=(cm.slice(0,cm.length-1));
if(!lem[cm]){
lem[cm]=true;
ret.push(cm);
}
}
return ret;
};
dojo.declare("dojo.widget.DomWidget",dojo.widget.Widget,function(){
if((arguments.length>0)&&(typeof arguments[0]=="object")){
this.create(arguments[0]);
}
},{templateNode:null,templateString:null,templateCssString:null,preventClobber:false,domNode:null,containerNode:null,widgetsInTemplate:false,addChild:function(_4b9,_4ba,pos,ref,_4bd){
if(!this.isContainer){
dojo.debug("dojo.widget.DomWidget.addChild() attempted on non-container widget");
return null;
}else{
if(_4bd==undefined){
_4bd=this.children.length;
}
this.addWidgetAsDirectChild(_4b9,_4ba,pos,ref,_4bd);
this.registerChild(_4b9,_4bd);
}
return _4b9;
},addWidgetAsDirectChild:function(_4be,_4bf,pos,ref,_4c2){
if((!this.containerNode)&&(!_4bf)){
this.containerNode=this.domNode;
}
var cn=(_4bf)?_4bf:this.containerNode;
if(!pos){
pos="after";
}
if(!ref){
if(!cn){
cn=dojo.body();
}
ref=cn.lastChild;
}
if(!_4c2){
_4c2=0;
}
_4be.domNode.setAttribute("dojoinsertionindex",_4c2);
if(!ref){
cn.appendChild(_4be.domNode);
}else{
if(pos=="insertAtIndex"){
dojo.dom.insertAtIndex(_4be.domNode,ref.parentNode,_4c2);
}else{
if((pos=="after")&&(ref===cn.lastChild)){
cn.appendChild(_4be.domNode);
}else{
dojo.dom.insertAtPosition(_4be.domNode,cn,pos);
}
}
}
},registerChild:function(_4c4,_4c5){
_4c4.dojoInsertionIndex=_4c5;
var idx=-1;
for(var i=0;i<this.children.length;i++){
if(this.children[i].dojoInsertionIndex<=_4c5){
idx=i;
}
}
this.children.splice(idx+1,0,_4c4);
_4c4.parent=this;
_4c4.addedTo(this,idx+1);
delete dojo.widget.manager.topWidgets[_4c4.widgetId];
},removeChild:function(_4c8){
dojo.dom.removeNode(_4c8.domNode);
return dojo.widget.DomWidget.superclass.removeChild.call(this,_4c8);
},getFragNodeRef:function(frag){
if(!frag){
return null;
}
if(!frag[this.getNamespacedType()]){
dojo.raise("Error: no frag for widget type "+this.getNamespacedType()+", id "+this.widgetId+" (maybe a widget has set it's type incorrectly)");
}
return frag[this.getNamespacedType()]["nodeRef"];
},postInitialize:function(args,frag,_4cc){
var _4cd=this.getFragNodeRef(frag);
if(_4cc&&(_4cc.snarfChildDomOutput||!_4cd)){
_4cc.addWidgetAsDirectChild(this,"","insertAtIndex","",args["dojoinsertionindex"],_4cd);
}else{
if(_4cd){
if(this.domNode&&(this.domNode!==_4cd)){
this._sourceNodeRef=dojo.dom.replaceNode(_4cd,this.domNode);
}
}
}
if(_4cc){
_4cc.registerChild(this,args.dojoinsertionindex);
}else{
dojo.widget.manager.topWidgets[this.widgetId]=this;
}
if(this.widgetsInTemplate){
var _4ce=new dojo.xml.Parse();
var _4cf;
var _4d0=this.domNode.getElementsByTagName("*");
for(var i=0;i<_4d0.length;i++){
if(_4d0[i].getAttribute("dojoAttachPoint")=="subContainerWidget"){
_4cf=_4d0[i];
}
if(_4d0[i].getAttribute("dojoType")){
_4d0[i].setAttribute("isSubWidget",true);
}
}
if(this.isContainer&&!this.containerNode){
if(_4cf){
var src=this.getFragNodeRef(frag);
if(src){
dojo.dom.moveChildren(src,_4cf);
frag["dojoDontFollow"]=true;
}
}else{
dojo.debug("No subContainerWidget node can be found in template file for widget "+this);
}
}
var _4d3=_4ce.parseElement(this.domNode,null,true);
dojo.widget.getParser().createSubComponents(_4d3,this);
var _4d4=[];
var _4d5=[this];
var w;
while((w=_4d5.pop())){
for(var i=0;i<w.children.length;i++){
var _4d7=w.children[i];
if(_4d7._processedSubWidgets||!_4d7.extraArgs["issubwidget"]){
continue;
}
_4d4.push(_4d7);
if(_4d7.isContainer){
_4d5.push(_4d7);
}
}
}
for(var i=0;i<_4d4.length;i++){
var _4d8=_4d4[i];
if(_4d8._processedSubWidgets){
dojo.debug("This should not happen: widget._processedSubWidgets is already true!");
return;
}
_4d8._processedSubWidgets=true;
if(_4d8.extraArgs["dojoattachevent"]){
var evts=_4d8.extraArgs["dojoattachevent"].split(";");
for(var j=0;j<evts.length;j++){
var _4db=null;
var tevt=dojo.string.trim(evts[j]);
if(tevt.indexOf(":")>=0){
var _4dd=tevt.split(":");
tevt=dojo.string.trim(_4dd[0]);
_4db=dojo.string.trim(_4dd[1]);
}
if(!_4db){
_4db=tevt;
}
if(dojo.lang.isFunction(_4d8[tevt])){
dojo.event.kwConnect({srcObj:_4d8,srcFunc:tevt,targetObj:this,targetFunc:_4db});
}else{
alert(tevt+" is not a function in widget "+_4d8);
}
}
}
if(_4d8.extraArgs["dojoattachpoint"]){
this[_4d8.extraArgs["dojoattachpoint"]]=_4d8;
}
}
}
if(this.isContainer&&!frag["dojoDontFollow"]){
dojo.widget.getParser().createSubComponents(frag,this);
}
},buildRendering:function(args,frag){
var ts=dojo.widget._templateCache[this.widgetType];
if(args["templatecsspath"]){
args["templateCssPath"]=args["templatecsspath"];
}
var _4e1=args["templateCssPath"]||this.templateCssPath;
if(_4e1&&!dojo.widget._cssFiles[_4e1.toString()]){
if((!this.templateCssString)&&(_4e1)){
this.templateCssString=dojo.hostenv.getText(_4e1);
this.templateCssPath=null;
}
dojo.widget._cssFiles[_4e1.toString()]=true;
}
if((this["templateCssString"])&&(!dojo.widget._cssStrings[this.templateCssString])){
dojo.html.insertCssText(this.templateCssString,null,_4e1);
dojo.widget._cssStrings[this.templateCssString]=true;
}
if((!this.preventClobber)&&((this.templatePath)||(this.templateNode)||((this["templateString"])&&(this.templateString.length))||((typeof ts!="undefined")&&((ts["string"])||(ts["node"]))))){
this.buildFromTemplate(args,frag);
}else{
this.domNode=this.getFragNodeRef(frag);
}
this.fillInTemplate(args,frag);
},buildFromTemplate:function(args,frag){
var _4e4=false;
if(args["templatepath"]){
args["templatePath"]=args["templatepath"];
}
dojo.widget.fillFromTemplateCache(this,args["templatePath"],null,_4e4);
var ts=dojo.widget._templateCache[this.templatePath?this.templatePath.toString():this.widgetType];
if((ts)&&(!_4e4)){
if(!this.templateString.length){
this.templateString=ts["string"];
}
if(!this.templateNode){
this.templateNode=ts["node"];
}
}
var _4e6=false;
var node=null;
var tstr=this.templateString;
if((!this.templateNode)&&(this.templateString)){
_4e6=this.templateString.match(/\$\{([^\}]+)\}/g);
if(_4e6){
var hash=this.strings||{};
for(var key in dojo.widget.defaultStrings){
if(dojo.lang.isUndefined(hash[key])){
hash[key]=dojo.widget.defaultStrings[key];
}
}
for(var i=0;i<_4e6.length;i++){
var key=_4e6[i];
key=key.substring(2,key.length-1);
var kval=(key.substring(0,5)=="this.")?dojo.lang.getObjPathValue(key.substring(5),this):hash[key];
var _4ed;
if((kval)||(dojo.lang.isString(kval))){
_4ed=new String((dojo.lang.isFunction(kval))?kval.call(this,key,this.templateString):kval);
while(_4ed.indexOf("\"")>-1){
_4ed=_4ed.replace("\"","&quot;");
}
tstr=tstr.replace(_4e6[i],_4ed);
}
}
}else{
this.templateNode=this.createNodesFromText(this.templateString,true)[0];
if(!_4e4){
ts.node=this.templateNode;
}
}
}
if((!this.templateNode)&&(!_4e6)){
dojo.debug("DomWidget.buildFromTemplate: could not create template");
return false;
}else{
if(!_4e6){
node=this.templateNode.cloneNode(true);
if(!node){
return false;
}
}else{
node=this.createNodesFromText(tstr,true)[0];
}
}
this.domNode=node;
this.attachTemplateNodes();
if(this.isContainer&&this.containerNode){
var src=this.getFragNodeRef(frag);
if(src){
dojo.dom.moveChildren(src,this.containerNode);
}
}
},attachTemplateNodes:function(_4ef,_4f0){
if(!_4ef){
_4ef=this.domNode;
}
if(!_4f0){
_4f0=this;
}
return dojo.widget.attachTemplateNodes(_4ef,_4f0,dojo.widget.getDojoEventsFromStr(this.templateString));
},fillInTemplate:function(){
},destroyRendering:function(){
try{
dojo.dom.destroyNode(this.domNode);
delete this.domNode;
}
catch(e){
}
if(this._sourceNodeRef){
try{
dojo.dom.destroyNode(this._sourceNodeRef);
}
catch(e){
}
}
},createNodesFromText:function(){
dojo.unimplemented("dojo.widget.DomWidget.createNodesFromText");
}});
dojo.provide("dojo.html.display");
dojo.html._toggle=function(node,_4f2,_4f3){
node=dojo.byId(node);
_4f3(node,!_4f2(node));
return _4f2(node);
};
dojo.html.show=function(node){
node=dojo.byId(node);
if(dojo.html.getStyleProperty(node,"display")=="none"){
dojo.html.setStyle(node,"display",(node.dojoDisplayCache||""));
node.dojoDisplayCache=undefined;
}
};
dojo.html.hide=function(node){
node=dojo.byId(node);
if(typeof node["dojoDisplayCache"]=="undefined"){
var d=dojo.html.getStyleProperty(node,"display");
if(d!="none"){
node.dojoDisplayCache=d;
}
}
dojo.html.setStyle(node,"display","none");
};
dojo.html.setShowing=function(node,_4f8){
dojo.html[(_4f8?"show":"hide")](node);
};
dojo.html.isShowing=function(node){
return (dojo.html.getStyleProperty(node,"display")!="none");
};
dojo.html.toggleShowing=function(node){
return dojo.html._toggle(node,dojo.html.isShowing,dojo.html.setShowing);
};
dojo.html.displayMap={tr:"",td:"",th:"",img:"inline",span:"inline",input:"inline",button:"inline"};
dojo.html.suggestDisplayByTagName=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
var tag=node.tagName.toLowerCase();
return (tag in dojo.html.displayMap?dojo.html.displayMap[tag]:"block");
}
};
dojo.html.setDisplay=function(node,_4fe){
dojo.html.setStyle(node,"display",((_4fe instanceof String||typeof _4fe=="string")?_4fe:(_4fe?dojo.html.suggestDisplayByTagName(node):"none")));
};
dojo.html.isDisplayed=function(node){
return (dojo.html.getComputedStyle(node,"display")!="none");
};
dojo.html.toggleDisplay=function(node){
return dojo.html._toggle(node,dojo.html.isDisplayed,dojo.html.setDisplay);
};
dojo.html.setVisibility=function(node,_502){
dojo.html.setStyle(node,"visibility",((_502 instanceof String||typeof _502=="string")?_502:(_502?"visible":"hidden")));
};
dojo.html.isVisible=function(node){
return (dojo.html.getComputedStyle(node,"visibility")!="hidden");
};
dojo.html.toggleVisibility=function(node){
return dojo.html._toggle(node,dojo.html.isVisible,dojo.html.setVisibility);
};
dojo.html.setOpacity=function(node,_506,_507){
node=dojo.byId(node);
var h=dojo.render.html;
if(!_507){
if(_506>=1){
if(h.ie){
dojo.html.clearOpacity(node);
return;
}else{
_506=0.999999;
}
}else{
if(_506<0){
_506=0;
}
}
}
if(h.ie){
if(node.nodeName.toLowerCase()=="tr"){
var tds=node.getElementsByTagName("td");
for(var x=0;x<tds.length;x++){
tds[x].style.filter="Alpha(Opacity="+_506*100+")";
}
}
node.style.filter="Alpha(Opacity="+_506*100+")";
}else{
if(h.moz){
node.style.opacity=_506;
node.style.MozOpacity=_506;
}else{
if(h.safari){
node.style.opacity=_506;
node.style.KhtmlOpacity=_506;
}else{
node.style.opacity=_506;
}
}
}
};
dojo.html.clearOpacity=function(node){
node=dojo.byId(node);
var ns=node.style;
var h=dojo.render.html;
if(h.ie){
try{
if(node.filters&&node.filters.alpha){
ns.filter="";
}
}
catch(e){
}
}else{
if(h.moz){
ns.opacity=1;
ns.MozOpacity=1;
}else{
if(h.safari){
ns.opacity=1;
ns.KhtmlOpacity=1;
}else{
ns.opacity=1;
}
}
}
};
dojo.html.getOpacity=function(node){
node=dojo.byId(node);
var h=dojo.render.html;
if(h.ie){
var opac=(node.filters&&node.filters.alpha&&typeof node.filters.alpha.opacity=="number"?node.filters.alpha.opacity:100)/100;
}else{
var opac=node.style.opacity||node.style.MozOpacity||node.style.KhtmlOpacity||1;
}
return opac>=0.999999?1:Number(opac);
};
dojo.provide("dojo.html.layout");
dojo.html.sumAncestorProperties=function(node,prop){
node=dojo.byId(node);
if(!node){
return 0;
}
var _513=0;
while(node){
if(dojo.html.getComputedStyle(node,"position")=="fixed"){
return 0;
}
var val=node[prop];
if(val){
_513+=val-0;
if(node==dojo.body()){
break;
}
}
node=node.parentNode;
}
return _513;
};
dojo.html.setStyleAttributes=function(node,_516){
node=dojo.byId(node);
var _517=_516.replace(/(;)?\s*$/,"").split(";");
for(var i=0;i<_517.length;i++){
var _519=_517[i].split(":");
var name=_519[0].replace(/\s*$/,"").replace(/^\s*/,"").toLowerCase();
var _51b=_519[1].replace(/\s*$/,"").replace(/^\s*/,"");
switch(name){
case "opacity":
dojo.html.setOpacity(node,_51b);
break;
case "content-height":
dojo.html.setContentBox(node,{height:_51b});
break;
case "content-width":
dojo.html.setContentBox(node,{width:_51b});
break;
case "outer-height":
dojo.html.setMarginBox(node,{height:_51b});
break;
case "outer-width":
dojo.html.setMarginBox(node,{width:_51b});
break;
default:
node.style[dojo.html.toCamelCase(name)]=_51b;
}
}
};
dojo.html.boxSizing={MARGIN_BOX:"margin-box",BORDER_BOX:"border-box",PADDING_BOX:"padding-box",CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition=dojo.html.abs=function(node,_51d,_51e){
node=dojo.byId(node,node.ownerDocument);
var ret={x:0,y:0};
var bs=dojo.html.boxSizing;
if(!_51e){
_51e=bs.CONTENT_BOX;
}
var _521=2;
var _522;
switch(_51e){
case bs.MARGIN_BOX:
_522=3;
break;
case bs.BORDER_BOX:
_522=2;
break;
case bs.PADDING_BOX:
default:
_522=1;
break;
case bs.CONTENT_BOX:
_522=0;
break;
}
var h=dojo.render.html;
var db=document["body"]||document["documentElement"];
if(h.ie){
with(node.getBoundingClientRect()){
ret.x=left-2;
ret.y=top-2;
}
}else{
if(document.getBoxObjectFor){
_521=1;
try{
var bo=document.getBoxObjectFor(node);
ret.x=bo.x-dojo.html.sumAncestorProperties(node,"scrollLeft");
ret.y=bo.y-dojo.html.sumAncestorProperties(node,"scrollTop");
}
catch(e){
}
}else{
if(node["offsetParent"]){
var _526;
if((h.safari)&&(node.style.getPropertyValue("position")=="absolute")&&(node.parentNode==db)){
_526=db;
}else{
_526=db.parentNode;
}
if(node.parentNode!=db){
var nd=node;
if(dojo.render.html.opera){
nd=db;
}
ret.x-=dojo.html.sumAncestorProperties(nd,"scrollLeft");
ret.y-=dojo.html.sumAncestorProperties(nd,"scrollTop");
}
var _528=node;
do{
var n=_528["offsetLeft"];
if(!h.opera||n>0){
ret.x+=isNaN(n)?0:n;
}
var m=_528["offsetTop"];
ret.y+=isNaN(m)?0:m;
_528=_528.offsetParent;
}while((_528!=_526)&&(_528!=null));
}else{
if(node["x"]&&node["y"]){
ret.x+=isNaN(node.x)?0:node.x;
ret.y+=isNaN(node.y)?0:node.y;
}
}
}
}
if(_51d){
var _52b=dojo.html.getScroll();
ret.y+=_52b.top;
ret.x+=_52b.left;
}
var _52c=[dojo.html.getPaddingExtent,dojo.html.getBorderExtent,dojo.html.getMarginExtent];
if(_521>_522){
for(var i=_522;i<_521;++i){
ret.y+=_52c[i](node,"top");
ret.x+=_52c[i](node,"left");
}
}else{
if(_521<_522){
for(var i=_522;i>_521;--i){
ret.y-=_52c[i-1](node,"top");
ret.x-=_52c[i-1](node,"left");
}
}
}
ret.top=ret.y;
ret.left=ret.x;
return ret;
};
dojo.html.isPositionAbsolute=function(node){
return (dojo.html.getComputedStyle(node,"position")=="absolute");
};
dojo.html._sumPixelValues=function(node,_530,_531){
var _532=0;
for(var x=0;x<_530.length;x++){
_532+=dojo.html.getPixelValue(node,_530[x],_531);
}
return _532;
};
dojo.html.getMargin=function(node){
return {width:dojo.html._sumPixelValues(node,["margin-left","margin-right"],(dojo.html.getComputedStyle(node,"position")=="absolute")),height:dojo.html._sumPixelValues(node,["margin-top","margin-bottom"],(dojo.html.getComputedStyle(node,"position")=="absolute"))};
};
dojo.html.getBorder=function(node){
return {width:dojo.html.getBorderExtent(node,"left")+dojo.html.getBorderExtent(node,"right"),height:dojo.html.getBorderExtent(node,"top")+dojo.html.getBorderExtent(node,"bottom")};
};
dojo.html.getBorderExtent=function(node,side){
return (dojo.html.getStyle(node,"border-"+side+"-style")=="none"?0:dojo.html.getPixelValue(node,"border-"+side+"-width"));
};
dojo.html.getMarginExtent=function(node,side){
return dojo.html._sumPixelValues(node,["margin-"+side],dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent=function(node,side){
return dojo.html._sumPixelValues(node,["padding-"+side],true);
};
dojo.html.getPadding=function(node){
return {width:dojo.html._sumPixelValues(node,["padding-left","padding-right"],true),height:dojo.html._sumPixelValues(node,["padding-top","padding-bottom"],true)};
};
dojo.html.getPadBorder=function(node){
var pad=dojo.html.getPadding(node);
var _53f=dojo.html.getBorder(node);
return {width:pad.width+_53f.width,height:pad.height+_53f.height};
};
dojo.html.getBoxSizing=function(node){
var h=dojo.render.html;
var bs=dojo.html.boxSizing;
if(((h.ie)||(h.opera))&&node.nodeName.toLowerCase()!="img"){
var cm=document["compatMode"];
if((cm=="BackCompat")||(cm=="QuirksMode")){
return bs.BORDER_BOX;
}else{
return bs.CONTENT_BOX;
}
}else{
if(arguments.length==0){
node=document.documentElement;
}
var _544;
if(!h.ie){
_544=dojo.html.getStyle(node,"-moz-box-sizing");
if(!_544){
_544=dojo.html.getStyle(node,"box-sizing");
}
}
return (_544?_544:bs.CONTENT_BOX);
}
};
dojo.html.isBorderBox=function(node){
return (dojo.html.getBoxSizing(node)==dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox=function(node){
node=dojo.byId(node);
return {width:node.offsetWidth,height:node.offsetHeight};
};
dojo.html.getPaddingBox=function(node){
var box=dojo.html.getBorderBox(node);
var _549=dojo.html.getBorder(node);
return {width:box.width-_549.width,height:box.height-_549.height};
};
dojo.html.getContentBox=function(node){
node=dojo.byId(node);
var _54b=dojo.html.getPadBorder(node);
return {width:node.offsetWidth-_54b.width,height:node.offsetHeight-_54b.height};
};
dojo.html.setContentBox=function(node,args){
node=dojo.byId(node);
var _54e=0;
var _54f=0;
var isbb=dojo.html.isBorderBox(node);
var _551=(isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var ret={};
if(typeof args.width!="undefined"){
_54e=args.width+_551.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_54e);
}
if(typeof args.height!="undefined"){
_54f=args.height+_551.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_54f);
}
return ret;
};
dojo.html.getMarginBox=function(node){
var _554=dojo.html.getBorderBox(node);
var _555=dojo.html.getMargin(node);
return {width:_554.width+_555.width,height:_554.height+_555.height};
};
dojo.html.setMarginBox=function(node,args){
node=dojo.byId(node);
var _558=0;
var _559=0;
var isbb=dojo.html.isBorderBox(node);
var _55b=(!isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var _55c=dojo.html.getMargin(node);
var ret={};
if(typeof args.width!="undefined"){
_558=args.width-_55b.width;
_558-=_55c.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_558);
}
if(typeof args.height!="undefined"){
_559=args.height-_55b.height;
_559-=_55c.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_559);
}
return ret;
};
dojo.html.getElementBox=function(node,type){
var bs=dojo.html.boxSizing;
switch(type){
case bs.MARGIN_BOX:
return dojo.html.getMarginBox(node);
case bs.BORDER_BOX:
return dojo.html.getBorderBox(node);
case bs.PADDING_BOX:
return dojo.html.getPaddingBox(node);
case bs.CONTENT_BOX:
default:
return dojo.html.getContentBox(node);
}
};
dojo.html.toCoordinateObject=dojo.html.toCoordinateArray=function(_561,_562,_563){
if(_561 instanceof Array||typeof _561=="array"){
dojo.deprecated("dojo.html.toCoordinateArray","use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead","0.5");
while(_561.length<4){
_561.push(0);
}
while(_561.length>4){
_561.pop();
}
var ret={left:_561[0],top:_561[1],width:_561[2],height:_561[3]};
}else{
if(!_561.nodeType&&!(_561 instanceof String||typeof _561=="string")&&("width" in _561||"height" in _561||"left" in _561||"x" in _561||"top" in _561||"y" in _561)){
var ret={left:_561.left||_561.x||0,top:_561.top||_561.y||0,width:_561.width||0,height:_561.height||0};
}else{
var node=dojo.byId(_561);
var pos=dojo.html.abs(node,_562,_563);
var _567=dojo.html.getMarginBox(node);
var ret={left:pos.left,top:pos.top,width:_567.width,height:_567.height};
}
}
ret.x=ret.left;
ret.y=ret.top;
return ret;
};
dojo.html.setMarginBoxWidth=dojo.html.setOuterWidth=function(node,_569){
return dojo.html._callDeprecated("setMarginBoxWidth","setMarginBox",arguments,"width");
};
dojo.html.setMarginBoxHeight=dojo.html.setOuterHeight=function(){
return dojo.html._callDeprecated("setMarginBoxHeight","setMarginBox",arguments,"height");
};
dojo.html.getMarginBoxWidth=dojo.html.getOuterWidth=function(){
return dojo.html._callDeprecated("getMarginBoxWidth","getMarginBox",arguments,null,"width");
};
dojo.html.getMarginBoxHeight=dojo.html.getOuterHeight=function(){
return dojo.html._callDeprecated("getMarginBoxHeight","getMarginBox",arguments,null,"height");
};
dojo.html.getTotalOffset=function(node,type,_56c){
return dojo.html._callDeprecated("getTotalOffset","getAbsolutePosition",arguments,null,type);
};
dojo.html.getAbsoluteX=function(node,_56e){
return dojo.html._callDeprecated("getAbsoluteX","getAbsolutePosition",arguments,null,"x");
};
dojo.html.getAbsoluteY=function(node,_570){
return dojo.html._callDeprecated("getAbsoluteY","getAbsolutePosition",arguments,null,"y");
};
dojo.html.totalOffsetLeft=function(node,_572){
return dojo.html._callDeprecated("totalOffsetLeft","getAbsolutePosition",arguments,null,"left");
};
dojo.html.totalOffsetTop=function(node,_574){
return dojo.html._callDeprecated("totalOffsetTop","getAbsolutePosition",arguments,null,"top");
};
dojo.html.getMarginWidth=function(node){
return dojo.html._callDeprecated("getMarginWidth","getMargin",arguments,null,"width");
};
dojo.html.getMarginHeight=function(node){
return dojo.html._callDeprecated("getMarginHeight","getMargin",arguments,null,"height");
};
dojo.html.getBorderWidth=function(node){
return dojo.html._callDeprecated("getBorderWidth","getBorder",arguments,null,"width");
};
dojo.html.getBorderHeight=function(node){
return dojo.html._callDeprecated("getBorderHeight","getBorder",arguments,null,"height");
};
dojo.html.getPaddingWidth=function(node){
return dojo.html._callDeprecated("getPaddingWidth","getPadding",arguments,null,"width");
};
dojo.html.getPaddingHeight=function(node){
return dojo.html._callDeprecated("getPaddingHeight","getPadding",arguments,null,"height");
};
dojo.html.getPadBorderWidth=function(node){
return dojo.html._callDeprecated("getPadBorderWidth","getPadBorder",arguments,null,"width");
};
dojo.html.getPadBorderHeight=function(node){
return dojo.html._callDeprecated("getPadBorderHeight","getPadBorder",arguments,null,"height");
};
dojo.html.getBorderBoxWidth=dojo.html.getInnerWidth=function(){
return dojo.html._callDeprecated("getBorderBoxWidth","getBorderBox",arguments,null,"width");
};
dojo.html.getBorderBoxHeight=dojo.html.getInnerHeight=function(){
return dojo.html._callDeprecated("getBorderBoxHeight","getBorderBox",arguments,null,"height");
};
dojo.html.getContentBoxWidth=dojo.html.getContentWidth=function(){
return dojo.html._callDeprecated("getContentBoxWidth","getContentBox",arguments,null,"width");
};
dojo.html.getContentBoxHeight=dojo.html.getContentHeight=function(){
return dojo.html._callDeprecated("getContentBoxHeight","getContentBox",arguments,null,"height");
};
dojo.html.setContentBoxWidth=dojo.html.setContentWidth=function(node,_57e){
return dojo.html._callDeprecated("setContentBoxWidth","setContentBox",arguments,"width");
};
dojo.html.setContentBoxHeight=dojo.html.setContentHeight=function(node,_580){
return dojo.html._callDeprecated("setContentBoxHeight","setContentBox",arguments,"height");
};
dojo.provide("dojo.html.util");
dojo.html.getElementWindow=function(_581){
return dojo.html.getDocumentWindow(_581.ownerDocument);
};
dojo.html.getDocumentWindow=function(doc){
if(dojo.render.html.safari&&!doc._parentWindow){
var fix=function(win){
win.document._parentWindow=win;
for(var i=0;i<win.frames.length;i++){
fix(win.frames[i]);
}
};
fix(window.top);
}
if(dojo.render.html.ie&&window!==document.parentWindow&&!doc._parentWindow){
doc.parentWindow.execScript("document._parentWindow = window;","Javascript");
var win=doc._parentWindow;
doc._parentWindow=null;
return win;
}
return doc._parentWindow||doc.parentWindow||doc.defaultView;
};
dojo.html.gravity=function(node,e){
node=dojo.byId(node);
var _589=dojo.html.getCursorPosition(e);
with(dojo.html){
var _58a=getAbsolutePosition(node,true);
var bb=getBorderBox(node);
var _58c=_58a.x+(bb.width/2);
var _58d=_58a.y+(bb.height/2);
}
with(dojo.html.gravity){
return ((_589.x<_58c?WEST:EAST)|(_589.y<_58d?NORTH:SOUTH));
}
};
dojo.html.gravity.NORTH=1;
dojo.html.gravity.SOUTH=1<<1;
dojo.html.gravity.EAST=1<<2;
dojo.html.gravity.WEST=1<<3;
dojo.html.overElement=function(_58e,e){
_58e=dojo.byId(_58e);
var _590=dojo.html.getCursorPosition(e);
var bb=dojo.html.getBorderBox(_58e);
var _592=dojo.html.getAbsolutePosition(_58e,true,dojo.html.boxSizing.BORDER_BOX);
var top=_592.y;
var _594=top+bb.height;
var left=_592.x;
var _596=left+bb.width;
return (_590.x>=left&&_590.x<=_596&&_590.y>=top&&_590.y<=_594);
};
dojo.html.renderedTextContent=function(node){
node=dojo.byId(node);
var _598="";
if(node==null){
return _598;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
var _59a="unknown";
try{
_59a=dojo.html.getStyle(node.childNodes[i],"display");
}
catch(E){
}
switch(_59a){
case "block":
case "list-item":
case "run-in":
case "table":
case "table-row-group":
case "table-header-group":
case "table-footer-group":
case "table-row":
case "table-column-group":
case "table-column":
case "table-cell":
case "table-caption":
_598+="\n";
_598+=dojo.html.renderedTextContent(node.childNodes[i]);
_598+="\n";
break;
case "none":
break;
default:
if(node.childNodes[i].tagName&&node.childNodes[i].tagName.toLowerCase()=="br"){
_598+="\n";
}else{
_598+=dojo.html.renderedTextContent(node.childNodes[i]);
}
break;
}
break;
case 3:
case 2:
case 4:
var text=node.childNodes[i].nodeValue;
var _59c="unknown";
try{
_59c=dojo.html.getStyle(node,"text-transform");
}
catch(E){
}
switch(_59c){
case "capitalize":
var _59d=text.split(" ");
for(var i=0;i<_59d.length;i++){
_59d[i]=_59d[i].charAt(0).toUpperCase()+_59d[i].substring(1);
}
text=_59d.join(" ");
break;
case "uppercase":
text=text.toUpperCase();
break;
case "lowercase":
text=text.toLowerCase();
break;
default:
break;
}
switch(_59c){
case "nowrap":
break;
case "pre-wrap":
break;
case "pre-line":
break;
case "pre":
break;
default:
text=text.replace(/\s+/," ");
if(/\s$/.test(_598)){
text.replace(/^\s/,"");
}
break;
}
_598+=text;
break;
default:
break;
}
}
return _598;
};
dojo.html.createNodesFromText=function(txt,trim){
if(trim){
txt=txt.replace(/^\s+|\s+$/g,"");
}
var tn=dojo.doc().createElement("div");
tn.style.visibility="hidden";
dojo.body().appendChild(tn);
var _5a1="none";
if((/^<t[dh][\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody><tr>"+txt+"</tr></tbody></table>";
_5a1="cell";
}else{
if((/^<tr[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody>"+txt+"</tbody></table>";
_5a1="row";
}else{
if((/^<(thead|tbody|tfoot)[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table>"+txt+"</table>";
_5a1="section";
}
}
}
tn.innerHTML=txt;
if(tn["normalize"]){
tn.normalize();
}
var _5a2=null;
switch(_5a1){
case "cell":
_5a2=tn.getElementsByTagName("tr")[0];
break;
case "row":
_5a2=tn.getElementsByTagName("tbody")[0];
break;
case "section":
_5a2=tn.getElementsByTagName("table")[0];
break;
default:
_5a2=tn;
break;
}
var _5a3=[];
for(var x=0;x<_5a2.childNodes.length;x++){
_5a3.push(_5a2.childNodes[x].cloneNode(true));
}
tn.style.display="none";
dojo.html.destroyNode(tn);
return _5a3;
};
dojo.html.placeOnScreen=function(node,_5a6,_5a7,_5a8,_5a9,_5aa,_5ab){
if(_5a6 instanceof Array||typeof _5a6=="array"){
_5ab=_5aa;
_5aa=_5a9;
_5a9=_5a8;
_5a8=_5a7;
_5a7=_5a6[1];
_5a6=_5a6[0];
}
if(_5aa instanceof String||typeof _5aa=="string"){
_5aa=_5aa.split(",");
}
if(!isNaN(_5a8)){
_5a8=[Number(_5a8),Number(_5a8)];
}else{
if(!(_5a8 instanceof Array||typeof _5a8=="array")){
_5a8=[0,0];
}
}
var _5ac=dojo.html.getScroll().offset;
var view=dojo.html.getViewport();
node=dojo.byId(node);
var _5ae=node.style.display;
node.style.display="";
var bb=dojo.html.getBorderBox(node);
var w=bb.width;
var h=bb.height;
node.style.display=_5ae;
if(!(_5aa instanceof Array||typeof _5aa=="array")){
_5aa=["TL"];
}
var _5b2,_5b3,_5b4=Infinity,_5b5;
for(var _5b6=0;_5b6<_5aa.length;++_5b6){
var _5b7=_5aa[_5b6];
var _5b8=true;
var tryX=_5a6-(_5b7.charAt(1)=="L"?0:w)+_5a8[0]*(_5b7.charAt(1)=="L"?1:-1);
var tryY=_5a7-(_5b7.charAt(0)=="T"?0:h)+_5a8[1]*(_5b7.charAt(0)=="T"?1:-1);
if(_5a9){
tryX-=_5ac.x;
tryY-=_5ac.y;
}
if(tryX<0){
tryX=0;
_5b8=false;
}
if(tryY<0){
tryY=0;
_5b8=false;
}
var x=tryX+w;
if(x>view.width){
x=view.width-w;
_5b8=false;
}else{
x=tryX;
}
x=Math.max(_5a8[0],x)+_5ac.x;
var y=tryY+h;
if(y>view.height){
y=view.height-h;
_5b8=false;
}else{
y=tryY;
}
y=Math.max(_5a8[1],y)+_5ac.y;
if(_5b8){
_5b2=x;
_5b3=y;
_5b4=0;
_5b5=_5b7;
break;
}else{
var dist=Math.pow(x-tryX-_5ac.x,2)+Math.pow(y-tryY-_5ac.y,2);
if(_5b4>dist){
_5b4=dist;
_5b2=x;
_5b3=y;
_5b5=_5b7;
}
}
}
if(!_5ab){
node.style.left=_5b2+"px";
node.style.top=_5b3+"px";
}
return {left:_5b2,top:_5b3,x:_5b2,y:_5b3,dist:_5b4,corner:_5b5};
};
dojo.html.placeOnScreenPoint=function(node,_5bf,_5c0,_5c1,_5c2){
dojo.deprecated("dojo.html.placeOnScreenPoint","use dojo.html.placeOnScreen() instead","0.5");
return dojo.html.placeOnScreen(node,_5bf,_5c0,_5c1,_5c2,["TL","TR","BL","BR"]);
};
dojo.html.placeOnScreenAroundElement=function(node,_5c4,_5c5,_5c6,_5c7,_5c8){
var best,_5ca=Infinity;
_5c4=dojo.byId(_5c4);
var _5cb=_5c4.style.display;
_5c4.style.display="";
var mb=dojo.html.getElementBox(_5c4,_5c6);
var _5cd=mb.width;
var _5ce=mb.height;
var _5cf=dojo.html.getAbsolutePosition(_5c4,true,_5c6);
_5c4.style.display=_5cb;
for(var _5d0 in _5c7){
var pos,_5d2,_5d3;
var _5d4=_5c7[_5d0];
_5d2=_5cf.x+(_5d0.charAt(1)=="L"?0:_5cd);
_5d3=_5cf.y+(_5d0.charAt(0)=="T"?0:_5ce);
pos=dojo.html.placeOnScreen(node,_5d2,_5d3,_5c5,true,_5d4,true);
if(pos.dist==0){
best=pos;
break;
}else{
if(_5ca>pos.dist){
_5ca=pos.dist;
best=pos;
}
}
}
if(!_5c8){
node.style.left=best.left+"px";
node.style.top=best.top+"px";
}
return best;
};
dojo.html.scrollIntoView=function(node){
if(!node){
return;
}
if(dojo.render.html.ie){
if(dojo.html.getBorderBox(node.parentNode).height<=node.parentNode.scrollHeight){
node.scrollIntoView(false);
}
}else{
if(dojo.render.html.mozilla){
node.scrollIntoView(false);
}else{
var _5d6=node.parentNode;
var _5d7=_5d6.scrollTop+dojo.html.getBorderBox(_5d6).height;
var _5d8=node.offsetTop+dojo.html.getMarginBox(node).height;
if(_5d7<_5d8){
_5d6.scrollTop+=(_5d8-_5d7);
}else{
if(_5d6.scrollTop>node.offsetTop){
_5d6.scrollTop-=(_5d6.scrollTop-node.offsetTop);
}
}
}
}
};
dojo.provide("dojo.gfx.color");
dojo.gfx.color.Color=function(r,g,b,a){
if(dojo.lang.isArray(r)){
this.r=r[0];
this.g=r[1];
this.b=r[2];
this.a=r[3]||1;
}else{
if(dojo.lang.isString(r)){
var rgb=dojo.gfx.color.extractRGB(r);
this.r=rgb[0];
this.g=rgb[1];
this.b=rgb[2];
this.a=g||1;
}else{
if(r instanceof dojo.gfx.color.Color){
this.r=r.r;
this.b=r.b;
this.g=r.g;
this.a=r.a;
}else{
this.r=r;
this.g=g;
this.b=b;
this.a=a;
}
}
}
};
dojo.gfx.color.Color.fromArray=function(arr){
return new dojo.gfx.color.Color(arr[0],arr[1],arr[2],arr[3]);
};
dojo.extend(dojo.gfx.color.Color,{toRgb:function(_5df){
if(_5df){
return this.toRgba();
}else{
return [this.r,this.g,this.b];
}
},toRgba:function(){
return [this.r,this.g,this.b,this.a];
},toHex:function(){
return dojo.gfx.color.rgb2hex(this.toRgb());
},toCss:function(){
return "rgb("+this.toRgb().join()+")";
},toString:function(){
return this.toHex();
},blend:function(_5e0,_5e1){
var rgb=null;
if(dojo.lang.isArray(_5e0)){
rgb=_5e0;
}else{
if(_5e0 instanceof dojo.gfx.color.Color){
rgb=_5e0.toRgb();
}else{
rgb=new dojo.gfx.color.Color(_5e0).toRgb();
}
}
return dojo.gfx.color.blend(this.toRgb(),rgb,_5e1);
}});
dojo.gfx.color.named={white:[255,255,255],black:[0,0,0],red:[255,0,0],green:[0,255,0],lime:[0,255,0],blue:[0,0,255],navy:[0,0,128],gray:[128,128,128],silver:[192,192,192]};
dojo.gfx.color.blend=function(a,b,_5e5){
if(typeof a=="string"){
return dojo.gfx.color.blendHex(a,b,_5e5);
}
if(!_5e5){
_5e5=0;
}
_5e5=Math.min(Math.max(-1,_5e5),1);
_5e5=((_5e5+1)/2);
var c=[];
for(var x=0;x<3;x++){
c[x]=parseInt(b[x]+((a[x]-b[x])*_5e5));
}
return c;
};
dojo.gfx.color.blendHex=function(a,b,_5ea){
return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a),dojo.gfx.color.hex2rgb(b),_5ea));
};
dojo.gfx.color.extractRGB=function(_5eb){
var hex="0123456789abcdef";
_5eb=_5eb.toLowerCase();
if(_5eb.indexOf("rgb")==0){
var _5ed=_5eb.match(/rgba*\((\d+), *(\d+), *(\d+)/i);
var ret=_5ed.splice(1,3);
return ret;
}else{
var _5ef=dojo.gfx.color.hex2rgb(_5eb);
if(_5ef){
return _5ef;
}else{
return dojo.gfx.color.named[_5eb]||[255,255,255];
}
}
};
dojo.gfx.color.hex2rgb=function(hex){
var _5f1="0123456789ABCDEF";
var rgb=new Array(3);
if(hex.indexOf("#")==0){
hex=hex.substring(1);
}
hex=hex.toUpperCase();
if(hex.replace(new RegExp("["+_5f1+"]","g"),"")!=""){
return null;
}
if(hex.length==3){
rgb[0]=hex.charAt(0)+hex.charAt(0);
rgb[1]=hex.charAt(1)+hex.charAt(1);
rgb[2]=hex.charAt(2)+hex.charAt(2);
}else{
rgb[0]=hex.substring(0,2);
rgb[1]=hex.substring(2,4);
rgb[2]=hex.substring(4);
}
for(var i=0;i<rgb.length;i++){
rgb[i]=_5f1.indexOf(rgb[i].charAt(0))*16+_5f1.indexOf(rgb[i].charAt(1));
}
return rgb;
};
dojo.gfx.color.rgb2hex=function(r,g,b){
if(dojo.lang.isArray(r)){
g=r[1]||0;
b=r[2]||0;
r=r[0]||0;
}
var ret=dojo.lang.map([r,g,b],function(x){
x=new Number(x);
var s=x.toString(16);
while(s.length<2){
s="0"+s;
}
return s;
});
ret.unshift("#");
return ret.join("");
};
dojo.provide("dojo.lfx.Animation");
dojo.lfx.Line=function(_5fa,end){
this.start=_5fa;
this.end=end;
if(dojo.lang.isArray(_5fa)){
var diff=[];
dojo.lang.forEach(this.start,function(s,i){
diff[i]=this.end[i]-s;
},this);
this.getValue=function(n){
var res=[];
dojo.lang.forEach(this.start,function(s,i){
res[i]=(diff[i]*n)+s;
},this);
return res;
};
}else{
var diff=end-_5fa;
this.getValue=function(n){
return (diff*n)+this.start;
};
}
};
if((dojo.render.html.khtml)&&(!dojo.render.html.safari)){
dojo.lfx.easeDefault=function(n){
return (parseFloat("0.5")+((Math.sin((n+parseFloat("1.5"))*Math.PI))/2));
};
}else{
dojo.lfx.easeDefault=function(n){
return (0.5+((Math.sin((n+1.5)*Math.PI))/2));
};
}
dojo.lfx.easeIn=function(n){
return Math.pow(n,3);
};
dojo.lfx.easeOut=function(n){
return (1-Math.pow(1-n,3));
};
dojo.lfx.easeInOut=function(n){
return ((3*Math.pow(n,2))-(2*Math.pow(n,3)));
};
dojo.lfx.IAnimation=function(){
};
dojo.lang.extend(dojo.lfx.IAnimation,{curve:null,duration:1000,easing:null,repeatCount:0,rate:10,handler:null,beforeBegin:null,onBegin:null,onAnimate:null,onEnd:null,onPlay:null,onPause:null,onStop:null,play:null,pause:null,stop:null,connect:function(evt,_60a,_60b){
if(!_60b){
_60b=_60a;
_60a=this;
}
_60b=dojo.lang.hitch(_60a,_60b);
var _60c=this[evt]||function(){
};
this[evt]=function(){
var ret=_60c.apply(this,arguments);
_60b.apply(this,arguments);
return ret;
};
return this;
},fire:function(evt,args){
if(this[evt]){
this[evt].apply(this,(args||[]));
}
return this;
},repeat:function(_610){
this.repeatCount=_610;
return this;
},_active:false,_paused:false});
dojo.lfx.Animation=function(_611,_612,_613,_614,_615,rate){
dojo.lfx.IAnimation.call(this);
if(dojo.lang.isNumber(_611)||(!_611&&_612.getValue)){
rate=_615;
_615=_614;
_614=_613;
_613=_612;
_612=_611;
_611=null;
}else{
if(_611.getValue||dojo.lang.isArray(_611)){
rate=_614;
_615=_613;
_614=_612;
_613=_611;
_612=null;
_611=null;
}
}
if(dojo.lang.isArray(_613)){
this.curve=new dojo.lfx.Line(_613[0],_613[1]);
}else{
this.curve=_613;
}
if(_612!=null&&_612>0){
this.duration=_612;
}
if(_615){
this.repeatCount=_615;
}
if(rate){
this.rate=rate;
}
if(_611){
dojo.lang.forEach(["handler","beforeBegin","onBegin","onEnd","onPlay","onStop","onAnimate"],function(item){
if(_611[item]){
this.connect(item,_611[item]);
}
},this);
}
if(_614&&dojo.lang.isFunction(_614)){
this.easing=_614;
}
};
dojo.inherits(dojo.lfx.Animation,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Animation,{_startTime:null,_endTime:null,_timer:null,_percent:0,_startRepeatCount:0,play:function(_618,_619){
if(_619){
clearTimeout(this._timer);
this._active=false;
this._paused=false;
this._percent=0;
}else{
if(this._active&&!this._paused){
return this;
}
}
this.fire("handler",["beforeBegin"]);
this.fire("beforeBegin");
if(_618>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_619);
}),_618);
return this;
}
this._startTime=new Date().valueOf();
if(this._paused){
this._startTime-=(this.duration*this._percent/100);
}
this._endTime=this._startTime+this.duration;
this._active=true;
this._paused=false;
var step=this._percent/100;
var _61b=this.curve.getValue(step);
if(this._percent==0){
if(!this._startRepeatCount){
this._startRepeatCount=this.repeatCount;
}
this.fire("handler",["begin",_61b]);
this.fire("onBegin",[_61b]);
}
this.fire("handler",["play",_61b]);
this.fire("onPlay",[_61b]);
this._cycle();
return this;
},pause:function(){
clearTimeout(this._timer);
if(!this._active){
return this;
}
this._paused=true;
var _61c=this.curve.getValue(this._percent/100);
this.fire("handler",["pause",_61c]);
this.fire("onPause",[_61c]);
return this;
},gotoPercent:function(pct,_61e){
clearTimeout(this._timer);
this._active=true;
this._paused=true;
this._percent=pct;
if(_61e){
this.play();
}
return this;
},stop:function(_61f){
clearTimeout(this._timer);
var step=this._percent/100;
if(_61f){
step=1;
}
var _621=this.curve.getValue(step);
this.fire("handler",["stop",_621]);
this.fire("onStop",[_621]);
this._active=false;
this._paused=false;
return this;
},status:function(){
if(this._active){
return this._paused?"paused":"playing";
}else{
return "stopped";
}
return this;
},_cycle:function(){
clearTimeout(this._timer);
if(this._active){
var curr=new Date().valueOf();
var step=(curr-this._startTime)/(this._endTime-this._startTime);
if(step>=1){
step=1;
this._percent=100;
}else{
this._percent=step*100;
}
if((this.easing)&&(dojo.lang.isFunction(this.easing))){
step=this.easing(step);
}
var _624=this.curve.getValue(step);
this.fire("handler",["animate",_624]);
this.fire("onAnimate",[_624]);
if(step<1){
this._timer=setTimeout(dojo.lang.hitch(this,"_cycle"),this.rate);
}else{
this._active=false;
this.fire("handler",["end"]);
this.fire("onEnd");
if(this.repeatCount>0){
this.repeatCount--;
this.play(null,true);
}else{
if(this.repeatCount==-1){
this.play(null,true);
}else{
if(this._startRepeatCount){
this.repeatCount=this._startRepeatCount;
this._startRepeatCount=0;
}
}
}
}
}
return this;
}});
dojo.lfx.Combine=function(_625){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._animsEnded=0;
var _626=arguments;
if(_626.length==1&&(dojo.lang.isArray(_626[0])||dojo.lang.isArrayLike(_626[0]))){
_626=_626[0];
}
dojo.lang.forEach(_626,function(anim){
this._anims.push(anim);
anim.connect("onEnd",dojo.lang.hitch(this,"_onAnimsEnded"));
},this);
};
dojo.inherits(dojo.lfx.Combine,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Combine,{_animsEnded:0,play:function(_628,_629){
if(!this._anims.length){
return this;
}
this.fire("beforeBegin");
if(_628>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_629);
}),_628);
return this;
}
if(_629||this._anims[0].percent==0){
this.fire("onBegin");
}
this.fire("onPlay");
this._animsCall("play",null,_629);
return this;
},pause:function(){
this.fire("onPause");
this._animsCall("pause");
return this;
},stop:function(_62a){
this.fire("onStop");
this._animsCall("stop",_62a);
return this;
},_onAnimsEnded:function(){
this._animsEnded++;
if(this._animsEnded>=this._anims.length){
this.fire("onEnd");
}
return this;
},_animsCall:function(_62b){
var args=[];
if(arguments.length>1){
for(var i=1;i<arguments.length;i++){
args.push(arguments[i]);
}
}
var _62e=this;
dojo.lang.forEach(this._anims,function(anim){
anim[_62b](args);
},_62e);
return this;
}});
dojo.lfx.Chain=function(_630){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._currAnim=-1;
var _631=arguments;
if(_631.length==1&&(dojo.lang.isArray(_631[0])||dojo.lang.isArrayLike(_631[0]))){
_631=_631[0];
}
var _632=this;
dojo.lang.forEach(_631,function(anim,i,_635){
this._anims.push(anim);
if(i<_635.length-1){
anim.connect("onEnd",dojo.lang.hitch(this,"_playNext"));
}else{
anim.connect("onEnd",dojo.lang.hitch(this,function(){
this.fire("onEnd");
}));
}
},this);
};
dojo.inherits(dojo.lfx.Chain,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Chain,{_currAnim:-1,play:function(_636,_637){
if(!this._anims.length){
return this;
}
if(_637||!this._anims[this._currAnim]){
this._currAnim=0;
}
var _638=this._anims[this._currAnim];
this.fire("beforeBegin");
if(_636>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_637);
}),_636);
return this;
}
if(_638){
if(this._currAnim==0){
this.fire("handler",["begin",this._currAnim]);
this.fire("onBegin",[this._currAnim]);
}
this.fire("onPlay",[this._currAnim]);
_638.play(null,_637);
}
return this;
},pause:function(){
if(this._anims[this._currAnim]){
this._anims[this._currAnim].pause();
this.fire("onPause",[this._currAnim]);
}
return this;
},playPause:function(){
if(this._anims.length==0){
return this;
}
if(this._currAnim==-1){
this._currAnim=0;
}
var _639=this._anims[this._currAnim];
if(_639){
if(!_639._active||_639._paused){
this.play();
}else{
this.pause();
}
}
return this;
},stop:function(){
var _63a=this._anims[this._currAnim];
if(_63a){
_63a.stop();
this.fire("onStop",[this._currAnim]);
}
return _63a;
},_playNext:function(){
if(this._currAnim==-1||this._anims.length==0){
return this;
}
this._currAnim++;
if(this._anims[this._currAnim]){
this._anims[this._currAnim].play(null,true);
}
return this;
}});
dojo.lfx.combine=function(_63b){
var _63c=arguments;
if(dojo.lang.isArray(arguments[0])){
_63c=arguments[0];
}
if(_63c.length==1){
return _63c[0];
}
return new dojo.lfx.Combine(_63c);
};
dojo.lfx.chain=function(_63d){
var _63e=arguments;
if(dojo.lang.isArray(arguments[0])){
_63e=arguments[0];
}
if(_63e.length==1){
return _63e[0];
}
return new dojo.lfx.Chain(_63e);
};
dojo.provide("dojo.html.color");
dojo.html.getBackgroundColor=function(node){
node=dojo.byId(node);
var _640;
do{
_640=dojo.html.getStyle(node,"background-color");
if(_640.toLowerCase()=="rgba(0, 0, 0, 0)"){
_640="transparent";
}
if(node==document.getElementsByTagName("body")[0]){
node=null;
break;
}
node=node.parentNode;
}while(node&&dojo.lang.inArray(["transparent",""],_640));
if(_640=="transparent"){
_640=[255,255,255,0];
}else{
_640=dojo.gfx.color.extractRGB(_640);
}
return _640;
};
dojo.provide("dojo.lfx.html");
dojo.lfx.html._byId=function(_641){
if(!_641){
return [];
}
if(dojo.lang.isArrayLike(_641)){
if(!_641.alreadyChecked){
var n=[];
dojo.lang.forEach(_641,function(node){
n.push(dojo.byId(node));
});
n.alreadyChecked=true;
return n;
}else{
return _641;
}
}else{
var n=[];
n.push(dojo.byId(_641));
n.alreadyChecked=true;
return n;
}
};
dojo.lfx.html.propertyAnimation=function(_644,_645,_646,_647,_648){
_644=dojo.lfx.html._byId(_644);
var _649={"propertyMap":_645,"nodes":_644,"duration":_646,"easing":_647||dojo.lfx.easeDefault};
var _64a=function(args){
if(args.nodes.length==1){
var pm=args.propertyMap;
if(!dojo.lang.isArray(args.propertyMap)){
var parr=[];
for(var _64e in pm){
pm[_64e].property=_64e;
parr.push(pm[_64e]);
}
pm=args.propertyMap=parr;
}
dojo.lang.forEach(pm,function(prop){
if(dj_undef("start",prop)){
if(prop.property!="opacity"){
prop.start=parseInt(dojo.html.getComputedStyle(args.nodes[0],prop.property));
}else{
prop.start=dojo.html.getOpacity(args.nodes[0]);
}
}
});
}
};
var _650=function(_651){
var _652=[];
dojo.lang.forEach(_651,function(c){
_652.push(Math.round(c));
});
return _652;
};
var _654=function(n,_656){
n=dojo.byId(n);
if(!n||!n.style){
return;
}
for(var s in _656){
try{
if(s=="opacity"){
dojo.html.setOpacity(n,_656[s]);
}else{
n.style[s]=_656[s];
}
}
catch(e){
dojo.debug(e);
}
}
};
var _658=function(_659){
this._properties=_659;
this.diffs=new Array(_659.length);
dojo.lang.forEach(_659,function(prop,i){
if(dojo.lang.isFunction(prop.start)){
prop.start=prop.start(prop,i);
}
if(dojo.lang.isFunction(prop.end)){
prop.end=prop.end(prop,i);
}
if(dojo.lang.isArray(prop.start)){
this.diffs[i]=null;
}else{
if(prop.start instanceof dojo.gfx.color.Color){
prop.startRgb=prop.start.toRgb();
prop.endRgb=prop.end.toRgb();
}else{
this.diffs[i]=prop.end-prop.start;
}
}
},this);
this.getValue=function(n){
var ret={};
dojo.lang.forEach(this._properties,function(prop,i){
var _660=null;
if(dojo.lang.isArray(prop.start)){
}else{
if(prop.start instanceof dojo.gfx.color.Color){
_660=(prop.units||"rgb")+"(";
for(var j=0;j<prop.startRgb.length;j++){
_660+=Math.round(((prop.endRgb[j]-prop.startRgb[j])*n)+prop.startRgb[j])+(j<prop.startRgb.length-1?",":"");
}
_660+=")";
}else{
_660=((this.diffs[i])*n)+prop.start+(prop.property!="opacity"?prop.units||"px":"");
}
}
ret[dojo.html.toCamelCase(prop.property)]=_660;
},this);
return ret;
};
};
var anim=new dojo.lfx.Animation({beforeBegin:function(){
_64a(_649);
anim.curve=new _658(_649.propertyMap);
},onAnimate:function(_663){
dojo.lang.forEach(_649.nodes,function(node){
_654(node,_663);
});
}},_649.duration,null,_649.easing);
if(_648){
for(var x in _648){
if(dojo.lang.isFunction(_648[x])){
anim.connect(x,anim,_648[x]);
}
}
}
return anim;
};
dojo.lfx.html._makeFadeable=function(_666){
var _667=function(node){
if(dojo.render.html.ie){
if((node.style.zoom.length==0)&&(dojo.html.getStyle(node,"zoom")=="normal")){
node.style.zoom="1";
}
if((node.style.width.length==0)&&(dojo.html.getStyle(node,"width")=="auto")){
node.style.width="auto";
}
}
};
if(dojo.lang.isArrayLike(_666)){
dojo.lang.forEach(_666,_667);
}else{
_667(_666);
}
};
dojo.lfx.html.fade=function(_669,_66a,_66b,_66c,_66d){
_669=dojo.lfx.html._byId(_669);
var _66e={property:"opacity"};
if(!dj_undef("start",_66a)){
_66e.start=_66a.start;
}else{
_66e.start=function(){
return dojo.html.getOpacity(_669[0]);
};
}
if(!dj_undef("end",_66a)){
_66e.end=_66a.end;
}else{
dojo.raise("dojo.lfx.html.fade needs an end value");
}
var anim=dojo.lfx.propertyAnimation(_669,[_66e],_66b,_66c);
anim.connect("beforeBegin",function(){
dojo.lfx.html._makeFadeable(_669);
});
if(_66d){
anim.connect("onEnd",function(){
_66d(_669,anim);
});
}
return anim;
};
dojo.lfx.html.fadeIn=function(_670,_671,_672,_673){
return dojo.lfx.html.fade(_670,{end:1},_671,_672,_673);
};
dojo.lfx.html.fadeOut=function(_674,_675,_676,_677){
return dojo.lfx.html.fade(_674,{end:0},_675,_676,_677);
};
dojo.lfx.html.fadeShow=function(_678,_679,_67a,_67b){
_678=dojo.lfx.html._byId(_678);
dojo.lang.forEach(_678,function(node){
dojo.html.setOpacity(node,0);
});
var anim=dojo.lfx.html.fadeIn(_678,_679,_67a,_67b);
anim.connect("beforeBegin",function(){
if(dojo.lang.isArrayLike(_678)){
dojo.lang.forEach(_678,dojo.html.show);
}else{
dojo.html.show(_678);
}
});
return anim;
};
dojo.lfx.html.fadeHide=function(_67e,_67f,_680,_681){
var anim=dojo.lfx.html.fadeOut(_67e,_67f,_680,function(){
if(dojo.lang.isArrayLike(_67e)){
dojo.lang.forEach(_67e,dojo.html.hide);
}else{
dojo.html.hide(_67e);
}
if(_681){
_681(_67e,anim);
}
});
return anim;
};
dojo.lfx.html.wipeIn=function(_683,_684,_685,_686){
_683=dojo.lfx.html._byId(_683);
var _687=[];
dojo.lang.forEach(_683,function(node){
var _689={};
var _68a,_68b,_68c;
with(node.style){
_68a=top;
_68b=left;
_68c=position;
top="-9999px";
left="-9999px";
position="absolute";
display="";
}
var _68d=dojo.html.getBorderBox(node).height;
with(node.style){
top=_68a;
left=_68b;
position=_68c;
display="none";
}
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:1,end:function(){
return _68d;
}}},_684,_685);
anim.connect("beforeBegin",function(){
_689.overflow=node.style.overflow;
_689.height=node.style.height;
with(node.style){
overflow="hidden";
height="1px";
}
dojo.html.show(node);
});
anim.connect("onEnd",function(){
with(node.style){
overflow=_689.overflow;
height=_689.height;
}
if(_686){
_686(node,anim);
}
});
_687.push(anim);
});
return dojo.lfx.combine(_687);
};
dojo.lfx.html.wipeOut=function(_68f,_690,_691,_692){
_68f=dojo.lfx.html._byId(_68f);
var _693=[];
dojo.lang.forEach(_68f,function(node){
var _695={};
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:function(){
return dojo.html.getContentBox(node).height;
},end:1}},_690,_691,{"beforeBegin":function(){
_695.overflow=node.style.overflow;
_695.height=node.style.height;
with(node.style){
overflow="hidden";
}
dojo.html.show(node);
},"onEnd":function(){
dojo.html.hide(node);
with(node.style){
overflow=_695.overflow;
height=_695.height;
}
if(_692){
_692(node,anim);
}
}});
_693.push(anim);
});
return dojo.lfx.combine(_693);
};
dojo.lfx.html.slideTo=function(_697,_698,_699,_69a,_69b){
_697=dojo.lfx.html._byId(_697);
var _69c=[];
var _69d=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_698)){
dojo.deprecated("dojo.lfx.html.slideTo(node, array)","use dojo.lfx.html.slideTo(node, {top: value, left: value});","0.5");
_698={top:_698[0],left:_698[1]};
}
dojo.lang.forEach(_697,function(node){
var top=null;
var left=null;
var init=(function(){
var _6a2=node;
return function(){
var pos=_69d(_6a2,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_69d(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_69d(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_6a2,true);
dojo.html.setStyleAttributes(_6a2,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:(_698.top||0)},"left":{start:left,end:(_698.left||0)}},_699,_69a,{"beforeBegin":init});
if(_69b){
anim.connect("onEnd",function(){
_69b(_697,anim);
});
}
_69c.push(anim);
});
return dojo.lfx.combine(_69c);
};
dojo.lfx.html.slideBy=function(_6a6,_6a7,_6a8,_6a9,_6aa){
_6a6=dojo.lfx.html._byId(_6a6);
var _6ab=[];
var _6ac=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_6a7)){
dojo.deprecated("dojo.lfx.html.slideBy(node, array)","use dojo.lfx.html.slideBy(node, {top: value, left: value});","0.5");
_6a7={top:_6a7[0],left:_6a7[1]};
}
dojo.lang.forEach(_6a6,function(node){
var top=null;
var left=null;
var init=(function(){
var _6b1=node;
return function(){
var pos=_6ac(_6b1,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_6ac(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_6ac(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_6b1,true);
dojo.html.setStyleAttributes(_6b1,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:top+(_6a7.top||0)},"left":{start:left,end:left+(_6a7.left||0)}},_6a8,_6a9).connect("beforeBegin",init);
if(_6aa){
anim.connect("onEnd",function(){
_6aa(_6a6,anim);
});
}
_6ab.push(anim);
});
return dojo.lfx.combine(_6ab);
};
dojo.lfx.html.explode=function(_6b5,_6b6,_6b7,_6b8,_6b9){
var h=dojo.html;
_6b5=dojo.byId(_6b5);
_6b6=dojo.byId(_6b6);
var _6bb=h.toCoordinateObject(_6b5,true);
var _6bc=document.createElement("div");
h.copyStyle(_6bc,_6b6);
if(_6b6.explodeClassName){
_6bc.className=_6b6.explodeClassName;
}
with(_6bc.style){
position="absolute";
display="none";
var _6bd=h.getStyle(_6b5,"background-color");
backgroundColor=_6bd?_6bd.toLowerCase():"transparent";
backgroundColor=(backgroundColor=="transparent")?"rgb(221, 221, 221)":backgroundColor;
}
dojo.body().appendChild(_6bc);
with(_6b6.style){
visibility="hidden";
display="block";
}
var _6be=h.toCoordinateObject(_6b6,true);
with(_6b6.style){
display="none";
visibility="visible";
}
var _6bf={opacity:{start:0.5,end:1}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_6bf[type]={start:_6bb[type],end:_6be[type]};
});
var anim=new dojo.lfx.propertyAnimation(_6bc,_6bf,_6b7,_6b8,{"beforeBegin":function(){
h.setDisplay(_6bc,"block");
},"onEnd":function(){
h.setDisplay(_6b6,"block");
_6bc.parentNode.removeChild(_6bc);
}});
if(_6b9){
anim.connect("onEnd",function(){
_6b9(_6b6,anim);
});
}
return anim;
};
dojo.lfx.html.implode=function(_6c2,end,_6c4,_6c5,_6c6){
var h=dojo.html;
_6c2=dojo.byId(_6c2);
end=dojo.byId(end);
var _6c8=dojo.html.toCoordinateObject(_6c2,true);
var _6c9=dojo.html.toCoordinateObject(end,true);
var _6ca=document.createElement("div");
dojo.html.copyStyle(_6ca,_6c2);
if(_6c2.explodeClassName){
_6ca.className=_6c2.explodeClassName;
}
dojo.html.setOpacity(_6ca,0.3);
with(_6ca.style){
position="absolute";
display="none";
backgroundColor=h.getStyle(_6c2,"background-color").toLowerCase();
}
dojo.body().appendChild(_6ca);
var _6cb={opacity:{start:1,end:0.5}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_6cb[type]={start:_6c8[type],end:_6c9[type]};
});
var anim=new dojo.lfx.propertyAnimation(_6ca,_6cb,_6c4,_6c5,{"beforeBegin":function(){
dojo.html.hide(_6c2);
dojo.html.show(_6ca);
},"onEnd":function(){
_6ca.parentNode.removeChild(_6ca);
}});
if(_6c6){
anim.connect("onEnd",function(){
_6c6(_6c2,anim);
});
}
return anim;
};
dojo.lfx.html.highlight=function(_6ce,_6cf,_6d0,_6d1,_6d2){
_6ce=dojo.lfx.html._byId(_6ce);
var _6d3=[];
dojo.lang.forEach(_6ce,function(node){
var _6d5=dojo.html.getBackgroundColor(node);
var bg=dojo.html.getStyle(node,"background-color").toLowerCase();
var _6d7=dojo.html.getStyle(node,"background-image");
var _6d8=(bg=="transparent"||bg=="rgba(0, 0, 0, 0)");
while(_6d5.length>3){
_6d5.pop();
}
var rgb=new dojo.gfx.color.Color(_6cf);
var _6da=new dojo.gfx.color.Color(_6d5);
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:rgb,end:_6da}},_6d0,_6d1,{"beforeBegin":function(){
if(_6d7){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+rgb.toRgb().join(",")+")";
},"onEnd":function(){
if(_6d7){
node.style.backgroundImage=_6d7;
}
if(_6d8){
node.style.backgroundColor="transparent";
}
if(_6d2){
_6d2(node,anim);
}
}});
_6d3.push(anim);
});
return dojo.lfx.combine(_6d3);
};
dojo.lfx.html.unhighlight=function(_6dc,_6dd,_6de,_6df,_6e0){
_6dc=dojo.lfx.html._byId(_6dc);
var _6e1=[];
dojo.lang.forEach(_6dc,function(node){
var _6e3=new dojo.gfx.color.Color(dojo.html.getBackgroundColor(node));
var rgb=new dojo.gfx.color.Color(_6dd);
var _6e5=dojo.html.getStyle(node,"background-image");
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:_6e3,end:rgb}},_6de,_6df,{"beforeBegin":function(){
if(_6e5){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+_6e3.toRgb().join(",")+")";
},"onEnd":function(){
if(_6e0){
_6e0(node,anim);
}
}});
_6e1.push(anim);
});
return dojo.lfx.combine(_6e1);
};
dojo.lang.mixin(dojo.lfx,dojo.lfx.html);
dojo.kwCompoundRequire({browser:["dojo.lfx.html"],dashboard:["dojo.lfx.html"]});
dojo.provide("dojo.lfx.*");
dojo.provide("dojo.lfx.toggle");
dojo.lfx.toggle.plain={show:function(node,_6e8,_6e9,_6ea){
dojo.html.show(node);
if(dojo.lang.isFunction(_6ea)){
_6ea();
}
},hide:function(node,_6ec,_6ed,_6ee){
dojo.html.hide(node);
if(dojo.lang.isFunction(_6ee)){
_6ee();
}
}};
dojo.lfx.toggle.fade={show:function(node,_6f0,_6f1,_6f2){
dojo.lfx.fadeShow(node,_6f0,_6f1,_6f2).play();
},hide:function(node,_6f4,_6f5,_6f6){
dojo.lfx.fadeHide(node,_6f4,_6f5,_6f6).play();
}};
dojo.lfx.toggle.wipe={show:function(node,_6f8,_6f9,_6fa){
dojo.lfx.wipeIn(node,_6f8,_6f9,_6fa).play();
},hide:function(node,_6fc,_6fd,_6fe){
dojo.lfx.wipeOut(node,_6fc,_6fd,_6fe).play();
}};
dojo.lfx.toggle.explode={show:function(node,_700,_701,_702,_703){
dojo.lfx.explode(_703||{x:0,y:0,width:0,height:0},node,_700,_701,_702).play();
},hide:function(node,_705,_706,_707,_708){
dojo.lfx.implode(node,_708||{x:0,y:0,width:0,height:0},_705,_706,_707).play();
}};
dojo.provide("dojo.widget.HtmlWidget");
dojo.declare("dojo.widget.HtmlWidget",dojo.widget.DomWidget,{templateCssPath:null,templatePath:null,lang:"",toggle:"plain",toggleDuration:150,initialize:function(args,frag){
},postMixInProperties:function(args,frag){
if(this.lang===""){
this.lang=null;
}
this.toggleObj=dojo.lfx.toggle[this.toggle.toLowerCase()]||dojo.lfx.toggle.plain;
},createNodesFromText:function(txt,wrap){
return dojo.html.createNodesFromText(txt,wrap);
},destroyRendering:function(_70f){
try{
if(this.bgIframe){
this.bgIframe.remove();
delete this.bgIframe;
}
if(!_70f&&this.domNode){
dojo.event.browser.clean(this.domNode);
}
dojo.widget.HtmlWidget.superclass.destroyRendering.call(this);
}
catch(e){
}
},isShowing:function(){
return dojo.html.isShowing(this.domNode);
},toggleShowing:function(){
if(this.isShowing()){
this.hide();
}else{
this.show();
}
},show:function(){
if(this.isShowing()){
return;
}
this.animationInProgress=true;
this.toggleObj.show(this.domNode,this.toggleDuration,null,dojo.lang.hitch(this,this.onShow),this.explodeSrc);
},onShow:function(){
this.animationInProgress=false;
this.checkSize();
},hide:function(){
if(!this.isShowing()){
return;
}
this.animationInProgress=true;
this.toggleObj.hide(this.domNode,this.toggleDuration,null,dojo.lang.hitch(this,this.onHide),this.explodeSrc);
},onHide:function(){
this.animationInProgress=false;
},_isResized:function(w,h){
if(!this.isShowing()){
return false;
}
var wh=dojo.html.getMarginBox(this.domNode);
var _713=w||wh.width;
var _714=h||wh.height;
if(this.width==_713&&this.height==_714){
return false;
}
this.width=_713;
this.height=_714;
return true;
},checkSize:function(){
if(!this._isResized()){
return;
}
this.onResized();
},resizeTo:function(w,h){
dojo.html.setMarginBox(this.domNode,{width:w,height:h});
if(this.isShowing()){
this.onResized();
}
},resizeSoon:function(){
if(this.isShowing()){
dojo.lang.setTimeout(this,this.onResized,0);
}
},onResized:function(){
dojo.lang.forEach(this.children,function(_717){
if(_717.checkSize){
_717.checkSize();
}
});
}});
dojo.kwCompoundRequire({common:["dojo.xml.Parse","dojo.widget.Widget","dojo.widget.Parse","dojo.widget.Manager"],browser:["dojo.widget.DomWidget","dojo.widget.HtmlWidget"],dashboard:["dojo.widget.DomWidget","dojo.widget.HtmlWidget"],svg:["dojo.widget.SvgWidget"],rhino:["dojo.widget.SwtWidget"]});
dojo.provide("dojo.widget.*");
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_71e,_71f){
var out="";
for(var i=0;i<_71e;i++){
out+=str;
if(_71f&&i<_71e-1){
out+=_71f;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_72e,_72f,_730){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_72e){
this.mimetype=_72e;
}
if(_72f){
this.transport=_72f;
}
if(arguments.length>=4){
this.changeUrl=_730;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,load:function(type,data,_733,_734){
},error:function(type,_736,_737,_738){
},timeout:function(type,_73a,_73b,_73c){
},handle:function(type,data,_73f,_740){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_741){
if(_741["url"]){
_741.url=_741.url.toString();
}
if(_741["formNode"]){
_741.formNode=dojo.byId(_741.formNode);
}
if(!_741["method"]&&_741["formNode"]&&_741["formNode"].method){
_741.method=_741["formNode"].method;
}
if(!_741["handle"]&&_741["handler"]){
_741.handle=_741.handler;
}
if(!_741["load"]&&_741["loaded"]){
_741.load=_741.loaded;
}
if(!_741["changeUrl"]&&_741["changeURL"]){
_741.changeUrl=_741.changeURL;
}
_741.encoding=dojo.lang.firstValued(_741["encoding"],djConfig["bindEncoding"],"");
_741.sendTransport=dojo.lang.firstValued(_741["sendTransport"],djConfig["ioSendTransport"],false);
var _742=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_741[fn]&&_742(_741[fn])){
continue;
}
if(_741["handle"]&&_742(_741["handle"])){
_741[fn]=_741.handle;
}
}
dojo.lang.mixin(this,_741);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_749){
if(!(_749 instanceof dojo.io.Request)){
try{
_749=new dojo.io.Request(_749);
}
catch(e){
dojo.debug(e);
}
}
var _74a="";
if(_749["transport"]){
_74a=_749["transport"];
if(!this[_74a]){
dojo.io.sendBindError(_749,"No dojo.io.bind() transport with name '"+_749["transport"]+"'.");
return _749;
}
if(!this[_74a].canHandle(_749)){
dojo.io.sendBindError(_749,"dojo.io.bind() transport with name '"+_749["transport"]+"' cannot handle this type of request.");
return _749;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_749))){
_74a=tmp;
break;
}
}
if(_74a==""){
dojo.io.sendBindError(_749,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _749;
}
}
this[_74a].bind(_749);
_749.bindSuccess=true;
return _749;
};
dojo.io.sendBindError=function(_74d,_74e){
if((typeof _74d.error=="function"||typeof _74d.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _74f=new dojo.io.Error(_74e);
setTimeout(function(){
_74d[(typeof _74d.error=="function")?"error":"handle"]("error",_74f,null,_74d);
},50);
}else{
dojo.raise(_74e);
}
};
dojo.io.queueBind=function(_750){
if(!(_750 instanceof dojo.io.Request)){
try{
_750=new dojo.io.Request(_750);
}
catch(e){
dojo.debug(e);
}
}
var _751=_750.load;
_750.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_751.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _753=_750.error;
_750.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_753.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_750);
dojo.io._dispatchNextQueueBind();
return _750;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_756,last){
var enc=/utf/i.test(_756||"")?encodeURIComponent:dojo.string.encodeAscii;
var _759=[];
var _75a=new Object();
for(var name in map){
var _75c=function(elt){
var val=enc(name)+"="+enc(elt);
_759[(last==name)?"push":"unshift"](val);
};
if(!_75a[name]){
var _75f=map[name];
if(dojo.lang.isArray(_75f)){
dojo.lang.forEach(_75f,_75c);
}else{
_75c(_75f);
}
}
}
return _759.join("&");
};
dojo.io.setIFrameSrc=function(_760,src,_762){
try{
var r=dojo.render.html;
if(!_762){
if(r.safari){
_760.location=src;
}else{
frames[_760.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_760.contentWindow.document;
}else{
if(r.safari){
idoc=_760.document;
}else{
idoc=_760.contentWindow;
}
}
if(!idoc){
_760.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_765,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _765.replace(/\%\{(\w+)\}/g,function(_768,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _76b=str.split(" ");
for(var i=0;i<_76b.length;i++){
_76b[i]=_76b[i].charAt(0).toUpperCase()+_76b[i].substring(1);
}
return _76b.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _770=escape(str);
var _771,re=/%u([0-9A-F]{4})/i;
while((_771=_770.match(re))){
var num=Number("0x"+_771[1]);
var _774=escape("&#"+num+";");
ret+=_770.substring(0,_771.index)+_774;
_770=_770.substring(_771.index+_771[0].length);
}
ret+=_770.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_779){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_779){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_782){
if(_782){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_786,_787){
if(_787){
str=str.toLowerCase();
_786=_786.toLowerCase();
}
return str.indexOf(_786)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_78d){
if(_78d=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_78d=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_78f){
var _790=[];
for(var i=0,_792=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_78f){
_790.push(str.substring(_792,i));
_792=i+1;
}
}
_790.push(str.substr(_792));
return _790;
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:(!dj_undef("window"))?window.location.href:"",initialHash:(!dj_undef("window"))?window.location.hash:"",moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
if(djConfig["useXDomain"]&&!djConfig["dojoIframeHistoryUrl"]){
dojo.debug("dojo.undo.browser: When using cross-domain Dojo builds,"+" please save iframe_history.html to your domain and set djConfig.dojoIframeHistoryUrl"+" to the path on your domain to iframe_history.html");
}
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _797=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_799){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_797.apply(this,[_799]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _79a=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_79c){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_79a){
_79a.apply(this,[_79c]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_79f){
if(!dojo.render.html.opera){
var _7a0=this._getUrlQuery(_79f.href);
if(_7a0==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_7a0==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_7a0==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _7a1=this.historyStack.pop();
if(!_7a1){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_7a1);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _7a8=url.split("?");
if(_7a8.length<2){
return null;
}else{
return _7a8[1];
}
},_loadIframeHistory:function(){
var url=(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
if(!dj_undef("window")){
dojo.io.checkChildrenForFile=function(node){
var _7ab=false;
var _7ac=node.getElementsByTagName("input");
dojo.lang.forEach(_7ac,function(_7ad){
if(_7ab){
return;
}
if(_7ad.getAttribute("type")=="file"){
_7ab=true;
}
});
return _7ab;
};
dojo.io.formHasFile=function(_7ae){
return dojo.io.checkChildrenForFile(_7ae);
};
dojo.io.updateNode=function(node,_7b0){
node=dojo.byId(node);
var args=_7b0;
if(dojo.lang.isString(_7b0)){
args={url:_7b0};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
dojo.dom.destroyNode(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_7b7,_7b8,_7b9){
if((!_7b7)||(!_7b7.tagName)||(!_7b7.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_7b9){
_7b9=dojo.io.formFilter;
}
var enc=/utf/i.test(_7b8||"")?encodeURIComponent:dojo.string.encodeAscii;
var _7bb=[];
for(var i=0;i<_7b7.elements.length;i++){
var elm=_7b7.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_7b9(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_7bb.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_7bb.push(name+"="+enc(elm.value));
}
}else{
_7bb.push(name+"="+enc(elm.value));
}
}
}
var _7c1=_7b7.getElementsByTagName("input");
for(var i=0;i<_7c1.length;i++){
var _7c2=_7c1[i];
if(_7c2.type.toLowerCase()=="image"&&_7c2.form==_7b7&&_7b9(_7c2)){
var name=enc(_7c2.name);
_7bb.push(name+"="+enc(_7c2.value));
_7bb.push(name+".x=0");
_7bb.push(name+".y=0");
}
}
return _7bb.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _7c8=form.getElementsByTagName("input");
for(var i=0;i<_7c8.length;i++){
var _7c9=_7c8[i];
if(_7c9.type.toLowerCase()=="image"&&_7c9.form==form){
this.connect(_7c9,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _7d0=false;
if(node.disabled||!node.name){
_7d0=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_7d0=node==this.clickedButton;
}else{
_7d0=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _7d0;
},connect:function(_7d1,_7d2,_7d3){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_7d1,_7d2,this,_7d3);
}else{
var fcn=dojo.lang.hitch(this,_7d3);
_7d1[_7d2]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _7d6=this;
var _7d7={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_7d9,_7da){
return url+"|"+_7d9+"|"+_7da.toLowerCase();
}
function addToCache(url,_7dc,_7dd,http){
_7d7[getCacheKey(url,_7dc,_7dd)]=http;
}
function getFromCache(url,_7e0,_7e1){
return _7d7[getCacheKey(url,_7e0,_7e1)];
}
this.clearCache=function(){
_7d7={};
};
function doLoad(_7e2,http,url,_7e5,_7e6){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_7e2.method.toLowerCase()=="head"){
var _7e8=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _7e8;
};
var _7e9=_7e8.split(/[\r\n]+/g);
for(var i=0;i<_7e9.length;i++){
var pair=_7e9[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_7e2.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_7e2.mimetype=="text/json"||_7e2.mimetype=="application/json"){
try{
ret=dj_eval("("+http.responseText+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_7e2.mimetype=="application/xml")||(_7e2.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_7e6){
addToCache(url,_7e5,_7e2.method,http);
}
_7e2[(typeof _7e2.load=="function")?"load":"handle"]("load",ret,http,_7e2);
}else{
var _7ec=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_7e2[(typeof _7e2.error=="function")?"error":"handle"]("error",_7ec,http,_7e2);
}
}
function setHeaders(http,_7ee){
if(_7ee["headers"]){
for(var _7ef in _7ee["headers"]){
if(_7ef.toLowerCase()=="content-type"&&!_7ee["contentType"]){
_7ee["contentType"]=_7ee["headers"][_7ef];
}else{
http.setRequestHeader(_7ef,_7ee["headers"][_7ef]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_7d6._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _7f3=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_7f3,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _7f4=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_7f5){
return _7f4&&dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript","text/json","application/json"],(_7f5["mimetype"].toLowerCase()||""))&&!(_7f5["formNode"]&&dojo.io.formHasFile(_7f5["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_7f6){
if(!_7f6["url"]){
if(!_7f6["formNode"]&&(_7f6["backButton"]||_7f6["back"]||_7f6["changeUrl"]||_7f6["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_7f6);
return true;
}
}
var url=_7f6.url;
var _7f8="";
if(_7f6["formNode"]){
var ta=_7f6.formNode.getAttribute("action");
if((ta)&&(!_7f6["url"])){
url=ta;
}
var tp=_7f6.formNode.getAttribute("method");
if((tp)&&(!_7f6["method"])){
_7f6.method=tp;
}
_7f8+=dojo.io.encodeForm(_7f6.formNode,_7f6.encoding,_7f6["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_7f6["file"]){
_7f6.method="post";
}
if(!_7f6["method"]){
_7f6.method="get";
}
if(_7f6.method.toLowerCase()=="get"){
_7f6.multipart=false;
}else{
if(_7f6["file"]){
_7f6.multipart=true;
}else{
if(!_7f6["multipart"]){
_7f6.multipart=false;
}
}
}
if(_7f6["backButton"]||_7f6["back"]||_7f6["changeUrl"]){
dojo.undo.browser.addToHistory(_7f6);
}
var _7fb=_7f6["content"]||{};
if(_7f6.sendTransport){
_7fb["dojo.transport"]="xmlhttp";
}
do{
if(_7f6.postContent){
_7f8=_7f6.postContent;
break;
}
if(_7fb){
_7f8+=dojo.io.argsFromMap(_7fb,_7f6.encoding);
}
if(_7f6.method.toLowerCase()=="get"||!_7f6.multipart){
break;
}
var t=[];
if(_7f8.length){
var q=_7f8.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_7f6.file){
if(dojo.lang.isArray(_7f6.file)){
for(var i=0;i<_7f6.file.length;++i){
var o=_7f6.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_7f6.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_7f8=t.join("\r\n");
}
}while(false);
var _801=_7f6["sync"]?false:true;
var _802=_7f6["preventCache"]||(this.preventCache==true&&_7f6["preventCache"]!=false);
var _803=_7f6["useCache"]==true||(this.useCache==true&&_7f6["useCache"]!=false);
if(!_802&&_803){
var _804=getFromCache(url,_7f8,_7f6.method);
if(_804){
doLoad(_7f6,_804,url,_7f8,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_7f6);
var _806=false;
if(_801){
var _807=this.inFlight.push({"req":_7f6,"http":http,"url":url,"query":_7f8,"useCache":_803,"startTime":_7f6.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_7d6._blockAsync=true;
}
if(_7f6.method.toLowerCase()=="post"){
if(!_7f6.user){
http.open("POST",url,_801);
}else{
http.open("POST",url,_801,_7f6.user,_7f6.password);
}
setHeaders(http,_7f6);
http.setRequestHeader("Content-Type",_7f6.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_7f6.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_7f8);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_7f6,{status:404},url,_7f8,_803);
}
}else{
var _808=url;
if(_7f8!=""){
_808+=(_808.indexOf("?")>-1?"&":"?")+_7f8;
}
if(_802){
_808+=(dojo.string.endsWithAny(_808,"?","&")?"":(_808.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_7f6.user){
http.open(_7f6.method.toUpperCase(),_808,_801);
}else{
http.open(_7f6.method.toUpperCase(),_808,_801,_7f6.user,_7f6.password);
}
setHeaders(http,_7f6);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_7f6,{status:404},url,_7f8,_803);
}
}
if(!_801){
doLoad(_7f6,http,url,_7f8,_803);
_7d6._blockAsync=false;
}
_7f6.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
}
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_80a,days,path,_80d,_80e){
var _80f=-1;
if((typeof days=="number")&&(days>=0)){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_80f=d.toGMTString();
}
_80a=escape(_80a);
document.cookie=name+"="+_80a+";"+(_80f!=-1?" expires="+_80f+";":"")+(path?"path="+path:"")+(_80d?"; domain="+_80d:"")+(_80e?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _813=document.cookie.substring(idx+name.length+1);
var end=_813.indexOf(";");
if(end==-1){
end=_813.length;
}
_813=_813.substring(0,end);
_813=unescape(_813);
return _813;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_81a,_81b,_81c){
if(arguments.length==5){
_81c=_81a;
_81a=null;
_81b=null;
}
var _81d=[],_81e,_81f="";
if(!_81c){
_81e=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_81e){
_81e={};
}
for(var prop in obj){
if(obj[prop]==null){
delete _81e[prop];
}else{
if((typeof obj[prop]=="string")||(typeof obj[prop]=="number")){
_81e[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _81e){
_81d.push(escape(prop)+"="+escape(_81e[prop]));
}
_81f=_81d.join("&");
}
dojo.io.cookie.setCookie(name,_81f,days,path,_81a,_81b);
};
dojo.io.cookie.getObjectCookie=function(name){
var _822=null,_823=dojo.io.cookie.getCookie(name);
if(_823){
_822={};
var _824=_823.split("&");
for(var i=0;i<_824.length;i++){
var pair=_824[i].split("=");
var _827=pair[1];
if(isNaN(_827)){
_827=unescape(pair[1]);
}
_822[unescape(pair[0])]=_827;
}
}
return _822;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _828=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_828=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.kwCompoundRequire({common:["dojo.io.common"],rhino:["dojo.io.RhinoIO"],browser:["dojo.io.BrowserIO","dojo.io.cookie"],dashboard:["dojo.io.BrowserIO","dojo.io.cookie"]});
dojo.provide("dojo.io.*");
dojo.kwCompoundRequire({common:["dojo.html.common","dojo.html.style"]});
dojo.provide("dojo.html.*");
dojo.provide("dojo.html.selection");
dojo.html.selectionType={NONE:0,TEXT:1,CONTROL:2};
dojo.html.clearSelection=function(){
var _829=dojo.global();
var _82a=dojo.doc();
try{
if(_829["getSelection"]){
if(dojo.render.html.safari){
_829.getSelection().collapse();
}else{
_829.getSelection().removeAllRanges();
}
}else{
if(_82a.selection){
if(_82a.selection.empty){
_82a.selection.empty();
}else{
if(_82a.selection.clear){
_82a.selection.clear();
}
}
}
}
return true;
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.html.disableSelection=function(_82b){
_82b=dojo.byId(_82b)||dojo.body();
var h=dojo.render.html;
if(h.mozilla){
_82b.style.MozUserSelect="none";
}else{
if(h.safari){
_82b.style.KhtmlUserSelect="none";
}else{
if(h.ie){
_82b.unselectable="on";
}else{
return false;
}
}
}
return true;
};
dojo.html.enableSelection=function(_82d){
_82d=dojo.byId(_82d)||dojo.body();
var h=dojo.render.html;
if(h.mozilla){
_82d.style.MozUserSelect="";
}else{
if(h.safari){
_82d.style.KhtmlUserSelect="";
}else{
if(h.ie){
_82d.unselectable="off";
}else{
return false;
}
}
}
return true;
};
dojo.html.selectElement=function(_82f){
dojo.deprecated("dojo.html.selectElement","replaced by dojo.html.selection.selectElementChildren",0.5);
};
dojo.html.selectInputText=function(_830){
var _831=dojo.global();
var _832=dojo.doc();
_830=dojo.byId(_830);
if(_832["selection"]&&dojo.body()["createTextRange"]){
var _833=_830.createTextRange();
_833.moveStart("character",0);
_833.moveEnd("character",_830.value.length);
_833.select();
}else{
if(_831["getSelection"]){
var _834=_831.getSelection();
_830.setSelectionRange(0,_830.value.length);
}
}
_830.focus();
};
dojo.html.isSelectionCollapsed=function(){
dojo.deprecated("dojo.html.isSelectionCollapsed","replaced by dojo.html.selection.isCollapsed",0.5);
return dojo.html.selection.isCollapsed();
};
dojo.lang.mixin(dojo.html.selection,{getType:function(){
if(dojo.doc()["selection"]){
return dojo.html.selectionType[dojo.doc().selection.type.toUpperCase()];
}else{
var _835=dojo.html.selectionType.TEXT;
var oSel;
try{
oSel=dojo.global().getSelection();
}
catch(e){
}
if(oSel&&oSel.rangeCount==1){
var _837=oSel.getRangeAt(0);
if(_837.startContainer==_837.endContainer&&(_837.endOffset-_837.startOffset)==1&&_837.startContainer.nodeType!=dojo.dom.TEXT_NODE){
_835=dojo.html.selectionType.CONTROL;
}
}
return _835;
}
},isCollapsed:function(){
var _838=dojo.global();
var _839=dojo.doc();
if(_839["selection"]){
return _839.selection.createRange().text=="";
}else{
if(_838["getSelection"]){
var _83a=_838.getSelection();
if(dojo.lang.isString(_83a)){
return _83a=="";
}else{
return _83a.isCollapsed||_83a.toString()=="";
}
}
}
},getSelectedElement:function(){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
if(dojo.doc()["selection"]){
var _83b=dojo.doc().selection.createRange();
if(_83b&&_83b.item){
return dojo.doc().selection.createRange().item(0);
}
}else{
var _83c=dojo.global().getSelection();
return _83c.anchorNode.childNodes[_83c.anchorOffset];
}
}
},getParentElement:function(){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
var p=dojo.html.selection.getSelectedElement();
if(p){
return p.parentNode;
}
}else{
if(dojo.doc()["selection"]){
return dojo.doc().selection.createRange().parentElement();
}else{
var _83e=dojo.global().getSelection();
if(_83e){
var node=_83e.anchorNode;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.parentNode;
}
return node;
}
}
}
},getSelectedText:function(){
if(dojo.doc()["selection"]){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
return null;
}
return dojo.doc().selection.createRange().text;
}else{
var _840=dojo.global().getSelection();
if(_840){
return _840.toString();
}
}
},getSelectedHtml:function(){
if(dojo.doc()["selection"]){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
return null;
}
return dojo.doc().selection.createRange().htmlText;
}else{
var _841=dojo.global().getSelection();
if(_841&&_841.rangeCount){
var frag=_841.getRangeAt(0).cloneContents();
var div=document.createElement("div");
div.appendChild(frag);
return div.innerHTML;
}
return null;
}
},hasAncestorElement:function(_844){
return (dojo.html.selection.getAncestorElement.apply(this,arguments)!=null);
},getAncestorElement:function(_845){
var node=dojo.html.selection.getSelectedElement()||dojo.html.selection.getParentElement();
while(node){
if(dojo.html.selection.isTag(node,arguments).length>0){
return node;
}
node=node.parentNode;
}
return null;
},isTag:function(node,tags){
if(node&&node.tagName){
for(var i=0;i<tags.length;i++){
if(node.tagName.toLowerCase()==String(tags[i]).toLowerCase()){
return String(tags[i]).toLowerCase();
}
}
}
return "";
},selectElement:function(_84a){
var _84b=dojo.global();
var _84c=dojo.doc();
_84a=dojo.byId(_84a);
if(_84c.selection&&dojo.body().createTextRange){
try{
var _84d=dojo.body().createControlRange();
_84d.addElement(_84a);
_84d.select();
}
catch(e){
dojo.html.selection.selectElementChildren(_84a);
}
}else{
if(_84b["getSelection"]){
var _84e=_84b.getSelection();
if(_84e["removeAllRanges"]){
var _84d=_84c.createRange();
_84d.selectNode(_84a);
_84e.removeAllRanges();
_84e.addRange(_84d);
}
}
}
},selectElementChildren:function(_84f){
var _850=dojo.global();
var _851=dojo.doc();
_84f=dojo.byId(_84f);
if(_851.selection&&dojo.body().createTextRange){
var _852=dojo.body().createTextRange();
_852.moveToElementText(_84f);
_852.select();
}else{
if(_850["getSelection"]){
var _853=_850.getSelection();
if(_853["setBaseAndExtent"]){
_853.setBaseAndExtent(_84f,0,_84f,_84f.innerText.length-1);
}else{
if(_853["selectAllChildren"]){
_853.selectAllChildren(_84f);
}
}
}
}
},getBookmark:function(){
var _854;
var _855=dojo.doc();
if(_855["selection"]){
var _856=_855.selection.createRange();
_854=_856.getBookmark();
}else{
var _857;
try{
_857=dojo.global().getSelection();
}
catch(e){
}
if(_857){
var _856=_857.getRangeAt(0);
_854=_856.cloneRange();
}else{
dojo.debug("No idea how to store the current selection for this browser!");
}
}
return _854;
},moveToBookmark:function(_858){
var _859=dojo.doc();
if(_859["selection"]){
var _85a=_859.selection.createRange();
_85a.moveToBookmark(_858);
_85a.select();
}else{
var _85b;
try{
_85b=dojo.global().getSelection();
}
catch(e){
}
if(_85b&&_85b["removeAllRanges"]){
_85b.removeAllRanges();
_85b.addRange(_858);
}else{
dojo.debug("No idea how to restore selection for this browser!");
}
}
},collapse:function(_85c){
if(dojo.global()["getSelection"]){
var _85d=dojo.global().getSelection();
if(_85d.removeAllRanges){
if(_85c){
_85d.collapseToStart();
}else{
_85d.collapseToEnd();
}
}else{
dojo.global().getSelection().collapse(_85c);
}
}else{
if(dojo.doc().selection){
var _85e=dojo.doc().selection.createRange();
_85e.collapse(_85c);
_85e.select();
}
}
},remove:function(){
if(dojo.doc().selection){
var _85f=dojo.doc().selection;
if(_85f.type.toUpperCase()!="NONE"){
_85f.clear();
}
return _85f;
}else{
var _85f=dojo.global().getSelection();
for(var i=0;i<_85f.rangeCount;i++){
_85f.getRangeAt(i).deleteContents();
}
return _85f;
}
}});
dojo.provide("dojo.Deferred");
dojo.Deferred=function(_861){
this.chain=[];
this.id=this._nextId();
this.fired=-1;
this.paused=0;
this.results=[null,null];
this.canceller=_861;
this.silentlyCancelled=false;
};
dojo.lang.extend(dojo.Deferred,{getFunctionFromArgs:function(){
var a=arguments;
if((a[0])&&(!a[1])){
if(dojo.lang.isFunction(a[0])){
return a[0];
}else{
if(dojo.lang.isString(a[0])){
return dj_global[a[0]];
}
}
}else{
if((a[0])&&(a[1])){
return dojo.lang.hitch(a[0],a[1]);
}
}
return null;
},makeCalled:function(){
var _863=new dojo.Deferred();
_863.callback();
return _863;
},repr:function(){
var _864;
if(this.fired==-1){
_864="unfired";
}else{
if(this.fired==0){
_864="success";
}else{
_864="error";
}
}
return "Deferred("+this.id+", "+_864+")";
},toString:dojo.lang.forward("repr"),_nextId:(function(){
var n=1;
return function(){
return n++;
};
})(),cancel:function(){
if(this.fired==-1){
if(this.canceller){
this.canceller(this);
}else{
this.silentlyCancelled=true;
}
if(this.fired==-1){
this.errback(new Error(this.repr()));
}
}else{
if((this.fired==0)&&(this.results[0] instanceof dojo.Deferred)){
this.results[0].cancel();
}
}
},_pause:function(){
this.paused++;
},_unpause:function(){
this.paused--;
if((this.paused==0)&&(this.fired>=0)){
this._fire();
}
},_continue:function(res){
this._resback(res);
this._unpause();
},_resback:function(res){
this.fired=((res instanceof Error)?1:0);
this.results[this.fired]=res;
this._fire();
},_check:function(){
if(this.fired!=-1){
if(!this.silentlyCancelled){
dojo.raise("already called!");
}
this.silentlyCancelled=false;
return;
}
},callback:function(res){
this._check();
this._resback(res);
},errback:function(res){
this._check();
if(!(res instanceof Error)){
res=new Error(res);
}
this._resback(res);
},addBoth:function(cb,cbfn){
var _86c=this.getFunctionFromArgs(cb,cbfn);
if(arguments.length>2){
_86c=dojo.lang.curryArguments(null,_86c,arguments,2);
}
return this.addCallbacks(_86c,_86c);
},addCallback:function(cb,cbfn){
var _86f=this.getFunctionFromArgs(cb,cbfn);
if(arguments.length>2){
_86f=dojo.lang.curryArguments(null,_86f,arguments,2);
}
return this.addCallbacks(_86f,null);
},addErrback:function(cb,cbfn){
var _872=this.getFunctionFromArgs(cb,cbfn);
if(arguments.length>2){
_872=dojo.lang.curryArguments(null,_872,arguments,2);
}
return this.addCallbacks(null,_872);
return this.addCallbacks(null,cbfn);
},addCallbacks:function(cb,eb){
this.chain.push([cb,eb]);
if(this.fired>=0){
this._fire();
}
return this;
},_fire:function(){
var _875=this.chain;
var _876=this.fired;
var res=this.results[_876];
var self=this;
var cb=null;
while(_875.length>0&&this.paused==0){
var pair=_875.shift();
var f=pair[_876];
if(f==null){
continue;
}
try{
res=f(res);
_876=((res instanceof Error)?1:0);
if(res instanceof dojo.Deferred){
cb=function(res){
self._continue(res);
};
this._pause();
}
}
catch(err){
_876=1;
res=err;
}
}
this.fired=_876;
this.results[_876]=res;
if((cb)&&(this.paused)){
res.addBoth(cb);
}
}});
dojo.provide("dojo.widget.RichText");
if(!djConfig["useXDomain"]||djConfig["allowXdRichTextSave"]){
if(dojo.hostenv.post_load_){
(function(){
var _87d=dojo.doc().createElement("textarea");
_87d.id="dojo.widget.RichText.savedContent";
_87d.style="display:none;position:absolute;top:-100px;left:-100px;height:3px;width:3px;overflow:hidden;";
dojo.body().appendChild(_87d);
})();
}else{
try{
dojo.doc().write("<textarea id=\"dojo.widget.RichText.savedContent\" "+"style=\"display:none;position:absolute;top:-100px;left:-100px;height:3px;width:3px;overflow:hidden;\"></textarea>");
}
catch(e){
}
}
}
dojo.widget.defineWidget("dojo.widget.RichText",dojo.widget.HtmlWidget,function(){
this.contentPreFilters=[];
this.contentPostFilters=[];
this.contentDomPreFilters=[];
this.contentDomPostFilters=[];
this.editingAreaStyleSheets=[];
if(dojo.render.html.moz){
this.contentPreFilters.push(this._fixContentForMoz);
}
this._keyHandlers={};
if(dojo.Deferred){
this.onLoadDeferred=new dojo.Deferred();
}
},{inheritWidth:false,focusOnLoad:false,saveName:"",styleSheets:"",_content:"",height:"",minHeight:"1em",isClosed:true,isLoaded:false,useActiveX:false,relativeImageUrls:false,_SEPARATOR:"@@**%%__RICHTEXTBOUNDRY__%%**@@",onLoadDeferred:null,fillInTemplate:function(){
dojo.event.topic.publish("dojo.widget.RichText::init",this);
this.open();
dojo.event.connect(this,"onKeyPressed",this,"afterKeyPress");
dojo.event.connect(this,"onKeyPress",this,"keyPress");
dojo.event.connect(this,"onKeyDown",this,"keyDown");
dojo.event.connect(this,"onKeyUp",this,"keyUp");
this.setupDefaultShortcuts();
},setupDefaultShortcuts:function(){
var ctrl=this.KEY_CTRL;
var exec=function(cmd,arg){
return arguments.length==1?function(){
this.execCommand(cmd);
}:function(){
this.execCommand(cmd,arg);
};
};
this.addKeyHandler("b",ctrl,exec("bold"));
this.addKeyHandler("i",ctrl,exec("italic"));
this.addKeyHandler("u",ctrl,exec("underline"));
this.addKeyHandler("a",ctrl,exec("selectall"));
this.addKeyHandler("s",ctrl,function(){
this.save(true);
});
this.addKeyHandler("1",ctrl,exec("formatblock","h1"));
this.addKeyHandler("2",ctrl,exec("formatblock","h2"));
this.addKeyHandler("3",ctrl,exec("formatblock","h3"));
this.addKeyHandler("4",ctrl,exec("formatblock","h4"));
this.addKeyHandler("\\",ctrl,exec("insertunorderedlist"));
if(!dojo.render.html.ie){
this.addKeyHandler("Z",ctrl,exec("redo"));
}
},events:["onBlur","onFocus","onKeyPress","onKeyDown","onKeyUp","onClick"],open:function(_882){
if(this.onLoadDeferred.fired>=0){
this.onLoadDeferred=new dojo.Deferred();
}
var h=dojo.render.html;
if(!this.isClosed){
this.close();
}
dojo.event.topic.publish("dojo.widget.RichText::open",this);
this._content="";
if((arguments.length==1)&&(_882["nodeName"])){
this.domNode=_882;
}
if((this.domNode["nodeName"])&&(this.domNode.nodeName.toLowerCase()=="textarea")){
this.textarea=this.domNode;
var html=this._preFilterContent(this.textarea.value);
this.domNode=dojo.doc().createElement("div");
dojo.html.copyStyle(this.domNode,this.textarea);
var _885=dojo.lang.hitch(this,function(){
with(this.textarea.style){
display="block";
position="absolute";
left=top="-1000px";
if(h.ie){
this.__overflow=overflow;
overflow="hidden";
}
}
});
if(h.ie){
setTimeout(_885,10);
}else{
_885();
}
if(!h.safari){
dojo.html.insertBefore(this.domNode,this.textarea);
}
if(this.textarea.form){
dojo.event.connect("before",this.textarea.form,"onsubmit",dojo.lang.hitch(this,function(){
this.textarea.value=this.getEditorContent();
}));
}
var _886=this;
dojo.event.connect(this,"postCreate",function(){
dojo.html.insertAfter(_886.textarea,_886.domNode);
});
}else{
var html=this._preFilterContent(dojo.string.trim(this.domNode.innerHTML));
}
if(html==""){
html="&nbsp;";
}
var _887=dojo.html.getContentBox(this.domNode);
this._oldHeight=_887.height;
this._oldWidth=_887.width;
this._firstChildContributingMargin=this._getContributingMargin(this.domNode,"top");
this._lastChildContributingMargin=this._getContributingMargin(this.domNode,"bottom");
this.savedContent=html;
this.domNode.innerHTML="";
this.editingArea=dojo.doc().createElement("div");
this.domNode.appendChild(this.editingArea);
if((this.domNode["nodeName"])&&(this.domNode.nodeName=="LI")){
this.domNode.innerHTML=" <br>";
}
if(this.saveName!=""&&(!djConfig["useXDomain"]||djConfig["allowXdRichTextSave"])){
var _888=dojo.doc().getElementById("dojo.widget.RichText.savedContent");
if(_888.value!=""){
var _889=_888.value.split(this._SEPARATOR);
for(var i=0;i<_889.length;i++){
var data=_889[i].split(":");
if(data[0]==this.saveName){
html=data[1];
_889.splice(i,1);
break;
}
}
}
dojo.event.connect("before",window,"onunload",this,"_saveContent");
}
if(h.ie70&&this.useActiveX){
dojo.debug("activeX in ie70 is not currently supported, useActiveX is ignored for now.");
this.useActiveX=false;
}
if(this.useActiveX&&h.ie){
var self=this;
setTimeout(function(){
self._drawObject(html);
},0);
}else{
if(h.ie||this._safariIsLeopard()||h.opera){
this.iframe=dojo.doc().createElement("iframe");
this.iframe.src="javascript:void(0)";
this.editorObject=this.iframe;
with(this.iframe.style){
border="0";
width="100%";
}
this.iframe.frameBorder=0;
this.editingArea.appendChild(this.iframe);
this.window=this.iframe.contentWindow;
this.document=this.window.document;
this.document.open();
this.document.write("<html><head><style>body{margin:0;padding:0;border:0;overflow:hidden;}</style></head><body><div></div></body></html>");
this.document.close();
this.editNode=this.document.body.firstChild;
this.editNode.contentEditable=true;
with(this.iframe.style){
if(h.ie70){
if(this.height){
height=this.height;
}
if(this.minHeight){
minHeight=this.minHeight;
}
}else{
height=this.height?this.height:this.minHeight;
}
}
var _88d=["p","pre","address","h1","h2","h3","h4","h5","h6","ol","div","ul"];
var _88e="";
for(var i in _88d){
if(_88d[i].charAt(1)!="l"){
_88e+="<"+_88d[i]+"><span>content</span></"+_88d[i]+">";
}else{
_88e+="<"+_88d[i]+"><li>content</li></"+_88d[i]+">";
}
}
with(this.editNode.style){
position="absolute";
left="-2000px";
top="-2000px";
}
this.editNode.innerHTML=_88e;
var node=this.editNode.firstChild;
while(node){
dojo.withGlobal(this.window,"selectElement",dojo.html.selection,[node.firstChild]);
var _890=node.tagName.toLowerCase();
this._local2NativeFormatNames[_890]=this.queryCommandValue("formatblock");
this._native2LocalFormatNames[this._local2NativeFormatNames[_890]]=_890;
node=node.nextSibling;
}
with(this.editNode.style){
position="";
left="";
top="";
}
this.editNode.innerHTML=html;
if(this.height){
this.document.body.style.overflowY="scroll";
}
dojo.lang.forEach(this.events,function(e){
dojo.event.connect(this.editNode,e.toLowerCase(),this,e);
},this);
this.onLoad();
}else{
this._drawIframe(html);
this.editorObject=this.iframe;
}
}
if(this.domNode.nodeName=="LI"){
this.domNode.lastChild.style.marginTop="-1.2em";
}
dojo.html.addClass(this.domNode,"RichTextEditable");
this.isClosed=false;
},_hasCollapseableMargin:function(_892,side){
if(dojo.html.getPixelValue(_892,"border-"+side+"-width",false)){
return false;
}else{
if(dojo.html.getPixelValue(_892,"padding-"+side,false)){
return false;
}else{
return true;
}
}
},_getContributingMargin:function(_894,_895){
if(_895=="top"){
var _896="previousSibling";
var _897="nextSibling";
var _898="firstChild";
var _899="margin-top";
var _89a="margin-bottom";
}else{
var _896="nextSibling";
var _897="previousSibling";
var _898="lastChild";
var _899="margin-bottom";
var _89a="margin-top";
}
var _89b=dojo.html.getPixelValue(_894,_899,false);
function isSignificantNode(_89c){
return !(_89c.nodeType==3&&dojo.string.isBlank(_89c.data))&&dojo.html.getStyle(_89c,"display")!="none"&&!dojo.html.isPositionAbsolute(_89c);
}
var _89d=0;
var _89e=_894[_898];
while(_89e){
while((!isSignificantNode(_89e))&&_89e[_897]){
_89e=_89e[_897];
}
_89d=Math.max(_89d,dojo.html.getPixelValue(_89e,_899,false));
if(!this._hasCollapseableMargin(_89e,_895)){
break;
}
_89e=_89e[_898];
}
if(!this._hasCollapseableMargin(_894,_895)){
return parseInt(_89d);
}
var _89f=0;
var _8a0=_894[_896];
while(_8a0){
if(isSignificantNode(_8a0)){
_89f=dojo.html.getPixelValue(_8a0,_89a,false);
break;
}
_8a0=_8a0[_896];
}
if(!_8a0){
_89f=dojo.html.getPixelValue(_894.parentNode,_899,false);
}
if(_89d>_89b){
return parseInt(Math.max((_89d-_89b)-_89f,0));
}else{
return 0;
}
},_drawIframe:function(html){
var _8a2=Boolean(dojo.render.html.moz&&(typeof window.XML=="undefined"));
if(!this.iframe){
var _8a3=(new dojo.uri.Uri(dojo.doc().location)).host;
this.iframe=dojo.doc().createElement("iframe");
with(this.iframe){
style.border="none";
style.lineHeight="0";
style.verticalAlign="bottom";
scrolling=this.height?"auto":"no";
}
}
if(djConfig["useXDomain"]&&!djConfig["dojoRichTextFrameUrl"]){
dojo.debug("dojo.widget.RichText: When using cross-domain Dojo builds,"+" please save src/widget/templates/richtextframe.html to your domain and set djConfig.dojoRichTextFrameUrl"+" to the path on your domain to richtextframe.html");
}
this.iframe.src=(djConfig["dojoRichTextFrameUrl"]||dojo.uri.moduleUri("dojo.widget","templates/richtextframe.html"))+((dojo.doc().domain!=_8a3)?("#"+dojo.doc().domain):"");
this.iframe.width=this.inheritWidth?this._oldWidth:"100%";
if(this.height){
this.iframe.style.height=this.height;
}else{
var _8a4=this._oldHeight;
if(this._hasCollapseableMargin(this.domNode,"top")){
_8a4+=this._firstChildContributingMargin;
}
if(this._hasCollapseableMargin(this.domNode,"bottom")){
_8a4+=this._lastChildContributingMargin;
}
this.iframe.height=_8a4;
}
var _8a5=dojo.doc().createElement("div");
_8a5.innerHTML=html;
this.editingArea.appendChild(_8a5);
if(this.relativeImageUrls){
var imgs=_8a5.getElementsByTagName("img");
for(var i=0;i<imgs.length;i++){
imgs[i].src=(new dojo.uri.Uri(dojo.global().location,imgs[i].src)).toString();
}
html=_8a5.innerHTML;
}
var _8a8=dojo.html.firstElement(_8a5);
var _8a9=dojo.html.lastElement(_8a5);
if(_8a8){
_8a8.style.marginTop=this._firstChildContributingMargin+"px";
}
if(_8a9){
_8a9.style.marginBottom=this._lastChildContributingMargin+"px";
}
this.editingArea.appendChild(this.iframe);
if(dojo.render.html.safari){
this.iframe.src=this.iframe.src;
}
var _8aa=false;
var _8ab=dojo.lang.hitch(this,function(){
if(!_8aa){
_8aa=true;
}else{
return;
}
if(!this.editNode){
if(this.iframe.contentWindow){
this.window=this.iframe.contentWindow;
this.document=this.iframe.contentWindow.document;
}else{
if(this.iframe.contentDocument){
this.window=this.iframe.contentDocument.window;
this.document=this.iframe.contentDocument;
}
}
var _8ac=(function(_8ad){
return function(_8ae){
return dojo.html.getStyle(_8ad,_8ae);
};
})(this.domNode);
var font=_8ac("font-weight")+" "+_8ac("font-size")+" "+_8ac("font-family");
var _8b0="1.0";
var _8b1=dojo.html.getUnitValue(this.domNode,"line-height");
if(_8b1.value&&_8b1.units==""){
_8b0=_8b1.value;
}
dojo.html.insertCssText("body,html{background:transparent;padding:0;margin:0;}"+"body{top:0;left:0;right:0;"+(((this.height)||(dojo.render.html.opera))?"":"position:fixed;")+"font:"+font+";"+"min-height:"+this.minHeight+";"+"line-height:"+_8b0+"}"+"p{margin: 1em 0 !important;}"+"body > *:first-child{padding-top:0 !important;margin-top:"+this._firstChildContributingMargin+"px !important;}"+"body > *:last-child{padding-bottom:0 !important;margin-bottom:"+this._lastChildContributingMargin+"px !important;}"+"li > ul:-moz-first-node, li > ol:-moz-first-node{padding-top:1.2em;}\n"+"li{min-height:1.2em;}"+"",this.document);
dojo.html.removeNode(_8a5);
this.document.body.innerHTML=html;
if(_8a2||dojo.render.html.safari){
this.document.designMode="on";
}
this.onLoad();
}else{
dojo.html.removeNode(_8a5);
this.editNode.innerHTML=html;
this.onDisplayChanged();
}
});
if(this.editNode){
_8ab();
}else{
if(dojo.render.html.moz){
this.iframe.onload=function(){
setTimeout(_8ab,250);
};
}else{
this.iframe.onload=_8ab;
}
}
},_applyEditingAreaStyleSheets:function(){
var _8b2=[];
if(this.styleSheets){
_8b2=this.styleSheets.split(";");
this.styleSheets="";
}
_8b2=_8b2.concat(this.editingAreaStyleSheets);
this.editingAreaStyleSheets=[];
if(_8b2.length>0){
for(var i=0;i<_8b2.length;i++){
var url=_8b2[i];
if(url){
this.addStyleSheet(dojo.uri.dojoUri(url));
}
}
}
},addStyleSheet:function(uri){
var url=uri.toString();
if(dojo.lang.find(this.editingAreaStyleSheets,url)>-1){
dojo.debug("dojo.widget.RichText.addStyleSheet: Style sheet "+url+" is already applied to the editing area!");
return;
}
if(url.charAt(0)=="."||(url.charAt(0)!="/"&&!uri.host)){
url=(new dojo.uri.Uri(dojo.global().location,url)).toString();
}
this.editingAreaStyleSheets.push(url);
if(this.document.createStyleSheet){
this.document.createStyleSheet(url);
}else{
var head=this.document.getElementsByTagName("head")[0];
var _8b8=this.document.createElement("link");
with(_8b8){
rel="stylesheet";
type="text/css";
href=url;
}
head.appendChild(_8b8);
}
},removeStyleSheet:function(uri){
var url=uri.toString();
if(url.charAt(0)=="."||(url.charAt(0)!="/"&&!uri.host)){
url=(new dojo.uri.Uri(dojo.global().location,url)).toString();
}
var _8bb=dojo.lang.find(this.editingAreaStyleSheets,url);
if(_8bb==-1){
dojo.debug("dojo.widget.RichText.removeStyleSheet: Style sheet "+url+" is not applied to the editing area so it can not be removed!");
return;
}
delete this.editingAreaStyleSheets[_8bb];
var _8bc=this.document.getElementsByTagName("link");
for(var i=0;i<_8bc.length;i++){
if(_8bc[i].href==url){
if(dojo.render.html.ie){
_8bc[i].href="";
}
dojo.html.removeNode(_8bc[i]);
break;
}
}
},_drawObject:function(html){
this.object=dojo.html.createExternalElement(dojo.doc(),"object");
with(this.object){
classid="clsid:2D360201-FFF5-11D1-8D03-00A0C959BC0A";
width=this.inheritWidth?this._oldWidth:"100%";
style.height=this.height?this.height:(this._oldHeight+"px");
Scrollbars=this.height?true:false;
Appearance=this._activeX.appearance.flat;
}
this.editorObject=this.object;
this.editingArea.appendChild(this.object);
this.object.attachEvent("DocumentComplete",dojo.lang.hitch(this,"onLoad"));
dojo.lang.forEach(this.events,function(e){
this.object.attachEvent(e.toLowerCase(),dojo.lang.hitch(this,e));
},this);
this.object.DocumentHTML="<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">"+"<html><title></title>"+"<style type=\"text/css\">"+"    body,html { padding: 0; margin: 0; }"+(this.height?"":"    body,  { overflow: hidden; }")+"</style>"+"<body><div>"+html+"<div></body></html>";
this._cacheLocalBlockFormatNames();
},_local2NativeFormatNames:{},_native2LocalFormatNames:{},_cacheLocalBlockFormatNames:function(){
if(!this._native2LocalFormatNames["p"]){
var obj=this.object;
var _8c1=false;
if(!obj){
try{
obj=dojo.html.createExternalElement(dojo.doc(),"object");
obj.classid="clsid:2D360201-FFF5-11D1-8D03-00A0C959BC0A";
dojo.body().appendChild(obj);
obj.DocumentHTML="<html><head></head><body></body></html>";
}
catch(e){
_8c1=true;
}
}
try{
var _8c2=new ActiveXObject("DEGetBlockFmtNamesParam.DEGetBlockFmtNamesParam");
obj.ExecCommand(this._activeX.command["getblockformatnames"],0,_8c2);
var _8c3=new VBArray(_8c2.Names);
var _8c4=_8c3.toArray();
var _8c5=["p","pre","address","h1","h2","h3","h4","h5","h6","ol","ul","","","","","div"];
for(var i=0;i<_8c5.length;++i){
if(_8c5[i].length>0){
this._local2NativeFormatNames[_8c4[i]]=_8c5[i];
this._native2LocalFormatNames[_8c5[i]]=_8c4[i];
}
}
}
catch(e){
_8c1=true;
}
if(obj&&!this.object){
dojo.body().removeChild(obj);
}
}
return !_8c1;
},_isResized:function(){
return false;
},onLoad:function(e){
this.isLoaded=true;
if(this.object){
this.document=this.object.DOM;
this.window=this.document.parentWindow;
this.editNode=this.document.body.firstChild;
this.editingArea.style.height=this.height?this.height:this.minHeight;
if(!this.height){
this.connect(this,"onDisplayChanged","_updateHeight");
}
this.window._frameElement=this.object;
}else{
if(this.iframe&&!dojo.render.html.ie){
this.editNode=this.document.body;
if(!this.height){
this.connect(this,"onDisplayChanged","_updateHeight");
}
try{
this.document.execCommand("useCSS",false,true);
this.document.execCommand("styleWithCSS",false,false);
}
catch(e2){
}
if(dojo.render.html.safari){
this.connect(this.editNode,"onblur","onBlur");
this.connect(this.editNode,"onfocus","onFocus");
this.connect(this.editNode,"onclick","onFocus");
this.interval=setInterval(dojo.lang.hitch(this,"onDisplayChanged"),750);
}else{
if(dojo.render.html.mozilla||dojo.render.html.opera){
var doc=this.document;
var _8c9=dojo.event.browser.addListener;
var self=this;
dojo.lang.forEach(this.events,function(e){
var l=_8c9(self.document,e.substr(2).toLowerCase(),dojo.lang.hitch(self,e));
if(e=="onBlur"){
var _8cd={unBlur:function(e){
dojo.event.browser.removeListener(doc,"blur",l);
}};
dojo.event.connect("before",self,"close",_8cd,"unBlur");
}
});
}
}
}else{
if(dojo.render.html.ie){
if(!this.height){
this.connect(this,"onDisplayChanged","_updateHeight");
}
this.editNode.style.zoom=1;
}
}
}
this._applyEditingAreaStyleSheets();
if(this.focusOnLoad){
this.focus();
}
this.onDisplayChanged(e);
if(this.onLoadDeferred){
this.onLoadDeferred.callback(true);
}
},onKeyDown:function(e){
if((!e)&&(this.object)){
e=dojo.event.browser.fixEvent(this.window.event);
}
if((dojo.render.html.ie)&&(e.keyCode==e.KEY_TAB)){
e.preventDefault();
e.stopPropagation();
this.execCommand((e.shiftKey?"outdent":"indent"));
}else{
if(dojo.render.html.ie){
if((65<=e.keyCode)&&(e.keyCode<=90)){
e.charCode=e.keyCode;
this.onKeyPress(e);
}
}
}
},onKeyUp:function(e){
return;
},KEY_CTRL:1,onKeyPress:function(e){
if((!e)&&(this.object)){
e=dojo.event.browser.fixEvent(this.window.event);
}
var _8d2=e.ctrlKey?this.KEY_CTRL:0;
if(this._keyHandlers[e.key]){
var _8d3=this._keyHandlers[e.key],i=0,_8d5;
while(_8d5=_8d3[i++]){
if(_8d2==_8d5.modifiers){
e.preventDefault();
_8d5.handler.call(this);
break;
}
}
}
dojo.lang.setTimeout(this,this.onKeyPressed,1,e);
},addKeyHandler:function(key,_8d7,_8d8){
if(!(this._keyHandlers[key] instanceof Array)){
this._keyHandlers[key]=[];
}
this._keyHandlers[key].push({modifiers:_8d7||0,handler:_8d8});
},onKeyPressed:function(e){
this.onDisplayChanged();
},onClick:function(e){
this.onDisplayChanged(e);
},onBlur:function(e){
},_initialFocus:true,onFocus:function(e){
if((dojo.render.html.mozilla)&&(this._initialFocus)){
this._initialFocus=false;
if(dojo.string.trim(this.editNode.innerHTML)=="&nbsp;"){
this.placeCursorAtStart();
}
}
},blur:function(){
if(this.iframe){
this.window.blur();
}else{
if(this.object){
this.document.body.blur();
}else{
if(this.editNode){
this.editNode.blur();
}
}
}
},focus:function(){
if(this.iframe&&!dojo.render.html.ie){
this.window.focus();
}else{
if(this.object){
this.document.focus();
}else{
if(this.editNode&&this.editNode.focus){
this.editNode.focus();
}else{
dojo.debug("Have no idea how to focus into the editor!");
}
}
}
},onDisplayChanged:function(e){
},_activeX:{command:{bold:5000,italic:5023,underline:5048,justifycenter:5024,justifyleft:5025,justifyright:5026,cut:5003,copy:5002,paste:5032,"delete":5004,undo:5049,redo:5033,removeformat:5034,selectall:5035,unlink:5050,indent:5018,outdent:5031,insertorderedlist:5030,insertunorderedlist:5051,inserttable:5022,insertcell:5019,insertcol:5020,insertrow:5021,deletecells:5005,deletecols:5006,deleterows:5007,mergecells:5029,splitcell:5047,setblockformat:5043,getblockformat:5011,getblockformatnames:5012,setfontname:5044,getfontname:5013,setfontsize:5045,getfontsize:5014,setbackcolor:5042,getbackcolor:5010,setforecolor:5046,getforecolor:5015,findtext:5008,font:5009,hyperlink:5016,image:5017,lockelement:5027,makeabsolute:5028,sendbackward:5036,bringforward:5037,sendbelowtext:5038,bringabovetext:5039,sendtoback:5040,bringtofront:5041,properties:5052},ui:{"default":0,prompt:1,noprompt:2},status:{notsupported:0,disabled:1,enabled:3,latched:7,ninched:11},appearance:{flat:0,inset:1},state:{unchecked:0,checked:1,gray:2}},_normalizeCommand:function(cmd){
var drh=dojo.render.html;
var _8e0=cmd.toLowerCase();
if(_8e0=="formatblock"){
if(drh.safari){
_8e0="heading";
}
}else{
if(this.object){
switch(_8e0){
case "createlink":
_8e0="hyperlink";
break;
case "insertimage":
_8e0="image";
break;
}
}else{
if(_8e0=="hilitecolor"&&!drh.mozilla){
_8e0="backcolor";
}
}
}
return _8e0;
},_safariIsLeopard:function(){
var _8e1=false;
if(dojo.render.html.safari){
var tmp=dojo.render.html.UA.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
_8e1=true;
}
}
return _8e1;
},queryCommandAvailable:function(_8e4){
var ie=1;
var _8e6=1<<1;
var _8e7=1<<2;
var _8e8=1<<3;
var _8e9=1<<4;
var _8ea=this._safariIsLeopard();
function isSupportedBy(_8eb){
return {ie:Boolean(_8eb&ie),mozilla:Boolean(_8eb&_8e6),safari:Boolean(_8eb&_8e7),safari420:Boolean(_8eb&_8e9),opera:Boolean(_8eb&_8e8)};
}
var _8ec=null;
switch(_8e4.toLowerCase()){
case "bold":
case "italic":
case "underline":
case "subscript":
case "superscript":
case "fontname":
case "fontsize":
case "forecolor":
case "hilitecolor":
case "justifycenter":
case "justifyfull":
case "justifyleft":
case "justifyright":
case "delete":
case "selectall":
_8ec=isSupportedBy(_8e6|ie|_8e7|_8e8);
break;
case "createlink":
case "unlink":
case "removeformat":
case "inserthorizontalrule":
case "insertimage":
case "insertorderedlist":
case "insertunorderedlist":
case "indent":
case "outdent":
case "formatblock":
case "inserthtml":
case "undo":
case "redo":
case "strikethrough":
_8ec=isSupportedBy(_8e6|ie|_8e8|_8e9);
break;
case "blockdirltr":
case "blockdirrtl":
case "dirltr":
case "dirrtl":
case "inlinedirltr":
case "inlinedirrtl":
_8ec=isSupportedBy(ie);
break;
case "cut":
case "copy":
case "paste":
_8ec=isSupportedBy(ie|_8e6|_8e9);
break;
case "inserttable":
_8ec=isSupportedBy(_8e6|(this.object?ie:0));
break;
case "insertcell":
case "insertcol":
case "insertrow":
case "deletecells":
case "deletecols":
case "deleterows":
case "mergecells":
case "splitcell":
_8ec=isSupportedBy(this.object?ie:0);
break;
default:
return false;
}
return (dojo.render.html.ie&&_8ec.ie)||(dojo.render.html.mozilla&&_8ec.mozilla)||(dojo.render.html.safari&&_8ec.safari)||(_8ea&&_8ec.safari420)||(dojo.render.html.opera&&_8ec.opera);
},execCommand:function(_8ed,_8ee){
var _8ef;
this.focus();
_8ed=this._normalizeCommand(_8ed);
if(_8ee!=undefined){
if(_8ed=="heading"){
throw new Error("unimplemented");
}else{
if(_8ed=="formatblock"){
if(this.object){
_8ee=this._native2LocalFormatNames[_8ee];
}else{
if(dojo.render.html.ie){
_8ee="<"+_8ee+">";
}
}
}
}
}
if(this.object){
switch(_8ed){
case "hilitecolor":
_8ed="setbackcolor";
break;
case "forecolor":
case "backcolor":
case "fontsize":
case "fontname":
_8ed="set"+_8ed;
break;
case "formatblock":
_8ed="setblockformat";
}
if(_8ed=="strikethrough"){
_8ed="inserthtml";
var _8f0=this.document.selection.createRange();
if(!_8f0.htmlText){
return;
}
_8ee=_8f0.htmlText.strike();
}else{
if(_8ed=="inserthorizontalrule"){
_8ed="inserthtml";
_8ee="<hr>";
}
}
if(_8ed=="inserthtml"){
var _8f0=this.document.selection.createRange();
if(this.document.selection.type.toUpperCase()=="CONTROL"){
for(var i=0;i<_8f0.length;i++){
_8f0.item(i).outerHTML=_8ee;
}
}else{
_8f0.pasteHTML(_8ee);
_8f0.select();
}
_8ef=true;
}else{
if(arguments.length==1){
_8ef=this.object.ExecCommand(this._activeX.command[_8ed],this._activeX.ui.noprompt);
}else{
_8ef=this.object.ExecCommand(this._activeX.command[_8ed],this._activeX.ui.noprompt,_8ee);
}
}
}else{
if(_8ed=="inserthtml"){
if(dojo.render.html.ie){
var _8f2=this.document.selection.createRange();
_8f2.pasteHTML(_8ee);
_8f2.select();
return true;
}else{
return this.document.execCommand(_8ed,false,_8ee);
}
}else{
if((_8ed=="unlink")&&(this.queryCommandEnabled("unlink"))&&(dojo.render.html.mozilla)){
var _8f3=this.window.getSelection();
var _8f4=_8f3.getRangeAt(0);
var _8f5=_8f4.startContainer;
var _8f6=_8f4.startOffset;
var _8f7=_8f4.endContainer;
var _8f8=_8f4.endOffset;
var a=dojo.withGlobal(this.window,"getAncestorElement",dojo.html.selection,["a"]);
dojo.withGlobal(this.window,"selectElement",dojo.html.selection,[a]);
_8ef=this.document.execCommand("unlink",false,null);
var _8f4=this.document.createRange();
_8f4.setStart(_8f5,_8f6);
_8f4.setEnd(_8f7,_8f8);
_8f3.removeAllRanges();
_8f3.addRange(_8f4);
return _8ef;
}else{
if((_8ed=="hilitecolor")&&(dojo.render.html.mozilla)){
this.document.execCommand("useCSS",false,false);
_8ef=this.document.execCommand(_8ed,false,_8ee);
this.document.execCommand("useCSS",false,true);
}else{
if((dojo.render.html.ie)&&((_8ed=="backcolor")||(_8ed=="forecolor"))){
_8ee=arguments.length>1?_8ee:null;
_8ef=this.document.execCommand(_8ed,false,_8ee);
}else{
_8ee=arguments.length>1?_8ee:null;
if(_8ee||_8ed!="createlink"){
_8ef=this.document.execCommand(_8ed,false,_8ee);
}
}
}
}
}
}
this.onDisplayChanged();
return _8ef;
},queryCommandEnabled:function(_8fa){
_8fa=this._normalizeCommand(_8fa);
if(this.object){
switch(_8fa){
case "hilitecolor":
_8fa="setbackcolor";
break;
case "forecolor":
case "backcolor":
case "fontsize":
case "fontname":
_8fa="set"+_8fa;
break;
case "formatblock":
_8fa="setblockformat";
break;
case "strikethrough":
_8fa="bold";
break;
case "inserthorizontalrule":
return true;
}
if(typeof this._activeX.command[_8fa]=="undefined"){
return false;
}
var _8fb=this.object.QueryStatus(this._activeX.command[_8fa]);
return ((_8fb!=this._activeX.status.notsupported)&&(_8fb!=this._activeX.status.disabled));
}else{
if(dojo.render.html.mozilla){
if(_8fa=="unlink"){
return dojo.withGlobal(this.window,"hasAncestorElement",dojo.html.selection,["a"]);
}else{
if(_8fa=="inserttable"){
return true;
}
}
}
var elem=(dojo.render.html.ie)?this.document.selection.createRange():this.document;
return elem.queryCommandEnabled(_8fa);
}
},queryCommandState:function(_8fd){
_8fd=this._normalizeCommand(_8fd);
if(this.object){
if(_8fd=="forecolor"){
_8fd="setforecolor";
}else{
if(_8fd=="backcolor"){
_8fd="setbackcolor";
}else{
if(_8fd=="strikethrough"){
return dojo.withGlobal(this.window,"hasAncestorElement",dojo.html.selection,["strike"]);
}else{
if(_8fd=="inserthorizontalrule"){
return false;
}
}
}
}
if(typeof this._activeX.command[_8fd]=="undefined"){
return null;
}
var _8fe=this.object.QueryStatus(this._activeX.command[_8fd]);
return ((_8fe==this._activeX.status.latched)||(_8fe==this._activeX.status.ninched));
}else{
return this.document.queryCommandState(_8fd);
}
},queryCommandValue:function(_8ff){
_8ff=this._normalizeCommand(_8ff);
if(this.object){
switch(_8ff){
case "forecolor":
case "backcolor":
case "fontsize":
case "fontname":
_8ff="get"+_8ff;
return this.object.execCommand(this._activeX.command[_8ff],this._activeX.ui.noprompt);
case "formatblock":
var _900=this.object.execCommand(this._activeX.command["getblockformat"],this._activeX.ui.noprompt);
if(_900){
return this._local2NativeFormatNames[_900];
}
}
}else{
if(dojo.render.html.ie&&_8ff=="formatblock"){
return this._local2NativeFormatNames[this.document.queryCommandValue(_8ff)]||this.document.queryCommandValue(_8ff);
}
return this.document.queryCommandValue(_8ff);
}
},placeCursorAtStart:function(){
this.focus();
if(dojo.render.html.moz&&this.editNode.firstChild&&this.editNode.firstChild.nodeType!=dojo.dom.TEXT_NODE){
dojo.withGlobal(this.window,"selectElementChildren",dojo.html.selection,[this.editNode.firstChild]);
}else{
dojo.withGlobal(this.window,"selectElementChildren",dojo.html.selection,[this.editNode]);
}
dojo.withGlobal(this.window,"collapse",dojo.html.selection,[true]);
},placeCursorAtEnd:function(){
this.focus();
if(dojo.render.html.moz&&this.editNode.lastChild&&this.editNode.lastChild.nodeType!=dojo.dom.TEXT_NODE){
dojo.withGlobal(this.window,"selectElementChildren",dojo.html.selection,[this.editNode.lastChild]);
}else{
dojo.withGlobal(this.window,"selectElementChildren",dojo.html.selection,[this.editNode]);
}
dojo.withGlobal(this.window,"collapse",dojo.html.selection,[false]);
},replaceEditorContent:function(html){
html=this._preFilterContent(html);
if(this.isClosed){
this.domNode.innerHTML=html;
}else{
if(this.window&&this.window.getSelection&&!dojo.render.html.moz){
this.editNode.innerHTML=html;
}else{
if((this.window&&this.window.getSelection)||(this.document&&this.document.selection)){
this.execCommand("selectall");
if(dojo.render.html.moz&&!html){
html="&nbsp;";
}
this.execCommand("inserthtml",html);
}
}
}
},_preFilterContent:function(html){
var ec=html;
dojo.lang.forEach(this.contentPreFilters,function(ef){
ec=ef(ec);
});
if(this.contentDomPreFilters.length>0){
var dom=dojo.doc().createElement("div");
dom.style.display="none";
dojo.body().appendChild(dom);
dom.innerHTML=ec;
dojo.lang.forEach(this.contentDomPreFilters,function(ef){
dom=ef(dom);
});
ec=dom.innerHTML;
dojo.body().removeChild(dom);
}
return ec;
},_postFilterContent:function(html){
var ec=html;
if(this.contentDomPostFilters.length>0){
var dom=this.document.createElement("div");
dom.innerHTML=ec;
dojo.lang.forEach(this.contentDomPostFilters,function(ef){
dom=ef(dom);
});
ec=dom.innerHTML;
}
dojo.lang.forEach(this.contentPostFilters,function(ef){
ec=ef(ec);
});
return ec;
},_lastHeight:0,_updateHeight:function(){
if(!this.isLoaded){
return;
}
if(this.height){
return;
}
var _90c=dojo.html.getBorderBox(this.editNode).height;
if(!_90c){
_90c=dojo.html.getBorderBox(this.document.body).height;
}
if(_90c==0){
dojo.debug("Can not figure out the height of the editing area!");
return;
}
this._lastHeight=_90c;
this.editorObject.style.height=this._lastHeight+"px";
this.window.scrollTo(0,0);
},_saveContent:function(e){
var _90e=dojo.doc().getElementById("dojo.widget.RichText.savedContent");
_90e.value+=this._SEPARATOR+this.saveName+":"+this.getEditorContent();
},getEditorContent:function(){
var ec="";
try{
ec=(this._content.length>0)?this._content:this.editNode.innerHTML;
if(dojo.string.trim(ec)=="&nbsp;"){
ec="";
}
}
catch(e){
}
if(dojo.render.html.ie&&!this.object){
var re=new RegExp("(?:<p>&nbsp;</p>[\n\r]*)+$","i");
ec=ec.replace(re,"");
}
ec=this._postFilterContent(ec);
if(this.relativeImageUrls){
var _911=dojo.global().location.protocol+"//"+dojo.global().location.host;
var _912=dojo.global().location.pathname;
if(_912.match(/\/$/)){
}else{
var _913=_912.split("/");
if(_913.length){
_913.pop();
}
_912=_913.join("/")+"/";
}
var _914=new RegExp("(<img[^>]* src=[\"'])("+_911+"("+_912+")?)","ig");
ec=ec.replace(_914,"$1");
}
return ec;
},close:function(save,_916){
if(this.isClosed){
return false;
}
if(arguments.length==0){
save=true;
}
this._content=this._postFilterContent(this.editNode.innerHTML);
var _917=(this.savedContent!=this._content);
if(this.interval){
clearInterval(this.interval);
}
if(dojo.render.html.ie&&!this.object){
dojo.event.browser.clean(this.editNode);
}
if(this.iframe){
delete this.iframe;
}
if(this.textarea){
with(this.textarea.style){
position="";
left=top="";
if(dojo.render.html.ie){
overflow=this.__overflow;
this.__overflow=null;
}
}
if(save){
this.textarea.value=this._content;
}else{
this.textarea.value=this.savedContent;
}
dojo.html.removeNode(this.domNode);
this.domNode=this.textarea;
}else{
if(save){
if(dojo.render.html.moz){
var nc=dojo.doc().createElement("span");
this.domNode.appendChild(nc);
nc.innerHTML=this.editNode.innerHTML;
}else{
this.domNode.innerHTML=this._content;
}
}else{
this.domNode.innerHTML=this.savedContent;
}
}
dojo.html.removeClass(this.domNode,"RichTextEditable");
this.isClosed=true;
this.isLoaded=false;
delete this.editNode;
if(this.window._frameElement){
this.window._frameElement=null;
}
this.window=null;
this.document=null;
this.object=null;
this.editingArea=null;
this.editorObject=null;
return _917;
},destroyRendering:function(){
},destroy:function(){
this.destroyRendering();
if(!this.isClosed){
this.close(false);
}
dojo.widget.RichText.superclass.destroy.call(this);
},connect:function(_919,_91a,_91b){
dojo.event.connect(_919,_91a,this,_91b);
},disconnect:function(_91c,_91d,_91e){
dojo.event.disconnect(_91c,_91d,this,_91e);
},disconnectAllWithRoot:function(_91f){
dojo.deprecated("disconnectAllWithRoot","is deprecated. No need to disconnect manually","0.5");
},_fixContentForMoz:function(html){
html=html.replace(/<strong([ \>])/gi,"<b$1");
html=html.replace(/<\/strong>/gi,"</b>");
html=html.replace(/<em([ \>])/gi,"<i$1");
html=html.replace(/<\/em>/gi,"</i>");
return html;
}});
dojo.provide("dojo.lang.type");
dojo.lang.whatAmI=function(_921){
dojo.deprecated("dojo.lang.whatAmI","use dojo.lang.getType instead","0.5");
return dojo.lang.getType(_921);
};
dojo.lang.whatAmI.custom={};
dojo.lang.getType=function(_922){
try{
if(dojo.lang.isArray(_922)){
return "array";
}
if(dojo.lang.isFunction(_922)){
return "function";
}
if(dojo.lang.isString(_922)){
return "string";
}
if(dojo.lang.isNumber(_922)){
return "number";
}
if(dojo.lang.isBoolean(_922)){
return "boolean";
}
if(dojo.lang.isAlien(_922)){
return "alien";
}
if(dojo.lang.isUndefined(_922)){
return "undefined";
}
for(var name in dojo.lang.whatAmI.custom){
if(dojo.lang.whatAmI.custom[name](_922)){
return name;
}
}
if(dojo.lang.isObject(_922)){
return "object";
}
}
catch(e){
}
return "unknown";
};
dojo.lang.isNumeric=function(_924){
return (!isNaN(_924)&&isFinite(_924)&&(_924!=null)&&!dojo.lang.isBoolean(_924)&&!dojo.lang.isArray(_924)&&!/^\s*$/.test(_924));
};
dojo.lang.isBuiltIn=function(_925){
return (dojo.lang.isArray(_925)||dojo.lang.isFunction(_925)||dojo.lang.isString(_925)||dojo.lang.isNumber(_925)||dojo.lang.isBoolean(_925)||(_925==null)||(_925 instanceof Error)||(typeof _925=="error"));
};
dojo.lang.isPureObject=function(_926){
return ((_926!=null)&&dojo.lang.isObject(_926)&&_926.constructor==Object);
};
dojo.lang.isOfType=function(_927,type,_929){
var _92a=false;
if(_929){
_92a=_929["optional"];
}
if(_92a&&((_927===null)||dojo.lang.isUndefined(_927))){
return true;
}
if(dojo.lang.isArray(type)){
var _92b=type;
for(var i in _92b){
var _92d=_92b[i];
if(dojo.lang.isOfType(_927,_92d)){
return true;
}
}
return false;
}else{
if(dojo.lang.isString(type)){
type=type.toLowerCase();
}
switch(type){
case Array:
case "array":
return dojo.lang.isArray(_927);
case Function:
case "function":
return dojo.lang.isFunction(_927);
case String:
case "string":
return dojo.lang.isString(_927);
case Number:
case "number":
return dojo.lang.isNumber(_927);
case "numeric":
return dojo.lang.isNumeric(_927);
case Boolean:
case "boolean":
return dojo.lang.isBoolean(_927);
case Object:
case "object":
return dojo.lang.isObject(_927);
case "pureobject":
return dojo.lang.isPureObject(_927);
case "builtin":
return dojo.lang.isBuiltIn(_927);
case "alien":
return dojo.lang.isAlien(_927);
case "undefined":
return dojo.lang.isUndefined(_927);
case null:
case "null":
return (_927===null);
case "optional":
dojo.deprecated("dojo.lang.isOfType(value, [type, \"optional\"])","use dojo.lang.isOfType(value, type, {optional: true} ) instead","0.5");
return ((_927===null)||dojo.lang.isUndefined(_927));
default:
if(dojo.lang.isFunction(type)){
return (_927 instanceof type);
}else{
dojo.raise("dojo.lang.isOfType() was passed an invalid type");
}
}
}
dojo.raise("If we get here, it means a bug was introduced above.");
};
dojo.lang.getObject=function(str){
var _92f=str.split("."),i=0,obj=dj_global;
do{
obj=obj[_92f[i++]];
}while(i<_92f.length&&obj);
return (obj!=dj_global)?obj:null;
};
dojo.lang.doesObjectExist=function(str){
var _933=str.split("."),i=0,obj=dj_global;
do{
obj=obj[_933[i++]];
}while(i<_933.length&&obj);
return (obj&&obj!=dj_global);
};
dojo.provide("dojo.lang.assert");
dojo.lang.assert=function(_936,_937){
if(!_936){
var _938="An assert statement failed.\n"+"The method dojo.lang.assert() was called with a 'false' value.\n";
if(_937){
_938+="Here's the assert message:\n"+_937+"\n";
}
throw new Error(_938);
}
};
dojo.lang.assertType=function(_939,type,_93b){
if(dojo.lang.isString(_93b)){
dojo.deprecated("dojo.lang.assertType(value, type, \"message\")","use dojo.lang.assertType(value, type) instead","0.5");
}
if(!dojo.lang.isOfType(_939,type,_93b)){
if(!dojo.lang.assertType._errorMessage){
dojo.lang.assertType._errorMessage="Type mismatch: dojo.lang.assertType() failed.";
}
dojo.lang.assert(false,dojo.lang.assertType._errorMessage);
}
};
dojo.lang.assertValidKeywords=function(_93c,_93d,_93e){
var key;
if(!_93e){
if(!dojo.lang.assertValidKeywords._errorMessage){
dojo.lang.assertValidKeywords._errorMessage="In dojo.lang.assertValidKeywords(), found invalid keyword:";
}
_93e=dojo.lang.assertValidKeywords._errorMessage;
}
if(dojo.lang.isArray(_93d)){
for(key in _93c){
if(!dojo.lang.inArray(_93d,key)){
dojo.lang.assert(false,_93e+" "+key);
}
}
}else{
for(key in _93c){
if(!(key in _93d)){
dojo.lang.assert(false,_93e+" "+key);
}
}
}
};
dojo.provide("dojo.AdapterRegistry");
dojo.AdapterRegistry=function(_940){
this.pairs=[];
this.returnWrappers=_940||false;
};
dojo.lang.extend(dojo.AdapterRegistry,{register:function(name,_942,wrap,_944,_945){
var type=(_945)?"unshift":"push";
this.pairs[type]([name,_942,wrap,_944]);
},match:function(){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[1].apply(this,arguments)){
if((pair[3])||(this.returnWrappers)){
return pair[2];
}else{
return pair[2].apply(this,arguments);
}
}
}
throw new Error("No match found");
},unregister:function(name){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[0]==name){
this.pairs.splice(i,1);
return true;
}
}
return false;
}});
dojo.provide("dojo.lang.repr");
dojo.lang.reprRegistry=new dojo.AdapterRegistry();
dojo.lang.registerRepr=function(name,_94d,wrap,_94f){
dojo.lang.reprRegistry.register(name,_94d,wrap,_94f);
};
dojo.lang.repr=function(obj){
if(typeof (obj)=="undefined"){
return "undefined";
}else{
if(obj===null){
return "null";
}
}
try{
if(typeof (obj["__repr__"])=="function"){
return obj["__repr__"]();
}else{
if((typeof (obj["repr"])=="function")&&(obj.repr!=arguments.callee)){
return obj["repr"]();
}
}
return dojo.lang.reprRegistry.match(obj);
}
catch(e){
if(typeof (obj.NAME)=="string"&&(obj.toString==Function.prototype.toString||obj.toString==Object.prototype.toString)){
return obj.NAME;
}
}
if(typeof (obj)=="function"){
obj=(obj+"").replace(/^\s+/,"");
var idx=obj.indexOf("{");
if(idx!=-1){
obj=obj.substr(0,idx)+"{...}";
}
}
return obj+"";
};
dojo.lang.reprArrayLike=function(arr){
try{
var na=dojo.lang.map(arr,dojo.lang.repr);
return "["+na.join(", ")+"]";
}
catch(e){
}
};
(function(){
var m=dojo.lang;
m.registerRepr("arrayLike",m.isArrayLike,m.reprArrayLike);
m.registerRepr("string",m.isString,m.reprString);
m.registerRepr("numbers",m.isNumber,m.reprNumber);
m.registerRepr("boolean",m.isBoolean,m.reprNumber);
})();
dojo.kwCompoundRequire({common:["dojo.lang.common","dojo.lang.assert","dojo.lang.array","dojo.lang.type","dojo.lang.func","dojo.lang.extras","dojo.lang.repr","dojo.lang.declare"]});
dojo.provide("dojo.lang.*");
dojo.provide("dojo.html.iframe");
dojo.html.iframeContentWindow=function(_955){
var win=dojo.html.getDocumentWindow(dojo.html.iframeContentDocument(_955))||dojo.html.iframeContentDocument(_955).__parent__||(_955.name&&document.frames[_955.name])||null;
return win;
};
dojo.html.iframeContentDocument=function(_957){
var doc=_957.contentDocument||((_957.contentWindow)&&(_957.contentWindow.document))||((_957.name)&&(document.frames[_957.name])&&(document.frames[_957.name].document))||null;
return doc;
};
dojo.html.BackgroundIframe=function(node){
if(dojo.render.html.ie55||dojo.render.html.ie60){
var html="<iframe src='javascript:false'"+" style='position: absolute; left: 0px; top: 0px; width: 100%; height: 100%;"+"z-index: -1; filter:Alpha(Opacity=\"0\");' "+">";
this.iframe=dojo.doc().createElement(html);
this.iframe.tabIndex=-1;
if(node){
node.appendChild(this.iframe);
this.domNode=node;
}else{
dojo.body().appendChild(this.iframe);
this.iframe.style.display="none";
}
}
};
dojo.lang.extend(dojo.html.BackgroundIframe,{iframe:null,onResized:function(){
if(this.iframe&&this.domNode&&this.domNode.parentNode){
var _95b=dojo.html.getMarginBox(this.domNode);
if(_95b.width==0||_95b.height==0){
dojo.lang.setTimeout(this,this.onResized,100);
return;
}
this.iframe.style.width=_95b.width+"px";
this.iframe.style.height=_95b.height+"px";
}
},size:function(node){
if(!this.iframe){
return;
}
var _95d=dojo.html.toCoordinateObject(node,true,dojo.html.boxSizing.BORDER_BOX);
with(this.iframe.style){
width=_95d.width+"px";
height=_95d.height+"px";
left=_95d.left+"px";
top=_95d.top+"px";
}
},setZIndex:function(node){
if(!this.iframe){
return;
}
if(dojo.dom.isNode(node)){
this.iframe.style.zIndex=dojo.html.getStyle(node,"z-index")-1;
}else{
if(!isNaN(node)){
this.iframe.style.zIndex=node;
}
}
},show:function(){
if(this.iframe){
this.iframe.style.display="block";
}
},hide:function(){
if(this.iframe){
this.iframe.style.display="none";
}
},remove:function(){
if(this.iframe){
dojo.html.removeNode(this.iframe,true);
delete this.iframe;
this.iframe=null;
}
}});
dojo.provide("dojo.widget.PopupContainer");
dojo.declare("dojo.widget.PopupContainerBase",null,function(){
this.queueOnAnimationFinish=[];
},{isShowingNow:false,currentSubpopup:null,beginZIndex:1000,parentPopup:null,parent:null,popupIndex:0,aroundBox:dojo.html.boxSizing.BORDER_BOX,openedForWindow:null,processKey:function(evt){
return false;
},applyPopupBasicStyle:function(){
with(this.domNode.style){
display="none";
position="absolute";
}
},aboutToShow:function(){
},open:function(x,y,_962,_963,_964,_965){
if(this.isShowingNow){
return;
}
if(this.animationInProgress){
this.queueOnAnimationFinish.push(this.open,arguments);
return;
}
this.aboutToShow();
var _966=false,node,_968;
if(typeof x=="object"){
node=x;
_968=_963;
_963=_962;
_962=y;
_966=true;
}
this.parent=_962;
dojo.body().appendChild(this.domNode);
_963=_963||_962["domNode"]||[];
var _969=null;
this.isTopLevel=true;
while(_962){
if(_962!==this&&(_962.setOpenedSubpopup!=undefined&&_962.applyPopupBasicStyle!=undefined)){
_969=_962;
this.isTopLevel=false;
_969.setOpenedSubpopup(this);
break;
}
_962=_962.parent;
}
this.parentPopup=_969;
this.popupIndex=_969?_969.popupIndex+1:1;
if(this.isTopLevel){
var _96a=dojo.html.isNode(_963)?_963:null;
dojo.widget.PopupManager.opened(this,_96a);
}
if(this.isTopLevel&&!dojo.withGlobal(this.openedForWindow||dojo.global(),dojo.html.selection.isCollapsed)){
this._bookmark=dojo.withGlobal(this.openedForWindow||dojo.global(),dojo.html.selection.getBookmark);
}else{
this._bookmark=null;
}
if(_963 instanceof Array){
_963={left:_963[0],top:_963[1],width:0,height:0};
}
with(this.domNode.style){
display="";
zIndex=this.beginZIndex+this.popupIndex;
}
if(_966){
this.move(node,_965,_968);
}else{
this.move(x,y,_965,_964);
}
this.domNode.style.display="none";
this.explodeSrc=_963;
this.show();
this.isShowingNow=true;
},move:function(x,y,_96d,_96e){
var _96f=(typeof x=="object");
if(_96f){
var _970=_96d;
var node=x;
_96d=y;
if(!_970){
_970={"BL":"TL","TL":"BL"};
}
dojo.html.placeOnScreenAroundElement(this.domNode,node,_96d,this.aroundBox,_970);
}else{
if(!_96e){
_96e="TL,TR,BL,BR";
}
dojo.html.placeOnScreen(this.domNode,x,y,_96d,true,_96e);
}
},close:function(_972){
if(_972){
this.domNode.style.display="none";
}
if(this.animationInProgress){
this.queueOnAnimationFinish.push(this.close,[]);
return;
}
this.closeSubpopup(_972);
this.hide();
if(this.bgIframe){
this.bgIframe.hide();
this.bgIframe.size({left:0,top:0,width:0,height:0});
}
if(this.isTopLevel){
dojo.widget.PopupManager.closed(this);
}
this.isShowingNow=false;
if(this.parent){
setTimeout(dojo.lang.hitch(this,function(){
try{
if(this.parent["focus"]){
this.parent.focus();
}else{
this.parent.domNode.focus();
}
}
catch(e){
dojo.debug("No idea how to focus to parent",e);
}
}),10);
}
if(this._bookmark&&dojo.withGlobal(this.openedForWindow||dojo.global(),dojo.html.selection.isCollapsed)){
if(this.openedForWindow){
this.openedForWindow.focus();
}
try{
dojo.withGlobal(this.openedForWindow||dojo.global(),"moveToBookmark",dojo.html.selection,[this._bookmark]);
}
catch(e){
}
}
this._bookmark=null;
},closeAll:function(_973){
if(this.parentPopup){
this.parentPopup.closeAll(_973);
}else{
this.close(_973);
}
},setOpenedSubpopup:function(_974){
this.currentSubpopup=_974;
},closeSubpopup:function(_975){
if(this.currentSubpopup==null){
return;
}
this.currentSubpopup.close(_975);
this.currentSubpopup=null;
},onShow:function(){
dojo.widget.PopupContainer.superclass.onShow.apply(this,arguments);
this.openedSize={w:this.domNode.style.width,h:this.domNode.style.height};
if(dojo.render.html.ie){
if(!this.bgIframe){
this.bgIframe=new dojo.html.BackgroundIframe();
this.bgIframe.setZIndex(this.domNode);
}
this.bgIframe.size(this.domNode);
this.bgIframe.show();
}
this.processQueue();
},processQueue:function(){
if(!this.queueOnAnimationFinish.length){
return;
}
var func=this.queueOnAnimationFinish.shift();
var args=this.queueOnAnimationFinish.shift();
func.apply(this,args);
},onHide:function(){
dojo.widget.HtmlWidget.prototype.onHide.call(this);
if(this.openedSize){
with(this.domNode.style){
width=this.openedSize.w;
height=this.openedSize.h;
}
}
this.processQueue();
}});
dojo.widget.defineWidget("dojo.widget.PopupContainer",[dojo.widget.HtmlWidget,dojo.widget.PopupContainerBase],{isContainer:true,fillInTemplate:function(){
this.applyPopupBasicStyle();
dojo.widget.PopupContainer.superclass.fillInTemplate.apply(this,arguments);
}});
dojo.widget.PopupManager=new function(){
this.currentMenu=null;
this.currentButton=null;
this.currentFocusMenu=null;
this.focusNode=null;
this.registeredWindows=[];
this.registerWin=function(win){
if(!win.__PopupManagerRegistered){
dojo.event.connect(win.document,"onmousedown",this,"onClick");
dojo.event.connect(win,"onscroll",this,"onClick");
dojo.event.connect(win.document,"onkey",this,"onKey");
win.__PopupManagerRegistered=true;
this.registeredWindows.push(win);
}
};
this.registerAllWindows=function(_979){
if(!_979){
_979=dojo.html.getDocumentWindow(window.top&&window.top.document||window.document);
}
this.registerWin(_979);
for(var i=0;i<_979.frames.length;i++){
try{
var win=dojo.html.getDocumentWindow(_979.frames[i].document);
if(win){
this.registerAllWindows(win);
}
}
catch(e){
}
}
};
this.unRegisterWin=function(win){
if(win.__PopupManagerRegistered){
dojo.event.disconnect(win.document,"onmousedown",this,"onClick");
dojo.event.disconnect(win,"onscroll",this,"onClick");
dojo.event.disconnect(win.document,"onkey",this,"onKey");
win.__PopupManagerRegistered=false;
}
};
this.unRegisterAllWindows=function(){
for(var i=0;i<this.registeredWindows.length;++i){
this.unRegisterWin(this.registeredWindows[i]);
}
this.registeredWindows=[];
};
dojo.addOnLoad(this,"registerAllWindows");
dojo.addOnUnload(this,"unRegisterAllWindows");
this.closed=function(menu){
if(this.currentMenu==menu){
this.currentMenu=null;
this.currentButton=null;
this.currentFocusMenu=null;
}
};
this.opened=function(menu,_980){
if(menu==this.currentMenu){
return;
}
if(this.currentMenu){
this.currentMenu.close();
}
this.currentMenu=menu;
this.currentFocusMenu=menu;
this.currentButton=_980;
};
this.setFocusedMenu=function(menu){
this.currentFocusMenu=menu;
};
this.onKey=function(e){
if(!e.key){
return;
}
if(!this.currentMenu||!this.currentMenu.isShowingNow){
return;
}
var m=this.currentFocusMenu;
while(m){
if(m.processKey(e)){
e.preventDefault();
e.stopPropagation();
break;
}
m=m.parentPopup||m.parentMenu;
}
},this.onClick=function(e){
if(!this.currentMenu){
return;
}
var _985=dojo.html.getScroll().offset;
var m=this.currentMenu;
while(m){
if(dojo.html.overElement(m.domNode,e)||dojo.html.isDescendantOf(e.target,m.domNode)){
return;
}
m=m.currentSubpopup;
}
if(this.currentButton&&dojo.html.overElement(this.currentButton,e)){
return;
}
this.currentMenu.closeAll(true);
};
};
dojo.provide("dojo.widget.ColorPalette");
dojo.widget.defineWidget("dojo.widget.ColorPalette",dojo.widget.HtmlWidget,{palette:"7x10",_palettes:{"7x10":[["fff","fcc","fc9","ff9","ffc","9f9","9ff","cff","ccf","fcf"],["ccc","f66","f96","ff6","ff3","6f9","3ff","6ff","99f","f9f"],["c0c0c0","f00","f90","fc6","ff0","3f3","6cc","3cf","66c","c6c"],["999","c00","f60","fc3","fc0","3c0","0cc","36f","63f","c3c"],["666","900","c60","c93","990","090","399","33f","60c","939"],["333","600","930","963","660","060","366","009","339","636"],["000","300","630","633","330","030","033","006","309","303"]],"3x4":[["ffffff","00ff00","008000","0000ff"],["c0c0c0","ffff00","ff00ff","000080"],["808080","ff0000","800080","000000"]]},buildRendering:function(){
this.domNode=document.createElement("table");
dojo.html.disableSelection(this.domNode);
dojo.event.connect(this.domNode,"onmousedown",function(e){
e.preventDefault();
});
with(this.domNode){
cellPadding="0";
cellSpacing="1";
border="1";
style.backgroundColor="white";
}
var _988=this._palettes[this.palette];
for(var i=0;i<_988.length;i++){
var tr=this.domNode.insertRow(-1);
for(var j=0;j<_988[i].length;j++){
if(_988[i][j].length==3){
_988[i][j]=_988[i][j].replace(/(.)(.)(.)/,"$1$1$2$2$3$3");
}
var td=tr.insertCell(-1);
with(td.style){
backgroundColor="#"+_988[i][j];
border="1px solid gray";
width=height="15px";
fontSize="1px";
}
td.color="#"+_988[i][j];
td.onmouseover=function(e){
this.style.borderColor="white";
};
td.onmouseout=function(e){
this.style.borderColor="gray";
};
dojo.event.connect(td,"onmousedown",this,"onClick");
td.innerHTML="&nbsp;";
}
}
},onClick:function(e){
this.onColorSelect(e.currentTarget.color);
e.currentTarget.style.borderColor="gray";
},onColorSelect:function(_990){
}});
dojo.provide("dojo.widget.ContentPane");
dojo.widget.defineWidget("dojo.widget.ContentPane",dojo.widget.HtmlWidget,function(){
this._styleNodes=[];
this._onLoadStack=[];
this._onUnloadStack=[];
this._callOnUnload=false;
this._ioBindObj;
this.scriptScope;
this.bindArgs={};
},{isContainer:true,adjustPaths:true,href:"",extractContent:true,parseContent:true,cacheContent:true,preload:false,refreshOnShow:false,handler:"",executeScripts:false,scriptSeparation:true,loadingMessage:"Loading...",isLoaded:false,postCreate:function(args,frag,_993){
if(this.handler!==""){
this.setHandler(this.handler);
}
if(this.isShowing()||this.preload){
this.loadContents();
}
},show:function(){
if(this.refreshOnShow){
this.refresh();
}else{
this.loadContents();
}
dojo.widget.ContentPane.superclass.show.call(this);
},refresh:function(){
this.isLoaded=false;
this.loadContents();
},loadContents:function(){
if(this.isLoaded){
return;
}
if(dojo.lang.isFunction(this.handler)){
this._runHandler();
}else{
if(this.href!=""){
this._downloadExternalContent(this.href,this.cacheContent&&!this.refreshOnShow);
}
}
},setUrl:function(url){
this.href=url;
this.isLoaded=false;
if(this.preload||this.isShowing()){
this.loadContents();
}
},abort:function(){
var bind=this._ioBindObj;
if(!bind||!bind.abort){
return;
}
bind.abort();
delete this._ioBindObj;
},_downloadExternalContent:function(url,_997){
this.abort();
this._handleDefaults(this.loadingMessage,"onDownloadStart");
var self=this;
this._ioBindObj=dojo.io.bind(this._cacheSetting({url:url,mimetype:"text/html",handler:function(type,data,xhr){
delete self._ioBindObj;
if(type=="load"){
self.onDownloadEnd.call(self,url,data);
}else{
var e={responseText:xhr.responseText,status:xhr.status,statusText:xhr.statusText,responseHeaders:xhr.getAllResponseHeaders(),text:"Error loading '"+url+"' ("+xhr.status+" "+xhr.statusText+")"};
self._handleDefaults.call(self,e,"onDownloadError");
self.onLoad();
}
}},_997));
},_cacheSetting:function(_99d,_99e){
for(var x in this.bindArgs){
if(dojo.lang.isUndefined(_99d[x])){
_99d[x]=this.bindArgs[x];
}
}
if(dojo.lang.isUndefined(_99d.useCache)){
_99d.useCache=_99e;
}
if(dojo.lang.isUndefined(_99d.preventCache)){
_99d.preventCache=!_99e;
}
if(dojo.lang.isUndefined(_99d.mimetype)){
_99d.mimetype="text/html";
}
return _99d;
},onLoad:function(e){
this._runStack("_onLoadStack");
this.isLoaded=true;
},onUnLoad:function(e){
dojo.deprecated(this.widgetType+".onUnLoad, use .onUnload (lowercased load)",0.5);
},onUnload:function(e){
this._runStack("_onUnloadStack");
delete this.scriptScope;
if(this.onUnLoad!==dojo.widget.ContentPane.prototype.onUnLoad){
this.onUnLoad.apply(this,arguments);
}
},_runStack:function(_9a3){
var st=this[_9a3];
var err="";
var _9a6=this.scriptScope||window;
for(var i=0;i<st.length;i++){
try{
st[i].call(_9a6);
}
catch(e){
err+="\n"+st[i]+" failed: "+e.description;
}
}
this[_9a3]=[];
if(err.length){
var name=(_9a3=="_onLoadStack")?"addOnLoad":"addOnUnLoad";
this._handleDefaults(name+" failure\n "+err,"onExecError","debug");
}
},addOnLoad:function(obj,func){
this._pushOnStack(this._onLoadStack,obj,func);
},addOnUnload:function(obj,func){
this._pushOnStack(this._onUnloadStack,obj,func);
},addOnUnLoad:function(){
dojo.deprecated(this.widgetType+".addOnUnLoad, use addOnUnload instead. (lowercased Load)",0.5);
this.addOnUnload.apply(this,arguments);
},_pushOnStack:function(_9ad,obj,func){
if(typeof func=="undefined"){
_9ad.push(obj);
}else{
_9ad.push(function(){
obj[func]();
});
}
},destroy:function(){
this.onUnload();
dojo.widget.ContentPane.superclass.destroy.call(this);
},onExecError:function(e){
},onContentError:function(e){
},onDownloadError:function(e){
},onDownloadStart:function(e){
},onDownloadEnd:function(url,data){
data=this.splitAndFixPaths(data,url);
this.setContent(data);
},_handleDefaults:function(e,_9b7,_9b8){
if(!_9b7){
_9b7="onContentError";
}
if(dojo.lang.isString(e)){
e={text:e};
}
if(!e.text){
e.text=e.toString();
}
e.toString=function(){
return this.text;
};
if(typeof e.returnValue!="boolean"){
e.returnValue=true;
}
if(typeof e.preventDefault!="function"){
e.preventDefault=function(){
this.returnValue=false;
};
}
this[_9b7](e);
if(e.returnValue){
switch(_9b8){
case true:
case "alert":
alert(e.toString());
break;
case "debug":
dojo.debug(e.toString());
break;
default:
if(this._callOnUnload){
this.onUnload();
}
this._callOnUnload=false;
if(arguments.callee._loopStop){
dojo.debug(e.toString());
}else{
arguments.callee._loopStop=true;
this._setContent(e.toString());
}
}
}
arguments.callee._loopStop=false;
},splitAndFixPaths:function(s,url){
var _9bb=[],_9bc=[],tmp=[];
var _9be=[],_9bf=[],attr=[],_9c1=[];
var str="",path="",fix="",_9c5="",tag="",_9c7="";
if(!url){
url="./";
}
if(s){
var _9c8=/<title[^>]*>([\s\S]*?)<\/title>/i;
while(_9be=_9c8.exec(s)){
_9bb.push(_9be[1]);
s=s.substring(0,_9be.index)+s.substr(_9be.index+_9be[0].length);
}
if(this.adjustPaths){
var _9c9=/<[a-z][a-z0-9]*[^>]*\s(?:(?:src|href|style)=[^>])+[^>]*>/i;
var _9ca=/\s(src|href|style)=(['"]?)([\w()\[\]\/.,\\'"-:;#=&?\s@]+?)\2/i;
var _9cb=/^(?:[#]|(?:(?:https?|ftps?|file|javascript|mailto|news):))/;
while(tag=_9c9.exec(s)){
str+=s.substring(0,tag.index);
s=s.substring((tag.index+tag[0].length),s.length);
tag=tag[0];
_9c5="";
while(attr=_9ca.exec(tag)){
path="";
_9c7=attr[3];
switch(attr[1].toLowerCase()){
case "src":
case "href":
if(_9cb.exec(_9c7)){
path=_9c7;
}else{
path=(new dojo.uri.Uri(url,_9c7).toString());
}
break;
case "style":
path=dojo.html.fixPathsInCssText(_9c7,url);
break;
default:
path=_9c7;
}
fix=" "+attr[1]+"="+attr[2]+path+attr[2];
_9c5+=tag.substring(0,attr.index)+fix;
tag=tag.substring((attr.index+attr[0].length),tag.length);
}
str+=_9c5+tag;
}
s=str+s;
}
_9c8=/(?:<(style)[^>]*>([\s\S]*?)<\/style>|<link ([^>]*rel=['"]?stylesheet['"]?[^>]*)>)/i;
while(_9be=_9c8.exec(s)){
if(_9be[1]&&_9be[1].toLowerCase()=="style"){
_9c1.push(dojo.html.fixPathsInCssText(_9be[2],url));
}else{
if(attr=_9be[3].match(/href=(['"]?)([^'">]*)\1/i)){
_9c1.push({path:attr[2]});
}
}
s=s.substring(0,_9be.index)+s.substr(_9be.index+_9be[0].length);
}
var _9c8=/<script([^>]*)>([\s\S]*?)<\/script>/i;
var _9cc=/src=(['"]?)([^"']*)\1/i;
var _9cd=/.*(\bdojo\b\.js(?:\.uncompressed\.js)?)$/;
var _9ce=/(?:var )?\bdjConfig\b(?:[\s]*=[\s]*\{[^}]+\}|\.[\w]*[\s]*=[\s]*[^;\n]*)?;?|dojo\.hostenv\.writeIncludes\(\s*\);?/g;
var _9cf=/dojo\.(?:(?:require(?:After)?(?:If)?)|(?:widget\.(?:manager\.)?registerWidgetPackage)|(?:(?:hostenv\.)?setModulePrefix|registerModulePath)|defineNamespace)\((['"]).*?\1\)\s*;?/;
while(_9be=_9c8.exec(s)){
if(this.executeScripts&&_9be[1]){
if(attr=_9cc.exec(_9be[1])){
if(_9cd.exec(attr[2])){
dojo.debug("Security note! inhibit:"+attr[2]+" from  being loaded again.");
}else{
_9bc.push({path:attr[2]});
}
}
}
if(_9be[2]){
var sc=_9be[2].replace(_9ce,"");
if(!sc){
continue;
}
while(tmp=_9cf.exec(sc)){
_9bf.push(tmp[0]);
sc=sc.substring(0,tmp.index)+sc.substr(tmp.index+tmp[0].length);
}
if(this.executeScripts){
_9bc.push(sc);
}
}
s=s.substr(0,_9be.index)+s.substr(_9be.index+_9be[0].length);
}
if(this.extractContent){
_9be=s.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_9be){
s=_9be[1];
}
}
if(this.executeScripts&&this.scriptSeparation){
var _9c8=/(<[a-zA-Z][a-zA-Z0-9]*\s[^>]*?\S=)((['"])[^>]*scriptScope[^>]*>)/;
var _9d1=/([\s'";:\(])scriptScope(.*)/;
str="";
while(tag=_9c8.exec(s)){
tmp=((tag[3]=="'")?"\"":"'");
fix="";
str+=s.substring(0,tag.index)+tag[1];
while(attr=_9d1.exec(tag[2])){
tag[2]=tag[2].substring(0,attr.index)+attr[1]+"dojo.widget.byId("+tmp+this.widgetId+tmp+").scriptScope"+attr[2];
}
str+=tag[2];
s=s.substr(tag.index+tag[0].length);
}
s=str+s;
}
}
return {"xml":s,"styles":_9c1,"titles":_9bb,"requires":_9bf,"scripts":_9bc,"url":url};
},_setContent:function(cont){
this.destroyChildren();
for(var i=0;i<this._styleNodes.length;i++){
if(this._styleNodes[i]&&this._styleNodes[i].parentNode){
this._styleNodes[i].parentNode.removeChild(this._styleNodes[i]);
}
}
this._styleNodes=[];
try{
var node=this.containerNode||this.domNode;
while(node.firstChild){
dojo.html.destroyNode(node.firstChild);
}
if(typeof cont!="string"){
node.appendChild(cont);
}else{
node.innerHTML=cont;
}
}
catch(e){
e.text="Couldn't load content:"+e.description;
this._handleDefaults(e,"onContentError");
}
},setContent:function(data){
this.abort();
if(this._callOnUnload){
this.onUnload();
}
this._callOnUnload=true;
if(!data||dojo.html.isNode(data)){
this._setContent(data);
this.onResized();
this.onLoad();
}else{
if(typeof data.xml!="string"){
this.href="";
data=this.splitAndFixPaths(data);
}
this._setContent(data.xml);
for(var i=0;i<data.styles.length;i++){
if(data.styles[i].path){
this._styleNodes.push(dojo.html.insertCssFile(data.styles[i].path,dojo.doc(),false,true));
}else{
this._styleNodes.push(dojo.html.insertCssText(data.styles[i]));
}
}
if(this.parseContent){
for(var i=0;i<data.requires.length;i++){
try{
eval(data.requires[i]);
}
catch(e){
e.text="ContentPane: error in package loading calls, "+(e.description||e);
this._handleDefaults(e,"onContentError","debug");
}
}
}
var _9d7=this;
function asyncParse(){
if(_9d7.executeScripts){
_9d7._executeScripts(data.scripts);
}
if(_9d7.parseContent){
var node=_9d7.containerNode||_9d7.domNode;
var _9d9=new dojo.xml.Parse();
var frag=_9d9.parseElement(node,null,true);
dojo.widget.getParser().createSubComponents(frag,_9d7);
}
_9d7.onResized();
_9d7.onLoad();
}
if(dojo.hostenv.isXDomain&&data.requires.length){
dojo.addOnLoad(asyncParse);
}else{
asyncParse();
}
}
},setHandler:function(_9db){
var fcn=dojo.lang.isFunction(_9db)?_9db:window[_9db];
if(!dojo.lang.isFunction(fcn)){
this._handleDefaults("Unable to set handler, '"+_9db+"' not a function.","onExecError",true);
return;
}
this.handler=function(){
return fcn.apply(this,arguments);
};
},_runHandler:function(){
var ret=true;
if(dojo.lang.isFunction(this.handler)){
this.handler(this,this.domNode);
ret=false;
}
this.onLoad();
return ret;
},_executeScripts:function(_9de){
var self=this;
var tmp="",code="";
for(var i=0;i<_9de.length;i++){
if(_9de[i].path){
dojo.io.bind(this._cacheSetting({"url":_9de[i].path,"load":function(type,_9e4){
dojo.lang.hitch(self,tmp=";"+_9e4);
},"error":function(type,_9e6){
_9e6.text=type+" downloading remote script";
self._handleDefaults.call(self,_9e6,"onExecError","debug");
},"mimetype":"text/plain","sync":true},this.cacheContent));
code+=tmp;
}else{
code+=_9de[i];
}
}
try{
if(this.scriptSeparation){
delete this.scriptScope;
this.scriptScope=new (new Function("_container_",code+"; return this;"))(self);
}else{
var djg=dojo.global();
if(djg.execScript){
djg.execScript(code);
}else{
var djd=dojo.doc();
var sc=djd.createElement("script");
sc.appendChild(djd.createTextNode(code));
(this.containerNode||this.domNode).appendChild(sc);
}
}
}
catch(e){
e.text="Error running scripts from content:\n"+e.description;
this._handleDefaults(e,"onExecError","debug");
}
}});
dojo.provide("dojo.widget.Editor2Toolbar");
dojo.lang.declare("dojo.widget.HandlerManager",null,function(){
this._registeredHandlers=[];
},{registerHandler:function(obj,func){
if(arguments.length==2){
this._registeredHandlers.push(function(){
return obj[func].apply(obj,arguments);
});
}else{
this._registeredHandlers.push(obj);
}
},removeHandler:function(func){
for(var i=0;i<this._registeredHandlers.length;i++){
if(func===this._registeredHandlers[i]){
delete this._registeredHandlers[i];
return;
}
}
dojo.debug("HandlerManager handler "+func+" is not registered, can not remove.");
},destroy:function(){
for(var i=0;i<this._registeredHandlers.length;i++){
delete this._registeredHandlers[i];
}
}});
dojo.widget.Editor2ToolbarItemManager=new dojo.widget.HandlerManager;
dojo.lang.mixin(dojo.widget.Editor2ToolbarItemManager,{getToolbarItem:function(name){
var item;
name=name.toLowerCase();
for(var i=0;i<this._registeredHandlers.length;i++){
item=this._registeredHandlers[i](name);
if(item){
return item;
}
}
switch(name){
case "bold":
case "copy":
case "cut":
case "delete":
case "indent":
case "inserthorizontalrule":
case "insertorderedlist":
case "insertunorderedlist":
case "italic":
case "justifycenter":
case "justifyfull":
case "justifyleft":
case "justifyright":
case "outdent":
case "paste":
case "redo":
case "removeformat":
case "selectall":
case "strikethrough":
case "subscript":
case "superscript":
case "underline":
case "undo":
case "unlink":
case "createlink":
case "insertimage":
case "htmltoggle":
item=new dojo.widget.Editor2ToolbarButton(name);
break;
case "forecolor":
case "hilitecolor":
item=new dojo.widget.Editor2ToolbarColorPaletteButton(name);
break;
case "plainformatblock":
item=new dojo.widget.Editor2ToolbarFormatBlockPlainSelect("formatblock");
break;
case "formatblock":
item=new dojo.widget.Editor2ToolbarFormatBlockSelect("formatblock");
break;
case "fontsize":
item=new dojo.widget.Editor2ToolbarFontSizeSelect("fontsize");
break;
case "fontname":
item=new dojo.widget.Editor2ToolbarFontNameSelect("fontname");
break;
case "inserttable":
case "insertcell":
case "insertcol":
case "insertrow":
case "deletecells":
case "deletecols":
case "deleterows":
case "mergecells":
case "splitcell":
dojo.debug(name+" is implemented in dojo.widget.Editor2Plugin.TableOperation, please require it first.");
break;
case "inserthtml":
case "blockdirltr":
case "blockdirrtl":
case "dirltr":
case "dirrtl":
case "inlinedirltr":
case "inlinedirrtl":
dojo.debug("Not yet implemented toolbar item: "+name);
break;
default:
dojo.debug("dojo.widget.Editor2ToolbarItemManager.getToolbarItem: Unknown toolbar item: "+name);
}
return item;
}});
dojo.addOnUnload(dojo.widget.Editor2ToolbarItemManager,"destroy");
dojo.declare("dojo.widget.Editor2ToolbarButton",null,function(name){
this._name=name;
},{create:function(node,_9f4,_9f5){
this._domNode=node;
var cmd=_9f4.parent.getCommand(this._name);
if(cmd){
this._domNode.title=cmd.getText();
}
this.disableSelection(this._domNode);
this._parentToolbar=_9f4;
dojo.event.connect(this._domNode,"onclick",this,"onClick");
if(!_9f5){
dojo.event.connect(this._domNode,"onmouseover",this,"onMouseOver");
dojo.event.connect(this._domNode,"onmouseout",this,"onMouseOut");
}
},disableSelection:function(_9f7){
dojo.html.disableSelection(_9f7);
var _9f8=_9f7.all||_9f7.getElementsByTagName("*");
for(var x=0;x<_9f8.length;x++){
dojo.html.disableSelection(_9f8[x]);
}
},onMouseOver:function(){
var _9fa=dojo.widget.Editor2Manager.getCurrentInstance();
if(_9fa){
var _9fb=_9fa.getCommand(this._name);
if(_9fb&&_9fb.getState()!=dojo.widget.Editor2Manager.commandState.Disabled){
this.highlightToolbarItem();
}
}
},onMouseOut:function(){
this.unhighlightToolbarItem();
},destroy:function(){
this._domNode=null;
this._parentToolbar=null;
},onClick:function(e){
if(this._domNode&&!this._domNode.disabled&&this._parentToolbar.checkAvailability()){
e.preventDefault();
e.stopPropagation();
var _9fd=dojo.widget.Editor2Manager.getCurrentInstance();
if(_9fd){
var _9fe=_9fd.getCommand(this._name);
if(_9fe){
_9fe.execute();
}
}
}
},refreshState:function(){
var _9ff=dojo.widget.Editor2Manager.getCurrentInstance();
var em=dojo.widget.Editor2Manager;
if(_9ff){
var _a01=_9ff.getCommand(this._name);
if(_a01){
var _a02=_a01.getState();
if(_a02!=this._lastState){
switch(_a02){
case em.commandState.Latched:
this.latchToolbarItem();
break;
case em.commandState.Enabled:
this.enableToolbarItem();
break;
case em.commandState.Disabled:
default:
this.disableToolbarItem();
}
this._lastState=_a02;
}
}
}
return em.commandState.Enabled;
},latchToolbarItem:function(){
this._domNode.disabled=false;
this.removeToolbarItemStyle(this._domNode);
dojo.html.addClass(this._domNode,this._parentToolbar.ToolbarLatchedItemStyle);
},enableToolbarItem:function(){
this._domNode.disabled=false;
this.removeToolbarItemStyle(this._domNode);
dojo.html.addClass(this._domNode,this._parentToolbar.ToolbarEnabledItemStyle);
},disableToolbarItem:function(){
this._domNode.disabled=true;
this.removeToolbarItemStyle(this._domNode);
dojo.html.addClass(this._domNode,this._parentToolbar.ToolbarDisabledItemStyle);
},highlightToolbarItem:function(){
dojo.html.addClass(this._domNode,this._parentToolbar.ToolbarHighlightedItemStyle);
},unhighlightToolbarItem:function(){
dojo.html.removeClass(this._domNode,this._parentToolbar.ToolbarHighlightedItemStyle);
},removeToolbarItemStyle:function(){
dojo.html.removeClass(this._domNode,this._parentToolbar.ToolbarEnabledItemStyle);
dojo.html.removeClass(this._domNode,this._parentToolbar.ToolbarLatchedItemStyle);
dojo.html.removeClass(this._domNode,this._parentToolbar.ToolbarDisabledItemStyle);
this.unhighlightToolbarItem();
}});
dojo.declare("dojo.widget.Editor2ToolbarDropDownButton",dojo.widget.Editor2ToolbarButton,{onClick:function(){
if(this._domNode&&!this._domNode.disabled&&this._parentToolbar.checkAvailability()){
if(!this._dropdown){
this._dropdown=dojo.widget.createWidget("PopupContainer",{});
this._domNode.appendChild(this._dropdown.domNode);
}
if(this._dropdown.isShowingNow){
this._dropdown.close();
}else{
this.onDropDownShown();
this._dropdown.open(this._domNode,null,this._domNode);
}
}
},destroy:function(){
this.onDropDownDestroy();
if(this._dropdown){
this._dropdown.destroy();
}
dojo.widget.Editor2ToolbarDropDownButton.superclass.destroy.call(this);
},onDropDownShown:function(){
},onDropDownDestroy:function(){
}});
dojo.declare("dojo.widget.Editor2ToolbarColorPaletteButton",dojo.widget.Editor2ToolbarDropDownButton,{onDropDownShown:function(){
if(!this._colorpalette){
this._colorpalette=dojo.widget.createWidget("ColorPalette",{});
this._dropdown.addChild(this._colorpalette);
this.disableSelection(this._dropdown.domNode);
this.disableSelection(this._colorpalette.domNode);
dojo.event.connect(this._colorpalette,"onColorSelect",this,"setColor");
dojo.event.connect(this._dropdown,"open",this,"latchToolbarItem");
dojo.event.connect(this._dropdown,"close",this,"enableToolbarItem");
}
},setColor:function(_a03){
this._dropdown.close();
var _a04=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a04){
var _a05=_a04.getCommand(this._name);
if(_a05){
_a05.execute(_a03);
}
}
}});
dojo.declare("dojo.widget.Editor2ToolbarFormatBlockPlainSelect",dojo.widget.Editor2ToolbarButton,{create:function(node,_a07){
this._domNode=node;
this._parentToolbar=_a07;
this._domNode=node;
this.disableSelection(this._domNode);
dojo.event.connect(this._domNode,"onchange",this,"onChange");
},destroy:function(){
this._domNode=null;
},onChange:function(){
if(this._parentToolbar.checkAvailability()){
var sv=this._domNode.value.toLowerCase();
var _a09=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a09){
var _a0a=_a09.getCommand(this._name);
if(_a0a){
_a0a.execute(sv);
}
}
}
},refreshState:function(){
if(this._domNode){
dojo.widget.Editor2ToolbarFormatBlockPlainSelect.superclass.refreshState.call(this);
var _a0b=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a0b){
var _a0c=_a0b.getCommand(this._name);
if(_a0c){
var _a0d=_a0c.getValue();
if(!_a0d){
_a0d="";
}
dojo.lang.forEach(this._domNode.options,function(item){
if(item.value.toLowerCase()==_a0d.toLowerCase()){
item.selected=true;
}
});
}
}
}
}});
dojo.declare("dojo.widget.Editor2ToolbarComboItem",dojo.widget.Editor2ToolbarDropDownButton,{href:null,create:function(node,_a10){
dojo.widget.Editor2ToolbarComboItem.superclass.create.apply(this,arguments);
if(!this._contentPane){
this._contentPane=dojo.widget.createWidget("ContentPane",{preload:"true"});
this._contentPane.addOnLoad(this,"setup");
this._contentPane.setUrl(this.href);
}
},onMouseOver:function(e){
if(this._lastState!=dojo.widget.Editor2Manager.commandState.Disabled){
dojo.html.addClass(e.currentTarget,this._parentToolbar.ToolbarHighlightedSelectStyle);
}
},onMouseOut:function(e){
dojo.html.removeClass(e.currentTarget,this._parentToolbar.ToolbarHighlightedSelectStyle);
},onDropDownShown:function(){
if(!this._dropdown.__addedContentPage){
this._dropdown.addChild(this._contentPane);
this._dropdown.__addedContentPage=true;
}
},setup:function(){
},onChange:function(e){
if(this._parentToolbar.checkAvailability()){
var name=e.currentTarget.getAttribute("dropDownItemName");
var _a15=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a15){
var _a16=_a15.getCommand(this._name);
if(_a16){
_a16.execute(name);
}
}
}
this._dropdown.close();
},onMouseOverItem:function(e){
dojo.html.addClass(e.currentTarget,this._parentToolbar.ToolbarHighlightedSelectItemStyle);
},onMouseOutItem:function(e){
dojo.html.removeClass(e.currentTarget,this._parentToolbar.ToolbarHighlightedSelectItemStyle);
}});
dojo.declare("dojo.widget.Editor2ToolbarFormatBlockSelect",dojo.widget.Editor2ToolbarComboItem,{href:dojo.uri.moduleUri("dojo.widget","templates/Editor2/EditorToolbar_FormatBlock.html"),setup:function(){
dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.setup.call(this);
var _a19=this._contentPane.domNode.all||this._contentPane.domNode.getElementsByTagName("*");
this._blockNames={};
this._blockDisplayNames={};
for(var x=0;x<_a19.length;x++){
var node=_a19[x];
dojo.html.disableSelection(node);
var name=node.getAttribute("dropDownItemName");
if(name){
this._blockNames[name]=node;
var _a1d=node.getElementsByTagName(name);
this._blockDisplayNames[name]=_a1d[_a1d.length-1].innerHTML;
}
}
for(var name in this._blockNames){
dojo.event.connect(this._blockNames[name],"onclick",this,"onChange");
dojo.event.connect(this._blockNames[name],"onmouseover",this,"onMouseOverItem");
dojo.event.connect(this._blockNames[name],"onmouseout",this,"onMouseOutItem");
}
},onDropDownDestroy:function(){
if(this._blockNames){
for(var name in this._blockNames){
delete this._blockNames[name];
delete this._blockDisplayNames[name];
}
}
},refreshState:function(){
dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.refreshState.call(this);
if(this._lastState!=dojo.widget.Editor2Manager.commandState.Disabled){
var _a1f=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a1f){
var _a20=_a1f.getCommand(this._name);
if(_a20){
var _a21=_a20.getValue();
if(_a21==this._lastSelectedFormat&&this._blockDisplayNames){
return this._lastState;
}
this._lastSelectedFormat=_a21;
var _a22=this._domNode.getElementsByTagName("label")[0];
var _a23=false;
if(this._blockDisplayNames){
for(var name in this._blockDisplayNames){
if(name==_a21){
_a22.innerHTML=this._blockDisplayNames[name];
_a23=true;
break;
}
}
if(!_a23){
_a22.innerHTML="&nbsp;";
}
}
}
}
}
return this._lastState;
}});
dojo.declare("dojo.widget.Editor2ToolbarFontSizeSelect",dojo.widget.Editor2ToolbarComboItem,{href:dojo.uri.moduleUri("dojo.widget","templates/Editor2/EditorToolbar_FontSize.html"),setup:function(){
dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.setup.call(this);
var _a25=this._contentPane.domNode.all||this._contentPane.domNode.getElementsByTagName("*");
this._fontsizes={};
this._fontSizeDisplayNames={};
for(var x=0;x<_a25.length;x++){
var node=_a25[x];
dojo.html.disableSelection(node);
var name=node.getAttribute("dropDownItemName");
if(name){
this._fontsizes[name]=node;
this._fontSizeDisplayNames[name]=node.getElementsByTagName("font")[0].innerHTML;
}
}
for(var name in this._fontsizes){
dojo.event.connect(this._fontsizes[name],"onclick",this,"onChange");
dojo.event.connect(this._fontsizes[name],"onmouseover",this,"onMouseOverItem");
dojo.event.connect(this._fontsizes[name],"onmouseout",this,"onMouseOutItem");
}
},onDropDownDestroy:function(){
if(this._fontsizes){
for(var name in this._fontsizes){
delete this._fontsizes[name];
delete this._fontSizeDisplayNames[name];
}
}
},refreshState:function(){
dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.refreshState.call(this);
if(this._lastState!=dojo.widget.Editor2Manager.commandState.Disabled){
var _a2a=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a2a){
var _a2b=_a2a.getCommand(this._name);
if(_a2b){
var size=_a2b.getValue();
if(size==this._lastSelectedSize&&this._fontSizeDisplayNames){
return this._lastState;
}
this._lastSelectedSize=size;
var _a2d=this._domNode.getElementsByTagName("label")[0];
var _a2e=false;
if(this._fontSizeDisplayNames){
for(var name in this._fontSizeDisplayNames){
if(name==size){
_a2d.innerHTML=this._fontSizeDisplayNames[name];
_a2e=true;
break;
}
}
if(!_a2e){
_a2d.innerHTML="&nbsp;";
}
}
}
}
}
return this._lastState;
}});
dojo.declare("dojo.widget.Editor2ToolbarFontNameSelect",dojo.widget.Editor2ToolbarFontSizeSelect,{href:dojo.uri.moduleUri("dojo.widget","templates/Editor2/EditorToolbar_FontName.html")});
dojo.widget.defineWidget("dojo.widget.Editor2Toolbar",dojo.widget.HtmlWidget,function(){
dojo.event.connect(this,"fillInTemplate",dojo.lang.hitch(this,function(){
if(dojo.render.html.ie){
this.domNode.style.zoom=1;
}
}));
},{templateString:"<div dojoAttachPoint=\"domNode\" class=\"EditorToolbarDomNode\" unselectable=\"on\">\n\t<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\">\n\t\t<!--\n\t\t\tour toolbar should look something like:\n\n\t\t\t+=======+=======+=======+=============================================+\n\t\t\t| w   w | style | copy  | bo | it | un | le | ce | ri |\n\t\t\t| w w w | style |=======|==============|==============|\n\t\t\t|  w w  | style | paste |  undo | redo | change style |\n\t\t\t+=======+=======+=======+=============================================+\n\t\t-->\n\t\t<tbody>\n\t\t\t<tr valign=\"top\">\n\t\t\t\t<td rowspan=\"2\">\n\t\t\t\t\t<div class=\"bigIcon\" dojoAttachPoint=\"wikiWordButton\"\n\t\t\t\t\t\tdojoOnClick=\"wikiWordClick; buttonClick;\">\n\t\t\t\t\t\t<span style=\"font-size: 30px; margin-left: 5px;\">\n\t\t\t\t\t\t\tW\n\t\t\t\t\t\t</span>\n\t\t\t\t\t</div>\n\t\t\t\t</td>\n\t\t\t\t<td rowspan=\"2\">\n\t\t\t\t\t<div class=\"bigIcon\" dojoAttachPoint=\"styleDropdownButton\"\n\t\t\t\t\t\tdojoOnClick=\"styleDropdownClick; buttonClick;\">\n\t\t\t\t\t\t<span unselectable=\"on\"\n\t\t\t\t\t\t\tstyle=\"font-size: 30px; margin-left: 5px;\">\n\t\t\t\t\t\t\tS\n\t\t\t\t\t\t</span>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"StyleDropdownContainer\" style=\"display: none;\"\n\t\t\t\t\t\tdojoAttachPoint=\"styleDropdownContainer\">\n\t\t\t\t\t\t<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"\n\t\t\t\t\t\t\theight=\"100%\" width=\"100%\">\n\t\t\t\t\t\t\t<tr valign=\"top\">\n\t\t\t\t\t\t\t\t<td rowspan=\"2\">\n\t\t\t\t\t\t\t\t\t<div style=\"height: 245px; overflow: auto;\">\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"normalTextClick\">normal</div>\n\t\t\t\t\t\t\t\t\t\t<h1 class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"h1TextClick\">Heading 1</h1>\n\t\t\t\t\t\t\t\t\t\t<h2 class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"h2TextClick\">Heading 2</h2>\n\t\t\t\t\t\t\t\t\t\t<h3 class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"h3TextClick\">Heading 3</h3>\n\t\t\t\t\t\t\t\t\t\t<h4 class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"h4TextClick\">Heading 4</h4>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"blahTextClick\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"blahTextClick\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"blahTextClick\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\">blah</div>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t<!--\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<span class=\"iconContainer\" dojoOnClick=\"buttonClick;\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"icon justifyleft\" \n\t\t\t\t\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t<span class=\"iconContainer\" dojoOnClick=\"buttonClick;\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"icon justifycenter\" \n\t\t\t\t\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t<span class=\"iconContainer\" dojoOnClick=\"buttonClick;\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"icon justifyright\" \n\t\t\t\t\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t<span class=\"iconContainer\" dojoOnClick=\"buttonClick;\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"icon justifyfull\" \n\t\t\t\t\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t-->\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr valign=\"top\">\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\tthud\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</div>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<!-- copy -->\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"copyButton\"\n\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\tdojoOnClick=\"copyClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon copy\" \n\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span> copy\n\t\t\t\t\t</span>\n\t\t\t\t\t<!-- \"droppable\" options -->\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"boldButton\"\n\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\tdojoOnClick=\"boldClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon bold\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"italicButton\"\n\t\t\t\t\t\tdojoOnClick=\"italicClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon italic\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"underlineButton\"\n\t\t\t\t\t\tdojoOnClick=\"underlineClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon underline\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"leftButton\"\n\t\t\t\t\t\tdojoOnClick=\"leftClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon justifyleft\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"fullButton\"\n\t\t\t\t\t\tdojoOnClick=\"fullClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon justifyfull\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"rightButton\"\n\t\t\t\t\t\tdojoOnClick=\"rightClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon justifyright\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>\n\t\t\t\t\t<!-- paste -->\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"pasteButton\"\n\t\t\t\t\t\tdojoOnClick=\"pasteClick; buttonClick;\" unselectable=\"on\">\n\t\t\t\t\t\t<span class=\"icon paste\" style=\"float: left;\" unselectable=\"on\">&nbsp;</span> paste\n\t\t\t\t\t</span>\n\t\t\t\t\t<!-- \"droppable\" options -->\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"undoButton\"\n\t\t\t\t\t\tdojoOnClick=\"undoClick; buttonClick;\" unselectable=\"on\">\n\t\t\t\t\t\t<span class=\"icon undo\" style=\"float: left;\" unselectable=\"on\">&nbsp;</span> undo\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"redoButton\"\n\t\t\t\t\t\tdojoOnClick=\"redoClick; buttonClick;\" unselectable=\"on\">\n\t\t\t\t\t\t<span class=\"icon redo\" style=\"float: left;\" unselectable=\"on\">&nbsp;</span> redo\n\t\t\t\t\t</span>\n\t\t\t\t</td>\t\n\t\t\t</tr>\n\t\t</tbody>\n\t</table>\n</div>\n",templateCssString:".StyleDropdownContainer {\n\tposition: absolute;\n\tz-index: 1000;\n\toverflow: auto;\n\tcursor: default;\n\twidth: 250px;\n\theight: 250px;\n\tbackground-color: white;\n\tborder: 1px solid black;\n}\n\n.ColorDropdownContainer {\n\tposition: absolute;\n\tz-index: 1000;\n\toverflow: auto;\n\tcursor: default;\n\twidth: 250px;\n\theight: 150px;\n\tbackground-color: white;\n\tborder: 1px solid black;\n}\n\n.EditorToolbarDomNode {\n\tbackground-image: url(buttons/bg-fade.png);\n\tbackground-repeat: repeat-x;\n\tbackground-position: 0px -50px;\n}\n\n.EditorToolbarSmallBg {\n\tbackground-image: url(images/toolbar-bg.gif);\n\tbackground-repeat: repeat-x;\n\tbackground-position: 0px 0px;\n}\n\n/*\nbody {\n\tbackground:url(images/blank.gif) fixed;\n}*/\n\n.IEFixedToolbar {\n\tposition:absolute;\n\t/* top:0; */\n\ttop: expression(eval((document.documentElement||document.body).scrollTop));\n}\n\ndiv.bigIcon {\n\twidth: 40px;\n\theight: 40px; \n\t/* background-color: white; */\n\t/* border: 1px solid #a6a7a3; */\n\tfont-family: Verdana, Trebuchet, Tahoma, Arial;\n}\n\n.iconContainer {\n\tfont-family: Verdana, Trebuchet, Tahoma, Arial;\n\tfont-size: 13px;\n\tfloat: left;\n\theight: 18px;\n\tdisplay: block;\n\t/* background-color: white; */\n\tcursor: pointer;\n\tpadding: 1px 4px 1px 1px; /* almost the same as a transparent border */\n\tborder: 0px;\n}\n\n.dojoE2TBIcon {\n\tdisplay: block;\n\ttext-align: center;\n\tmin-width: 18px;\n\twidth: 18px;\n\theight: 18px;\n\t/* background-color: #a6a7a3; */\n\tbackground-repeat: no-repeat;\n\tbackground-image: url(buttons/aggregate.gif);\n}\n\n\n.dojoE2TBIcon[class~=dojoE2TBIcon] {\n}\n\n.ToolbarButtonLatched {\n    border: #316ac5 1px solid; !important;\n    padding: 0px 3px 0px 0px; !important; /* make room for border */\n    background-color: #c1d2ee;\n}\n\n.ToolbarButtonHighlighted {\n    border: #316ac5 1px solid; !important;\n    padding: 0px 3px 0px 0px; !important; /* make room for border */\n    background-color: #dff1ff;\n}\n\n.ToolbarButtonDisabled{\n    filter: gray() alpha(opacity=30); /* IE */\n    opacity: 0.30; /* Safari, Opera and Mozilla */\n}\n\n.headingContainer {\n\twidth: 150px;\n\theight: 30px;\n\tmargin: 0px;\n\t/* padding-left: 5px; */\n\toverflow: hidden;\n\tline-height: 25px;\n\tborder-bottom: 1px solid black;\n\tborder-top: 1px solid white;\n}\n\n.EditorToolbarDomNode select {\n\tfont-size: 14px;\n}\n \n.dojoE2TBIcon_Sep { width: 5px; min-width: 5px; max-width: 5px; background-position: 0px 0px}\n.dojoE2TBIcon_Backcolor { background-position: -18px 0px}\n.dojoE2TBIcon_Bold { background-position: -36px 0px}\n.dojoE2TBIcon_Cancel { background-position: -54px 0px}\n.dojoE2TBIcon_Copy { background-position: -72px 0px}\n.dojoE2TBIcon_Link { background-position: -90px 0px}\n.dojoE2TBIcon_Cut { background-position: -108px 0px}\n.dojoE2TBIcon_Delete { background-position: -126px 0px}\n.dojoE2TBIcon_TextColor { background-position: -144px 0px}\n.dojoE2TBIcon_BackgroundColor { background-position: -162px 0px}\n.dojoE2TBIcon_Indent { background-position: -180px 0px}\n.dojoE2TBIcon_HorizontalLine { background-position: -198px 0px}\n.dojoE2TBIcon_Image { background-position: -216px 0px}\n.dojoE2TBIcon_NumberedList { background-position: -234px 0px}\n.dojoE2TBIcon_Table { background-position: -252px 0px}\n.dojoE2TBIcon_BulletedList { background-position: -270px 0px}\n.dojoE2TBIcon_Italic { background-position: -288px 0px}\n.dojoE2TBIcon_CenterJustify { background-position: -306px 0px}\n.dojoE2TBIcon_BlockJustify { background-position: -324px 0px}\n.dojoE2TBIcon_LeftJustify { background-position: -342px 0px}\n.dojoE2TBIcon_RightJustify { background-position: -360px 0px}\n.dojoE2TBIcon_left_to_right { background-position: -378px 0px}\n.dojoE2TBIcon_list_bullet_indent { background-position: -396px 0px}\n.dojoE2TBIcon_list_bullet_outdent { background-position: -414px 0px}\n.dojoE2TBIcon_list_num_indent { background-position: -432px 0px}\n.dojoE2TBIcon_list_num_outdent { background-position: -450px 0px}\n.dojoE2TBIcon_Outdent { background-position: -468px 0px}\n.dojoE2TBIcon_Paste { background-position: -486px 0px}\n.dojoE2TBIcon_Redo { background-position: -504px 0px}\ndojoE2TBIcon_RemoveFormat { background-position: -522px 0px}\n.dojoE2TBIcon_right_to_left { background-position: -540px 0px}\n.dojoE2TBIcon_Save { background-position: -558px 0px}\n.dojoE2TBIcon_Space { background-position: -576px 0px}\n.dojoE2TBIcon_StrikeThrough { background-position: -594px 0px}\n.dojoE2TBIcon_Subscript { background-position: -612px 0px}\n.dojoE2TBIcon_Superscript { background-position: -630px 0px}\n.dojoE2TBIcon_Underline { background-position: -648px 0px}\n.dojoE2TBIcon_Undo { background-position: -666px 0px}\n.dojoE2TBIcon_WikiWord { background-position: -684px 0px}\n\n",templateCssPath:dojo.uri.moduleUri("dojo.widget","templates/EditorToolbar.css"),ToolbarLatchedItemStyle:"ToolbarButtonLatched",ToolbarEnabledItemStyle:"ToolbarButtonEnabled",ToolbarDisabledItemStyle:"ToolbarButtonDisabled",ToolbarHighlightedItemStyle:"ToolbarButtonHighlighted",ToolbarHighlightedSelectStyle:"ToolbarSelectHighlighted",ToolbarHighlightedSelectItemStyle:"ToolbarSelectHighlightedItem",postCreate:function(){
var _a30=dojo.html.getElementsByClass("dojoEditorToolbarItem",this.domNode);
this.items={};
for(var x=0;x<_a30.length;x++){
var node=_a30[x];
var _a33=node.getAttribute("dojoETItemName");
if(_a33){
var item=dojo.widget.Editor2ToolbarItemManager.getToolbarItem(_a33);
if(item){
item.create(node,this);
this.items[_a33.toLowerCase()]=item;
}else{
node.style.display="none";
}
}
}
},update:function(){
for(var cmd in this.items){
this.items[cmd].refreshState();
}
},shareGroup:"",checkAvailability:function(){
if(!this.shareGroup){
this.parent.focus();
return true;
}
var _a36=dojo.widget.Editor2Manager.getCurrentInstance();
if(this.shareGroup==_a36.toolbarGroup){
return true;
}
return false;
},destroy:function(){
for(var it in this.items){
this.items[it].destroy();
delete this.items[it];
}
dojo.widget.Editor2Toolbar.superclass.destroy.call(this);
}});
dojo.provide("dojo.uri.cache");
dojo.uri.cache={_cache:{},set:function(uri,_a39){
this._cache[uri.toString()]=_a39;
return uri;
},remove:function(uri){
delete this._cache[uri.toString()];
},get:function(uri){
var key=uri.toString();
var _a3d=this._cache[key];
if(!_a3d){
_a3d=dojo.hostenv.getText(key);
if(_a3d){
this._cache[key]=_a3d;
}
}
return _a3d;
},allow:function(uri){
return uri;
}};
dojo.provide("dojo.lfx.shadow");
dojo.lfx.shadow=function(node){
this.shadowPng=dojo.uri.moduleUri("dojo.html","images/shadow");
this.shadowThickness=8;
this.shadowOffset=15;
this.init(node);
};
dojo.extend(dojo.lfx.shadow,{init:function(node){
this.node=node;
this.pieces={};
var x1=-1*this.shadowThickness;
var y0=this.shadowOffset;
var y1=this.shadowOffset+this.shadowThickness;
this._makePiece("tl","top",y0,"left",x1);
this._makePiece("l","top",y1,"left",x1,"scale");
this._makePiece("tr","top",y0,"left",0);
this._makePiece("r","top",y1,"left",0,"scale");
this._makePiece("bl","top",0,"left",x1);
this._makePiece("b","top",0,"left",0,"crop");
this._makePiece("br","top",0,"left",0);
},_makePiece:function(name,_a45,_a46,_a47,_a48,_a49){
var img;
var url=this.shadowPng+name.toUpperCase()+".png";
if(dojo.render.html.ie55||dojo.render.html.ie60){
img=dojo.doc().createElement("div");
img.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+url+"'"+(_a49?", sizingMethod='"+_a49+"'":"")+")";
}else{
img=dojo.doc().createElement("img");
img.src=url;
}
img.style.position="absolute";
img.style[_a45]=_a46+"px";
img.style[_a47]=_a48+"px";
img.style.width=this.shadowThickness+"px";
img.style.height=this.shadowThickness+"px";
this.pieces[name]=img;
this.node.appendChild(img);
},size:function(_a4c,_a4d){
var _a4e=_a4d-(this.shadowOffset+this.shadowThickness+1);
if(_a4e<0){
_a4e=0;
}
if(_a4d<1){
_a4d=1;
}
if(_a4c<1){
_a4c=1;
}
with(this.pieces){
l.style.height=_a4e+"px";
r.style.height=_a4e+"px";
b.style.width=(_a4c-1)+"px";
bl.style.top=(_a4d-1)+"px";
b.style.top=(_a4d-1)+"px";
br.style.top=(_a4d-1)+"px";
tr.style.left=(_a4c-1)+"px";
r.style.left=(_a4c-1)+"px";
br.style.left=(_a4c-1)+"px";
}
}});
dojo.provide("dojo.widget.html.layout");
dojo.widget.html.layout=function(_a4f,_a50,_a51){
dojo.html.addClass(_a4f,"dojoLayoutContainer");
_a50=dojo.lang.filter(_a50,function(_a52,idx){
_a52.idx=idx;
return dojo.lang.inArray(["top","bottom","left","right","client","flood"],_a52.layoutAlign);
});
if(_a51&&_a51!="none"){
var rank=function(_a55){
switch(_a55.layoutAlign){
case "flood":
return 1;
case "left":
case "right":
return (_a51=="left-right")?2:3;
case "top":
case "bottom":
return (_a51=="left-right")?3:2;
default:
return 4;
}
};
_a50.sort(function(a,b){
return (rank(a)-rank(b))||(a.idx-b.idx);
});
}
var f={top:dojo.html.getPixelValue(_a4f,"padding-top",true),left:dojo.html.getPixelValue(_a4f,"padding-left",true)};
dojo.lang.mixin(f,dojo.html.getContentBox(_a4f));
dojo.lang.forEach(_a50,function(_a59){
var elm=_a59.domNode;
var pos=_a59.layoutAlign;
with(elm.style){
left=f.left+"px";
top=f.top+"px";
bottom="auto";
right="auto";
}
dojo.html.addClass(elm,"dojoAlign"+dojo.string.capitalize(pos));
if((pos=="top")||(pos=="bottom")){
dojo.html.setMarginBox(elm,{width:f.width});
var h=dojo.html.getMarginBox(elm).height;
f.height-=h;
if(pos=="top"){
f.top+=h;
}else{
elm.style.top=f.top+f.height+"px";
}
if(_a59.onResized){
_a59.onResized();
}
}else{
if(pos=="left"||pos=="right"){
var w=dojo.html.getMarginBox(elm).width;
if(_a59.resizeTo){
_a59.resizeTo(w,f.height);
}else{
dojo.html.setMarginBox(elm,{width:w,height:f.height});
}
f.width-=w;
if(pos=="left"){
f.left+=w;
}else{
elm.style.left=f.left+f.width+"px";
}
}else{
if(pos=="flood"||pos=="client"){
if(_a59.resizeTo){
_a59.resizeTo(f.width,f.height);
}else{
dojo.html.setMarginBox(elm,{width:f.width,height:f.height});
}
}
}
}
});
};
dojo.html.insertCssText(".dojoLayoutContainer{ position: relative; display: block; overflow: hidden; }\n"+"body .dojoAlignTop, body .dojoAlignBottom, body .dojoAlignLeft, body .dojoAlignRight { position: absolute; overflow: hidden; }\n"+"body .dojoAlignClient { position: absolute }\n"+".dojoAlignClient { overflow: auto; }\n");
dojo.provide("dojo.dnd.DragAndDrop");
dojo.declare("dojo.dnd.DragSource",null,{type:"",onDragEnd:function(evt){
},onDragStart:function(evt){
},onSelected:function(evt){
},unregister:function(){
dojo.dnd.dragManager.unregisterDragSource(this);
},reregister:function(){
dojo.dnd.dragManager.registerDragSource(this);
}});
dojo.declare("dojo.dnd.DragObject",null,{type:"",register:function(){
var dm=dojo.dnd.dragManager;
if(dm["registerDragObject"]){
dm.registerDragObject(this);
}
},onDragStart:function(evt){
},onDragMove:function(evt){
},onDragOver:function(evt){
},onDragOut:function(evt){
},onDragEnd:function(evt){
},onDragLeave:dojo.lang.forward("onDragOut"),onDragEnter:dojo.lang.forward("onDragOver"),ondragout:dojo.lang.forward("onDragOut"),ondragover:dojo.lang.forward("onDragOver")});
dojo.declare("dojo.dnd.DropTarget",null,{acceptsType:function(type){
if(!dojo.lang.inArray(this.acceptedTypes,"*")){
if(!dojo.lang.inArray(this.acceptedTypes,type)){
return false;
}
}
return true;
},accepts:function(_a68){
if(!dojo.lang.inArray(this.acceptedTypes,"*")){
for(var i=0;i<_a68.length;i++){
if(!dojo.lang.inArray(this.acceptedTypes,_a68[i].type)){
return false;
}
}
}
return true;
},unregister:function(){
dojo.dnd.dragManager.unregisterDropTarget(this);
},onDragOver:function(evt){
},onDragOut:function(evt){
},onDragMove:function(evt){
},onDropStart:function(evt){
},onDrop:function(evt){
},onDropEnd:function(){
}},function(){
this.acceptedTypes=[];
});
dojo.dnd.DragEvent=function(){
this.dragSource=null;
this.dragObject=null;
this.target=null;
this.eventStatus="success";
};
dojo.declare("dojo.dnd.DragManager",null,{selectedSources:[],dragObjects:[],dragSources:[],registerDragSource:function(_a6f){
},dropTargets:[],registerDropTarget:function(_a70){
},lastDragTarget:null,currentDragTarget:null,onKeyDown:function(){
},onMouseOut:function(){
},onMouseMove:function(){
},onMouseUp:function(){
}});
dojo.provide("dojo.dnd.HtmlDragManager");
dojo.declare("dojo.dnd.HtmlDragManager",dojo.dnd.DragManager,{disabled:false,nestedTargets:false,mouseDownTimer:null,dsCounter:0,dsPrefix:"dojoDragSource",dropTargetDimensions:[],currentDropTarget:null,previousDropTarget:null,_dragTriggered:false,selectedSources:[],dragObjects:[],dragSources:[],dropTargets:[],currentX:null,currentY:null,lastX:null,lastY:null,mouseDownX:null,mouseDownY:null,threshold:7,dropAcceptable:false,cancelEvent:function(e){
e.stopPropagation();
e.preventDefault();
},registerDragSource:function(ds){
if(ds["domNode"]){
var dp=this.dsPrefix;
var _a74=dp+"Idx_"+(this.dsCounter++);
ds.dragSourceId=_a74;
this.dragSources[_a74]=ds;
ds.domNode.setAttribute(dp,_a74);
if(dojo.render.html.ie){
dojo.event.browser.addListener(ds.domNode,"ondragstart",this.cancelEvent);
}
}
},unregisterDragSource:function(ds){
if(ds["domNode"]){
var dp=this.dsPrefix;
var _a77=ds.dragSourceId;
delete ds.dragSourceId;
delete this.dragSources[_a77];
ds.domNode.setAttribute(dp,null);
if(dojo.render.html.ie){
dojo.event.browser.removeListener(ds.domNode,"ondragstart",this.cancelEvent);
}
}
},registerDropTarget:function(dt){
this.dropTargets.push(dt);
},unregisterDropTarget:function(dt){
var _a7a=dojo.lang.find(this.dropTargets,dt,true);
if(_a7a>=0){
this.dropTargets.splice(_a7a,1);
}
},getDragSource:function(e){
var tn=e.target;
if(tn===dojo.body()){
return;
}
var ta=dojo.html.getAttribute(tn,this.dsPrefix);
while((!ta)&&(tn)){
tn=tn.parentNode;
if((!tn)||(tn===dojo.body())){
return;
}
ta=dojo.html.getAttribute(tn,this.dsPrefix);
}
return this.dragSources[ta];
},onKeyDown:function(e){
},onMouseDown:function(e){
if(this.disabled){
return;
}
if(dojo.render.html.ie){
if(e.button!=1){
return;
}
}else{
if(e.which!=1){
return;
}
}
var _a80=e.target.nodeType==dojo.html.TEXT_NODE?e.target.parentNode:e.target;
if(dojo.html.isTag(_a80,"button","textarea","input","select","option")){
return;
}
var ds=this.getDragSource(e);
if(!ds){
return;
}
if(!dojo.lang.inArray(this.selectedSources,ds)){
this.selectedSources.push(ds);
ds.onSelected();
}
this.mouseDownX=e.pageX;
this.mouseDownY=e.pageY;
e.preventDefault();
dojo.event.connect(document,"onmousemove",this,"onMouseMove");
},onMouseUp:function(e,_a83){
if(this.selectedSources.length==0){
return;
}
this.mouseDownX=null;
this.mouseDownY=null;
this._dragTriggered=false;
e.dragSource=this.dragSource;
if((!e.shiftKey)&&(!e.ctrlKey)){
if(this.currentDropTarget){
this.currentDropTarget.onDropStart();
}
dojo.lang.forEach(this.dragObjects,function(_a84){
var ret=null;
if(!_a84){
return;
}
if(this.currentDropTarget){
e.dragObject=_a84;
var ce=this.currentDropTarget.domNode.childNodes;
if(ce.length>0){
e.dropTarget=ce[0];
while(e.dropTarget==_a84.domNode){
e.dropTarget=e.dropTarget.nextSibling;
}
}else{
e.dropTarget=this.currentDropTarget.domNode;
}
if(this.dropAcceptable){
ret=this.currentDropTarget.onDrop(e);
}else{
this.currentDropTarget.onDragOut(e);
}
}
e.dragStatus=this.dropAcceptable&&ret?"dropSuccess":"dropFailure";
dojo.lang.delayThese([function(){
try{
_a84.dragSource.onDragEnd(e);
}
catch(err){
var _a87={};
for(var i in e){
if(i=="type"){
_a87.type="mouseup";
continue;
}
_a87[i]=e[i];
}
_a84.dragSource.onDragEnd(_a87);
}
},function(){
_a84.onDragEnd(e);
}]);
},this);
this.selectedSources=[];
this.dragObjects=[];
this.dragSource=null;
if(this.currentDropTarget){
this.currentDropTarget.onDropEnd();
}
}else{
}
dojo.event.disconnect(document,"onmousemove",this,"onMouseMove");
this.currentDropTarget=null;
},onScroll:function(){
for(var i=0;i<this.dragObjects.length;i++){
if(this.dragObjects[i].updateDragOffset){
this.dragObjects[i].updateDragOffset();
}
}
if(this.dragObjects.length){
this.cacheTargetLocations();
}
},_dragStartDistance:function(x,y){
if((!this.mouseDownX)||(!this.mouseDownX)){
return;
}
var dx=Math.abs(x-this.mouseDownX);
var dx2=dx*dx;
var dy=Math.abs(y-this.mouseDownY);
var dy2=dy*dy;
return parseInt(Math.sqrt(dx2+dy2),10);
},cacheTargetLocations:function(){
dojo.profile.start("cacheTargetLocations");
this.dropTargetDimensions=[];
dojo.lang.forEach(this.dropTargets,function(_a90){
var tn=_a90.domNode;
if(!tn||!_a90.accepts([this.dragSource])){
return;
}
var abs=dojo.html.getAbsolutePosition(tn,true);
var bb=dojo.html.getBorderBox(tn);
this.dropTargetDimensions.push([[abs.x,abs.y],[abs.x+bb.width,abs.y+bb.height],_a90]);
},this);
dojo.profile.end("cacheTargetLocations");
},onMouseMove:function(e){
if((dojo.render.html.ie)&&(e.button!=1)){
this.currentDropTarget=null;
this.onMouseUp(e,true);
return;
}
if((this.selectedSources.length)&&(!this.dragObjects.length)){
var dx;
var dy;
if(!this._dragTriggered){
this._dragTriggered=(this._dragStartDistance(e.pageX,e.pageY)>this.threshold);
if(!this._dragTriggered){
return;
}
dx=e.pageX-this.mouseDownX;
dy=e.pageY-this.mouseDownY;
}
this.dragSource=this.selectedSources[0];
dojo.lang.forEach(this.selectedSources,function(_a97){
if(!_a97){
return;
}
var tdo=_a97.onDragStart(e);
if(tdo){
tdo.onDragStart(e);
tdo.dragOffset.y+=dy;
tdo.dragOffset.x+=dx;
tdo.dragSource=_a97;
this.dragObjects.push(tdo);
}
},this);
this.previousDropTarget=null;
this.cacheTargetLocations();
}
dojo.lang.forEach(this.dragObjects,function(_a99){
if(_a99){
_a99.onDragMove(e);
}
});
if(this.currentDropTarget){
var c=dojo.html.toCoordinateObject(this.currentDropTarget.domNode,true);
var dtp=[[c.x,c.y],[c.x+c.width,c.y+c.height]];
}
if((!this.nestedTargets)&&(dtp)&&(this.isInsideBox(e,dtp))){
if(this.dropAcceptable){
this.currentDropTarget.onDragMove(e,this.dragObjects);
}
}else{
var _a9c=this.findBestTarget(e);
if(_a9c.target===null){
if(this.currentDropTarget){
this.currentDropTarget.onDragOut(e);
this.previousDropTarget=this.currentDropTarget;
this.currentDropTarget=null;
}
this.dropAcceptable=false;
return;
}
if(this.currentDropTarget!==_a9c.target){
if(this.currentDropTarget){
this.previousDropTarget=this.currentDropTarget;
this.currentDropTarget.onDragOut(e);
}
this.currentDropTarget=_a9c.target;
e.dragObjects=this.dragObjects;
this.dropAcceptable=this.currentDropTarget.onDragOver(e);
}else{
if(this.dropAcceptable){
this.currentDropTarget.onDragMove(e,this.dragObjects);
}
}
}
},findBestTarget:function(e){
var _a9e=this;
var _a9f=new Object();
_a9f.target=null;
_a9f.points=null;
dojo.lang.every(this.dropTargetDimensions,function(_aa0){
if(!_a9e.isInsideBox(e,_aa0)){
return true;
}
_a9f.target=_aa0[2];
_a9f.points=_aa0;
return Boolean(_a9e.nestedTargets);
});
return _a9f;
},isInsideBox:function(e,_aa2){
if((e.pageX>_aa2[0][0])&&(e.pageX<_aa2[1][0])&&(e.pageY>_aa2[0][1])&&(e.pageY<_aa2[1][1])){
return true;
}
return false;
},onMouseOver:function(e){
},onMouseOut:function(e){
}});
dojo.dnd.dragManager=new dojo.dnd.HtmlDragManager();
(function(){
var d=document;
var dm=dojo.dnd.dragManager;
dojo.event.connect(d,"onkeydown",dm,"onKeyDown");
dojo.event.connect(d,"onmouseover",dm,"onMouseOver");
dojo.event.connect(d,"onmouseout",dm,"onMouseOut");
dojo.event.connect(d,"onmousedown",dm,"onMouseDown");
dojo.event.connect(d,"onmouseup",dm,"onMouseUp");
dojo.event.connect(window,"onscroll",dm,"onScroll");
})();
dojo.provide("dojo.dnd.HtmlDragAndDrop");
dojo.declare("dojo.dnd.HtmlDragSource",dojo.dnd.DragSource,{dragClass:"",onDragStart:function(){
var _aa7=new dojo.dnd.HtmlDragObject(this.dragObject,this.type);
if(this.dragClass){
_aa7.dragClass=this.dragClass;
}
if(this.constrainToContainer){
_aa7.constrainTo(this.constrainingContainer||this.domNode.parentNode);
}
return _aa7;
},setDragHandle:function(node){
node=dojo.byId(node);
dojo.dnd.dragManager.unregisterDragSource(this);
this.domNode=node;
dojo.dnd.dragManager.registerDragSource(this);
},setDragTarget:function(node){
this.dragObject=node;
},constrainTo:function(_aaa){
this.constrainToContainer=true;
if(_aaa){
this.constrainingContainer=_aaa;
}
},onSelected:function(){
for(var i=0;i<this.dragObjects.length;i++){
dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragSource(this.dragObjects[i]));
}
},addDragObjects:function(el){
for(var i=0;i<arguments.length;i++){
this.dragObjects.push(dojo.byId(arguments[i]));
}
}},function(node,type){
node=dojo.byId(node);
this.dragObjects=[];
this.constrainToContainer=false;
if(node){
this.domNode=node;
this.dragObject=node;
this.type=(type)||(this.domNode.nodeName.toLowerCase());
dojo.dnd.DragSource.prototype.reregister.call(this);
}
});
dojo.declare("dojo.dnd.HtmlDragObject",dojo.dnd.DragObject,{dragClass:"",opacity:0.5,createIframe:true,disableX:false,disableY:false,createDragNode:function(){
var node=this.domNode.cloneNode(true);
if(this.dragClass){
dojo.html.addClass(node,this.dragClass);
}
if(this.opacity<1){
dojo.html.setOpacity(node,this.opacity);
}
var ltn=node.tagName.toLowerCase();
var isTr=(ltn=="tr");
if((isTr)||(ltn=="tbody")){
var doc=this.domNode.ownerDocument;
var _ab4=doc.createElement("table");
if(isTr){
var _ab5=doc.createElement("tbody");
_ab4.appendChild(_ab5);
_ab5.appendChild(node);
}else{
_ab4.appendChild(node);
}
var _ab6=((isTr)?this.domNode:this.domNode.firstChild);
var _ab7=((isTr)?node:node.firstChild);
var _ab8=_ab6.childNodes;
var _ab9=_ab7.childNodes;
for(var i=0;i<_ab8.length;i++){
if((_ab9[i])&&(_ab9[i].style)){
_ab9[i].style.width=dojo.html.getContentBox(_ab8[i]).width+"px";
}
}
node=_ab4;
}
if((dojo.render.html.ie55||dojo.render.html.ie60)&&this.createIframe){
with(node.style){
top="0px";
left="0px";
}
var _abb=document.createElement("div");
_abb.appendChild(node);
this.bgIframe=new dojo.html.BackgroundIframe(_abb);
_abb.appendChild(this.bgIframe.iframe);
node=_abb;
}
node.style.zIndex=999;
return node;
},onDragStart:function(e){
dojo.html.clearSelection();
this.scrollOffset=dojo.html.getScroll().offset;
this.dragStartPosition=dojo.html.getAbsolutePosition(this.domNode,true);
this.dragOffset={y:this.dragStartPosition.y-e.pageY,x:this.dragStartPosition.x-e.pageX};
this.dragClone=this.createDragNode();
this.containingBlockPosition=this.domNode.offsetParent?dojo.html.getAbsolutePosition(this.domNode.offsetParent,true):{x:0,y:0};
if(this.constrainToContainer){
this.constraints=this.getConstraints();
}
with(this.dragClone.style){
position="absolute";
top=this.dragOffset.y+e.pageY+"px";
left=this.dragOffset.x+e.pageX+"px";
}
dojo.body().appendChild(this.dragClone);
dojo.event.topic.publish("dragStart",{source:this});
},getConstraints:function(){
if(this.constrainingContainer.nodeName.toLowerCase()=="body"){
var _abd=dojo.html.getViewport();
var _abe=_abd.width;
var _abf=_abd.height;
var _ac0=dojo.html.getScroll().offset;
var x=_ac0.x;
var y=_ac0.y;
}else{
var _ac3=dojo.html.getContentBox(this.constrainingContainer);
_abe=_ac3.width;
_abf=_ac3.height;
x=this.containingBlockPosition.x+dojo.html.getPixelValue(this.constrainingContainer,"padding-left",true)+dojo.html.getBorderExtent(this.constrainingContainer,"left");
y=this.containingBlockPosition.y+dojo.html.getPixelValue(this.constrainingContainer,"padding-top",true)+dojo.html.getBorderExtent(this.constrainingContainer,"top");
}
var mb=dojo.html.getMarginBox(this.domNode);
return {minX:x,minY:y,maxX:x+_abe-mb.width,maxY:y+_abf-mb.height};
},updateDragOffset:function(){
var _ac5=dojo.html.getScroll().offset;
if(_ac5.y!=this.scrollOffset.y){
var diff=_ac5.y-this.scrollOffset.y;
this.dragOffset.y+=diff;
this.scrollOffset.y=_ac5.y;
}
if(_ac5.x!=this.scrollOffset.x){
var diff=_ac5.x-this.scrollOffset.x;
this.dragOffset.x+=diff;
this.scrollOffset.x=_ac5.x;
}
},onDragMove:function(e){
this.updateDragOffset();
var x=this.dragOffset.x+e.pageX;
var y=this.dragOffset.y+e.pageY;
if(this.constrainToContainer){
if(x<this.constraints.minX){
x=this.constraints.minX;
}
if(y<this.constraints.minY){
y=this.constraints.minY;
}
if(x>this.constraints.maxX){
x=this.constraints.maxX;
}
if(y>this.constraints.maxY){
y=this.constraints.maxY;
}
}
this.setAbsolutePosition(x,y);
dojo.event.topic.publish("dragMove",{source:this});
},setAbsolutePosition:function(x,y){
if(!this.disableY){
this.dragClone.style.top=y+"px";
}
if(!this.disableX){
this.dragClone.style.left=x+"px";
}
},onDragEnd:function(e){
switch(e.dragStatus){
case "dropSuccess":
dojo.html.removeNode(this.dragClone);
this.dragClone=null;
break;
case "dropFailure":
var _acd=dojo.html.getAbsolutePosition(this.dragClone,true);
var _ace={left:this.dragStartPosition.x+1,top:this.dragStartPosition.y+1};
var anim=dojo.lfx.slideTo(this.dragClone,_ace,300);
var _ad0=this;
dojo.event.connect(anim,"onEnd",function(e){
dojo.html.removeNode(_ad0.dragClone);
_ad0.dragClone=null;
});
anim.play();
break;
}
dojo.event.topic.publish("dragEnd",{source:this});
},constrainTo:function(_ad2){
this.constrainToContainer=true;
if(_ad2){
this.constrainingContainer=_ad2;
}else{
this.constrainingContainer=this.domNode.parentNode;
}
}},function(node,type){
this.domNode=dojo.byId(node);
this.type=type;
this.constrainToContainer=false;
this.dragSource=null;
dojo.dnd.DragObject.prototype.register.call(this);
});
dojo.declare("dojo.dnd.HtmlDropTarget",dojo.dnd.DropTarget,{vertical:false,onDragOver:function(e){
if(!this.accepts(e.dragObjects)){
return false;
}
this.childBoxes=[];
for(var i=0,_ad7;i<this.domNode.childNodes.length;i++){
_ad7=this.domNode.childNodes[i];
if(_ad7.nodeType!=dojo.html.ELEMENT_NODE){
continue;
}
var pos=dojo.html.getAbsolutePosition(_ad7,true);
var _ad9=dojo.html.getBorderBox(_ad7);
this.childBoxes.push({top:pos.y,bottom:pos.y+_ad9.height,left:pos.x,right:pos.x+_ad9.width,height:_ad9.height,width:_ad9.width,node:_ad7});
}
return true;
},_getNodeUnderMouse:function(e){
for(var i=0,_adc;i<this.childBoxes.length;i++){
with(this.childBoxes[i]){
if(e.pageX>=left&&e.pageX<=right&&e.pageY>=top&&e.pageY<=bottom){
return i;
}
}
}
return -1;
},createDropIndicator:function(){
this.dropIndicator=document.createElement("div");
with(this.dropIndicator.style){
position="absolute";
zIndex=999;
if(this.vertical){
borderLeftWidth="1px";
borderLeftColor="black";
borderLeftStyle="solid";
height=dojo.html.getBorderBox(this.domNode).height+"px";
top=dojo.html.getAbsolutePosition(this.domNode,true).y+"px";
}else{
borderTopWidth="1px";
borderTopColor="black";
borderTopStyle="solid";
width=dojo.html.getBorderBox(this.domNode).width+"px";
left=dojo.html.getAbsolutePosition(this.domNode,true).x+"px";
}
}
},onDragMove:function(e,_ade){
var i=this._getNodeUnderMouse(e);
if(!this.dropIndicator){
this.createDropIndicator();
}
var _ae0=this.vertical?dojo.html.gravity.WEST:dojo.html.gravity.NORTH;
var hide=false;
if(i<0){
if(this.childBoxes.length){
var _ae2=(dojo.html.gravity(this.childBoxes[0].node,e)&_ae0);
if(_ae2){
hide=true;
}
}else{
var _ae2=true;
}
}else{
var _ae3=this.childBoxes[i];
var _ae2=(dojo.html.gravity(_ae3.node,e)&_ae0);
if(_ae3.node===_ade[0].dragSource.domNode){
hide=true;
}else{
var _ae4=_ae2?(i>0?this.childBoxes[i-1]:_ae3):(i<this.childBoxes.length-1?this.childBoxes[i+1]:_ae3);
if(_ae4.node===_ade[0].dragSource.domNode){
hide=true;
}
}
}
if(hide){
this.dropIndicator.style.display="none";
return;
}else{
this.dropIndicator.style.display="";
}
this.placeIndicator(e,_ade,i,_ae2);
if(!dojo.html.hasParent(this.dropIndicator)){
dojo.body().appendChild(this.dropIndicator);
}
},placeIndicator:function(e,_ae6,_ae7,_ae8){
var _ae9=this.vertical?"left":"top";
var _aea;
if(_ae7<0){
if(this.childBoxes.length){
_aea=_ae8?this.childBoxes[0]:this.childBoxes[this.childBoxes.length-1];
}else{
this.dropIndicator.style[_ae9]=dojo.html.getAbsolutePosition(this.domNode,true)[this.vertical?"x":"y"]+"px";
}
}else{
_aea=this.childBoxes[_ae7];
}
if(_aea){
this.dropIndicator.style[_ae9]=(_ae8?_aea[_ae9]:_aea[this.vertical?"right":"bottom"])+"px";
if(this.vertical){
this.dropIndicator.style.height=_aea.height+"px";
this.dropIndicator.style.top=_aea.top+"px";
}else{
this.dropIndicator.style.width=_aea.width+"px";
this.dropIndicator.style.left=_aea.left+"px";
}
}
},onDragOut:function(e){
if(this.dropIndicator){
dojo.html.removeNode(this.dropIndicator);
delete this.dropIndicator;
}
},onDrop:function(e){
this.onDragOut(e);
var i=this._getNodeUnderMouse(e);
var _aee=this.vertical?dojo.html.gravity.WEST:dojo.html.gravity.NORTH;
if(i<0){
if(this.childBoxes.length){
if(dojo.html.gravity(this.childBoxes[0].node,e)&_aee){
return this.insert(e,this.childBoxes[0].node,"before");
}else{
return this.insert(e,this.childBoxes[this.childBoxes.length-1].node,"after");
}
}
return this.insert(e,this.domNode,"append");
}
var _aef=this.childBoxes[i];
if(dojo.html.gravity(_aef.node,e)&_aee){
return this.insert(e,_aef.node,"before");
}else{
return this.insert(e,_aef.node,"after");
}
},insert:function(e,_af1,_af2){
var node=e.dragObject.domNode;
if(_af2=="before"){
return dojo.html.insertBefore(node,_af1);
}else{
if(_af2=="after"){
return dojo.html.insertAfter(node,_af1);
}else{
if(_af2=="append"){
_af1.appendChild(node);
return true;
}
}
}
return false;
}},function(node,_af5){
if(arguments.length==0){
return;
}
this.domNode=dojo.byId(node);
dojo.dnd.DropTarget.call(this);
if(_af5&&dojo.lang.isString(_af5)){
_af5=[_af5];
}
this.acceptedTypes=_af5||[];
dojo.dnd.dragManager.registerDropTarget(this);
});
dojo.kwCompoundRequire({common:["dojo.dnd.DragAndDrop"],browser:["dojo.dnd.HtmlDragAndDrop"],dashboard:["dojo.dnd.HtmlDragAndDrop"]});
dojo.provide("dojo.dnd.*");
dojo.provide("dojo.dnd.HtmlDragMove");
dojo.declare("dojo.dnd.HtmlDragMoveSource",dojo.dnd.HtmlDragSource,{onDragStart:function(){
var _af6=new dojo.dnd.HtmlDragMoveObject(this.dragObject,this.type);
if(this.constrainToContainer){
_af6.constrainTo(this.constrainingContainer);
}
return _af6;
},onSelected:function(){
for(var i=0;i<this.dragObjects.length;i++){
dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragMoveSource(this.dragObjects[i]));
}
}});
dojo.declare("dojo.dnd.HtmlDragMoveObject",dojo.dnd.HtmlDragObject,{onDragStart:function(e){
dojo.html.clearSelection();
this.dragClone=this.domNode;
if(dojo.html.getComputedStyle(this.domNode,"position")!="absolute"){
this.domNode.style.position="relative";
}
var left=parseInt(dojo.html.getComputedStyle(this.domNode,"left"));
var top=parseInt(dojo.html.getComputedStyle(this.domNode,"top"));
this.dragStartPosition={x:isNaN(left)?0:left,y:isNaN(top)?0:top};
this.scrollOffset=dojo.html.getScroll().offset;
this.dragOffset={y:this.dragStartPosition.y-e.pageY,x:this.dragStartPosition.x-e.pageX};
this.containingBlockPosition={x:0,y:0};
if(this.constrainToContainer){
this.constraints=this.getConstraints();
}
dojo.event.connect(this.domNode,"onclick",this,"_squelchOnClick");
},onDragEnd:function(e){
},setAbsolutePosition:function(x,y){
if(!this.disableY){
this.domNode.style.top=y+"px";
}
if(!this.disableX){
this.domNode.style.left=x+"px";
}
},_squelchOnClick:function(e){
dojo.event.browser.stopEvent(e);
dojo.event.disconnect(this.domNode,"onclick",this,"_squelchOnClick");
}});
dojo.provide("dojo.widget.Dialog");
dojo.declare("dojo.widget.ModalDialogBase",null,{isContainer:true,focusElement:"",bgColor:"black",bgOpacity:0.4,followScroll:true,closeOnBackgroundClick:false,trapTabs:function(e){
if(e.target==this.tabStartOuter){
if(this._fromTrap){
this.tabStart.focus();
this._fromTrap=false;
}else{
this._fromTrap=true;
this.tabEnd.focus();
}
}else{
if(e.target==this.tabStart){
if(this._fromTrap){
this._fromTrap=false;
}else{
this._fromTrap=true;
this.tabEnd.focus();
}
}else{
if(e.target==this.tabEndOuter){
if(this._fromTrap){
this.tabEnd.focus();
this._fromTrap=false;
}else{
this._fromTrap=true;
this.tabStart.focus();
}
}else{
if(e.target==this.tabEnd){
if(this._fromTrap){
this._fromTrap=false;
}else{
this._fromTrap=true;
this.tabStart.focus();
}
}
}
}
}
},clearTrap:function(e){
var _b01=this;
setTimeout(function(){
_b01._fromTrap=false;
},100);
},postCreate:function(){
with(this.domNode.style){
position="absolute";
zIndex=999;
display="none";
overflow="visible";
}
var b=dojo.body();
b.appendChild(this.domNode);
this.bg=document.createElement("div");
this.bg.className="dialogUnderlay";
with(this.bg.style){
position="absolute";
left=top="0px";
zIndex=998;
display="none";
}
b.appendChild(this.bg);
this.setBackgroundColor(this.bgColor);
this.bgIframe=new dojo.html.BackgroundIframe();
if(this.bgIframe.iframe){
with(this.bgIframe.iframe.style){
position="absolute";
left=top="0px";
zIndex=90;
display="none";
}
}
if(this.closeOnBackgroundClick){
dojo.event.kwConnect({srcObj:this.bg,srcFunc:"onclick",adviceObj:this,adviceFunc:"onBackgroundClick",once:true});
}
},uninitialize:function(){
this.bgIframe.remove();
dojo.html.removeNode(this.bg,true);
},setBackgroundColor:function(_b03){
if(arguments.length>=3){
_b03=new dojo.gfx.color.Color(arguments[0],arguments[1],arguments[2]);
}else{
_b03=new dojo.gfx.color.Color(_b03);
}
this.bg.style.backgroundColor=_b03.toString();
return this.bgColor=_b03;
},setBackgroundOpacity:function(op){
if(arguments.length==0){
op=this.bgOpacity;
}
dojo.html.setOpacity(this.bg,op);
try{
this.bgOpacity=dojo.html.getOpacity(this.bg);
}
catch(e){
this.bgOpacity=op;
}
return this.bgOpacity;
},_sizeBackground:function(){
if(this.bgOpacity>0){
var _b05=dojo.html.getViewport();
var h=_b05.height;
var w=_b05.width;
with(this.bg.style){
width=w+"px";
height=h+"px";
}
var _b08=dojo.html.getScroll().offset;
this.bg.style.top=_b08.y+"px";
this.bg.style.left=_b08.x+"px";
var _b05=dojo.html.getViewport();
if(_b05.width!=w){
this.bg.style.width=_b05.width+"px";
}
if(_b05.height!=h){
this.bg.style.height=_b05.height+"px";
}
}
this.bgIframe.size(this.bg);
},_showBackground:function(){
if(this.bgOpacity>0){
this.bg.style.display="block";
}
if(this.bgIframe.iframe){
this.bgIframe.iframe.style.display="block";
}
},placeModalDialog:function(){
var _b09=dojo.html.getScroll().offset;
var _b0a=dojo.html.getViewport();
var mb;
if(this.isShowing()){
mb=dojo.html.getMarginBox(this.domNode);
}else{
dojo.html.setVisibility(this.domNode,false);
dojo.html.show(this.domNode);
mb=dojo.html.getMarginBox(this.domNode);
dojo.html.hide(this.domNode);
dojo.html.setVisibility(this.domNode,true);
}
var x=_b09.x+(_b0a.width-mb.width)/2;
var y=_b09.y+(_b0a.height-mb.height)/2;
with(this.domNode.style){
left=x+"px";
top=y+"px";
}
},_onKey:function(evt){
if(evt.key){
var node=evt.target;
while(node!=null){
if(node==this.domNode){
return;
}
node=node.parentNode;
}
if(evt.key!=evt.KEY_TAB){
dojo.event.browser.stopEvent(evt);
}else{
if(!dojo.render.html.opera){
try{
this.tabStart.focus();
}
catch(e){
}
}
}
}
},showModalDialog:function(){
if(this.followScroll&&!this._scrollConnected){
this._scrollConnected=true;
dojo.event.connect(window,"onscroll",this,"_onScroll");
}
dojo.event.connect(document.documentElement,"onkey",this,"_onKey");
this.placeModalDialog();
this.setBackgroundOpacity();
this._sizeBackground();
this._showBackground();
this._fromTrap=true;
setTimeout(dojo.lang.hitch(this,function(){
try{
this.tabStart.focus();
}
catch(e){
}
}),50);
},hideModalDialog:function(){
if(this.focusElement){
dojo.byId(this.focusElement).focus();
dojo.byId(this.focusElement).blur();
}
this.bg.style.display="none";
this.bg.style.width=this.bg.style.height="1px";
if(this.bgIframe.iframe){
this.bgIframe.iframe.style.display="none";
}
dojo.event.disconnect(document.documentElement,"onkey",this,"_onKey");
if(this._scrollConnected){
this._scrollConnected=false;
dojo.event.disconnect(window,"onscroll",this,"_onScroll");
}
},_onScroll:function(){
var _b10=dojo.html.getScroll().offset;
this.bg.style.top=_b10.y+"px";
this.bg.style.left=_b10.x+"px";
this.placeModalDialog();
},checkSize:function(){
if(this.isShowing()){
this._sizeBackground();
this.placeModalDialog();
this.onResized();
}
},onBackgroundClick:function(){
if(this.lifetime-this.timeRemaining>=this.blockDuration){
return;
}
this.hide();
}});
dojo.widget.defineWidget("dojo.widget.Dialog",[dojo.widget.ContentPane,dojo.widget.ModalDialogBase],{templateString:"<div id=\"${this.widgetId}\" class=\"dojoDialog\" dojoattachpoint=\"wrapper\">\n\t<span dojoattachpoint=\"tabStartOuter\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\"\ttabindex=\"0\"></span>\n\t<span dojoattachpoint=\"tabStart\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<div dojoattachpoint=\"containerNode\" style=\"position: relative; z-index: 2;\"></div>\n\t<span dojoattachpoint=\"tabEnd\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<span dojoattachpoint=\"tabEndOuter\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n</div>\n",blockDuration:0,lifetime:0,closeNode:"",postMixInProperties:function(){
dojo.widget.Dialog.superclass.postMixInProperties.apply(this,arguments);
if(this.closeNode){
this.setCloseControl(this.closeNode);
}
},postCreate:function(){
dojo.widget.Dialog.superclass.postCreate.apply(this,arguments);
dojo.widget.ModalDialogBase.prototype.postCreate.apply(this,arguments);
},show:function(){
if(this.lifetime){
this.timeRemaining=this.lifetime;
if(this.timerNode){
this.timerNode.innerHTML=Math.ceil(this.timeRemaining/1000);
}
if(this.blockDuration&&this.closeNode){
if(this.lifetime>this.blockDuration){
this.closeNode.style.visibility="hidden";
}else{
this.closeNode.style.display="none";
}
}
if(this.timer){
clearInterval(this.timer);
}
this.timer=setInterval(dojo.lang.hitch(this,"_onTick"),100);
}
this.showModalDialog();
dojo.widget.Dialog.superclass.show.call(this);
},onLoad:function(){
this.placeModalDialog();
dojo.widget.Dialog.superclass.onLoad.call(this);
},fillInTemplate:function(){
},hide:function(){
this.hideModalDialog();
dojo.widget.Dialog.superclass.hide.call(this);
if(this.timer){
clearInterval(this.timer);
}
},setTimerNode:function(node){
this.timerNode=node;
},setCloseControl:function(node){
this.closeNode=dojo.byId(node);
dojo.event.connect(this.closeNode,"onclick",this,"hide");
},setShowControl:function(node){
node=dojo.byId(node);
dojo.event.connect(node,"onclick",this,"show");
},_onTick:function(){
if(this.timer){
this.timeRemaining-=100;
if(this.lifetime-this.timeRemaining>=this.blockDuration){
if(this.closeNode){
this.closeNode.style.visibility="visible";
}
}
if(!this.timeRemaining){
clearInterval(this.timer);
this.hide();
}else{
if(this.timerNode){
this.timerNode.innerHTML=Math.ceil(this.timeRemaining/1000);
}
}
}
}});
dojo.provide("dojo.widget.ResizeHandle");
dojo.widget.defineWidget("dojo.widget.ResizeHandle",dojo.widget.HtmlWidget,{targetElmId:"",templateCssString:".dojoHtmlResizeHandle {\n\tfloat: right;\n\tposition: absolute;\n\tright: 2px;\n\tbottom: 2px;\n\twidth: 13px;\n\theight: 13px;\n\tz-index: 20;\n\tcursor: nw-resize;\n\tbackground-image: url(grabCorner.gif);\n\tline-height: 0px;\n}\n",templateCssPath:dojo.uri.moduleUri("dojo.widget","templates/ResizeHandle.css"),templateString:"<div class=\"dojoHtmlResizeHandle\"><div></div></div>",postCreate:function(){
dojo.event.connect(this.domNode,"onmousedown",this,"_beginSizing");
},_beginSizing:function(e){
if(this._isSizing){
return false;
}
this.targetWidget=dojo.widget.byId(this.targetElmId);
this.targetDomNode=this.targetWidget?this.targetWidget.domNode:dojo.byId(this.targetElmId);
if(!this.targetDomNode){
return;
}
this._isSizing=true;
this.startPoint={"x":e.clientX,"y":e.clientY};
var mb=dojo.html.getMarginBox(this.targetDomNode);
this.startSize={"w":mb.width,"h":mb.height};
dojo.event.kwConnect({srcObj:dojo.body(),srcFunc:"onmousemove",targetObj:this,targetFunc:"_changeSizing",rate:25});
dojo.event.connect(dojo.body(),"onmouseup",this,"_endSizing");
e.preventDefault();
},_changeSizing:function(e){
try{
if(!e.clientX||!e.clientY){
return;
}
}
catch(e){
return;
}
var dx=this.startPoint.x-e.clientX;
var dy=this.startPoint.y-e.clientY;
var newW=this.startSize.w-dx;
var newH=this.startSize.h-dy;
if(this.minSize){
var mb=dojo.html.getMarginBox(this.targetDomNode);
if(newW<this.minSize.w){
newW=mb.width;
}
if(newH<this.minSize.h){
newH=mb.height;
}
}
if(this.targetWidget){
this.targetWidget.resizeTo(newW,newH);
}else{
dojo.html.setMarginBox(this.targetDomNode,{width:newW,height:newH});
}
e.preventDefault();
},_endSizing:function(e){
dojo.event.disconnect(dojo.body(),"onmousemove",this,"_changeSizing");
dojo.event.disconnect(dojo.body(),"onmouseup",this,"_endSizing");
this._isSizing=false;
}});
dojo.provide("dojo.widget.FloatingPane");
dojo.declare("dojo.widget.FloatingPaneBase",null,{title:"",iconSrc:"",hasShadow:false,constrainToContainer:false,taskBarId:"",resizable:true,titleBarDisplay:true,windowState:"normal",displayCloseAction:false,displayMinimizeAction:false,displayMaximizeAction:false,_max_taskBarConnectAttempts:5,_taskBarConnectAttempts:0,templateString:"<div id=\"${this.widgetId}\" dojoAttachEvent=\"onMouseDown\" class=\"dojoFloatingPane\">\n\t<div dojoAttachPoint=\"titleBar\" class=\"dojoFloatingPaneTitleBar\"  style=\"display:none\">\n\t  \t<img dojoAttachPoint=\"titleBarIcon\"  class=\"dojoFloatingPaneTitleBarIcon\">\n\t\t<div dojoAttachPoint=\"closeAction\" dojoAttachEvent=\"onClick:closeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneCloseIcon\"></div>\n\t\t<div dojoAttachPoint=\"restoreAction\" dojoAttachEvent=\"onClick:restoreWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneRestoreIcon\"></div>\n\t\t<div dojoAttachPoint=\"maximizeAction\" dojoAttachEvent=\"onClick:maximizeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneMaximizeIcon\"></div>\n\t\t<div dojoAttachPoint=\"minimizeAction\" dojoAttachEvent=\"onClick:minimizeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneMinimizeIcon\"></div>\n\t  \t<div dojoAttachPoint=\"titleBarText\" class=\"dojoFloatingPaneTitleText\">${this.title}</div>\n\t</div>\n\n\t<div id=\"${this.widgetId}_container\" dojoAttachPoint=\"containerNode\" class=\"dojoFloatingPaneClient\"></div>\n\n\t<div dojoAttachPoint=\"resizeBar\" class=\"dojoFloatingPaneResizebar\" style=\"display:none\"></div>\n</div>\n",templateCssString:"\n/********** Outer Window ***************/\n\n.dojoFloatingPane {\n\t/* essential css */\n\tposition: absolute;\n\toverflow: visible;\t\t/* so drop shadow is displayed */\n\tz-index: 10;\n\n\t/* styling css */\n\tborder: 1px solid;\n\tborder-color: ThreeDHighlight ThreeDShadow ThreeDShadow ThreeDHighlight;\n\tbackground-color: ThreeDFace;\n}\n\n\n/********** Title Bar ****************/\n\n.dojoFloatingPaneTitleBar {\n\tvertical-align: top;\n\tmargin: 2px 2px 2px 2px;\n\tz-index: 10;\n\tbackground-color: #7596c6;\n\tcursor: default;\n\toverflow: hidden;\n\tborder-color: ThreeDHighlight ThreeDShadow ThreeDShadow ThreeDHighlight;\n\tvertical-align: middle;\n}\n\n.dojoFloatingPaneTitleText {\n\tfloat: left;\n\tpadding: 2px 4px 2px 2px;\n\twhite-space: nowrap;\n\tcolor: CaptionText;\n\tfont: small-caption;\n}\n\n.dojoTitleBarIcon {\n\tfloat: left;\n\theight: 22px;\n\twidth: 22px;\n\tvertical-align: middle;\n\tmargin-right: 5px;\n\tmargin-left: 5px;\n}\n\n.dojoFloatingPaneActions{\n\tfloat: right;\n\tposition: absolute;\n\tright: 2px;\n\ttop: 2px;\n\tvertical-align: middle;\n}\n\n\n.dojoFloatingPaneActionItem {\n\tvertical-align: middle;\n\tmargin-right: 1px;\n\theight: 22px;\n\twidth: 22px;\n}\n\n\n.dojoFloatingPaneTitleBarIcon {\n\t/* essential css */\n\tfloat: left;\n\n\t/* styling css */\n\tmargin-left: 2px;\n\tmargin-right: 4px;\n\theight: 22px;\n}\n\n/* minimize/maximize icons are specified by CSS only */\n.dojoFloatingPaneMinimizeIcon,\n.dojoFloatingPaneMaximizeIcon,\n.dojoFloatingPaneRestoreIcon,\n.dojoFloatingPaneCloseIcon {\n\tvertical-align: middle;\n\theight: 22px;\n\twidth: 22px;\n\tfloat: right;\n}\n.dojoFloatingPaneMinimizeIcon {\n\tbackground-image: url(images/floatingPaneMinimize.gif);\n}\n.dojoFloatingPaneMaximizeIcon {\n\tbackground-image: url(images/floatingPaneMaximize.gif);\n}\n.dojoFloatingPaneRestoreIcon {\n\tbackground-image: url(images/floatingPaneRestore.gif);\n}\n.dojoFloatingPaneCloseIcon {\n\tbackground-image: url(images/floatingPaneClose.gif);\n}\n\n/* bar at bottom of window that holds resize handle */\n.dojoFloatingPaneResizebar {\n\tz-index: 10;\n\theight: 13px;\n\tbackground-color: ThreeDFace;\n}\n\n/************* Client Area ***************/\n\n.dojoFloatingPaneClient {\n\tposition: relative;\n\tz-index: 10;\n\tborder: 1px solid;\n\tborder-color: ThreeDShadow ThreeDHighlight ThreeDHighlight ThreeDShadow;\n\tmargin: 2px;\n\tbackground-color: ThreeDFace;\n\tpadding: 8px;\n\tfont-family: Verdana, Helvetica, Garamond, sans-serif;\n\tfont-size: 12px;\n\toverflow: auto;\n}\n\n",templateCssPath:dojo.uri.moduleUri("dojo.widget","templates/FloatingPane.css"),fillInFloatingPaneTemplate:function(args,frag){
var _b1f=this.getFragNodeRef(frag);
dojo.html.copyStyle(this.domNode,_b1f);
dojo.body().appendChild(this.domNode);
if(!this.isShowing()){
this.windowState="minimized";
}
if(this.iconSrc==""){
dojo.html.removeNode(this.titleBarIcon);
}else{
this.titleBarIcon.src=this.iconSrc.toString();
}
if(this.titleBarDisplay){
this.titleBar.style.display="";
dojo.html.disableSelection(this.titleBar);
this.titleBarIcon.style.display=(this.iconSrc==""?"none":"");
this.minimizeAction.style.display=(this.displayMinimizeAction?"":"none");
this.maximizeAction.style.display=(this.displayMaximizeAction&&this.windowState!="maximized"?"":"none");
this.restoreAction.style.display=(this.displayMaximizeAction&&this.windowState=="maximized"?"":"none");
this.closeAction.style.display=(this.displayCloseAction?"":"none");
this.drag=new dojo.dnd.HtmlDragMoveSource(this.domNode);
if(this.constrainToContainer){
this.drag.constrainTo();
}
this.drag.setDragHandle(this.titleBar);
var self=this;
dojo.event.topic.subscribe("dragMove",function(info){
if(info.source.domNode==self.domNode){
dojo.event.topic.publish("floatingPaneMove",{source:self});
}
});
}
if(this.resizable){
this.resizeBar.style.display="";
this.resizeHandle=dojo.widget.createWidget("ResizeHandle",{targetElmId:this.widgetId,id:this.widgetId+"_resize"});
this.resizeBar.appendChild(this.resizeHandle.domNode);
}
if(this.hasShadow){
this.shadow=new dojo.lfx.shadow(this.domNode);
}
this.bgIframe=new dojo.html.BackgroundIframe(this.domNode);
if(this.taskBarId){
this._taskBarSetup();
}
dojo.body().removeChild(this.domNode);
},postCreate:function(){
if(dojo.hostenv.post_load_){
this._setInitialWindowState();
}else{
dojo.addOnLoad(this,"_setInitialWindowState");
}
},maximizeWindow:function(evt){
var mb=dojo.html.getMarginBox(this.domNode);
this.previous={width:mb.width||this.width,height:mb.height||this.height,left:this.domNode.style.left,top:this.domNode.style.top,bottom:this.domNode.style.bottom,right:this.domNode.style.right};
if(this.domNode.parentNode.style.overflow.toLowerCase()!="hidden"){
this.parentPrevious={overflow:this.domNode.parentNode.style.overflow};
dojo.debug(this.domNode.parentNode.style.overflow);
this.domNode.parentNode.style.overflow="hidden";
}
this.domNode.style.left=dojo.html.getPixelValue(this.domNode.parentNode,"padding-left",true)+"px";
this.domNode.style.top=dojo.html.getPixelValue(this.domNode.parentNode,"padding-top",true)+"px";
if((this.domNode.parentNode.nodeName.toLowerCase()=="body")){
var _b24=dojo.html.getViewport();
var _b25=dojo.html.getPadding(dojo.body());
this.resizeTo(_b24.width-_b25.width,_b24.height-_b25.height);
}else{
var _b26=dojo.html.getContentBox(this.domNode.parentNode);
this.resizeTo(_b26.width,_b26.height);
}
this.maximizeAction.style.display="none";
this.restoreAction.style.display="";
if(this.resizeHandle){
this.resizeHandle.domNode.style.display="none";
}
this.drag.setDragHandle(null);
this.windowState="maximized";
},minimizeWindow:function(evt){
this.hide();
for(var attr in this.parentPrevious){
this.domNode.parentNode.style[attr]=this.parentPrevious[attr];
}
this.lastWindowState=this.windowState;
this.windowState="minimized";
},restoreWindow:function(evt){
if(this.windowState=="minimized"){
this.show();
if(this.lastWindowState=="maximized"){
this.domNode.parentNode.style.overflow="hidden";
this.windowState="maximized";
}else{
this.windowState="normal";
}
}else{
if(this.windowState=="maximized"){
for(var attr in this.previous){
this.domNode.style[attr]=this.previous[attr];
}
for(var attr in this.parentPrevious){
this.domNode.parentNode.style[attr]=this.parentPrevious[attr];
}
this.resizeTo(this.previous.width,this.previous.height);
this.previous=null;
this.parentPrevious=null;
this.restoreAction.style.display="none";
this.maximizeAction.style.display=this.displayMaximizeAction?"":"none";
if(this.resizeHandle){
this.resizeHandle.domNode.style.display="";
}
this.drag.setDragHandle(this.titleBar);
this.windowState="normal";
}else{
}
}
},toggleDisplay:function(){
if(this.windowState=="minimized"){
this.restoreWindow();
}else{
this.minimizeWindow();
}
},closeWindow:function(evt){
dojo.html.removeNode(this.domNode);
this.destroy();
},onMouseDown:function(evt){
this.bringToTop();
},bringToTop:function(){
var _b2d=dojo.widget.manager.getWidgetsByType(this.widgetType);
var _b2e=[];
for(var x=0;x<_b2d.length;x++){
if(this.widgetId!=_b2d[x].widgetId){
_b2e.push(_b2d[x]);
}
}
_b2e.sort(function(a,b){
return a.domNode.style.zIndex-b.domNode.style.zIndex;
});
_b2e.push(this);
var _b32=100;
for(x=0;x<_b2e.length;x++){
_b2e[x].domNode.style.zIndex=_b32+x*2;
}
},_setInitialWindowState:function(){
if(this.isShowing()){
this.width=-1;
var mb=dojo.html.getMarginBox(this.domNode);
this.resizeTo(mb.width,mb.height);
}
if(this.windowState=="maximized"){
this.maximizeWindow();
this.show();
return;
}
if(this.windowState=="normal"){
this.show();
return;
}
if(this.windowState=="minimized"){
this.hide();
return;
}
this.windowState="minimized";
},_taskBarSetup:function(){
var _b34=dojo.widget.getWidgetById(this.taskBarId);
if(!_b34){
if(this._taskBarConnectAttempts<this._max_taskBarConnectAttempts){
dojo.lang.setTimeout(this,this._taskBarSetup,50);
this._taskBarConnectAttempts++;
}else{
dojo.debug("Unable to connect to the taskBar");
}
return;
}
_b34.addChild(this);
},showFloatingPane:function(){
this.bringToTop();
},onFloatingPaneShow:function(){
var mb=dojo.html.getMarginBox(this.domNode);
this.resizeTo(mb.width,mb.height);
},resizeTo:function(_b36,_b37){
dojo.html.setMarginBox(this.domNode,{width:_b36,height:_b37});
dojo.widget.html.layout(this.domNode,[{domNode:this.titleBar,layoutAlign:"top"},{domNode:this.resizeBar,layoutAlign:"bottom"},{domNode:this.containerNode,layoutAlign:"client"}]);
dojo.widget.html.layout(this.containerNode,this.children,"top-bottom");
this.bgIframe.onResized();
if(this.shadow){
this.shadow.size(_b36,_b37);
}
this.onResized();
},checkSize:function(){
},destroyFloatingPane:function(){
if(this.resizeHandle){
this.resizeHandle.destroy();
this.resizeHandle=null;
}
}});
dojo.widget.defineWidget("dojo.widget.FloatingPane",[dojo.widget.ContentPane,dojo.widget.FloatingPaneBase],{fillInTemplate:function(args,frag){
this.fillInFloatingPaneTemplate(args,frag);
dojo.widget.FloatingPane.superclass.fillInTemplate.call(this,args,frag);
},postCreate:function(){
dojo.widget.FloatingPaneBase.prototype.postCreate.apply(this,arguments);
dojo.widget.FloatingPane.superclass.postCreate.apply(this,arguments);
},show:function(){
dojo.widget.FloatingPane.superclass.show.apply(this,arguments);
this.showFloatingPane();
},onShow:function(){
dojo.widget.FloatingPane.superclass.onShow.call(this);
this.onFloatingPaneShow();
},destroy:function(){
this.destroyFloatingPane();
dojo.widget.FloatingPane.superclass.destroy.apply(this,arguments);
}});
dojo.widget.defineWidget("dojo.widget.ModalFloatingPane",[dojo.widget.FloatingPane,dojo.widget.ModalDialogBase],{windowState:"minimized",displayCloseAction:true,postCreate:function(){
dojo.widget.ModalDialogBase.prototype.postCreate.call(this);
dojo.widget.ModalFloatingPane.superclass.postCreate.call(this);
},show:function(){
this.showModalDialog();
dojo.widget.ModalFloatingPane.superclass.show.apply(this,arguments);
this.bg.style.zIndex=this.domNode.style.zIndex-1;
},hide:function(){
this.hideModalDialog();
dojo.widget.ModalFloatingPane.superclass.hide.apply(this,arguments);
},closeWindow:function(){
this.hide();
dojo.widget.ModalFloatingPane.superclass.closeWindow.apply(this,arguments);
}});
dojo.provide("dojo.widget.Editor2Plugin.AlwaysShowToolbar");
dojo.event.topic.subscribe("dojo.widget.Editor2::onLoad",function(_b3a){
if(_b3a.toolbarAlwaysVisible){
var p=new dojo.widget.Editor2Plugin.AlwaysShowToolbar(_b3a);
}
});
dojo.declare("dojo.widget.Editor2Plugin.AlwaysShowToolbar",null,function(_b3c){
this.editor=_b3c;
this.editor.registerLoadedPlugin(this);
this.setup();
},{_scrollSetUp:false,_fixEnabled:false,_scrollThreshold:false,_handleScroll:true,setup:function(){
var tdn=this.editor.toolbarWidget;
if(!tdn.tbBgIframe){
tdn.tbBgIframe=new dojo.html.BackgroundIframe(tdn.domNode);
tdn.tbBgIframe.onResized();
}
this.scrollInterval=setInterval(dojo.lang.hitch(this,"globalOnScrollHandler"),100);
dojo.event.connect("before",this.editor.toolbarWidget,"destroy",this,"destroy");
},globalOnScrollHandler:function(){
var isIE=dojo.render.html.ie;
if(!this._handleScroll){
return;
}
var dh=dojo.html;
var tdn=this.editor.toolbarWidget.domNode;
var db=dojo.body();
if(!this._scrollSetUp){
this._scrollSetUp=true;
var _b42=dh.getMarginBox(this.editor.domNode).width;
this._scrollThreshold=dh.abs(tdn,true).y;
if((isIE)&&(db)&&(dh.getStyle(db,"background-image")=="none")){
with(db.style){
backgroundImage="url("+dojo.uri.moduleUri("dojo.widget","templates/images/blank.gif")+")";
backgroundAttachment="fixed";
}
}
}
var _b43=(window["pageYOffset"])?window["pageYOffset"]:(document["documentElement"]||document["body"]).scrollTop;
if(_b43>this._scrollThreshold){
if(!this._fixEnabled){
var _b44=dojo.html.getMarginBox(tdn);
this.editor.editorObject.style.marginTop=_b44.height+"px";
if(isIE){
tdn.style.left=dojo.html.abs(tdn,dojo.html.boxSizing.MARGIN_BOX).x;
if(tdn.previousSibling){
this._IEOriginalPos=["after",tdn.previousSibling];
}else{
if(tdn.nextSibling){
this._IEOriginalPos=["before",tdn.nextSibling];
}else{
this._IEOriginalPos=["",tdn.parentNode];
}
}
dojo.body().appendChild(tdn);
dojo.html.addClass(tdn,"IEFixedToolbar");
}else{
with(tdn.style){
position="fixed";
top="0px";
}
}
tdn.style.width=_b44.width+"px";
tdn.style.zIndex=1000;
this._fixEnabled=true;
}
if(!dojo.render.html.safari){
var _b45=(this.height)?parseInt(this.editor.height):this.editor._lastHeight;
if(_b43>(this._scrollThreshold+_b45)){
tdn.style.display="none";
}else{
tdn.style.display="";
}
}
}else{
if(this._fixEnabled){
(this.editor.object||this.editor.iframe).style.marginTop=null;
with(tdn.style){
position="";
top="";
zIndex="";
display="";
}
if(isIE){
tdn.style.left="";
dojo.html.removeClass(tdn,"IEFixedToolbar");
if(this._IEOriginalPos){
dojo.html.insertAtPosition(tdn,this._IEOriginalPos[1],this._IEOriginalPos[0]);
this._IEOriginalPos=null;
}else{
dojo.html.insertBefore(tdn,this.editor.object||this.editor.iframe);
}
}
tdn.style.width="";
this._fixEnabled=false;
}
}
},destroy:function(){
this._IEOriginalPos=null;
this._handleScroll=false;
clearInterval(this.scrollInterval);
this.editor.unregisterLoadedPlugin(this);
if(dojo.render.html.ie){
dojo.html.removeClass(this.editor.toolbarWidget.domNode,"IEFixedToolbar");
}
}});
dojo.provide("dojo.widget.Editor2");
dojo.widget.Editor2Manager=new dojo.widget.HandlerManager;
dojo.lang.mixin(dojo.widget.Editor2Manager,{_currentInstance:null,commandState:{Disabled:0,Latched:1,Enabled:2},getCurrentInstance:function(){
return this._currentInstance;
},setCurrentInstance:function(inst){
this._currentInstance=inst;
},getCommand:function(_b47,name){
var _b49;
name=name.toLowerCase();
for(var i=0;i<this._registeredHandlers.length;i++){
_b49=this._registeredHandlers[i](_b47,name);
if(_b49){
return _b49;
}
}
switch(name){
case "htmltoggle":
_b49=new dojo.widget.Editor2BrowserCommand(_b47,name);
break;
case "formatblock":
_b49=new dojo.widget.Editor2FormatBlockCommand(_b47,name);
break;
case "anchor":
_b49=new dojo.widget.Editor2Command(_b47,name);
break;
case "createlink":
_b49=new dojo.widget.Editor2DialogCommand(_b47,name,{contentFile:"dojo.widget.Editor2Plugin.CreateLinkDialog",contentClass:"Editor2CreateLinkDialog",title:"Insert/Edit Link",width:"300px",height:"200px"});
break;
case "insertimage":
_b49=new dojo.widget.Editor2DialogCommand(_b47,name,{contentFile:"dojo.widget.Editor2Plugin.InsertImageDialog",contentClass:"Editor2InsertImageDialog",title:"Insert/Edit Image",width:"400px",height:"270px"});
break;
default:
var _b4b=this.getCurrentInstance();
if((_b4b&&_b4b.queryCommandAvailable(name))||(!_b4b&&dojo.widget.Editor2.prototype.queryCommandAvailable(name))){
_b49=new dojo.widget.Editor2BrowserCommand(_b47,name);
}else{
dojo.debug("dojo.widget.Editor2Manager.getCommand: Unknown command "+name);
return;
}
}
return _b49;
},destroy:function(){
this._currentInstance=null;
dojo.widget.HandlerManager.prototype.destroy.call(this);
}});
dojo.addOnUnload(dojo.widget.Editor2Manager,"destroy");
dojo.lang.declare("dojo.widget.Editor2Command",null,function(_b4c,name){
this._editor=_b4c;
this._updateTime=0;
this._name=name;
},{_text:"Unknown",execute:function(para){
dojo.unimplemented("dojo.widget.Editor2Command.execute");
},getText:function(){
return this._text;
},getState:function(){
return dojo.widget.Editor2Manager.commandState.Enabled;
},destroy:function(){
}});
dojo.widget.Editor2BrowserCommandNames={"bold":"Bold","copy":"Copy","cut":"Cut","Delete":"Delete","indent":"Indent","inserthorizontalrule":"Horizental Rule","insertorderedlist":"Numbered List","insertunorderedlist":"Bullet List","italic":"Italic","justifycenter":"Align Center","justifyfull":"Justify","justifyleft":"Align Left","justifyright":"Align Right","outdent":"Outdent","paste":"Paste","redo":"Redo","removeformat":"Remove Format","selectall":"Select All","strikethrough":"Strikethrough","subscript":"Subscript","superscript":"Superscript","underline":"Underline","undo":"Undo","unlink":"Remove Link","createlink":"Create Link","insertimage":"Insert Image","htmltoggle":"HTML Source","forecolor":"Foreground Color","hilitecolor":"Background Color","plainformatblock":"Paragraph Style","formatblock":"Paragraph Style","fontsize":"Font Size","fontname":"Font Name"};
dojo.lang.declare("dojo.widget.Editor2BrowserCommand",dojo.widget.Editor2Command,function(_b4f,name){
var text=dojo.widget.Editor2BrowserCommandNames[name.toLowerCase()];
if(text){
this._text=text;
}
},{execute:function(para){
this._editor.execCommand(this._name,para);
},getState:function(){
if(this._editor._lastStateTimestamp>this._updateTime||this._state==undefined){
this._updateTime=this._editor._lastStateTimestamp;
try{
if(this._editor.queryCommandEnabled(this._name)){
if(this._editor.queryCommandState(this._name)){
this._state=dojo.widget.Editor2Manager.commandState.Latched;
}else{
this._state=dojo.widget.Editor2Manager.commandState.Enabled;
}
}else{
this._state=dojo.widget.Editor2Manager.commandState.Disabled;
}
}
catch(e){
this._state=dojo.widget.Editor2Manager.commandState.Enabled;
}
}
return this._state;
},getValue:function(){
try{
return this._editor.queryCommandValue(this._name);
}
catch(e){
}
}});
dojo.lang.declare("dojo.widget.Editor2FormatBlockCommand",dojo.widget.Editor2BrowserCommand,{});
dojo.widget.defineWidget("dojo.widget.Editor2Dialog",[dojo.widget.HtmlWidget,dojo.widget.FloatingPaneBase,dojo.widget.ModalDialogBase],{templateString:"<div id=\"${this.widgetId}\" class=\"dojoFloatingPane\">\n\t<span dojoattachpoint=\"tabStartOuter\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\"\ttabindex=\"0\"></span>\n\t<span dojoattachpoint=\"tabStart\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<div dojoAttachPoint=\"titleBar\" class=\"dojoFloatingPaneTitleBar\"  style=\"display:none\">\n\t  \t<img dojoAttachPoint=\"titleBarIcon\"  class=\"dojoFloatingPaneTitleBarIcon\">\n\t\t<div dojoAttachPoint=\"closeAction\" dojoAttachEvent=\"onClick:hide\"\n   \t  \t\tclass=\"dojoFloatingPaneCloseIcon\"></div>\n\t\t<div dojoAttachPoint=\"restoreAction\" dojoAttachEvent=\"onClick:restoreWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneRestoreIcon\"></div>\n\t\t<div dojoAttachPoint=\"maximizeAction\" dojoAttachEvent=\"onClick:maximizeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneMaximizeIcon\"></div>\n\t\t<div dojoAttachPoint=\"minimizeAction\" dojoAttachEvent=\"onClick:minimizeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneMinimizeIcon\"></div>\n\t  \t<div dojoAttachPoint=\"titleBarText\" class=\"dojoFloatingPaneTitleText\">${this.title}</div>\n\t</div>\n\n\t<div id=\"${this.widgetId}_container\" dojoAttachPoint=\"containerNode\" class=\"dojoFloatingPaneClient\"></div>\n\t<span dojoattachpoint=\"tabEnd\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<span dojoattachpoint=\"tabEndOuter\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<div dojoAttachPoint=\"resizeBar\" class=\"dojoFloatingPaneResizebar\" style=\"display:none\"></div>\n</div>\n",modal:true,width:"",height:"",windowState:"minimized",displayCloseAction:true,contentFile:"",contentClass:"",fillInTemplate:function(args,frag){
this.fillInFloatingPaneTemplate(args,frag);
dojo.widget.Editor2Dialog.superclass.fillInTemplate.call(this,args,frag);
},postCreate:function(){
if(this.contentFile){
dojo.require(this.contentFile);
}
if(this.modal){
dojo.widget.ModalDialogBase.prototype.postCreate.call(this);
}else{
with(this.domNode.style){
zIndex=999;
display="none";
}
}
dojo.widget.FloatingPaneBase.prototype.postCreate.apply(this,arguments);
dojo.widget.Editor2Dialog.superclass.postCreate.call(this);
if(this.width&&this.height){
with(this.domNode.style){
width=this.width;
height=this.height;
}
}
},createContent:function(){
if(!this.contentWidget&&this.contentClass){
this.contentWidget=dojo.widget.createWidget(this.contentClass);
this.addChild(this.contentWidget);
}
},show:function(){
if(!this.contentWidget){
dojo.widget.Editor2Dialog.superclass.show.apply(this,arguments);
this.createContent();
dojo.widget.Editor2Dialog.superclass.hide.call(this);
}
if(!this.contentWidget||!this.contentWidget.loadContent()){
return;
}
this.showFloatingPane();
dojo.widget.Editor2Dialog.superclass.show.apply(this,arguments);
if(this.modal){
this.showModalDialog();
}
if(this.modal){
this.bg.style.zIndex=this.domNode.style.zIndex-1;
}
},onShow:function(){
dojo.widget.Editor2Dialog.superclass.onShow.call(this);
this.onFloatingPaneShow();
},closeWindow:function(){
this.hide();
dojo.widget.Editor2Dialog.superclass.closeWindow.apply(this,arguments);
},hide:function(){
if(this.modal){
this.hideModalDialog();
}
dojo.widget.Editor2Dialog.superclass.hide.call(this);
},checkSize:function(){
if(this.isShowing()){
if(this.modal){
this._sizeBackground();
}
this.placeModalDialog();
this.onResized();
}
}});
dojo.widget.defineWidget("dojo.widget.Editor2DialogContent",dojo.widget.HtmlWidget,{widgetsInTemplate:true,loadContent:function(){
return true;
},cancel:function(){
this.parent.hide();
}});
dojo.lang.declare("dojo.widget.Editor2DialogCommand",dojo.widget.Editor2BrowserCommand,function(_b55,name,_b57){
this.dialogParas=_b57;
},{execute:function(){
if(!this.dialog){
if(!this.dialogParas.contentFile||!this.dialogParas.contentClass){
alert("contentFile and contentClass should be set for dojo.widget.Editor2DialogCommand.dialogParas!");
return;
}
this.dialog=dojo.widget.createWidget("Editor2Dialog",this.dialogParas);
dojo.body().appendChild(this.dialog.domNode);
dojo.event.connect(this,"destroy",this.dialog,"destroy");
}
this.dialog.show();
},getText:function(){
return this.dialogParas.title||dojo.widget.Editor2DialogCommand.superclass.getText.call(this);
}});
dojo.widget.Editor2ToolbarGroups={};
dojo.widget.defineWidget("dojo.widget.Editor2",dojo.widget.RichText,function(){
this._loadedCommands={};
},{toolbarAlwaysVisible:false,toolbarWidget:null,scrollInterval:null,toolbarTemplatePath:dojo.uri.cache.set(dojo.uri.moduleUri("dojo.widget","templates/EditorToolbarOneline.html"), "<div class=\"EditorToolbarDomNode EditorToolbarSmallBg\">\n\t<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\">\n\t\t<tbody>\n\t\t\t<tr valign=\"top\" align=\"left\">\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"htmltoggle\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon\" \n\t\t\t\t\t\tstyle=\"background-image: none; width: 30px;\" >&lt;h&gt;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"copy\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Copy\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"paste\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Paste\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"undo\">\n\t\t\t\t\t\t<!-- FIXME: should we have the text \"undo\" here? -->\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Undo\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"redo\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Redo\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td isSpacer=\"true\">\n\t\t\t\t\t<span class=\"iconContainer\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Sep\"\tstyle=\"width: 5px; min-width: 5px;\"></span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"createlink\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Link\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"insertimage\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Image\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"inserthorizontalrule\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_HorizontalLine \">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"bold\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Bold\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"italic\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Italic\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"underline\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Underline\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"strikethrough\">\n\t\t\t\t\t\t<span \n\t\t\t\t\t\t\tclass=\"dojoE2TBIcon dojoE2TBIcon_StrikeThrough\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td isSpacer=\"true\">\n\t\t\t\t\t<span class=\"iconContainer\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Sep\" \n\t\t\t\t\t\t\tstyle=\"width: 5px; min-width: 5px;\"></span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"insertunorderedlist\">\n\t\t\t\t\t\t<span \n\t\t\t\t\t\t\tclass=\"dojoE2TBIcon dojoE2TBIcon_BulletedList\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"insertorderedlist\">\n\t\t\t\t\t\t<span \n\t\t\t\t\t\t\tclass=\"dojoE2TBIcon dojoE2TBIcon_NumberedList\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td isSpacer=\"true\">\n\t\t\t\t\t<span class=\"iconContainer\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Sep\" style=\"width: 5px; min-width: 5px;\"></span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"indent\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Indent\" \n\t\t\t\t\t\t\tunselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"outdent\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Outdent\" \n\t\t\t\t\t\t\tunselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td isSpacer=\"true\">\n\t\t\t\t\t<span class=\"iconContainer\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Sep\" style=\"width: 5px; min-width: 5px;\"></span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"forecolor\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_TextColor\" \n\t\t\t\t\t\t\tunselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"hilitecolor\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_BackgroundColor\" \n\t\t\t\t\t\t\tunselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td isSpacer=\"true\">\n\t\t\t\t\t<span class=\"iconContainer\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Sep\" style=\"width: 5px; min-width: 5px;\"></span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"justifyleft\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_LeftJustify\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"justifycenter\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_CenterJustify\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"justifyright\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_RightJustify\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"justifyfull\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_BlockJustify\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\t\n\t\t\t\t<td>\n\t\t\t\t\t<select class=\"dojoEditorToolbarItem\" dojoETItemName=\"plainformatblock\">\n\t\t\t\t\t\t<!-- FIXME: using \"p\" here inserts a paragraph in most cases! -->\n\t\t\t\t\t\t<option value=\"\">-- format --</option>\n\t\t\t\t\t\t<option value=\"p\">Normal</option>\n\t\t\t\t\t\t<option value=\"pre\">Fixed Font</option>\n\t\t\t\t\t\t<option value=\"h1\">Main Heading</option>\n\t\t\t\t\t\t<option value=\"h2\">Section Heading</option>\n\t\t\t\t\t\t<option value=\"h3\">Sub-Heading</option>\n\t\t\t\t\t\t<!-- <option value=\"blockquote\">Block Quote</option> -->\n\t\t\t\t\t</select>\n\t\t\t\t</td>\n\t\t\t\t<td><!-- uncomment to enable save button -->\n\t\t\t\t\t<!-- save -->\n\t\t\t\t\t<!--span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"save\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Save\">&nbsp;</span>\n\t\t\t\t\t</span-->\n\t\t\t\t</td>\n\t\t\t\t<td width=\"*\">&nbsp;</td>\n\t\t\t</tr>\n\t\t</tbody>\n\t</table>\n</div>\n"),toolbarTemplateCssPath:null,toolbarPlaceHolder:"",_inSourceMode:false,_htmlEditNode:null,toolbarGroup:"",shareToolbar:false,contextMenuGroupSet:"",editorOnLoad:function(){
dojo.event.topic.publish("dojo.widget.Editor2::preLoadingToolbar",this);
if(this.toolbarAlwaysVisible){
}
if(this.toolbarWidget){
this.toolbarWidget.show();
dojo.html.insertBefore(this.toolbarWidget.domNode,this.domNode.firstChild);
}else{
if(this.shareToolbar){
dojo.deprecated("Editor2:shareToolbar is deprecated in favor of toolbarGroup","0.5");
this.toolbarGroup="defaultDojoToolbarGroup";
}
if(this.toolbarGroup){
if(dojo.widget.Editor2ToolbarGroups[this.toolbarGroup]){
this.toolbarWidget=dojo.widget.Editor2ToolbarGroups[this.toolbarGroup];
}
}
if(!this.toolbarWidget){
var _b58={shareGroup:this.toolbarGroup,parent:this};
_b58.templateString=dojo.uri.cache.get(this.toolbarTemplatePath);
if(this.toolbarTemplateCssPath){
_b58.templateCssPath=this.toolbarTemplateCssPath;
_b58.templateCssString=dojo.uri.cache.get(this.toolbarTemplateCssPath);
}
if(this.toolbarPlaceHolder){
this.toolbarWidget=dojo.widget.createWidget("Editor2Toolbar",_b58,dojo.byId(this.toolbarPlaceHolder),"after");
}else{
this.toolbarWidget=dojo.widget.createWidget("Editor2Toolbar",_b58,this.domNode.firstChild,"before");
}
if(this.toolbarGroup){
dojo.widget.Editor2ToolbarGroups[this.toolbarGroup]=this.toolbarWidget;
}
dojo.event.connect(this,"close",this.toolbarWidget,"hide");
this.toolbarLoaded();
}
}
dojo.event.topic.registerPublisher("Editor2.clobberFocus",this,"clobberFocus");
dojo.event.topic.subscribe("Editor2.clobberFocus",this,"setBlur");
dojo.event.topic.publish("dojo.widget.Editor2::onLoad",this);
},toolbarLoaded:function(){
},registerLoadedPlugin:function(obj){
if(!this.loadedPlugins){
this.loadedPlugins=[];
}
this.loadedPlugins.push(obj);
},unregisterLoadedPlugin:function(obj){
for(var i in this.loadedPlugins){
if(this.loadedPlugins[i]===obj){
delete this.loadedPlugins[i];
return;
}
}
dojo.debug("dojo.widget.Editor2.unregisterLoadedPlugin: unknow plugin object: "+obj);
},execCommand:function(_b5c,_b5d){
switch(_b5c.toLowerCase()){
case "htmltoggle":
this.toggleHtmlEditing();
break;
default:
dojo.widget.Editor2.superclass.execCommand.apply(this,arguments);
}
},queryCommandEnabled:function(_b5e,_b5f){
switch(_b5e.toLowerCase()){
case "htmltoggle":
return true;
default:
if(this._inSourceMode){
return false;
}
return dojo.widget.Editor2.superclass.queryCommandEnabled.apply(this,arguments);
}
},queryCommandState:function(_b60,_b61){
switch(_b60.toLowerCase()){
case "htmltoggle":
return this._inSourceMode;
default:
return dojo.widget.Editor2.superclass.queryCommandState.apply(this,arguments);
}
},onClick:function(e){
dojo.widget.Editor2.superclass.onClick.call(this,e);
if(dojo.widget.PopupManager){
if(!e){
e=this.window.event;
}
dojo.widget.PopupManager.onClick(e);
}
},clobberFocus:function(){
},toggleHtmlEditing:function(){
if(this===dojo.widget.Editor2Manager.getCurrentInstance()){
if(!this._inSourceMode){
var html=this.getEditorContent();
this._inSourceMode=true;
if(!this._htmlEditNode){
this._htmlEditNode=dojo.doc().createElement("textarea");
dojo.html.insertAfter(this._htmlEditNode,this.editorObject);
}
this._htmlEditNode.style.display="";
this._htmlEditNode.style.width="100%";
this._htmlEditNode.style.height=dojo.html.getBorderBox(this.editNode).height+"px";
this._htmlEditNode.value=html;
with(this.editorObject.style){
position="absolute";
left="-2000px";
top="-2000px";
}
}else{
this._inSourceMode=false;
this._htmlEditNode.blur();
with(this.editorObject.style){
position="";
left="";
top="";
}
var html=this._htmlEditNode.value;
dojo.lang.setTimeout(this,"replaceEditorContent",1,html);
this._htmlEditNode.style.display="none";
this.focus();
}
this.onDisplayChanged(null,true);
}
},setFocus:function(){
if(dojo.widget.Editor2Manager.getCurrentInstance()===this){
return;
}
this.clobberFocus();
dojo.widget.Editor2Manager.setCurrentInstance(this);
},setBlur:function(){
},saveSelection:function(){
this._bookmark=null;
this._bookmark=dojo.withGlobal(this.window,dojo.html.selection.getBookmark);
},restoreSelection:function(){
if(this._bookmark){
this.focus();
dojo.withGlobal(this.window,"moveToBookmark",dojo.html.selection,[this._bookmark]);
this._bookmark=null;
}else{
dojo.debug("restoreSelection: no saved selection is found!");
}
},_updateToolbarLastRan:null,_updateToolbarTimer:null,_updateToolbarFrequency:500,updateToolbar:function(_b64){
if((!this.isLoaded)||(!this.toolbarWidget)){
return;
}
var diff=new Date()-this._updateToolbarLastRan;
if((!_b64)&&(this._updateToolbarLastRan)&&((diff<this._updateToolbarFrequency))){
clearTimeout(this._updateToolbarTimer);
var _b66=this;
this._updateToolbarTimer=setTimeout(function(){
_b66.updateToolbar();
},this._updateToolbarFrequency/2);
return;
}else{
this._updateToolbarLastRan=new Date();
}
if(dojo.widget.Editor2Manager.getCurrentInstance()!==this){
return;
}
this.toolbarWidget.update();
},destroy:function(_b67){
this._htmlEditNode=null;
dojo.event.disconnect(this,"close",this.toolbarWidget,"hide");
if(!_b67){
this.toolbarWidget.destroy();
}
dojo.widget.Editor2.superclass.destroy.call(this);
},_lastStateTimestamp:0,onDisplayChanged:function(e,_b69){
this._lastStateTimestamp=(new Date()).getTime();
dojo.widget.Editor2.superclass.onDisplayChanged.call(this,e);
this.updateToolbar(_b69);
},onLoad:function(){
try{
dojo.widget.Editor2.superclass.onLoad.call(this);
}
catch(e){
dojo.debug(e);
}
this.editorOnLoad();
},onFocus:function(){
dojo.widget.Editor2.superclass.onFocus.call(this);
this.setFocus();
},getEditorContent:function(){
if(this._inSourceMode){
return this._htmlEditNode.value;
}
return dojo.widget.Editor2.superclass.getEditorContent.call(this);
},replaceEditorContent:function(html){
if(this._inSourceMode){
this._htmlEditNode.value=html;
return;
}
dojo.widget.Editor2.superclass.replaceEditorContent.apply(this,arguments);
},getCommand:function(name){
if(this._loadedCommands[name]){
return this._loadedCommands[name];
}
var cmd=dojo.widget.Editor2Manager.getCommand(this,name);
this._loadedCommands[name]=cmd;
return cmd;
},shortcuts:[["bold"],["italic"],["underline"],["selectall","a"],["insertunorderedlist","\\"]],setupDefaultShortcuts:function(){
var exec=function(cmd){
return function(){
cmd.execute();
};
};
var self=this;
dojo.lang.forEach(this.shortcuts,function(item){
var cmd=self.getCommand(item[0]);
if(cmd){
self.addKeyHandler(item[1]?item[1]:item[0].charAt(0),item[2]==undefined?self.KEY_CTRL:item[2],exec(cmd));
}
});
}});


__CPAN_EDITION__ editor build.txt
Files baked into this build:
dojoGuardStart.js
../src/bootstrap1.js
../src/loader.js
dojoGuardEnd.js
../src/hostenv_browser.js
../src/dom.js
../src/xml/Parse.js
../src/lang/common.js
../src/lang/func.js
../src/lang/array.js
../src/lang/extras.js
../src/lang/declare.js
../src/ns.js
../src/event/common.js
../src/event/topic.js
../src/event/browser.js
../src/event/__package__.js
../src/widget/Manager.js
../src/uri/Uri.js
../src/uri/__package__.js
../src/html/common.js
../src/a11y.js
../src/widget/Widget.js
../src/widget/Parse.js
../src/html/style.js
../src/widget/DomWidget.js
../src/html/display.js
../src/html/layout.js
../src/html/util.js
../src/gfx/color.js
../src/lfx/Animation.js
../src/html/color.js
../src/lfx/html.js
../src/lfx/__package__.js
../src/lfx/toggle.js
../src/widget/HtmlWidget.js
../src/widget/__package__.js
../src/string/common.js
../src/string.js
../src/io/common.js
../src/string/extras.js
../src/undo/browser.js
../src/io/BrowserIO.js
../src/io/cookie.js
../src/io/__package__.js
../src/html/__package__.js
../src/html/selection.js
../src/Deferred.js
../src/widget/RichText.js
../src/lang/type.js
../src/lang/assert.js
../src/AdapterRegistry.js
../src/lang/repr.js
../src/lang/__package__.js
../src/html/iframe.js
../src/widget/PopupContainer.js
../src/widget/ColorPalette.js
../src/widget/ContentPane.js
../src/widget/Editor2Toolbar.js
../src/uri/cache.js
../src/lfx/shadow.js
../src/widget/html/layout.js
../src/dnd/DragAndDrop.js
../src/dnd/HtmlDragManager.js
../src/dnd/HtmlDragAndDrop.js
../src/dnd/__package__.js
../src/dnd/HtmlDragMove.js
../src/widget/Dialog.js
../src/widget/ResizeHandle.js
../src/widget/FloatingPane.js
../src/widget/Editor2Plugin/AlwaysShowToolbar.js
../src/widget/Editor2.js
__CPAN_EDITION__ event dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:2,flag:"",revision:Number("$Rev: 7616 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
function dj_load_init(e){
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_ee,_ef){
if(!dojo.lang.isFunction(_ef)){
dojo.raise("dojo.inherits: superclass argument ["+_ef+"] must be a function (subclass: ["+_ee+"']");
}
_ee.prototype=new _ef();
_ee.prototype.constructor=_ee;
_ee.superclass=_ef.prototype;
_ee["super"]=_ef.prototype;
};
dojo.lang._mixin=function(obj,_f1){
var _f2={};
for(var x in _f1){
if((typeof _f2[x]=="undefined")||(_f2[x]!=_f1[x])){
obj[x]=_f1[x];
}
}
if(dojo.render.html.ie&&(typeof (_f1["toString"])=="function")&&(_f1["toString"]!=obj["toString"])&&(_f1["toString"]!=_f2["toString"])){
obj.toString=_f1.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_f5){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_f8,_f9){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_f8.prototype,arguments[i]);
}
return _f8;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_fc,_fd,_fe,_ff){
if(!dojo.lang.isArrayLike(_fc)&&dojo.lang.isArrayLike(_fd)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_fc;
_fc=_fd;
_fd=temp;
}
var _101=dojo.lang.isString(_fc);
if(_101){
_fc=_fc.split("");
}
if(_ff){
var step=-1;
var i=_fc.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_fc.length;
}
if(_fe){
while(i!=end){
if(_fc[i]===_fd){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_fc[i]==_fd){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_105,_106,_107){
return dojo.lang.find(_105,_106,_107,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_108,_109){
return dojo.lang.find(_108,_109)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _118=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_118++;
break;
}
}
return _118==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
},map:function(arr,obj,_11c){
var _11d=dojo.lang.isString(arr);
if(_11d){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_11c)){
_11c=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_11c){
var _11e=obj;
obj=_11c;
_11c=_11e;
}
}
if(Array.map){
var _11f=Array.map(arr,_11c,obj);
}else{
var _11f=[];
for(var i=0;i<arr.length;++i){
_11f.push(_11c.call(obj,arr[i]));
}
}
if(_11d){
return _11f.join("");
}else{
return _11f;
}
},reduce:function(arr,_122,obj,_124){
var _125=_122;
if(arguments.length==2){
_124=_122;
_125=arr[0];
arr=arr.slice(1);
}else{
if(arguments.length==3){
if(dojo.lang.isFunction(obj)){
_124=obj;
obj=null;
}
}else{
if(dojo.lang.isFunction(obj)){
var tmp=_124;
_124=obj;
obj=tmp;
}
}
}
var ob=obj||dj_global;
dojo.lang.map(arr,function(val){
_125=_124.call(ob,_125,val);
});
return _125;
},forEach:function(_129,_12a,_12b){
if(dojo.lang.isString(_129)){
_129=_129.split("");
}
if(Array.forEach){
Array.forEach(_129,_12a,_12b);
}else{
if(!_12b){
_12b=dj_global;
}
for(var i=0,l=_129.length;i<l;i++){
_12a.call(_12b,_129[i],i,_129);
}
}
},_everyOrSome:function(_12e,arr,_130,_131){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_12e?"every":"some"](arr,_130,_131);
}else{
if(!_131){
_131=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _134=_130.call(_131,arr[i],i,arr);
if(_12e&&!_134){
return false;
}else{
if((!_12e)&&(_134)){
return true;
}
}
}
return Boolean(_12e);
}
},every:function(arr,_136,_137){
return this._everyOrSome(true,arr,_136,_137);
},some:function(arr,_139,_13a){
return this._everyOrSome(false,arr,_139,_13a);
},filter:function(arr,_13c,_13d){
var _13e=dojo.lang.isString(arr);
if(_13e){
arr=arr.split("");
}
var _13f;
if(Array.filter){
_13f=Array.filter(arr,_13c,_13d);
}else{
if(!_13d){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_13d=dj_global;
}
_13f=[];
for(var i=0;i<arr.length;i++){
if(_13c.call(_13d,arr[i],i,arr)){
_13f.push(arr[i]);
}
}
}
if(_13e){
return _13f.join("");
}else{
return _13f;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_144,_145){
var _146=[];
for(var i=_145||0;i<_144.length;i++){
_146.push(_144[i]);
}
return _146;
}});
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_149){
var _14a=window,_14b=2;
if(!dojo.lang.isFunction(func)){
_14a=func;
func=_149;
_149=arguments[2];
_14b++;
}
if(dojo.lang.isString(func)){
func=_14a[func];
}
var args=[];
for(var i=_14b;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_14a,args);
},_149);
};
dojo.lang.clearTimeout=function(_14e){
dojo.global().clearTimeout(_14e);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_157,_158,_159){
with(dojo.parseObjPath(_157,_158,_159)){
return dojo.evalProp(prop,obj,_159);
}
};
dojo.lang.setObjPathValue=function(_15a,_15b,_15c,_15d){
dojo.deprecated("dojo.lang.setObjPathValue","use dojo.parseObjPath and the '=' operator","0.6");
if(arguments.length<4){
_15d=true;
}
with(dojo.parseObjPath(_15a,_15c,_15d)){
if(obj&&(_15d||(prop in obj))){
obj[prop]=_15b;
}
}
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_15e,_15f){
var fcn=(dojo.lang.isString(_15f)?_15e[_15f]:_15f)||function(){
};
return function(){
return fcn.apply(_15e,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_161,_162,_163){
var nso=(_162||dojo.lang.anon);
if((_163)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_161){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_161;
return ret;
};
dojo.lang.forward=function(_167){
return function(){
return this[_167].apply(this,arguments);
};
};
dojo.lang.curry=function(_168,func){
var _16a=[];
_168=_168||dj_global;
if(dojo.lang.isString(func)){
func=_168[func];
}
for(var x=2;x<arguments.length;x++){
_16a.push(arguments[x]);
}
var _16c=(func["__preJoinArity"]||func.length)-_16a.length;
function gather(_16d,_16e,_16f){
var _170=_16f;
var _171=_16e.slice(0);
for(var x=0;x<_16d.length;x++){
_171.push(_16d[x]);
}
_16f=_16f-_16d.length;
if(_16f<=0){
var res=func.apply(_168,_171);
_16f=_170;
return res;
}else{
return function(){
return gather(arguments,_171,_16f);
};
}
}
return gather([],_16a,_16c);
};
dojo.lang.curryArguments=function(_174,func,args,_177){
var _178=[];
var x=_177||0;
for(x=_177;x<args.length;x++){
_178.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_174,func].concat(_178));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_17e,_17f){
if(!farr.length){
if(typeof _17f=="function"){
_17f();
}
return;
}
if((typeof _17e=="undefined")&&(typeof cb=="number")){
_17e=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_17e){
_17e=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_17e,_17f);
},_17e);
};
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_181){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false,maxCalls:-1};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _184=dl.nameAnonFunc(args[2],ao.adviceObj,_181);
ao.adviceFunc=_184;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _184=dl.nameAnonFunc(args[0],ao.srcObj,_181);
ao.srcFunc=_184;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _184=dl.nameAnonFunc(args[1],dj_global,_181);
ao.srcFunc=_184;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _184=dl.nameAnonFunc(args[3],dj_global,_181);
ao.adviceObj=dj_global;
ao.adviceFunc=_184;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
ao.maxCalls=(!isNaN(parseInt(args[11])))?args[11]:-1;
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _184=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_181);
ao.aroundFunc=_184;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _186={};
for(var x in ao){
_186[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_186.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_186));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _18e;
if((arguments.length==1)&&(typeof a1=="object")){
_18e=a1;
}else{
_18e={srcObj:a1,srcFunc:a2};
}
_18e.adviceFunc=function(){
var _18f=[];
for(var x=0;x<arguments.length;x++){
_18f.push(arguments[x]);
}
dojo.debug("("+_18e.srcObj+")."+_18e.srcFunc,":",_18f.join(", "));
};
this.kwConnect(_18e);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this.connectRunOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.maxCalls=1;
return this.connect(ao);
};
this._kwConnectImpl=function(_197,_198){
var fn=(_198)?"disconnect":"connect";
if(typeof _197["srcFunc"]=="function"){
_197.srcObj=_197["srcObj"]||dj_global;
var _19a=dojo.lang.nameAnonFunc(_197.srcFunc,_197.srcObj,true);
_197.srcFunc=_19a;
}
if(typeof _197["adviceFunc"]=="function"){
_197.adviceObj=_197["adviceObj"]||dj_global;
var _19a=dojo.lang.nameAnonFunc(_197.adviceFunc,_197.adviceObj,true);
_197.adviceFunc=_19a;
}
_197.srcObj=_197["srcObj"]||dj_global;
_197.adviceObj=_197["adviceObj"]||_197["targetObj"]||dj_global;
_197.adviceFunc=_197["adviceFunc"]||_197["targetFunc"];
return dojo.event[fn](_197);
};
this.kwConnect=function(_19b){
return this._kwConnectImpl(_19b,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
if(!ao.srcObj[ao.srcFunc]){
return null;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc,true);
mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
return mjp;
};
this.kwDisconnect=function(_19e){
return this._kwConnectImpl(_19e,true);
};
};
dojo.event.MethodInvocation=function(_19f,obj,args){
this.jp_=_19f;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_1a7){
this.object=obj||dj_global;
this.methodname=_1a7;
this.methodfunc=this.object[_1a7];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_1a9){
if(!obj){
obj=dj_global;
}
var ofn=obj[_1a9];
if(!ofn){
ofn=obj[_1a9]=function(){
};
if(!obj[_1a9]){
dojo.raise("Cannot set do-nothing method on that object "+_1a9);
}
}else{
if((typeof ofn!="function")&&(!dojo.lang.isFunction(ofn))&&(!dojo.lang.isAlien(ofn))){
return null;
}
}
var _1ab=_1a9+"$joinpoint";
var _1ac=_1a9+"$joinpoint$method";
var _1ad=obj[_1ab];
if(!_1ad){
var _1ae=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_1ae=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_1ab,_1ac,_1a9]);
}
}
var _1af=ofn.length;
obj[_1ac]=ofn;
_1ad=obj[_1ab]=new dojo.event.MethodJoinPoint(obj,_1ac);
if(!_1ae){
obj[_1a9]=function(){
return _1ad.run.apply(_1ad,arguments);
};
}else{
obj[_1a9]=function(){
var args=[];
if(!arguments.length){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _1ad.run.apply(_1ad,args);
};
}
obj[_1a9].__preJoinArity=_1af;
}
return _1ad;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{squelch:false,unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _1b5=[];
for(var x=0;x<args.length;x++){
_1b5[x]=args[x];
}
var _1b7=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _1b9=marr[0]||dj_global;
var _1ba=marr[1];
if(!_1b9[_1ba]){
dojo.raise("function \""+_1ba+"\" does not exist on \""+_1b9+"\"");
}
var _1bb=marr[2]||dj_global;
var _1bc=marr[3];
var msg=marr[6];
var _1be=marr[7];
if(_1be>-1){
if(_1be==0){
return;
}
marr[7]--;
}
var _1bf;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _1b9[_1ba].apply(_1b9,to.args);
}};
to.args=_1b5;
var _1c1=parseInt(marr[4]);
var _1c2=((!isNaN(_1c1))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _1c5=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_1b7(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_1bc){
_1bb[_1bc].call(_1bb,to);
}else{
if((_1c2)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_1b9[_1ba].call(_1b9,to);
}else{
_1b9[_1ba].apply(_1b9,args);
}
},_1c1);
}else{
if(msg){
_1b9[_1ba].call(_1b9,to);
}else{
_1b9[_1ba].apply(_1b9,args);
}
}
}
};
var _1c8=function(){
if(this.squelch){
try{
return _1b7.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _1b7.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_1c8);
}
var _1c9;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_1c9=mi.proceed();
}else{
if(this.methodfunc){
_1c9=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.debug(e,"when calling",this.methodname,"on",this.object,"with arguments",args);
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_1c8);
}
return (this.methodfunc)?_1c9:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"],args["maxCalls"]);
},addAdvice:function(_1ce,_1cf,_1d0,_1d1,_1d2,_1d3,once,_1d5,rate,_1d7,_1d8){
var arr=this.getArr(_1d2);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_1ce,_1cf,_1d0,_1d1,_1d5,rate,_1d7,_1d8];
if(once){
if(this.hasAdvice(_1ce,_1cf,_1d2,arr)>=0){
return;
}
}
if(_1d3=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_1db,_1dc,_1dd,arr){
if(!arr){
arr=this.getArr(_1dd);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _1dc=="object")?(new String(_1dc)).toString():_1dc;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_1db)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_1e3,_1e4,_1e5,once){
var arr=this.getArr(_1e5);
var ind=this.hasAdvice(_1e3,_1e4,_1e5,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_1e3,_1e4,_1e5,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_1e9){
if(!this.topics[_1e9]){
this.topics[_1e9]=new this.TopicImpl(_1e9);
}
return this.topics[_1e9];
};
this.registerPublisher=function(_1ea,obj,_1ec){
var _1ea=this.getTopic(_1ea);
_1ea.registerPublisher(obj,_1ec);
};
this.subscribe=function(_1ed,obj,_1ef){
var _1ed=this.getTopic(_1ed);
_1ed.subscribe(obj,_1ef);
};
this.unsubscribe=function(_1f0,obj,_1f2){
var _1f0=this.getTopic(_1f0);
_1f0.unsubscribe(obj,_1f2);
};
this.destroy=function(_1f3){
this.getTopic(_1f3).destroy();
delete this.topics[_1f3];
};
this.publishApply=function(_1f4,args){
var _1f4=this.getTopic(_1f4);
_1f4.sendMessage.apply(_1f4,args);
};
this.publish=function(_1f6,_1f7){
var _1f6=this.getTopic(_1f6);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_1f6.sendMessage.apply(_1f6,args);
};
};
dojo.event.topic.TopicImpl=function(_1fa){
this.topicName=_1fa;
this.subscribe=function(_1fb,_1fc){
var tf=_1fc||_1fb;
var to=(!_1fc)?dj_global:_1fb;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_1ff,_200){
var tf=(!_200)?_1ff:_200;
var to=(!_200)?null:_1ff;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_203){
this._getJoinPoint().squelch=_203;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_204,_205){
dojo.event.connect(_204,_205,this,"sendMessage");
};
this.sendMessage=function(_206){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_209){
var na;
var tna;
if(_209){
tna=_209.all||_209.getElementsByTagName("*");
na=[_209];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _20d={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
if(dojo.widget){
for(var name in dojo.widget._templateCache){
if(dojo.widget._templateCache[name].node){
dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
dojo.widget._templateCache[name].node=null;
delete dojo.widget._templateCache[name].node;
}
}
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _212=0;
this.normalizedEventName=function(_213){
switch(_213){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _213;
break;
default:
var lcn=_213.toLowerCase();
return (lcn.indexOf("on")==0)?lcn.substr(2):lcn;
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_218){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_218.length;x++){
node.__clobberAttrs__.push(_218[x]);
}
};
this.removeListener=function(node,_21b,fp,_21d){
if(!_21d){
var _21d=false;
}
_21b=dojo.event.browser.normalizedEventName(_21b);
if(_21b=="key"){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_21d);
}
_21b="keypress";
}
if(node.removeEventListener){
node.removeEventListener(_21b,fp,_21d);
}
};
this.addListener=function(node,_21f,fp,_221,_222){
if(!node){
return;
}
if(!_221){
var _221=false;
}
_21f=dojo.event.browser.normalizedEventName(_21f);
if(_21f=="key"){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_221,_222);
}
_21f="keypress";
}
if(!_222){
var _223=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_221){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_223=fp;
}
if(node.addEventListener){
node.addEventListener(_21f,_223,_221);
return _223;
}else{
_21f="on"+_21f;
if(typeof node[_21f]=="function"){
var _226=node[_21f];
node[_21f]=function(e){
_226(e);
return _223(e);
};
}else{
node[_21f]=_223;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_21f]);
}
return _223;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(obj)&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_229,_22a){
if(typeof _229!="function"){
dojo.raise("listener not a function: "+_229);
}
dojo.event.browser.currentEvent.currentTarget=_22a;
return _229.call(_22a,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_22d){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _22f=evt.keyCode;
if(_22f>=65&&_22f<=90&&evt.shiftKey==false){
_22f+=32;
}
if(_22f>=1&&_22f<=26&&evt.ctrlKey){
_22f+=96;
}
evt.key=String.fromCharCode(_22f);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _22f=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_22f+=32;
}
evt.key=String.fromCharCode(_22f);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 25:
evt.key=evt.KEY_TAB;
evt.shift=true;
break;
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
case 63236:
evt.key=evt.KEY_F1;
break;
case 63237:
evt.key=evt.KEY_F2;
break;
case 63238:
evt.key=evt.KEY_F3;
break;
case 63239:
evt.key=evt.KEY_F4;
break;
case 63240:
evt.key=evt.KEY_F5;
break;
case 63241:
evt.key=evt.KEY_F6;
break;
case 63242:
evt.key=evt.KEY_F7;
break;
case 63243:
evt.key=evt.KEY_F8;
break;
case 63244:
evt.key=evt.KEY_F9;
break;
case 63245:
evt.key=evt.KEY_F10;
break;
case 63246:
evt.key=evt.KEY_F11;
break;
case 63247:
evt.key=evt.KEY_F12;
break;
case 63250:
evt.key=evt.KEY_PAUSE;
break;
case 63272:
evt.key=evt.KEY_DELETE;
break;
case 63273:
evt.key=evt.KEY_HOME;
break;
case 63275:
evt.key=evt.KEY_END;
break;
case 63276:
evt.key=evt.KEY_PAGE_UP;
break;
case 63277:
evt.key=evt.KEY_PAGE_DOWN;
break;
case 63302:
evt.key=evt.KEY_INSERT;
break;
case 63248:
case 63249:
case 63289:
break;
default:
evt.key=evt.charCode>=evt.KEY_SPACE?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_22d?_22d:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _231=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_231.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_231.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.cancelBubble=true;
evt.returnValue=false;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.kwCompoundRequire({common:["dojo.event.common","dojo.event.topic"],browser:["dojo.event.browser"],dashboard:["dojo.event.browser"]});
dojo.provide("dojo.event.*");


__CPAN_EDITION__ event build.txt
Files baked into this build:
dojoGuardStart.js
../src/bootstrap1.js
../src/loader.js
dojoGuardEnd.js
../src/hostenv_browser.js
../src/lang/common.js
../src/lang/array.js
../src/lang/extras.js
../src/lang/func.js
../src/event/common.js
../src/event/topic.js
../src/event/browser.js
../src/event/__package__.js
__CPAN_EDITION__ event_and_io dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:2,flag:"",revision:Number("$Rev: 7616 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
function dj_load_init(e){
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_f4,_f5){
var out="";
for(var i=0;i<_f4;i++){
out+=str;
if(_f5&&i<_f4-1){
out+=_f5;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_103,_104){
if(!dojo.lang.isFunction(_104)){
dojo.raise("dojo.inherits: superclass argument ["+_104+"] must be a function (subclass: ["+_103+"']");
}
_103.prototype=new _104();
_103.prototype.constructor=_103;
_103.superclass=_104.prototype;
_103["super"]=_104.prototype;
};
dojo.lang._mixin=function(obj,_106){
var tobj={};
for(var x in _106){
if((typeof tobj[x]=="undefined")||(tobj[x]!=_106[x])){
obj[x]=_106[x];
}
}
if(dojo.render.html.ie&&(typeof (_106["toString"])=="function")&&(_106["toString"]!=obj["toString"])&&(_106["toString"]!=tobj["toString"])){
obj.toString=_106.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_10a){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_10d,_10e){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_10d.prototype,arguments[i]);
}
return _10d;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_111,_112,_113,_114){
if(!dojo.lang.isArrayLike(_111)&&dojo.lang.isArrayLike(_112)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_111;
_111=_112;
_112=temp;
}
var _116=dojo.lang.isString(_111);
if(_116){
_111=_111.split("");
}
if(_114){
var step=-1;
var i=_111.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_111.length;
}
if(_113){
while(i!=end){
if(_111[i]===_112){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_111[i]==_112){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_11a,_11b,_11c){
return dojo.lang.find(_11a,_11b,_11c,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_11d,_11e){
return dojo.lang.find(_11d,_11e)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_12a){
var _12b=window,_12c=2;
if(!dojo.lang.isFunction(func)){
_12b=func;
func=_12a;
_12a=arguments[2];
_12c++;
}
if(dojo.lang.isString(func)){
func=_12b[func];
}
var args=[];
for(var i=_12c;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_12b,args);
},_12a);
};
dojo.lang.clearTimeout=function(_12f){
dojo.global().clearTimeout(_12f);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_138,_139,_13a){
with(dojo.parseObjPath(_138,_139,_13a)){
return dojo.evalProp(prop,obj,_13a);
}
};
dojo.lang.setObjPathValue=function(_13b,_13c,_13d,_13e){
dojo.deprecated("dojo.lang.setObjPathValue","use dojo.parseObjPath and the '=' operator","0.6");
if(arguments.length<4){
_13e=true;
}
with(dojo.parseObjPath(_13b,_13d,_13e)){
if(obj&&(_13e||(prop in obj))){
obj[prop]=_13c;
}
}
};
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_140,_141,_142){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_140){
this.mimetype=_140;
}
if(_141){
this.transport=_141;
}
if(arguments.length>=4){
this.changeUrl=_142;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,load:function(type,data,_145,_146){
},error:function(type,_148,_149,_14a){
},timeout:function(type,_14c,_14d,_14e){
},handle:function(type,data,_151,_152){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_153){
if(_153["url"]){
_153.url=_153.url.toString();
}
if(_153["formNode"]){
_153.formNode=dojo.byId(_153.formNode);
}
if(!_153["method"]&&_153["formNode"]&&_153["formNode"].method){
_153.method=_153["formNode"].method;
}
if(!_153["handle"]&&_153["handler"]){
_153.handle=_153.handler;
}
if(!_153["load"]&&_153["loaded"]){
_153.load=_153.loaded;
}
if(!_153["changeUrl"]&&_153["changeURL"]){
_153.changeUrl=_153.changeURL;
}
_153.encoding=dojo.lang.firstValued(_153["encoding"],djConfig["bindEncoding"],"");
_153.sendTransport=dojo.lang.firstValued(_153["sendTransport"],djConfig["ioSendTransport"],false);
var _154=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_153[fn]&&_154(_153[fn])){
continue;
}
if(_153["handle"]&&_154(_153["handle"])){
_153[fn]=_153.handle;
}
}
dojo.lang.mixin(this,_153);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_15b){
if(!(_15b instanceof dojo.io.Request)){
try{
_15b=new dojo.io.Request(_15b);
}
catch(e){
dojo.debug(e);
}
}
var _15c="";
if(_15b["transport"]){
_15c=_15b["transport"];
if(!this[_15c]){
dojo.io.sendBindError(_15b,"No dojo.io.bind() transport with name '"+_15b["transport"]+"'.");
return _15b;
}
if(!this[_15c].canHandle(_15b)){
dojo.io.sendBindError(_15b,"dojo.io.bind() transport with name '"+_15b["transport"]+"' cannot handle this type of request.");
return _15b;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_15b))){
_15c=tmp;
break;
}
}
if(_15c==""){
dojo.io.sendBindError(_15b,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _15b;
}
}
this[_15c].bind(_15b);
_15b.bindSuccess=true;
return _15b;
};
dojo.io.sendBindError=function(_15f,_160){
if((typeof _15f.error=="function"||typeof _15f.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _161=new dojo.io.Error(_160);
setTimeout(function(){
_15f[(typeof _15f.error=="function")?"error":"handle"]("error",_161,null,_15f);
},50);
}else{
dojo.raise(_160);
}
};
dojo.io.queueBind=function(_162){
if(!(_162 instanceof dojo.io.Request)){
try{
_162=new dojo.io.Request(_162);
}
catch(e){
dojo.debug(e);
}
}
var _163=_162.load;
_162.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_163.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _165=_162.error;
_162.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_165.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_162);
dojo.io._dispatchNextQueueBind();
return _162;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_168,last){
var enc=/utf/i.test(_168||"")?encodeURIComponent:dojo.string.encodeAscii;
var _16b=[];
var _16c=new Object();
for(var name in map){
var _16e=function(elt){
var val=enc(name)+"="+enc(elt);
_16b[(last==name)?"push":"unshift"](val);
};
if(!_16c[name]){
var _171=map[name];
if(dojo.lang.isArray(_171)){
dojo.lang.forEach(_171,_16e);
}else{
_16e(_171);
}
}
}
return _16b.join("&");
};
dojo.io.setIFrameSrc=function(_172,src,_174){
try{
var r=dojo.render.html;
if(!_174){
if(r.safari){
_172.location=src;
}else{
frames[_172.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_172.contentWindow.document;
}else{
if(r.safari){
idoc=_172.document;
}else{
idoc=_172.contentWindow;
}
}
if(!idoc){
_172.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _17b=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_17b++;
break;
}
}
return _17b==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
},map:function(arr,obj,_17f){
var _180=dojo.lang.isString(arr);
if(_180){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_17f)){
_17f=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_17f){
var _181=obj;
obj=_17f;
_17f=_181;
}
}
if(Array.map){
var _182=Array.map(arr,_17f,obj);
}else{
var _182=[];
for(var i=0;i<arr.length;++i){
_182.push(_17f.call(obj,arr[i]));
}
}
if(_180){
return _182.join("");
}else{
return _182;
}
},reduce:function(arr,_185,obj,_187){
var _188=_185;
if(arguments.length==2){
_187=_185;
_188=arr[0];
arr=arr.slice(1);
}else{
if(arguments.length==3){
if(dojo.lang.isFunction(obj)){
_187=obj;
obj=null;
}
}else{
if(dojo.lang.isFunction(obj)){
var tmp=_187;
_187=obj;
obj=tmp;
}
}
}
var ob=obj||dj_global;
dojo.lang.map(arr,function(val){
_188=_187.call(ob,_188,val);
});
return _188;
},forEach:function(_18c,_18d,_18e){
if(dojo.lang.isString(_18c)){
_18c=_18c.split("");
}
if(Array.forEach){
Array.forEach(_18c,_18d,_18e);
}else{
if(!_18e){
_18e=dj_global;
}
for(var i=0,l=_18c.length;i<l;i++){
_18d.call(_18e,_18c[i],i,_18c);
}
}
},_everyOrSome:function(_191,arr,_193,_194){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_191?"every":"some"](arr,_193,_194);
}else{
if(!_194){
_194=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _197=_193.call(_194,arr[i],i,arr);
if(_191&&!_197){
return false;
}else{
if((!_191)&&(_197)){
return true;
}
}
}
return Boolean(_191);
}
},every:function(arr,_199,_19a){
return this._everyOrSome(true,arr,_199,_19a);
},some:function(arr,_19c,_19d){
return this._everyOrSome(false,arr,_19c,_19d);
},filter:function(arr,_19f,_1a0){
var _1a1=dojo.lang.isString(arr);
if(_1a1){
arr=arr.split("");
}
var _1a2;
if(Array.filter){
_1a2=Array.filter(arr,_19f,_1a0);
}else{
if(!_1a0){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_1a0=dj_global;
}
_1a2=[];
for(var i=0;i<arr.length;i++){
if(_19f.call(_1a0,arr[i],i,arr)){
_1a2.push(arr[i]);
}
}
}
if(_1a1){
return _1a2.join("");
}else{
return _1a2;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_1a7,_1a8){
var _1a9=[];
for(var i=_1a8||0;i<_1a7.length;i++){
_1a9.push(_1a7[i]);
}
return _1a9;
}});
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_1ab,_1ac){
var fcn=(dojo.lang.isString(_1ac)?_1ab[_1ac]:_1ac)||function(){
};
return function(){
return fcn.apply(_1ab,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_1ae,_1af,_1b0){
var nso=(_1af||dojo.lang.anon);
if((_1b0)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_1ae){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_1ae;
return ret;
};
dojo.lang.forward=function(_1b4){
return function(){
return this[_1b4].apply(this,arguments);
};
};
dojo.lang.curry=function(_1b5,func){
var _1b7=[];
_1b5=_1b5||dj_global;
if(dojo.lang.isString(func)){
func=_1b5[func];
}
for(var x=2;x<arguments.length;x++){
_1b7.push(arguments[x]);
}
var _1b9=(func["__preJoinArity"]||func.length)-_1b7.length;
function gather(_1ba,_1bb,_1bc){
var _1bd=_1bc;
var _1be=_1bb.slice(0);
for(var x=0;x<_1ba.length;x++){
_1be.push(_1ba[x]);
}
_1bc=_1bc-_1ba.length;
if(_1bc<=0){
var res=func.apply(_1b5,_1be);
_1bc=_1bd;
return res;
}else{
return function(){
return gather(arguments,_1be,_1bc);
};
}
}
return gather([],_1b7,_1b9);
};
dojo.lang.curryArguments=function(_1c1,func,args,_1c4){
var _1c5=[];
var x=_1c4||0;
for(x=_1c4;x<args.length;x++){
_1c5.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_1c1,func].concat(_1c5));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_1cb,_1cc){
if(!farr.length){
if(typeof _1cc=="function"){
_1cc();
}
return;
}
if((typeof _1cb=="undefined")&&(typeof cb=="number")){
_1cb=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_1cb){
_1cb=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_1cb,_1cc);
},_1cb);
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_1cd,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _1cd.replace(/\%\{(\w+)\}/g,function(_1d0,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _1d3=str.split(" ");
for(var i=0;i<_1d3.length;i++){
_1d3[i]=_1d3[i].charAt(0).toUpperCase()+_1d3[i].substring(1);
}
return _1d3.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _1d8=escape(str);
var _1d9,re=/%u([0-9A-F]{4})/i;
while((_1d9=_1d8.match(re))){
var num=Number("0x"+_1d9[1]);
var _1dc=escape("&#"+num+";");
ret+=_1d8.substring(0,_1d9.index)+_1dc;
_1d8=_1d8.substring(_1d9.index+_1d9[0].length);
}
ret+=_1d8.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_1e1){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_1e1){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_1ea){
if(_1ea){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_1ee,_1ef){
if(_1ef){
str=str.toLowerCase();
_1ee=_1ee.toLowerCase();
}
return str.indexOf(_1ee)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_1f5){
if(_1f5=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_1f5=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_1f7){
var _1f8=[];
for(var i=0,_1fa=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_1f7){
_1f8.push(str.substring(_1fa,i));
_1fa=i+1;
}
}
_1f8.push(str.substr(_1fa));
return _1f8;
};
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _1fc=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_1fc.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_1fe,_1ff){
var node=_1fe.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_1ff&&node&&node.tagName&&node.tagName.toLowerCase()!=_1ff.toLowerCase()){
node=dojo.dom.nextElement(node,_1ff);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_201,_202){
var node=_201.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_202&&node&&node.tagName&&node.tagName.toLowerCase()!=_202.toLowerCase()){
node=dojo.dom.prevElement(node,_202);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_205){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_205&&_205.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_205);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_207){
if(!node){
return null;
}
if(_207){
_207=_207.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_207&&_207.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_207);
}
return node;
};
dojo.dom.moveChildren=function(_208,_209,trim){
var _20b=0;
if(trim){
while(_208.hasChildNodes()&&_208.firstChild.nodeType==dojo.dom.TEXT_NODE){
_208.removeChild(_208.firstChild);
}
while(_208.hasChildNodes()&&_208.lastChild.nodeType==dojo.dom.TEXT_NODE){
_208.removeChild(_208.lastChild);
}
}
while(_208.hasChildNodes()){
_209.appendChild(_208.firstChild);
_20b++;
}
return _20b;
};
dojo.dom.copyChildren=function(_20c,_20d,trim){
var _20f=_20c.cloneNode(true);
return this.moveChildren(_20f,_20d,trim);
};
dojo.dom.replaceChildren=function(node,_211){
var _212=[];
if(dojo.render.html.ie){
for(var i=0;i<node.childNodes.length;i++){
_212.push(node.childNodes[i]);
}
}
dojo.dom.removeChildren(node);
node.appendChild(_211);
for(var i=0;i<_212.length;i++){
dojo.dom.destroyNode(_212[i]);
}
};
dojo.dom.removeChildren=function(node){
var _215=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _215;
};
dojo.dom.replaceNode=function(node,_217){
return node.parentNode.replaceChild(_217,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.evalObjPath("dojo.event.browser.clean",false)){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_21b,_21c){
var _21d=[];
var _21e=(_21b&&(_21b instanceof Function||typeof _21b=="function"));
while(node){
if(!_21e||_21b(node)){
_21d.push(node);
}
if(_21c&&_21d.length>0){
return _21d[0];
}
node=node.parentNode;
}
if(_21c){
return null;
}
return _21d;
};
dojo.dom.getAncestorsByTag=function(node,tag,_221){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_221);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_226,_227){
if(_227&&node){
node=node.parentNode;
}
while(node){
if(node==_226){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _22a=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _22b=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_22b.length;i++){
try{
doc=new ActiveXObject(_22b[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_22a.implementation)&&(_22a.implementation.createDocument)){
doc=_22a.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_22e){
if(!_22e){
_22e="text/xml";
}
if(!dj_undef("DOMParser")){
var _22f=new DOMParser();
return _22f.parseFromString(str,_22e);
}else{
if(!dj_undef("ActiveXObject")){
var _230=dojo.dom.createDocument();
if(_230){
_230.async=false;
_230.loadXML(str);
return _230;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _231=dojo.doc();
if(_231.createElement){
var tmp=_231.createElement("xml");
tmp.innerHTML=str;
if(_231.implementation&&_231.implementation.createDocument){
var _233=_231.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_233.importNode(tmp.childNodes.item(i),true);
}
return _233;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_236){
if(_236.firstChild){
_236.insertBefore(node,_236.firstChild);
}else{
_236.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_239){
if((_239!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _23a=ref.parentNode;
_23a.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_23d){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_23d!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_23d);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_241){
if((!node)||(!ref)||(!_241)){
return false;
}
switch(_241.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_243,_244){
var _245=_243.childNodes;
if(!_245.length||_245.length==_244){
_243.appendChild(node);
return true;
}
if(_244==0){
return dojo.dom.prependChild(node,_243);
}
return dojo.dom.insertAfter(node,_245[_244-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _248=dojo.doc();
dojo.dom.replaceChildren(node,_248.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _249="";
if(node==null){
return _249;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_249+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_249+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _249;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_24f,_250,_251){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_24f,_250,_251);
}else{
var _252=elem.ownerDocument;
var _253=_252.createNode(2,_250,_24f);
_253.nodeValue=_251;
elem.setAttributeNode(_253);
}
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:(!dj_undef("window"))?window.location.href:"",initialHash:(!dj_undef("window"))?window.location.hash:"",moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
if(djConfig["useXDomain"]&&!djConfig["dojoIframeHistoryUrl"]){
dojo.debug("dojo.undo.browser: When using cross-domain Dojo builds,"+" please save iframe_history.html to your domain and set djConfig.dojoIframeHistoryUrl"+" to the path on your domain to iframe_history.html");
}
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _258=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_25a){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_258.apply(this,[_25a]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _25b=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_25d){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_25b){
_25b.apply(this,[_25d]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_260){
if(!dojo.render.html.opera){
var _261=this._getUrlQuery(_260.href);
if(_261==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_261==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_261==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _262=this.historyStack.pop();
if(!_262){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_262);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _269=url.split("?");
if(_269.length<2){
return null;
}else{
return _269[1];
}
},_loadIframeHistory:function(){
var url=(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
if(!dj_undef("window")){
dojo.io.checkChildrenForFile=function(node){
var _26c=false;
var _26d=node.getElementsByTagName("input");
dojo.lang.forEach(_26d,function(_26e){
if(_26c){
return;
}
if(_26e.getAttribute("type")=="file"){
_26c=true;
}
});
return _26c;
};
dojo.io.formHasFile=function(_26f){
return dojo.io.checkChildrenForFile(_26f);
};
dojo.io.updateNode=function(node,_271){
node=dojo.byId(node);
var args=_271;
if(dojo.lang.isString(_271)){
args={url:_271};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
dojo.dom.destroyNode(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_278,_279,_27a){
if((!_278)||(!_278.tagName)||(!_278.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_27a){
_27a=dojo.io.formFilter;
}
var enc=/utf/i.test(_279||"")?encodeURIComponent:dojo.string.encodeAscii;
var _27c=[];
for(var i=0;i<_278.elements.length;i++){
var elm=_278.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_27a(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_27c.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_27c.push(name+"="+enc(elm.value));
}
}else{
_27c.push(name+"="+enc(elm.value));
}
}
}
var _282=_278.getElementsByTagName("input");
for(var i=0;i<_282.length;i++){
var _283=_282[i];
if(_283.type.toLowerCase()=="image"&&_283.form==_278&&_27a(_283)){
var name=enc(_283.name);
_27c.push(name+"="+enc(_283.value));
_27c.push(name+".x=0");
_27c.push(name+".y=0");
}
}
return _27c.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _289=form.getElementsByTagName("input");
for(var i=0;i<_289.length;i++){
var _28a=_289[i];
if(_28a.type.toLowerCase()=="image"&&_28a.form==form){
this.connect(_28a,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _291=false;
if(node.disabled||!node.name){
_291=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_291=node==this.clickedButton;
}else{
_291=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _291;
},connect:function(_292,_293,_294){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_292,_293,this,_294);
}else{
var fcn=dojo.lang.hitch(this,_294);
_292[_293]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _297=this;
var _298={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_29a,_29b){
return url+"|"+_29a+"|"+_29b.toLowerCase();
}
function addToCache(url,_29d,_29e,http){
_298[getCacheKey(url,_29d,_29e)]=http;
}
function getFromCache(url,_2a1,_2a2){
return _298[getCacheKey(url,_2a1,_2a2)];
}
this.clearCache=function(){
_298={};
};
function doLoad(_2a3,http,url,_2a6,_2a7){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_2a3.method.toLowerCase()=="head"){
var _2a9=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _2a9;
};
var _2aa=_2a9.split(/[\r\n]+/g);
for(var i=0;i<_2aa.length;i++){
var pair=_2aa[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_2a3.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_2a3.mimetype=="text/json"||_2a3.mimetype=="application/json"){
try{
ret=dj_eval("("+http.responseText+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_2a3.mimetype=="application/xml")||(_2a3.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_2a7){
addToCache(url,_2a6,_2a3.method,http);
}
_2a3[(typeof _2a3.load=="function")?"load":"handle"]("load",ret,http,_2a3);
}else{
var _2ad=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_2a3[(typeof _2a3.error=="function")?"error":"handle"]("error",_2ad,http,_2a3);
}
}
function setHeaders(http,_2af){
if(_2af["headers"]){
for(var _2b0 in _2af["headers"]){
if(_2b0.toLowerCase()=="content-type"&&!_2af["contentType"]){
_2af["contentType"]=_2af["headers"][_2b0];
}else{
http.setRequestHeader(_2b0,_2af["headers"][_2b0]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_297._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _2b4=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_2b4,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _2b5=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_2b6){
return _2b5&&dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript","text/json","application/json"],(_2b6["mimetype"].toLowerCase()||""))&&!(_2b6["formNode"]&&dojo.io.formHasFile(_2b6["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_2b7){
if(!_2b7["url"]){
if(!_2b7["formNode"]&&(_2b7["backButton"]||_2b7["back"]||_2b7["changeUrl"]||_2b7["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_2b7);
return true;
}
}
var url=_2b7.url;
var _2b9="";
if(_2b7["formNode"]){
var ta=_2b7.formNode.getAttribute("action");
if((ta)&&(!_2b7["url"])){
url=ta;
}
var tp=_2b7.formNode.getAttribute("method");
if((tp)&&(!_2b7["method"])){
_2b7.method=tp;
}
_2b9+=dojo.io.encodeForm(_2b7.formNode,_2b7.encoding,_2b7["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_2b7["file"]){
_2b7.method="post";
}
if(!_2b7["method"]){
_2b7.method="get";
}
if(_2b7.method.toLowerCase()=="get"){
_2b7.multipart=false;
}else{
if(_2b7["file"]){
_2b7.multipart=true;
}else{
if(!_2b7["multipart"]){
_2b7.multipart=false;
}
}
}
if(_2b7["backButton"]||_2b7["back"]||_2b7["changeUrl"]){
dojo.undo.browser.addToHistory(_2b7);
}
var _2bc=_2b7["content"]||{};
if(_2b7.sendTransport){
_2bc["dojo.transport"]="xmlhttp";
}
do{
if(_2b7.postContent){
_2b9=_2b7.postContent;
break;
}
if(_2bc){
_2b9+=dojo.io.argsFromMap(_2bc,_2b7.encoding);
}
if(_2b7.method.toLowerCase()=="get"||!_2b7.multipart){
break;
}
var t=[];
if(_2b9.length){
var q=_2b9.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_2b7.file){
if(dojo.lang.isArray(_2b7.file)){
for(var i=0;i<_2b7.file.length;++i){
var o=_2b7.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_2b7.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_2b9=t.join("\r\n");
}
}while(false);
var _2c2=_2b7["sync"]?false:true;
var _2c3=_2b7["preventCache"]||(this.preventCache==true&&_2b7["preventCache"]!=false);
var _2c4=_2b7["useCache"]==true||(this.useCache==true&&_2b7["useCache"]!=false);
if(!_2c3&&_2c4){
var _2c5=getFromCache(url,_2b9,_2b7.method);
if(_2c5){
doLoad(_2b7,_2c5,url,_2b9,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_2b7);
var _2c7=false;
if(_2c2){
var _2c8=this.inFlight.push({"req":_2b7,"http":http,"url":url,"query":_2b9,"useCache":_2c4,"startTime":_2b7.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_297._blockAsync=true;
}
if(_2b7.method.toLowerCase()=="post"){
if(!_2b7.user){
http.open("POST",url,_2c2);
}else{
http.open("POST",url,_2c2,_2b7.user,_2b7.password);
}
setHeaders(http,_2b7);
http.setRequestHeader("Content-Type",_2b7.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_2b7.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_2b9);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2b7,{status:404},url,_2b9,_2c4);
}
}else{
var _2c9=url;
if(_2b9!=""){
_2c9+=(_2c9.indexOf("?")>-1?"&":"?")+_2b9;
}
if(_2c3){
_2c9+=(dojo.string.endsWithAny(_2c9,"?","&")?"":(_2c9.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_2b7.user){
http.open(_2b7.method.toUpperCase(),_2c9,_2c2);
}else{
http.open(_2b7.method.toUpperCase(),_2c9,_2c2,_2b7.user,_2b7.password);
}
setHeaders(http,_2b7);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2b7,{status:404},url,_2b9,_2c4);
}
}
if(!_2c2){
doLoad(_2b7,http,url,_2b9,_2c4);
_297._blockAsync=false;
}
_2b7.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
}
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_2cb,days,path,_2ce,_2cf){
var _2d0=-1;
if((typeof days=="number")&&(days>=0)){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_2d0=d.toGMTString();
}
_2cb=escape(_2cb);
document.cookie=name+"="+_2cb+";"+(_2d0!=-1?" expires="+_2d0+";":"")+(path?"path="+path:"")+(_2ce?"; domain="+_2ce:"")+(_2cf?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _2d4=document.cookie.substring(idx+name.length+1);
var end=_2d4.indexOf(";");
if(end==-1){
end=_2d4.length;
}
_2d4=_2d4.substring(0,end);
_2d4=unescape(_2d4);
return _2d4;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_2db,_2dc,_2dd){
if(arguments.length==5){
_2dd=_2db;
_2db=null;
_2dc=null;
}
var _2de=[],_2df,_2e0="";
if(!_2dd){
_2df=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_2df){
_2df={};
}
for(var prop in obj){
if(obj[prop]==null){
delete _2df[prop];
}else{
if((typeof obj[prop]=="string")||(typeof obj[prop]=="number")){
_2df[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _2df){
_2de.push(escape(prop)+"="+escape(_2df[prop]));
}
_2e0=_2de.join("&");
}
dojo.io.cookie.setCookie(name,_2e0,days,path,_2db,_2dc);
};
dojo.io.cookie.getObjectCookie=function(name){
var _2e3=null,_2e4=dojo.io.cookie.getCookie(name);
if(_2e4){
_2e3={};
var _2e5=_2e4.split("&");
for(var i=0;i<_2e5.length;i++){
var pair=_2e5[i].split("=");
var _2e8=pair[1];
if(isNaN(_2e8)){
_2e8=unescape(pair[1]);
}
_2e3[unescape(pair[0])]=_2e8;
}
}
return _2e3;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _2e9=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_2e9=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.kwCompoundRequire({common:["dojo.io.common"],rhino:["dojo.io.RhinoIO"],browser:["dojo.io.BrowserIO","dojo.io.cookie"],dashboard:["dojo.io.BrowserIO","dojo.io.cookie"]});
dojo.provide("dojo.io.*");
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_2eb){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false,maxCalls:-1};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _2ee=dl.nameAnonFunc(args[2],ao.adviceObj,_2eb);
ao.adviceFunc=_2ee;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _2ee=dl.nameAnonFunc(args[0],ao.srcObj,_2eb);
ao.srcFunc=_2ee;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _2ee=dl.nameAnonFunc(args[1],dj_global,_2eb);
ao.srcFunc=_2ee;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _2ee=dl.nameAnonFunc(args[3],dj_global,_2eb);
ao.adviceObj=dj_global;
ao.adviceFunc=_2ee;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
ao.maxCalls=(!isNaN(parseInt(args[11])))?args[11]:-1;
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _2ee=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_2eb);
ao.aroundFunc=_2ee;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _2f0={};
for(var x in ao){
_2f0[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_2f0.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_2f0));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _2f8;
if((arguments.length==1)&&(typeof a1=="object")){
_2f8=a1;
}else{
_2f8={srcObj:a1,srcFunc:a2};
}
_2f8.adviceFunc=function(){
var _2f9=[];
for(var x=0;x<arguments.length;x++){
_2f9.push(arguments[x]);
}
dojo.debug("("+_2f8.srcObj+")."+_2f8.srcFunc,":",_2f9.join(", "));
};
this.kwConnect(_2f8);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this.connectRunOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.maxCalls=1;
return this.connect(ao);
};
this._kwConnectImpl=function(_301,_302){
var fn=(_302)?"disconnect":"connect";
if(typeof _301["srcFunc"]=="function"){
_301.srcObj=_301["srcObj"]||dj_global;
var _304=dojo.lang.nameAnonFunc(_301.srcFunc,_301.srcObj,true);
_301.srcFunc=_304;
}
if(typeof _301["adviceFunc"]=="function"){
_301.adviceObj=_301["adviceObj"]||dj_global;
var _304=dojo.lang.nameAnonFunc(_301.adviceFunc,_301.adviceObj,true);
_301.adviceFunc=_304;
}
_301.srcObj=_301["srcObj"]||dj_global;
_301.adviceObj=_301["adviceObj"]||_301["targetObj"]||dj_global;
_301.adviceFunc=_301["adviceFunc"]||_301["targetFunc"];
return dojo.event[fn](_301);
};
this.kwConnect=function(_305){
return this._kwConnectImpl(_305,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
if(!ao.srcObj[ao.srcFunc]){
return null;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc,true);
mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
return mjp;
};
this.kwDisconnect=function(_308){
return this._kwConnectImpl(_308,true);
};
};
dojo.event.MethodInvocation=function(_309,obj,args){
this.jp_=_309;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_311){
this.object=obj||dj_global;
this.methodname=_311;
this.methodfunc=this.object[_311];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_313){
if(!obj){
obj=dj_global;
}
var ofn=obj[_313];
if(!ofn){
ofn=obj[_313]=function(){
};
if(!obj[_313]){
dojo.raise("Cannot set do-nothing method on that object "+_313);
}
}else{
if((typeof ofn!="function")&&(!dojo.lang.isFunction(ofn))&&(!dojo.lang.isAlien(ofn))){
return null;
}
}
var _315=_313+"$joinpoint";
var _316=_313+"$joinpoint$method";
var _317=obj[_315];
if(!_317){
var _318=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_318=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_315,_316,_313]);
}
}
var _319=ofn.length;
obj[_316]=ofn;
_317=obj[_315]=new dojo.event.MethodJoinPoint(obj,_316);
if(!_318){
obj[_313]=function(){
return _317.run.apply(_317,arguments);
};
}else{
obj[_313]=function(){
var args=[];
if(!arguments.length){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _317.run.apply(_317,args);
};
}
obj[_313].__preJoinArity=_319;
}
return _317;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{squelch:false,unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _31f=[];
for(var x=0;x<args.length;x++){
_31f[x]=args[x];
}
var _321=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _323=marr[0]||dj_global;
var _324=marr[1];
if(!_323[_324]){
dojo.raise("function \""+_324+"\" does not exist on \""+_323+"\"");
}
var _325=marr[2]||dj_global;
var _326=marr[3];
var msg=marr[6];
var _328=marr[7];
if(_328>-1){
if(_328==0){
return;
}
marr[7]--;
}
var _329;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _323[_324].apply(_323,to.args);
}};
to.args=_31f;
var _32b=parseInt(marr[4]);
var _32c=((!isNaN(_32b))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _32f=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_321(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_326){
_325[_326].call(_325,to);
}else{
if((_32c)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_323[_324].call(_323,to);
}else{
_323[_324].apply(_323,args);
}
},_32b);
}else{
if(msg){
_323[_324].call(_323,to);
}else{
_323[_324].apply(_323,args);
}
}
}
};
var _332=function(){
if(this.squelch){
try{
return _321.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _321.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_332);
}
var _333;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_333=mi.proceed();
}else{
if(this.methodfunc){
_333=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.debug(e,"when calling",this.methodname,"on",this.object,"with arguments",args);
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_332);
}
return (this.methodfunc)?_333:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"],args["maxCalls"]);
},addAdvice:function(_338,_339,_33a,_33b,_33c,_33d,once,_33f,rate,_341,_342){
var arr=this.getArr(_33c);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_338,_339,_33a,_33b,_33f,rate,_341,_342];
if(once){
if(this.hasAdvice(_338,_339,_33c,arr)>=0){
return;
}
}
if(_33d=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_345,_346,_347,arr){
if(!arr){
arr=this.getArr(_347);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _346=="object")?(new String(_346)).toString():_346;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_345)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_34d,_34e,_34f,once){
var arr=this.getArr(_34f);
var ind=this.hasAdvice(_34d,_34e,_34f,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_34d,_34e,_34f,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_353){
if(!this.topics[_353]){
this.topics[_353]=new this.TopicImpl(_353);
}
return this.topics[_353];
};
this.registerPublisher=function(_354,obj,_356){
var _354=this.getTopic(_354);
_354.registerPublisher(obj,_356);
};
this.subscribe=function(_357,obj,_359){
var _357=this.getTopic(_357);
_357.subscribe(obj,_359);
};
this.unsubscribe=function(_35a,obj,_35c){
var _35a=this.getTopic(_35a);
_35a.unsubscribe(obj,_35c);
};
this.destroy=function(_35d){
this.getTopic(_35d).destroy();
delete this.topics[_35d];
};
this.publishApply=function(_35e,args){
var _35e=this.getTopic(_35e);
_35e.sendMessage.apply(_35e,args);
};
this.publish=function(_360,_361){
var _360=this.getTopic(_360);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_360.sendMessage.apply(_360,args);
};
};
dojo.event.topic.TopicImpl=function(_364){
this.topicName=_364;
this.subscribe=function(_365,_366){
var tf=_366||_365;
var to=(!_366)?dj_global:_365;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_369,_36a){
var tf=(!_36a)?_369:_36a;
var to=(!_36a)?null:_369;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_36d){
this._getJoinPoint().squelch=_36d;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_36e,_36f){
dojo.event.connect(_36e,_36f,this,"sendMessage");
};
this.sendMessage=function(_370){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_373){
var na;
var tna;
if(_373){
tna=_373.all||_373.getElementsByTagName("*");
na=[_373];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _377={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
if(dojo.widget){
for(var name in dojo.widget._templateCache){
if(dojo.widget._templateCache[name].node){
dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
dojo.widget._templateCache[name].node=null;
delete dojo.widget._templateCache[name].node;
}
}
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _37c=0;
this.normalizedEventName=function(_37d){
switch(_37d){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _37d;
break;
default:
var lcn=_37d.toLowerCase();
return (lcn.indexOf("on")==0)?lcn.substr(2):lcn;
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_382){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_382.length;x++){
node.__clobberAttrs__.push(_382[x]);
}
};
this.removeListener=function(node,_385,fp,_387){
if(!_387){
var _387=false;
}
_385=dojo.event.browser.normalizedEventName(_385);
if(_385=="key"){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_387);
}
_385="keypress";
}
if(node.removeEventListener){
node.removeEventListener(_385,fp,_387);
}
};
this.addListener=function(node,_389,fp,_38b,_38c){
if(!node){
return;
}
if(!_38b){
var _38b=false;
}
_389=dojo.event.browser.normalizedEventName(_389);
if(_389=="key"){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_38b,_38c);
}
_389="keypress";
}
if(!_38c){
var _38d=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_38b){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_38d=fp;
}
if(node.addEventListener){
node.addEventListener(_389,_38d,_38b);
return _38d;
}else{
_389="on"+_389;
if(typeof node[_389]=="function"){
var _390=node[_389];
node[_389]=function(e){
_390(e);
return _38d(e);
};
}else{
node[_389]=_38d;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_389]);
}
return _38d;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(obj)&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_393,_394){
if(typeof _393!="function"){
dojo.raise("listener not a function: "+_393);
}
dojo.event.browser.currentEvent.currentTarget=_394;
return _393.call(_394,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_397){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _399=evt.keyCode;
if(_399>=65&&_399<=90&&evt.shiftKey==false){
_399+=32;
}
if(_399>=1&&_399<=26&&evt.ctrlKey){
_399+=96;
}
evt.key=String.fromCharCode(_399);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _399=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_399+=32;
}
evt.key=String.fromCharCode(_399);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 25:
evt.key=evt.KEY_TAB;
evt.shift=true;
break;
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
case 63236:
evt.key=evt.KEY_F1;
break;
case 63237:
evt.key=evt.KEY_F2;
break;
case 63238:
evt.key=evt.KEY_F3;
break;
case 63239:
evt.key=evt.KEY_F4;
break;
case 63240:
evt.key=evt.KEY_F5;
break;
case 63241:
evt.key=evt.KEY_F6;
break;
case 63242:
evt.key=evt.KEY_F7;
break;
case 63243:
evt.key=evt.KEY_F8;
break;
case 63244:
evt.key=evt.KEY_F9;
break;
case 63245:
evt.key=evt.KEY_F10;
break;
case 63246:
evt.key=evt.KEY_F11;
break;
case 63247:
evt.key=evt.KEY_F12;
break;
case 63250:
evt.key=evt.KEY_PAUSE;
break;
case 63272:
evt.key=evt.KEY_DELETE;
break;
case 63273:
evt.key=evt.KEY_HOME;
break;
case 63275:
evt.key=evt.KEY_END;
break;
case 63276:
evt.key=evt.KEY_PAGE_UP;
break;
case 63277:
evt.key=evt.KEY_PAGE_DOWN;
break;
case 63302:
evt.key=evt.KEY_INSERT;
break;
case 63248:
case 63249:
case 63289:
break;
default:
evt.key=evt.charCode>=evt.KEY_SPACE?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_397?_397:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _39b=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_39b.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_39b.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.cancelBubble=true;
evt.returnValue=false;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.kwCompoundRequire({common:["dojo.event.common","dojo.event.topic"],browser:["dojo.event.browser"],dashboard:["dojo.event.browser"]});
dojo.provide("dojo.event.*");


__CPAN_EDITION__ event_and_io build.txt
Files baked into this build:
dojoGuardStart.js
../src/bootstrap1.js
../src/loader.js
dojoGuardEnd.js
../src/hostenv_browser.js
../src/string/common.js
../src/string.js
../src/lang/common.js
../src/lang/extras.js
../src/io/common.js
../src/lang/array.js
../src/lang/func.js
../src/string/extras.js
../src/dom.js
../src/undo/browser.js
../src/io/BrowserIO.js
../src/io/cookie.js
../src/io/__package__.js
../src/event/common.js
../src/event/topic.js
../src/event/browser.js
../src/event/__package__.js
__CPAN_EDITION__ kitchen_sink dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:2,flag:"",revision:Number("$Rev: 7616 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
function dj_load_init(e){
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_ee,_ef){
if(!dojo.lang.isFunction(_ef)){
dojo.raise("dojo.inherits: superclass argument ["+_ef+"] must be a function (subclass: ["+_ee+"']");
}
_ee.prototype=new _ef();
_ee.prototype.constructor=_ee;
_ee.superclass=_ef.prototype;
_ee["super"]=_ef.prototype;
};
dojo.lang._mixin=function(obj,_f1){
var _f2={};
for(var x in _f1){
if((typeof _f2[x]=="undefined")||(_f2[x]!=_f1[x])){
obj[x]=_f1[x];
}
}
if(dojo.render.html.ie&&(typeof (_f1["toString"])=="function")&&(_f1["toString"]!=obj["toString"])&&(_f1["toString"]!=_f2["toString"])){
obj.toString=_f1.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_f5){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_f8,_f9){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_f8.prototype,arguments[i]);
}
return _f8;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_fc,_fd,_fe,_ff){
if(!dojo.lang.isArrayLike(_fc)&&dojo.lang.isArrayLike(_fd)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_fc;
_fc=_fd;
_fd=temp;
}
var _101=dojo.lang.isString(_fc);
if(_101){
_fc=_fc.split("");
}
if(_ff){
var step=-1;
var i=_fc.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_fc.length;
}
if(_fe){
while(i!=end){
if(_fc[i]===_fd){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_fc[i]==_fd){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_105,_106,_107){
return dojo.lang.find(_105,_106,_107,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_108,_109){
return dojo.lang.find(_108,_109)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang");
dojo.deprecated("dojo.lang","replaced by dojo.lang.common","0.5");
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _115=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_115.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_117,_118){
var node=_117.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_118&&node&&node.tagName&&node.tagName.toLowerCase()!=_118.toLowerCase()){
node=dojo.dom.nextElement(node,_118);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_11a,_11b){
var node=_11a.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_11b&&node&&node.tagName&&node.tagName.toLowerCase()!=_11b.toLowerCase()){
node=dojo.dom.prevElement(node,_11b);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_11e){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_11e&&_11e.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_11e);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_120){
if(!node){
return null;
}
if(_120){
_120=_120.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_120&&_120.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_120);
}
return node;
};
dojo.dom.moveChildren=function(_121,_122,trim){
var _124=0;
if(trim){
while(_121.hasChildNodes()&&_121.firstChild.nodeType==dojo.dom.TEXT_NODE){
_121.removeChild(_121.firstChild);
}
while(_121.hasChildNodes()&&_121.lastChild.nodeType==dojo.dom.TEXT_NODE){
_121.removeChild(_121.lastChild);
}
}
while(_121.hasChildNodes()){
_122.appendChild(_121.firstChild);
_124++;
}
return _124;
};
dojo.dom.copyChildren=function(_125,_126,trim){
var _128=_125.cloneNode(true);
return this.moveChildren(_128,_126,trim);
};
dojo.dom.replaceChildren=function(node,_12a){
var _12b=[];
if(dojo.render.html.ie){
for(var i=0;i<node.childNodes.length;i++){
_12b.push(node.childNodes[i]);
}
}
dojo.dom.removeChildren(node);
node.appendChild(_12a);
for(var i=0;i<_12b.length;i++){
dojo.dom.destroyNode(_12b[i]);
}
};
dojo.dom.removeChildren=function(node){
var _12e=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _12e;
};
dojo.dom.replaceNode=function(node,_130){
return node.parentNode.replaceChild(_130,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.evalObjPath("dojo.event.browser.clean",false)){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_134,_135){
var _136=[];
var _137=(_134&&(_134 instanceof Function||typeof _134=="function"));
while(node){
if(!_137||_134(node)){
_136.push(node);
}
if(_135&&_136.length>0){
return _136[0];
}
node=node.parentNode;
}
if(_135){
return null;
}
return _136;
};
dojo.dom.getAncestorsByTag=function(node,tag,_13a){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_13a);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_13f,_140){
if(_140&&node){
node=node.parentNode;
}
while(node){
if(node==_13f){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _143=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _144=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_144.length;i++){
try{
doc=new ActiveXObject(_144[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_143.implementation)&&(_143.implementation.createDocument)){
doc=_143.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_147){
if(!_147){
_147="text/xml";
}
if(!dj_undef("DOMParser")){
var _148=new DOMParser();
return _148.parseFromString(str,_147);
}else{
if(!dj_undef("ActiveXObject")){
var _149=dojo.dom.createDocument();
if(_149){
_149.async=false;
_149.loadXML(str);
return _149;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _14a=dojo.doc();
if(_14a.createElement){
var tmp=_14a.createElement("xml");
tmp.innerHTML=str;
if(_14a.implementation&&_14a.implementation.createDocument){
var _14c=_14a.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_14c.importNode(tmp.childNodes.item(i),true);
}
return _14c;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_14f){
if(_14f.firstChild){
_14f.insertBefore(node,_14f.firstChild);
}else{
_14f.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_152){
if((_152!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _153=ref.parentNode;
_153.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_156){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_156!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_156);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_15a){
if((!node)||(!ref)||(!_15a)){
return false;
}
switch(_15a.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_15c,_15d){
var _15e=_15c.childNodes;
if(!_15e.length||_15e.length==_15d){
_15c.appendChild(node);
return true;
}
if(_15d==0){
return dojo.dom.prependChild(node,_15c);
}
return dojo.dom.insertAfter(node,_15e[_15d-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _161=dojo.doc();
dojo.dom.replaceChildren(node,_161.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _162="";
if(node==null){
return _162;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_162+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_162+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _162;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_168,_169,_16a){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_168,_169,_16a);
}else{
var _16b=elem.ownerDocument;
var _16c=_16b.createNode(2,_169,_168);
_16c.nodeValue=_16a;
elem.setAttributeNode(_16c);
}
};
dojo.provide("dojo.html.common");
dojo.lang.mixin(dojo.html,dojo.dom);
dojo.html.body=function(){
dojo.deprecated("dojo.html.body() moved to dojo.body()","0.5");
return dojo.body();
};
dojo.html.getEventTarget=function(evt){
if(!evt){
evt=dojo.global().event||{};
}
var t=(evt.srcElement?evt.srcElement:(evt.target?evt.target:null));
while((t)&&(t.nodeType!=1)){
t=t.parentNode;
}
return t;
};
dojo.html.getViewport=function(){
var _16f=dojo.global();
var _170=dojo.doc();
var w=0;
var h=0;
if(dojo.render.html.mozilla){
w=_170.documentElement.clientWidth;
h=_16f.innerHeight;
}else{
if(!dojo.render.html.opera&&_16f.innerWidth){
w=_16f.innerWidth;
h=_16f.innerHeight;
}else{
if(!dojo.render.html.opera&&dojo.exists(_170,"documentElement.clientWidth")){
var w2=_170.documentElement.clientWidth;
if(!w||w2&&w2<w){
w=w2;
}
h=_170.documentElement.clientHeight;
}else{
if(dojo.body().clientWidth){
w=dojo.body().clientWidth;
h=dojo.body().clientHeight;
}
}
}
}
return {width:w,height:h};
};
dojo.html.getScroll=function(){
var _174=dojo.global();
var _175=dojo.doc();
var top=_174.pageYOffset||_175.documentElement.scrollTop||dojo.body().scrollTop||0;
var left=_174.pageXOffset||_175.documentElement.scrollLeft||dojo.body().scrollLeft||0;
return {top:top,left:left,offset:{x:left,y:top}};
};
dojo.html.getParentByType=function(node,type){
var _17a=dojo.doc();
var _17b=dojo.byId(node);
type=type.toLowerCase();
while((_17b)&&(_17b.nodeName.toLowerCase()!=type)){
if(_17b==(_17a["body"]||_17a["documentElement"])){
return null;
}
_17b=_17b.parentNode;
}
return _17b;
};
dojo.html.getAttribute=function(node,attr){
node=dojo.byId(node);
if((!node)||(!node.getAttribute)){
return null;
}
var ta=typeof attr=="string"?attr:new String(attr);
var v=node.getAttribute(ta.toUpperCase());
if((v)&&(typeof v=="string")&&(v!="")){
return v;
}
if(v&&v.value){
return v.value;
}
if((node.getAttributeNode)&&(node.getAttributeNode(ta))){
return (node.getAttributeNode(ta)).value;
}else{
if(node.getAttribute(ta)){
return node.getAttribute(ta);
}else{
if(node.getAttribute(ta.toLowerCase())){
return node.getAttribute(ta.toLowerCase());
}
}
}
return null;
};
dojo.html.hasAttribute=function(node,attr){
return dojo.html.getAttribute(dojo.byId(node),attr)?true:false;
};
dojo.html.getCursorPosition=function(e){
e=e||dojo.global().event;
var _183={x:0,y:0};
if(e.pageX||e.pageY){
_183.x=e.pageX;
_183.y=e.pageY;
}else{
var de=dojo.doc().documentElement;
var db=dojo.body();
_183.x=e.clientX+((de||db)["scrollLeft"])-((de||db)["clientLeft"]);
_183.y=e.clientY+((de||db)["scrollTop"])-((de||db)["clientTop"]);
}
return _183;
};
dojo.html.isTag=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName.toLowerCase()==String(arguments[i]).toLowerCase()){
return String(arguments[i]).toLowerCase();
}
}
}
return "";
};
if(dojo.render.html.ie&&!dojo.render.html.ie70){
if(window.location.href.substr(0,6).toLowerCase()!="https:"){
(function(){
var _188=dojo.doc().createElement("script");
_188.src="javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
dojo.doc().getElementsByTagName("head")[0].appendChild(_188);
})();
}
}else{
dojo.html.createExternalElement=function(doc,tag){
return doc.createElement(tag);
};
}
dojo.html._callDeprecated=function(_18b,_18c,args,_18e,_18f){
dojo.deprecated("dojo.html."+_18b,"replaced by dojo.html."+_18c+"("+(_18e?"node, {"+_18e+": "+_18e+"}":"")+")"+(_18f?"."+_18f:""),"0.5");
var _190=[];
if(_18e){
var _191={};
_191[_18e]=args[1];
_190.push(args[0]);
_190.push(_191);
}else{
_190=args;
}
var ret=dojo.html[_18c].apply(dojo.html,args);
if(_18f){
return ret[_18f];
}else{
return ret;
}
};
dojo.html.getViewportWidth=function(){
return dojo.html._callDeprecated("getViewportWidth","getViewport",arguments,null,"width");
};
dojo.html.getViewportHeight=function(){
return dojo.html._callDeprecated("getViewportHeight","getViewport",arguments,null,"height");
};
dojo.html.getViewportSize=function(){
return dojo.html._callDeprecated("getViewportSize","getViewport",arguments);
};
dojo.html.getScrollTop=function(){
return dojo.html._callDeprecated("getScrollTop","getScroll",arguments,null,"top");
};
dojo.html.getScrollLeft=function(){
return dojo.html._callDeprecated("getScrollLeft","getScroll",arguments,null,"left");
};
dojo.html.getScrollOffset=function(){
return dojo.html._callDeprecated("getScrollOffset","getScroll",arguments,null,"offset");
};
dojo.provide("dojo.uri.Uri");
dojo.uri=new function(){
this.dojoUri=function(uri){
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri(),uri);
};
this.moduleUri=function(_194,uri){
var loc=dojo.hostenv.getModuleSymbols(_194).join("/");
if(!loc){
return null;
}
if(loc.lastIndexOf("/")!=loc.length-1){
loc+="/";
}
var _197=loc.indexOf(":");
var _198=loc.indexOf("/");
if(loc.charAt(0)!="/"&&(_197==-1||_197>_198)){
loc=dojo.hostenv.getBaseScriptUri()+loc;
}
return new dojo.uri.Uri(loc,uri);
};
this.Uri=function(){
var uri=arguments[0];
for(var i=1;i<arguments.length;i++){
if(!arguments[i]){
continue;
}
var _19b=new dojo.uri.Uri(arguments[i].toString());
var _19c=new dojo.uri.Uri(uri.toString());
if((_19b.path=="")&&(_19b.scheme==null)&&(_19b.authority==null)&&(_19b.query==null)){
if(_19b.fragment!=null){
_19c.fragment=_19b.fragment;
}
_19b=_19c;
}else{
if(_19b.scheme==null){
_19b.scheme=_19c.scheme;
if(_19b.authority==null){
_19b.authority=_19c.authority;
if(_19b.path.charAt(0)!="/"){
var path=_19c.path.substring(0,_19c.path.lastIndexOf("/")+1)+_19b.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==segs.length-1){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_19b.path=segs.join("/");
}
}
}
}
uri="";
if(_19b.scheme!=null){
uri+=_19b.scheme+":";
}
if(_19b.authority!=null){
uri+="//"+_19b.authority;
}
uri+=_19b.path;
if(_19b.query!=null){
uri+="?"+_19b.query;
}
if(_19b.fragment!=null){
uri+="#"+_19b.fragment;
}
}
this.uri=uri.toString();
var _1a0="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=this.uri.match(new RegExp(_1a0));
this.scheme=r[2]||(r[1]?"":null);
this.authority=r[4]||(r[3]?"":null);
this.path=r[5];
this.query=r[7]||(r[6]?"":null);
this.fragment=r[9]||(r[8]?"":null);
if(this.authority!=null){
_1a0="^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$";
r=this.authority.match(new RegExp(_1a0));
this.user=r[3]||null;
this.password=r[4]||null;
this.host=r[5];
this.port=r[7]||null;
}
this.toString=function(){
return this.uri;
};
};
};
dojo.provide("dojo.html.style");
dojo.html.getClass=function(node){
node=dojo.byId(node);
if(!node){
return "";
}
var cs="";
if(node.className){
cs=node.className;
}else{
if(dojo.html.hasAttribute(node,"class")){
cs=dojo.html.getAttribute(node,"class");
}
}
return cs.replace(/^\s+|\s+$/g,"");
};
dojo.html.getClasses=function(node){
var c=dojo.html.getClass(node);
return (c=="")?[]:c.split(/\s+/g);
};
dojo.html.hasClass=function(node,_1a7){
return (new RegExp("(^|\\s+)"+_1a7+"(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass=function(node,_1a9){
_1a9+=" "+dojo.html.getClass(node);
return dojo.html.setClass(node,_1a9);
};
dojo.html.addClass=function(node,_1ab){
if(dojo.html.hasClass(node,_1ab)){
return false;
}
_1ab=(dojo.html.getClass(node)+" "+_1ab).replace(/^\s+|\s+$/g,"");
return dojo.html.setClass(node,_1ab);
};
dojo.html.setClass=function(node,_1ad){
node=dojo.byId(node);
var cs=new String(_1ad);
try{
if(typeof node.className=="string"){
node.className=cs;
}else{
if(node.setAttribute){
node.setAttribute("class",_1ad);
node.className=cs;
}else{
return false;
}
}
}
catch(e){
dojo.debug("dojo.html.setClass() failed",e);
}
return true;
};
dojo.html.removeClass=function(node,_1b0,_1b1){
try{
if(!_1b1){
var _1b2=dojo.html.getClass(node).replace(new RegExp("(^|\\s+)"+_1b0+"(\\s+|$)"),"$1$2");
}else{
var _1b2=dojo.html.getClass(node).replace(_1b0,"");
}
dojo.html.setClass(node,_1b2);
}
catch(e){
dojo.debug("dojo.html.removeClass() failed",e);
}
return true;
};
dojo.html.replaceClass=function(node,_1b4,_1b5){
dojo.html.removeClass(node,_1b5);
dojo.html.addClass(node,_1b4);
};
dojo.html.classMatchType={ContainsAll:0,ContainsAny:1,IsOnly:2};
dojo.html.getElementsByClass=function(_1b6,_1b7,_1b8,_1b9,_1ba){
_1ba=false;
var _1bb=dojo.doc();
_1b7=dojo.byId(_1b7)||_1bb;
var _1bc=_1b6.split(/\s+/g);
var _1bd=[];
if(_1b9!=1&&_1b9!=2){
_1b9=0;
}
var _1be=new RegExp("(\\s|^)(("+_1bc.join(")|(")+"))(\\s|$)");
var _1bf=_1bc.join(" ").length;
var _1c0=[];
if(!_1ba&&_1bb.evaluate){
var _1c1=".//"+(_1b8||"*")+"[contains(";
if(_1b9!=dojo.html.classMatchType.ContainsAny){
_1c1+="concat(' ',@class,' '), ' "+_1bc.join(" ') and contains(concat(' ',@class,' '), ' ")+" ')";
if(_1b9==2){
_1c1+=" and string-length(@class)="+_1bf+"]";
}else{
_1c1+="]";
}
}else{
_1c1+="concat(' ',@class,' '), ' "+_1bc.join(" ') or contains(concat(' ',@class,' '), ' ")+" ')]";
}
var _1c2=_1bb.evaluate(_1c1,_1b7,null,XPathResult.ANY_TYPE,null);
var _1c3=_1c2.iterateNext();
while(_1c3){
try{
_1c0.push(_1c3);
_1c3=_1c2.iterateNext();
}
catch(e){
break;
}
}
return _1c0;
}else{
if(!_1b8){
_1b8="*";
}
_1c0=_1b7.getElementsByTagName(_1b8);
var node,i=0;
outer:
while(node=_1c0[i++]){
var _1c6=dojo.html.getClasses(node);
if(_1c6.length==0){
continue outer;
}
var _1c7=0;
for(var j=0;j<_1c6.length;j++){
if(_1be.test(_1c6[j])){
if(_1b9==dojo.html.classMatchType.ContainsAny){
_1bd.push(node);
continue outer;
}else{
_1c7++;
}
}else{
if(_1b9==dojo.html.classMatchType.IsOnly){
continue outer;
}
}
}
if(_1c7==_1bc.length){
if((_1b9==dojo.html.classMatchType.IsOnly)&&(_1c7==_1c6.length)){
_1bd.push(node);
}else{
if(_1b9==dojo.html.classMatchType.ContainsAll){
_1bd.push(node);
}
}
}
}
return _1bd;
}
};
dojo.html.getElementsByClassName=dojo.html.getElementsByClass;
dojo.html.toCamelCase=function(_1c9){
var arr=_1c9.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.html.toSelectorCase=function(_1cd){
return _1cd.replace(/([A-Z])/g,"-$1").toLowerCase();
};
if(dojo.render.html.ie){
dojo.html.getComputedStyle=function(node,_1cf,_1d0){
node=dojo.byId(node);
if(!node||!node.style){
return _1d0;
}
return node.currentStyle[dojo.html.toCamelCase(_1cf)];
};
dojo.html.getComputedStyles=function(node){
return node.currentStyle;
};
}else{
dojo.html.getComputedStyle=function(node,_1d3,_1d4){
node=dojo.byId(node);
if(!node||!node.style){
return _1d4;
}
var s=document.defaultView.getComputedStyle(node,null);
return (s&&s[dojo.html.toCamelCase(_1d3)])||"";
};
dojo.html.getComputedStyles=function(node){
return document.defaultView.getComputedStyle(node,null);
};
}
dojo.html.getStyleProperty=function(node,_1d8){
node=dojo.byId(node);
return (node&&node.style?node.style[dojo.html.toCamelCase(_1d8)]:undefined);
};
dojo.html.getStyle=function(node,_1da){
var _1db=dojo.html.getStyleProperty(node,_1da);
return (_1db?_1db:dojo.html.getComputedStyle(node,_1da));
};
dojo.html.setStyle=function(node,_1dd,_1de){
node=dojo.byId(node);
if(node&&node.style){
var _1df=dojo.html.toCamelCase(_1dd);
node.style[_1df]=_1de;
}
};
dojo.html.setStyleText=function(_1e0,text){
try{
_1e0.style.cssText=text;
}
catch(e){
_1e0.setAttribute("style",text);
}
};
dojo.html.copyStyle=function(_1e2,_1e3){
if(!_1e3.style.cssText){
_1e2.setAttribute("style",_1e3.getAttribute("style"));
}else{
_1e2.style.cssText=_1e3.style.cssText;
}
dojo.html.addClass(_1e2,dojo.html.getClass(_1e3));
};
dojo.html.getUnitValue=function(node,_1e5,_1e6){
var s=dojo.html.getComputedStyle(node,_1e5);
if((!s)||((s=="auto")&&(_1e6))){
return {value:0,units:"px"};
}
var _1e8=s.match(/(\-?[\d.]+)([a-z%]*)/i);
if(!_1e8){
return dojo.html.getUnitValue.bad;
}
return {value:Number(_1e8[1]),units:_1e8[2].toLowerCase()};
};
dojo.html.getUnitValue.bad={value:NaN,units:""};
if(dojo.render.html.ie){
dojo.html.toPixelValue=function(_1e9,_1ea){
if(!_1ea){
return 0;
}
if(_1ea.slice(-2)=="px"){
return parseFloat(_1ea);
}
var _1eb=0;
with(_1e9){
var _1ec=style.left;
var _1ed=runtimeStyle.left;
runtimeStyle.left=currentStyle.left;
try{
style.left=_1ea||0;
_1eb=style.pixelLeft;
style.left=_1ec;
runtimeStyle.left=_1ed;
}
catch(e){
}
}
return _1eb;
};
}else{
dojo.html.toPixelValue=function(_1ee,_1ef){
return (_1ef&&(_1ef.slice(-2)=="px")?parseFloat(_1ef):0);
};
}
dojo.html.getPixelValue=function(node,_1f1,_1f2){
return dojo.html.toPixelValue(node,dojo.html.getComputedStyle(node,_1f1));
};
dojo.html.setPositivePixelValue=function(node,_1f4,_1f5){
if(isNaN(_1f5)){
return false;
}
node.style[_1f4]=Math.max(0,_1f5)+"px";
return true;
};
dojo.html.styleSheet=null;
dojo.html.insertCssRule=function(_1f6,_1f7,_1f8){
if(!dojo.html.styleSheet){
if(document.createStyleSheet){
dojo.html.styleSheet=document.createStyleSheet();
}else{
if(document.styleSheets[0]){
dojo.html.styleSheet=document.styleSheets[0];
}else{
return null;
}
}
}
if(arguments.length<3){
if(dojo.html.styleSheet.cssRules){
_1f8=dojo.html.styleSheet.cssRules.length;
}else{
if(dojo.html.styleSheet.rules){
_1f8=dojo.html.styleSheet.rules.length;
}else{
return null;
}
}
}
if(dojo.html.styleSheet.insertRule){
var rule=_1f6+" { "+_1f7+" }";
return dojo.html.styleSheet.insertRule(rule,_1f8);
}else{
if(dojo.html.styleSheet.addRule){
return dojo.html.styleSheet.addRule(_1f6,_1f7,_1f8);
}else{
return null;
}
}
};
dojo.html.removeCssRule=function(_1fa){
if(!dojo.html.styleSheet){
dojo.debug("no stylesheet defined for removing rules");
return false;
}
if(dojo.render.html.ie){
if(!_1fa){
_1fa=dojo.html.styleSheet.rules.length;
dojo.html.styleSheet.removeRule(_1fa);
}
}else{
if(document.styleSheets[0]){
if(!_1fa){
_1fa=dojo.html.styleSheet.cssRules.length;
}
dojo.html.styleSheet.deleteRule(_1fa);
}
}
return true;
};
dojo.html._insertedCssFiles=[];
dojo.html.insertCssFile=function(URI,doc,_1fd,_1fe){
if(!URI){
return;
}
if(!doc){
doc=document;
}
var _1ff=dojo.hostenv.getText(URI,false,_1fe);
if(_1ff===null){
return;
}
_1ff=dojo.html.fixPathsInCssText(_1ff,URI);
if(_1fd){
var idx=-1,node,ent=dojo.html._insertedCssFiles;
for(var i=0;i<ent.length;i++){
if((ent[i].doc==doc)&&(ent[i].cssText==_1ff)){
idx=i;
node=ent[i].nodeRef;
break;
}
}
if(node){
var _204=doc.getElementsByTagName("style");
for(var i=0;i<_204.length;i++){
if(_204[i]==node){
return;
}
}
dojo.html._insertedCssFiles.shift(idx,1);
}
}
var _205=dojo.html.insertCssText(_1ff,doc);
dojo.html._insertedCssFiles.push({"doc":doc,"cssText":_1ff,"nodeRef":_205});
if(_205&&djConfig.isDebug){
_205.setAttribute("dbgHref",URI);
}
return _205;
};
dojo.html.insertCssText=function(_206,doc,URI){
if(!_206){
return;
}
if(!doc){
doc=document;
}
if(URI){
_206=dojo.html.fixPathsInCssText(_206,URI);
}
var _209=doc.createElement("style");
_209.setAttribute("type","text/css");
var head=doc.getElementsByTagName("head")[0];
if(!head){
dojo.debug("No head tag in document, aborting styles");
return;
}else{
head.appendChild(_209);
}
if(_209.styleSheet){
var _20b=function(){
try{
_209.styleSheet.cssText=_206;
}
catch(e){
dojo.debug(e);
}
};
if(_209.styleSheet.disabled){
setTimeout(_20b,10);
}else{
_20b();
}
}else{
var _20c=doc.createTextNode(_206);
_209.appendChild(_20c);
}
return _209;
};
dojo.html.fixPathsInCssText=function(_20d,URI){
if(!_20d||!URI){
return;
}
var _20f,str="",url="",_212="[\\t\\s\\w\\(\\)\\/\\.\\\\'\"-:#=&?~]+";
var _213=new RegExp("url\\(\\s*("+_212+")\\s*\\)");
var _214=/(file|https?|ftps?):\/\//;
regexTrim=new RegExp("^[\\s]*(['\"]?)("+_212+")\\1[\\s]*?$");
if(dojo.render.html.ie55||dojo.render.html.ie60){
var _215=new RegExp("AlphaImageLoader\\((.*)src=['\"]("+_212+")['\"]");
while(_20f=_215.exec(_20d)){
url=_20f[2].replace(regexTrim,"$2");
if(!_214.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_20d.substring(0,_20f.index)+"AlphaImageLoader("+_20f[1]+"src='"+url+"'";
_20d=_20d.substr(_20f.index+_20f[0].length);
}
_20d=str+_20d;
str="";
}
while(_20f=_213.exec(_20d)){
url=_20f[1].replace(regexTrim,"$2");
if(!_214.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_20d.substring(0,_20f.index)+"url("+url+")";
_20d=_20d.substr(_20f.index+_20f[0].length);
}
return str+_20d;
};
dojo.html.setActiveStyleSheet=function(_216){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")){
a.disabled=true;
if(a.getAttribute("title")==_216){
a.disabled=false;
}
}
}
};
dojo.html.getActiveStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")&&!a.disabled){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.getPreferredStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttrib