package Net::IDN::Stupid::_Mapping;

use utf8;
use strict;

use Exporter;
our @ISA = ('Exporter');
our @EXPORT_OK = ('NFC', 'MapWidth');
our %EXPORT_TAGS = ( 'all' => \@EXPORT_OK );


sub MapWidth {
  my $s = shift;
  $s =~ tr/\x{3000}\x{FF01}-\x{FF5E}\x{FF5F}\x{FF60}\x{FF61}\x{FF62}\x{FF63}\x{FF64}\x{FF65}\x{FF66}\x{FF67}\x{FF68}\x{FF69}\x{FF6A}\x{FF6B}\x{FF6C}\x{FF6D}\x{FF6E}\x{FF6F}\x{FF70}\x{FF71}\x{FF72}\x{FF73}\x{FF74}\x{FF75}\x{FF76}\x{FF77}\x{FF78}\x{FF79}\x{FF7A}\x{FF7B}\x{FF7C}\x{FF7D}\x{FF7E}\x{FF7F}\x{FF80}\x{FF81}\x{FF82}\x{FF83}\x{FF84}\x{FF85}-\x{FF8A}\x{FF8B}\x{FF8C}\x{FF8D}\x{FF8E}\x{FF8F}-\x{FF93}\x{FF94}\x{FF95}\x{FF96}-\x{FF9B}\x{FF9C}\x{FF9D}\x{FF9E}\x{FF9F}\x{FFA0}\x{FFA1}-\x{FFBE}\x{FFC2}-\x{FFC7}\x{FFCA}-\x{FFCF}\x{FFD2}-\x{FFD7}\x{FFDA}-\x{FFDC}\x{FFE0}\x{FFE1}\x{FFE2}\x{FFE3}\x{FFE4}\x{FFE5}\x{FFE6}\x{FFE8}\x{FFE9}-\x{FFEC}\x{FFED}\x{FFEE}/\x20\x21-\x7E\x{2985}\x{2986}\x{3002}\x{300C}\x{300D}\x{3001}\x{30FB}\x{30F2}\x{30A1}\x{30A3}\x{30A5}\x{30A7}\x{30A9}\x{30E3}\x{30E5}\x{30E7}\x{30C3}\x{30FC}\x{30A2}\x{30A4}\x{30A6}\x{30A8}\x{30AA}\x{30AB}\x{30AD}\x{30AF}\x{30B1}\x{30B3}\x{30B5}\x{30B7}\x{30B9}\x{30BB}\x{30BD}\x{30BF}\x{30C1}\x{30C4}\x{30C6}\x{30C8}\x{30CA}-\x{30CF}\x{30D2}\x{30D5}\x{30D8}\x{30DB}\x{30DE}-\x{30E2}\x{30E4}\x{30E6}\x{30E8}-\x{30ED}\x{30EF}\x{30F3}\x{3099}\x{309A}\x{3164}\x{3131}-\x{314E}\x{314F}-\x{3154}\x{3155}-\x{315A}\x{315B}-\x{3160}\x{3161}-\x{3163}\x{A2}\x{A3}\x{AC}\x{AF}\x{A6}\x{A5}\x{20A9}\x{2502}\x{2190}-\x{2193}\x{25A0}\x{25CB}/;
  return $s;
}

sub NFC {  my $s = shift;
  $s =~ s/(.?[\x{300}-\x{34E}\x{350}-\x{36F}\x{374}\x{37E}\x{387}\x{483}-\x{487}\x{591}-\x{5BD}\x{5BF}\x{5C1}\x{5C2}\x{5C4}\x{5C5}\x{5C7}\x{610}-\x{61A}\x{64B}-\x{65F}\x{670}\x{6D6}-\x{6DC}\x{6DF}-\x{6E4}\x{6E7}\x{6E8}\x{6EA}-\x{6ED}\x{711}\x{730}-\x{74A}\x{7EB}-\x{7F3}\x{816}-\x{819}\x{81B}-\x{823}\x{825}-\x{827}\x{829}-\x{82D}\x{859}-\x{85B}\x{93C}\x{94D}\x{951}-\x{954}\x{958}-\x{960}\x{9BC}\x{9BE}\x{9CD}\x{9D7}\x{9DC}-\x{9DF}\x{A33}\x{A36}\x{A3C}\x{A4D}\x{A59}-\x{A5C}\x{A5E}\x{ABC}\x{ACD}\x{B3C}\x{B3E}\x{B4D}\x{B56}\x{B57}\x{B5C}-\x{B5E}\x{BBE}\x{BCD}\x{BD7}\x{C4D}\x{C55}\x{C56}\x{CBC}\x{CC2}\x{CCD}\x{CD5}-\x{CD7}\x{D3E}\x{D4D}\x{D57}\x{DCA}\x{DCF}\x{DDF}\x{E38}-\x{E3A}\x{E48}-\x{E4B}\x{EB8}\x{EB9}\x{EC8}-\x{ECB}\x{F18}\x{F19}\x{F35}\x{F37}\x{F39}\x{F43}\x{F4D}\x{F52}\x{F57}\x{F5C}\x{F69}\x{F71}-\x{F78}\x{F7A}-\x{F7D}\x{F80}-\x{F84}\x{F86}\x{F87}\x{F93}\x{F9D}\x{FA2}\x{FA7}\x{FAC}\x{FB9}\x{FC6}\x{102E}\x{1037}\x{1039}\x{103A}\x{108D}\x{1161}-\x{1176}\x{11A8}-\x{11C3}\x{135D}-\x{135F}\x{1714}\x{1734}\x{17D2}\x{17DD}\x{18A9}\x{1939}-\x{193B}\x{1A17}\x{1A18}\x{1A60}\x{1A75}-\x{1A7C}\x{1A7F}\x{1B34}\x{1B35}\x{1B44}\x{1B6B}-\x{1B73}\x{1BAA}\x{1BE6}\x{1BF2}\x{1BF3}\x{1C37}\x{1CD0}-\x{1CD2}\x{1CD4}-\x{1CE0}\x{1CE2}-\x{1CE8}\x{1CED}\x{1DC0}-\x{1DE6}\x{1DFC}-\x{1DFF}\x{1F71}\x{1F73}\x{1F75}\x{1F77}\x{1F79}\x{1F7B}\x{1F7D}\x{1FBB}\x{1FBE}\x{1FC9}\x{1FCB}\x{1FD3}\x{1FDB}\x{1FE3}\x{1FEB}\x{1FEE}-\x{1FF0}\x{1FF9}\x{1FFB}\x{1FFD}\x{2000}-\x{2002}\x{20D0}-\x{20DC}\x{20E1}\x{20E5}-\x{20F0}\x{2126}\x{212A}-\x{212C}\x{2329}\x{232A}\x{2ADC}\x{2CEF}-\x{2CF1}\x{2D7F}\x{2DE0}-\x{2DFF}\x{302A}-\x{302F}\x{3099}-\x{309B}\x{A66F}\x{A67C}\x{A67D}\x{A6F0}\x{A6F1}\x{A806}\x{A8C4}\x{A8E0}-\x{A8F1}\x{A92B}-\x{A92D}\x{A953}\x{A9B3}\x{A9C0}\x{AAB0}\x{AAB2}-\x{AAB4}\x{AAB7}\x{AAB8}\x{AABE}\x{AABF}\x{AAC1}\x{ABED}\x{F900}-\x{FA0E}\x{FA10}\x{FA12}\x{FA15}-\x{FA20}\x{FA22}\x{FA25}-\x{FA27}\x{FA2A}-\x{FA2E}\x{FA30}-\x{FA6E}\x{FA70}-\x{FADA}\x{FB1D}-\x{FB1F}\x{FB2A}-\x{FB3E}\x{FB40}-\x{FB4F}\x{FE20}-\x{FE26}\x{101FD}\x{10A0D}\x{10A0F}\x{10A38}-\x{10A3A}\x{10A3F}\x{11046}\x{110B9}\x{110BA}\x{1D15E}-\x{1D169}\x{1D16D}-\x{1D172}\x{1D17B}-\x{1D182}\x{1D185}-\x{1D18B}\x{1D1AA}-\x{1D1AD}\x{1D1BB}-\x{1D1C1}\x{1D242}-\x{1D244}\x{2F800}-\x{2FA1E}]+)/ _nfc($1) /ge;
  return $s;
}
my %_com = (0x300=>{0x41=>0xC0,0x45=>0xC8,0x49=>0xCC,0x4E=>0x1F8,0x4F=>0xD2,0x55=>0xD9,0x57=>0x1E80,0x59=>0x1EF2,0x61=>0xE0,0x65=>0xE8,0x69=>0xEC,0x6E=>0x1F9,0x6F=>0xF2,0x75=>0xF9,0x77=>0x1E81,0x79=>0x1EF3,0xA8=>0x1FED,0xC2=>0x1EA6,0xCA=>0x1EC0,0xD4=>0x1ED2,0xDC=>0x1DB,0xE2=>0x1EA7,0xEA=>0x1EC1,0xF4=>0x1ED3,0xFC=>0x1DC,0x102=>0x1EB0,0x103=>0x1EB1,0x112=>0x1E14,0x113=>0x1E15,0x14C=>0x1E50,0x14D=>0x1E51,0x1A0=>0x1EDC,0x1A1=>0x1EDD,0x1AF=>0x1EEA,0x1B0=>0x1EEB,0x391=>0x1FBA,0x395=>0x1FC8,0x397=>0x1FCA,0x399=>0x1FDA,0x39F=>0x1FF8,0x3A5=>0x1FEA,0x3A9=>0x1FFA,0x3B1=>0x1F70,0x3B5=>0x1F72,0x3B7=>0x1F74,0x3B9=>0x1F76,0x3BF=>0x1F78,0x3C5=>0x1F7A,0x3C9=>0x1F7C,0x3CA=>0x1FD2,0x3CB=>0x1FE2,0x415=>0x400,0x418=>0x40D,0x435=>0x450,0x438=>0x45D,0x1F00=>0x1F02,0x1F01=>0x1F03,0x1F08=>0x1F0A,0x1F09=>0x1F0B,0x1F10=>0x1F12,0x1F11=>0x1F13,0x1F18=>0x1F1A,0x1F19=>0x1F1B,0x1F20=>0x1F22,0x1F21=>0x1F23,0x1F28=>0x1F2A,0x1F29=>0x1F2B,0x1F30=>0x1F32,0x1F31=>0x1F33,0x1F38=>0x1F3A,0x1F39=>0x1F3B,0x1F40=>0x1F42,0x1F41=>0x1F43,0x1F48=>0x1F4A,0x1F49=>0x1F4B,0x1F50=>0x1F52,0x1F51=>0x1F53,0x1F59=>0x1F5B,0x1F60=>0x1F62,0x1F61=>0x1F63,0x1F68=>0x1F6A,0x1F69=>0x1F6B,0x1FBF=>0x1FCD,0x1FFE=>0x1FDD,},0x301=>{0x41=>0xC1,0x43=>0x106,0x45=>0xC9,0x47=>0x1F4,0x49=>0xCD,0x4B=>0x1E30,0x4C=>0x139,0x4D=>0x1E3E,0x4E=>0x143,0x4F=>0xD3,0x50=>0x1E54,0x52=>0x154,0x53=>0x15A,0x55=>0xDA,0x57=>0x1E82,0x59=>0xDD,0x5A=>0x179,0x61=>0xE1,0x63=>0x107,0x65=>0xE9,0x67=>0x1F5,0x69=>0xED,0x6B=>0x1E31,0x6C=>0x13A,0x6D=>0x1E3F,0x6E=>0x144,0x6F=>0xF3,0x70=>0x1E55,0x72=>0x155,0x73=>0x15B,0x75=>0xFA,0x77=>0x1E83,0x79=>0xFD,0x7A=>0x17A,0xA8=>0x385,0xC2=>0x1EA4,0xC5=>0x1FA,0xC6=>0x1FC,0xC7=>0x1E08,0xCA=>0x1EBE,0xCF=>0x1E2E,0xD4=>0x1ED0,0xD5=>0x1E4C,0xD8=>0x1FE,0xDC=>0x1D7,0xE2=>0x1EA5,0xE5=>0x1FB,0xE6=>0x1FD,0xE7=>0x1E09,0xEA=>0x1EBF,0xEF=>0x1E2F,0xF4=>0x1ED1,0xF5=>0x1E4D,0xF8=>0x1FF,0xFC=>0x1D8,0x102=>0x1EAE,0x103=>0x1EAF,0x112=>0x1E16,0x113=>0x1E17,0x14C=>0x1E52,0x14D=>0x1E53,0x168=>0x1E78,0x169=>0x1E79,0x1A0=>0x1EDA,0x1A1=>0x1EDB,0x1AF=>0x1EE8,0x1B0=>0x1EE9,0x391=>0x386,0x395=>0x388,0x397=>0x389,0x399=>0x38A,0x39F=>0x38C,0x3A5=>0x38E,0x3A9=>0x38F,0x3B1=>0x3AC,0x3B5=>0x3AD,0x3B7=>0x3AE,0x3B9=>0x3AF,0x3BF=>0x3CC,0x3C5=>0x3CD,0x3C9=>0x3CE,0x3CA=>0x390,0x3CB=>0x3B0,0x3D2=>0x3D3,0x413=>0x403,0x41A=>0x40C,0x433=>0x453,0x43A=>0x45C,0x1F00=>0x1F04,0x1F01=>0x1F05,0x1F08=>0x1F0C,0x1F09=>0x1F0D,0x1F10=>0x1F14,0x1F11=>0x1F15,0x1F18=>0x1F1C,0x1F19=>0x1F1D,0x1F20=>0x1F24,0x1F21=>0x1F25,0x1F28=>0x1F2C,0x1F29=>0x1F2D,0x1F30=>0x1F34,0x1F31=>0x1F35,0x1F38=>0x1F3C,0x1F39=>0x1F3D,0x1F40=>0x1F44,0x1F41=>0x1F45,0x1F48=>0x1F4C,0x1F49=>0x1F4D,0x1F50=>0x1F54,0x1F51=>0x1F55,0x1F59=>0x1F5D,0x1F60=>0x1F64,0x1F61=>0x1F65,0x1F68=>0x1F6C,0x1F69=>0x1F6D,0x1FBF=>0x1FCE,0x1FFE=>0x1FDE,},0x302=>{0x41=>0xC2,0x43=>0x108,0x45=>0xCA,0x47=>0x11C,0x48=>0x124,0x49=>0xCE,0x4A=>0x134,0x4F=>0xD4,0x53=>0x15C,0x55=>0xDB,0x57=>0x174,0x59=>0x176,0x5A=>0x1E90,0x61=>0xE2,0x63=>0x109,0x65=>0xEA,0x67=>0x11D,0x68=>0x125,0x69=>0xEE,0x6A=>0x135,0x6F=>0xF4,0x73=>0x15D,0x75=>0xFB,0x77=>0x175,0x79=>0x177,0x7A=>0x1E91,0x1EA0=>0x1EAC,0x1EA1=>0x1EAD,0x1EB8=>0x1EC6,0x1EB9=>0x1EC7,0x1ECC=>0x1ED8,0x1ECD=>0x1ED9,},0x303=>{0x41=>0xC3,0x45=>0x1EBC,0x49=>0x128,0x4E=>0xD1,0x4F=>0xD5,0x55=>0x168,0x56=>0x1E7C,0x59=>0x1EF8,0x61=>0xE3,0x65=>0x1EBD,0x69=>0x129,0x6E=>0xF1,0x6F=>0xF5,0x75=>0x169,0x76=>0x1E7D,0x79=>0x1EF9,0xC2=>0x1EAA,0xCA=>0x1EC4,0xD4=>0x1ED6,0xE2=>0x1EAB,0xEA=>0x1EC5,0xF4=>0x1ED7,0x102=>0x1EB4,0x103=>0x1EB5,0x1A0=>0x1EE0,0x1A1=>0x1EE1,0x1AF=>0x1EEE,0x1B0=>0x1EEF,},0x304=>{0x41=>0x100,0x45=>0x112,0x47=>0x1E20,0x49=>0x12A,0x4F=>0x14C,0x55=>0x16A,0x59=>0x232,0x61=>0x101,0x65=>0x113,0x67=>0x1E21,0x69=>0x12B,0x6F=>0x14D,0x75=>0x16B,0x79=>0x233,0xC4=>0x1DE,0xC6=>0x1E2,0xD5=>0x22C,0xD6=>0x22A,0xDC=>0x1D5,0xE4=>0x1DF,0xE6=>0x1E3,0xF5=>0x22D,0xF6=>0x22B,0xFC=>0x1D6,0x1EA=>0x1EC,0x1EB=>0x1ED,0x226=>0x1E0,0x227=>0x1E1,0x22E=>0x230,0x22F=>0x231,0x391=>0x1FB9,0x399=>0x1FD9,0x3A5=>0x1FE9,0x3B1=>0x1FB1,0x3B9=>0x1FD1,0x3C5=>0x1FE1,0x418=>0x4E2,0x423=>0x4EE,0x438=>0x4E3,0x443=>0x4EF,0x1E36=>0x1E38,0x1E37=>0x1E39,0x1E5A=>0x1E5C,0x1E5B=>0x1E5D,},0x306=>{0x41=>0x102,0x45=>0x114,0x47=>0x11E,0x49=>0x12C,0x4F=>0x14E,0x55=>0x16C,0x61=>0x103,0x65=>0x115,0x67=>0x11F,0x69=>0x12D,0x6F=>0x14F,0x75=>0x16D,0x228=>0x1E1C,0x229=>0x1E1D,0x391=>0x1FB8,0x399=>0x1FD8,0x3A5=>0x1FE8,0x3B1=>0x1FB0,0x3B9=>0x1FD0,0x3C5=>0x1FE0,0x410=>0x4D0,0x415=>0x4D6,0x416=>0x4C1,0x418=>0x419,0x423=>0x40E,0x430=>0x4D1,0x435=>0x4D7,0x436=>0x4C2,0x438=>0x439,0x443=>0x45E,0x1EA0=>0x1EB6,0x1EA1=>0x1EB7,},0x307=>{0x41=>0x226,0x42=>0x1E02,0x43=>0x10A,0x44=>0x1E0A,0x45=>0x116,0x46=>0x1E1E,0x47=>0x120,0x48=>0x1E22,0x49=>0x130,0x4D=>0x1E40,0x4E=>0x1E44,0x4F=>0x22E,0x50=>0x1E56,0x52=>0x1E58,0x53=>0x1E60,0x54=>0x1E6A,0x57=>0x1E86,0x58=>0x1E8A,0x59=>0x1E8E,0x5A=>0x17B,0x61=>0x227,0x62=>0x1E03,0x63=>0x10B,0x64=>0x1E0B,0x65=>0x117,0x66=>0x1E1F,0x67=>0x121,0x68=>0x1E23,0x6D=>0x1E41,0x6E=>0x1E45,0x6F=>0x22F,0x70=>0x1E57,0x72=>0x1E59,0x73=>0x1E61,0x74=>0x1E6B,0x77=>0x1E87,0x78=>0x1E8B,0x79=>0x1E8F,0x7A=>0x17C,0x15A=>0x1E64,0x15B=>0x1E65,0x160=>0x1E66,0x161=>0x1E67,0x17F=>0x1E9B,0x1E62=>0x1E68,0x1E63=>0x1E69,},0x308=>{0x41=>0xC4,0x45=>0xCB,0x48=>0x1E26,0x49=>0xCF,0x4F=>0xD6,0x55=>0xDC,0x57=>0x1E84,0x58=>0x1E8C,0x59=>0x178,0x61=>0xE4,0x65=>0xEB,0x68=>0x1E27,0x69=>0xEF,0x6F=>0xF6,0x74=>0x1E97,0x75=>0xFC,0x77=>0x1E85,0x78=>0x1E8D,0x79=>0xFF,0xD5=>0x1E4E,0xF5=>0x1E4F,0x16A=>0x1E7A,0x16B=>0x1E7B,0x399=>0x3AA,0x3A5=>0x3AB,0x3B9=>0x3CA,0x3C5=>0x3CB,0x3D2=>0x3D4,0x406=>0x407,0x410=>0x4D2,0x415=>0x401,0x416=>0x4DC,0x417=>0x4DE,0x418=>0x4E4,0x41E=>0x4E6,0x423=>0x4F0,0x427=>0x4F4,0x42B=>0x4F8,0x42D=>0x4EC,0x430=>0x4D3,0x435=>0x451,0x436=>0x4DD,0x437=>0x4DF,0x438=>0x4E5,0x43E=>0x4E7,0x443=>0x4F1,0x447=>0x4F5,0x44B=>0x4F9,0x44D=>0x4ED,0x456=>0x457,0x4D8=>0x4DA,0x4D9=>0x4DB,0x4E8=>0x4EA,0x4E9=>0x4EB,},0x309=>{0x41=>0x1EA2,0x45=>0x1EBA,0x49=>0x1EC8,0x4F=>0x1ECE,0x55=>0x1EE6,0x59=>0x1EF6,0x61=>0x1EA3,0x65=>0x1EBB,0x69=>0x1EC9,0x6F=>0x1ECF,0x75=>0x1EE7,0x79=>0x1EF7,0xC2=>0x1EA8,0xCA=>0x1EC2,0xD4=>0x1ED4,0xE2=>0x1EA9,0xEA=>0x1EC3,0xF4=>0x1ED5,0x102=>0x1EB2,0x103=>0x1EB3,0x1A0=>0x1EDE,0x1A1=>0x1EDF,0x1AF=>0x1EEC,0x1B0=>0x1EED,},0x30A=>{0x41=>0xC5,0x55=>0x16E,0x61=>0xE5,0x75=>0x16F,0x77=>0x1E98,0x79=>0x1E99,},0x30B=>{0x4F=>0x150,0x55=>0x170,0x6F=>0x151,0x75=>0x171,0x423=>0x4F2,0x443=>0x4F3,},0x30C=>{0x41=>0x1CD,0x43=>0x10C,0x44=>0x10E,0x45=>0x11A,0x47=>0x1E6,0x48=>0x21E,0x49=>0x1CF,0x4B=>0x1E8,0x4C=>0x13D,0x4E=>0x147,0x4F=>0x1D1,0x52=>0x158,0x53=>0x160,0x54=>0x164,0x55=>0x1D3,0x5A=>0x17D,0x61=>0x1CE,0x63=>0x10D,0x64=>0x10F,0x65=>0x11B,0x67=>0x1E7,0x68=>0x21F,0x69=>0x1D0,0x6A=>0x1F0,0x6B=>0x1E9,0x6C=>0x13E,0x6E=>0x148,0x6F=>0x1D2,0x72=>0x159,0x73=>0x161,0x74=>0x165,0x75=>0x1D4,0x7A=>0x17E,0xDC=>0x1D9,0xFC=>0x1DA,0x1B7=>0x1EE,0x292=>0x1EF,},0x30F=>{0x41=>0x200,0x45=>0x204,0x49=>0x208,0x4F=>0x20C,0x52=>0x210,0x55=>0x214,0x61=>0x201,0x65=>0x205,0x69=>0x209,0x6F=>0x20D,0x72=>0x211,0x75=>0x215,0x474=>0x476,0x475=>0x477,},0x311=>{0x41=>0x202,0x45=>0x206,0x49=>0x20A,0x4F=>0x20E,0x52=>0x212,0x55=>0x216,0x61=>0x203,0x65=>0x207,0x69=>0x20B,0x6F=>0x20F,0x72=>0x213,0x75=>0x217,},0x313=>{0x391=>0x1F08,0x395=>0x1F18,0x397=>0x1F28,0x399=>0x1F38,0x39F=>0x1F48,0x3A9=>0x1F68,0x3B1=>0x1F00,0x3B5=>0x1F10,0x3B7=>0x1F20,0x3B9=>0x1F30,0x3BF=>0x1F40,0x3C1=>0x1FE4,0x3C5=>0x1F50,0x3C9=>0x1F60,},0x314=>{0x391=>0x1F09,0x395=>0x1F19,0x397=>0x1F29,0x399=>0x1F39,0x39F=>0x1F49,0x3A1=>0x1FEC,0x3A5=>0x1F59,0x3A9=>0x1F69,0x3B1=>0x1F01,0x3B5=>0x1F11,0x3B7=>0x1F21,0x3B9=>0x1F31,0x3BF=>0x1F41,0x3C1=>0x1FE5,0x3C5=>0x1F51,0x3C9=>0x1F61,},0x31B=>{0x4F=>0x1A0,0x55=>0x1AF,0x6F=>0x1A1,0x75=>0x1B0,},0x323=>{0x41=>0x1EA0,0x42=>0x1E04,0x44=>0x1E0C,0x45=>0x1EB8,0x48=>0x1E24,0x49=>0x1ECA,0x4B=>0x1E32,0x4C=>0x1E36,0x4D=>0x1E42,0x4E=>0x1E46,0x4F=>0x1ECC,0x52=>0x1E5A,0x53=>0x1E62,0x54=>0x1E6C,0x55=>0x1EE4,0x56=>0x1E7E,0x57=>0x1E88,0x59=>0x1EF4,0x5A=>0x1E92,0x61=>0x1EA1,0x62=>0x1E05,0x64=>0x1E0D,0x65=>0x1EB9,0x68=>0x1E25,0x69=>0x1ECB,0x6B=>0x1E33,0x6C=>0x1E37,0x6D=>0x1E43,0x6E=>0x1E47,0x6F=>0x1ECD,0x72=>0x1E5B,0x73=>0x1E63,0x74=>0x1E6D,0x75=>0x1EE5,0x76=>0x1E7F,0x77=>0x1E89,0x79=>0x1EF5,0x7A=>0x1E93,0x1A0=>0x1EE2,0x1A1=>0x1EE3,0x1AF=>0x1EF0,0x1B0=>0x1EF1,},0x324=>{0x55=>0x1E72,0x75=>0x1E73,},0x325=>{0x41=>0x1E00,0x61=>0x1E01,},0x326=>{0x53=>0x218,0x54=>0x21A,0x73=>0x219,0x74=>0x21B,},0x327=>{0x43=>0xC7,0x44=>0x1E10,0x45=>0x228,0x47=>0x122,0x48=>0x1E28,0x4B=>0x136,0x4C=>0x13B,0x4E=>0x145,0x52=>0x156,0x53=>0x15E,0x54=>0x162,0x63=>0xE7,0x64=>0x1E11,0x65=>0x229,0x67=>0x123,0x68=>0x1E29,0x6B=>0x137,0x6C=>0x13C,0x6E=>0x146,0x72=>0x157,0x73=>0x15F,0x74=>0x163,},0x328=>{0x41=>0x104,0x45=>0x118,0x49=>0x12E,0x4F=>0x1EA,0x55=>0x172,0x61=>0x105,0x65=>0x119,0x69=>0x12F,0x6F=>0x1EB,0x75=>0x173,},0x32D=>{0x44=>0x1E12,0x45=>0x1E18,0x4C=>0x1E3C,0x4E=>0x1E4A,0x54=>0x1E70,0x55=>0x1E76,0x64=>0x1E13,0x65=>0x1E19,0x6C=>0x1E3D,0x6E=>0x1E4B,0x74=>0x1E71,0x75=>0x1E77,},0x32E=>{0x48=>0x1E2A,0x68=>0x1E2B,},0x330=>{0x45=>0x1E1A,0x49=>0x1E2C,0x55=>0x1E74,0x65=>0x1E1B,0x69=>0x1E2D,0x75=>0x1E75,},0x331=>{0x42=>0x1E06,0x44=>0x1E0E,0x4B=>0x1E34,0x4C=>0x1E3A,0x4E=>0x1E48,0x52=>0x1E5E,0x54=>0x1E6E,0x5A=>0x1E94,0x62=>0x1E07,0x64=>0x1E0F,0x68=>0x1E96,0x6B=>0x1E35,0x6C=>0x1E3B,0x6E=>0x1E49,0x72=>0x1E5F,0x74=>0x1E6F,0x7A=>0x1E95,},0x338=>{0x3C=>0x226E,0x3D=>0x2260,0x3E=>0x226F,0x2190=>0x219A,0x2192=>0x219B,0x2194=>0x21AE,0x21D0=>0x21CD,0x21D2=>0x21CF,0x21D4=>0x21CE,0x2203=>0x2204,0x2208=>0x2209,0x220B=>0x220C,0x2223=>0x2224,0x2225=>0x2226,0x223C=>0x2241,0x2243=>0x2244,0x2245=>0x2247,0x2248=>0x2249,0x224D=>0x226D,0x2261=>0x2262,0x2264=>0x2270,0x2265=>0x2271,0x2272=>0x2274,0x2273=>0x2275,0x2276=>0x2278,0x2277=>0x2279,0x227A=>0x2280,0x227B=>0x2281,0x227C=>0x22E0,0x227D=>0x22E1,0x2282=>0x2284,0x2283=>0x2285,0x2286=>0x2288,0x2287=>0x2289,0x2291=>0x22E2,0x2292=>0x22E3,0x22A2=>0x22AC,0x22A8=>0x22AD,0x22A9=>0x22AE,0x22AB=>0x22AF,0x22B2=>0x22EA,0x22B3=>0x22EB,0x22B4=>0x22EC,0x22B5=>0x22ED,},0x342=>{0xA8=>0x1FC1,0x3B1=>0x1FB6,0x3B7=>0x1FC6,0x3B9=>0x1FD6,0x3C5=>0x1FE6,0x3C9=>0x1FF6,0x3CA=>0x1FD7,0x3CB=>0x1FE7,0x1F00=>0x1F06,0x1F01=>0x1F07,0x1F08=>0x1F0E,0x1F09=>0x1F0F,0x1F20=>0x1F26,0x1F21=>0x1F27,0x1F28=>0x1F2E,0x1F29=>0x1F2F,0x1F30=>0x1F36,0x1F31=>0x1F37,0x1F38=>0x1F3E,0x1F39=>0x1F3F,0x1F50=>0x1F56,0x1F51=>0x1F57,0x1F59=>0x1F5F,0x1F60=>0x1F66,0x1F61=>0x1F67,0x1F68=>0x1F6E,0x1F69=>0x1F6F,0x1FBF=>0x1FCF,0x1FFE=>0x1FDF,},0x345=>{0x391=>0x1FBC,0x397=>0x1FCC,0x3A9=>0x1FFC,0x3AC=>0x1FB4,0x3AE=>0x1FC4,0x3B1=>0x1FB3,0x3B7=>0x1FC3,0x3C9=>0x1FF3,0x3CE=>0x1FF4,0x1F00=>0x1F80,0x1F01=>0x1F81,0x1F02=>0x1F82,0x1F03=>0x1F83,0x1F04=>0x1F84,0x1F05=>0x1F85,0x1F06=>0x1F86,0x1F07=>0x1F87,0x1F08=>0x1F88,0x1F09=>0x1F89,0x1F0A=>0x1F8A,0x1F0B=>0x1F8B,0x1F0C=>0x1F8C,0x1F0D=>0x1F8D,0x1F0E=>0x1F8E,0x1F0F=>0x1F8F,0x1F20=>0x1F90,0x1F21=>0x1F91,0x1F22=>0x1F92,0x1F23=>0x1F93,0x1F24=>0x1F94,0x1F25=>0x1F95,0x1F26=>0x1F96,0x1F27=>0x1F97,0x1F28=>0x1F98,0x1F29=>0x1F99,0x1F2A=>0x1F9A,0x1F2B=>0x1F9B,0x1F2C=>0x1F9C,0x1F2D=>0x1F9D,0x1F2E=>0x1F9E,0x1F2F=>0x1F9F,0x1F60=>0x1FA0,0x1F61=>0x1FA1,0x1F62=>0x1FA2,0x1F63=>0x1FA3,0x1F64=>0x1FA4,0x1F65=>0x1FA5,0x1F66=>0x1FA6,0x1F67=>0x1FA7,0x1F68=>0x1FA8,0x1F69=>0x1FA9,0x1F6A=>0x1FAA,0x1F6B=>0x1FAB,0x1F6C=>0x1FAC,0x1F6D=>0x1FAD,0x1F6E=>0x1FAE,0x1F6F=>0x1FAF,0x1F70=>0x1FB2,0x1F74=>0x1FC2,0x1F7C=>0x1FF2,0x1FB6=>0x1FB7,0x1FC6=>0x1FC7,0x1FF6=>0x1FF7,},0x653=>{0x627=>0x622,},0x654=>{0x627=>0x623,0x648=>0x624,0x64A=>0x626,0x6C1=>0x6C2,0x6D2=>0x6D3,0x6D5=>0x6C0,},0x655=>{0x627=>0x625,},0x93C=>{0x928=>0x929,0x930=>0x931,0x933=>0x934,},0x9BE=>{0x9C7=>0x9CB,},0x9D7=>{0x9C7=>0x9CC,},0xB3E=>{0xB47=>0xB4B,},0xB56=>{0xB47=>0xB48,},0xB57=>{0xB47=>0xB4C,},0xBBE=>{0xBC6=>0xBCA,0xBC7=>0xBCB,},0xBD7=>{0xB92=>0xB94,0xBC6=>0xBCC,},0xC56=>{0xC46=>0xC48,},0xCC2=>{0xCC6=>0xCCA,},0xCD5=>{0xCBF=>0xCC0,0xCC6=>0xCC7,0xCCA=>0xCCB,},0xCD6=>{0xCC6=>0xCC8,},0xD3E=>{0xD46=>0xD4A,0xD47=>0xD4B,},0xD57=>{0xD46=>0xD4C,},0xDCA=>{0xDD9=>0xDDA,0xDDC=>0xDDD,},0xDCF=>{0xDD9=>0xDDC,},0xDDF=>{0xDD9=>0xDDE,},0x102E=>{0x1025=>0x1026,},0x1B35=>{0x1B05=>0x1B06,0x1B07=>0x1B08,0x1B09=>0x1B0A,0x1B0B=>0x1B0C,0x1B0D=>0x1B0E,0x1B11=>0x1B12,0x1B3A=>0x1B3B,0x1B3C=>0x1B3D,0x1B3E=>0x1B40,0x1B3F=>0x1B41,0x1B42=>0x1B43,},0x3099=>{0x3046=>0x3094,0x304B=>0x304C,0x304D=>0x304E,0x304F=>0x3050,0x3051=>0x3052,0x3053=>0x3054,0x3055=>0x3056,0x3057=>0x3058,0x3059=>0x305A,0x305B=>0x305C,0x305D=>0x305E,0x305F=>0x3060,0x3061=>0x3062,0x3064=>0x3065,0x3066=>0x3067,0x3068=>0x3069,0x306F=>0x3070,0x3072=>0x3073,0x3075=>0x3076,0x3078=>0x3079,0x307B=>0x307C,0x309D=>0x309E,0x30A6=>0x30F4,0x30AB=>0x30AC,0x30AD=>0x30AE,0x30AF=>0x30B0,0x30B1=>0x30B2,0x30B3=>0x30B4,0x30B5=>0x30B6,0x30B7=>0x30B8,0x30B9=>0x30BA,0x30BB=>0x30BC,0x30BD=>0x30BE,0x30BF=>0x30C0,0x30C1=>0x30C2,0x30C4=>0x30C5,0x30C6=>0x30C7,0x30C8=>0x30C9,0x30CF=>0x30D0,0x30D2=>0x30D3,0x30D5=>0x30D6,0x30D8=>0x30D9,0x30DB=>0x30DC,0x30EF=>0x30F7,0x30F0=>0x30F8,0x30F1=>0x30F9,0x30F2=>0x30FA,0x30FD=>0x30FE,},0x309A=>{0x306F=>0x3071,0x3072=>0x3074,0x3075=>0x3077,0x3078=>0x307A,0x307B=>0x307D,0x30CF=>0x30D1,0x30D2=>0x30D4,0x30D5=>0x30D7,0x30D8=>0x30DA,0x30DB=>0x30DD,},0x110BA=>{0x11099=>0x1109A,0x1109B=>0x1109C,0x110A5=>0x110AB,},);
my %_dec = ( 0xC0=>[0x41,0x300], 0xC1=>[0x41,0x301], 0xC2=>[0x41,0x302], 0xC3=>[0x41,0x303], 0xC4=>[0x41,0x308], 0xC5=>[0x41,0x30A], 0xC7=>[0x43,0x327], 0xC8=>[0x45,0x300], 0xC9=>[0x45,0x301], 0xCA=>[0x45,0x302], 0xCB=>[0x45,0x308], 0xCC=>[0x49,0x300], 0xCD=>[0x49,0x301], 0xCE=>[0x49,0x302], 0xCF=>[0x49,0x308], 0xD1=>[0x4E,0x303], 0xD2=>[0x4F,0x300], 0xD3=>[0x4F,0x301], 0xD4=>[0x4F,0x302], 0xD5=>[0x4F,0x303], 0xD6=>[0x4F,0x308], 0xD9=>[0x55,0x300], 0xDA=>[0x55,0x301], 0xDB=>[0x55,0x302], 0xDC=>[0x55,0x308], 0xDD=>[0x59,0x301], 0xE0=>[0x61,0x300], 0xE1=>[0x61,0x301], 0xE2=>[0x61,0x302], 0xE3=>[0x61,0x303], 0xE4=>[0x61,0x308], 0xE5=>[0x61,0x30A], 0xE7=>[0x63,0x327], 0xE8=>[0x65,0x300], 0xE9=>[0x65,0x301], 0xEA=>[0x65,0x302], 0xEB=>[0x65,0x308], 0xEC=>[0x69,0x300], 0xED=>[0x69,0x301], 0xEE=>[0x69,0x302], 0xEF=>[0x69,0x308], 0xF1=>[0x6E,0x303], 0xF2=>[0x6F,0x300], 0xF3=>[0x6F,0x301], 0xF4=>[0x6F,0x302], 0xF5=>[0x6F,0x303], 0xF6=>[0x6F,0x308], 0xF9=>[0x75,0x300], 0xFA=>[0x75,0x301], 0xFB=>[0x75,0x302], 0xFC=>[0x75,0x308], 0xFD=>[0x79,0x301], 0xFF=>[0x79,0x308], 0x100=>[0x41,0x304], 0x101=>[0x61,0x304], 0x102=>[0x41,0x306], 0x103=>[0x61,0x306], 0x104=>[0x41,0x328], 0x105=>[0x61,0x328], 0x106=>[0x43,0x301], 0x107=>[0x63,0x301], 0x108=>[0x43,0x302], 0x109=>[0x63,0x302], 0x10A=>[0x43,0x307], 0x10B=>[0x63,0x307], 0x10C=>[0x43,0x30C], 0x10D=>[0x63,0x30C], 0x10E=>[0x44,0x30C], 0x10F=>[0x64,0x30C], 0x112=>[0x45,0x304], 0x113=>[0x65,0x304], 0x114=>[0x45,0x306], 0x115=>[0x65,0x306], 0x116=>[0x45,0x307], 0x117=>[0x65,0x307], 0x118=>[0x45,0x328], 0x119=>[0x65,0x328], 0x11A=>[0x45,0x30C], 0x11B=>[0x65,0x30C], 0x11C=>[0x47,0x302], 0x11D=>[0x67,0x302], 0x11E=>[0x47,0x306], 0x11F=>[0x67,0x306], 0x120=>[0x47,0x307], 0x121=>[0x67,0x307], 0x122=>[0x47,0x327], 0x123=>[0x67,0x327], 0x124=>[0x48,0x302], 0x125=>[0x68,0x302], 0x128=>[0x49,0x303], 0x129=>[0x69,0x303], 0x12A=>[0x49,0x304], 0x12B=>[0x69,0x304], 0x12C=>[0x49,0x306], 0x12D=>[0x69,0x306], 0x12E=>[0x49,0x328], 0x12F=>[0x69,0x328], 0x130=>[0x49,0x307], 0x134=>[0x4A,0x302], 0x135=>[0x6A,0x302], 0x136=>[0x4B,0x327], 0x137=>[0x6B,0x327], 0x139=>[0x4C,0x301], 0x13A=>[0x6C,0x301], 0x13B=>[0x4C,0x327], 0x13C=>[0x6C,0x327], 0x13D=>[0x4C,0x30C], 0x13E=>[0x6C,0x30C], 0x143=>[0x4E,0x301], 0x144=>[0x6E,0x301], 0x145=>[0x4E,0x327], 0x146=>[0x6E,0x327], 0x147=>[0x4E,0x30C], 0x148=>[0x6E,0x30C], 0x14C=>[0x4F,0x304], 0x14D=>[0x6F,0x304], 0x14E=>[0x4F,0x306], 0x14F=>[0x6F,0x306], 0x150=>[0x4F,0x30B], 0x151=>[0x6F,0x30B], 0x154=>[0x52,0x301], 0x155=>[0x72,0x301], 0x156=>[0x52,0x327], 0x157=>[0x72,0x327], 0x158=>[0x52,0x30C], 0x159=>[0x72,0x30C], 0x15A=>[0x53,0x301], 0x15B=>[0x73,0x301], 0x15C=>[0x53,0x302], 0x15D=>[0x73,0x302], 0x15E=>[0x53,0x327], 0x15F=>[0x73,0x327], 0x160=>[0x53,0x30C], 0x161=>[0x73,0x30C], 0x162=>[0x54,0x327], 0x163=>[0x74,0x327], 0x164=>[0x54,0x30C], 0x165=>[0x74,0x30C], 0x168=>[0x55,0x303], 0x169=>[0x75,0x303], 0x16A=>[0x55,0x304], 0x16B=>[0x75,0x304], 0x16C=>[0x55,0x306], 0x16D=>[0x75,0x306], 0x16E=>[0x55,0x30A], 0x16F=>[0x75,0x30A], 0x170=>[0x55,0x30B], 0x171=>[0x75,0x30B], 0x172=>[0x55,0x328], 0x173=>[0x75,0x328], 0x174=>[0x57,0x302], 0x175=>[0x77,0x302], 0x176=>[0x59,0x302], 0x177=>[0x79,0x302], 0x178=>[0x59,0x308], 0x179=>[0x5A,0x301], 0x17A=>[0x7A,0x301], 0x17B=>[0x5A,0x307], 0x17C=>[0x7A,0x307], 0x17D=>[0x5A,0x30C], 0x17E=>[0x7A,0x30C], 0x1A0=>[0x4F,0x31B], 0x1A1=>[0x6F,0x31B], 0x1AF=>[0x55,0x31B], 0x1B0=>[0x75,0x31B], 0x1CD=>[0x41,0x30C], 0x1CE=>[0x61,0x30C], 0x1CF=>[0x49,0x30C], 0x1D0=>[0x69,0x30C], 0x1D1=>[0x4F,0x30C], 0x1D2=>[0x6F,0x30C], 0x1D3=>[0x55,0x30C], 0x1D4=>[0x75,0x30C], 0x1D5=>[0x55,0x308,0x304], 0x1D6=>[0x75,0x308,0x304], 0x1D7=>[0x55,0x308,0x301], 0x1D8=>[0x75,0x308,0x301], 0x1D9=>[0x55,0x308,0x30C], 0x1DA=>[0x75,0x308,0x30C], 0x1DB=>[0x55,0x308,0x300], 0x1DC=>[0x75,0x308,0x300], 0x1DE=>[0x41,0x308,0x304], 0x1DF=>[0x61,0x308,0x304], 0x1E0=>[0x41,0x307,0x304], 0x1E1=>[0x61,0x307,0x304], 0x1E2=>[0xC6,0x304], 0x1E3=>[0xE6,0x304], 0x1E6=>[0x47,0x30C], 0x1E7=>[0x67,0x30C], 0x1E8=>[0x4B,0x30C], 0x1E9=>[0x6B,0x30C], 0x1EA=>[0x4F,0x328], 0x1EB=>[0x6F,0x328], 0x1EC=>[0x4F,0x328,0x304], 0x1ED=>[0x6F,0x328,0x304], 0x1EE=>[0x1B7,0x30C], 0x1EF=>[0x292,0x30C], 0x1F0=>[0x6A,0x30C], 0x1F4=>[0x47,0x301], 0x1F5=>[0x67,0x301], 0x1F8=>[0x4E,0x300], 0x1F9=>[0x6E,0x300], 0x1FA=>[0x41,0x30A,0x301], 0x1FB=>[0x61,0x30A,0x301], 0x1FC=>[0xC6,0x301], 0x1FD=>[0xE6,0x301], 0x1FE=>[0xD8,0x301], 0x1FF=>[0xF8,0x301], 0x200=>[0x41,0x30F], 0x201=>[0x61,0x30F], 0x202=>[0x41,0x311], 0x203=>[0x61,0x311], 0x204=>[0x45,0x30F], 0x205=>[0x65,0x30F], 0x206=>[0x45,0x311], 0x207=>[0x65,0x311], 0x208=>[0x49,0x30F], 0x209=>[0x69,0x30F], 0x20A=>[0x49,0x311], 0x20B=>[0x69,0x311], 0x20C=>[0x4F,0x30F], 0x20D=>[0x6F,0x30F], 0x20E=>[0x4F,0x311], 0x20F=>[0x6F,0x311], 0x210=>[0x52,0x30F], 0x211=>[0x72,0x30F], 0x212=>[0x52,0x311], 0x213=>[0x72,0x311], 0x214=>[0x55,0x30F], 0x215=>[0x75,0x30F], 0x216=>[0x55,0x311], 0x217=>[0x75,0x311], 0x218=>[0x53,0x326], 0x219=>[0x73,0x326], 0x21A=>[0x54,0x326], 0x21B=>[0x74,0x326], 0x21E=>[0x48,0x30C], 0x21F=>[0x68,0x30C], 0x226=>[0x41,0x307], 0x227=>[0x61,0x307], 0x228=>[0x45,0x327], 0x229=>[0x65,0x327], 0x22A=>[0x4F,0x308,0x304], 0x22B=>[0x6F,0x308,0x304], 0x22C=>[0x4F,0x303,0x304], 0x22D=>[0x6F,0x303,0x304], 0x22E=>[0x4F,0x307], 0x22F=>[0x6F,0x307], 0x230=>[0x4F,0x307,0x304], 0x231=>[0x6F,0x307,0x304], 0x232=>[0x59,0x304], 0x233=>[0x79,0x304], 0x340=>[0x300], 0x341=>[0x301], 0x343=>[0x313], 0x344=>[0x308,0x301], 0x374=>[0x2B9], 0x37E=>[0x3B], 0x385=>[0xA8,0x301], 0x386=>[0x391,0x301], 0x387=>[0xB7], 0x388=>[0x395,0x301], 0x389=>[0x397,0x301], 0x38A=>[0x399,0x301], 0x38C=>[0x39F,0x301], 0x38E=>[0x3A5,0x301], 0x38F=>[0x3A9,0x301], 0x390=>[0x3B9,0x308,0x301], 0x3AA=>[0x399,0x308], 0x3AB=>[0x3A5,0x308], 0x3AC=>[0x3B1,0x301], 0x3AD=>[0x3B5,0x301], 0x3AE=>[0x3B7,0x301], 0x3AF=>[0x3B9,0x301], 0x3B0=>[0x3C5,0x308,0x301], 0x3CA=>[0x3B9,0x308], 0x3CB=>[0x3C5,0x308], 0x3CC=>[0x3BF,0x301], 0x3CD=>[0x3C5,0x301], 0x3CE=>[0x3C9,0x301], 0x3D3=>[0x3D2,0x301], 0x3D4=>[0x3D2,0x308], 0x400=>[0x415,0x300], 0x401=>[0x415,0x308], 0x403=>[0x413,0x301], 0x407=>[0x406,0x308], 0x40C=>[0x41A,0x301], 0x40D=>[0x418,0x300], 0x40E=>[0x423,0x306], 0x419=>[0x418,0x306], 0x439=>[0x438,0x306], 0x450=>[0x435,0x300], 0x451=>[0x435,0x308], 0x453=>[0x433,0x301], 0x457=>[0x456,0x308], 0x45C=>[0x43A,0x301], 0x45D=>[0x438,0x300], 0x45E=>[0x443,0x306], 0x476=>[0x474,0x30F], 0x477=>[0x475,0x30F], 0x4C1=>[0x416,0x306], 0x4C2=>[0x436,0x306], 0x4D0=>[0x410,0x306], 0x4D1=>[0x430,0x306], 0x4D2=>[0x410,0x308], 0x4D3=>[0x430,0x308], 0x4D6=>[0x415,0x306], 0x4D7=>[0x435,0x306], 0x4DA=>[0x4D8,0x308], 0x4DB=>[0x4D9,0x308], 0x4DC=>[0x416,0x308], 0x4DD=>[0x436,0x308], 0x4DE=>[0x417,0x308], 0x4DF=>[0x437,0x308], 0x4E2=>[0x418,0x304], 0x4E3=>[0x438,0x304], 0x4E4=>[0x418,0x308], 0x4E5=>[0x438,0x308], 0x4E6=>[0x41E,0x308], 0x4E7=>[0x43E,0x308], 0x4EA=>[0x4E8,0x308], 0x4EB=>[0x4E9,0x308], 0x4EC=>[0x42D,0x308], 0x4ED=>[0x44D,0x308], 0x4EE=>[0x423,0x304], 0x4EF=>[0x443,0x304], 0x4F0=>[0x423,0x308], 0x4F1=>[0x443,0x308], 0x4F2=>[0x423,0x30B], 0x4F3=>[0x443,0x30B], 0x4F4=>[0x427,0x308], 0x4F5=>[0x447,0x308], 0x4F8=>[0x42B,0x308], 0x4F9=>[0x44B,0x308], 0x622=>[0x627,0x653], 0x623=>[0x627,0x654], 0x624=>[0x648,0x654], 0x625=>[0x627,0x655], 0x626=>[0x64A,0x654], 0x6C0=>[0x6D5,0x654], 0x6C2=>[0x6C1,0x654], 0x6D3=>[0x6D2,0x654], 0x929=>[0x928,0x93C], 0x931=>[0x930,0x93C], 0x934=>[0x933,0x93C], 0x958=>[0x915,0x93C], 0x959=>[0x916,0x93C], 0x95A=>[0x917,0x93C], 0x95B=>[0x91C,0x93C], 0x95C=>[0x921,0x93C], 0x95D=>[0x922,0x93C], 0x95E=>[0x92B,0x93C], 0x95F=>[0x92F,0x93C], 0x9CB=>[0x9C7,0x9BE], 0x9CC=>[0x9C7,0x9D7], 0x9DC=>[0x9A1,0x9BC], 0x9DD=>[0x9A2,0x9BC], 0x9DF=>[0x9AF,0x9BC], 0xA33=>[0xA32,0xA3C], 0xA36=>[0xA38,0xA3C], 0xA59=>[0xA16,0xA3C], 0xA5A=>[0xA17,0xA3C], 0xA5B=>[0xA1C,0xA3C], 0xA5E=>[0xA2B,0xA3C], 0xB48=>[0xB47,0xB56], 0xB4B=>[0xB47,0xB3E], 0xB4C=>[0xB47,0xB57], 0xB5C=>[0xB21,0xB3C], 0xB5D=>[0xB22,0xB3C], 0xB94=>[0xB92,0xBD7], 0xBCA=>[0xBC6,0xBBE], 0xBCB=>[0xBC7,0xBBE], 0xBCC=>[0xBC6,0xBD7], 0xC48=>[0xC46,0xC56], 0xCC0=>[0xCBF,0xCD5], 0xCC7=>[0xCC6,0xCD5], 0xCC8=>[0xCC6,0xCD6], 0xCCA=>[0xCC6,0xCC2], 0xCCB=>[0xCC6,0xCC2,0xCD5], 0xD4A=>[0xD46,0xD3E], 0xD4B=>[0xD47,0xD3E], 0xD4C=>[0xD46,0xD57], 0xDDA=>[0xDD9,0xDCA], 0xDDC=>[0xDD9,0xDCF], 0xDDD=>[0xDD9,0xDCF,0xDCA], 0xDDE=>[0xDD9,0xDDF], 0xF43=>[0xF42,0xFB7], 0xF4D=>[0xF4C,0xFB7], 0xF52=>[0xF51,0xFB7], 0xF57=>[0xF56,0xFB7], 0xF5C=>[0xF5B,0xFB7], 0xF69=>[0xF40,0xFB5], 0xF73=>[0xF71,0xF72], 0xF75=>[0xF71,0xF74], 0xF76=>[0xFB2,0xF80], 0xF78=>[0xFB3,0xF80], 0xF81=>[0xF71,0xF80], 0xF93=>[0xF92,0xFB7], 0xF9D=>[0xF9C,0xFB7], 0xFA2=>[0xFA1,0xFB7], 0xFA7=>[0xFA6,0xFB7], 0xFAC=>[0xFAB,0xFB7], 0xFB9=>[0xF90,0xFB5], 0x1026=>[0x1025,0x102E], 0x1B06=>[0x1B05,0x1B35], 0x1B08=>[0x1B07,0x1B35], 0x1B0A=>[0x1B09,0x1B35], 0x1B0C=>[0x1B0B,0x1B35], 0x1B0E=>[0x1B0D,0x1B35], 0x1B12=>[0x1B11,0x1B35], 0x1B3B=>[0x1B3A,0x1B35], 0x1B3D=>[0x1B3C,0x1B35], 0x1B40=>[0x1B3E,0x1B35], 0x1B41=>[0x1B3F,0x1B35], 0x1B43=>[0x1B42,0x1B35], 0x1E00=>[0x41,0x325], 0x1E01=>[0x61,0x325], 0x1E02=>[0x42,0x307], 0x1E03=>[0x62,0x307], 0x1E04=>[0x42,0x323], 0x1E05=>[0x62,0x323], 0x1E06=>[0x42,0x331], 0x1E07=>[0x62,0x331], 0x1E08=>[0x43,0x327,0x301], 0x1E09=>[0x63,0x327,0x301], 0x1E0A=>[0x44,0x307], 0x1E0B=>[0x64,0x307], 0x1E0C=>[0x44,0x323], 0x1E0D=>[0x64,0x323], 0x1E0E=>[0x44,0x331], 0x1E0F=>[0x64,0x331], 0x1E10=>[0x44,0x327], 0x1E11=>[0x64,0x327], 0x1E12=>[0x44,0x32D], 0x1E13=>[0x64,0x32D], 0x1E14=>[0x45,0x304,0x300], 0x1E15=>[0x65,0x304,0x300], 0x1E16=>[0x45,0x304,0x301], 0x1E17=>[0x65,0x304,0x301], 0x1E18=>[0x45,0x32D], 0x1E19=>[0x65,0x32D], 0x1E1A=>[0x45,0x330], 0x1E1B=>[0x65,0x330], 0x1E1C=>[0x45,0x327,0x306], 0x1E1D=>[0x65,0x327,0x306], 0x1E1E=>[0x46,0x307], 0x1E1F=>[0x66,0x307], 0x1E20=>[0x47,0x304], 0x1E21=>[0x67,0x304], 0x1E22=>[0x48,0x307], 0x1E23=>[0x68,0x307], 0x1E24=>[0x48,0x323], 0x1E25=>[0x68,0x323], 0x1E26=>[0x48,0x308], 0x1E27=>[0x68,0x308], 0x1E28=>[0x48,0x327], 0x1E29=>[0x68,0x327], 0x1E2A=>[0x48,0x32E], 0x1E2B=>[0x68,0x32E], 0x1E2C=>[0x49,0x330], 0x1E2D=>[0x69,0x330], 0x1E2E=>[0x49,0x308,0x301], 0x1E2F=>[0x69,0x308,0x301], 0x1E30=>[0x4B,0x301], 0x1E31=>[0x6B,0x301], 0x1E32=>[0x4B,0x323], 0x1E33=>[0x6B,0x323], 0x1E34=>[0x4B,0x331], 0x1E35=>[0x6B,0x331], 0x1E36=>[0x4C,0x323], 0x1E37=>[0x6C,0x323], 0x1E38=>[0x4C,0x323,0x304], 0x1E39=>[0x6C,0x323,0x304], 0x1E3A=>[0x4C,0x331], 0x1E3B=>[0x6C,0x331], 0x1E3C=>[0x4C,0x32D], 0x1E3D=>[0x6C,0x32D], 0x1E3E=>[0x4D,0x301], 0x1E3F=>[0x6D,0x301], 0x1E40=>[0x4D,0x307], 0x1E41=>[0x6D,0x307], 0x1E42=>[0x4D,0x323], 0x1E43=>[0x6D,0x323], 0x1E44=>[0x4E,0x307], 0x1E45=>[0x6E,0x307], 0x1E46=>[0x4E,0x323], 0x1E47=>[0x6E,0x323], 0x1E48=>[0x4E,0x331], 0x1E49=>[0x6E,0x331], 0x1E4A=>[0x4E,0x32D], 0x1E4B=>[0x6E,0x32D], 0x1E4C=>[0x4F,0x303,0x301], 0x1E4D=>[0x6F,0x303,0x301], 0x1E4E=>[0x4F,0x303,0x308], 0x1E4F=>[0x6F,0x303,0x308], 0x1E50=>[0x4F,0x304,0x300], 0x1E51=>[0x6F,0x304,0x300], 0x1E52=>[0x4F,0x304,0x301], 0x1E53=>[0x6F,0x304,0x301], 0x1E54=>[0x50,0x301], 0x1E55=>[0x70,0x301], 0x1E56=>[0x50,0x307], 0x1E57=>[0x70,0x307], 0x1E58=>[0x52,0x307], 0x1E59=>[0x72,0x307], 0x1E5A=>[0x52,0x323], 0x1E5B=>[0x72,0x323], 0x1E5C=>[0x52,0x323,0x304], 0x1E5D=>[0x72,0x323,0x304], 0x1E5E=>[0x52,0x331], 0x1E5F=>[0x72,0x331], 0x1E60=>[0x53,0x307], 0x1E61=>[0x73,0x307], 0x1E62=>[0x53,0x323], 0x1E63=>[0x73,0x323], 0x1E64=>[0x53,0x301,0x307], 0x1E65=>[0x73,0x301,0x307], 0x1E66=>[0x53,0x30C,0x307], 0x1E67=>[0x73,0x30C,0x307], 0x1E68=>[0x53,0x323,0x307], 0x1E69=>[0x73,0x323,0x307], 0x1E6A=>[0x54,0x307], 0x1E6B=>[0x74,0x307], 0x1E6C=>[0x54,0x323], 0x1E6D=>[0x74,0x323], 0x1E6E=>[0x54,0x331], 0x1E6F=>[0x74,0x331], 0x1E70=>[0x54,0x32D], 0x1E71=>[0x74,0x32D], 0x1E72=>[0x55,0x324], 0x1E73=>[0x75,0x324], 0x1E74=>[0x55,0x330], 0x1E75=>[0x75,0x330], 0x1E76=>[0x55,0x32D], 0x1E77=>[0x75,0x32D], 0x1E78=>[0x55,0x303,0x301], 0x1E79=>[0x75,0x303,0x301], 0x1E7A=>[0x55,0x304,0x308], 0x1E7B=>[0x75,0x304,0x308], 0x1E7C=>[0x56,0x303], 0x1E7D=>[0x76,0x303], 0x1E7E=>[0x56,0x323], 0x1E7F=>[0x76,0x323], 0x1E80=>[0x57,0x300], 0x1E81=>[0x77,0x300], 0x1E82=>[0x57,0x301], 0x1E83=>[0x77,0x301], 0x1E84=>[0x57,0x308], 0x1E85=>[0x77,0x308], 0x1E86=>[0x57,0x307], 0x1E87=>[0x77,0x307], 0x1E88=>[0x57,0x323], 0x1E89=>[0x77,0x323], 0x1E8A=>[0x58,0x307], 0x1E8B=>[0x78,0x307], 0x1E8C=>[0x58,0x308], 0x1E8D=>[0x78,0x308], 0x1E8E=>[0x59,0x307], 0x1E8F=>[0x79,0x307], 0x1E90=>[0x5A,0x302], 0x1E91=>[0x7A,0x302], 0x1E92=>[0x5A,0x323], 0x1E93=>[0x7A,0x323], 0x1E94=>[0x5A,0x331], 0x1E95=>[0x7A,0x331], 0x1E96=>[0x68,0x331], 0x1E97=>[0x74,0x308], 0x1E98=>[0x77,0x30A], 0x1E99=>[0x79,0x30A], 0x1E9B=>[0x17F,0x307], 0x1EA0=>[0x41,0x323], 0x1EA1=>[0x61,0x323], 0x1EA2=>[0x41,0x309], 0x1EA3=>[0x61,0x309], 0x1EA4=>[0x41,0x302,0x301], 0x1EA5=>[0x61,0x302,0x301], 0x1EA6=>[0x41,0x302,0x300], 0x1EA7=>[0x61,0x302,0x300], 0x1EA8=>[0x41,0x302,0x309], 0x1EA9=>[0x61,0x302,0x309], 0x1EAA=>[0x41,0x302,0x303], 0x1EAB=>[0x61,0x302,0x303], 0x1EAC=>[0x41,0x323,0x302], 0x1EAD=>[0x61,0x323,0x302], 0x1EAE=>[0x41,0x306,0x301], 0x1EAF=>[0x61,0x306,0x301], 0x1EB0=>[0x41,0x306,0x300], 0x1EB1=>[0x61,0x306,0x300], 0x1EB2=>[0x41,0x306,0x309], 0x1EB3=>[0x61,0x306,0x309], 0x1EB4=>[0x41,0x306,0x303], 0x1EB5=>[0x61,0x306,0x303], 0x1EB6=>[0x41,0x323,0x306], 0x1EB7=>[0x61,0x323,0x306], 0x1EB8=>[0x45,0x323], 0x1EB9=>[0x65,0x323], 0x1EBA=>[0x45,0x309], 0x1EBB=>[0x65,0x309], 0x1EBC=>[0x45,0x303], 0x1EBD=>[0x65,0x303], 0x1EBE=>[0x45,0x302,0x301], 0x1EBF=>[0x65,0x302,0x301], 0x1EC0=>[0x45,0x302,0x300], 0x1EC1=>[0x65,0x302,0x300], 0x1EC2=>[0x45,0x302,0x309], 0x1EC3=>[0x65,0x302,0x309], 0x1EC4=>[0x45,0x302,0x303], 0x1EC5=>[0x65,0x302,0x303], 0x1EC6=>[0x45,0x323,0x302], 0x1EC7=>[0x65,0x323,0x302], 0x1EC8=>[0x49,0x309], 0x1EC9=>[0x69,0x309], 0x1ECA=>[0x49,0x323], 0x1ECB=>[0x69,0x323], 0x1ECC=>[0x4F,0x323], 0x1ECD=>[0x6F,0x323], 0x1ECE=>[0x4F,0x309], 0x1ECF=>[0x6F,0x309], 0x1ED0=>[0x4F,0x302,0x301], 0x1ED1=>[0x6F,0x302,0x301], 0x1ED2=>[0x4F,0x302,0x300], 0x1ED3=>[0x6F,0x302,0x300], 0x1ED4=>[0x4F,0x302,0x309], 0x1ED5=>[0x6F,0x302,0x309], 0x1ED6=>[0x4F,0x302,0x303], 0x1ED7=>[0x6F,0x302,0x303], 0x1ED8=>[0x4F,0x323,0x302], 0x1ED9=>[0x6F,0x323,0x302], 0x1EDA=>[0x4F,0x31B,0x301], 0x1EDB=>[0x6F,0x31B,0x301], 0x1EDC=>[0x4F,0x31B,0x300], 0x1EDD=>[0x6F,0x31B,0x300], 0x1EDE=>[0x4F,0x31B,0x309], 0x1EDF=>[0x6F,0x31B,0x309], 0x1EE0=>[0x4F,0x31B,0x303], 0x1EE1=>[0x6F,0x31B,0x303], 0x1EE2=>[0x4F,0x31B,0x323], 0x1EE3=>[0x6F,0x31B,0x323], 0x1EE4=>[0x55,0x323], 0x1EE5=>[0x75,0x323], 0x1EE6=>[0x55,0x309], 0x1EE7=>[0x75,0x309], 0x1EE8=>[0x55,0x31B,0x301], 0x1EE9=>[0x75,0x31B,0x301], 0x1EEA=>[0x55,0x31B,0x300], 0x1EEB=>[0x75,0x31B,0x300], 0x1EEC=>[0x55,0x31B,0x309], 0x1EED=>[0x75,0x31B,0x309], 0x1EEE=>[0x55,0x31B,0x303], 0x1EEF=>[0x75,0x31B,0x303], 0x1EF0=>[0x55,0x31B,0x323], 0x1EF1=>[0x75,0x31B,0x323], 0x1EF2=>[0x59,0x300], 0x1EF3=>[0x79,0x300], 0x1EF4=>[0x59,0x323], 0x1EF5=>[0x79,0x323], 0x1EF6=>[0x59,0x309], 0x1EF7=>[0x79,0x309], 0x1EF8=>[0x59,0x303], 0x1EF9=>[0x79,0x303], 0x1F00=>[0x3B1,0x313], 0x1F01=>[0x3B1,0x314], 0x1F02=>[0x3B1,0x313,0x300], 0x1F03=>[0x3B1,0x314,0x300], 0x1F04=>[0x3B1,0x313,0x301], 0x1F05=>[0x3B1,0x314,0x301], 0x1F06=>[0x3B1,0x313,0x342], 0x1F07=>[0x3B1,0x314,0x342], 0x1F08=>[0x391,0x313], 0x1F09=>[0x391,0x314], 0x1F0A=>[0x391,0x313,0x300], 0x1F0B=>[0x391,0x314,0x300], 0x1F0C=>[0x391,0x313,0x301], 0x1F0D=>[0x391,0x314,0x301], 0x1F0E=>[0x391,0x313,0x342], 0x1F0F=>[0x391,0x314,0x342], 0x1F10=>[0x3B5,0x313], 0x1F11=>[0x3B5,0x314], 0x1F12=>[0x3B5,0x313,0x300], 0x1F13=>[0x3B5,0x314,0x300], 0x1F14=>[0x3B5,0x313,0x301], 0x1F15=>[0x3B5,0x314,0x301], 0x1F18=>[0x395,0x313], 0x1F19=>[0x395,0x314], 0x1F1A=>[0x395,0x313,0x300], 0x1F1B=>[0x395,0x314,0x300], 0x1F1C=>[0x395,0x313,0x301], 0x1F1D=>[0x395,0x314,0x301], 0x1F20=>[0x3B7,0x313], 0x1F21=>[0x3B7,0x314], 0x1F22=>[0x3B7,0x313,0x300], 0x1F23=>[0x3B7,0x314,0x300], 0x1F24=>[0x3B7,0x313,0x301], 0x1F25=>[0x3B7,0x314,0x301], 0x1F26=>[0x3B7,0x313,0x342], 0x1F27=>[0x3B7,0x314,0x342], 0x1F28=>[0x397,0x313], 0x1F29=>[0x397,0x314], 0x1F2A=>[0x397,0x313,0x300], 0x1F2B=>[0x397,0x314,0x300], 0x1F2C=>[0x397,0x313,0x301], 0x1F2D=>[0x397,0x314,0x301], 0x1F2E=>[0x397,0x313,0x342], 0x1F2F=>[0x397,0x314,0x342], 0x1F30=>[0x3B9,0x313], 0x1F31=>[0x3B9,0x314], 0x1F32=>[0x3B9,0x313,0x300], 0x1F33=>[0x3B9,0x314,0x300], 0x1F34=>[0x3B9,0x313,0x301], 0x1F35=>[0x3B9,0x314,0x301], 0x1F36=>[0x3B9,0x313,0x342], 0x1F37=>[0x3B9,0x314,0x342], 0x1F38=>[0x399,0x313], 0x1F39=>[0x399,0x314], 0x1F3A=>[0x399,0x313,0x300], 0x1F3B=>[0x399,0x314,0x300], 0x1F3C=>[0x399,0x313,0x301], 0x1F3D=>[0x399,0x314,0x301], 0x1F3E=>[0x399,0x313,0x342], 0x1F3F=>[0x399,0x314,0x342], 0x1F40=>[0x3BF,0x313], 0x1F41=>[0x3BF,0x314], 0x1F42=>[0x3BF,0x313,0x300], 0x1F43=>[0x3BF,0x314,0x300], 0x1F44=>[0x3BF,0x313,0x301], 0x1F45=>[0x3BF,0x314,0x301], 0x1F48=>[0x39F,0x313], 0x1F49=>[0x39F,0x314], 0x1F4A=>[0x39F,0x313,0x300], 0x1F4B=>[0x39F,0x314,0x300], 0x1F4C=>[0x39F,0x313,0x301], 0x1F4D=>[0x39F,0x314,0x301], 0x1F50=>[0x3C5,0x313], 0x1F51=>[0x3C5,0x314], 0x1F52=>[0x3C5,0x313,0x300], 0x1F53=>[0x3C5,0x314,0x300], 0x1F54=>[0x3C5,0x313,0x301], 0x1F55=>[0x3C5,0x314,0x301], 0x1F56=>[0x3C5,0x313,0x342], 0x1F57=>[0x3C5,0x314,0x342], 0x1F59=>[0x3A5,0x314], 0x1F5B=>[0x3A5,0x314,0x300], 0x1F5D=>[0x3A5,0x314,0x301], 0x1F5F=>[0x3A5,0x314,0x342], 0x1F60=>[0x3C9,0x313], 0x1F61=>[0x3C9,0x314], 0x1F62=>[0x3C9,0x313,0x300], 0x1F63=>[0x3C9,0x314,0x300], 0x1F64=>[0x3C9,0x313,0x301], 0x1F65=>[0x3C9,0x314,0x301], 0x1F66=>[0x3C9,0x313,0x342], 0x1F67=>[0x3C9,0x314,0x342], 0x1F68=>[0x3A9,0x313], 0x1F69=>[0x3A9,0x314], 0x1F6A=>[0x3A9,0x313,0x300], 0x1F6B=>[0x3A9,0x314,0x300], 0x1F6C=>[0x3A9,0x313,0x301], 0x1F6D=>[0x3A9,0x314,0x301], 0x1F6E=>[0x3A9,0x313,0x342], 0x1F6F=>[0x3A9,0x314,0x342], 0x1F70=>[0x3B1,0x300], 0x1F71=>[0x3B1,0x301], 0x1F72=>[0x3B5,0x300], 0x1F73=>[0x3B5,0x301], 0x1F74=>[0x3B7,0x300], 0x1F75=>[0x3B7,0x301], 0x1F76=>[0x3B9,0x300], 0x1F77=>[0x3B9,0x301], 0x1F78=>[0x3BF,0x300], 0x1F79=>[0x3BF,0x301], 0x1F7A=>[0x3C5,0x300], 0x1F7B=>[0x3C5,0x301], 0x1F7C=>[0x3C9,0x300], 0x1F7D=>[0x3C9,0x301], 0x1F80=>[0x3B1,0x313,0x345], 0x1F81=>[0x3B1,0x314,0x345], 0x1F82=>[0x3B1,0x313,0x300,0x345], 0x1F83=>[0x3B1,0x314,0x300,0x345], 0x1F84=>[0x3B1,0x313,0x301,0x345], 0x1F85=>[0x3B1,0x314,0x301,0x345], 0x1F86=>[0x3B1,0x313,0x342,0x345], 0x1F87=>[0x3B1,0x314,0x342,0x345], 0x1F88=>[0x391,0x313,0x345], 0x1F89=>[0x391,0x314,0x345], 0x1F8A=>[0x391,0x313,0x300,0x345], 0x1F8B=>[0x391,0x314,0x300,0x345], 0x1F8C=>[0x391,0x313,0x301,0x345], 0x1F8D=>[0x391,0x314,0x301,0x345], 0x1F8E=>[0x391,0x313,0x342,0x345], 0x1F8F=>[0x391,0x314,0x342,0x345], 0x1F90=>[0x3B7,0x313,0x345], 0x1F91=>[0x3B7,0x314,0x345], 0x1F92=>[0x3B7,0x313,0x300,0x345], 0x1F93=>[0x3B7,0x314,0x300,0x345], 0x1F94=>[0x3B7,0x313,0x301,0x345], 0x1F95=>[0x3B7,0x314,0x301,0x345], 0x1F96=>[0x3B7,0x313,0x342,0x345], 0x1F97=>[0x3B7,0x314,0x342,0x345], 0x1F98=>[0x397,0x313,0x345], 0x1F99=>[0x397,0x314,0x345], 0x1F9A=>[0x397,0x313,0x300,0x345], 0x1F9B=>[0x397,0x314,0x300,0x345], 0x1F9C=>[0x397,0x313,0x301,0x345], 0x1F9D=>[0x397,0x314,0x301,0x345], 0x1F9E=>[0x397,0x313,0x342,0x345], 0x1F9F=>[0x397,0x314,0x342,0x345], 0x1FA0=>[0x3C9,0x313,0x345], 0x1FA1=>[0x3C9,0x314,0x345], 0x1FA2=>[0x3C9,0x313,0x300,0x345], 0x1FA3=>[0x3C9,0x314,0x300,0x345], 0x1FA4=>[0x3C9,0x313,0x301,0x345], 0x1FA5=>[0x3C9,0x314,0x301,0x345], 0x1FA6=>[0x3C9,0x313,0x342,0x345], 0x1FA7=>[0x3C9,0x314,0x342,0x345], 0x1FA8=>[0x3A9,0x313,0x345], 0x1FA9=>[0x3A9,0x314,0x345], 0x1FAA=>[0x3A9,0x313,0x300,0x345], 0x1FAB=>[0x3A9,0x314,0x300,0x345], 0x1FAC=>[0x3A9,0x313,0x301,0x345], 0x1FAD=>[0x3A9,0x314,0x301,0x345], 0x1FAE=>[0x3A9,0x313,0x342,0x345], 0x1FAF=>[0x3A9,0x314,0x342,0x345], 0x1FB0=>[0x3B1,0x306], 0x1FB1=>[0x3B1,0x304], 0x1FB2=>[0x3B1,0x300,0x345], 0x1FB3=>[0x3B1,0x345], 0x1FB4=>[0x3B1,0x301,0x345], 0x1FB6=>[0x3B1,0x342], 0x1FB7=>[0x3B1,0x342,0x345], 0x1FB8=>[0x391,0x306], 0x1FB9=>[0x391,0x304], 0x1FBA=>[0x391,0x300], 0x1FBB=>[0x391,0x301], 0x1FBC=>[0x391,0x345], 0x1FBE=>[0x3B9], 0x1FC1=>[0xA8,0x342], 0x1FC2=>[0x3B7,0x300,0x345], 0x1FC3=>[0x3B7,0x345], 0x1FC4=>[0x3B7,0x301,0x345], 0x1FC6=>[0x3B7,0x342], 0x1FC7=>[0x3B7,0x342,0x345], 0x1FC8=>[0x395,0x300], 0x1FC9=>[0x395,0x301], 0x1FCA=>[0x397,0x300], 0x1FCB=>[0x397,0x301], 0x1FCC=>[0x397,0x345], 0x1FCD=>[0x1FBF,0x300], 0x1FCE=>[0x1FBF,0x301], 0x1FCF=>[0x1FBF,0x342], 0x1FD0=>[0x3B9,0x306], 0x1FD1=>[0x3B9,0x304], 0x1FD2=>[0x3B9,0x308,0x300], 0x1FD3=>[0x3B9,0x308,0x301], 0x1FD6=>[0x3B9,0x342], 0x1FD7=>[0x3B9,0x308,0x342], 0x1FD8=>[0x399,0x306], 0x1FD9=>[0x399,0x304], 0x1FDA=>[0x399,0x300], 0x1FDB=>[0x399,0x301], 0x1FDD=>[0x1FFE,0x300], 0x1FDE=>[0x1FFE,0x301], 0x1FDF=>[0x1FFE,0x342], 0x1FE0=>[0x3C5,0x306], 0x1FE1=>[0x3C5,0x304], 0x1FE2=>[0x3C5,0x308,0x300], 0x1FE3=>[0x3C5,0x308,0x301], 0x1FE4=>[0x3C1,0x313], 0x1FE5=>[0x3C1,0x314], 0x1FE6=>[0x3C5,0x342], 0x1FE7=>[0x3C5,0x308,0x342], 0x1FE8=>[0x3A5,0x306], 0x1FE9=>[0x3A5,0x304], 0x1FEA=>[0x3A5,0x300], 0x1FEB=>[0x3A5,0x301], 0x1FEC=>[0x3A1,0x314], 0x1FED=>[0xA8,0x300], 0x1FEE=>[0xA8,0x301], 0x1FEF=>[0x60], 0x1FF2=>[0x3C9,0x300,0x345], 0x1FF3=>[0x3C9,0x345], 0x1FF4=>[0x3C9,0x301,0x345], 0x1FF6=>[0x3C9,0x342], 0x1FF7=>[0x3C9,0x342,0x345], 0x1FF8=>[0x39F,0x300], 0x1FF9=>[0x39F,0x301], 0x1FFA=>[0x3A9,0x300], 0x1FFB=>[0x3A9,0x301], 0x1FFC=>[0x3A9,0x345], 0x1FFD=>[0xB4], 0x2000=>[0x2002], 0x2001=>[0x2003], 0x2126=>[0x3A9], 0x212A=>[0x4B], 0x212B=>[0x41,0x30A], 0x219A=>[0x2190,0x338], 0x219B=>[0x2192,0x338], 0x21AE=>[0x2194,0x338], 0x21CD=>[0x21D0,0x338], 0x21CE=>[0x21D4,0x338], 0x21CF=>[0x21D2,0x338], 0x2204=>[0x2203,0x338], 0x2209=>[0x2208,0x338], 0x220C=>[0x220B,0x338], 0x2224=>[0x2223,0x338], 0x2226=>[0x2225,0x338], 0x2241=>[0x223C,0x338], 0x2244=>[0x2243,0x338], 0x2247=>[0x2245,0x338], 0x2249=>[0x2248,0x338], 0x2260=>[0x3D,0x338], 0x2262=>[0x2261,0x338], 0x226D=>[0x224D,0x338], 0x226E=>[0x3C,0x338], 0x226F=>[0x3E,0x338], 0x2270=>[0x2264,0x338], 0x2271=>[0x2265,0x338], 0x2274=>[0x2272,0x338], 0x2275=>[0x2273,0x338], 0x2278=>[0x2276,0x338], 0x2279=>[0x2277,0x338], 0x2280=>[0x227A,0x338], 0x2281=>[0x227B,0x338], 0x2284=>[0x2282,0x338], 0x2285=>[0x2283,0x338], 0x2288=>[0x2286,0x338], 0x2289=>[0x2287,0x338], 0x22AC=>[0x22A2,0x338], 0x22AD=>[0x22A8,0x338], 0x22AE=>[0x22A9,0x338], 0x22AF=>[0x22AB,0x338], 0x22E0=>[0x227C,0x338], 0x22E1=>[0x227D,0x338], 0x22E2=>[0x2291,0x338], 0x22E3=>[0x2292,0x338], 0x22EA=>[0x22B2,0x338], 0x22EB=>[0x22B3,0x338], 0x22EC=>[0x22B4,0x338], 0x22ED=>[0x22B5,0x338], 0x2329=>[0x3008], 0x232A=>[0x3009], 0x2ADC=>[0x2ADD,0x338], 0x304C=>[0x304B,0x3099], 0x304E=>[0x304D,0x3099], 0x3050=>[0x304F,0x3099], 0x3052=>[0x3051,0x3099], 0x3054=>[0x3053,0x3099], 0x3056=>[0x3055,0x3099], 0x3058=>[0x3057,0x3099], 0x305A=>[0x3059,0x3099], 0x305C=>[0x305B,0x3099], 0x305E=>[0x305D,0x3099], 0x3060=>[0x305F,0x3099], 0x3062=>[0x3061,0x3099], 0x3065=>[0x3064,0x3099], 0x3067=>[0x3066,0x3099], 0x3069=>[0x3068,0x3099], 0x3070=>[0x306F,0x3099], 0x3071=>[0x306F,0x309A], 0x3073=>[0x3072,0x3099], 0x3074=>[0x3072,0x309A], 0x3076=>[0x3075,0x3099], 0x3077=>[0x3075,0x309A], 0x3079=>[0x3078,0x3099], 0x307A=>[0x3078,0x309A], 0x307C=>[0x307B,0x3099], 0x307D=>[0x307B,0x309A], 0x3094=>[0x3046,0x3099], 0x309E=>[0x309D,0x3099], 0x30AC=>[0x30AB,0x3099], 0x30AE=>[0x30AD,0x3099], 0x30B0=>[0x30AF,0x3099], 0x30B2=>[0x30B1,0x3099], 0x30B4=>[0x30B3,0x3099], 0x30B6=>[0x30B5,0x3099], 0x30B8=>[0x30B7,0x3099], 0x30BA=>[0x30B9,0x3099], 0x30BC=>[0x30BB,0x3099], 0x30BE=>[0x30BD,0x3099], 0x30C0=>[0x30BF,0x3099], 0x30C2=>[0x30C1,0x3099], 0x30C5=>[0x30C4,0x3099], 0x30C7=>[0x30C6,0x3099], 0x30C9=>[0x30C8,0x3099], 0x30D0=>[0x30CF,0x3099], 0x30D1=>[0x30CF,0x309A], 0x30D3=>[0x30D2,0x3099], 0x30D4=>[0x30D2,0x309A], 0x30D6=>[0x30D5,0x3099], 0x30D7=>[0x30D5,0x309A], 0x30D9=>[0x30D8,0x3099], 0x30DA=>[0x30D8,0x309A], 0x30DC=>[0x30DB,0x3099], 0x30DD=>[0x30DB,0x309A], 0x30F4=>[0x30A6,0x3099], 0x30F7=>[0x30EF,0x3099], 0x30F8=>[0x30F0,0x3099], 0x30F9=>[0x30F1,0x3099], 0x30FA=>[0x30F2,0x3099], 0x30FE=>[0x30FD,0x3099], 0xF900=>[0x8C48], 0xF901=>[0x66F4], 0xF902=>[0x8ECA], 0xF903=>[0x8CC8], 0xF904=>[0x6ED1], 0xF905=>[0x4E32], 0xF906=>[0x53E5], 0xF907=>[0x9F9C], 0xF908=>[0x9F9C], 0xF909=>[0x5951], 0xF90A=>[0x91D1], 0xF90B=>[0x5587], 0xF90C=>[0x5948], 0xF90D=>[0x61F6], 0xF90E=>[0x7669], 0xF90F=>[0x7F85], 0xF910=>[0x863F], 0xF911=>[0x87BA], 0xF912=>[0x88F8], 0xF913=>[0x908F], 0xF914=>[0x6A02], 0xF915=>[0x6D1B], 0xF916=>[0x70D9], 0xF917=>[0x73DE], 0xF918=>[0x843D], 0xF919=>[0x916A], 0xF91A=>[0x99F1], 0xF91B=>[0x4E82], 0xF91C=>[0x5375], 0xF91D=>[0x6B04], 0xF91E=>[0x721B], 0xF91F=>[0x862D], 0xF920=>[0x9E1E], 0xF921=>[0x5D50], 0xF922=>[0x6FEB], 0xF923=>[0x85CD], 0xF924=>[0x8964], 0xF925=>[0x62C9], 0xF926=>[0x81D8], 0xF927=>[0x881F], 0xF928=>[0x5ECA], 0xF929=>[0x6717], 0xF92A=>[0x6D6A], 0xF92B=>[0x72FC], 0xF92C=>[0x90CE], 0xF92D=>[0x4F86], 0xF92E=>[0x51B7], 0xF92F=>[0x52DE], 0xF930=>[0x64C4], 0xF931=>[0x6AD3], 0xF932=>[0x7210], 0xF933=>[0x76E7], 0xF934=>[0x8001], 0xF935=>[0x8606], 0xF936=>[0x865C], 0xF937=>[0x8DEF], 0xF938=>[0x9732], 0xF939=>[0x9B6F], 0xF93A=>[0x9DFA], 0xF93B=>[0x788C], 0xF93C=>[0x797F], 0xF93D=>[0x7DA0], 0xF93E=>[0x83C9], 0xF93F=>[0x9304], 0xF940=>[0x9E7F], 0xF941=>[0x8AD6], 0xF942=>[0x58DF], 0xF943=>[0x5F04], 0xF944=>[0x7C60], 0xF945=>[0x807E], 0xF946=>[0x7262], 0xF947=>[0x78CA], 0xF948=>[0x8CC2], 0xF949=>[0x96F7], 0xF94A=>[0x58D8], 0xF94B=>[0x5C62], 0xF94C=>[0x6A13], 0xF94D=>[0x6DDA], 0xF94E=>[0x6F0F], 0xF94F=>[0x7D2F], 0xF950=>[0x7E37], 0xF951=>[0x964B], 0xF952=>[0x52D2], 0xF953=>[0x808B], 0xF954=>[0x51DC], 0xF955=>[0x51CC], 0xF956=>[0x7A1C], 0xF957=>[0x7DBE], 0xF958=>[0x83F1], 0xF959=>[0x9675], 0xF95A=>[0x8B80], 0xF95B=>[0x62CF], 0xF95C=>[0x6A02], 0xF95D=>[0x8AFE], 0xF95E=>[0x4E39], 0xF95F=>[0x5BE7], 0xF960=>[0x6012], 0xF961=>[0x7387], 0xF962=>[0x7570], 0xF963=>[0x5317], 0xF964=>[0x78FB], 0xF965=>[0x4FBF], 0xF966=>[0x5FA9], 0xF967=>[0x4E0D], 0xF968=>[0x6CCC], 0xF969=>[0x6578], 0xF96A=>[0x7D22], 0xF96B=>[0x53C3], 0xF96C=>[0x585E], 0xF96D=>[0x7701], 0xF96E=>[0x8449], 0xF96F=>[0x8AAA], 0xF970=>[0x6BBA], 0xF971=>[0x8FB0], 0xF972=>[0x6C88], 0xF973=>[0x62FE], 0xF974=>[0x82E5], 0xF975=>[0x63A0], 0xF976=>[0x7565], 0xF977=>[0x4EAE], 0xF978=>[0x5169], 0xF979=>[0x51C9], 0xF97A=>[0x6881], 0xF97B=>[0x7CE7], 0xF97C=>[0x826F], 0xF97D=>[0x8AD2], 0xF97E=>[0x91CF], 0xF97F=>[0x52F5], 0xF980=>[0x5442], 0xF981=>[0x5973], 0xF982=>[0x5EEC], 0xF983=>[0x65C5], 0xF984=>[0x6FFE], 0xF985=>[0x792A], 0xF986=>[0x95AD], 0xF987=>[0x9A6A], 0xF988=>[0x9E97], 0xF989=>[0x9ECE], 0xF98A=>[0x529B], 0xF98B=>[0x66C6], 0xF98C=>[0x6B77], 0xF98D=>[0x8F62], 0xF98E=>[0x5E74], 0xF98F=>[0x6190], 0xF990=>[0x6200], 0xF991=>[0x649A], 0xF992=>[0x6F23], 0xF993=>[0x7149], 0xF994=>[0x7489], 0xF995=>[0x79CA], 0xF996=>[0x7DF4], 0xF997=>[0x806F], 0xF998=>[0x8F26], 0xF999=>[0x84EE], 0xF99A=>[0x9023], 0xF99B=>[0x934A], 0xF99C=>[0x5217], 0xF99D=>[0x52A3], 0xF99E=>[0x54BD], 0xF99F=>[0x70C8], 0xF9A0=>[0x88C2], 0xF9A1=>[0x8AAA], 0xF9A2=>[0x5EC9], 0xF9A3=>[0x5FF5], 0xF9A4=>[0x637B], 0xF9A5=>[0x6BAE], 0xF9A6=>[0x7C3E], 0xF9A7=>[0x7375], 0xF9A8=>[0x4EE4], 0xF9A9=>[0x56F9], 0xF9AA=>[0x5BE7], 0xF9AB=>[0x5DBA], 0xF9AC=>[0x601C], 0xF9AD=>[0x73B2], 0xF9AE=>[0x7469], 0xF9AF=>[0x7F9A], 0xF9B0=>[0x8046], 0xF9B1=>[0x9234], 0xF9B2=>[0x96F6], 0xF9B3=>[0x9748], 0xF9B4=>[0x9818], 0xF9B5=>[0x4F8B], 0xF9B6=>[0x79AE], 0xF9B7=>[0x91B4], 0xF9B8=>[0x96B8], 0xF9B9=>[0x60E1], 0xF9BA=>[0x4E86], 0xF9BB=>[0x50DA], 0xF9BC=>[0x5BEE], 0xF9BD=>[0x5C3F], 0xF9BE=>[0x6599], 0xF9BF=>[0x6A02], 0xF9C0=>[0x71CE], 0xF9C1=>[0x7642], 0xF9C2=>[0x84FC], 0xF9C3=>[0x907C], 0xF9C4=>[0x9F8D], 0xF9C5=>[0x6688], 0xF9C6=>[0x962E], 0xF9C7=>[0x5289], 0xF9C8=>[0x677B], 0xF9C9=>[0x67F3], 0xF9CA=>[0x6D41], 0xF9CB=>[0x6E9C], 0xF9CC=>[0x7409], 0xF9CD=>[0x7559], 0xF9CE=>[0x786B], 0xF9CF=>[0x7D10], 0xF9D0=>[0x985E], 0xF9D1=>[0x516D], 0xF9D2=>[0x622E], 0xF9D3=>[0x9678], 0xF9D4=>[0x502B], 0xF9D5=>[0x5D19], 0xF9D6=>[0x6DEA], 0xF9D7=>[0x8F2A], 0xF9D8=>[0x5F8B], 0xF9D9=>[0x6144], 0xF9DA=>[0x6817], 0xF9DB=>[0x7387], 0xF9DC=>[0x9686], 0xF9DD=>[0x5229], 0xF9DE=>[0x540F], 0xF9DF=>[0x5C65], 0xF9E0=>[0x6613], 0xF9E1=>[0x674E], 0xF9E2=>[0x68A8], 0xF9E3=>[0x6CE5], 0xF9E4=>[0x7406], 0xF9E5=>[0x75E2], 0xF9E6=>[0x7F79], 0xF9E7=>[0x88CF], 0xF9E8=>[0x88E1], 0xF9E9=>[0x91CC], 0xF9EA=>[0x96E2], 0xF9EB=>[0x533F], 0xF9EC=>[0x6EBA], 0xF9ED=>[0x541D], 0xF9EE=>[0x71D0], 0xF9EF=>[0x7498], 0xF9F0=>[0x85FA], 0xF9F1=>[0x96A3], 0xF9F2=>[0x9C57], 0xF9F3=>[0x9E9F], 0xF9F4=>[0x6797], 0xF9F5=>[0x6DCB], 0xF9F6=>[0x81E8], 0xF9F7=>[0x7ACB], 0xF9F8=>[0x7B20], 0xF9F9=>[0x7C92], 0xF9FA=>[0x72C0], 0xF9FB=>[0x7099], 0xF9FC=>[0x8B58], 0xF9FD=>[0x4EC0], 0xF9FE=>[0x8336], 0xF9FF=>[0x523A], 0xFA00=>[0x5207], 0xFA01=>[0x5EA6], 0xFA02=>[0x62D3], 0xFA03=>[0x7CD6], 0xFA04=>[0x5B85], 0xFA05=>[0x6D1E], 0xFA06=>[0x66B4], 0xFA07=>[0x8F3B], 0xFA08=>[0x884C], 0xFA09=>[0x964D], 0xFA0A=>[0x898B], 0xFA0B=>[0x5ED3], 0xFA0C=>[0x5140], 0xFA0D=>[0x55C0], 0xFA10=>[0x585A], 0xFA12=>[0x6674], 0xFA15=>[0x51DE], 0xFA16=>[0x732A], 0xFA17=>[0x76CA], 0xFA18=>[0x793C], 0xFA19=>[0x795E], 0xFA1A=>[0x7965], 0xFA1B=>[0x798F], 0xFA1C=>[0x9756], 0xFA1D=>[0x7CBE], 0xFA1E=>[0x7FBD], 0xFA20=>[0x8612], 0xFA22=>[0x8AF8], 0xFA25=>[0x9038], 0xFA26=>[0x90FD], 0xFA2A=>[0x98EF], 0xFA2B=>[0x98FC], 0xFA2C=>[0x9928], 0xFA2D=>[0x9DB4], 0xFA30=>[0x4FAE], 0xFA31=>[0x50E7], 0xFA32=>[0x514D], 0xFA33=>[0x52C9], 0xFA34=>[0x52E4], 0xFA35=>[0x5351], 0xFA36=>[0x559D], 0xFA37=>[0x5606], 0xFA38=>[0x5668], 0xFA39=>[0x5840], 0xFA3A=>[0x58A8], 0xFA3B=>[0x5C64], 0xFA3C=>[0x5C6E], 0xFA3D=>[0x6094], 0xFA3E=>[0x6168], 0xFA3F=>[0x618E], 0xFA40=>[0x61F2], 0xFA41=>[0x654F], 0xFA42=>[0x65E2], 0xFA43=>[0x6691], 0xFA44=>[0x6885], 0xFA45=>[0x6D77], 0xFA46=>[0x6E1A], 0xFA47=>[0x6F22], 0xFA48=>[0x716E], 0xFA49=>[0x722B], 0xFA4A=>[0x7422], 0xFA4B=>[0x7891], 0xFA4C=>[0x793E], 0xFA4D=>[0x7949], 0xFA4E=>[0x7948], 0xFA4F=>[0x7950], 0xFA50=>[0x7956], 0xFA51=>[0x795D], 0xFA52=>[0x798D], 0xFA53=>[0x798E], 0xFA54=>[0x7A40], 0xFA55=>[0x7A81], 0xFA56=>[0x7BC0], 0xFA57=>[0x7DF4], 0xFA58=>[0x7E09], 0xFA59=>[0x7E41], 0xFA5A=>[0x7F72], 0xFA5B=>[0x8005], 0xFA5C=>[0x81ED], 0xFA5D=>[0x8279], 0xFA5E=>[0x8279], 0xFA5F=>[0x8457], 0xFA60=>[0x8910], 0xFA61=>[0x8996], 0xFA62=>[0x8B01], 0xFA63=>[0x8B39], 0xFA64=>[0x8CD3], 0xFA65=>[0x8D08], 0xFA66=>[0x8FB6], 0xFA67=>[0x9038], 0xFA68=>[0x96E3], 0xFA69=>[0x97FF], 0xFA6A=>[0x983B], 0xFA6B=>[0x6075], 0xFA6C=>[0x242EE], 0xFA6D=>[0x8218], 0xFA70=>[0x4E26], 0xFA71=>[0x51B5], 0xFA72=>[0x5168], 0xFA73=>[0x4F80], 0xFA74=>[0x5145], 0xFA75=>[0x5180], 0xFA76=>[0x52C7], 0xFA77=>[0x52FA], 0xFA78=>[0x559D], 0xFA79=>[0x5555], 0xFA7A=>[0x5599], 0xFA7B=>[0x55E2], 0xFA7C=>[0x585A], 0xFA7D=>[0x58B3], 0xFA7E=>[0x5944], 0xFA7F=>[0x5954], 0xFA80=>[0x5A62], 0xFA81=>[0x5B28], 0xFA82=>[0x5ED2], 0xFA83=>[0x5ED9], 0xFA84=>[0x5F69], 0xFA85=>[0x5FAD], 0xFA86=>[0x60D8], 0xFA87=>[0x614E], 0xFA88=>[0x6108], 0xFA89=>[0x618E], 0xFA8A=>[0x6160], 0xFA8B=>[0x61F2], 0xFA8C=>[0x6234], 0xFA8D=>[0x63C4], 0xFA8E=>[0x641C], 0xFA8F=>[0x6452], 0xFA90=>[0x6556], 0xFA91=>[0x6674], 0xFA92=>[0x6717], 0xFA93=>[0x671B], 0xFA94=>[0x6756], 0xFA95=>[0x6B79], 0xFA96=>[0x6BBA], 0xFA97=>[0x6D41], 0xFA98=>[0x6EDB], 0xFA99=>[0x6ECB], 0xFA9A=>[0x6F22], 0xFA9B=>[0x701E], 0xFA9C=>[0x716E], 0xFA9D=>[0x77A7], 0xFA9E=>[0x7235], 0xFA9F=>[0x72AF], 0xFAA0=>[0x732A], 0xFAA1=>[0x7471], 0xFAA2=>[0x7506], 0xFAA3=>[0x753B], 0xFAA4=>[0x761D], 0xFAA5=>[0x761F], 0xFAA6=>[0x76CA], 0xFAA7=>[0x76DB], 0xFAA8=>[0x76F4], 0xFAA9=>[0x774A], 0xFAAA=>[0x7740], 0xFAAB=>[0x78CC], 0xFAAC=>[0x7AB1], 0xFAAD=>[0x7BC0], 0xFAAE=>[0x7C7B], 0xFAAF=>[0x7D5B], 0xFAB0=>[0x7DF4], 0xFAB1=>[0x7F3E], 0xFAB2=>[0x8005], 0xFAB3=>[0x8352], 0xFAB4=>[0x83EF], 0xFAB5=>[0x8779], 0xFAB6=>[0x8941], 0xFAB7=>[0x8986], 0xFAB8=>[0x8996], 0xFAB9=>[0x8ABF], 0xFABA=>[0x8AF8], 0xFABB=>[0x8ACB], 0xFABC=>[0x8B01], 0xFABD=>[0x8AFE], 0xFABE=>[0x8AED], 0xFABF=>[0x8B39], 0xFAC0=>[0x8B8A], 0xFAC1=>[0x8D08], 0xFAC2=>[0x8F38], 0xFAC3=>[0x9072], 0xFAC4=>[0x9199], 0xFAC5=>[0x9276], 0xFAC6=>[0x967C], 0xFAC7=>[0x96E3], 0xFAC8=>[0x9756], 0xFAC9=>[0x97DB], 0xFACA=>[0x97FF], 0xFACB=>[0x980B], 0xFACC=>[0x983B], 0xFACD=>[0x9B12], 0xFACE=>[0x9F9C], 0xFACF=>[0x2284A], 0xFAD0=>[0x22844], 0xFAD1=>[0x233D5], 0xFAD2=>[0x3B9D], 0xFAD3=>[0x4018], 0xFAD4=>[0x4039], 0xFAD5=>[0x25249], 0xFAD6=>[0x25CD0], 0xFAD7=>[0x27ED3], 0xFAD8=>[0x9F43], 0xFAD9=>[0x9F8E], 0xFB1D=>[0x5D9,0x5B4], 0xFB1F=>[0x5F2,0x5B7], 0xFB2A=>[0x5E9,0x5C1], 0xFB2B=>[0x5E9,0x5C2], 0xFB2C=>[0x5E9,0x5BC,0x5C1], 0xFB2D=>[0x5E9,0x5BC,0x5C2], 0xFB2E=>[0x5D0,0x5B7], 0xFB2F=>[0x5D0,0x5B8], 0xFB30=>[0x5D0,0x5BC], 0xFB31=>[0x5D1,0x5BC], 0xFB32=>[0x5D2,0x5BC], 0xFB33=>[0x5D3,0x5BC], 0xFB34=>[0x5D4,0x5BC], 0xFB35=>[0x5D5,0x5BC], 0xFB36=>[0x5D6,0x5BC], 0xFB38=>[0x5D8,0x5BC], 0xFB39=>[0x5D9,0x5BC], 0xFB3A=>[0x5DA,0x5BC], 0xFB3B=>[0x5DB,0x5BC], 0xFB3C=>[0x5DC,0x5BC], 0xFB3E=>[0x5DE,0x5BC], 0xFB40=>[0x5E0,0x5BC], 0xFB41=>[0x5E1,0x5BC], 0xFB43=>[0x5E3,0x5BC], 0xFB44=>[0x5E4,0x5BC], 0xFB46=>[0x5E6,0x5BC], 0xFB47=>[0x5E7,0x5BC], 0xFB48=>[0x5E8,0x5BC], 0xFB49=>[0x5E9,0x5BC], 0xFB4A=>[0x5EA,0x5BC], 0xFB4B=>[0x5D5,0x5B9], 0xFB4C=>[0x5D1,0x5BF], 0xFB4D=>[0x5DB,0x5BF], 0xFB4E=>[0x5E4,0x5BF], 0x1109A=>[0x11099,0x110BA], 0x1109C=>[0x1109B,0x110BA], 0x110AB=>[0x110A5,0x110BA], 0x1D15E=>[0x1D157,0x1D165], 0x1D15F=>[0x1D158,0x1D165], 0x1D160=>[0x1D158,0x1D165,0x1D16E], 0x1D161=>[0x1D158,0x1D165,0x1D16F], 0x1D162=>[0x1D158,0x1D165,0x1D170], 0x1D163=>[0x1D158,0x1D165,0x1D171], 0x1D164=>[0x1D158,0x1D165,0x1D172], 0x1D1BB=>[0x1D1B9,0x1D165], 0x1D1BC=>[0x1D1BA,0x1D165], 0x1D1BD=>[0x1D1B9,0x1D165,0x1D16E], 0x1D1BE=>[0x1D1BA,0x1D165,0x1D16E], 0x1D1BF=>[0x1D1B9,0x1D165,0x1D16F], 0x1D1C0=>[0x1D1BA,0x1D165,0x1D16F], 0x2F800=>[0x4E3D], 0x2F801=>[0x4E38], 0x2F802=>[0x4E41], 0x2F803=>[0x20122], 0x2F804=>[0x4F60], 0x2F805=>[0x4FAE], 0x2F806=>[0x4FBB], 0x2F807=>[0x5002], 0x2F808=>[0x507A], 0x2F809=>[0x5099], 0x2F80A=>[0x50E7], 0x2F80B=>[0x50CF], 0x2F80C=>[0x349E], 0x2F80D=>[0x2063A], 0x2F80E=>[0x514D], 0x2F80F=>[0x5154], 0x2F810=>[0x5164], 0x2F811=>[0x5177], 0x2F812=>[0x2051C], 0x2F813=>[0x34B9], 0x2F814=>[0x5167], 0x2F815=>[0x518D], 0x2F816=>[0x2054B], 0x2F817=>[0x5197], 0x2F818=>[0x51A4], 0x2F819=>[0x4ECC], 0x2F81A=>[0x51AC], 0x2F81B=>[0x51B5], 0x2F81C=>[0x291DF], 0x2F81D=>[0x51F5], 0x2F81E=>[0x5203], 0x2F81F=>[0x34DF], 0x2F820=>[0x523B], 0x2F821=>[0x5246], 0x2F822=>[0x5272], 0x2F823=>[0x5277], 0x2F824=>[0x3515], 0x2F825=>[0x52C7], 0x2F826=>[0x52C9], 0x2F827=>[0x52E4], 0x2F828=>[0x52FA], 0x2F829=>[0x5305], 0x2F82A=>[0x5306], 0x2F82B=>[0x5317], 0x2F82C=>[0x5349], 0x2F82D=>[0x5351], 0x2F82E=>[0x535A], 0x2F82F=>[0x5373], 0x2F830=>[0x537D], 0x2F831=>[0x537F], 0x2F832=>[0x537F], 0x2F833=>[0x537F], 0x2F834=>[0x20A2C], 0x2F835=>[0x7070], 0x2F836=>[0x53CA], 0x2F837=>[0x53DF], 0x2F838=>[0x20B63], 0x2F839=>[0x53EB], 0x2F83A=>[0x53F1], 0x2F83B=>[0x5406], 0x2F83C=>[0x549E], 0x2F83D=>[0x5438], 0x2F83E=>[0x5448], 0x2F83F=>[0x5468], 0x2F840=>[0x54A2], 0x2F841=>[0x54F6], 0x2F842=>[0x5510], 0x2F843=>[0x5553], 0x2F844=>[0x5563], 0x2F845=>[0x5584], 0x2F846=>[0x5584], 0x2F847=>[0x5599], 0x2F848=>[0x55AB], 0x2F849=>[0x55B3], 0x2F84A=>[0x55C2], 0x2F84B=>[0x5716], 0x2F84C=>[0x5606], 0x2F84D=>[0x5717], 0x2F84E=>[0x5651], 0x2F84F=>[0x5674], 0x2F850=>[0x5207], 0x2F851=>[0x58EE], 0x2F852=>[0x57CE], 0x2F853=>[0x57F4], 0x2F854=>[0x580D], 0x2F855=>[0x578B], 0x2F856=>[0x5832], 0x2F857=>[0x5831], 0x2F858=>[0x58AC], 0x2F859=>[0x214E4], 0x2F85A=>[0x58F2], 0x2F85B=>[0x58F7], 0x2F85C=>[0x5906], 0x2F85D=>[0x591A], 0x2F85E=>[0x5922], 0x2F85F=>[0x5962], 0x2F860=>[0x216A8], 0x2F861=>[0x216EA], 0x2F862=>[0x59EC], 0x2F863=>[0x5A1B], 0x2F864=>[0x5A27], 0x2F865=>[0x59D8], 0x2F866=>[0x5A66], 0x2F867=>[0x36EE], 0x2F868=>[0x36FC], 0x2F869=>[0x5B08], 0x2F86A=>[0x5B3E], 0x2F86B=>[0x5B3E], 0x2F86C=>[0x219C8], 0x2F86D=>[0x5BC3], 0x2F86E=>[0x5BD8], 0x2F86F=>[0x5BE7], 0x2F870=>[0x5BF3], 0x2F871=>[0x21B18], 0x2F872=>[0x5BFF], 0x2F873=>[0x5C06], 0x2F874=>[0x5F53], 0x2F875=>[0x5C22], 0x2F876=>[0x3781], 0x2F877=>[0x5C60], 0x2F878=>[0x5C6E], 0x2F879=>[0x5CC0], 0x2F87A=>[0x5C8D], 0x2F87B=>[0x21DE4], 0x2F87C=>[0x5D43], 0x2F87D=>[0x21DE6], 0x2F87E=>[0x5D6E], 0x2F87F=>[0x5D6B], 0x2F880=>[0x5D7C], 0x2F881=>[0x5DE1], 0x2F882=>[0x5DE2], 0x2F883=>[0x382F], 0x2F884=>[0x5DFD], 0x2F885=>[0x5E28], 0x2F886=>[0x5E3D], 0x2F887=>[0x5E69], 0x2F888=>[0x3862], 0x2F889=>[0x22183], 0x2F88A=>[0x387C], 0x2F88B=>[0x5EB0], 0x2F88C=>[0x5EB3], 0x2F88D=>[0x5EB6], 0x2F88E=>[0x5ECA], 0x2F88F=>[0x2A392], 0x2F890=>[0x5EFE], 0x2F891=>[0x22331], 0x2F892=>[0x22331], 0x2F893=>[0x8201], 0x2F894=>[0x5F22], 0x2F895=>[0x5F22], 0x2F896=>[0x38C7], 0x2F897=>[0x232B8], 0x2F898=>[0x261DA], 0x2F899=>[0x5F62], 0x2F89A=>[0x5F6B], 0x2F89B=>[0x38E3], 0x2F89C=>[0x5F9A], 0x2F89D=>[0x5FCD], 0x2F89E=>[0x5FD7], 0x2F89F=>[0x5FF9], 0x2F8A0=>[0x6081], 0x2F8A1=>[0x393A], 0x2F8A2=>[0x391C], 0x2F8A3=>[0x6094], 0x2F8A4=>[0x226D4], 0x2F8A5=>[0x60C7], 0x2F8A6=>[0x6148], 0x2F8A7=>[0x614C], 0x2F8A8=>[0x614E], 0x2F8A9=>[0x614C], 0x2F8AA=>[0x617A], 0x2F8AB=>[0x618E], 0x2F8AC=>[0x61B2], 0x2F8AD=>[0x61A4], 0x2F8AE=>[0x61AF], 0x2F8AF=>[0x61DE], 0x2F8B0=>[0x61F2], 0x2F8B1=>[0x61F6], 0x2F8B2=>[0x6210], 0x2F8B3=>[0x621B], 0x2F8B4=>[0x625D], 0x2F8B5=>[0x62B1], 0x2F8B6=>[0x62D4], 0x2F8B7=>[0x6350], 0x2F8B8=>[0x22B0C], 0x2F8B9=>[0x633D], 0x2F8BA=>[0x62FC], 0x2F8BB=>[0x6368], 0x2F8BC=>[0x6383], 0x2F8BD=>[0x63E4], 0x2F8BE=>[0x22BF1], 0x2F8BF=>[0x6422], 0x2F8C0=>[0x63C5], 0x2F8C1=>[0x63A9], 0x2F8C2=>[0x3A2E], 0x2F8C3=>[0x6469], 0x2F8C4=>[0x647E], 0x2F8C5=>[0x649D], 0x2F8C6=>[0x6477], 0x2F8C7=>[0x3A6C], 0x2F8C8=>[0x654F], 0x2F8C9=>[0x656C], 0x2F8CA=>[0x2300A], 0x2F8CB=>[0x65E3], 0x2F8CC=>[0x66F8], 0x2F8CD=>[0x6649], 0x2F8CE=>[0x3B19], 0x2F8CF=>[0x6691], 0x2F8D0=>[0x3B08], 0x2F8D1=>[0x3AE4], 0x2F8D2=>[0x5192], 0x2F8D3=>[0x5195], 0x2F8D4=>[0x6700], 0x2F8D5=>[0x669C], 0x2F8D6=>[0x80AD], 0x2F8D7=>[0x43D9], 0x2F8D8=>[0x6717], 0x2F8D9=>[0x671B], 0x2F8DA=>[0x6721], 0x2F8DB=>[0x675E], 0x2F8DC=>[0x6753], 0x2F8DD=>[0x233C3], 0x2F8DE=>[0x3B49], 0x2F8DF=>[0x67FA], 0x2F8E0=>[0x6785], 0x2F8E1=>[0x6852], 0x2F8E2=>[0x6885], 0x2F8E3=>[0x2346D], 0x2F8E4=>[0x688E], 0x2F8E5=>[0x681F], 0x2F8E6=>[0x6914], 0x2F8E7=>[0x3B9D], 0x2F8E8=>[0x6942], 0x2F8E9=>[0x69A3], 0x2F8EA=>[0x69EA], 0x2F8EB=>[0x6AA8], 0x2F8EC=>[0x236A3], 0x2F8ED=>[0x6ADB], 0x2F8EE=>[0x3C18], 0x2F8EF=>[0x6B21], 0x2F8F0=>[0x238A7], 0x2F8F1=>[0x6B54], 0x2F8F2=>[0x3C4E], 0x2F8F3=>[0x6B72], 0x2F8F4=>[0x6B9F], 0x2F8F5=>[0x6BBA], 0x2F8F6=>[0x6BBB], 0x2F8F7=>[0x23A8D], 0x2F8F8=>[0x21D0B], 0x2F8F9=>[0x23AFA], 0x2F8FA=>[0x6C4E], 0x2F8FB=>[0x23CBC], 0x2F8FC=>[0x6CBF], 0x2F8FD=>[0x6CCD], 0x2F8FE=>[0x6C67], 0x2F8FF=>[0x6D16], 0x2F900=>[0x6D3E], 0x2F901=>[0x6D77], 0x2F902=>[0x6D41], 0x2F903=>[0x6D69], 0x2F904=>[0x6D78], 0x2F905=>[0x6D85], 0x2F906=>[0x23D1E], 0x2F907=>[0x6D34], 0x2F908=>[0x6E2F], 0x2F909=>[0x6E6E], 0x2F90A=>[0x3D33], 0x2F90B=>[0x6ECB], 0x2F90C=>[0x6EC7], 0x2F90D=>[0x23ED1], 0x2F90E=>[0x6DF9], 0x2F90F=>[0x6F6E], 0x2F910=>[0x23F5E], 0x2F911=>[0x23F8E], 0x2F912=>[0x6FC6], 0x2F913=>[0x7039], 0x2F914=>[0x701E], 0x2F915=>[0x701B], 0x2F916=>[0x3D96], 0x2F917=>[0x704A], 0x2F918=>[0x707D], 0x2F919=>[0x7077], 0x2F91A=>[0x70AD], 0x2F91B=>[0x20525], 0x2F91C=>[0x7145], 0x2F91D=>[0x24263], 0x2F91E=>[0x719C], 0x2F91F=>[0x243AB], 0x2F920=>[0x7228], 0x2F921=>[0x7235], 0x2F922=>[0x7250], 0x2F923=>[0x24608], 0x2F924=>[0x7280], 0x2F925=>[0x7295], 0x2F926=>[0x24735], 0x2F927=>[0x24814], 0x2F928=>[0x737A], 0x2F929=>[0x738B], 0x2F92A=>[0x3EAC], 0x2F92B=>[0x73A5], 0x2F92C=>[0x3EB8], 0x2F92D=>[0x3EB8], 0x2F92E=>[0x7447], 0x2F92F=>[0x745C], 0x2F930=>[0x7471], 0x2F931=>[0x7485], 0x2F932=>[0x74CA], 0x2F933=>[0x3F1B], 0x2F934=>[0x7524], 0x2F935=>[0x24C36], 0x2F936=>[0x753E], 0x2F937=>[0x24C92], 0x2F938=>[0x7570], 0x2F939=>[0x2219F], 0x2F93A=>[0x7610], 0x2F93B=>[0x24FA1], 0x2F93C=>[0x24FB8], 0x2F93D=>[0x25044], 0x2F93E=>[0x3FFC], 0x2F93F=>[0x4008], 0x2F940=>[0x76F4], 0x2F941=>[0x250F3], 0x2F942=>[0x250F2], 0x2F943=>[0x25119], 0x2F944=>[0x25133], 0x2F945=>[0x771E], 0x2F946=>[0x771F], 0x2F947=>[0x771F], 0x2F948=>[0x774A], 0x2F949=>[0x4039], 0x2F94A=>[0x778B], 0x2F94B=>[0x4046], 0x2F94C=>[0x4096], 0x2F94D=>[0x2541D], 0x2F94E=>[0x784E], 0x2F94F=>[0x788C], 0x2F950=>[0x78CC], 0x2F951=>[0x40E3], 0x2F952=>[0x25626], 0x2F953=>[0x7956], 0x2F954=>[0x2569A], 0x2F955=>[0x256C5], 0x2F956=>[0x798F], 0x2F957=>[0x79EB], 0x2F958=>[0x412F], 0x2F959=>[0x7A40], 0x2F95A=>[0x7A4A], 0x2F95B=>[0x7A4F], 0x2F95C=>[0x2597C], 0x2F95D=>[0x25AA7], 0x2F95E=>[0x25AA7], 0x2F95F=>[0x7AEE], 0x2F960=>[0x4202], 0x2F961=>[0x25BAB], 0x2F962=>[0x7BC6], 0x2F963=>[0x7BC9], 0x2F964=>[0x4227], 0x2F965=>[0x25C80], 0x2F966=>[0x7CD2], 0x2F967=>[0x42A0], 0x2F968=>[0x7CE8], 0x2F969=>[0x7CE3], 0x2F96A=>[0x7D00], 0x2F96B=>[0x25F86], 0x2F96C=>[0x7D63], 0x2F96D=>[0x4301], 0x2F96E=>[0x7DC7], 0x2F96F=>[0x7E02], 0x2F970=>[0x7E45], 0x2F971=>[0x4334], 0x2F972=>[0x26228], 0x2F973=>[0x26247], 0x2F974=>[0x4359], 0x2F975=>[0x262D9], 0x2F976=>[0x7F7A], 0x2F977=>[0x2633E], 0x2F978=>[0x7F95], 0x2F979=>[0x7FFA], 0x2F97A=>[0x8005], 0x2F97B=>[0x264DA], 0x2F97C=>[0x26523], 0x2F97D=>[0x8060], 0x2F97E=>[0x265A8], 0x2F97F=>[0x8070], 0x2F980=>[0x2335F], 0x2F981=>[0x43D5], 0x2F982=>[0x80B2], 0x2F983=>[0x8103], 0x2F984=>[0x440B], 0x2F985=>[0x813E], 0x2F986=>[0x5AB5], 0x2F987=>[0x267A7], 0x2F988=>[0x267B5], 0x2F989=>[0x23393], 0x2F98A=>[0x2339C], 0x2F98B=>[0x8201], 0x2F98C=>[0x8204], 0x2F98D=>[0x8F9E], 0x2F98E=>[0x446B], 0x2F98F=>[0x8291], 0x2F990=>[0x828B], 0x2F991=>[0x829D], 0x2F992=>[0x52B3], 0x2F993=>[0x82B1], 0x2F994=>[0x82B3], 0x2F995=>[0x82BD], 0x2F996=>[0x82E6], 0x2F997=>[0x26B3C], 0x2F998=>[0x82E5], 0x2F999=>[0x831D], 0x2F99A=>[0x8363], 0x2F99B=>[0x83AD], 0x2F99C=>[0x8323], 0x2F99D=>[0x83BD], 0x2F99E=>[0x83E7], 0x2F99F=>[0x8457], 0x2F9A0=>[0x8353], 0x2F9A1=>[0x83CA], 0x2F9A2=>[0x83CC], 0x2F9A3=>[0x83DC], 0x2F9A4=>[0x26C36], 0x2F9A5=>[0x26D6B], 0x2F9A6=>[0x26CD5], 0x2F9A7=>[0x452B], 0x2F9A8=>[0x84F1], 0x2F9A9=>[0x84F3], 0x2F9AA=>[0x8516], 0x2F9AB=>[0x273CA], 0x2F9AC=>[0x8564], 0x2F9AD=>[0x26F2C], 0x2F9AE=>[0x455D], 0x2F9AF=>[0x4561], 0x2F9B0=>[0x26FB1], 0x2F9B1=>[0x270D2], 0x2F9B2=>[0x456B], 0x2F9B3=>[0x8650], 0x2F9B4=>[0x865C], 0x2F9B5=>[0x8667], 0x2F9B6=>[0x8669], 0x2F9B7=>[0x86A9], 0x2F9B8=>[0x8688], 0x2F9B9=>[0x870E], 0x2F9BA=>[0x86E2], 0x2F9BB=>[0x8779], 0x2F9BC=>[0x8728], 0x2F9BD=>[0x876B], 0x2F9BE=>[0x8786], 0x2F9BF=>[0x45D7], 0x2F9C0=>[0x87E1], 0x2F9C1=>[0x8801], 0x2F9C2=>[0x45F9], 0x2F9C3=>[0x8860], 0x2F9C4=>[0x8863], 0x2F9C5=>[0x27667], 0x2F9C6=>[0x88D7], 0x2F9C7=>[0x88DE], 0x2F9C8=>[0x4635], 0x2F9C9=>[0x88FA], 0x2F9CA=>[0x34BB], 0x2F9CB=>[0x278AE], 0x2F9CC=>[0x27966], 0x2F9CD=>[0x46BE], 0x2F9CE=>[0x46C7], 0x2F9CF=>[0x8AA0], 0x2F9D0=>[0x8AED], 0x2F9D1=>[0x8B8A], 0x2F9D2=>[0x8C55], 0x2F9D3=>[0x27CA8], 0x2F9D4=>[0x8CAB], 0x2F9D5=>[0x8CC1], 0x2F9D6=>[0x8D1B], 0x2F9D7=>[0x8D77], 0x2F9D8=>[0x27F2F], 0x2F9D9=>[0x20804], 0x2F9DA=>[0x8DCB], 0x2F9DB=>[0x8DBC], 0x2F9DC=>[0x8DF0], 0x2F9DD=>[0x208DE], 0x2F9DE=>[0x8ED4], 0x2F9DF=>[0x8F38], 0x2F9E0=>[0x285D2], 0x2F9E1=>[0x285ED], 0x2F9E2=>[0x9094], 0x2F9E3=>[0x90F1], 0x2F9E4=>[0x9111], 0x2F9E5=>[0x2872E], 0x2F9E6=>[0x911B], 0x2F9E7=>[0x9238], 0x2F9E8=>[0x92D7], 0x2F9E9=>[0x92D8], 0x2F9EA=>[0x927C], 0x2F9EB=>[0x93F9], 0x2F9EC=>[0x9415], 0x2F9ED=>[0x28BFA], 0x2F9EE=>[0x958B], 0x2F9EF=>[0x4995], 0x2F9F0=>[0x95B7], 0x2F9F1=>[0x28D77], 0x2F9F2=>[0x49E6], 0x2F9F3=>[0x96C3], 0x2F9F4=>[0x5DB2], 0x2F9F5=>[0x9723], 0x2F9F6=>[0x29145], 0x2F9F7=>[0x2921A], 0x2F9F8=>[0x4A6E], 0x2F9F9=>[0x4A76], 0x2F9FA=>[0x97E0], 0x2F9FB=>[0x2940A], 0x2F9FC=>[0x4AB2], 0x2F9FD=>[0x29496], 0x2F9FE=>[0x980B], 0x2F9FF=>[0x980B], 0x2FA00=>[0x9829], 0x2FA01=>[0x295B6], 0x2FA02=>[0x98E2], 0x2FA03=>[0x4B33], 0x2FA04=>[0x9929], 0x2FA05=>[0x99A7], 0x2FA06=>[0x99C2], 0x2FA07=>[0x99FE], 0x2FA08=>[0x4BCE], 0x2FA09=>[0x29B30], 0x2FA0A=>[0x9B12], 0x2FA0B=>[0x9C40], 0x2FA0C=>[0x9CFD], 0x2FA0D=>[0x4CCE], 0x2FA0E=>[0x4CED], 0x2FA0F=>[0x9D67], 0x2FA10=>[0x2A0CE], 0x2FA11=>[0x4CF8], 0x2FA12=>[0x2A105], 0x2FA13=>[0x2A20E], 0x2FA14=>[0x2A291], 0x2FA15=>[0x9EBB], 0x2FA16=>[0x4D56], 0x2FA17=>[0x9EF9], 0x2FA18=>[0x9EFE], 0x2FA19=>[0x9F05], 0x2FA1A=>[0x9F0F], 0x2FA1B=>[0x9F16], 0x2FA1C=>[0x9F3B], 0x2FA1D=>[0x2A600]);
my %_ccc = (0x300 => 230,0x301 => 230,0x302 => 230,0x303 => 230,0x304 => 230,0x305 => 230,0x306 => 230,0x307 => 230,0x308 => 230,0x309 => 230,0x30A => 230,0x30B => 230,0x30C => 230,0x30D => 230,0x30E => 230,0x30F => 230,0x310 => 230,0x311 => 230,0x312 => 230,0x313 => 230,0x314 => 230,0x315 => 232,0x316 => 220,0x317 => 220,0x318 => 220,0x319 => 220,0x31A => 232,0x31B => 216,0x31C => 220,0x31D => 220,0x31E => 220,0x31F => 220,0x320 => 220,0x321 => 202,0x322 => 202,0x323 => 220,0x324 => 220,0x325 => 220,0x326 => 220,0x327 => 202,0x328 => 202,0x329 => 220,0x32A => 220,0x32B => 220,0x32C => 220,0x32D => 220,0x32E => 220,0x32F => 220,0x330 => 220,0x331 => 220,0x332 => 220,0x333 => 220,0x334 => 1,0x335 => 1,0x336 => 1,0x337 => 1,0x338 => 1,0x339 => 220,0x33A => 220,0x33B => 220,0x33C => 220,0x33D => 230,0x33E => 230,0x33F => 230,0x340 => 230,0x341 => 230,0x342 => 230,0x343 => 230,0x344 => 230,0x345 => 240,0x346 => 230,0x347 => 220,0x348 => 220,0x349 => 220,0x34A => 230,0x34B => 230,0x34C => 230,0x34D => 220,0x34E => 220,0x350 => 230,0x351 => 230,0x352 => 230,0x353 => 220,0x354 => 220,0x355 => 220,0x356 => 220,0x357 => 230,0x358 => 232,0x359 => 220,0x35A => 220,0x35B => 230,0x35C => 233,0x35D => 234,0x35E => 234,0x35F => 233,0x360 => 234,0x361 => 234,0x362 => 233,0x363 => 230,0x364 => 230,0x365 => 230,0x366 => 230,0x367 => 230,0x368 => 230,0x369 => 230,0x36A => 230,0x36B => 230,0x36C => 230,0x36D => 230,0x36E => 230,0x36F => 230,0x483 => 230,0x484 => 230,0x485 => 230,0x486 => 230,0x487 => 230,0x591 => 220,0x592 => 230,0x593 => 230,0x594 => 230,0x595 => 230,0x596 => 220,0x597 => 230,0x598 => 230,0x599 => 230,0x59A => 222,0x59B => 220,0x59C => 230,0x59D => 230,0x59E => 230,0x59F => 230,0x5A0 => 230,0x5A1 => 230,0x5A2 => 220,0x5A3 => 220,0x5A4 => 220,0x5A5 => 220,0x5A6 => 220,0x5A7 => 220,0x5A8 => 230,0x5A9 => 230,0x5AA => 220,0x5AB => 230,0x5AC => 230,0x5AD => 222,0x5AE => 228,0x5AF => 230,0x5B0 => 10,0x5B1 => 11,0x5B2 => 12,0x5B3 => 13,0x5B4 => 14,0x5B5 => 15,0x5B6 => 16,0x5B7 => 17,0x5B8 => 18,0x5B9 => 19,0x5BA => 19,0x5BB => 20,0x5BC => 21,0x5BD => 22,0x5BF => 23,0x5C1 => 24,0x5C2 => 25,0x5C4 => 230,0x5C5 => 220,0x5C7 => 18,0x610 => 230,0x611 => 230,0x612 => 230,0x613 => 230,0x614 => 230,0x615 => 230,0x616 => 230,0x617 => 230,0x618 => 30,0x619 => 31,0x61A => 32,0x64B => 27,0x64C => 28,0x64D => 29,0x64E => 30,0x64F => 31,0x650 => 32,0x651 => 33,0x652 => 34,0x653 => 230,0x654 => 230,0x655 => 220,0x656 => 220,0x657 => 230,0x658 => 230,0x659 => 230,0x65A => 230,0x65B => 230,0x65C => 220,0x65D => 230,0x65E => 230,0x65F => 220,0x670 => 35,0x6D6 => 230,0x6D7 => 230,0x6D8 => 230,0x6D9 => 230,0x6DA => 230,0x6DB => 230,0x6DC => 230,0x6DF => 230,0x6E0 => 230,0x6E1 => 230,0x6E2 => 230,0x6E3 => 220,0x6E4 => 230,0x6E7 => 230,0x6E8 => 230,0x6EA => 220,0x6EB => 230,0x6EC => 230,0x6ED => 220,0x711 => 36,0x730 => 230,0x731 => 220,0x732 => 230,0x733 => 230,0x734 => 220,0x735 => 230,0x736 => 230,0x737 => 220,0x738 => 220,0x739 => 220,0x73A => 230,0x73B => 220,0x73C => 220,0x73D => 230,0x73E => 220,0x73F => 230,0x740 => 230,0x741 => 230,0x742 => 220,0x743 => 230,0x744 => 220,0x745 => 230,0x746 => 220,0x747 => 230,0x748 => 220,0x749 => 230,0x74A => 230,0x7EB => 230,0x7EC => 230,0x7ED => 230,0x7EE => 230,0x7EF => 230,0x7F0 => 230,0x7F1 => 230,0x7F2 => 220,0x7F3 => 230,0x816 => 230,0x817 => 230,0x818 => 230,0x819 => 230,0x81B => 230,0x81C => 230,0x81D => 230,0x81E => 230,0x81F => 230,0x820 => 230,0x821 => 230,0x822 => 230,0x823 => 230,0x825 => 230,0x826 => 230,0x827 => 230,0x829 => 230,0x82A => 230,0x82B => 230,0x82C => 230,0x82D => 230,0x859 => 220,0x85A => 220,0x85B => 220,0x93C => 7,0x94D => 9,0x951 => 230,0x952 => 220,0x953 => 230,0x954 => 230,0x9BC => 7,0x9CD => 9,0xA3C => 7,0xA4D => 9,0xABC => 7,0xACD => 9,0xB3C => 7,0xB4D => 9,0xBCD => 9,0xC4D => 9,0xC55 => 84,0xC56 => 91,0xCBC => 7,0xCCD => 9,0xD4D => 9,0xDCA => 9,0xE38 => 103,0xE39 => 103,0xE3A => 9,0xE48 => 107,0xE49 => 107,0xE4A => 107,0xE4B => 107,0xEB8 => 118,0xEB9 => 118,0xEC8 => 122,0xEC9 => 122,0xECA => 122,0xECB => 122,0xF18 => 220,0xF19 => 220,0xF35 => 220,0xF37 => 220,0xF39 => 216,0xF71 => 129,0xF72 => 130,0xF74 => 132,0xF7A => 130,0xF7B => 130,0xF7C => 130,0xF7D => 130,0xF80 => 130,0xF82 => 230,0xF83 => 230,0xF84 => 9,0xF86 => 230,0xF87 => 230,0xFC6 => 220,0x1037 => 7,0x1039 => 9,0x103A => 9,0x108D => 220,0x135D => 230,0x135E => 230,0x135F => 230,0x1714 => 9,0x1734 => 9,0x17D2 => 9,0x17DD => 230,0x18A9 => 228,0x1939 => 222,0x193A => 230,0x193B => 220,0x1A17 => 230,0x1A18 => 220,0x1A60 => 9,0x1A75 => 230,0x1A76 => 230,0x1A77 => 230,0x1A78 => 230,0x1A79 => 230,0x1A7A => 230,0x1A7B => 230,0x1A7C => 230,0x1A7F => 220,0x1B34 => 7,0x1B44 => 9,0x1B6B => 230,0x1B6C => 220,0x1B6D => 230,0x1B6E => 230,0x1B6F => 230,0x1B70 => 230,0x1B71 => 230,0x1B72 => 230,0x1B73 => 230,0x1BAA => 9,0x1BE6 => 7,0x1BF2 => 9,0x1BF3 => 9,0x1C37 => 7,0x1CD0 => 230,0x1CD1 => 230,0x1CD2 => 230,0x1CD4 => 1,0x1CD5 => 220,0x1CD6 => 220,0x1CD7 => 220,0x1CD8 => 220,0x1CD9 => 220,0x1CDA => 230,0x1CDB => 230,0x1CDC => 220,0x1CDD => 220,0x1CDE => 220,0x1CDF => 220,0x1CE0 => 230,0x1CE2 => 1,0x1CE3 => 1,0x1CE4 => 1,0x1CE5 => 1,0x1CE6 => 1,0x1CE7 => 1,0x1CE8 => 1,0x1CED => 220,0x1DC0 => 230,0x1DC1 => 230,0x1DC2 => 220,0x1DC3 => 230,0x1DC4 => 230,0x1DC5 => 230,0x1DC6 => 230,0x1DC7 => 230,0x1DC8 => 230,0x1DC9 => 230,0x1DCA => 220,0x1DCB => 230,0x1DCC => 230,0x1DCD => 234,0x1DCE => 214,0x1DCF => 220,0x1DD0 => 202,0x1DD1 => 230,0x1DD2 => 230,0x1DD3 => 230,0x1DD4 => 230,0x1DD5 => 230,0x1DD6 => 230,0x1DD7 => 230,0x1DD8 => 230,0x1DD9 => 230,0x1DDA => 230,0x1DDB => 230,0x1DDC => 230,0x1DDD => 230,0x1DDE => 230,0x1DDF => 230,0x1DE0 => 230,0x1DE1 => 230,0x1DE2 => 230,0x1DE3 => 230,0x1DE4 => 230,0x1DE5 => 230,0x1DE6 => 230,0x1DFC => 233,0x1DFD => 220,0x1DFE => 230,0x1DFF => 220,0x20D0 => 230,0x20D1 => 230,0x20D2 => 1,0x20D3 => 1,0x20D4 => 230,0x20D5 => 230,0x20D6 => 230,0x20D7 => 230,0x20D8 => 1,0x20D9 => 1,0x20DA => 1,0x20DB => 230,0x20DC => 230,0x20E1 => 230,0x20E5 => 1,0x20E6 => 1,0x20E7 => 230,0x20E8 => 220,0x20E9 => 230,0x20EA => 1,0x20EB => 1,0x20EC => 220,0x20ED => 220,0x20EE => 220,0x20EF => 220,0x20F0 => 230,0x2CEF => 230,0x2CF0 => 230,0x2CF1 => 230,0x2D7F => 9,0x2DE0 => 230,0x2DE1 => 230,0x2DE2 => 230,0x2DE3 => 230,0x2DE4 => 230,0x2DE5 => 230,0x2DE6 => 230,0x2DE7 => 230,0x2DE8 => 230,0x2DE9 => 230,0x2DEA => 230,0x2DEB => 230,0x2DEC => 230,0x2DED => 230,0x2DEE => 230,0x2DEF => 230,0x2DF0 => 230,0x2DF1 => 230,0x2DF2 => 230,0x2DF3 => 230,0x2DF4 => 230,0x2DF5 => 230,0x2DF6 => 230,0x2DF7 => 230,0x2DF8 => 230,0x2DF9 => 230,0x2DFA => 230,0x2DFB => 230,0x2DFC => 230,0x2DFD => 230,0x2DFE => 230,0x2DFF => 230,0x302A => 218,0x302B => 228,0x302C => 232,0x302D => 222,0x302E => 224,0x302F => 224,0x3099 => 8,0x309A => 8,0xA66F => 230,0xA67C => 230,0xA67D => 230,0xA6F0 => 230,0xA6F1 => 230,0xA806 => 9,0xA8C4 => 9,0xA8E0 => 230,0xA8E1 => 230,0xA8E2 => 230,0xA8E3 => 230,0xA8E4 => 230,0xA8E5 => 230,0xA8E6 => 230,0xA8E7 => 230,0xA8E8 => 230,0xA8E9 => 230,0xA8EA => 230,0xA8EB => 230,0xA8EC => 230,0xA8ED => 230,0xA8EE => 230,0xA8EF => 230,0xA8F0 => 230,0xA8F1 => 230,0xA92B => 220,0xA92C => 220,0xA92D => 220,0xA953 => 9,0xA9B3 => 7,0xA9C0 => 9,0xAAB0 => 230,0xAAB2 => 230,0xAAB3 => 230,0xAAB4 => 220,0xAAB7 => 230,0xAAB8 => 230,0xAABE => 230,0xAABF => 230,0xAAC1 => 230,0xABED => 9,0xFB1E => 26,0xFE20 => 230,0xFE21 => 230,0xFE22 => 230,0xFE23 => 230,0xFE24 => 230,0xFE25 => 230,0xFE26 => 230,0x101FD => 220,0x10A0D => 220,0x10A0F => 230,0x10A38 => 230,0x10A39 => 1,0x10A3A => 220,0x10A3F => 9,0x11046 => 9,0x110B9 => 9,0x110BA => 7,0x1D165 => 216,0x1D166 => 216,0x1D167 => 1,0x1D168 => 1,0x1D169 => 1,0x1D16D => 226,0x1D16E => 216,0x1D16F => 216,0x1D170 => 216,0x1D171 => 216,0x1D172 => 216,0x1D17B => 220,0x1D17C => 220,0x1D17D => 220,0x1D17E => 220,0x1D17F => 220,0x1D180 => 220,0x1D181 => 220,0x1D182 => 220,0x1D185 => 230,0x1D186 => 230,0x1D187 => 230,0x1D188 => 230,0x1D189 => 230,0x1D18A => 220,0x1D18B => 220,0x1D1AA => 230,0x1D1AB => 230,0x1D1AC => 230,0x1D1AD => 230,0x1D242 => 230,0x1D243 => 230,0x1D244 => 230);

my $SBase = 0xAC00;
my $LBase = 0x1100;
my $VBase = 0x1161;
my $TBase = 0x11A7;

my $LCount = 19;
my $VCount = 21;
my $TCount = 28;

my $NCount = $VCount * $TCount;
my $SCount = $LCount * $NCount;

sub _dec_hangul {
  my $si = (shift) - $SBase;

  my $l = int( $si / $NCount);
  my $v = int(($si % $NCount) / $TCount);
  my $t =      $si % $TCount;

  return ($LBase + $l, $VBase + $v, ($t ? $TBase + $t : ()));
}

sub _nfc {
  my @cp = map { ord } split //, shift;

  ## decompose
  @cp = map { exists($_dec{$_}) ? @{$_dec{$_}} : 
   ($_ >= $SBase and $_ < $SBase+$SCount) ? _dec_hangul($_) : $_ } @cp;

  ## reorder
  for(my $c=0; $c<=$#cp-1; $c++) {
    next if !$_ccc{$cp[$c]};
    my $l = $c; while($l<$#cp and $_ccc{$cp[$l+1]}) {$l++};
    if($l > $c) {
      splice @cp, $c, $l-$c+1,
	sort { $_ccc{$a} <=> $_ccc{$b} }
          @cp[$c..$l];
      $c = $l;
    }
  }

  ## compose 
  C: for(my $c=1; $c<=$#cp; $c++) {

    ## NB: As Hangul L,V,LV,T have Ccc:0, we only have to look at the previous character
    ##     furthermore, Hangul sequences are never blocked
    if($cp[$c] >= $VBase and $cp[$c] < $VBase+$VCount
        and $cp[$c-1] >= $LBase and $cp[$c-1] < $LBase+$LCount) {	# found Hangul L+V
      splice @cp, $c-1, 2, ($cp[$c-1]-$LBase) * $NCount + ($cp[$c]-$VBase) * $TCount + $SBase;
      $c--; next;
    }

    if($cp[$c] >= $TBase and $cp[$c] < $TBase+$TCount
        and $cp[$c-1] >= $SBase and $cp[$c-1] < $SBase+$SCount
        and !(($cp[$c-1]-$SBase) % $TCount)) {			# found Hangul LV+T
      splice @cp, $c-1, 2, $cp[$c-1] + $cp[$c]-$TBase;
      $c--; next;
    }

    next unless $_com{$cp[$c]};					# no other combination defined
    next if $_ccc{$cp[$c-1]} and $_ccc{$cp[$c-1]} >= ($_ccc{$cp[$c]} || -1); # blocked

    for(my $l=$c-1; $l>=0; $l--) {
      if(!$_ccc{$cp[$l]} and $_com{$cp[$c]}->{$cp[$l]}) {	# found starter with composition
        $cp[$l] = $_com{$cp[$c]}->{$cp[$l]};
        splice @cp, $c, 1; 
	$c--; next;
      }
    }
  };

  return join '', map { chr } @cp;
}

1;

__END__
