/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.flyingtitans.xml.ElementalParser;
import org.ttt.salt.Configuration;
import org.ttt.salt.TBXException;
import org.ttt.salt.TBXResolver;
import org.ttt.salt.XCSDocument;
import org.ttt.salt.XCSValidationException;
import org.ttt.salt.dom.tbx.TBXDocument;
import org.ttt.salt.dom.tbx.TBXElement;
import org.ttt.salt.dom.tbx.TBXParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TBXFile {
    private static final String RCSID = "$Id: TBXFile.java 147 2012-06-02 14:37:43Z lanhel $";
    public static final String AUTO_TERMENTRY_ID_PREFIX = "AUTO_termEntry_ID_";
    private static final DocumentBuilderFactory FACTORY;
    private static final Logger LOGGER;
    private Type fileType = Type.UNKNOWN;
    private Configuration config;
    private URL url;
    private Reader reader;
    private XCSDocument xcsDocument;
    private EntityResolver resolver;
    private TBXParser tbxParser;
    private TBXDocument tbxDocument;
    private boolean parsed;
    private boolean valid;
    private int termEntrySeq;
    private Map<String, Element> termEntries = new HashMap<String, Element>();
    private SortedSet<TBXException> exceptions = new TreeSet<TBXException>();
    private SortedSet<TBXException> warnings = new TreeSet<TBXException>();

    public TBXFile(URL u, Configuration c) throws IOException, SAXException {
        if (c == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        this.config = c;
        if (u == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        this.url = u;
        this.resolver = c.getCustomEntityResolver();
        if (this.resolver == null) {
            this.resolver = new TBXResolver(u);
        }
        this.tbxParser = new TBXParser(this.resolver, c);
        InputStream input = this.url.openStream();
        if (!input.markSupported()) {
            input = new BufferedInputStream(input);
        }
        InputStreamReader inread = new InputStreamReader(input, TBXResolver.getEncoding(input));
        this.reader = new BufferedReader(inread);
    }

    public void parseAndValidate() throws IOException {
        if (!this.parsed) {
            boolean ok = this.preParseCheck();
            if (ok) {
                ok = this.parseDocument();
            }
            if (ok) {
                this.valid = this.validate();
            }
            if (this.valid) {
                this.buildTermEntriesMap();
            }
        }
    }

    public TBXDocument getTBXDocument() {
        return this.tbxDocument;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void write(File file) throws IOException {
        ResourceBundle bundle = this.getResourceBundle();
        PrintWriter out = new PrintWriter(new FileWriter(file));
        Element elem = this.getTBXDocument().getDocumentElement();
        out.println(bundle.getString("Header"));
        out.println(elem);
        out.flush();
        out.close();
    }

    public Type getType() {
        return this.fileType;
    }

    public Map<String, Element> getTermEntryMap() {
        return this.termEntries;
    }

    public XCSDocument getXCSDocument() {
        return this.xcsDocument;
    }

    public Element getBodyElement() {
        Element root = this.getTBXDocument().getDocumentElement();
        Element text = (Element)root.getElementsByTagName("text").item(0);
        Element body = (Element)text.getElementsByTagName("body").item(0);
        return body;
    }

    public List<TBXException> getInvalidatingExceptions() {
        return new ArrayList<TBXException>(this.exceptions);
    }

    public List<TBXException> getWarningExceptions() {
        return new ArrayList<TBXException>(this.warnings);
    }

    private ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle("org.ttt.salt.TBXFile");
    }

    private boolean preParseCheck() throws IOException {
        boolean stageXMLDECL = false;
        boolean stageDOCTYPE = true;
        int stageMARTIF = 2;
        int stageDONE = 3;
        int minMarkSize = 1024;
        ResourceBundle bundle = this.getResourceBundle();
        ElementalParser parse = new ElementalParser(this.reader);
        this.reader.mark(1024);
        int stage = 0;
        ElementalParser.Token type = parse.next();
        while (stage != 3) {
            if (type == ElementalParser.Token.EOF) {
                StreamCorruptedException cause = new StreamCorruptedException(bundle.getString("PreParse_EOF"));
                TBXException err = new TBXException(TBXException.Priority.PRE_PARSE, cause);
                this.exceptions.add(err);
                this.fileType = Type.CORRUPT;
                stage = 3;
            } else if (type == ElementalParser.Token.ILLFORMED) {
                this.exceptions.add(new TBXException(TBXException.Priority.PRE_PARSE, new StreamCorruptedException(bundle.getString("PreParse_Illformed") + parse.sval)));
                this.fileType = Type.CORRUPT;
                stage = 3;
            } else if (stage == 0 && type != ElementalParser.Token.XMLDECL) {
                this.exceptions.add(new TBXException(TBXException.Priority.PRE_PARSE, new StreamCorruptedException(bundle.getString("PreParse_NoXMLDecl") + parse.sval)));
                this.fileType = Type.CORRUPT;
            } else if (stage == 0 && type == ElementalParser.Token.XMLDECL) {
                stage = 1;
            } else if (stage == 1 && type == ElementalParser.Token.DOCTYPEDECL) {
                this.fileType = Type.DTD;
                stage = 2;
            } else if (stage == 2 && type == ElementalParser.Token.START) {
                if (this.fileType == Type.UNKNOWN) {
                    this.fileType = Type.SCHEMA;
                }
                stage = 3;
            }
            type = parse.next();
        }
        try {
            this.reader.reset();
        }
        catch (IOException err) {
            if (err.getMessage().equals("Mark invalid")) {
                this.exceptions.add(new TBXException(TBXException.Priority.PRE_PARSE, new StreamCorruptedException(bundle.getString("PreParse_Overflow"))));
            }
            throw err;
        }
        return this.exceptions.isEmpty();
    }

    private boolean parseDocument() throws IOException {
        boolean ret = true;
        try {
            switch (this.fileType) {
                case CORRUPT: {
                    break;
                }
                case DTD: {
                    this.buildDocumentWithDTD();
                    break;
                }
                case SCHEMA: {
                    this.buildDocumentWithSchema();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown file type: " + (Object)((Object)this.fileType));
                }
            }
            this.parsed = true;
        }
        catch (IOException err) {
            this.exceptions.add(new TBXException(TBXException.Priority.XMLVALID_MAJOR, err));
            ret = false;
        }
        catch (SAXException err) {
            this.exceptions.add(new TBXException(TBXException.Priority.WELLFORMED, err));
            ret = false;
        }
        catch (ParserConfigurationException err) {
            this.exceptions.add(new TBXException(TBXException.Priority.WELLFORMED, err));
            ret = false;
        }
        return ret;
    }

    private void buildDocumentWithDTD() throws IOException, ParserConfigurationException, SAXException {
        InputSource insource = new InputSource(this.reader);
        insource.setSystemId(this.url.toString());
        this.tbxDocument = this.tbxParser.parse(insource);
        this.exceptions.addAll(this.tbxDocument.getParseExceptions());
    }

    private void buildDocumentWithSchema() throws IOException, ParserConfigurationException, SAXException {
        InputSource insource = new InputSource(this.reader);
        insource.setSystemId(this.url.toString());
        this.tbxDocument = this.tbxParser.parse(insource);
        this.exceptions.addAll(this.tbxDocument.getParseExceptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validate() throws IOException {
        ResourceBundle bundle = this.getResourceBundle();
        if (!this.parsed) {
            throw new IllegalArgumentException(bundle.getString("Validate_NoXMLParse"));
        }
        try {
            if (this.tbxParser != null) {
                this.exceptions.addAll(this.tbxDocument.getParseExceptions());
            } else {
                this.buildXCSDocument();
                this.validateAgainstXCS((TBXElement)this.getTBXDocument().getDocumentElement());
            }
        }
        catch (SAXException err) {
            this.exceptions.add(new TBXException(TBXException.Priority.XMLVALID_MAJOR, err));
        }
        catch (ParserConfigurationException err) {
            System.err.println(err);
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        return this.exceptions.isEmpty();
    }

    private void buildXCSDocument() throws IOException, ParserConfigurationException, SAXException {
        Element root = this.getTBXDocument().getDocumentElement();
        Element header = (Element)root.getElementsByTagName("martifHeader").item(0);
        if (header.getElementsByTagName("encodingDesc").getLength() == 1) {
            String xcsUriStr = null;
            Element encoding = (Element)header.getElementsByTagName("encodingDesc").item(0);
            NodeList plist = encoding.getElementsByTagName("p");
            for (int i = 0; i < plist.getLength(); ++i) {
                Element p = (Element)plist.item(i);
                if (!p.hasAttribute("type")) continue;
                if (p.getAttribute("type").equals("DCSName") || p.getAttribute("type").equals("XCSName")) {
                    xcsUriStr = p.getTextContent().trim();
                    LOGGER.info("<p type='DCSName'> is deprecated: use <p type='XCSURI'>.");
                    break;
                }
                if (p.getAttribute("type").equals("XCSURI")) {
                    xcsUriStr = p.getTextContent().trim();
                    break;
                }
                if (!p.getAttribute("type").equals("XCSContent")) continue;
                throw new UnsupportedOperationException("XCSContent location type unsupported.");
            }
            if (xcsUriStr == null) {
                throw new FileNotFoundException(String.format("XCS unspecified for TBX file: %s.", this.url));
            }
            try {
                LOGGER.info("Using XCS file: " + xcsUriStr);
                this.xcsDocument = new XCSDocument(xcsUriStr, this.resolver, this.config);
            }
            catch (FileNotFoundException err) {
                String msg = String.format("On TBX file '%s' XCS file '%s' not found.", this.url, xcsUriStr);
                LOGGER.info(msg);
            }
            catch (IOException err) {
                LOGGER.log(Level.WARNING, "Exception building XCS", err);
            }
        }
    }

    private void validateAgainstXCS(TBXElement elem) {
        String name = elem.getTagName();
        if (name.equals("termEntry")) {
            try {
                this.xcsDocument.validateTermEntry(elem);
            }
            catch (XCSValidationException err) {
                this.exceptions.add(new TBXException(TBXException.Priority.XCS, err));
            }
        } else {
            for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof TBXElement)) continue;
                this.validateAgainstXCS((TBXElement)node);
            }
        }
    }

    public String getTermEntryAutoId() {
        String ret = AUTO_TERMENTRY_ID_PREFIX + this.termEntrySeq;
        ++this.termEntrySeq;
        return ret;
    }

    private void buildTermEntriesMap() {
        Element body = this.getBodyElement();
        NodeList terms = body.getElementsByTagName("termEntry");
        for (int i = 0; i < terms.getLength(); ++i) {
            String id;
            Element entry = (Element)terms.item(i);
            if (entry.getAttribute("id").startsWith(AUTO_TERMENTRY_ID_PREFIX)) {
                entry.removeAttribute("id");
            }
            if ((id = entry.getAttribute("id")).equals("")) {
                id = this.getTermEntryAutoId();
                entry.setAttribute("id", id);
            }
            this.termEntries.put(id, entry);
        }
    }

    static {
        LOGGER = Logger.getLogger("org.ttt.salt");
        FACTORY = DocumentBuilderFactory.newInstance();
        FACTORY.setNamespaceAware(true);
    }

    private static class MarkLimitReader
    extends FilterReader {
        private int maxChars;
        private int count;

        public MarkLimitReader(Reader in) {
            super(in);
            if (!in.markSupported()) {
                throw new IllegalArgumentException("Reader shall support marking");
            }
        }

        public int read() throws IOException {
            this.checkReader(1L);
            int ret = this.in.read();
            ++this.count;
            return ret;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int allow = (int)this.checkReader(len);
            int ret = this.in.read(cbuf, off, allow);
            this.count += ret;
            return ret;
        }

        public long skip(long n) throws IOException {
            long allow = this.checkReader(n);
            long ret = this.in.skip(allow);
            this.count = (int)((long)this.count + ret);
            return ret;
        }

        public void mark(int readAheadLimit) throws IOException {
            if (this.in == null) {
                throw new IOException("Reader closed");
            }
            this.maxChars = readAheadLimit;
            this.in.mark(readAheadLimit);
        }

        public void reset() throws IOException {
            if (this.in == null) {
                throw new IOException("Reader closed");
            }
            this.count = 0;
            this.in.reset();
        }

        public void clearMark() throws IOException {
            this.maxChars = -1;
        }

        public void close() throws IOException {
            this.in = null;
        }

        private long checkReader(long n) throws IOException {
            if (this.in == null) {
                throw new IOException("Reader closed");
            }
            long ret = 0L;
            if (this.maxChars >= 0) {
                if (this.count >= this.maxChars) {
                    throw new IOException("Maximum marked characters read");
                }
                if ((long)this.count + n > (long)this.maxChars) {
                    ret = this.maxChars - this.count;
                }
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNKNOWN,
        CORRUPT,
        DTD,
        SCHEMA;

    }
}

