package t::lib::StepOver;

use base qw(Test::Class);
use Test::More;
use Test::Deep;

use t::lib::Debugger;

# setup methods are run before every test method.
sub load_debugger : Test(setup) {
	my $self = shift;
	start_script('t/eg/02-sub.pl');
	$self->{debugger} = start_debugger();
	my $out = $self->{debugger}->get;
	$out =~ m/(1.\d{2})$/m;
	$self->{perl5db_ver} = $1;
}

sub stepover : Test(3) {
	my $self = shift;
	my $out;

	$self->{debugger}->run(8);

	my @out = $self->{debugger}->step_over;

	SKIP: {
		skip( "perl5db $] dose not support c [line|sub]", 1 ) if $] =~ m/5.01500(3|4|5)/;
		SKIP: {
			skip( "perl5db v$self->{perl5db_ver} dose not support list context", 1 ) if $self->{perl5db_ver} == 1.35;
			cmp_deeply( \@out, [ 'main::', 't/eg/02-sub.pl', 9, 'my $z = $x + $y;' ], 'stepover line 9' );
		}
	}

	$self->{debugger}->get_lineinfo;
	SKIP: {
		skip( "perl5db $] dose not support c [line|sub]", 1 ) if $] =~ m/5.01500(3|4|5)/;
		ok( $self->{debugger}->get_row == 9, 'row = 9' );
	}

	ok( $self->{debugger}->get_filename =~ m/02-sub/, 'filename = 02-sub.pl' );

}

# teardown methods are run after every test method.
sub teardown : Test(teardown) {
	my $self = shift;
	$self->{debugger}->quit;
	done_testing();
}

1;

__END__
