#!perl -T
use 5.006;

use strict;
use warnings;

use Statistics::Covid::Datum;
use Statistics::Covid::Datum::IO;
use File::Temp;
use File::Spec;
use File::Basename;

my $dirname = dirname(__FILE__);

use Test::More;

my $num_tests = 0;

my ($ret, $count, $io, $schema, $da);

my @das;
my $N = 3; my $M = 10;
for my $i (1..$N){ for my $j (1..$M){
	$da = Statistics::Covid::Datum::make_random_object(123);
	ok(defined $da, "created Datum"); $num_tests++;
	$da->name($i);
	$da->belongsto(10*$i-1);
	$da->confirmed(($i)*(10*$j-1));
	$da->unconfirmed(10*(($i)*(10*$j-1)));
	push @das, $da
} }
my $df = Statistics::Covid::Utils::datums2dataframe(
	\@das,
	['name', 'belongsto'],
	['confirmed', 'unconfirmed']
);
ok(defined $df, "Statistics::Covid::Utils::datums2dataframe() called"); $num_tests++;

my (%counts, $v);
for my $i (1..$N){
	my $k = $i.'|'.(10*$i-1);
	ok(exists $df->{$k}, "key $k exists"); $num_tests++;
	ok(exists $df->{$k}->{'confirmed'}, "key confirmed exists for $k"); $num_tests++;
	ok(exists $df->{$k}->{'unconfirmed'}, "key unconfirmed exists for $k"); $num_tests++;
	for my $j (1..$M){
		$v = ($i)*(10*$j-1);
		ok($df->{$k}->{'confirmed'}->[$j-1]==$v, "key confirmed ($k) for j=$j has value $v == ".$df->{$k}->{'confirmed'}->[$j-1]); $num_tests++;
		$v = 10*(($i)*(10*$j-1));
		ok($df->{$k}->{'unconfirmed'}->[$j-1]==$v, "key unconfirmed ($k) for j=$j has value $v == ".$df->{$k}->{'confirmed'}->[$j-1]); $num_tests++;
	}
}

done_testing($num_tests);
