# This is a test for module Image::Quantize.

use warnings;
use strict;
use Test::More;
use FindBin;
use Image::Quantize::PNG;
use Image::PNG::Libpng ':all';
use Image::PNG::Const ':all';

my $iq = Image::Quantize::PNG->new ();
ok ($iq, 'made object');

ok ($iq->check_integrity (), 'integrity check');

$iq->speed (10);
is ($iq->speed, 10, 'got correct speed value');

ok ($iq->check_integrity (), 'integrity check');

my $pngfile;

# Test reading and writing a file.

$pngfile = "$FindBin::Bin/dice.png";

if (! -f $pngfile) {
    die "cannot find '$pngfile'";
}

# Height and width of "dice.png"

my $dicew = 800;
my $diceh = 600;

my $pngin = read_png_file ($pngfile);
my $ihdr = $pngin->get_IHDR ();

# These do not test Image::Quantize::PNG.

if ($ihdr->{height} != $diceh) {
    die "bad height $diceh";
}
if ($ihdr->{width} != $dicew) {
    die "bad width $diceh";
}
if ($ihdr->{color_type} != PNG_COLOR_TYPE_RGBA) {
    die "$pngfile bad colour type not RGBA";
}

my $pngout;

$pngout = $iq->quantize ($pngin);

ok ($iq->check_integrity (), 'integrity check');

my $ihdrout = $pngout->get_IHDR ();
is ($ihdrout->{height}, $diceh, 'got correct height');
is ($ihdrout->{width}, $dicew, 'got correct width');
is ($ihdrout->{color_type}, PNG_COLOR_TYPE_PALETTE, "Got palette colour type");

my $outfile;

$outfile = "$FindBin::Bin/dice-output.png";

$pngout->write_png_file ($outfile);

ok (-f $outfile, 'outfile was written');

if (-f $outfile) {
    unlink ($outfile);
}

$pngfile = "$FindBin::Bin/flores.png";
$pngin = read_png_file ($pngfile);

$pngout = $iq->quantize ($pngin);
ok ($iq->check_integrity (), 'integrity check');
$outfile = "$FindBin::Bin/flores-output.png";
$pngout->write_png_file ($outfile);
ok (-f $outfile, 'outfile was written');
if (-f $outfile) {
    unlink ($outfile);
}


done_testing ();
