#line 2 "Libpng.xs.tmpl"

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"

/* There is some kind of collision between a file included by "perl.h"
   and "png.h" for very old versions of libpng, like the one used on
   Ubuntu Linux. */

#define PNG_SKIP_SETJMP_CHECK
#include <zlib.h>
#include <png.h>

#include <stdarg.h>
#include <time.h>

#include "my-xs.h"
#include "perl-libpng.c"
#include "const-c.inc"

MODULE = Image::PNG::Libpng PACKAGE = Image::PNG::Libpng PREFIX = perl_png_

PROTOTYPES: ENABLE

INCLUDE: const-xs.inc

Image::PNG::Libpng perl_png_create_read_struct ()
CODE:
        RETVAL = perl_png_create_read_struct ();
OUTPUT:
        RETVAL

Image::PNG::Libpng perl_png_create_write_struct ()
CODE:
        RETVAL = perl_png_create_write_struct ();
OUTPUT:
        RETVAL

void
perl_png_destroy_read_struct (Png)
        Image::PNG::Libpng  Png
CODE:
        perl_png_destroy_read_struct (Png);


void
perl_png_destroy_write_struct (Png)
        Image::PNG::Libpng  Png
CODE:
        perl_png_destroy_write_struct (Png);


void perl_png_write_png (Png, transforms = PNG_TRANSFORM_IDENTITY)
        Image::PNG::Libpng  Png
        int transforms
CODE:
        perl_png_write_png (Png, transforms);


void perl_png_init_io (Png, fp)
        Image::PNG::Libpng  Png
        FILE * fp
CODE:
        png_init_io (Png->png, fp);
        Png->init_io_done = 1;

void perl_png_read_info (Png)
        Image::PNG::Libpng  Png
CODE:
        png_read_info (Png->png, Png->info);


void perl_png_read_update_info (Png)
        Image::PNG::Libpng  Png
CODE:
        png_read_update_info (Png->png, Png->info);


void perl_png_read_image (Png)
        Image::PNG::Libpng  Png
CODE:
        perl_png_read_image (Png);


void perl_png_read_png (Png, transforms = PNG_TRANSFORM_IDENTITY)
        Image::PNG::Libpng  Png
        int transforms
CODE:
        perl_png_read_png (Png, transforms);
OUTPUT:

SV * perl_png_get_text (Png)
        Image::PNG::Libpng  Png
CODE:
        RETVAL = perl_png_get_text (Png);
OUTPUT:
        RETVAL

void perl_png_set_text (Png, text)
        Image::PNG::Libpng  Png
        AV * text
CODE:
        perl_png_set_text (Png, text);


int perl_png_sig_cmp (sig, start = 0, num_to_check = 8)
        SV * sig
        int start
        int num_to_check
CODE:
        RETVAL = perl_png_sig_cmp (sig, start, num_to_check);
OUTPUT:
        RETVAL

void perl_png_scalar_as_input (Png, scalar, transforms = 0)
        Image::PNG::Libpng Png
        SV * scalar
        int transforms
CODE:
        perl_png_scalar_as_input (Png, scalar, transforms);


Image::PNG::Libpng
perl_png_read_from_scalar (scalar, transforms = 0)
        SV * scalar
        int transforms
CODE:
        RETVAL = perl_png_read_from_scalar (scalar, transforms);
OUTPUT:
	RETVAL

const char *
perl_png_color_type_name (color_type)
        int color_type
CODE:
        RETVAL = perl_png_color_type_name (color_type);
OUTPUT:
        RETVAL

const char *
perl_png_text_compression_name (text_compression)
        int text_compression
CODE:
        RETVAL = perl_png_text_compression_name (text_compression);
OUTPUT:
        RETVAL

const char *
perl_png_get_libpng_ver ()
CODE:
        RETVAL = png_get_libpng_ver (UNUSED_ZERO_ARG);
OUTPUT:
        RETVAL

int
perl_png_access_version_number ()
CODE:
        RETVAL = png_access_version_number ();
OUTPUT:
        RETVAL

void *
perl_png_get_row_pointers (Png)
        Image::PNG::Libpng  Png
CODE:
        RETVAL = perl_png_get_row_pointers (Png);
OUTPUT:
        RETVAL

SV *
perl_png_get_rows (Png)
        Image::PNG::Libpng  Png
CODE:
        RETVAL = perl_png_get_rows (Png);
OUTPUT:
        RETVAL

int
perl_png_get_rowbytes (Png)
        Image::PNG::Libpng  Png
CODE:
        RETVAL = png_get_rowbytes (Png->png, Png->info);
OUTPUT:
        RETVAL


SV * perl_png_get_valid (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_valid (Png);
OUTPUT:
        RETVAL

void perl_png_set_tRNS_pointer (Png, tRNS_pointer, num_tRNS_pointer)
        Image::PNG::Libpng Png
        void * tRNS_pointer
        int num_tRNS_pointer
CODE:
        perl_png_set_tRNS_pointer (Png, tRNS_pointer, num_tRNS_pointer);


void perl_png_set_rows (Png, rows)
        Image::PNG::Libpng Png
        AV * rows
CODE:
        perl_png_set_rows (Png, rows);


SV * perl_png_write_to_scalar (Png, transforms = 0)
        Image::PNG::Libpng Png
        int transforms;
CODE:
        RETVAL = perl_png_write_to_scalar (Png, transforms);
OUTPUT:
        RETVAL

void perl_png_set_filter (Png, filters)
        Image::PNG::Libpng Png
        int filters;
CODE:
        png_set_filter (Png->png, UNUSED_ZERO_ARG, filters);


void perl_png_set_verbosity (Png, verbosity = 0)
        Image::PNG::Libpng Png
        int verbosity; 
CODE:
        perl_png_set_verbosity (Png, verbosity);
OUTPUT:
        
void perl_png_set_unknown_chunks (Png, unknown_chunks)
        Image::PNG::Libpng Png
        AV * unknown_chunks
CODE:
        perl_png_set_unknown_chunks (Png, unknown_chunks);


SV * perl_png_get_unknown_chunks (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_unknown_chunks (Png);
OUTPUT:
        RETVAL

int perl_png_libpng_supports (what)
        const char * what
CODE:
        RETVAL = perl_png_libpng_supports (what);
OUTPUT:
        RETVAL

void perl_png_set_keep_unknown_chunks (Png, keep, chunk_list = 0)
        Image::PNG::Libpng Png
        int keep
        SV * chunk_list
CODE:
        perl_png_set_keep_unknown_chunks (Png, keep, chunk_list);


SV * perl_png_get_tRNS_palette (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_tRNS_palette (Png);
OUTPUT:
        RETVAL

void perl_png_set_expand (Png)
        Image::PNG::Libpng Png
CODE:
        png_set_expand (Png->png);

void perl_png_set_expand_16 (Png)
        Image::PNG::Libpng Png
CODE:
        png_set_expand_16 (Png->png);

void perl_png_set_gray_to_rgb (Png)
        Image::PNG::Libpng Png
CODE:
        png_set_gray_to_rgb (Png->png);


void perl_png_set_filler (Png, filler, flags)
        Image::PNG::Libpng Png
        int filler
        int flags
CODE:
        png_set_filler (Png->png, filler, flags);

int
perl_png_get_sRGB (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_sRGB (Png);
OUTPUT:
        RETVAL

void perl_png_set_sRGB (Png, sRGB)
        Image::PNG::Libpng Png
        int sRGB
CODE:
        png_set_sRGB (Png->png, Png->info, sRGB);


void perl_png_set_packing (Png)
        Image::PNG::Libpng Png
CODE:
        png_set_packing (Png->png);


void perl_png_set_strip_16 (Png)
        Image::PNG::Libpng Png
CODE:
        png_set_strip_16 (Png->png);

void perl_png_set_strip_alpha (Png)
        Image::PNG::Libpng Png
CODE:
        png_set_strip_alpha (Png->png);

void perl_png_DESTROY (Png)
        Image::PNG::Libpng Png
	CODE:
        if (Png) {
        	perl_png_destroy (Png);
	}

SV * perl_png_get_bKGD (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_bKGD (Png);
OUTPUT:
        RETVAL

void perl_png_set_bKGD (Png, bKGD)
        Image::PNG::Libpng Png
        HV * bKGD
CODE:
        perl_png_set_bKGD (Png, bKGD);



SV * perl_png_get_cHRM (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_cHRM (Png);
OUTPUT:
        RETVAL

void perl_png_set_cHRM (Png, cHRM)
        Image::PNG::Libpng Png
        HV * cHRM
CODE:
        perl_png_set_cHRM (Png, cHRM);



SV * perl_png_get_cHRM_XYZ (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_cHRM_XYZ (Png);
OUTPUT:
        RETVAL

void perl_png_set_cHRM_XYZ (Png, cHRM_XYZ)
        Image::PNG::Libpng Png
        HV * cHRM_XYZ
CODE:
        perl_png_set_cHRM_XYZ (Png, cHRM_XYZ);



SV * perl_png_get_eXIf (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_eXIf (Png);
OUTPUT:
        RETVAL

void perl_png_set_eXIf (Png, eXIf)
        Image::PNG::Libpng Png
        SV * eXIf
CODE:
        perl_png_set_eXIf (Png, eXIf);



SV * perl_png_get_gAMA (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_gAMA (Png);
OUTPUT:
        RETVAL

void perl_png_set_gAMA (Png, gAMA)
        Image::PNG::Libpng Png
        double gAMA
CODE:
        perl_png_set_gAMA (Png, gAMA);



SV * perl_png_get_hIST (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_hIST (Png);
OUTPUT:
        RETVAL

void perl_png_set_hIST (Png, hIST)
        Image::PNG::Libpng Png
        AV * hIST
CODE:
        perl_png_set_hIST (Png, hIST);



SV * perl_png_get_iCCP (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_iCCP (Png);
OUTPUT:
        RETVAL

void perl_png_set_iCCP (Png, iCCP)
        Image::PNG::Libpng Png
        HV * iCCP
CODE:
        perl_png_set_iCCP (Png, iCCP);



SV * perl_png_get_IHDR (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_IHDR (Png);
OUTPUT:
        RETVAL

void perl_png_set_IHDR (Png, IHDR)
        Image::PNG::Libpng Png
        HV * IHDR
CODE:
        perl_png_set_IHDR (Png, IHDR);



SV * perl_png_get_oFFs (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_oFFs (Png);
OUTPUT:
        RETVAL

void perl_png_set_oFFs (Png, oFFs)
        Image::PNG::Libpng Png
        HV * oFFs
CODE:
        perl_png_set_oFFs (Png, oFFs);



SV * perl_png_get_pCAL (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_pCAL (Png);
OUTPUT:
        RETVAL

void perl_png_set_pCAL (Png, pCAL)
        Image::PNG::Libpng Png
        HV * pCAL
CODE:
        perl_png_set_pCAL (Png, pCAL);



SV * perl_png_get_pHYs (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_pHYs (Png);
OUTPUT:
        RETVAL

void perl_png_set_pHYs (Png, pHYs)
        Image::PNG::Libpng Png
        HV * pHYs
CODE:
        perl_png_set_pHYs (Png, pHYs);



SV * perl_png_get_PLTE (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_PLTE (Png);
OUTPUT:
        RETVAL

void perl_png_set_PLTE (Png, PLTE)
        Image::PNG::Libpng Png
        AV * PLTE
CODE:
        perl_png_set_PLTE (Png, PLTE);



SV * perl_png_get_sBIT (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_sBIT (Png);
OUTPUT:
        RETVAL

void perl_png_set_sBIT (Png, sBIT)
        Image::PNG::Libpng Png
        HV * sBIT
CODE:
        perl_png_set_sBIT (Png, sBIT);



SV * perl_png_get_sCAL (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_sCAL (Png);
OUTPUT:
        RETVAL

void perl_png_set_sCAL (Png, sCAL)
        Image::PNG::Libpng Png
        HV * sCAL
CODE:
        perl_png_set_sCAL (Png, sCAL);



SV * perl_png_get_sPLT (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_sPLT (Png);
OUTPUT:
        RETVAL

void perl_png_set_sPLT (Png, sPLT)
        Image::PNG::Libpng Png
        AV * sPLT
CODE:
        perl_png_set_sPLT (Png, sPLT);



SV * perl_png_get_tIME (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_tIME (Png);
OUTPUT:
        RETVAL

void perl_png_set_tIME (Png, tIME =  0)
        Image::PNG::Libpng Png
        SV * tIME
CODE:
        perl_png_set_tIME (Png, tIME);



SV * perl_png_get_tRNS (Png)
        Image::PNG::Libpng Png
CODE:
        RETVAL = perl_png_get_tRNS (Png);
OUTPUT:
        RETVAL

void perl_png_set_tRNS (Png, tRNS)
        Image::PNG::Libpng Png
        SV * tRNS
CODE:
        perl_png_set_tRNS (Png, tRNS);



#line 353 "Libpng.xs.tmpl"

void perl_png_get_internals (Png)
	Image::PNG::Libpng Png
PREINIT:
	png_structp png;
	png_infop info;
	SV * png_sv;
	SV * info_sv;
PPCODE:
	png = Png->png;
	info = Png->info;
	png_sv = newSViv (PTR2IV (png));
	info_sv = newSViv (PTR2IV (info));
	XPUSHs(sv_2mortal(png_sv));
	XPUSHs(sv_2mortal(info_sv));

void perl_png_set_transforms (Png, transforms)
	Image::PNG::Libpng Png;
	int transforms;
CODE:
	perl_png_set_transforms (Png, transforms);
OUTPUT:

void perl_png_copy_row_pointers (Png, row_pointers)
	Image::PNG::Libpng Png;
	SV * row_pointers;
CODE:
	perl_png_copy_row_pointers (Png, row_pointers);
OUTPUT:


int
perl_png_get_image_width (Png)
	Image::PNG::Libpng Png;
CODE: 
    	RETVAL = perl_png_get_image_width (Png);
OUTPUT:
	RETVAL

int
perl_png_get_image_height (Png)
	Image::PNG::Libpng Png;
CODE: 
    	RETVAL = perl_png_get_image_height (Png);
OUTPUT:
	RETVAL


int
perl_png_get_palette_max(Png)
	Image::PNG::Libpng Png;
CODE:
#ifdef PNG_CHECK_FOR_INVALID_INDEX_SUPPORTED
#  ifdef PNG_GET_PALETTE_MAX_SUPPORTED
	RETVAL = png_get_palette_max (Png->png, Png->info);
#  else
	UNSUPPORTED('GET_PALETTE_MAX');
#  endif
#else
        UNSUPPORTED('CHECK_FOR_INVALID_INDEX');
#endif
OUTPUT:
	RETVAL




int
perl_png_get_channels (Png)
	Image::PNG::Libpng Png;
CODE: 
    	RETVAL = perl_png_get_channels (Png);
OUTPUT:
	RETVAL

int
perl_png_get_bit_depth (Png)
	Image::PNG::Libpng Png;
CODE: 
    	RETVAL = png_get_bit_depth (Png->png, Png->info);
OUTPUT:
	RETVAL

int
perl_png_get_interlace_type (Png)
	Image::PNG::Libpng Png;
CODE: 
    	RETVAL = png_get_interlace_type (Png->png, Png->info);
OUTPUT:
	RETVAL

int
perl_png_get_color_type (Png)
	Image::PNG::Libpng Png;
CODE: 
    	RETVAL = png_get_color_type (Png->png, Png->info);
OUTPUT:
	RETVAL

int
perl_png_set_user_limits (Png, w, h)
	Image::PNG::Libpng Png;
	unsigned w;
	unsigned h;
CODE: 
	perl_png_set_user_limits (Png, w, h);


SV *
perl_png_get_user_width_max (Png)
	Image::PNG::Libpng Png;
CODE:
	RETVAL = perl_png_get_user_width_max (Png);
OUTPUT:
	RETVAL


SV *
perl_png_get_user_height_max (Png)
	Image::PNG::Libpng Png;
CODE:
	RETVAL = perl_png_get_user_height_max (Png);
OUTPUT:
	RETVAL



void
perl_png_set_image_data (Png, image_data, own = & PL_sv_undef)
	Image::PNG::Libpng Png;
	void * image_data;
	SV * own;
CODE:
	if (Png->type != perl_png_write_obj) {
		croak ("Cannot set image data in read PNG");
	}
	Png->image_data = image_data;
	Png->memory_gets++;

void
perl_png_set_row_pointers (Png, row_pointers)
	Image::PNG::Libpng Png;
	SV * row_pointers;
CODE:
	if (Png->type != perl_png_write_obj) {
		croak ("Cannot set row pointe	rs in read PNG");
	}
	Png->row_pointers = INT2PTR (png_bytepp, SvIV (row_pointers));
        png_set_rows (Png->png, Png->info, Png->row_pointers);
	Png->memory_gets++;

int
perl_png_set_rgb_to_gray_fixed (Png, error_action = 1, red_weight=-1, green_weight=-1)
	Image::PNG::Libpng Png;
	int error_action;
	int red_weight;
	int green_weight;
CODE:
	png_set_rgb_to_gray_fixed (Png->png, error_action, red_weight, green_weight);
	RETVAL = png_get_rgb_to_gray_status (Png->png);
	png_read_update_info (Png->png, Png->info);
OUTPUT:
	RETVAL

# These functions predate the macro and were valid in libpng 1.2, yet
# the macro is invalid except for libpng 1.6.17, so conditional
# compilation doesn't seem to offer any benefit, hence the following
# is commented out. 

# #ifdef PNG_WRITE_CUSTOMIZE_COMPRESSION_SUPPORTED

void
perl_png_set_compression_level (Png, level)
	Image::PNG::Libpng Png;
	int level
CODE:
	if (level != Z_DEFAULT_COMPRESSION) {
	    if (level < Z_NO_COMPRESSION || level > Z_BEST_COMPRESSION) {
		croak ("Compression level must be %d for default or "
		       "between %d and %d",
		       Z_DEFAULT_COMPRESSION, Z_NO_COMPRESSION,
		       Z_BEST_COMPRESSION);
	    }
	}
	png_set_compression_level (Png->png, level);

void
perl_png_set_compression_buffer_size (Png, size)
	Image::PNG::Libpng Png;
	size_t size;
CODE:
	png_set_compression_buffer_size (Png->png, size);

SV *
perl_png_get_compression_buffer_size (Png)
	Image::PNG::Libpng Png;
PREINIT:
	size_t size;
CODE:
	size = png_get_compression_buffer_size (Png->png);
	RETVAL = newSViv (size);
OUTPUT:
	RETVAL
	
void
perl_png_set_compression_mem_level (Png, mem_level);
	Image::PNG::Libpng Png;
	int mem_level;
CODE:
	png_set_compression_mem_level (Png->png, mem_level);

void
perl_png_set_compression_strategy (Png, strategy);
	Image::PNG::Libpng Png;
	int strategy;
CODE:
	png_set_compression_strategy (Png->png, strategy);

void
perl_png_set_compression_window_bits  (Png,   window_bits);
	Image::PNG::Libpng Png;
	int window_bits;
CODE:
	png_set_compression_window_bits (Png->png, window_bits);

# #endif /* WRITE_CUSTOMIZE_COMPRESSION */

# This macro is not documented in CHANGES in libpng.

#ifdef PNG_WRITE_CUSTOMIZE_ZTXT_COMPRESSION_SUPPORTED

void
perl_png_set_text_compression_level (Png, level);
	Image::PNG::Libpng Png;
	int level;
CODE:
	png_set_text_compression_level (Png->png, level);

void
perl_png_set_text_compression_mem_level (Png, mem_level);
	Image::PNG::Libpng Png;
	int mem_level;
CODE:
	png_set_compression_mem_level (Png->png, mem_level);

void
perl_png_set_text_compression_strategy (Png, strategy);
	Image::PNG::Libpng Png;
	int strategy;
CODE:
	png_set_compression_strategy (Png->png, strategy);

void
perl_png_set_text_compression_window_bits  (Png,   window_bits);
	Image::PNG::Libpng Png;
	int window_bits;
CODE:
	png_set_compression_window_bits (Png->png, window_bits);

#endif /* WRITE_CUSTOMIZE_ZTXT_COMPRESSION */

#if 0

void
perl_png_set_compression_method (Png, method);
	Image::PNG::Libpng Png;
	int method;
CODE:
	png_set_compression_method (Png->png, method);

#endif /* 0 */

#if 0

void
perl_png_set_crc_action  (Png, crit_action, ancil_action);
	Image::PNG::Libpng Png;
	int crit_action;
	int ancil_action;
CODE:
	png_set_crc_action (Png->png, crit_action, ancil_action);

#endif /* 0 */

SV *
perl_png_split_alpha (Png)
	Image::PNG::Libpng Png;
CODE:
	RETVAL = perl_png_split_alpha (Png);
OUTPUT:
	RETVAL


int
perl_png_read_struct (Png)
	Image::PNG::Libpng Png;
CODE:
	RETVAL = (Png->type == perl_png_read_obj);
OUTPUT:
	RETVAL

void
perl_png_set_gamma (Png, gamma, override_gamma)
	Image::PNG::Libpng Png;
	double gamma;
	double override_gamma;
CODE:
	png_set_gamma (Png->png, gamma, override_gamma);
	

void
perl_png_set_alpha_mode (Png, mode, screen_gamma)
	Image::PNG::Libpng Png;
	int mode;
	double screen_gamma;
CODE:
	png_set_alpha_mode (Png->png, mode, screen_gamma);

void
perl_png_set_scale_16(Png)
	Image::PNG::Libpng Png;
CODE:
	png_set_scale_16 (Png->png);

void
perl_png_set_invert_mono(Png)
	Image::PNG::Libpng Png;
CODE:
	png_set_invert_mono (Png->png);

void
perl_png_set_invert_alpha(Png)
	Image::PNG::Libpng Png;
CODE:
	png_set_invert_alpha (Png->png);

void
perl_png_set_bgr(Png)
	Image::PNG::Libpng Png;
CODE:
	png_set_bgr (Png->png);

void
perl_png_set_palette_to_rgb(Png)
	Image::PNG::Libpng Png;
CODE:
	png_set_palette_to_rgb (Png->png);

void
perl_png_set_packswap(Png)
	Image::PNG::Libpng Png;
CODE:
	png_set_packswap (Png->png);

void
perl_png_set_swap(Png)
	Image::PNG::Libpng Png;
CODE:
	png_set_swap (Png->png);

void
perl_png_set_swap_alpha(Png)
	Image::PNG::Libpng Png;
CODE:
	png_set_swap_alpha (Png->png);

void
perl_png_permit_mng_features(Png, mask)
	Image::PNG::Libpng Png;
	int mask;
CODE:
	png_permit_mng_features(Png->png, mask);




