#line 1 "bcd-c.tmpl"
#ifdef TEST
#include <stdio.h>
#endif /* def TEST */
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include "split-double.h"
#include "math.h"

typedef struct bcd {
    int16_t pow2;
    int16_t exp;
    uint32_t upper;
    uint32_t lower;
}
bcd_t;

bcd_t bcddata[0x800] = {
{0, 0, 0, 0}, /* -inf */
#line 22 "bcd.c"
{-1022, -308, 0x22250738, 0x58507201},
{-1021, -308, 0x44501477, 0x17014403},
{-1020, -308, 0x89002954, 0x34028806},
{-1019, -307, 0x17800590, 0x86805761},
{-1018, -307, 0x35601181, 0x73611521},
{-1017, -307, 0x71202363, 0x47223043},
{-1016, -306, 0x14240472, 0x69444608},
{-1015, -306, 0x28480945, 0x38889217},
{-1014, -306, 0x56961890, 0x77778435},
{-1013, -305, 0x11392378, 0x15555687},
{-1012, -305, 0x22784756, 0x31111374},
{-1011, -305, 0x45569512, 0x62222748},
{-1010, -305, 0x91139025, 0x24445496},
{-1009, -304, 0x18227805, 0x04889099},
{-1008, -304, 0x36455610, 0x09778198},
{-1007, -304, 0x72911220, 0x19556396},
{-1006, -303, 0x14582244, 0x03911279},
{-1005, -303, 0x29164488, 0x07822558},
{-1004, -303, 0x58328976, 0x15645118},
{-1003, -302, 0x11665795, 0x23129023},
{-1002, -302, 0x23331590, 0x46258047},
{-1001, -302, 0x46663180, 0x92516094},
{-1000, -302, 0x93326361, 0x85032188},
{-999, -301, 0x18665272, 0x37006437},
{-998, -301, 0x37330544, 0x74012875},
{-997, -301, 0x74661089, 0x48025750},
{-996, -300, 0x14932217, 0x89605150},
{-995, -300, 0x29864435, 0x79210300},
{-994, -300, 0x59728871, 0x58420601},
{-993, -299, 0x11945774, 0x31684120},
{-992, -299, 0x23891548, 0x63368240},
{-991, -299, 0x47783097, 0x26736480},
{-990, -299, 0x95566194, 0x53472960},
{-989, -298, 0x19113238, 0x90694592},
{-988, -298, 0x38226477, 0x81389184},
{-987, -298, 0x76452955, 0x62778369},
{-986, -297, 0x15290591, 0x12555673},
{-985, -297, 0x30581182, 0x25111347},
{-984, -297, 0x61162364, 0x50222695},
{-983, -296, 0x12232472, 0x90044539},
{-982, -296, 0x24464945, 0x80089078},
{-981, -296, 0x48929891, 0x60178156},
{-980, -296, 0x97859783, 0x20356312},
{-979, -295, 0x19571956, 0x64071262},
{-978, -295, 0x39143913, 0x28142524},
{-977, -295, 0x78287826, 0x56285049},
{-976, -294, 0x15657565, 0x31257009},
{-975, -294, 0x31315130, 0x62514019},
{-974, -294, 0x62630261, 0x25028039},
{-973, -293, 0x12526052, 0x25005608},
{-972, -293, 0x25052104, 0x50011216},
{-971, -293, 0x50104209, 0x00022432},
{-970, -292, 0x10020841, 0x80004486},
{-969, -292, 0x20041683, 0x60008972},
{-968, -292, 0x40083367, 0x20017945},
{-967, -292, 0x80166734, 0x40035891},
{-966, -291, 0x16033346, 0x88007178},
{-965, -291, 0x32066693, 0x76014356},
{-964, -291, 0x64133387, 0x52028712},
{-963, -290, 0x12826677, 0x50405742},
{-962, -290, 0x25653355, 0x00811484},
{-961, -290, 0x51306710, 0x01622970},
{-960, -289, 0x10261342, 0x00324594},
{-959, -289, 0x20522684, 0x00649188},
{-958, -289, 0x41045368, 0x01298376},
{-957, -289, 0x82090736, 0x02596752},
{-956, -288, 0x16418147, 0x20519350},
{-955, -288, 0x32836294, 0x41038700},
{-954, -288, 0x65672588, 0x82077400},
{-953, -287, 0x13134517, 0x76415480},
{-952, -287, 0x26269035, 0x52830960},
{-951, -287, 0x52538071, 0x05661921},
{-950, -286, 0x10507614, 0x21132384},
{-949, -286, 0x21015228, 0x42264768},
{-948, -286, 0x42030456, 0x84529537},
{-947, -286, 0x84060913, 0x69059074},
{-946, -285, 0x16812182, 0x73811814},
{-945, -285, 0x33624365, 0x47623629},
{-944, -285, 0x67248730, 0x95247259},
{-943, -284, 0x13449746, 0x19049451},
{-942, -284, 0x26899492, 0x38098903},
{-941, -284, 0x53798984, 0x76197807},
{-940, -283, 0x10759796, 0x95239561},
{-939, -283, 0x21519593, 0x90479122},
{-938, -283, 0x43039187, 0x80958246},
{-937, -283, 0x86078375, 0x61916492},
{-936, -282, 0x17215675, 0x12383298},
{-935, -282, 0x34431350, 0x24766597},
{-934, -282, 0x68862700, 0x49533194},
{-933, -281, 0x13772540, 0x09906638},
{-932, -281, 0x27545080, 0x19813277},
{-931, -281, 0x55090160, 0x39626555},
{-930, -280, 0x11018032, 0x07925311},
{-929, -280, 0x22036064, 0x15850622},
{-928, -280, 0x44072128, 0x31701243},
{-927, -280, 0x88144256, 0x63402487},
{-926, -279, 0x17628851, 0x32680497},
{-925, -279, 0x35257702, 0x65360995},
{-924, -279, 0x70515405, 0x30721990},
{-923, -278, 0x14103081, 0x06144398},
{-922, -278, 0x28206162, 0x12288796},
{-921, -278, 0x56412324, 0x24577592},
{-920, -277, 0x11282464, 0x84915518},
{-919, -277, 0x22564929, 0x69831037},
{-918, -277, 0x45129859, 0x39662073},
{-917, -277, 0x90259718, 0x79324147},
{-916, -276, 0x18051943, 0x75864829},
{-915, -276, 0x36103887, 0x51729659},
{-914, -276, 0x72207775, 0x03459318},
{-913, -275, 0x14441555, 0x00691863},
{-912, -275, 0x28883110, 0x01383727},
{-911, -275, 0x57766220, 0x02767455},
{-910, -274, 0x11553244, 0x00553491},
{-909, -274, 0x23106488, 0x01106982},
{-908, -274, 0x46212976, 0x02213963},
{-907, -274, 0x92425952, 0x04427926},
{-906, -273, 0x18485190, 0x40885585},
{-905, -273, 0x36970380, 0x81771170},
{-904, -273, 0x73940761, 0x63542341},
{-903, -272, 0x14788152, 0x32708468},
{-902, -272, 0x29576304, 0x65416936},
{-901, -272, 0x59152609, 0x30833873},
{-900, -271, 0x11830521, 0x86166774},
{-899, -271, 0x23661043, 0x72333549},
{-898, -271, 0x47322087, 0x44667098},
{-897, -271, 0x94644174, 0x89334197},
{-896, -270, 0x18928834, 0x97866839},
{-895, -270, 0x37857669, 0x95733679},
{-894, -270, 0x75715339, 0x91467358},
{-893, -269, 0x15143067, 0x98293471},
{-892, -269, 0x30286135, 0x96586943},
{-891, -269, 0x60572271, 0x93173886},
{-890, -268, 0x12114454, 0x38634777},
{-889, -268, 0x24228908, 0x77269554},
{-888, -268, 0x48457817, 0x54539109},
{-887, -268, 0x96915635, 0x09078218},
{-886, -267, 0x19383127, 0x01815643},
{-885, -267, 0x38766254, 0x03631287},
{-884, -267, 0x77532508, 0x07262574},
{-883, -266, 0x15506501, 0x61452515},
{-882, -266, 0x31013003, 0x22905030},
{-881, -266, 0x62026006, 0x45810060},
{-880, -265, 0x12405201, 0x29162012},
{-879, -265, 0x24810402, 0x58324024},
{-878, -265, 0x49620805, 0x16648047},
{-877, -265, 0x99241610, 0x33296095},
{-876, -264, 0x19848322, 0x06659218},
{-875, -264, 0x39696644, 0x13318438},
{-874, -264, 0x79393288, 0x26636876},
{-873, -263, 0x15878657, 0x65327375},
{-872, -263, 0x31757315, 0x30654750},
{-871, -263, 0x63514630, 0x61309501},
{-870, -262, 0x12702926, 0x12261900},
{-869, -262, 0x25405852, 0x24523800},
{-868, -262, 0x50811704, 0x49047600},
{-867, -261, 0x10162340, 0x89809520},
{-866, -261, 0x20324681, 0x79619040},
{-865, -261, 0x40649363, 0x59238081},
{-864, -261, 0x81298727, 0x18476162},
{-863, -260, 0x16259745, 0x43695232},
{-862, -260, 0x32519490, 0x87390464},
{-861, -260, 0x65038981, 0x74780928},
{-860, -259, 0x13007796, 0x34956185},
{-859, -259, 0x26015592, 0x69912371},
{-858, -259, 0x52031185, 0x39824743},
{-857, -258, 0x10406237, 0x07964948},
{-856, -258, 0x20812474, 0x15929897},
{-855, -258, 0x41624948, 0x31859794},
{-854, -258, 0x83249896, 0x63719589},
{-853, -257, 0x16649979, 0x32743917},
{-852, -257, 0x33299958, 0x65487835},
{-851, -257, 0x66599917, 0x30975671},
{-850, -256, 0x13319983, 0x46195134},
{-849, -256, 0x26639966, 0x92390268},
{-848, -256, 0x53279933, 0x84780537},
{-847, -255, 0x10655986, 0x76956107},
{-846, -255, 0x21311973, 0x53912214},
{-845, -255, 0x42623947, 0x07824430},
{-844, -255, 0x85247894, 0x15648860},
{-843, -254, 0x17049578, 0x83129772},
{-842, -254, 0x34099157, 0x66259543},
{-841, -254, 0x68198315, 0x32519087},
{-840, -253, 0x13639663, 0x06503817},
{-839, -253, 0x27279326, 0x13007634},
{-838, -253, 0x54558652, 0x26015269},
{-837, -252, 0x10911730, 0x45203053},
{-836, -252, 0x21823460, 0x90406107},
{-835, -252, 0x43646921, 0x80812216},
{-834, -252, 0x87293843, 0x61624432},
{-833, -251, 0x17458768, 0x72324886},
{-832, -251, 0x34917537, 0x44649772},
{-831, -251, 0x69835074, 0x89299545},
{-830, -250, 0x13967014, 0x97859909},
{-829, -250, 0x27934029, 0x95719818},
{-828, -250, 0x55868059, 0x91439637},
{-827, -249, 0x11173611, 0x98287927},
{-826, -249, 0x22347223, 0x96575855},
{-825, -249, 0x44694447, 0x93151710},
{-824, -249, 0x89388895, 0x86303420},
{-823, -248, 0x17877779, 0x17260683},
{-822, -248, 0x35755558, 0x34521366},
{-821, -248, 0x71511116, 0x69042733},
{-820, -247, 0x14302223, 0x33808546},
{-819, -247, 0x28604446, 0x67617093},
{-818, -247, 0x57208893, 0x35234188},
{-817, -246, 0x11441778, 0x67046837},
{-816, -246, 0x22883557, 0x34093675},
{-815, -246, 0x45767114, 0x68187350},
{-814, -246, 0x91534229, 0x36374701},
{-813, -245, 0x18306845, 0x87274940},
{-812, -245, 0x36613691, 0x74549880},
{-811, -245, 0x73227383, 0x49099761},
{-810, -244, 0x14645476, 0x69819952},
{-809, -244, 0x29290953, 0x39639904},
{-808, -244, 0x58581906, 0x79279808},
{-807, -243, 0x11716381, 0x35855961},
{-806, -243, 0x23432762, 0x71711923},
{-805, -243, 0x46865525, 0x43423846},
{-804, -243, 0x93731050, 0x86847693},
{-803, -242, 0x18746210, 0x17369538},
{-802, -242, 0x37492420, 0x34739077},
{-801, -242, 0x74984840, 0x69478155},
{-800, -241, 0x14996968, 0x13895630},
{-799, -241, 0x29993936, 0x27791261},
{-798, -241, 0x59987872, 0x55582523},
{-797, -240, 0x11997574, 0x51116504},
{-796, -240, 0x23995149, 0x02233009},
{-795, -240, 0x47990298, 0x04466018},
{-794, -240, 0x95980596, 0x08932036},
{-793, -239, 0x19196119, 0x21786407},
{-792, -239, 0x38392238, 0x43572815},
{-791, -239, 0x76784476, 0x87145630},
{-790, -238, 0x15356895, 0x37429126},
{-789, -238, 0x30713790, 0x74858252},
{-788, -238, 0x61427581, 0x49716504},
{-787, -237, 0x12285516, 0x29943300},
{-786, -237, 0x24571032, 0x59886601},
{-785, -237, 0x49142065, 0x19773203},
{-784, -237, 0x98284130, 0x39546406},
{-783, -236, 0x19656826, 0x07909281},
{-782, -236, 0x39313652, 0x15818563},
{-781, -236, 0x78627304, 0x31637126},
{-780, -235, 0x15725460, 0x86327425},
{-779, -235, 0x31450921, 0x72654850},
{-778, -235, 0x62901843, 0x45309700},
{-777, -234, 0x12580368, 0x69061940},
{-776, -234, 0x25160737, 0x38123880},
{-775, -234, 0x50321474, 0x76247760},
{-774, -233, 0x10064294, 0x95249552},
{-773, -233, 0x20128589, 0x90499103},
{-772, -233, 0x40257179, 0x80998207},
{-771, -233, 0x80514359, 0x61996415},
{-770, -232, 0x16102871, 0x92399283},
{-769, -232, 0x32205743, 0x84798566},
{-768, -232, 0x64411487, 0x69597133},
{-767, -231, 0x12882297, 0x53919426},
{-766, -231, 0x25764595, 0x07838853},
{-765, -231, 0x51529190, 0x15677706},
{-764, -230, 0x10305838, 0x03135541},
{-763, -230, 0x20611676, 0x06271082},
{-762, -230, 0x41223352, 0x12542165},
{-761, -230, 0x82446704, 0x25084330},
{-760, -229, 0x16489340, 0x85016866},
{-759, -229, 0x32978681, 0x70033732},
{-758, -229, 0x65957363, 0x40067464},
{-757, -228, 0x13191472, 0x68013492},
{-756, -228, 0x26382945, 0x36026985},
{-755, -228, 0x52765890, 0x72053970},
{-754, -227, 0x10553178, 0x14410794},
{-753, -227, 0x21106356, 0x28821588},
{-752, -227, 0x42212712, 0x57643177},
{-751, -227, 0x84425425, 0x15286355},
{-750, -226, 0x16885085, 0x03057271},
{-749, -226, 0x33770170, 0x06114542},
{-748, -226, 0x67540340, 0x12229084},
{-747, -225, 0x13508068, 0x02445816},
{-746, -225, 0x27016136, 0x04891633},
{-745, -225, 0x54032272, 0x09783266},
{-744, -224, 0x10806454, 0x41956653},
{-743, -224, 0x21612908, 0x83913306},
{-742, -224, 0x43225817, 0x67826613},
{-741, -224, 0x86451635, 0x35653227},
{-740, -223, 0x17290327, 0x07130645},
{-739, -223, 0x34580654, 0x14261290},
{-738, -223, 0x69161308, 0x28522581},
{-737, -222, 0x13832261, 0x65704516},
{-736, -222, 0x27664523, 0x31409032},
{-735, -222, 0x55329046, 0x62818065},
{-734, -221, 0x11065809, 0x32563613},
{-733, -221, 0x22131618, 0x65127226},
{-732, -221, 0x44263237, 0x30254452},
{-731, -221, 0x88526474, 0x60508904},
{-730, -220, 0x17705294, 0x92101780},
{-729, -220, 0x35410589, 0x84203561},
{-728, -220, 0x70821179, 0x68407122},
{-727, -219, 0x14164235, 0x93681424},
{-726, -219, 0x28328471, 0x87362849},
{-725, -219, 0x56656943, 0x74725698},
{-724, -218, 0x11331388, 0x74945139},
{-723, -218, 0x22662777, 0x49890279},
{-722, -218, 0x45325554, 0x99780559},
{-721, -218, 0x90651109, 0x99561118},
{-720, -217, 0x18130221, 0x99912223},
{-719, -217, 0x36260443, 0x99824447},
{-718, -217, 0x72520887, 0x99648894},
{-717, -216, 0x14504177, 0x59929779},
{-716, -216, 0x29008355, 0x19859558},
{-715, -216, 0x58016710, 0x39719115},
{-714, -215, 0x11603342, 0x07943823},
{-713, -215, 0x23206684, 0x15887646},
{-712, -215, 0x46413368, 0x31775293},
{-711, -215, 0x92826736, 0x63550586},
{-710, -214, 0x18565347, 0x32710117},
{-709, -214, 0x37130694, 0x65420233},
{-708, -214, 0x74261389, 0x30840466},
{-707, -213, 0x14852277, 0x86168093},
{-706, -213, 0x29704555, 0x72336186},
{-705, -213, 0x59409111, 0x44672375},
{-704, -212, 0x11881822, 0x28934474},
{-703, -212, 0x23763644, 0x57868949},
{-702, -212, 0x47527289, 0x15737899},
{-701, -212, 0x95054578, 0x31475798},
{-700, -211, 0x19010915, 0x66295159},
{-699, -211, 0x38021831, 0x32590319},
{-698, -211, 0x76043662, 0x65180638},
{-697, -210, 0x15208732, 0x53036127},
{-696, -210, 0x30417465, 0x06072255},
{-695, -210, 0x60834930, 0x12144510},
{-694, -209, 0x12166986, 0x02428902},
{-693, -209, 0x24333972, 0x04857804},
{-692, -209, 0x48667944, 0x09715608},
{-691, -209, 0x97335888, 0x19431217},
{-690, -208, 0x19467177, 0x63886243},
{-689, -208, 0x38934355, 0x27772486},
{-688, -208, 0x77868710, 0x55544973},
{-687, -207, 0x15573742, 0x11108994},
{-686, -207, 0x31147484, 0x22217989},
{-685, -207, 0x62294968, 0x44435979},
{-684, -206, 0x12458993, 0x68887195},
{-683, -206, 0x24917987, 0x37774391},
{-682, -206, 0x49835974, 0x75548783},
{-681, -206, 0x99671949, 0x51097567},
{-680, -205, 0x19934389, 0x90219513},
{-679, -205, 0x39868779, 0x80439026},
{-678, -205, 0x79737559, 0x60878053},
{-677, -204, 0x15947511, 0x92175610},
{-676, -204, 0x31895023, 0x84351221},
{-675, -204, 0x63790047, 0x68702443},
{-674, -203, 0x12758009, 0x53740488},
{-673, -203, 0x25516019, 0x07480977},
{-672, -203, 0x51032038, 0x14961954},
{-671, -202, 0x10206407, 0x62992390},
{-670, -202, 0x20412815, 0x25984781},
{-669, -202, 0x40825630, 0x51969563},
{-668, -202, 0x81651261, 0x03939126},
{-667, -201, 0x16330252, 0x20787825},
{-666, -201, 0x32660504, 0x41575650},
{-665, -201, 0x65321008, 0x83151301},
{-664, -200, 0x13064201, 0x76630260},
{-663, -200, 0x26128403, 0x53260520},
{-662, -200, 0x52256807, 0x06521042},
{-661, -199, 0x10451361, 0x41304208},
{-660, -199, 0x20902722, 0x82608416},
{-659, -199, 0x41805445, 0x65216833},
{-658, -199, 0x83610891, 0x30433667},
{-657, -198, 0x16722178, 0x26086733},
{-656, -198, 0x33444356, 0x52173466},
{-655, -198, 0x66888713, 0x04346932},
{-654, -197, 0x13377742, 0x60869386},
{-653, -197, 0x26755485, 0x21738773},
{-652, -197, 0x53510970, 0x43477546},
{-651, -196, 0x10702194, 0x08695509},
{-650, -196, 0x21404388, 0x17391018},
{-649, -196, 0x42808776, 0x34782036},
{-648, -196, 0x85617552, 0x69564073},
{-647, -195, 0x17123510, 0x53912814},
{-646, -195, 0x34247021, 0x07825629},
{-645, -195, 0x68494042, 0x15651258},
{-644, -194, 0x13698808, 0x43130251},
{-643, -194, 0x27397616, 0x86260503},
{-642, -194, 0x54795233, 0x72521006},
{-641, -193, 0x10959046, 0x74504201},
{-640, -193, 0x21918093, 0x49008402},
{-639, -193, 0x43836186, 0x98016805},
{-638, -193, 0x87672373, 0x96033611},
{-637, -192, 0x17534474, 0x79206722},
{-636, -192, 0x35068949, 0x58413444},
{-635, -192, 0x70137899, 0x16826889},
{-634, -191, 0x14027579, 0x83365377},
{-633, -191, 0x28055159, 0x66730755},
{-632, -191, 0x56110319, 0x33461512},
{-631, -190, 0x11222063, 0x86692302},
{-630, -190, 0x22444127, 0x73384604},
{-629, -190, 0x44888255, 0x46769208},
{-628, -190, 0x89776510, 0x93538417},
{-627, -189, 0x17955302, 0x18707683},
{-626, -189, 0x35910604, 0x37415367},
{-625, -189, 0x71821208, 0x74830735},
{-624, -188, 0x14364241, 0x74966147},
{-623, -188, 0x28728483, 0x49932294},
{-622, -188, 0x57456966, 0x99864587},
{-621, -187, 0x11491393, 0x39972917},
{-620, -187, 0x22982786, 0x79945834},
{-619, -187, 0x45965573, 0x59891670},
{-618, -187, 0x91931147, 0x19783341},
{-617, -186, 0x18386229, 0x43956668},
{-616, -186, 0x36772458, 0x87913336},
{-615, -186, 0x73544917, 0x75826672},
{-614, -185, 0x14708983, 0x55165334},
{-613, -185, 0x29417967, 0x10330669},
{-612, -185, 0x58835934, 0x20661338},
{-611, -184, 0x11767186, 0x84132267},
{-610, -184, 0x23534373, 0x68264535},
{-609, -184, 0x47068747, 0x36529070},
{-608, -184, 0x94137494, 0x73058140},
{-607, -183, 0x18827498, 0x94611628},
{-606, -183, 0x37654997, 0x89223256},
{-605, -183, 0x75309995, 0x78446512},
{-604, -182, 0x15061999, 0x15689302},
{-603, -182, 0x30123998, 0x31378604},
{-602, -182, 0x60247996, 0x62757210},
{-601, -181, 0x12049599, 0x32551442},
{-600, -181, 0x24099198, 0x65102884},
{-599, -181, 0x48198397, 0x30205768},
{-598, -181, 0x96396794, 0x60411536},
{-597, -180, 0x19279358, 0x92082307},
{-596, -180, 0x38558717, 0x84164615},
{-595, -180, 0x77117435, 0x68329230},
{-594, -179, 0x15423487, 0x13665845},
{-593, -179, 0x30846974, 0x27331691},
{-592, -179, 0x61693948, 0x54663383},
{-591, -178, 0x12338789, 0x70932676},
{-590, -178, 0x24677579, 0x41865353},
{-589, -178, 0x49355158, 0x83730706},
{-588, -178, 0x98710317, 0x67461413},
{-587, -177, 0x19742063, 0x53492282},
{-586, -177, 0x39484127, 0x06984565},
{-585, -177, 0x78968254, 0x13969130},
{-584, -176, 0x15793650, 0x82793826},
{-583, -176, 0x31587301, 0x65587652},
{-582, -176, 0x63174603, 0x31175304},
{-581, -175, 0x12634920, 0x66235060},
{-580, -175, 0x25269841, 0x32470121},
{-579, -175, 0x50539682, 0x64940243},
{-578, -174, 0x10107936, 0x52988048},
{-577, -174, 0x20215873, 0x05976097},
{-576, -174, 0x40431746, 0x11952194},
{-575, -174, 0x80863492, 0x23904389},
{-574, -173, 0x16172698, 0x44780878},
{-573, -173, 0x32345396, 0x89561755},
{-572, -173, 0x64690793, 0x79123511},
{-571, -172, 0x12938158, 0x75824702},
{-570, -172, 0x25876317, 0x51649404},
{-569, -172, 0x51752635, 0x03298809},
{-568, -171, 0x10350527, 0x00659761},
{-567, -171, 0x20701054, 0x01319523},
{-566, -171, 0x41402108, 0x02639048},
{-565, -171, 0x82804216, 0x05278096},
{-564, -170, 0x16560843, 0x21055619},
{-563, -170, 0x33121686, 0x42111237},
{-562, -170, 0x66243372, 0x84222475},
{-561, -169, 0x13248674, 0x56844495},
{-560, -169, 0x26497349, 0x13688990},
{-559, -169, 0x52994698, 0x27377980},
{-558, -168, 0x10598939, 0x65475596},
{-557, -168, 0x21197879, 0x30951192},
{-556, -168, 0x42395758, 0x61902384},
{-555, -168, 0x84791517, 0x23804769},
{-554, -167, 0x16958303, 0x44760954},
{-553, -167, 0x33916606, 0x89521907},
{-552, -167, 0x67833213, 0x79043815},
{-551, -166, 0x13566642, 0x75808762},
{-550, -166, 0x27133285, 0x51617525},
{-549, -166, 0x54266571, 0x03235051},
{-548, -165, 0x10853314, 0x20647010},
{-547, -165, 0x21706628, 0x41294020},
{-546, -165, 0x43413256, 0x82588041},
{-545, -165, 0x86826513, 0x65176083},
{-544, -164, 0x17365302, 0x73035216},
{-543, -164, 0x34730605, 0x46070433},
{-542, -164, 0x69461210, 0x92140866},
{-541, -163, 0x13892242, 0x18428173},
{-540, -163, 0x27784484, 0x36856346},
{-539, -163, 0x55568968, 0x73712694},
{-538, -162, 0x11113793, 0x74742538},
{-537, -162, 0x22227587, 0x49485077},
{-536, -162, 0x44455174, 0x98970154},
{-535, -162, 0x88910349, 0x97940308},
{-534, -161, 0x17782069, 0x99588061},
{-533, -161, 0x35564139, 0x99176123},
{-532, -161, 0x71128279, 0x98352246},
{-531, -160, 0x14225655, 0x99670449},
{-530, -160, 0x28451311, 0x99340898},
{-529, -160, 0x56902623, 0x98681797},
{-528, -159, 0x11380524, 0x79736359},
{-527, -159, 0x22761049, 0x59472719},
{-526, -159, 0x45522099, 0x18945438},
{-525, -159, 0x91044198, 0x37890876},
{-524, -158, 0x18208839, 0x67578175},
{-523, -158, 0x36417679, 0x35156350},
{-522, -158, 0x72835358, 0x70312701},
{-521, -157, 0x14567071, 0x74062540},
{-520, -157, 0x29134143, 0x48125080},
{-519, -157, 0x58268286, 0x96250161},
{-518, -156, 0x11653657, 0x39250032},
{-517, -156, 0x23307314, 0x78500064},
{-516, -156, 0x46614629, 0x57000129},
{-515, -156, 0x93229259, 0x14000258},
{-514, -155, 0x18645851, 0x82800051},
{-513, -155, 0x37291703, 0x65600103},
{-512, -155, 0x74583407, 0x31200207},
{-511, -154, 0x14916681, 0x46240041},
{-510, -154, 0x29833362, 0x92480082},
{-509, -154, 0x59666725, 0x84960165},
{-508, -153, 0x11933345, 0x16992033},
{-507, -153, 0x23866690, 0x33984066},
{-506, -153, 0x47733380, 0x67968131},
{-505, -153, 0x95466761, 0x35936262},
{-504, -152, 0x19093352, 0x27187252},
{-503, -152, 0x38186704, 0x54374505},
{-502, -152, 0x76373409, 0x08749011},
{-501, -151, 0x15274681, 0x81749802},
{-500, -151, 0x30549363, 0x63499604},
{-499, -151, 0x61098727, 0x26999209},
{-498, -150, 0x12219745, 0x45399841},
{-497, -150, 0x24439490, 0x90799683},
{-496, -150, 0x48878981, 0x81599367},
{-495, -150, 0x97757963, 0x63198735},
{-494, -149, 0x19551592, 0x72639747},
{-493, -149, 0x39103185, 0x45279494},
{-492, -149, 0x78206370, 0x90558988},
{-491, -148, 0x15641274, 0x18111797},
{-490, -148, 0x31282548, 0x36223595},
{-489, -148, 0x62565096, 0x72447190},
{-488, -147, 0x12513019, 0x34489437},
{-487, -147, 0x25026038, 0x68978875},
{-486, -147, 0x50052077, 0x37957751},
{-485, -146, 0x10010415, 0x47591550},
{-484, -146, 0x20020830, 0x95183100},
{-483, -146, 0x40041661, 0x90366201},
{-482, -146, 0x80083323, 0x80732402},
{-481, -145, 0x16016664, 0x76146480},
{-480, -145, 0x32033329, 0x52292961},
{-479, -145, 0x64066659, 0x04585923},
{-478, -144, 0x12813331, 0x80917184},
{-477, -144, 0x25626663, 0x61834369},
{-476, -144, 0x51253327, 0x23668738},
{-475, -143, 0x10250665, 0x44733747},
{-474, -143, 0x20501330, 0x89467495},
{-473, -143, 0x41002661, 0x78934990},
{-472, -143, 0x82005323, 0x57869980},
{-471, -142, 0x16401064, 0x71573996},
{-470, -142, 0x32802129, 0x43147992},
{-469, -142, 0x65604258, 0x86295985},
{-468, -141, 0x13120851, 0x77259197},
{-467, -141, 0x26241703, 0x54518394},
{-466, -141, 0x52483407, 0x09036788},
{-465, -140, 0x10496681, 0x41807357},
{-464, -140, 0x20993362, 0x83614715},
{-463, -140, 0x41986725, 0x67229430},
{-462, -140, 0x83973451, 0x34458861},
{-461, -139, 0x16794690, 0x26891772},
{-460, -139, 0x33589380, 0x53783544},
{-459, -139, 0x67178761, 0x07567088},
{-458, -138, 0x13435752, 0x21513417},
{-457, -138, 0x26871504, 0x43026835},
{-456, -138, 0x53743008, 0x86053671},
{-455, -137, 0x10748601, 0x77210734},
{-454, -137, 0x21497203, 0x54421468},
{-453, -137, 0x42994407, 0x08842937},
{-452, -137, 0x85988814, 0x17685875},
{-451, -136, 0x17197762, 0x83537174},
{-450, -136, 0x34395525, 0x67074349},
{-449, -136, 0x68791051, 0x34148698},
{-448, -135, 0x13758210, 0x26829739},
{-447, -135, 0x27516420, 0x53659479},
{-446, -135, 0x55032841, 0x07318958},
{-445, -134, 0x11006568, 0x21463791},
{-444, -134, 0x22013136, 0x42927583},
{-443, -134, 0x44026272, 0x85855166},
{-442, -134, 0x88052545, 0x71710332},
{-441, -133, 0x17610509, 0x14342066},
{-440, -133, 0x35221018, 0x28684133},
{-439, -133, 0x70442036, 0x57368266},
{-438, -132, 0x14088407, 0x31473653},
{-437, -132, 0x28176814, 0x62947306},
{-436, -132, 0x56353629, 0x25894614},
{-435, -131, 0x11270725, 0x85178922},
{-434, -131, 0x22541451, 0x70357845},
{-433, -131, 0x45082903, 0x40715691},
{-432, -131, 0x90165806, 0x81431383},
{-431, -130, 0x18033161, 0x36286276},
{-430, -130, 0x36066322, 0x72572553},
{-429, -130, 0x72132645, 0x45145106},
{-428, -129, 0x14426529, 0x09029021},
{-427, -129, 0x28853058, 0x18058042},
{-426, -129, 0x57706116, 0x36116085},
{-425, -128, 0x11541223, 0x27223217},
{-424, -128, 0x23082446, 0x54446434},
{-423, -128, 0x46164893, 0x08892867},
{-422, -128, 0x92329786, 0x17785735},
{-421, -127, 0x18465957, 0x23557147},
{-420, -127, 0x36931914, 0x47114294},
{-419, -127, 0x73863828, 0x94228589},
{-418, -126, 0x14772765, 0x78845717},
{-417, -126, 0x29545531, 0x57691435},
{-416, -126, 0x59091063, 0x15382870},
{-415, -125, 0x11818212, 0x63076574},
{-414, -125, 0x23636425, 0x26153148},
{-413, -125, 0x47272850, 0x52306297},
{-412, -125, 0x94545701, 0x04612594},
{-411, -124, 0x18909140, 0x20922518},
{-410, -124, 0x37818280, 0x41845037},
{-409, -124, 0x75636560, 0x83690074},
{-408, -123, 0x15127312, 0x16738014},
{-407, -123, 0x30254624, 0x33476029},
{-406, -123, 0x60509248, 0x66952059},
{-405, -122, 0x12101849, 0x73390412},
{-404, -122, 0x24203699, 0x46780824},
{-403, -122, 0x48407398, 0x93561647},
{-402, -122, 0x96814797, 0x87123294},
{-401, -121, 0x19362959, 0x57424659},
{-400, -121, 0x38725919, 0x14849318},
{-399, -121, 0x77451838, 0x29698636},
{-398, -120, 0x15490367, 0x65939727},
{-397, -120, 0x30980735, 0x31879454},
{-396, -120, 0x61961470, 0x63758908},
{-395, -119, 0x12392294, 0x12751781},
{-394, -119, 0x24784588, 0x25503563},
{-393, -119, 0x49569176, 0x51007126},
{-392, -119, 0x99138353, 0x02014253},
{-391, -118, 0x19827670, 0x60402850},
{-390, -118, 0x39655341, 0x20805701},
{-389, -118, 0x79310682, 0x41611403},
{-388, -117, 0x15862136, 0x48322280},
{-387, -117, 0x31724272, 0x96644561},
{-386, -117, 0x63448545, 0x93289123},
{-385, -116, 0x12689709, 0x18657824},
{-384, -116, 0x25379418, 0x37315649},
{-383, -116, 0x50758836, 0x74631298},
{-382, -115, 0x10151767, 0x34926259},
{-381, -115, 0x20303534, 0x69852519},
{-380, -115, 0x40607069, 0x39705038},
{-379, -115, 0x81214138, 0x79410077},
{-378, -114, 0x16242827, 0x75882015},
{-377, -114, 0x32485655, 0x51764031},
{-376, -114, 0x64971311, 0x03528062},
{-375, -113, 0x12994262, 0x20705612},
{-374, -113, 0x25988524, 0x41411224},
{-373, -113, 0x51977048, 0x82822450},
{-372, -112, 0x10395409, 0x76564490},
{-371, -112, 0x20790819, 0x53128980},
{-370, -112, 0x41581639, 0x06257960},
{-369, -112, 0x83163278, 0x12515920},
{-368, -111, 0x16632655, 0x62503183},
{-367, -111, 0x33265311, 0x25006367},
{-366, -111, 0x66530622, 0x50012735},
{-365, -110, 0x13306124, 0x50002547},
{-364, -110, 0x26612249, 0x00005094},
{-363, -110, 0x53224498, 0x00010188},
{-362, -109, 0x10644899, 0x60002037},
{-361, -109, 0x21289799, 0x20004075},
{-360, -109, 0x42579598, 0x40008150},
{-359, -109, 0x85159196, 0x80016301},
{-358, -108, 0x17031839, 0x36003260},
{-357, -108, 0x34063678, 0x72006520},
{-356, -108, 0x68127357, 0x44013040},
{-355, -107, 0x13625471, 0x48802608},
{-354, -107, 0x27250942, 0x97605216},
{-353, -107, 0x54501885, 0x95210432},
{-352, -106, 0x10900377, 0x19042086},
{-351, -106, 0x21800754, 0x38084173},
{-350, -106, 0x43601508, 0x76168346},
{-349, -106, 0x87203017, 0x52336692},
{-348, -105, 0x17440603, 0x50467338},
{-347, -105, 0x34881207, 0x00934676},
{-346, -105, 0x69762414, 0x01869353},
{-345, -104, 0x13952482, 0x80373870},
{-344, -104, 0x27904965, 0x60747741},
{-343, -104, 0x55809931, 0x21495483},
{-342, -103, 0x11161986, 0x24299096},
{-341, -103, 0x22323972, 0x48598193},
{-340, -103, 0x44647944, 0x97196387},
{-339, -103, 0x89295889, 0x94392774},
{-338, -102, 0x17859177, 0x98878554},
{-337, -102, 0x35718355, 0x97757109},
{-336, -102, 0x71436711, 0x95514218},
{-335, -101, 0x14287342, 0x39102843},
{-334, -101, 0x28574684, 0x78205687},
{-333, -101, 0x57149369, 0x56411375},
{-332, -100, 0x11429873, 0x91282274},
{-331, -100, 0x22859747, 0x82564549},
{-330, -100, 0x45719495, 0x65129099},
{-329, -100, 0x91438991, 0x30258199},
{-328, -99, 0x18287798, 0x26051639},
{-327, -99, 0x36575596, 0x52103279},
{-326, -99, 0x73151193, 0x04206558},
{-325, -98, 0x14630238, 0x60841311},
{-324, -98, 0x29260477, 0x21682623},
{-323, -98, 0x58520954, 0x43365247},
{-322, -97, 0x11704190, 0x88673049},
{-321, -97, 0x23408381, 0x77346099},
{-320, -97, 0x46816763, 0x54692198},
{-319, -97, 0x93633527, 0x09384397},
{-318, -96, 0x18726705, 0x41876879},
{-317, -96, 0x37453410, 0x83753758},
{-316, -96, 0x74906821, 0x67507517},
{-315, -95, 0x14981364, 0x33501503},
{-314, -95, 0x29962728, 0x67003006},
{-313, -95, 0x59925457, 0x34006013},
{-312, -94, 0x11985091, 0x46801202},
{-311, -94, 0x23970182, 0x93602405},
{-310, -94, 0x47940365, 0x87204811},
{-309, -94, 0x95880731, 0x74409622},
{-308, -93, 0x19176146, 0x34881924},
{-307, -93, 0x38352292, 0x69763849},
{-306, -93, 0x76704585, 0x39527698},
{-305, -92, 0x15340917, 0x07905539},
{-304, -92, 0x30681834, 0x15811079},
{-303, -92, 0x61363668, 0x31622157},
{-302, -91, 0x12272733, 0x66324431},
{-301, -91, 0x24545467, 0x32648862},
{-300, -91, 0x49090934, 0x65297726},
{-299, -91, 0x98181869, 0x30595452},
{-298, -90, 0x19636373, 0x86119090},
{-297, -90, 0x39272747, 0x72238181},
{-296, -90, 0x78545495, 0x44476362},
{-295, -89, 0x15709099, 0x08895272},
{-294, -89, 0x31418198, 0x17790544},
{-293, -89, 0x62836396, 0x35581089},
{-292, -88, 0x12567279, 0x27116217},
{-291, -88, 0x25134558, 0x54232435},
{-290, -88, 0x50269117, 0x08464871},
{-289, -87, 0x10053823, 0x41692974},
{-288, -87, 0x20107646, 0x83385948},
{-287, -87, 0x40215293, 0x66771898},
{-286, -87, 0x80430587, 0x33543796},
{-285, -86, 0x16086117, 0x46708759},
{-284, -86, 0x32172234, 0x93417518},
{-283, -86, 0x64344469, 0x86835036},
{-282, -85, 0x12868893, 0x97367007},
{-281, -85, 0x25737787, 0x94734014},
{-280, -85, 0x51475575, 0x89468029},
{-279, -84, 0x10295115, 0x17893605},
{-278, -84, 0x20590230, 0x35787211},
{-277, -84, 0x41180460, 0x71574422},
{-276, -84, 0x82360921, 0x43148845},
{-275, -83, 0x16472184, 0x28629769},
{-274, -83, 0x32944368, 0x57259538},
{-273, -83, 0x65888737, 0x14519076},
{-272, -82, 0x13177747, 0x42903815},
{-271, -82, 0x26355494, 0x85807630},
{-270, -82, 0x52710989, 0x71615262},
{-269, -81, 0x10542197, 0x94323052},
{-268, -81, 0x21084395, 0x88646104},
{-267, -81, 0x42168791, 0x77292209},
{-266, -81, 0x84337583, 0x54584418},
{-265, -80, 0x16867516, 0x70916883},
{-264, -80, 0x33735033, 0x41833767},
{-263, -80, 0x67470066, 0x83667534},
{-262, -79, 0x13494013, 0x36733506},
{-261, -79, 0x26988026, 0x73467013},
{-260, -79, 0x53976053, 0x46934027},
{-259, -78, 0x10795210, 0x69386805},
{-258, -78, 0x21590421, 0x38773611},
{-257, -78, 0x43180842, 0x77547222},
{-256, -78, 0x86361685, 0x55094445},
{-255, -77, 0x17272337, 0x11018889},
{-254, -77, 0x34544674, 0x22037777},
{-253, -77, 0x69089348, 0x44075554},
{-252, -76, 0x13817869, 0x68815111},
{-251, -76, 0x27635739, 0x37630222},
{-250, -76, 0x55271478, 0x75260445},
{-249, -75, 0x11054295, 0x75052089},
{-248, -75, 0x22108591, 0x50104177},
{-247, -75, 0x44217183, 0x00208355},
{-246, -75, 0x88434366, 0x00416711},
{-245, -74, 0x17686873, 0x20083342},
{-244, -74, 0x35373746, 0x40166684},
{-243, -74, 0x70747492, 0x80333368},
{-242, -73, 0x14149498, 0x56066673},
{-241, -73, 0x28298997, 0x12133347},
{-240, -73, 0x56597994, 0x24266694},
{-239, -72, 0x11319598, 0x84853338},
{-238, -72, 0x22639197, 0x69706677},
{-237, -72, 0x45278395, 0x39413356},
{-236, -72, 0x90556790, 0x78826712},
{-235, -71, 0x18111358, 0x15765342},
{-234, -71, 0x36222716, 0x31530685},
{-233, -71, 0x72445432, 0x63061370},
{-232, -70, 0x14489086, 0x52612274},
{-231, -70, 0x28978173, 0x05224548},
{-230, -70, 0x57956346, 0x10449096},
{-229, -69, 0x11591269, 0x22089819},
{-228, -69, 0x23182538, 0x44179638},
{-227, -69, 0x46365076, 0x88359276},
{-226, -69, 0x92730153, 0x76718553},
{-225, -68, 0x18546030, 0x75343710},
{-224, -68, 0x37092061, 0x50687420},
{-223, -68, 0x74184123, 0x01374841},
{-222, -67, 0x14836824, 0x60274968},
{-221, -67, 0x29673649, 0x20549936},
{-220, -67, 0x59347298, 0x41099873},
{-219, -66, 0x11869459, 0x68219974},
{-218, -66, 0x23738919, 0x36439949},
{-217, -66, 0x47477838, 0x72879900},
{-216, -66, 0x94955677, 0x45759800},
{-215, -65, 0x18991135, 0x49151960},
{-214, -65, 0x37982270, 0x98303919},
{-213, -65, 0x75964541, 0x96607839},
{-212, -64, 0x15192908, 0x39321567},
{-211, -64, 0x30385816, 0x78643135},
{-210, -64, 0x60771633, 0x57286271},
{-209, -63, 0x12154326, 0x71457254},
{-208, -63, 0x24308653, 0x42914508},
{-207, -63, 0x48617306, 0x85829016},
{-206, -63, 0x97234613, 0x71658033},
{-205, -62, 0x19446922, 0x74331606},
{-204, -62, 0x38893845, 0x48663213},
{-203, -62, 0x77787690, 0x97326426},
{-202, -61, 0x15557538, 0x19465285},
{-201, -61, 0x31115076, 0x38930570},
{-200, -61, 0x62230152, 0x77861141},
{-199, -60, 0x12446030, 0x55572228},
{-198, -60, 0x24892061, 0x11144456},
{-197, -60, 0x49784122, 0x22288913},
{-196, -60, 0x99568244, 0x44577826},
{-195, -59, 0x19913648, 0x88915565},
{-194, -59, 0x39827297, 0x77831129},
{-193, -59, 0x79654595, 0x55662259},
{-192, -58, 0x15930919, 0x11132452},
{-191, -58, 0x31861838, 0x22264904},
{-190, -58, 0x63723676, 0x44529809},
{-189, -57, 0x12744735, 0x28905961},
{-188, -57, 0x25489470, 0x57811923},
{-187, -57, 0x50978941, 0x15623846},
{-186, -56, 0x10195788, 0x23124769},
{-185, -56, 0x20391576, 0x46249538},
{-184, -56, 0x40783152, 0x92499078},
{-183, -56, 0x81566305, 0x84998156},
{-182, -55, 0x16313261, 0x16999631},
{-181, -55, 0x32626522, 0x33999262},
{-180, -55, 0x65253044, 0x67998525},
{-179, -54, 0x13050608, 0x93599704},
{-178, -54, 0x26101217, 0x87199409},
{-177, -54, 0x52202435, 0x74398819},
{-176, -53, 0x10440487, 0x14879763},
{-175, -53, 0x20880974, 0x29759527},
{-174, -53, 0x41761948, 0x59519055},
{-173, -53, 0x83523897, 0x19038111},
{-172, -52, 0x16704779, 0x43807622},
{-171, -52, 0x33409558, 0x87615244},
{-170, -52, 0x66819117, 0x75230489},
{-169, -51, 0x13363823, 0x55046097},
{-168, -51, 0x26727647, 0x10092195},
{-167, -51, 0x53455294, 0x20184391},
{-166, -50, 0x10691058, 0x84036878},
{-165, -50, 0x21382117, 0x68073756},
{-164, -50, 0x42764235, 0x36147513},
{-163, -50, 0x85528470, 0x72295026},
{-162, -49, 0x17105694, 0x14459005},
{-161, -49, 0x34211388, 0x28918010},
{-160, -49, 0x68422776, 0x57836021},
{-159, -48, 0x13684555, 0x31567204},
{-158, -48, 0x27369110, 0x63134408},
{-157, -48, 0x54738221, 0x26268816},
{-156, -47, 0x10947644, 0x25253763},
{-155, -47, 0x21895288, 0x50507526},
{-154, -47, 0x43790577, 0x01015053},
{-153, -47, 0x87581154, 0x02030106},
{-152, -46, 0x17516230, 0x80406021},
{-151, -46, 0x35032461, 0x60812042},
{-150, -46, 0x70064923, 0x21624085},
{-149, -45, 0x14012984, 0x64324817},
{-148, -45, 0x28025969, 0x28649634},
{-147, -45, 0x56051938, 0x57299268},
{-146, -44, 0x11210387, 0x71459853},
{-145, -44, 0x22420775, 0x42919707},
{-144, -44, 0x44841550, 0x85839414},
{-143, -44, 0x89683101, 0x71678828},
{-142, -43, 0x17936620, 0x34335765},
{-141, -43, 0x35873240, 0x68671531},
{-140, -43, 0x71746481, 0x37343062},
{-139, -42, 0x14349296, 0x27468612},
{-138, -42, 0x28698592, 0x54937224},
{-137, -42, 0x57397185, 0x09874450},
{-136, -41, 0x11479437, 0x01974890},
{-135, -41, 0x22958874, 0x03949780},
{-134, -41, 0x45917748, 0x07899561},
{-133, -41, 0x91835496, 0x15799122},
{-132, -40, 0x18367099, 0x23159824},
{-131, -40, 0x36734198, 0x46319648},
{-130, -40, 0x73468396, 0x92639296},
{-129, -39, 0x14693679, 0x38527859},
{-128, -39, 0x29387358, 0x77055718},
{-127, -39, 0x58774717, 0x54111437},
{-126, -38, 0x11754943, 0x50822287},
{-125, -38, 0x23509887, 0x01644574},
{-124, -38, 0x47019774, 0x03289149},
{-123, -38, 0x94039548, 0x06578298},
{-122, -37, 0x18807909, 0x61315659},
{-121, -37, 0x37615819, 0x22631319},
{-120, -37, 0x75231638, 0x45262639},
{-119, -36, 0x15046327, 0x69052527},
{-118, -36, 0x30092655, 0x38105055},
{-117, -36, 0x60185310, 0x76210111},
{-116, -35, 0x12037062, 0x15242022},
{-115, -35, 0x24074124, 0x30484044},
{-114, -35, 0x48148248, 0x60968089},
{-113, -35, 0x96296497, 0x21936179},
{-112, -34, 0x19259299, 0x44387236},
{-111, -34, 0x38518598, 0x88774471},
{-110, -34, 0x77037197, 0x77548942},
{-109, -33, 0x15407439, 0x55509788},
{-108, -33, 0x30814879, 0x11019576},
{-107, -33, 0x61629758, 0x22039155},
{-106, -32, 0x12325951, 0x64407831},
{-105, -32, 0x24651903, 0x28815662},
{-104, -32, 0x49303806, 0x57631323},
{-103, -32, 0x98607613, 0x15262647},
{-102, -31, 0x19721522, 0x63052529},
{-101, -31, 0x39443045, 0x26105058},
{-100, -31, 0x78886090, 0x52210117},
{-99, -30, 0x15777218, 0x10442023},
{-98, -30, 0x31554436, 0x20884046},
{-97, -30, 0x63108872, 0x41768093},
{-96, -29, 0x12621774, 0x48353618},
{-95, -29, 0x25243548, 0x96707237},
{-94, -29, 0x50487097, 0x93414475},
{-93, -28, 0x10097419, 0x58682895},
{-92, -28, 0x20194839, 0x17365790},
{-91, -28, 0x40389678, 0x34731580},
{-90, -28, 0x80779356, 0x69463160},
{-89, -27, 0x16155871, 0x33892632},
{-88, -27, 0x32311742, 0x67785263},
{-87, -27, 0x64623485, 0x35570527},
{-86, -26, 0x12924697, 0x07114105},
{-85, -26, 0x25849394, 0x14228211},
{-84, -26, 0x51698788, 0x28456422},
{-83, -25, 0x10339757, 0x65691284},
{-82, -25, 0x20679515, 0x31382568},
{-81, -25, 0x41359030, 0x62765138},
{-80, -25, 0x82718061, 0x25530276},
{-79, -24, 0x16543612, 0x25106055},
{-78, -24, 0x33087224, 0x50212110},
{-77, -24, 0x66174449, 0x00424220},
{-76, -23, 0x13234889, 0x80084844},
{-75, -23, 0x26469779, 0x60169688},
{-74, -23, 0x52939559, 0x20339377},
{-73, -22, 0x10587911, 0x84067875},
{-72, -22, 0x21175823, 0x68135750},
{-71, -22, 0x42351647, 0x36271501},
{-70, -22, 0x84703294, 0x72543002},
{-69, -21, 0x16940658, 0x94508600},
{-68, -21, 0x33881317, 0x89017200},
{-67, -21, 0x67762635, 0x78034401},
{-66, -20, 0x13552527, 0x15606880},
{-65, -20, 0x27105054, 0x31213760},
{-64, -20, 0x54210108, 0x62427522},
{-63, -19, 0x10842021, 0x72485504},
{-62, -19, 0x21684043, 0x44971008},
{-61, -19, 0x43368086, 0x89942017},
{-60, -19, 0x86736173, 0x79884034},
{-59, -18, 0x17347234, 0x75976806},
{-58, -18, 0x34694469, 0x51953614},
{-57, -18, 0x69388939, 0x03907229},
{-56, -17, 0x13877787, 0x80781445},
{-55, -17, 0x27755575, 0x61562891},
{-54, -17, 0x55511151, 0x23125782},
{-53, -16, 0x11102230, 0x24625156},
{-52, -16, 0x22204460, 0x49250313},
{-51, -16, 0x44408920, 0x98500625},
{-50, -16, 0x88817841, 0x97001251},
{-49, -15, 0x17763568, 0x39400250},
{-48, -15, 0x35527136, 0x78800500},
{-47, -15, 0x71054273, 0x57601001},
{-46, -14, 0x14210854, 0x71520200},
{-45, -14, 0x28421709, 0x43040400},
{-44, -14, 0x56843418, 0x86080801},
{-43, -13, 0x11368683, 0x77216160},
{-42, -13, 0x22737367, 0x54432320},
{-41, -13, 0x45474735, 0x08864641},
{-40, -13, 0x90949470, 0x17729282},
{-39, -12, 0x18189894, 0x03545856},
{-38, -12, 0x36379788, 0x07091712},
{-37, -12, 0x72759576, 0x14183424},
{-36, -11, 0x14551915, 0x22836684},
{-35, -11, 0x29103830, 0x45673369},
{-34, -11, 0x58207660, 0x91346740},
{-33, -10, 0x11641532, 0x18269348},
{-32, -10, 0x23283064, 0x36538696},
{-31, -10, 0x46566128, 0x73077392},
{-30, -10, 0x93132257, 0x46154784},
{-29, -9, 0x18626451, 0x49230956},
{-28, -9, 0x37252902, 0x98461914},
{-27, -9, 0x74505805, 0x96923828},
{-26, -8, 0x14901161, 0x19384765},
{-25, -8, 0x29802322, 0x38769531},
{-24, -8, 0x59604644, 0x77539062},
{-23, -7, 0x11920928, 0x95507812},
{-22, -7, 0x23841857, 0x91015625},
{-21, -7, 0x47683715, 0x82031250},
{-20, -7, 0x95367431, 0x64062500},
{-19, -6, 0x19073486, 0x32812500},
{-18, -6, 0x38146972, 0x65625000},
{-17, -6, 0x76293945, 0x31250001},
{-16, -5, 0x15258789, 0x06250000},
{-15, -5, 0x30517578, 0x12500000},
{-14, -5, 0x61035156, 0x25000000},
{-13, -4, 0x12207031, 0x25000000},
{-12, -4, 0x24414062, 0x50000000},
{-11, -4, 0x48828125, 0x00000000},
{-10, -4, 0x97656250, 0x00000000},
{-9, -3, 0x19531250, 0x00000000},
{-8, -3, 0x39062500, 0x00000000},
{-7, -3, 0x78125000, 0x00000000},
{-6, -2, 0x15625000, 0x00000000},
{-5, -2, 0x31250000, 0x00000000},
{-4, -2, 0x62500000, 0x00000000},
{-3, -1, 0x12500000, 0x00000000},
{-2, -1, 0x25000000, 0x00000000},
{-1, -1, 0x50000000, 0x00000000},
{0, 0, 0x10000000, 0x00000000},
{1, 0, 0x20000000, 0x00000000},
{2, 0, 0x40000000, 0x00000000},
{3, 0, 0x80000000, 0x00000000},
{4, 1, 0x16000000, 0x00000000},
{5, 1, 0x32000000, 0x00000000},
{6, 1, 0x64000000, 0x00000000},
{7, 2, 0x12800000, 0x00000000},
{8, 2, 0x25600000, 0x00000000},
{9, 2, 0x51200000, 0x00000000},
{10, 3, 0x10240000, 0x00000000},
{11, 3, 0x20480000, 0x00000000},
{12, 3, 0x40960000, 0x00000000},
{13, 3, 0x81920000, 0x00000000},
{14, 4, 0x16384000, 0x00000000},
{15, 4, 0x32768000, 0x00000000},
{16, 4, 0x65536000, 0x00000001},
{17, 5, 0x13107200, 0x00000000},
{18, 5, 0x26214400, 0x00000000},
{19, 5, 0x52428799, 0x99999999},
{20, 6, 0x10485759, 0x99999999},
{21, 6, 0x20971519, 0x99999999},
{22, 6, 0x41943039, 0x99999999},
{23, 6, 0x83886079, 0x99999999},
{24, 7, 0x16777216, 0x00000000},
{25, 7, 0x33554432, 0x00000000},
{26, 7, 0x67108864, 0x00000000},
{27, 8, 0x13421772, 0x80000000},
{28, 8, 0x26843545, 0x60000000},
{29, 8, 0x53687091, 0x20000000},
{30, 9, 0x10737418, 0x24000000},
{31, 9, 0x21474836, 0x48000000},
{32, 9, 0x42949672, 0x96000000},
{33, 9, 0x85899345, 0x92000001},
{34, 10, 0x17179869, 0x18400000},
{35, 10, 0x34359738, 0x36799999},
{36, 10, 0x68719476, 0x73599999},
{37, 11, 0x13743895, 0x34719999},
{38, 11, 0x27487790, 0x69439999},
{39, 11, 0x54975581, 0x38879999},
{40, 12, 0x10995116, 0x27776000},
{41, 12, 0x21990232, 0x55552000},
{42, 12, 0x43980465, 0x11104000},
{43, 12, 0x87960930, 0x22208000},
{44, 13, 0x17592186, 0x04441600},
{45, 13, 0x35184372, 0x08883200},
{46, 13, 0x70368744, 0x17766401},
{47, 14, 0x14073748, 0x83553280},
{48, 14, 0x28147497, 0x67106560},
{49, 14, 0x56294995, 0x34213120},
{50, 15, 0x11258999, 0x06842624},
{51, 15, 0x22517998, 0x13685248},
{52, 15, 0x45035996, 0x27370495},
{53, 15, 0x90071992, 0x54740991},
{54, 16, 0x18014398, 0x50948198},
{55, 16, 0x36028797, 0x01896397},
{56, 16, 0x72057594, 0x03792794},
{57, 17, 0x14411518, 0x80758558},
{58, 17, 0x28823037, 0x61517117},
{59, 17, 0x57646075, 0x23034235},
{60, 18, 0x11529215, 0x04606847},
{61, 18, 0x23058430, 0x09213694},
{62, 18, 0x46116860, 0x18427387},
{63, 18, 0x92233720, 0x36854775},
{64, 19, 0x18446744, 0x07370955},
{65, 19, 0x36893488, 0x14741910},
{66, 19, 0x73786976, 0x29483820},
{67, 20, 0x14757395, 0x25896763},
{68, 20, 0x29514790, 0x51793527},
{69, 20, 0x59029581, 0x03587055},
{70, 21, 0x11805916, 0x20717411},
{71, 21, 0x23611832, 0x41434822},
{72, 21, 0x47223664, 0x82869645},
{73, 21, 0x94447329, 0x65739290},
{74, 22, 0x18889465, 0x93147858},
{75, 22, 0x37778931, 0x86295716},
{76, 22, 0x75557863, 0x72591433},
{77, 23, 0x15111572, 0x74518286},
{78, 23, 0x30223145, 0x49036573},
{79, 23, 0x60446290, 0x98073146},
{80, 24, 0x12089258, 0x19614629},
{81, 24, 0x24178516, 0x39229258},
{82, 24, 0x48357032, 0x78458516},
{83, 24, 0x96714065, 0x56917032},
{84, 25, 0x19342813, 0x11383406},
{85, 25, 0x38685626, 0x22766812},
{86, 25, 0x77371252, 0x45533625},
{87, 26, 0x15474250, 0x49106725},
{88, 26, 0x30948500, 0x98213450},
{89, 26, 0x61897001, 0x96426901},
{90, 27, 0x12379400, 0x39285380},
{91, 27, 0x24758800, 0x78570760},
{92, 27, 0x49517601, 0x57141521},
{93, 27, 0x99035203, 0x14283043},
{94, 28, 0x19807040, 0x62856608},
{95, 28, 0x39614081, 0x25713216},
{96, 28, 0x79228162, 0x51426433},
{97, 29, 0x15845632, 0x50285286},
{98, 29, 0x31691265, 0x00570573},
{99, 29, 0x63382530, 0x01141146},
{100, 30, 0x12676506, 0x00228229},
{101, 30, 0x25353012, 0x00456458},
{102, 30, 0x50706024, 0x00912918},
{103, 31, 0x10141204, 0x80182583},
{104, 31, 0x20282409, 0x60365167},
{105, 31, 0x40564819, 0x20730333},
{106, 31, 0x81129638, 0x41460667},
{107, 32, 0x16225927, 0x68292133},
{108, 32, 0x32451855, 0x36584267},
{109, 32, 0x64903710, 0x73168534},
{110, 33, 0x12980742, 0x14633707},
{111, 33, 0x25961484, 0x29267414},
{112, 33, 0x51922968, 0x58534827},
{113, 34, 0x10384593, 0x71706965},
{114, 34, 0x20769187, 0x43413930},
{115, 34, 0x41538374, 0x86827861},
{116, 34, 0x83076749, 0x73655723},
{117, 35, 0x16615349, 0x94731144},
{118, 35, 0x33230699, 0x89462289},
{119, 35, 0x66461399, 0x78924578},
{120, 36, 0x13292279, 0x95784915},
{121, 36, 0x26584559, 0x91569831},
{122, 36, 0x53169119, 0x83139663},
{123, 37, 0x10633823, 0x96627932},
{124, 37, 0x21267647, 0x93255865},
{125, 37, 0x42535295, 0x86511730},
{126, 37, 0x85070591, 0x73023461},
{127, 38, 0x17014118, 0x34604692},
{128, 38, 0x34028236, 0x69209384},
{129, 38, 0x68056473, 0x38418768},
{130, 39, 0x13611294, 0x67683753},
{131, 39, 0x27222589, 0x35367507},
{132, 39, 0x54445178, 0x70735015},
{133, 40, 0x10889035, 0x74147002},
{134, 40, 0x21778071, 0x48294005},
{135, 40, 0x43556142, 0x96588012},
{136, 40, 0x87112285, 0x93176024},
{137, 41, 0x17422457, 0x18635205},
{138, 41, 0x34844914, 0x37270410},
{139, 41, 0x69689828, 0x74540819},
{140, 42, 0x13937965, 0x74908164},
{141, 42, 0x27875931, 0x49816328},
{142, 42, 0x55751862, 0x99632656},
{143, 43, 0x11150372, 0x59926531},
{144, 43, 0x22300745, 0x19853062},
{145, 43, 0x44601490, 0x39706124},
{146, 43, 0x89202980, 0x79412248},
{147, 44, 0x17840596, 0x15882449},
{148, 44, 0x35681192, 0x31764900},
{149, 44, 0x71362384, 0x63529800},
{150, 45, 0x14272476, 0x92705960},
{151, 45, 0x28544953, 0x85411920},
{152, 45, 0x57089907, 0x70823839},
{153, 46, 0x11417981, 0x54164767},
{154, 46, 0x22835963, 0x08329535},
{155, 46, 0x45671926, 0x16659071},
{156, 46, 0x91343852, 0x33318143},
{157, 47, 0x18268770, 0x46663628},
{158, 47, 0x36537540, 0x93327257},
{159, 47, 0x73075081, 0x86654514},
{160, 48, 0x14615016, 0x37330902},
{161, 48, 0x29230032, 0x74661805},
{162, 48, 0x58460065, 0x49323611},
{163, 49, 0x11692013, 0x09864722},
{164, 49, 0x23384026, 0x19729444},
{165, 49, 0x46768052, 0x39458888},
{166, 49, 0x93536104, 0x78917777},
{167, 50, 0x18707220, 0x95783555},
{168, 50, 0x37414441, 0x91567111},
{169, 50, 0x74828883, 0x83134223},
{170, 51, 0x14965776, 0x76626844},
{171, 51, 0x29931553, 0x53253689},
{172, 51, 0x59863107, 0x06507378},
{173, 52, 0x11972621, 0x41301475},
{174, 52, 0x23945242, 0x82602951},
{175, 52, 0x47890485, 0x65205902},
{176, 52, 0x95780971, 0x30411805},
{177, 53, 0x19156194, 0x26082361},
{178, 53, 0x38312388, 0x52164721},
{179, 53, 0x76624777, 0x04329442},
{180, 54, 0x15324955, 0x40865888},
{181, 54, 0x30649910, 0x81731777},
{182, 54, 0x61299821, 0x63463555},
{183, 55, 0x12259964, 0x32692711},
{184, 55, 0x24519928, 0x65385422},
{185, 55, 0x49039857, 0x30770843},
{186, 55, 0x98079714, 0x61541687},
{187, 56, 0x19615942, 0x92308337},
{188, 56, 0x39231885, 0x84616675},
{189, 56, 0x78463771, 0x69233351},
{190, 57, 0x15692754, 0x33846670},
{191, 57, 0x31385508, 0x67693340},
{192, 57, 0x62771017, 0x35386679},
{193, 58, 0x12554203, 0x47077335},
{194, 58, 0x25108406, 0x94154671},
{195, 58, 0x50216813, 0x88309344},
{196, 59, 0x10043362, 0x77661868},
{197, 59, 0x20086725, 0x55323737},
{198, 59, 0x40173451, 0x10647475},
{199, 59, 0x80346902, 0x21294951},
{200, 60, 0x16069380, 0x44258990},
{201, 60, 0x32138760, 0x88517980},
{202, 60, 0x64277521, 0x77035960},
{203, 61, 0x12855504, 0x35407191},
{204, 61, 0x25711008, 0x70814383},
{205, 61, 0x51422017, 0x41628769},
{206, 62, 0x10284403, 0x48325753},
{207, 62, 0x20568806, 0x96651507},
{208, 62, 0x41137613, 0x93303014},
{209, 62, 0x82275227, 0x86606029},
{210, 63, 0x16455045, 0x57321205},
{211, 63, 0x32910091, 0x14642411},
{212, 63, 0x65820182, 0x29284823},
{213, 64, 0x13164036, 0x45856964},
{214, 64, 0x26328072, 0x91713929},
{215, 64, 0x52656145, 0x83427858},
{216, 65, 0x10531229, 0x16685571},
{217, 65, 0x21062458, 0x33371143},
{218, 65, 0x42124916, 0x66742287},
{219, 65, 0x84249833, 0x33484575},
{220, 66, 0x16849966, 0x66696915},
{221, 66, 0x33699933, 0x33393829},
{222, 66, 0x67399866, 0x66787658},
{223, 67, 0x13479973, 0x33357531},
{224, 67, 0x26959946, 0x66715063},
{225, 67, 0x53919893, 0x33430128},
{226, 68, 0x10783978, 0x66686025},
{227, 68, 0x21567957, 0x33372051},
{228, 68, 0x43135914, 0x66744102},
{229, 68, 0x86271829, 0x33488204},
{230, 69, 0x17254365, 0x86697640},
{231, 69, 0x34508731, 0x73395282},
{232, 69, 0x69017463, 0x46790564},
{233, 70, 0x13803492, 0x69358112},
{234, 70, 0x27606985, 0x38716225},
{235, 70, 0x55213970, 0x77432450},
{236, 71, 0x11042794, 0x15486490},
{237, 71, 0x22085588, 0x30972980},
{238, 71, 0x44171176, 0x61945961},
{239, 71, 0x88342353, 0x23891923},
{240, 72, 0x17668470, 0x64778384},
{241, 72, 0x35336941, 0x29556768},
{242, 72, 0x70673882, 0x59113537},
{243, 73, 0x14134776, 0x51822707},
{244, 73, 0x28269553, 0x03645414},
{245, 73, 0x56539106, 0x07290829},
{246, 74, 0x11307821, 0x21458165},
{247, 74, 0x22615642, 0x42916331},
{248, 74, 0x45231284, 0x85832664},
{249, 74, 0x90462569, 0x71665328},
{250, 75, 0x18092513, 0x94333065},
{251, 75, 0x36185027, 0x88666130},
{252, 75, 0x72370055, 0x77332261},
{253, 76, 0x14474011, 0x15466452},
{254, 76, 0x28948022, 0x30932904},
{255, 76, 0x57896044, 0x61865809},
{256, 77, 0x11579208, 0x92373161},
{257, 77, 0x23158417, 0x84746323},
{258, 77, 0x46316835, 0x69492647},
{259, 77, 0x92633671, 0x38985295},
{260, 78, 0x18526734, 0x27797059},
{261, 78, 0x37053468, 0x55594118},
{262, 78, 0x74106937, 0x11188236},
{263, 79, 0x14821387, 0x42237647},
{264, 79, 0x29642774, 0x84475294},
{265, 79, 0x59285549, 0x68950588},
{266, 80, 0x11857109, 0x93790117},
{267, 80, 0x23714219, 0x87580235},
{268, 80, 0x47428439, 0x75160471},
{269, 80, 0x94856879, 0x50320943},
{270, 81, 0x18971375, 0x90064188},
{271, 81, 0x37942751, 0x80128376},
{272, 81, 0x75885503, 0x60256753},
{273, 82, 0x15177100, 0x72051350},
{274, 82, 0x30354201, 0x44102701},
{275, 82, 0x60708402, 0x88205403},
{276, 83, 0x12141680, 0x57641080},
{277, 83, 0x24283361, 0x15282161},
{278, 83, 0x48566722, 0x30564322},
{279, 83, 0x97133444, 0x61128645},
{280, 84, 0x19426688, 0x92225729},
{281, 84, 0x38853377, 0x84451458},
{282, 84, 0x77706755, 0x68902916},
{283, 85, 0x15541351, 0x13780583},
{284, 85, 0x31082702, 0x27561166},
{285, 85, 0x62165404, 0x55122332},
{286, 86, 0x12433080, 0x91024466},
{287, 86, 0x24866161, 0x82048932},
{288, 86, 0x49732323, 0x64097867},
{289, 86, 0x99464647, 0x28195734},
{290, 87, 0x19892929, 0x45639146},
{291, 87, 0x39785858, 0x91278293},
{292, 87, 0x79571717, 0x82556586},
{293, 88, 0x15914343, 0x56511317},
{294, 88, 0x31828687, 0x13022634},
{295, 88, 0x63657374, 0x26045269},
{296, 89, 0x12731474, 0x85209053},
{297, 89, 0x25462949, 0x70418107},
{298, 89, 0x50925899, 0x40836215},
{299, 90, 0x10185179, 0x88167243},
{300, 90, 0x20370359, 0x76334486},
{301, 90, 0x40740719, 0x52668971},
{302, 90, 0x81481439, 0x05337943},
{303, 91, 0x16296287, 0x81067588},
{304, 91, 0x32592575, 0x62135177},
{305, 91, 0x65185151, 0x24270354},
{306, 92, 0x13037030, 0x24854070},
{307, 92, 0x26074060, 0x49708141},
{308, 92, 0x52148120, 0x99416283},
{309, 93, 0x10429624, 0x19883256},
{310, 93, 0x20859248, 0x39766513},
{311, 93, 0x41718496, 0x79533027},
{312, 93, 0x83436993, 0x59066054},
{313, 94, 0x16687398, 0x71813210},
{314, 94, 0x33374797, 0x43626421},
{315, 94, 0x66749594, 0x87252842},
{316, 95, 0x13349918, 0x97450568},
{317, 95, 0x26699837, 0x94901137},
{318, 95, 0x53399675, 0x89802274},
{319, 96, 0x10679935, 0x17960454},
{320, 96, 0x21359870, 0x35920909},
{321, 96, 0x42719740, 0x71841819},
{322, 96, 0x85439481, 0x43683639},
{323, 97, 0x17087896, 0x28736727},
{324, 97, 0x34175792, 0x57473456},
{325, 97, 0x68351585, 0x14946912},
{326, 98, 0x13670317, 0x02989382},
{327, 98, 0x27340634, 0x05978764},
{328, 98, 0x54681268, 0x11957529},
{329, 99, 0x10936253, 0x62391505},
{330, 99, 0x21872507, 0x24783011},
{331, 99, 0x43745014, 0x49566023},
{332, 99, 0x87490028, 0x99132047},
{333, 100, 0x17498005, 0x79826409},
{334, 100, 0x34996011, 0x59652819},
{335, 100, 0x69992023, 0x19305639},
{336, 101, 0x13998404, 0x63861127},
{337, 101, 0x27996809, 0x27722255},
{338, 101, 0x55993618, 0x55444510},
{339, 102, 0x11198723, 0x71088902},
{340, 102, 0x22397447, 0x42177804},
{341, 102, 0x44794894, 0x84355608},
{342, 102, 0x89589789, 0x68711216},
{343, 103, 0x17917957, 0x93742243},
{344, 103, 0x35835915, 0x87484486},
{345, 103, 0x71671831, 0x74968972},
{346, 104, 0x14334366, 0x34993794},
{347, 104, 0x28668732, 0x69987589},
{348, 104, 0x57337465, 0x39975178},
{349, 105, 0x11467493, 0x07995035},
{350, 105, 0x22934986, 0x15990071},
{351, 105, 0x45869972, 0x31980143},
{352, 105, 0x91739944, 0x63960286},
{353, 106, 0x18347988, 0x92792057},
{354, 106, 0x36695977, 0x85584114},
{355, 106, 0x73391955, 0x71168228},
{356, 107, 0x14678391, 0x14233645},
{357, 107, 0x29356782, 0x28467291},
{358, 107, 0x58713564, 0x56934583},
{359, 108, 0x11742712, 0x91386916},
{360, 108, 0x23485425, 0x82773833},
{361, 108, 0x46970851, 0x65547666},
{362, 108, 0x93941703, 0x31095332},
{363, 109, 0x18788340, 0x66219066},
{364, 109, 0x37576681, 0x32438132},
{365, 109, 0x75153362, 0x64876265},
{366, 110, 0x15030672, 0x52975253},
{367, 110, 0x30061345, 0x05950506},
{368, 110, 0x60122690, 0x11901013},
{369, 111, 0x12024538, 0x02380202},
{370, 111, 0x24049076, 0x04760405},
{371, 111, 0x48098152, 0x09520811},
{372, 111, 0x96196304, 0x19041622},
{373, 112, 0x19239260, 0x83808324},
{374, 112, 0x38478521, 0x67616648},
{375, 112, 0x76957043, 0x35233297},
{376, 113, 0x15391408, 0x67046659},
{377, 113, 0x30782817, 0x34093318},
{378, 113, 0x61565634, 0x68186637},
{379, 114, 0x12313126, 0x93637327},
{380, 114, 0x24626253, 0x87274655},
{381, 114, 0x49252507, 0x74549310},
{382, 114, 0x98505015, 0x49098620},
{383, 115, 0x19701003, 0x09819723},
{384, 115, 0x39402006, 0x19639447},
{385, 115, 0x78804012, 0x39278895},
{386, 116, 0x15760802, 0x47855779},
{387, 116, 0x31521604, 0x95711558},
{388, 116, 0x63043209, 0x91423116},
{389, 117, 0x12608641, 0x98284623},
{390, 117, 0x25217283, 0x96569246},
{391, 117, 0x50434567, 0x93138493},
{392, 118, 0x10086913, 0x58627698},
{393, 118, 0x20173827, 0x17255397},
{394, 118, 0x40347654, 0x34510794},
{395, 118, 0x80695308, 0x69021589},
{396, 119, 0x16139061, 0x73804317},
{397, 119, 0x32278123, 0x47608635},
{398, 119, 0x64556246, 0x95217271},
{399, 120, 0x12911249, 0x39043454},
{400, 120, 0x25822498, 0x78086908},
{401, 120, 0x51644997, 0x56173817},
{402, 121, 0x10328999, 0x51234763},
{403, 121, 0x20657999, 0x02469526},
{404, 121, 0x41315998, 0x04939053},
{405, 121, 0x82631996, 0x09878106},
{406, 122, 0x16526399, 0x21975621},
{407, 122, 0x33052798, 0x43951243},
{408, 122, 0x66105596, 0x87902486},
{409, 123, 0x13221119, 0x37580497},
{410, 123, 0x26442238, 0x75160994},
{411, 123, 0x52884477, 0x50321989},
{412, 124, 0x10576895, 0x50064397},
{413, 124, 0x21153791, 0x00128795},
{414, 124, 0x42307582, 0x00257590},
{415, 124, 0x84615164, 0x00515181},
{416, 125, 0x16923032, 0x80103036},
{417, 125, 0x33846065, 0x60206072},
{418, 125, 0x67692131, 0x20412145},
{419, 126, 0x13538426, 0x24082429},
{420, 126, 0x27076852, 0x48164858},
{421, 126, 0x54153704, 0x96329716},
{422, 127, 0x10830740, 0x99265943},
{423, 127, 0x21661481, 0x98531886},
{424, 127, 0x43322963, 0x97063772},
{425, 127, 0x86645927, 0x94127545},
{426, 128, 0x17329185, 0x58825509},
{427, 128, 0x34658371, 0x17651018},
{428, 128, 0x69316742, 0x35302036},
{429, 129, 0x13863348, 0x47060407},
{430, 129, 0x27726696, 0x94120814},
{431, 129, 0x55453393, 0x88241629},
{432, 130, 0x11090678, 0x77648325},
{433, 130, 0x22181357, 0x55296651},
{434, 130, 0x44362715, 0x10593304},
{435, 130, 0x88725430, 0x21186608},
{436, 131, 0x17745086, 0x04237321},
{437, 131, 0x35490172, 0x08474642},
{438, 131, 0x70980344, 0x16949285},
{439, 132, 0x14196068, 0x83389857},
{440, 132, 0x28392137, 0x66779714},
{441, 132, 0x56784275, 0x33559429},
{442, 133, 0x11356855, 0x06711885},
{443, 133, 0x22713710, 0x13423771},
{444, 133, 0x45427420, 0x26847543},
{445, 133, 0x90854840, 0x53695086},
{446, 134, 0x18170968, 0x10739017},
{447, 134, 0x36341936, 0x21478034},
{448, 134, 0x72683872, 0x42956069},
{449, 135, 0x14536774, 0x48591213},
{450, 135, 0x29073548, 0x97182427},
{451, 135, 0x58147097, 0x94364855},
{452, 136, 0x11629419, 0x58872971},
{453, 136, 0x23258839, 0x17745942},
{454, 136, 0x46517678, 0x35491883},
{455, 136, 0x93035356, 0x70983766},
{456, 137, 0x18607071, 0x34196753},
{457, 137, 0x37214142, 0x68393506},
{458, 137, 0x74428285, 0x36787013},
{459, 138, 0x14885657, 0x07357402},
{460, 138, 0x29771314, 0x14714805},
{461, 138, 0x59542628, 0x29429611},
{462, 139, 0x11908525, 0x65885922},
{463, 139, 0x23817051, 0x31771844},
{464, 139, 0x47634102, 0x63543689},
{465, 139, 0x95268205, 0x27087378},
{466, 140, 0x19053641, 0x05417475},
{467, 140, 0x38107282, 0x10834951},
{468, 140, 0x76214564, 0x21669903},
{469, 141, 0x15242912, 0x84333980},
{470, 141, 0x30485825, 0x68667961},
{471, 141, 0x60971651, 0x37335922},
{472, 142, 0x12194330, 0x27467184},
{473, 142, 0x24388660, 0x54934369},
{474, 142, 0x48777321, 0x09868737},
{475, 142, 0x97554642, 0x19737475},
{476, 143, 0x19510928, 0x43947495},
{477, 143, 0x39021856, 0x87894990},
{478, 143, 0x78043713, 0x75789980},
{479, 144, 0x15608742, 0x75157995},
{480, 144, 0x31217485, 0x50315991},
{481, 144, 0x62434971, 0x00631985},
{482, 145, 0x12486994, 0x20126397},
{483, 145, 0x24973988, 0x40252794},
{484, 145, 0x49947976, 0x80505587},
{485, 145, 0x99895953, 0x61011174},
{486, 146, 0x19979190, 0x72202234},
{487, 146, 0x39958381, 0x44404469},
{488, 146, 0x79916762, 0x88808939},
{489, 147, 0x15983352, 0x57761787},
{490, 147, 0x31966705, 0x15523575},
{491, 147, 0x63933410, 0x31047151},
{492, 148, 0x12786682, 0x06209430},
{493, 148, 0x25573364, 0x12418860},
{494, 148, 0x51146728, 0x24837721},
{495, 149, 0x10229345, 0x64967544},
{496, 149, 0x20458691, 0x29935088},
{497, 149, 0x40917382, 0x59870176},
{498, 149, 0x81834765, 0x19740353},
{499, 150, 0x16366953, 0x03948070},
{500, 150, 0x32733906, 0x07896141},
{501, 150, 0x65467812, 0x15792283},
{502, 151, 0x13093562, 0x43158456},
{503, 151, 0x26187124, 0x86316913},
{504, 151, 0x52374249, 0x72633826},
{505, 152, 0x10474849, 0x94526765},
{506, 152, 0x20949699, 0x89053530},
{507, 152, 0x41899399, 0x78107061},
{508, 152, 0x83798799, 0x56214122},
{509, 153, 0x16759759, 0x91242824},
{510, 153, 0x33519519, 0x82485649},
{511, 153, 0x67039039, 0x64971298},
{512, 154, 0x13407807, 0x92994259},
{513, 154, 0x26815615, 0x85988519},
{514, 154, 0x53631231, 0x71977038},
{515, 155, 0x10726246, 0x34395407},
{516, 155, 0x21452492, 0x68790815},
{517, 155, 0x42904985, 0x37581631},
{518, 155, 0x85809970, 0x75163263},
{519, 156, 0x17161994, 0x15032652},
{520, 156, 0x34323988, 0x30065304},
{521, 156, 0x68647976, 0x60130608},
{522, 157, 0x13729595, 0x32026121},
{523, 157, 0x27459190, 0x64052243},
{524, 157, 0x54918381, 0x28104488},
{525, 158, 0x10983676, 0x25620897},
{526, 158, 0x21967352, 0x51241795},
{527, 158, 0x43934705, 0x02483590},
{528, 158, 0x87869410, 0x04967181},
{529, 159, 0x17573882, 0x00993436},
{530, 159, 0x35147764, 0x01986872},
{531, 159, 0x70295528, 0x03973744},
{532, 160, 0x14059105, 0x60794748},
{533, 160, 0x28118211, 0x21589497},
{534, 160, 0x56236422, 0x43178995},
{535, 161, 0x11247284, 0x48635799},
{536, 161, 0x22494568, 0x97271598},
{537, 161, 0x44989137, 0x94543196},
{538, 161, 0x89978275, 0x89086393},
{539, 162, 0x17995655, 0x17817278},
{540, 162, 0x35991310, 0x35634557},
{541, 162, 0x71982620, 0x71269114},
{542, 163, 0x14396524, 0x14253823},
{543, 163, 0x28793048, 0x28507646},
{544, 163, 0x57586096, 0x57015291},
{545, 164, 0x11517219, 0x31403058},
{546, 164, 0x23034438, 0x62806116},
{547, 164, 0x46068877, 0x25612232},
{548, 164, 0x92137754, 0x51224465},
{549, 165, 0x18427550, 0x90244893},
{550, 165, 0x36855101, 0x80489786},
{551, 165, 0x73710203, 0x60979572},
{552, 166, 0x14742040, 0x72195914},
{553, 166, 0x29484081, 0x44391828},
{554, 166, 0x58968162, 0x88783658},
{555, 167, 0x11793632, 0x57756731},
{556, 167, 0x23587265, 0x15513463},
{557, 167, 0x47174530, 0x31026926},
{558, 167, 0x94349060, 0x62053853},
{559, 168, 0x18869812, 0x12410770},
{560, 168, 0x37739624, 0x24821540},
{561, 168, 0x75479248, 0x49643081},
{562, 169, 0x15095849, 0x69928616},
{563, 169, 0x30191699, 0x39857232},
{564, 169, 0x60383398, 0x79714466},
{565, 170, 0x12076679, 0x75942893},
{566, 170, 0x24153359, 0x51885786},
{567, 170, 0x48306719, 0x03771572},
{568, 170, 0x96613438, 0x07543145},
{569, 171, 0x19322687, 0x61508629},
{570, 171, 0x38645375, 0x23017257},
{571, 171, 0x77290750, 0x46034515},
{572, 172, 0x15458150, 0x09206903},
{573, 172, 0x30916300, 0x18413806},
{574, 172, 0x61832600, 0x36827613},
{575, 173, 0x12366520, 0x07365522},
{576, 173, 0x24733040, 0x14731045},
{577, 173, 0x49466080, 0x29462090},
{578, 173, 0x98932160, 0x58924180},
{579, 174, 0x19786432, 0x11784835},
{580, 174, 0x39572864, 0x23569672},
{581, 174, 0x79145728, 0x47139345},
{582, 175, 0x15829145, 0x69427869},
{583, 175, 0x31658291, 0x38855738},
{584, 175, 0x63316582, 0x77711476},
{585, 176, 0x12663316, 0x55542295},
{586, 176, 0x25326633, 0x11084590},
{587, 176, 0x50653266, 0x22169180},
{588, 177, 0x10130653, 0x24433836},
{589, 177, 0x20261306, 0x48867672},
{590, 177, 0x40522612, 0x97735344},
{591, 177, 0x81045225, 0x95470688},
{592, 178, 0x16209045, 0x19094137},
{593, 178, 0x32418090, 0x38188275},
{594, 178, 0x64836180, 0x76376551},
{595, 179, 0x12967236, 0x15275310},
{596, 179, 0x25934472, 0x30550620},
{597, 179, 0x51868944, 0x61101241},
{598, 180, 0x10373788, 0x92220248},
{599, 180, 0x20747577, 0x84440496},
{600, 180, 0x41495155, 0x68880993},
{601, 180, 0x82990311, 0x37761986},
{602, 181, 0x16598062, 0x27552397},
{603, 181, 0x33196124, 0x55104793},
{604, 181, 0x66392249, 0x10209586},
{605, 182, 0x13278449, 0x82041917},
{606, 182, 0x26556899, 0x64083834},
{607, 182, 0x53113799, 0x28167671},
{608, 183, 0x10622759, 0x85633534},
{609, 183, 0x21245519, 0x71267068},
{610, 183, 0x42491039, 0x42534137},
{611, 183, 0x84982078, 0x85068274},
{612, 184, 0x16996415, 0x77013654},
{613, 184, 0x33992831, 0x54027309},
{614, 184, 0x67985663, 0x08054618},
{615, 185, 0x13597132, 0x61610923},
{616, 185, 0x27194265, 0x23221847},
{617, 185, 0x54388530, 0x46443695},
{618, 186, 0x10877706, 0x09288739},
{619, 186, 0x21755412, 0x18577478},
{620, 186, 0x43510824, 0x37154956},
{621, 186, 0x87021648, 0x74309912},
{622, 187, 0x17404329, 0x74861982},
{623, 187, 0x34808659, 0x49723964},
{624, 187, 0x69617318, 0x99447929},
{625, 188, 0x13923463, 0x79889585},
{626, 188, 0x27846927, 0x59779171},
{627, 188, 0x55693855, 0x19558344},
{628, 189, 0x11138771, 0x03911668},
{629, 189, 0x22277542, 0x07823337},
{630, 189, 0x44555084, 0x15646674},
{631, 189, 0x89110168, 0x31293349},
{632, 190, 0x17822033, 0x66258669},
{633, 190, 0x35644067, 0x32517340},
{634, 190, 0x71288134, 0x65034680},
{635, 191, 0x14257626, 0x93006936},
{636, 191, 0x28515253, 0x86013872},
{637, 191, 0x57030507, 0x72027743},
{638, 192, 0x11406101, 0x54405548},
{639, 192, 0x22812203, 0x08811097},
{640, 192, 0x45624406, 0x17622194},
{641, 192, 0x91248812, 0x35244388},
{642, 193, 0x18249762, 0x47048877},
{643, 193, 0x36499524, 0x94097756},
{644, 193, 0x72999049, 0x88195513},
{645, 194, 0x14599809, 0x97639102},
{646, 194, 0x29199619, 0x95278205},
{647, 194, 0x58399239, 0x90556410},
{648, 195, 0x11679847, 0x98111282},
{649, 195, 0x23359695, 0x96222564},
{650, 195, 0x46719391, 0x92445128},
{651, 195, 0x93438783, 0x84890256},
{652, 196, 0x18687756, 0x76978051},
{653, 196, 0x37375513, 0x53956102},
{654, 196, 0x74751027, 0x07912204},
{655, 197, 0x14950205, 0x41582440},
{656, 197, 0x29900410, 0x83164881},
{657, 197, 0x59800821, 0x66329763},
{658, 198, 0x11960164, 0x33265952},
{659, 198, 0x23920328, 0x66531905},
{660, 198, 0x47840657, 0x33063810},
{661, 198, 0x95681314, 0x66127620},
{662, 199, 0x19136262, 0x93225524},
{663, 199, 0x38272525, 0x86451048},
{664, 199, 0x76545051, 0x72902097},
{665, 200, 0x15309010, 0x34580419},
{666, 200, 0x30618020, 0x69160838},
{667, 200, 0x61236041, 0x38321677},
{668, 201, 0x12247208, 0x27664335},
{669, 201, 0x24494416, 0x55328671},
{670, 201, 0x48988833, 0x10657343},
{671, 201, 0x97977666, 0x21314686},
{672, 202, 0x19595533, 0x24262937},
{673, 202, 0x39191066, 0x48525874},
{674, 202, 0x78382132, 0x97051748},
{675, 203, 0x15676426, 0x59410349},
{676, 203, 0x31352853, 0x18820699},
{677, 203, 0x62705706, 0x37641398},
{678, 204, 0x12541141, 0x27528279},
{679, 204, 0x25082282, 0x55056559},
{680, 204, 0x50164565, 0x10113118},
{681, 205, 0x10032913, 0x02022623},
{682, 205, 0x20065826, 0x04045247},
{683, 205, 0x40131652, 0x08090495},
{684, 205, 0x80263304, 0x16180991},
{685, 206, 0x16052660, 0x83236198},
{686, 206, 0x32105321, 0x66472395},
{687, 206, 0x64210643, 0x32944791},
{688, 207, 0x12842128, 0x66588958},
{689, 207, 0x25684257, 0x33177916},
{690, 207, 0x51368514, 0x66355834},
{691, 208, 0x10273702, 0x93271166},
{692, 208, 0x20547405, 0x86542333},
{693, 208, 0x41094811, 0x73084666},
{694, 208, 0x82189623, 0x46169332},
{695, 209, 0x16437924, 0x69233866},
{696, 209, 0x32875849, 0x38467733},
{697, 209, 0x65751698, 0x76935466},
{698, 210, 0x13150339, 0x75387093},
{699, 210, 0x26300679, 0x50774186},
{700, 210, 0x52601359, 0x01548373},
{701, 211, 0x10520271, 0x80309674},
{702, 211, 0x21040543, 0x60619349},
{703, 211, 0x42081087, 0x21238699},
{704, 211, 0x84162174, 0x42477398},
{705, 212, 0x16832434, 0x88495479},
{706, 212, 0x33664869, 0x76990958},
{707, 212, 0x67329739, 0x53981917},
{708, 213, 0x13465947, 0x90796383},
{709, 213, 0x26931895, 0x81592767},
{710, 213, 0x53863791, 0x63185535},
{711, 214, 0x10772758, 0x32637107},
{712, 214, 0x21545516, 0x65274214},
{713, 214, 0x43091033, 0x30548427},
{714, 214, 0x86182066, 0x61096854},
{715, 215, 0x17236413, 0x32219370},
{716, 215, 0x34472826, 0x64438742},
{717, 215, 0x68945653, 0x28877484},
{718, 216, 0x13789130, 0x65775496},
{719, 216, 0x27578261, 0x31550993},
{720, 216, 0x55156522, 0x63101987},
{721, 217, 0x11031304, 0x52620397},
{722, 217, 0x22062609, 0x05240794},
{723, 217, 0x44125218, 0x10481589},
{724, 217, 0x88250436, 0x20963178},
{725, 218, 0x17650087, 0x24192635},
{726, 218, 0x35300174, 0x48385271},
{727, 218, 0x70600348, 0x96770543},
{728, 219, 0x14120069, 0x79354108},
{729, 219, 0x28240139, 0x58708217},
{730, 219, 0x56480279, 0x17416434},
{731, 220, 0x11296055, 0x83483287},
{732, 220, 0x22592111, 0x66966574},
{733, 220, 0x45184223, 0x33933147},
{734, 220, 0x90368446, 0x67866295},
{735, 221, 0x18073689, 0x33573259},
{736, 221, 0x36147378, 0x67146518},
{737, 221, 0x72294757, 0x34293036},
{738, 222, 0x14458951, 0x46858607},
{739, 222, 0x28917902, 0x93717214},
{740, 222, 0x57835805, 0x87434430},
{741, 223, 0x11567161, 0x17486886},
{742, 223, 0x23134322, 0x34973772},
{743, 223, 0x46268644, 0x69947543},
{744, 223, 0x92537289, 0x39895087},
{745, 224, 0x18507457, 0x87979017},
{746, 224, 0x37014915, 0x75958034},
{747, 224, 0x74029831, 0x51916069},
{748, 225, 0x14805966, 0x30383213},
{749, 225, 0x29611932, 0x60766427},
{750, 225, 0x59223865, 0x21532856},
{751, 226, 0x11844773, 0x04306571},
{752, 226, 0x23689546, 0x08613142},
{753, 226, 0x47379092, 0x17226283},
{754, 226, 0x94758184, 0x34452567},
{755, 227, 0x18951636, 0x86890513},
{756, 227, 0x37903273, 0x73781027},
{757, 227, 0x75806547, 0x47562055},
{758, 228, 0x15161309, 0x49512411},
{759, 228, 0x30322618, 0x99024822},
{760, 228, 0x60645237, 0x98049644},
{761, 229, 0x12129047, 0x59609928},
{762, 229, 0x24258095, 0x19219857},
{763, 229, 0x48516190, 0x38439715},
{764, 229, 0x97032380, 0x76879430},
{765, 230, 0x19406476, 0x15375886},
{766, 230, 0x38812952, 0x30751772},
{767, 230, 0x77625904, 0x61503544},
{768, 231, 0x15525180, 0x92300708},
{769, 231, 0x31050361, 0x84601417},
{770, 231, 0x62100723, 0x69202835},
{771, 232, 0x12420144, 0x73840567},
{772, 232, 0x24840289, 0x47681134},
{773, 232, 0x49680578, 0x95362268},
{774, 232, 0x99361157, 0x90724537},
{775, 233, 0x19872231, 0x58144907},
{776, 233, 0x39744463, 0x16289814},
{777, 233, 0x79488926, 0x32579629},
{778, 234, 0x15897785, 0x26515925},
{779, 234, 0x31795570, 0x53031851},
{780, 234, 0x63591141, 0x06063703},
{781, 235, 0x12718228, 0x21212740},
{782, 235, 0x25436456, 0x42425481},
{783, 235, 0x50872912, 0x84850963},
{784, 236, 0x10174582, 0x56970192},
{785, 236, 0x20349165, 0x13940385},
{786, 236, 0x40698330, 0x27880770},
{787, 236, 0x81396660, 0x55761541},
{788, 237, 0x16279332, 0x11152308},
{789, 237, 0x32558664, 0x22304616},
{790, 237, 0x65117328, 0x44609232},
{791, 238, 0x13023465, 0x68921846},
{792, 238, 0x26046931, 0x37843693},
{793, 238, 0x52093862, 0x75687386},
{794, 239, 0x10418772, 0x55137477},
{795, 239, 0x20837545, 0x10274954},
{796, 239, 0x41675090, 0x20549908},
{797, 239, 0x83350180, 0x41099817},
{798, 240, 0x16670036, 0x08219963},
{799, 240, 0x33340072, 0x16439927},
{800, 240, 0x66680144, 0x32879854},
{801, 241, 0x13336028, 0x86575970},
{802, 241, 0x26672057, 0x73151941},
{803, 241, 0x53344115, 0x46303883},
{804, 242, 0x10668823, 0x09260776},
{805, 242, 0x21337646, 0x18521553},
{806, 242, 0x42675292, 0x37043106},
{807, 242, 0x85350584, 0x74086212},
{808, 243, 0x17070116, 0x94817242},
{809, 243, 0x34140233, 0x89634485},
{810, 243, 0x68280467, 0x79268971},
{811, 244, 0x13656093, 0x55853794},
{812, 244, 0x27312187, 0x11707588},
{813, 244, 0x54624374, 0x23415176},
{814, 245, 0x10924874, 0x84683035},
{815, 245, 0x21849749, 0x69366070},
{816, 245, 0x43699499, 0x38732141},
{817, 245, 0x87398998, 0x77464283},
{818, 246, 0x17479799, 0x75492856},
{819, 246, 0x34959599, 0x50985711},
{820, 246, 0x69919199, 0x01971423},
{821, 247, 0x13983839, 0x80394284},
{822, 247, 0x27967679, 0x60788569},
{823, 247, 0x55935359, 0x21577140},
{824, 248, 0x11187071, 0x84315428},
{825, 248, 0x22374143, 0x68630856},
{826, 248, 0x44748287, 0x37261712},
{827, 248, 0x89496574, 0x74523425},
{828, 249, 0x17899314, 0x94904685},
{829, 249, 0x35798629, 0x89809370},
{830, 249, 0x71597259, 0x79618740},
{831, 250, 0x14319451, 0x95923748},
{832, 250, 0x28638903, 0x91847496},
{833, 250, 0x57277807, 0x83694992},
{834, 251, 0x11455561, 0x56738998},
{835, 251, 0x22911123, 0x13477997},
{836, 251, 0x45822246, 0x26955993},
{837, 251, 0x91644492, 0x53911987},
{838, 252, 0x18328898, 0x50782397},
{839, 252, 0x36657797, 0x01564795},
{840, 252, 0x73315594, 0x03129590},
{841, 253, 0x14663118, 0x80625918},
{842, 253, 0x29326237, 0x61251836},
{843, 253, 0x58652475, 0x22503672},
{844, 254, 0x11730495, 0x04500734},
{845, 254, 0x23460990, 0x09001469},
{846, 254, 0x46921980, 0x18002937},
{847, 254, 0x93843960, 0x36005875},
{848, 255, 0x18768792, 0x07201175},
{849, 255, 0x37537584, 0x14402350},
{850, 255, 0x75075168, 0x28804700},
{851, 256, 0x15015033, 0x65760940},
{852, 256, 0x30030067, 0x31521880},
{853, 256, 0x60060134, 0x63043760},
{854, 257, 0x12012026, 0x92608751},
{855, 257, 0x24024053, 0x85217503},
{856, 257, 0x48048107, 0x70435007},
{857, 257, 0x96096215, 0x40870015},
{858, 258, 0x19219243, 0x08174003},
{859, 258, 0x38438486, 0x16348006},
{860, 258, 0x76876972, 0x32696013},
{861, 259, 0x15375394, 0x46539202},
{862, 259, 0x30750788, 0x93078405},
{863, 259, 0x61501577, 0x86156811},
{864, 260, 0x12300315, 0x57231362},
{865, 260, 0x24600631, 0x14462724},
{866, 260, 0x49201262, 0x28925448},
{867, 260, 0x98402524, 0x57850897},
{868, 261, 0x19680504, 0x91570179},
{869, 261, 0x39361009, 0x83140358},
{870, 261, 0x78722019, 0x66280717},
{871, 262, 0x15744403, 0x93256143},
{872, 262, 0x31488807, 0x86512286},
{873, 262, 0x62977615, 0x73024573},
{874, 263, 0x12595523, 0x14604914},
{875, 263, 0x25191046, 0x29209829},
{876, 263, 0x50382092, 0x58419659},
{877, 264, 0x10076418, 0x51683931},
{878, 264, 0x20152837, 0x03367863},
{879, 264, 0x40305674, 0x06735727},
{880, 264, 0x80611348, 0x13471454},
{881, 265, 0x16122269, 0x62694290},
{882, 265, 0x32244539, 0x25388581},
{883, 265, 0x64489078, 0x50777163},
{884, 266, 0x12897815, 0x70155432},
{885, 266, 0x25795631, 0x40310865},
{886, 266, 0x51591262, 0x80621730},
{887, 267, 0x10318252, 0x56124346},
{888, 267, 0x20636505, 0x12248692},
{889, 267, 0x41273010, 0x24497385},
{890, 267, 0x82546020, 0x48994770},
{891, 268, 0x16509204, 0x09798954},
{892, 268, 0x33018408, 0x19597907},
{893, 268, 0x66036816, 0x39195815},
{894, 269, 0x13207363, 0x27839163},
{895, 269, 0x26414726, 0x55678326},
{896, 269, 0x52829453, 0x11356652},
{897, 270, 0x10565890, 0x62271330},
{898, 270, 0x21131781, 0x24542661},
{899, 270, 0x42263562, 0x49085322},
{900, 270, 0x84527124, 0x98170644},
{901, 271, 0x16905424, 0x99634128},
{902, 271, 0x33810849, 0x99268257},
{903, 271, 0x67621699, 0x98536514},
{904, 272, 0x13524339, 0x99707302},
{905, 272, 0x27048679, 0x99414605},
{906, 272, 0x54097359, 0x98829211},
{907, 273, 0x10819471, 0x99765842},
{908, 273, 0x21638943, 0x99531684},
{909, 273, 0x43277887, 0x99063370},
{910, 273, 0x86555775, 0x98126740},
{911, 274, 0x17311155, 0x19625348},
{912, 274, 0x34622310, 0x39250696},
{913, 274, 0x69244620, 0x78501392},
{914, 275, 0x13848924, 0x15700278},
{915, 275, 0x27697848, 0x31400556},
{916, 275, 0x55395696, 0x62801112},
{917, 276, 0x11079139, 0x32560222},
{918, 276, 0x22158278, 0x65120444},
{919, 276, 0x44316557, 0x30240890},
{920, 276, 0x88633114, 0x60481780},
{921, 277, 0x17726622, 0x92096356},
{922, 277, 0x35453245, 0x84192712},
{923, 277, 0x70906491, 0x68385425},
{924, 278, 0x14181298, 0x33677085},
{925, 278, 0x28362596, 0x67354170},
{926, 278, 0x56725193, 0x34708340},
{927, 279, 0x11345038, 0x66941668},
{928, 279, 0x22690077, 0x33883336},
{929, 279, 0x45380154, 0x67766671},
{930, 279, 0x90760309, 0x35533343},
{931, 280, 0x18152061, 0x87106668},
{932, 280, 0x36304123, 0x74213337},
{933, 280, 0x72608247, 0x48426675},
{934, 281, 0x14521649, 0x49685335},
{935, 281, 0x29043298, 0x99370670},
{936, 281, 0x58086597, 0x98741340},
{937, 282, 0x11617319, 0x59748268},
{938, 282, 0x23234639, 0x19496536},
{939, 282, 0x46469278, 0x38993072},
{940, 282, 0x92938556, 0x77986144},
{941, 283, 0x18587711, 0x35597228},
{942, 283, 0x37175422, 0x71194457},
{943, 283, 0x74350845, 0x42388915},
{944, 284, 0x14870169, 0x08477783},
{945, 284, 0x29740338, 0x16955566},
{946, 284, 0x59480676, 0x33911132},
{947, 285, 0x11896135, 0x26782226},
{948, 285, 0x23792270, 0x53564453},
{949, 285, 0x47584541, 0x07128905},
{950, 285, 0x95169082, 0x14257810},
{951, 286, 0x19033816, 0x42851562},
{952, 286, 0x38067632, 0x85703124},
{953, 286, 0x76135265, 0x71406248},
{954, 287, 0x15227053, 0x14281249},
{955, 287, 0x30454106, 0x28562499},
{956, 287, 0x60908212, 0x57124999},
{957, 288, 0x12181642, 0x51424999},
{958, 288, 0x24363285, 0x02849999},
{959, 288, 0x48726570, 0x05699999},
{960, 288, 0x97453140, 0x11399998},
{961, 289, 0x19490628, 0x02279999},
{962, 289, 0x38981256, 0x04559999},
{963, 289, 0x77962512, 0x09119998},
{964, 290, 0x15592502, 0x41823999},
{965, 290, 0x31185004, 0x83647999},
{966, 290, 0x62370009, 0x67295999},
{967, 291, 0x12474001, 0x93459199},
{968, 291, 0x24948003, 0x86918399},
{969, 291, 0x49896007, 0x73836799},
{970, 291, 0x99792015, 0x47673598},
{971, 292, 0x19958403, 0x09534719},
{972, 292, 0x39916806, 0x19069439},
{973, 292, 0x79833612, 0x38138879},
{974, 293, 0x15966722, 0x47627775},
{975, 293, 0x31933444, 0x95255551},
{976, 293, 0x63866889, 0x90511103},
{977, 294, 0x12773377, 0x98102220},
{978, 294, 0x25546755, 0x96204441},
{979, 294, 0x51093511, 0x92408883},
{980, 295, 0x10218702, 0x38481776},
{981, 295, 0x20437404, 0x76963553},
{982, 295, 0x40874809, 0x53927106},
{983, 295, 0x81749619, 0x07854212},
{984, 296, 0x16349923, 0x81570842},
{985, 296, 0x32699847, 0x63141685},
{986, 296, 0x65399695, 0x26283371},
{987, 297, 0x13079939, 0x05256674},
{988, 297, 0x26159878, 0x10513348},
{989, 297, 0x52319756, 0x21026696},
{990, 298, 0x10463951, 0x24205339},
{991, 298, 0x20927902, 0x48410678},
{992, 298, 0x41855804, 0x96821356},
{993, 298, 0x83711609, 0x93642713},
{994, 299, 0x16742321, 0x98728542},
{995, 299, 0x33484643, 0x97457085},
{996, 299, 0x66969287, 0x94914170},
{997, 300, 0x13393857, 0x58982834},
{998, 300, 0x26787715, 0x17965668},
{999, 300, 0x53575430, 0x35931336},
{1000, 301, 0x10715086, 0x07186267},
{1001, 301, 0x21430172, 0x14372534},
{1002, 301, 0x42860344, 0x28745069},
{1003, 301, 0x85720688, 0x57490138},
{1004, 302, 0x17144137, 0x71498027},
{1005, 302, 0x34288275, 0x42996055},
{1006, 302, 0x68576550, 0x85992110},
{1007, 303, 0x13715310, 0x17198422},
{1008, 303, 0x27430620, 0x34396844},
{1009, 303, 0x54861240, 0x68793688},
{1010, 304, 0x10972248, 0x13758737},
{1011, 304, 0x21944496, 0x27517475},
{1012, 304, 0x43888992, 0x55034951},
{1013, 304, 0x87777985, 0x10069902},
{1014, 305, 0x17555597, 0x02013980},
{1015, 305, 0x35111194, 0x04027961},
{1016, 305, 0x70222388, 0x08055922},
{1017, 306, 0x14044477, 0x61611184},
{1018, 306, 0x28088955, 0x23222368},
{1019, 306, 0x56177910, 0x46444737},
{1020, 307, 0x11235582, 0x09288947},
{1021, 307, 0x22471164, 0x18577895},
{1022, 307, 0x44942328, 0x37155789},
{1023, 307, 0x89884656, 0x74311579},
#line 23 "bcd-c.tmpl"
{0, 0, 0, 0} /* +inf */
};

#define BYTE(bcd,j) (((bcd) >> ((7-j)*4)) & 0xf)

int bit(unsigned char * z, int b)
{
    int byte = b / 8;
    int bit = b % 8;
    if (z[byte] & 1<<bit) {
	return 1;
    }
    return 0;
}

int
print_double (double d, char * buffer)
{
    split_double_t * sp;
    unsigned char * z;
    int bytes[16] = {0};
    int powten;
    int i;
    int exp;
    double check = 0.0;
    int j;
    // Current print point within buffer.
    char * p;
    // Number of bytes printed.
    int printed;

    p = buffer;
    printed = 0;

    sp = (split_double_t *) & d;
    z = (unsigned char *) & d;
    exp = sp->exp;
    powten = bcddata[sp->exp].exp;
//    printf ("exp = %d, pow ten = %d\n", sp->exp, powten);
#if 0
    printf ("data = %08X;%08X x 10^{%d}\n", bcddata[sp->exp].upper,
	    bcddata[sp->exp].lower, bcddata[sp->exp].exp);
#endif
    for (j = 0; j < 8; j++) {
	bytes[j] = BYTE(bcddata[sp->exp].upper, j);
	bytes[j + 8] = BYTE(bcddata[sp->exp].lower, j);
    }
    check = pow (2.0, exp - 1023);
//    printf ("check = %g\n", check);
//    exit (0);
    //printf ("%llX\n", sp->fraction);
    for (i = 1; i <= 52; i++) {
	bcd_t shift;
	int powtenshift;
	int expi;
	expi = exp - i;
	if (expi < 0) {
	    break;
	}
	if (bit (z, 52 - i)) {
	    int j;
	    int maxupper;
	    int maxlower;
#if 0
	    printf ("data = %08X;%08X x 10^{%d}\n", bcddata[expi].upper,
		    bcddata[expi].lower, bcddata[expi].exp);
#endif
	    check += pow (2.0, expi - 1023);
	    shift = bcddata[expi];
	    powtenshift = powten - shift.exp;
#if 0
	    printf ("bit = %d exp = %d powtenshift = %d check=%.9g\n", i, exp - i, powtenshift, check);
#endif 
	    maxupper = 8;
	    maxlower = 8;
	    if (powtenshift > 8) {
		maxupper = 16 - powtenshift;
		maxlower = 0;
	    }
	    else {
		maxupper = 8;
		maxlower = 8 - powtenshift;
	    }
	    for (j = 0; j < maxupper; j++) {
		int digit = (shift.upper >> ((7-j)*4)) & 0xf;
#if 0
		if (digit) {
		    printf ("Adding digit %d\n", digit);
		}
#endif
		bytes[powtenshift + j] += digit;
	    }
	    for (j = 0; j < maxlower; j++) {
		int digit = (shift.lower >> ((7-j)*4)) & 0xf;
#if 0
		if (digit) {
		    printf ("Adding digit %d\n", digit);
		}
#endif
		bytes[powtenshift + 8 + j] += digit;
	    }
	    int k;
#if 0
	    for (k = 0; k < 15; k++) {
		printf ("%d ", bytes[k]);
	    }
	    printf ("\n");
#endif /* 0 */
	}
    }
    for (i = 15; i >= 0; i--) {
	if (bytes[i] > 10) {
	    bytes[i - 1] += bytes[i] / 10;
	    bytes[i] %= 10;
	}
    }
#define MAXDIGITS 14
    // Round off, maximum byte is byte 14.
    if (bytes[MAXDIGITS] >= 5) {
	bytes[MAXDIGITS-1]++;
    }
    for (i = MAXDIGITS; i >= 0; i--) {
	if (bytes[i] == 10) {
	    bytes[i-1]++;
	    bytes[i] = 0;
	}
    }
    if (printed != 0 || p != buffer) {
	fprintf (stderr,
		 "%s:%d: Unexpectedly not at start of string, printed = %d.\n",
		 __FILE__, __LINE__, printed);
	return -1;
    }
    printed += sprintf (p, "%d.", bytes[0]);
	p = buffer + printed;
    for (i = 1; i < MAXDIGITS; i++) {
#if 0
	if (i > 1 && (i - 1) % 3 == 0) {
	    printf ("_");
	}
#endif /* 0 */
	printed += sprintf (p, "%d", bytes[i]);
	p = buffer + printed;
    }
    printed += sprintf (p, "e");
    p = buffer + printed;
    if (powten >= 0) {
	printed += sprintf (p, "+");
	p = buffer + printed;
    }
    else {
	powten = -powten;
	printed += sprintf (p, "-");
	p = buffer + printed;
    }
    printed += sprintf (p, "%02d", powten);
    p = buffer + printed;
    if (strlen (buffer) != printed) {
	fprintf (stderr, "%s:%d: Unexpected mismatch between buffer length %d"
		 " and value of 'printed' %d", __FILE__, __LINE__, 
		 strlen(buffer), printed);
	return -1;
    }
    return printed;
}

#ifdef TEST

static void ruler ()
{
    int i;
    for (i = 0; i < 7; i++) {
	printf ("0123456789");
    }
    printf ("\n");
}

static void doit (double d)
{
    char buffer[0x100] = {0};
    print_double (d, buffer);
    printf ("%.13e\n%s\n", d, buffer);
//    ruler ();
}

int
main (int argc, char ** argv)
{
    char buffer[0x100] = {0};
    double d;

    d = 1234.5678;
    doit (d);
    d = 9.784536e100;
    doit (d);
    d = 0.008765;
    doit (d);
    d = 1.0;
    doit (d);
    d = 16.0;
    doit (d);
    d = 3.0;
    doit (d);
    d = 3.00003;
    doit (d);
    return 0;
}

#endif /* TEST */
