#!/usr/bin/perl -w

# ICC::Profile::cvst test module / 2019-01-30
#
# Copyright © 2004-2020 by William B. Birkett

use strict;

use File::Spec;
use Test::More tests => 5;

# local variables
my ($tag);

# does module load
BEGIN { use_ok('ICC::Profile::cvst') };

# test class methods
can_ok('ICC::Profile::cvst', qw(new inv new_fh write_fh size cin cout transform inverse jacobian parajac header array pars curv));
can_ok('ICC::Profile::cvst', qw(apogee cgats device_link efi fuji_xmf harlequin indigo iso_18620 navigator photoshop prinergy rampage sierra trueflow));
can_ok('ICC::Profile::cvst', qw(text graph normalize update sdump));

# make empty Curve object
$tag = ICC::Profile::cvst->new;

# test object class
isa_ok($tag, 'ICC::Profile::cvst');

##### more tests needed ######

