package POE::Component::IRC::Cookbook::Resolver;

use strict;
use warnings;

1;
__END__

=head1 NAME

POE::Component::IRC::Cookbook::Translator - A bot that can resolve DNS records

=head1 DESCRIPTION

This bot uses L<POE::Component::Client::DNS|POE::Component::Client::DNS>
to DNS records for channel members.

=head1 SYNOPSIS

 #!/usr/bin/perl

 use strict;
 use warnings;
 use POE;
 use POE::Component::Client::DNS;
 use POE::Component::IRC::Common qw(parse_user);
 use POE::Component::IRC::State;
 use POE::Component::IRC::Plugin::AutoJoin;
 use POE::Component::IRC::Plugin::BotCommand;

 POE::Session->create(
     package_states => [
         main => [ qw(_start irc_botcmd_resolve dns_response) ]
     ],
 );

 $poe_kernel->run();

 sub _start {
     my $heap = $_[HEAP];
     my $irc = POE::Component::IRC::State->spawn(
         Nick   => 'resolver_bot',
         Server => 'irc.freenode.net',
     );
     $heap->{irc} = $irc;

     $irc->plugin_add('AutoJoin', POE::Component::IRC::Plugin::AutoJoin->new(
         Channels => [ '#test_channel1', '#test_channel2' ]
     ));
     
     $irc->plugin_add('BotCommand', POE::Component::IRC::Plugin::BotCommand->new(
         Commands => {
            resolve => 'Usage: resolve <host>'
         }
     ));

     $heap->{dns} = POE::Component::Client::DNS->spawn();

     $irc->yield(register => 'botcmd_resolve');
     $irc->yield(connect => );
     return;
 }

 sub irc_botcmd_resolve {
     my $dns = $_[HEAP]->{dns};
     my $nick = parse_user( $_[ARG0] );
     my ($channel, $host) = @_[ARG1, ARG2];
    
     my $res = $dns->resolve(
         event => 'dns_response',
         host => $host,
         context => {
             channel => $channel,
             nick    => $nick,
         },
     );
    
     $poe_kernel->yield(dns_response => $res) if $res;
     return;
 }

 sub dns_response {
     my $irc = $_[HEAP]->{irc};
     my $res = $_[ARG0];
     my @answers = $res->{response}
         ? map { $_->rdatastr } $res->{response}->answer()
         : ();
 
     $irc->yield(
         'privmsg',
         $res->{context}->{channel},
         $res->{context}->{nick} . (scalar @answers
             ? ": @answers"
             : ': no answers for "' . $res->{host} . '"')
     );

     return;
 }

=head1 AUTHOR

Hinrik E<Ouml>rn SigurE<eth>sson, hinrik.sig@gmail.com
