/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HTMLCollectionFrames
extends HTMLCollection {
    private static final Log LOG = LogFactory.getLog(HTMLCollectionFrames.class);

    public HTMLCollectionFrames(HtmlPage page) {
        super(page, false, "Window.frames");
    }

    @Override
    protected boolean isMatching(DomNode node) {
        return node instanceof BaseFrameElement;
    }

    @Override
    protected Scriptable getScriptableForElement(Object obj) {
        WebWindow window = obj instanceof BaseFrameElement ? ((BaseFrameElement)obj).getEnclosedWindow() : ((FrameWindow)obj).getFrameElement().getEnclosedWindow();
        return Window.getProxy(window);
    }

    @Override
    protected Object getWithPreemption(String name) {
        List<Object> elements = this.getElements();
        for (Object next : elements) {
            BaseFrameElement frameElt = (BaseFrameElement)next;
            WebWindow window = frameElt.getEnclosedWindow();
            if (name.equals(window.getName())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Property \"" + name + "\" evaluated (by name) to " + window));
                }
                return this.getScriptableForElement(window);
            }
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_47) || !frameElt.getAttribute("id").equals(name)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Property \"" + name + "\" evaluated (by id) to " + window));
            }
            return this.getScriptableForElement(window);
        }
        return NOT_FOUND;
    }

    @Override
    protected void addElementIds(List<String> idList, List<Object> elements) {
        for (Object next : elements) {
            BaseFrameElement frameElt = (BaseFrameElement)next;
            WebWindow window = frameElt.getEnclosedWindow();
            String windowName = window.getName();
            if (windowName == null) continue;
            idList.add(windowName);
        }
    }
}

