/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.configuration;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassConfiguration {
    private static final String GETTER_PREFIX = "jsxGet_";
    private static final String SETTER_PREFIX = "jsxSet_";
    private static final String FUNCTION_PREFIX = "jsxFunction_";
    private Map<String, PropertyInfo> propertyMap_ = new HashMap<String, PropertyInfo>();
    private Map<String, FunctionInfo> functionMap_ = new HashMap<String, FunctionInfo>();
    private List<String> constants_ = new ArrayList<String>();
    private String extendedClassName_;
    private final Class<? extends SimpleScriptable> hostClass_;
    private final Method jsConstructor_;
    private final String htmlClassName_;
    private final boolean jsObject_;

    public ClassConfiguration(String hostClassName, String jsConstructor, String extendedClassName, String htmlClassName, boolean jsObject) throws ClassNotFoundException {
        this.extendedClassName_ = extendedClassName;
        this.hostClass_ = Class.forName(hostClassName);
        if (jsConstructor != null && jsConstructor.length() != 0) {
            Method foundCtor = null;
            for (Method method : this.hostClass_.getMethods()) {
                if (!method.getName().equals(jsConstructor)) continue;
                foundCtor = method;
                break;
            }
            if (foundCtor == null) {
                throw new IllegalStateException("Constructor method \"" + jsConstructor + "\" in class \"" + hostClassName + " is not found.");
            }
            this.jsConstructor_ = foundCtor;
        } else {
            this.jsConstructor_ = null;
        }
        this.jsObject_ = jsObject;
        this.htmlClassName_ = htmlClassName != null && htmlClassName.length() != 0 ? htmlClassName : null;
    }

    public void addProperty(String name, boolean readable, boolean writable) {
        PropertyInfo info = new PropertyInfo();
        info.setReadable(readable);
        info.setWritable(writable);
        try {
            if (readable) {
                info.setReadMethod(this.hostClass_.getMethod(GETTER_PREFIX + name, null));
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Method 'jsxGet_" + name + "' was not found for " + name + " property in " + this.hostClass_.getName());
        }
        if (writable) {
            String setMethodName = SETTER_PREFIX + name;
            for (Method method : this.hostClass_.getMethods()) {
                if (!method.getName().equals(setMethodName) || method.getParameterTypes().length != 1) continue;
                info.setWriteMethod(method);
                break;
            }
            if (info.getWriteMethod() == null) {
                throw new IllegalStateException("Method 'jsxSet_" + name + "' was not found for " + name + " property in " + this.hostClass_.getName());
            }
        }
        this.propertyMap_.put(name, info);
    }

    public void addConstant(String name) {
        this.constants_.add(name);
    }

    public Set<String> propertyKeys() {
        return this.propertyMap_.keySet();
    }

    public Set<String> functionKeys() {
        return this.functionMap_.keySet();
    }

    public List<String> constants() {
        return this.constants_;
    }

    public void addFunction(String name) {
        FunctionInfo info = new FunctionInfo();
        String setMethodName = FUNCTION_PREFIX + name;
        for (Method method : this.hostClass_.getMethods()) {
            if (!method.getName().equals(setMethodName)) continue;
            info.setFunctionMethod(method);
            break;
        }
        if (info.getFunctionMethod() == null) {
            throw new IllegalStateException("Method 'jsxFunction_" + name + "' was not found for " + name + " function in " + this.hostClass_.getName());
        }
        this.functionMap_.put(name, info);
    }

    void addAllDefinitions(ClassConfiguration virtualClassConfig) {
        if (!virtualClassConfig.getHostClass().isAssignableFrom(this.getHostClass())) {
            throw new RuntimeException("Can't configure " + this.getHostClass() + " with info from " + virtualClassConfig.getHostClass());
        }
        this.propertyMap_.putAll(virtualClassConfig.propertyMap_);
        this.functionMap_.putAll(virtualClassConfig.functionMap_);
        this.constants_.addAll(virtualClassConfig.constants_);
    }

    public void setBrowser(String propertyName, String browserName) throws IllegalStateException {
        PropertyInfo property = this.getPropertyInfo(propertyName);
        if (property == null) {
            throw new IllegalStateException("Property does not exist to set browser");
        }
        property.setBrowser(new BrowserInfo(browserName));
    }

    public String getExtendedClassName() {
        return this.extendedClassName_;
    }

    public void setExtendedClassName(String extendedClass) {
        this.extendedClassName_ = extendedClass;
    }

    protected PropertyInfo getPropertyInfo(String propertyName) {
        return this.propertyMap_.get(propertyName);
    }

    private FunctionInfo getFunctionInfo(String functionName) {
        return this.functionMap_.get(functionName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassConfiguration)) {
            return false;
        }
        ClassConfiguration config = (ClassConfiguration)obj;
        if (this.propertyMap_.size() != config.propertyMap_.size()) {
            return false;
        }
        if (this.functionMap_.size() != config.functionMap_.size()) {
            return false;
        }
        Set<String> keys = config.propertyMap_.keySet();
        for (String key : keys) {
            if (config.propertyMap_.get(key).valueEquals(this.propertyMap_.get(key))) continue;
            return false;
        }
        for (String key : config.functionMap_.keySet()) {
            if (config.functionMap_.get(key).valueEquals(this.functionMap_.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hostClass_.getName().hashCode();
    }

    public Method getPropertyReadMethod(String propertyName) {
        PropertyInfo info = this.getPropertyInfo(propertyName);
        if (info == null) {
            return null;
        }
        return info.getReadMethod();
    }

    public Method getPropertyWriteMethod(String propertyName) {
        PropertyInfo info = this.getPropertyInfo(propertyName);
        if (info == null) {
            return null;
        }
        return info.getWriteMethod();
    }

    public Method getFunctionMethod(String functionName) {
        FunctionInfo info = this.getFunctionInfo(functionName);
        if (info == null) {
            return null;
        }
        return info.getFunctionMethod();
    }

    public Class<? extends SimpleScriptable> getHostClass() {
        return this.hostClass_;
    }

    public Method getJsConstructor() {
        return this.jsConstructor_;
    }

    public String getHtmlClassname() {
        return this.htmlClassName_;
    }

    public boolean isJsObject() {
        return this.jsObject_;
    }

    private static final class BrowserInfo {
        private String browserName_;
        private String minVersion_;
        private String maxVersion_;
        private String lessThanVersion_;

        private boolean valueEquals(Object obj) {
            if (!(obj instanceof BrowserInfo)) {
                return false;
            }
            BrowserInfo info = (BrowserInfo)obj;
            if (this.minVersion_ != null && !this.minVersion_.equals(info.minVersion_)) {
                return false;
            }
            if (this.maxVersion_ != null && !this.maxVersion_.equals(info.maxVersion_)) {
                return false;
            }
            if (this.lessThanVersion_ != null && !this.lessThanVersion_.equals(info.lessThanVersion_)) {
                return false;
            }
            return this.browserName_ == info.browserName_;
        }

        private BrowserInfo(String browserName) {
            this.browserName_ = browserName;
        }

        private String getBrowserName() {
            return this.browserName_;
        }
    }

    private static class FunctionInfo {
        private boolean hasBrowsers_ = false;
        private Map<String, BrowserInfo> browserMap_;
        private Method functionMethod_;

        private FunctionInfo() {
        }

        private boolean valueEquals(Object obj) {
            if (!(obj instanceof FunctionInfo)) {
                return false;
            }
            FunctionInfo info = (FunctionInfo)obj;
            if (this.hasBrowsers_ != info.hasBrowsers_) {
                return false;
            }
            if (this.hasBrowsers_) {
                if (this.browserMap_.size() != info.browserMap_.size()) {
                    return false;
                }
                for (Map.Entry<String, BrowserInfo> entry : this.browserMap_.entrySet()) {
                    if (!entry.getValue().valueEquals(info.browserMap_.get(entry.getKey()))) continue;
                    return false;
                }
            }
            return true;
        }

        public Method getFunctionMethod() {
            return this.functionMethod_;
        }

        public void setFunctionMethod(Method functionMethod) {
            this.functionMethod_ = functionMethod;
        }
    }

    protected static class PropertyInfo {
        private boolean readable_ = false;
        private boolean writable_ = false;
        private boolean hasBrowsers_ = false;
        private Map<String, BrowserInfo> browserMap_;
        private Method readMethod_;
        private Method writeMethod_;

        protected PropertyInfo() {
        }

        public Method getReadMethod() {
            return this.readMethod_;
        }

        public void setReadMethod(Method readMethod) {
            this.readMethod_ = readMethod;
        }

        public Method getWriteMethod() {
            return this.writeMethod_;
        }

        public void setWriteMethod(Method writeMethod) {
            this.writeMethod_ = writeMethod;
        }

        private void setBrowser(BrowserInfo browserInfo) {
            if (this.browserMap_ == null) {
                this.hasBrowsers_ = true;
                this.browserMap_ = new HashMap<String, BrowserInfo>();
            }
            this.browserMap_.put(browserInfo.getBrowserName(), browserInfo);
        }

        private boolean valueEquals(Object obj) {
            if (!(obj instanceof PropertyInfo)) {
                return false;
            }
            PropertyInfo info = (PropertyInfo)obj;
            if (this.hasBrowsers_ != info.hasBrowsers_) {
                return false;
            }
            if (this.hasBrowsers_) {
                if (this.browserMap_.size() != info.browserMap_.size()) {
                    return false;
                }
                for (Map.Entry<String, BrowserInfo> entry : this.browserMap_.entrySet()) {
                    if (entry.getValue().valueEquals(info.browserMap_.get(entry.getKey()))) continue;
                    return false;
                }
            }
            return this.readable_ == info.readable_ && this.writable_ == info.writable_;
        }

        private void setReadable(boolean readable) {
            this.readable_ = readable;
        }

        private void setWritable(boolean writable) {
            this.writable_ = writable;
        }
    }
}

