/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;

public class ImmediateRefreshHandler
implements RefreshHandler,
Serializable {
    private static final long serialVersionUID = 529942009235309224L;

    public void handleRefresh(Page page, URL url, int seconds) throws IOException {
        WebWindow window = page.getEnclosingWindow();
        if (window == null) {
            return;
        }
        WebClient client = window.getWebClient();
        if (page.getWebResponse().getWebRequest().getUrl().toExternalForm().equals(url.toExternalForm()) && HttpMethod.GET == page.getWebResponse().getWebRequest().getHttpMethod()) {
            String msg = "Refresh to " + url + " (" + seconds + "s) aborted by HtmlUnit: " + "Attempted to refresh a page using an ImmediateRefreshHandler " + "which could have caused an OutOfMemoryError " + "Please use WaitingRefreshHandler or ThreadedRefreshHandler instead.";
            throw new RuntimeException(msg);
        }
        client.getPage(window, new WebRequest(url));
    }
}

