/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.impl;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import java.io.Serializable;
import org.w3c.dom.ranges.Range;

public class SelectionDelegate
implements Serializable {
    private static final long serialVersionUID = -5611492671640559880L;
    private final SelectableTextInput element_;
    private final Range selection_;

    public SelectionDelegate(SelectableTextInput element) {
        this.element_ = element;
        this.selection_ = new SimpleRange(element, element.getText().length());
    }

    public void select() {
        this.element_.focus();
        this.setSelectionStart(0);
        this.setSelectionEnd(this.element_.getText().length());
    }

    public String getSelectedText() {
        return ((Object)this.selection_).toString();
    }

    public int getSelectionStart() {
        return this.selection_.getStartOffset();
    }

    public void setSelectionStart(int selectionStart) {
        int length = this.element_.getText().length();
        selectionStart = Math.max(0, Math.min(selectionStart, length));
        this.selection_.setStart(this.element_, selectionStart);
        if (this.selection_.getEndOffset() < selectionStart) {
            this.selection_.setEnd(this.element_, selectionStart);
        }
        this.makeThisTheOnlySelectionIfEmulatingIE();
    }

    public int getSelectionEnd() {
        return this.selection_.getEndOffset();
    }

    public void setSelectionEnd(int selectionEnd) {
        int length = this.element_.getText().length();
        selectionEnd = Math.min(length, Math.max(selectionEnd, 0));
        this.selection_.setEnd(this.element_, selectionEnd);
        if (this.selection_.getStartOffset() > selectionEnd) {
            this.selection_.setStart(this.element_, selectionEnd);
        }
        this.makeThisTheOnlySelectionIfEmulatingIE();
    }

    private void makeThisTheOnlySelectionIfEmulatingIE() {
        HtmlPage htmlPage;
        Page page = this.element_.getPage();
        if (page instanceof HtmlPage && (htmlPage = (HtmlPage)page).getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_13)) {
            htmlPage.setSelectionRange(this.selection_);
        }
    }
}

