/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.xpath;

import com.gargoylesoftware.htmlunit.html.xpath.LowerCaseFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.objects.XObject;

class XPathAdapter {
    private Expression mainExp_;
    private FunctionTable funcTable_;

    private void initFunctionTable() {
        this.funcTable_ = new FunctionTable();
        this.funcTable_.installFunction("lower-case", LowerCaseFunction.class);
    }

    XPathAdapter(String exprString, SourceLocator locator, PrefixResolver prefixResolver, ErrorListener errorListener, boolean html) throws TransformerException {
        Expression expr;
        this.initFunctionTable();
        if (errorListener == null) {
            errorListener = new DefaultErrorHandler();
        }
        if (html) {
            exprString = XPathAdapter.preProcessXPath(exprString);
        }
        XPathParser parser = new XPathParser(errorListener, locator);
        Compiler compiler = new Compiler(errorListener, locator, this.funcTable_);
        parser.initXPath(compiler, exprString, prefixResolver);
        this.mainExp_ = expr = compiler.compile(0);
        if (locator != null && locator instanceof ExpressionNode) {
            expr.exprSetParent((ExpressionNode)locator);
        }
    }

    private static String preProcessXPath(String string) {
        char[] charArray = string.toCharArray();
        XPathAdapter.processOutsideBrackets(charArray);
        string = new String(charArray);
        Pattern pattern = Pattern.compile("(@[a-zA-Z]+)");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String attribute = matcher.group(1);
            string = string.replace(attribute, attribute.toLowerCase());
        }
        return string;
    }

    private static void processOutsideBrackets(char[] array) {
        int length = array.length;
        int insideBrackets = 0;
        block4: for (int i = 0; i < length; ++i) {
            char ch = array[i];
            switch (ch) {
                case '(': 
                case '[': {
                    ++insideBrackets;
                    continue block4;
                }
                case ')': 
                case ']': {
                    --insideBrackets;
                    continue block4;
                }
                default: {
                    if (insideBrackets != 0) continue block4;
                    array[i] = Character.toLowerCase(ch);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XObject execute(XPathContext xpathContext, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        XObject xobj;
        block11: {
            xpathContext.pushNamespaceContext(namespaceContext);
            xpathContext.pushCurrentNodeAndExpression(contextNode, contextNode);
            xobj = null;
            try {
                xobj = this.mainExp_.execute(xpathContext);
            }
            catch (TransformerException te) {
                te.setLocator((SourceLocator)this.mainExp_);
                ErrorListener el = xpathContext.getErrorListener();
                if (null != el) {
                    el.error(te);
                    break block11;
                }
                throw te;
            }
            catch (Exception e) {
                while (e instanceof WrappedRuntimeException) {
                    e = ((WrappedRuntimeException)e).getException();
                }
                String msg = e.getMessage();
                if (msg == null || msg.length() == 0) {
                    msg = XSLMessages.createXPATHMessage((String)"ER_XPATH_ERROR", null);
                }
                TransformerException te = new TransformerException(msg, (SourceLocator)this.mainExp_, e);
                ErrorListener el = xpathContext.getErrorListener();
                if (null != el) {
                    el.fatalError(te);
                    break block11;
                }
                throw te;
            }
            finally {
                xpathContext.popNamespaceContext();
                xpathContext.popCurrentNodeAndExpression();
            }
        }
        return xobj;
    }
}

