/*
 * PerlQt interface to QKeyEvent (qevent.h)
 *
 * Copyright (C) 1997, Ashley Winters <jql@accessone.com>
 *
 * You may distribute under the terms of the LGPL as specified in the
 * README file
 */

#include <pqkeyev.h>
#include <qkeycode.h>

struct pqt_const_hash pqt_const_hash_Key[] = {
    { "Escape",		Key_Escape	},
    { "Tab",		Key_Tab		},
    { "Backtab",	Key_Backtab	},
    { "Backspace",	Key_Backspace	},
    { "Return",		Key_Return	},
    { "Enter",		Key_Enter	},
    { "Insert",		Key_Insert	},
    { "Delete",		Key_Delete	},
    { "Pause",		Key_Pause	},
    { "Print",		Key_Print	},
    { "SysReq",		Key_SysReq	},
    { "Home",		Key_Home	},
    { "End",		Key_End		},
    { "Left",		Key_Left	},
    { "Up",		Key_Up		},
    { "Right",		Key_Right	},
    { "Down",		Key_Down	},
    { "Prior",		Key_Prior	},
    { "PageUp",		Key_PageUp	},
    { "Next",		Key_Next	},
    { "PageDown",	Key_PageDown	},
    { "Shift",		Key_Shift	},
    { "Control",	Key_Control	},
    { "Meta",		Key_Meta	},
    { "Alt",		Key_Alt		},
    { "CapsLock",	Key_CapsLock	},
    { "NumLock",	Key_NumLock	},
    { "ScrollLock",	Key_ScrollLock	},
    { "F1",		Key_F1		},
    { "F2",		Key_F2		},
    { "F3",		Key_F3		},
    { "F4",		Key_F4		},
    { "F5",		Key_F5		},
    { "F6",		Key_F6		},
    { "F7",		Key_F7		},
    { "F8",		Key_F8		},
    { "F9",		Key_F9		},
    { "F10",		Key_F10		},
    { "F11",		Key_F11		},
    { "F12",		Key_F12		},
    { "F13",		Key_F13		},
    { "F14",		Key_F14		},
    { "F15",		Key_F15		},
    { "F16",		Key_F16		},
    { "F17",		Key_F17		},
    { "F18",		Key_F18		},
    { "F19",		Key_F19		},
    { "F20",		Key_F20		},
    { "F21",		Key_F21		},
    { "F22",		Key_F22		},
    { "F23",		Key_F23		},
    { "F24",		Key_F24		},
    { "Space",		Key_Space	},
    { "Exclam",		Key_Exclam	},
    { "QuoteDbl",	Key_QuoteDbl	},
    { "NumberSign",	Key_NumberSign	},
    { "Dollar",		Key_Dollar	},
    { "Percent",	Key_Percent	},
    { "Ampersand",	Key_Ampersand	},
    { "Apostrophe",	Key_Apostrophe	},
    { "ParenLeft",	Key_ParenLeft	},
    { "ParenRight",	Key_ParenRight	},
    { "Asterisk",	Key_Asterisk	},
    { "Plus",		Key_Plus	},
    { "Comma",		Key_Comma	},
    { "Minus",		Key_Minus	},
    { "Period",		Key_Period	},
    { "Slash",		Key_Slash	},
    { "0",		Key_0		},
    { "1",		Key_1		},
    { "2",		Key_2		},
    { "3",		Key_3		},
    { "4",		Key_4		},
    { "5",		Key_5		},
    { "6",		Key_6		},
    { "7",		Key_7		},
    { "8",		Key_8		},
    { "9",		Key_9		},
    { "Colon",		Key_Colon	},
    { "Semicolon",	Key_Semicolon	},
    { "Less",		Key_Less	},
    { "Equal",		Key_Equal	},
    { "Greater",	Key_Greater	},
    { "Question",	Key_Question	},
    { "At",		Key_At		},
    { "A",		Key_A		},
    { "B",		Key_B		},
    { "C",		Key_C		},
    { "D",		Key_D		},
    { "E",		Key_E		},
    { "F",		Key_F		},
    { "G",		Key_G		},
    { "H",		Key_H		},
    { "I",		Key_I		},
    { "J",		Key_J		},
    { "K",		Key_K		},
    { "L",		Key_L		},
    { "M",		Key_M		},
    { "N",		Key_N		},
    { "O",		Key_O		},
    { "P",		Key_P		},
    { "Q",		Key_Q		},
    { "R",		Key_R		},
    { "S",		Key_S		},
    { "T",		Key_T		},
    { "U",		Key_U		},
    { "V",		Key_V		},
    { "W",		Key_W		},
    { "X",		Key_X		},
    { "Y",		Key_Y		},
    { "Z",		Key_Z		},
    { "BracketLeft",	Key_BracketLeft	},
    { "Backslash",	Key_Backslash	},
    { "BracketRight",	Key_BracketRight},
    { "AsciiCircum",	Key_AsciiCircum	},
    { "Underscore",	Key_Underscore	},
    { "QuoteLeft",	Key_QuoteLeft	},
    { "BraceLeft",	Key_BraceLeft	},
    { "Bar",		Key_Bar		},
    { "BraceRight",	Key_BraceRight	},
    { "AsciiTilde",	Key_AsciiTilde	},
    { "nobreakspace",	Key_nobreakspace},
    { "exclamdown",	Key_exclamdown	},
    { "cent",		Key_cent	},
    { "sterling",	Key_sterling	},
    { "currency",	Key_currency	},
    { "yen",		Key_yen		},
    { "brokenbar",	Key_brokenbar	},
    { "section",	Key_section	},
    { "diaeresis",	Key_diaeresis	},
    { "copyright",	Key_copyright	},
    { "ordfeminine",	Key_ordfeminine	},
    { "guillemotleft",	Key_guillemotleft },
    { "notsign",	Key_notsign	},
    { "hyphen",		Key_hyphen	},
    { "registered",	Key_registered	},
    { "macron",		Key_macron	},
    { "degree",		Key_degree	},
    { "plusminus",	Key_plusminus	},
    { "twosuperior",	Key_twosuperior	},
    { "threesuperior",	Key_threesuperior },
    { "acute",		Key_acute	},
    { "mu",		Key_mu		},
    { "paragraph",	Key_paragraph	},
    { "periodcentered",	Key_periodcentered },
    { "cedilla",	Key_cedilla	},
    { "onesuperior",	Key_onesuperior	},
    { "masculine",	Key_masculine	},
    { "guillemotright",	Key_guillemotright },
    { "onequarter",	Key_onequarter	},
    { "onehalf",	Key_onehalf	},
    { "threequarters",	Key_threequarters },
    { "questiondown",	Key_questiondown },
    { "Agrave",		Key_Agrave	},
    { "Aacute",		Key_Aacute	},
    { "Acircumflex",	Key_Acircumflex	},
    { "Atilde",		Key_Atilde	},
    { "Adiaeresis",	Key_Adiaeresis	},
    { "Aring",		Key_Aring	},
    { "AE",		Key_AE		},
    { "Ccedilla",	Key_Ccedilla	},
    { "Egrave",		Key_Egrave	},
    { "Eacute",		Key_Eacute	},
    { "Ecircumflex",	Key_Ecircumflex	},
    { "Ediaeresis",	Key_Ediaeresis	},
    { "Igrave",		Key_Igrave	},
    { "Iacute",		Key_Iacute	},
    { "Icircumflex",	Key_Icircumflex	},
    { "Idiaeresis",	Key_Idiaeresis	},
    { "ETH",		Key_ETH		},
    { "Ntilde",		Key_Ntilde	},
    { "Ograve",		Key_Ograve	},
    { "Oacute",		Key_Oacute	},
    { "Ocircumflex",	Key_Ocircumflex	},
    { "Otilde",		Key_Otilde	},
    { "Odiaeresis",	Key_Odiaeresis	},
    { "multiply",	Key_multiply	},
    { "Ooblique",	Key_Ooblique	},
    { "Ugrave",		Key_Ugrave	},
    { "Uacute",		Key_Uacute	},
    { "Ucircumflex",	Key_Ucircumflex	},
    { "Udiaeresis",	Key_Udiaeresis	},
    { "Yacute",		Key_Yacute	},
    { "THORN",		Key_THORN	},
    { "ssharp",		Key_ssharp	},
    { "agrave",		Key_agrave	},
    { "aacute",		Key_aacute	},
    { "acircumflex",	Key_acircumflex	},
    { "atilde",		Key_atilde	},
    { "adiaeresis",	Key_adiaeresis	},
    { "aring",		Key_aring	},
    { "ae",		Key_ae		},
    { "ccedilla",	Key_ccedilla	},
    { "egrave",		Key_egrave	},
    { "eacute",		Key_eacute	},
    { "ecircumflex",	Key_ecircumflex	},
    { "ediaeresis",	Key_ediaeresis	},
    { "igrave",		Key_igrave	},
    { "iacute",		Key_iacute	},
    { "icircumflex",	Key_icircumflex	},
    { "idiaeresis",	Key_idiaeresis	},
    { "eth",		Key_eth		},
    { "ntilde",		Key_ntilde	},
    { "ograve",		Key_ograve	},
    { "oacute",		Key_oacute	},
    { "ocircumflex",	Key_ocircumflex	},
    { "otilde",		Key_otilde	},
    { "odiaeresis",	Key_odiaeresis	},
    { "division",	Key_division	},
    { "oslash",		Key_oslash	},
    { "ugrave",		Key_ugrave	},
    { "uacute",		Key_uacute	},
    { "ucircumflex",	Key_ucircumflex	},
    { "udiaeresis",	Key_udiaeresis	},
    { "yacute",		Key_yacute	},
    { "thorn",		Key_thorn	},
    { "ydiaeresis",	Key_ydiaeresis	},
    { "unknown",	Key_unknown	},
    { "SHIFT",		SHIFT		},
    { "CTRL",		CTRL		},
    { "ALT",		ALT		},
    { "ASCII_ACCEL",	ASCII_ACCEL	},
    { NULL,		0		},
};

static struct pqt_export QKeyEvent_export[] = {
    { "%Key", pqt_const_hash_Key },
    { 0, 0 }
};

MODULE = Qt::QKeyEvent	     PACKAGE = QKeyEvent
PROTOTYPES: DISABLE

BOOT:
    pqt_class_register(
	"QKeyEvent",
	"QEvent",
	0,
	QKeyEvent_export
    );
