# Before 'make install' is performed this script should be runnable with
# 'make test'. After 'make install' it should work as 'perl Graphics-Raylib-XS.t'

#########################

# change 'tests => 2' to 'tests => last_test_to_print';

use strict;
use warnings;

use Test::More tests => 2;
BEGIN { use_ok('Graphics::Raylib::XS') };


my $fail = 0;
foreach my $constname (qw(
	BLEND_ADDITIVE BLEND_ALPHA BLEND_MULTIPLIED CAMERA_CUSTOM
	CAMERA_FIRST_PERSON CAMERA_FREE CAMERA_ORBITAL CAMERA_THIRD_PERSON
	COMPRESSED_ASTC_4x4_RGBA COMPRESSED_ASTC_8x8_RGBA COMPRESSED_DXT1_RGB
	COMPRESSED_DXT1_RGBA COMPRESSED_DXT3_RGBA COMPRESSED_DXT5_RGBA
	COMPRESSED_ETC1_RGB COMPRESSED_ETC2_EAC_RGBA COMPRESSED_ETC2_RGB
	COMPRESSED_PVRT_RGB COMPRESSED_PVRT_RGBA DEG2RAD FILTER_ANISOTROPIC_16X
	FILTER_ANISOTROPIC_4X FILTER_ANISOTROPIC_8X FILTER_BILINEAR
	FILTER_POINT FILTER_TRILINEAR FLAG_CENTERED_MODE FLAG_FULLSCREEN_MODE
	FLAG_MSAA_4X_HINT FLAG_RESIZABLE_WINDOW FLAG_SHOW_LOGO
	FLAG_SHOW_MOUSE_CURSOR FLAG_VSYNC_HINT GAMEPAD_PLAYER1 GAMEPAD_PLAYER2
	GAMEPAD_PLAYER3 GAMEPAD_PLAYER4 GAMEPAD_PS3_AXIS_L2
	GAMEPAD_PS3_AXIS_LEFT_X GAMEPAD_PS3_AXIS_LEFT_Y GAMEPAD_PS3_AXIS_R2
	GAMEPAD_PS3_AXIS_RIGHT_X GAMEPAD_PS3_AXIS_RIGHT_Y
	GAMEPAD_PS3_BUTTON_CIRCLE GAMEPAD_PS3_BUTTON_CROSS
	GAMEPAD_PS3_BUTTON_DOWN GAMEPAD_PS3_BUTTON_L1 GAMEPAD_PS3_BUTTON_L2
	GAMEPAD_PS3_BUTTON_LEFT GAMEPAD_PS3_BUTTON_PS GAMEPAD_PS3_BUTTON_R1
	GAMEPAD_PS3_BUTTON_R2 GAMEPAD_PS3_BUTTON_RIGHT
	GAMEPAD_PS3_BUTTON_SELECT GAMEPAD_PS3_BUTTON_SQUARE
	GAMEPAD_PS3_BUTTON_START GAMEPAD_PS3_BUTTON_TRIANGLE
	GAMEPAD_PS3_BUTTON_UP GAMEPAD_XBOX_AXIS_LEFT_X GAMEPAD_XBOX_AXIS_LEFT_Y
	GAMEPAD_XBOX_AXIS_LT GAMEPAD_XBOX_AXIS_RIGHT_X
	GAMEPAD_XBOX_AXIS_RIGHT_Y GAMEPAD_XBOX_AXIS_RT GAMEPAD_XBOX_BUTTON_A
	GAMEPAD_XBOX_BUTTON_B GAMEPAD_XBOX_BUTTON_DOWN GAMEPAD_XBOX_BUTTON_HOME
	GAMEPAD_XBOX_BUTTON_LB GAMEPAD_XBOX_BUTTON_LEFT GAMEPAD_XBOX_BUTTON_RB
	GAMEPAD_XBOX_BUTTON_RIGHT GAMEPAD_XBOX_BUTTON_SELECT
	GAMEPAD_XBOX_BUTTON_START GAMEPAD_XBOX_BUTTON_UP GAMEPAD_XBOX_BUTTON_X
	GAMEPAD_XBOX_BUTTON_Y GESTURE_DOUBLETAP GESTURE_DRAG GESTURE_HOLD
	GESTURE_NONE GESTURE_PINCH_IN GESTURE_PINCH_OUT GESTURE_SWIPE_DOWN
	GESTURE_SWIPE_LEFT GESTURE_SWIPE_RIGHT GESTURE_SWIPE_UP GESTURE_TAP
	HMD_DEFAULT_DEVICE HMD_FOVE_VR HMD_GOOGLE_CARDBOARD HMD_OCULUS_RIFT_CV1
	HMD_OCULUS_RIFT_DK2 HMD_RAZER_OSVR HMD_SAMSUNG_GEAR_VR
	HMD_SONY_PLAYSTATION_VR HMD_VALVE_HTC_VIVE KEY_A KEY_B KEY_BACK
	KEY_BACKSPACE KEY_C KEY_D KEY_DOWN KEY_E KEY_EIGHT KEY_ENTER KEY_ESCAPE
	KEY_F KEY_F1 KEY_F10 KEY_F11 KEY_F12 KEY_F2 KEY_F3 KEY_F4 KEY_F5 KEY_F6
	KEY_F7 KEY_F8 KEY_F9 KEY_FIVE KEY_FOUR KEY_G KEY_H KEY_I KEY_J KEY_K
	KEY_L KEY_LEFT KEY_LEFT_ALT KEY_LEFT_CONTROL KEY_LEFT_SHIFT KEY_M
	KEY_MENU KEY_N KEY_NINE KEY_O KEY_ONE KEY_P KEY_Q KEY_R KEY_RIGHT
	KEY_RIGHT_ALT KEY_RIGHT_CONTROL KEY_RIGHT_SHIFT KEY_S KEY_SEVEN KEY_SIX
	KEY_SPACE KEY_T KEY_THREE KEY_TWO KEY_U KEY_UP KEY_V KEY_VOLUME_DOWN
	KEY_VOLUME_UP KEY_W KEY_X KEY_Y KEY_Z KEY_ZERO LIGHT_DIRECTIONAL
	LIGHT_POINT LIGHT_SPOT MAX_TOUCH_POINTS MOUSE_LEFT_BUTTON
	MOUSE_MIDDLE_BUTTON MOUSE_RIGHT_BUTTON RAD2DEG UNCOMPRESSED_GRAYSCALE
	UNCOMPRESSED_GRAY_ALPHA UNCOMPRESSED_R4G4B4A4 UNCOMPRESSED_R5G5B5A1
	UNCOMPRESSED_R5G6B5 UNCOMPRESSED_R8G8B8 UNCOMPRESSED_R8G8B8A8
	WRAP_CLAMP WRAP_MIRROR WRAP_REPEAT false true)) {
  next if (eval "my \$a = $constname; 1");
  if ($@ =~ /^Your vendor has not defined Graphics::Raylib::XS macro $constname/) {
    print "# pass: $@";
  } else {
    print "# fail: $@";
    $fail = 1;
  }

}

ok( $fail == 0 , 'Constants' );
#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

