# NAME

AsposeCellsCloud::Role - a Moose role for the Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

# VERSION

Automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0
- Package version: 19.2.1
- Build package: io.swagger.codegen.languages.PerlClientCodegen

## A note on Moose

This role is the only component of the library that uses Moose. See
AsposeCellsCloud::ApiFactory for non-Moosey usage.

# SYNOPSIS

The Perl Swagger Codegen project builds a library of Perl modules to interact with
a web service defined by a OpenAPI Specification. See below for how to build the
library.

This module provides an interface to the generated library. All the classes,
objects, and methods (well, not quite \*all\*, see below) are flattened into this
role.

        package MyApp;
        use Moose;
        with 'AsposeCellsCloud::Role';

        package main;

        my $api = MyApp->new({ tokens => $tokens });

        my $pet = $api->get_pet_by_id(pet_id => $pet_id);


## Structure of the library

The library consists of a set of API classes, one for each endpoint. These APIs
implement the method calls available on each endpoint.

Additionally, there is a set of "object" classes, which represent the objects
returned by and sent to the methods on the endpoints.

An API factory class is provided, which builds instances of each endpoint API.

This Moose role flattens all the methods from the endpoint APIs onto the consuming
class. It also provides methods to retrieve the endpoint API objects, and the API
factory object, should you need it.

For documentation of all these methods, see AUTOMATIC DOCUMENTATION below.

## Configuring authentication

In the normal case, the OpenAPI Spec will describe what parameters are
required and where to put them. You just need to supply the tokens.

    my $tokens = {
        # basic
        username => $username,
        password => $password,

        # oauth
        access_token => $oauth_token,

        # keys
        $some_key => { token => $token,
                       prefix => $prefix,
                       in => $in,             # 'head||query',
                       },

        $another => { token => $token,
                      prefix => $prefix,
                      in => $in,              # 'head||query',
                      },
        ...,

        };

        my $api = MyApp->new({ tokens => $tokens });

Note these are all optional, as are `prefix` and `in`, and depend on the API
you are accessing. Usually `prefix` and `in` will be determined by the code generator from
the spec and you will not need to set them at run time. If not, `in` will
default to 'head' and `prefix` to the empty string.

The tokens will be placed in a L<AsposeCellsCloud::Configuration> instance
as follows, but you don't need to know about this.

- `$cfg->{username}`

    String. The username for basic auth.

- `$cfg->{password}`

    String. The password for basic auth.

- `$cfg->{api_key}`

    Hashref. Keyed on the name of each key (there can be multiple tokens).

            $cfg->{api_key} = {
                    secretKey => 'aaaabbbbccccdddd',
                    anotherKey => '1111222233334444',
                    };

- `$cfg->{api_key_prefix}`

    Hashref. Keyed on the name of each key (there can be multiple tokens). Note not
    all api keys require a prefix.

            $cfg->{api_key_prefix} = {
                    secretKey => 'string',
                    anotherKey => 'same or some other string',
                    };

- `$cfg->{access_token}`

    String. The OAuth access token.

# METHODS

## `base_url`

The generated code has the `base_url` already set as a default value. This method
returns the current value of `base_url`.

## `api_factory`

Returns an API factory object. You probably won't need to call this directly.

        $self->api_factory('Pet'); # returns a AsposeCellsCloud::PetApi instance

        $self->pet_api;            # the same

# MISSING METHODS

Most of the methods on the API are delegated to individual endpoint API objects
(e.g. Pet API, Store API, User API etc). Where different endpoint APIs use the
same method name (e.g. `new()`), these methods can't be delegated. So you need
to call `$api->pet_api->new()`.

In principle, every API is susceptible to the presence of a few, random, undelegatable
method names. In practice, because of the way method names are constructed, it's
unlikely in general that any methods will be undelegatable, except for:

        new()
        class_documentation()
        method_documentation()

To call these methods, you need to get a handle on the relevant object, either
by calling `$api->foo_api` or by retrieving an object, e.g.
`$api->get_pet_by_id(pet_id => $pet_id)`. They are class methods, so
you could also call them on class names.

# BUILDING YOUR LIBRARY

See the homepage `https://github.com/swagger-api/swagger-codegen` for full details.
But briefly, clone the git repository, build the codegen codebase, set up your build
config file, then run the API build script. You will need git, Java 7 or 8 and Apache
maven 3.0.3 or better already installed.

The config file should specify the project name for the generated library:

        {"moduleName":"WWW::MyProjectName"}

Your library files will be built under `WWW::MyProjectName`.

          $ git clone https://github.com/swagger-api/swagger-codegen.git
          $ cd swagger-codegen
          $ mvn package
          $ java -jar modules/swagger-codegen-cli/target/swagger-codegen-cli.jar generate \
    -i [URL or file path to JSON swagger API spec] \
    -l perl \
    -c /path/to/config/file.json \
    -o /path/to/output/folder

Bang, all done. Run the `autodoc` script in the `bin` directory to see the API
you just built.

# AUTOMATIC DOCUMENTATION

You can print out a summary of the generated API by running the included
`autodoc` script in the `bin` directory of your generated library. A few
output formats are supported:

          Usage: autodoc [OPTION]

    -w           wide format (default)
    -n           narrow format
    -p           POD format
    -H           HTML format
    -m           Markdown format
    -h           print this help message
    -c           your application class


The `-c` option allows you to load and inspect your own application. A dummy
namespace is used if you don't supply your own class.

# DOCUMENTATION FROM THE OpenAPI Spec

Additional documentation for each class and method may be provided by the Swagger
spec. If so, this is available via the `class_documentation()` and
`method_documentation()` methods on each generated object class, and the
`method_documentation()` method on the endpoint API classes:

        my $cmdoc = $api->pet_api->method_documentation->{$method_name};

        my $odoc = $api->get_pet_by_id->(pet_id => $pet_id)->class_documentation;
        my $omdoc = $api->get_pet_by_id->(pet_id => $pet_id)->method_documentation->{method_name};


Each of these calls returns a hashref with various useful pieces of information.

# LOAD THE MODULES

To load the API packages:
```perl
use AsposeCellsCloud::CellsApi;
use AsposeCellsCloud::CellsAutoFilterApi;
use AsposeCellsCloud::CellsAutoshapesApi;
use AsposeCellsCloud::CellsChartAreaApi;
use AsposeCellsCloud::CellsChartsApi;
use AsposeCellsCloud::CellsConditionalFormattingsApi;
use AsposeCellsCloud::CellsHypelinksApi;
use AsposeCellsCloud::CellsListObjectsApi;
use AsposeCellsCloud::CellsOleObjectsApi;
use AsposeCellsCloud::CellsPageBreaksApi;
use AsposeCellsCloud::CellsPageSetupApi;
use AsposeCellsCloud::CellsPicturesApi;
use AsposeCellsCloud::CellsPivotTablesApi;
use AsposeCellsCloud::CellsPropertiesApi;
use AsposeCellsCloud::CellsRangesApi;
use AsposeCellsCloud::CellsSaveAsApi;
use AsposeCellsCloud::CellsShapesApi;
use AsposeCellsCloud::CellsTaskApi;
use AsposeCellsCloud::CellsWorkbookApi;
use AsposeCellsCloud::CellsWorksheetValidationsApi;
use AsposeCellsCloud::CellsWorksheetsApi;
use AsposeCellsCloud::OAuthApi;

```

To load the models:
```perl
use AsposeCellsCloud::Object::AboveAverage;
use AsposeCellsCloud::Object::AccessTokenResponse;
use AsposeCellsCloud::Object::Area;
use AsposeCellsCloud::Object::AutoFitterOptions;
use AsposeCellsCloud::Object::Border;
use AsposeCellsCloud::Object::CalculationOptions;
use AsposeCellsCloud::Object::CellArea;
use AsposeCellsCloud::Object::CellValue;
use AsposeCellsCloud::Object::CellsColor;
use AsposeCellsCloud::Object::Color;
use AsposeCellsCloud::Object::ColorFilter;
use AsposeCellsCloud::Object::ColorFilterRequest;
use AsposeCellsCloud::Object::ColorScale;
use AsposeCellsCloud::Object::ConditionalFormattingIcon;
use AsposeCellsCloud::Object::ConditionalFormattingValue;
use AsposeCellsCloud::Object::CopyOptions;
use AsposeCellsCloud::Object::CreatePivotTableRequest;
use AsposeCellsCloud::Object::CustomFilter;
use AsposeCellsCloud::Object::CustomParserConfig;
use AsposeCellsCloud::Object::DataBar;
use AsposeCellsCloud::Object::DataBarBorder;
use AsposeCellsCloud::Object::DataSorter;
use AsposeCellsCloud::Object::DynamicFilter;
use AsposeCellsCloud::Object::FileSource;
use AsposeCellsCloud::Object::FillFormat;
use AsposeCellsCloud::Object::FilterColumn;
use AsposeCellsCloud::Object::Font;
use AsposeCellsCloud::Object::FontSetting;
use AsposeCellsCloud::Object::GradientFill;
use AsposeCellsCloud::Object::GradientFillStop;
use AsposeCellsCloud::Object::HorizontalPageBreak;
use AsposeCellsCloud::Object::IconFilter;
use AsposeCellsCloud::Object::IconSet;
use AsposeCellsCloud::Object::ImportOption;
use AsposeCellsCloud::Object::Line;
use AsposeCellsCloud::Object::Link;
use AsposeCellsCloud::Object::LinkElement;
use AsposeCellsCloud::Object::ListColumn;
use AsposeCellsCloud::Object::MultipleFilter;
use AsposeCellsCloud::Object::MultipleFilters;
use AsposeCellsCloud::Object::NegativeBarFormat;
use AsposeCellsCloud::Object::OperateObject;
use AsposeCellsCloud::Object::OperateObjectPosition;
use AsposeCellsCloud::Object::OperateParameter;
use AsposeCellsCloud::Object::PageSection;
use AsposeCellsCloud::Object::PasswordRequest;
use AsposeCellsCloud::Object::PasteOptions;
use AsposeCellsCloud::Object::PatternFill;
use AsposeCellsCloud::Object::PdfSecurityOptions;
use AsposeCellsCloud::Object::PicFormatOption;
use AsposeCellsCloud::Object::PivotField;
use AsposeCellsCloud::Object::PivotFilter;
use AsposeCellsCloud::Object::PivotItem;
use AsposeCellsCloud::Object::PivotTableFieldRequest;
use AsposeCellsCloud::Object::ProtectSheetParameter;
use AsposeCellsCloud::Object::Range;
use AsposeCellsCloud::Object::RangeCopyRequest;
use AsposeCellsCloud::Object::RangeSetOutlineBorderRequest;
use AsposeCellsCloud::Object::RangeSetStyleRequest;
use AsposeCellsCloud::Object::Ranges;
use AsposeCellsCloud::Object::ResultDestination;
use AsposeCellsCloud::Object::SaaSposeResponse;
use AsposeCellsCloud::Object::SaveOptions;
use AsposeCellsCloud::Object::SaveResult;
use AsposeCellsCloud::Object::ShadowEffect;
use AsposeCellsCloud::Object::SingleValue;
use AsposeCellsCloud::Object::SolidFill;
use AsposeCellsCloud::Object::SortKey;
use AsposeCellsCloud::Object::SplitResult;
use AsposeCellsCloud::Object::TaskData;
use AsposeCellsCloud::Object::TaskDescription;
use AsposeCellsCloud::Object::TaskParameter;
use AsposeCellsCloud::Object::TextureFill;
use AsposeCellsCloud::Object::ThemeColor;
use AsposeCellsCloud::Object::TilePicOption;
use AsposeCellsCloud::Object::Top10;
use AsposeCellsCloud::Object::Top10Filter;
use AsposeCellsCloud::Object::ValueType;
use AsposeCellsCloud::Object::VerticalPageBreak;
use AsposeCellsCloud::Object::Workbook;
use AsposeCellsCloud::Object::WorkbookEncryptionRequest;
use AsposeCellsCloud::Object::WorkbookProtectionRequest;
use AsposeCellsCloud::Object::WorkbookSettings;
use AsposeCellsCloud::Object::Worksheet;
use AsposeCellsCloud::Object::WorksheetMovingRequest;
use AsposeCellsCloud::Object::AutoFilter;
use AsposeCellsCloud::Object::AutoFilterResponse;
use AsposeCellsCloud::Object::AutoShapeResponse;
use AsposeCellsCloud::Object::AutoShapes;
use AsposeCellsCloud::Object::AutoShapesResponse;
use AsposeCellsCloud::Object::Cell;
use AsposeCellsCloud::Object::CellResponse;
use AsposeCellsCloud::Object::Cells;
use AsposeCellsCloud::Object::CellsDocumentProperties;
use AsposeCellsCloud::Object::CellsDocumentPropertiesResponse;
use AsposeCellsCloud::Object::CellsDocumentProperty;
use AsposeCellsCloud::Object::CellsDocumentPropertyResponse;
use AsposeCellsCloud::Object::CellsObjectOperateTaskParameter;
use AsposeCellsCloud::Object::CellsResponse;
use AsposeCellsCloud::Object::Chart;
use AsposeCellsCloud::Object::ChartAreaResponse;
use AsposeCellsCloud::Object::ChartFrame;
use AsposeCellsCloud::Object::ChartOperateParameter;
use AsposeCellsCloud::Object::Charts;
use AsposeCellsCloud::Object::ChartsResponse;
use AsposeCellsCloud::Object::Column;
use AsposeCellsCloud::Object::ColumnResponse;
use AsposeCellsCloud::Object::Columns;
use AsposeCellsCloud::Object::ColumnsResponse;
use AsposeCellsCloud::Object::Comment;
use AsposeCellsCloud::Object::CommentResponse;
use AsposeCellsCloud::Object::Comments;
use AsposeCellsCloud::Object::CommentsResponse;
use AsposeCellsCloud::Object::ConditionalFormatting;
use AsposeCellsCloud::Object::ConditionalFormattingResponse;
use AsposeCellsCloud::Object::ConditionalFormattings;
use AsposeCellsCloud::Object::ConditionalFormattingsResponse;
use AsposeCellsCloud::Object::ConvertTaskParameter;
use AsposeCellsCloud::Object::DifSaveOptions;
use AsposeCellsCloud::Object::FillFormatResponse;
use AsposeCellsCloud::Object::FormatCondition;
use AsposeCellsCloud::Object::HorizontalPageBreakResponse;
use AsposeCellsCloud::Object::HorizontalPageBreaks;
use AsposeCellsCloud::Object::HorizontalPageBreaksResponse;
use AsposeCellsCloud::Object::HtmlSaveOptions;
use AsposeCellsCloud::Object::Hyperlink;
use AsposeCellsCloud::Object::HyperlinkResponse;
use AsposeCellsCloud::Object::Hyperlinks;
use AsposeCellsCloud::Object::HyperlinksResponse;
use AsposeCellsCloud::Object::ImageSaveOptions;
use AsposeCellsCloud::Object::ImportBatchDataOption;
use AsposeCellsCloud::Object::ImportCSVDataOption;
use AsposeCellsCloud::Object::ImportDataTaskParameter;
use AsposeCellsCloud::Object::ImportDoubleArrayOption;
use AsposeCellsCloud::Object::ImportIntArrayOption;
use AsposeCellsCloud::Object::ImportStringArrayOption;
use AsposeCellsCloud::Object::LegendResponse;
use AsposeCellsCloud::Object::LineFormat;
use AsposeCellsCloud::Object::LineResponse;
use AsposeCellsCloud::Object::ListObject;
use AsposeCellsCloud::Object::ListObjectOperateParameter;
use AsposeCellsCloud::Object::ListObjectResponse;
use AsposeCellsCloud::Object::ListObjects;
use AsposeCellsCloud::Object::ListObjectsResponse;
use AsposeCellsCloud::Object::MHtmlSaveOptions;
use AsposeCellsCloud::Object::MergedCell;
use AsposeCellsCloud::Object::MergedCellResponse;
use AsposeCellsCloud::Object::MergedCells;
use AsposeCellsCloud::Object::MergedCellsResponse;
use AsposeCellsCloud::Object::Name;
use AsposeCellsCloud::Object::NameResponse;
use AsposeCellsCloud::Object::Names;
use AsposeCellsCloud::Object::NamesResponse;
use AsposeCellsCloud::Object::OdsSaveOptions;
use AsposeCellsCloud::Object::OleObjectResponse;
use AsposeCellsCloud::Object::OleObjects;
use AsposeCellsCloud::Object::OleObjectsResponse;
use AsposeCellsCloud::Object::OoxmlSaveOptions;
use AsposeCellsCloud::Object::PageBreakOperateParameter;
use AsposeCellsCloud::Object::PageSectionsResponse;
use AsposeCellsCloud::Object::PageSetup;
use AsposeCellsCloud::Object::PageSetupOperateParameter;
use AsposeCellsCloud::Object::PageSetupResponse;
use AsposeCellsCloud::Object::PdfSaveOptions;
use AsposeCellsCloud::Object::PictureResponse;
use AsposeCellsCloud::Object::Pictures;
use AsposeCellsCloud::Object::PicturesResponse;
use AsposeCellsCloud::Object::PivotFieldResponse;
use AsposeCellsCloud::Object::PivotFilterResponse;
use AsposeCellsCloud::Object::PivotFiltersResponse;
use AsposeCellsCloud::Object::PivotTable;
use AsposeCellsCloud::Object::PivotTableOperateParameter;
use AsposeCellsCloud::Object::PivotTableResponse;
use AsposeCellsCloud::Object::PivotTables;
use AsposeCellsCloud::Object::PivotTablesResponse;
use AsposeCellsCloud::Object::RangeValueResponse;
use AsposeCellsCloud::Object::RangesResponse;
use AsposeCellsCloud::Object::Row;
use AsposeCellsCloud::Object::RowResponse;
use AsposeCellsCloud::Object::Rows;
use AsposeCellsCloud::Object::RowsResponse;
use AsposeCellsCloud::Object::SaveResponse;
use AsposeCellsCloud::Object::SaveResultTaskParameter;
use AsposeCellsCloud::Object::Shape;
use AsposeCellsCloud::Object::ShapeOperateParameter;
use AsposeCellsCloud::Object::ShapeResponse;
use AsposeCellsCloud::Object::Shapes;
use AsposeCellsCloud::Object::ShapesResponse;
use AsposeCellsCloud::Object::SingleValueResponse;
use AsposeCellsCloud::Object::SmartMarkerTaskParameter;
use AsposeCellsCloud::Object::SplitResultDocument;
use AsposeCellsCloud::Object::SplitResultResponse;
use AsposeCellsCloud::Object::SplitWorkbookTaskParameter;
use AsposeCellsCloud::Object::SpreadsheetML2003SaveOptions;
use AsposeCellsCloud::Object::Style;
use AsposeCellsCloud::Object::StyleResponse;
use AsposeCellsCloud::Object::SvgSaveOptions;
use AsposeCellsCloud::Object::TextItem;
use AsposeCellsCloud::Object::TextItems;
use AsposeCellsCloud::Object::TextItemsResponse;
use AsposeCellsCloud::Object::TextOptions;
use AsposeCellsCloud::Object::TitleResponse;
use AsposeCellsCloud::Object::TxtSaveOptions;
use AsposeCellsCloud::Object::Validation;
use AsposeCellsCloud::Object::ValidationResponse;
use AsposeCellsCloud::Object::Validations;
use AsposeCellsCloud::Object::ValidationsResponse;
use AsposeCellsCloud::Object::VerticalPageBreakResponse;
use AsposeCellsCloud::Object::VerticalPageBreaks;
use AsposeCellsCloud::Object::VerticalPageBreaksResponse;
use AsposeCellsCloud::Object::WorkbookOperateParameter;
use AsposeCellsCloud::Object::WorkbookReplaceResponse;
use AsposeCellsCloud::Object::WorkbookResponse;
use AsposeCellsCloud::Object::WorkbookSettingsOperateParameter;
use AsposeCellsCloud::Object::WorkbookSettingsResponse;
use AsposeCellsCloud::Object::WorksheetReplaceResponse;
use AsposeCellsCloud::Object::WorksheetResponse;
use AsposeCellsCloud::Object::Worksheets;
use AsposeCellsCloud::Object::WorksheetsResponse;
use AsposeCellsCloud::Object::XlsSaveOptions;
use AsposeCellsCloud::Object::XlsbSaveOptions;
use AsposeCellsCloud::Object::XpsSaveOptions;
use AsposeCellsCloud::Object::AutoShape;
use AsposeCellsCloud::Object::ChartArea;
use AsposeCellsCloud::Object::Legend;
use AsposeCellsCloud::Object::OleObject;
use AsposeCellsCloud::Object::Picture;
use AsposeCellsCloud::Object::Title;

````

# GETTING STARTED
Put the Perl SDK under the 'lib' folder in your project directory, then run the following
```perl
#!/usr/bin/perl
use lib 'lib';
use strict;
use warnings;
# load the API package
use AsposeCellsCloud::CellsApi;
use AsposeCellsCloud::CellsAutoFilterApi;
use AsposeCellsCloud::CellsAutoshapesApi;
use AsposeCellsCloud::CellsChartAreaApi;
use AsposeCellsCloud::CellsChartsApi;
use AsposeCellsCloud::CellsConditionalFormattingsApi;
use AsposeCellsCloud::CellsHypelinksApi;
use AsposeCellsCloud::CellsListObjectsApi;
use AsposeCellsCloud::CellsOleObjectsApi;
use AsposeCellsCloud::CellsPageBreaksApi;
use AsposeCellsCloud::CellsPageSetupApi;
use AsposeCellsCloud::CellsPicturesApi;
use AsposeCellsCloud::CellsPivotTablesApi;
use AsposeCellsCloud::CellsPropertiesApi;
use AsposeCellsCloud::CellsRangesApi;
use AsposeCellsCloud::CellsSaveAsApi;
use AsposeCellsCloud::CellsShapesApi;
use AsposeCellsCloud::CellsTaskApi;
use AsposeCellsCloud::CellsWorkbookApi;
use AsposeCellsCloud::CellsWorksheetValidationsApi;
use AsposeCellsCloud::CellsWorksheetsApi;
use AsposeCellsCloud::OAuthApi;

# load the models
use AsposeCellsCloud::Object::AboveAverage;
use AsposeCellsCloud::Object::AccessTokenResponse;
use AsposeCellsCloud::Object::Area;
use AsposeCellsCloud::Object::AutoFitterOptions;
use AsposeCellsCloud::Object::Border;
use AsposeCellsCloud::Object::CalculationOptions;
use AsposeCellsCloud::Object::CellArea;
use AsposeCellsCloud::Object::CellValue;
use AsposeCellsCloud::Object::CellsColor;
use AsposeCellsCloud::Object::Color;
use AsposeCellsCloud::Object::ColorFilter;
use AsposeCellsCloud::Object::ColorFilterRequest;
use AsposeCellsCloud::Object::ColorScale;
use AsposeCellsCloud::Object::ConditionalFormattingIcon;
use AsposeCellsCloud::Object::ConditionalFormattingValue;
use AsposeCellsCloud::Object::CopyOptions;
use AsposeCellsCloud::Object::CreatePivotTableRequest;
use AsposeCellsCloud::Object::CustomFilter;
use AsposeCellsCloud::Object::CustomParserConfig;
use AsposeCellsCloud::Object::DataBar;
use AsposeCellsCloud::Object::DataBarBorder;
use AsposeCellsCloud::Object::DataSorter;
use AsposeCellsCloud::Object::DynamicFilter;
use AsposeCellsCloud::Object::FileSource;
use AsposeCellsCloud::Object::FillFormat;
use AsposeCellsCloud::Object::FilterColumn;
use AsposeCellsCloud::Object::Font;
use AsposeCellsCloud::Object::FontSetting;
use AsposeCellsCloud::Object::GradientFill;
use AsposeCellsCloud::Object::GradientFillStop;
use AsposeCellsCloud::Object::HorizontalPageBreak;
use AsposeCellsCloud::Object::IconFilter;
use AsposeCellsCloud::Object::IconSet;
use AsposeCellsCloud::Object::ImportOption;
use AsposeCellsCloud::Object::Line;
use AsposeCellsCloud::Object::Link;
use AsposeCellsCloud::Object::LinkElement;
use AsposeCellsCloud::Object::ListColumn;
use AsposeCellsCloud::Object::MultipleFilter;
use AsposeCellsCloud::Object::MultipleFilters;
use AsposeCellsCloud::Object::NegativeBarFormat;
use AsposeCellsCloud::Object::OperateObject;
use AsposeCellsCloud::Object::OperateObjectPosition;
use AsposeCellsCloud::Object::OperateParameter;
use AsposeCellsCloud::Object::PageSection;
use AsposeCellsCloud::Object::PasswordRequest;
use AsposeCellsCloud::Object::PasteOptions;
use AsposeCellsCloud::Object::PatternFill;
use AsposeCellsCloud::Object::PdfSecurityOptions;
use AsposeCellsCloud::Object::PicFormatOption;
use AsposeCellsCloud::Object::PivotField;
use AsposeCellsCloud::Object::PivotFilter;
use AsposeCellsCloud::Object::PivotItem;
use AsposeCellsCloud::Object::PivotTableFieldRequest;
use AsposeCellsCloud::Object::ProtectSheetParameter;
use AsposeCellsCloud::Object::Range;
use AsposeCellsCloud::Object::RangeCopyRequest;
use AsposeCellsCloud::Object::RangeSetOutlineBorderRequest;
use AsposeCellsCloud::Object::RangeSetStyleRequest;
use AsposeCellsCloud::Object::Ranges;
use AsposeCellsCloud::Object::ResultDestination;
use AsposeCellsCloud::Object::SaaSposeResponse;
use AsposeCellsCloud::Object::SaveOptions;
use AsposeCellsCloud::Object::SaveResult;
use AsposeCellsCloud::Object::ShadowEffect;
use AsposeCellsCloud::Object::SingleValue;
use AsposeCellsCloud::Object::SolidFill;
use AsposeCellsCloud::Object::SortKey;
use AsposeCellsCloud::Object::SplitResult;
use AsposeCellsCloud::Object::TaskData;
use AsposeCellsCloud::Object::TaskDescription;
use AsposeCellsCloud::Object::TaskParameter;
use AsposeCellsCloud::Object::TextureFill;
use AsposeCellsCloud::Object::ThemeColor;
use AsposeCellsCloud::Object::TilePicOption;
use AsposeCellsCloud::Object::Top10;
use AsposeCellsCloud::Object::Top10Filter;
use AsposeCellsCloud::Object::ValueType;
use AsposeCellsCloud::Object::VerticalPageBreak;
use AsposeCellsCloud::Object::Workbook;
use AsposeCellsCloud::Object::WorkbookEncryptionRequest;
use AsposeCellsCloud::Object::WorkbookProtectionRequest;
use AsposeCellsCloud::Object::WorkbookSettings;
use AsposeCellsCloud::Object::Worksheet;
use AsposeCellsCloud::Object::WorksheetMovingRequest;
use AsposeCellsCloud::Object::AutoFilter;
use AsposeCellsCloud::Object::AutoFilterResponse;
use AsposeCellsCloud::Object::AutoShapeResponse;
use AsposeCellsCloud::Object::AutoShapes;
use AsposeCellsCloud::Object::AutoShapesResponse;
use AsposeCellsCloud::Object::Cell;
use AsposeCellsCloud::Object::CellResponse;
use AsposeCellsCloud::Object::Cells;
use AsposeCellsCloud::Object::CellsDocumentProperties;
use AsposeCellsCloud::Object::CellsDocumentPropertiesResponse;
use AsposeCellsCloud::Object::CellsDocumentProperty;
use AsposeCellsCloud::Object::CellsDocumentPropertyResponse;
use AsposeCellsCloud::Object::CellsObjectOperateTaskParameter;
use AsposeCellsCloud::Object::CellsResponse;
use AsposeCellsCloud::Object::Chart;
use AsposeCellsCloud::Object::ChartAreaResponse;
use AsposeCellsCloud::Object::ChartFrame;
use AsposeCellsCloud::Object::ChartOperateParameter;
use AsposeCellsCloud::Object::Charts;
use AsposeCellsCloud::Object::ChartsResponse;
use AsposeCellsCloud::Object::Column;
use AsposeCellsCloud::Object::ColumnResponse;
use AsposeCellsCloud::Object::Columns;
use AsposeCellsCloud::Object::ColumnsResponse;
use AsposeCellsCloud::Object::Comment;
use AsposeCellsCloud::Object::CommentResponse;
use AsposeCellsCloud::Object::Comments;
use AsposeCellsCloud::Object::CommentsResponse;
use AsposeCellsCloud::Object::ConditionalFormatting;
use AsposeCellsCloud::Object::ConditionalFormattingResponse;
use AsposeCellsCloud::Object::ConditionalFormattings;
use AsposeCellsCloud::Object::ConditionalFormattingsResponse;
use AsposeCellsCloud::Object::ConvertTaskParameter;
use AsposeCellsCloud::Object::DifSaveOptions;
use AsposeCellsCloud::Object::FillFormatResponse;
use AsposeCellsCloud::Object::FormatCondition;
use AsposeCellsCloud::Object::HorizontalPageBreakResponse;
use AsposeCellsCloud::Object::HorizontalPageBreaks;
use AsposeCellsCloud::Object::HorizontalPageBreaksResponse;
use AsposeCellsCloud::Object::HtmlSaveOptions;
use AsposeCellsCloud::Object::Hyperlink;
use AsposeCellsCloud::Object::HyperlinkResponse;
use AsposeCellsCloud::Object::Hyperlinks;
use AsposeCellsCloud::Object::HyperlinksResponse;
use AsposeCellsCloud::Object::ImageSaveOptions;
use AsposeCellsCloud::Object::ImportBatchDataOption;
use AsposeCellsCloud::Object::ImportCSVDataOption;
use AsposeCellsCloud::Object::ImportDataTaskParameter;
use AsposeCellsCloud::Object::ImportDoubleArrayOption;
use AsposeCellsCloud::Object::ImportIntArrayOption;
use AsposeCellsCloud::Object::ImportStringArrayOption;
use AsposeCellsCloud::Object::LegendResponse;
use AsposeCellsCloud::Object::LineFormat;
use AsposeCellsCloud::Object::LineResponse;
use AsposeCellsCloud::Object::ListObject;
use AsposeCellsCloud::Object::ListObjectOperateParameter;
use AsposeCellsCloud::Object::ListObjectResponse;
use AsposeCellsCloud::Object::ListObjects;
use AsposeCellsCloud::Object::ListObjectsResponse;
use AsposeCellsCloud::Object::MHtmlSaveOptions;
use AsposeCellsCloud::Object::MergedCell;
use AsposeCellsCloud::Object::MergedCellResponse;
use AsposeCellsCloud::Object::MergedCells;
use AsposeCellsCloud::Object::MergedCellsResponse;
use AsposeCellsCloud::Object::Name;
use AsposeCellsCloud::Object::NameResponse;
use AsposeCellsCloud::Object::Names;
use AsposeCellsCloud::Object::NamesResponse;
use AsposeCellsCloud::Object::OdsSaveOptions;
use AsposeCellsCloud::Object::OleObjectResponse;
use AsposeCellsCloud::Object::OleObjects;
use AsposeCellsCloud::Object::OleObjectsResponse;
use AsposeCellsCloud::Object::OoxmlSaveOptions;
use AsposeCellsCloud::Object::PageBreakOperateParameter;
use AsposeCellsCloud::Object::PageSectionsResponse;
use AsposeCellsCloud::Object::PageSetup;
use AsposeCellsCloud::Object::PageSetupOperateParameter;
use AsposeCellsCloud::Object::PageSetupResponse;
use AsposeCellsCloud::Object::PdfSaveOptions;
use AsposeCellsCloud::Object::PictureResponse;
use AsposeCellsCloud::Object::Pictures;
use AsposeCellsCloud::Object::PicturesResponse;
use AsposeCellsCloud::Object::PivotFieldResponse;
use AsposeCellsCloud::Object::PivotFilterResponse;
use AsposeCellsCloud::Object::PivotFiltersResponse;
use AsposeCellsCloud::Object::PivotTable;
use AsposeCellsCloud::Object::PivotTableOperateParameter;
use AsposeCellsCloud::Object::PivotTableResponse;
use AsposeCellsCloud::Object::PivotTables;
use AsposeCellsCloud::Object::PivotTablesResponse;
use AsposeCellsCloud::Object::RangeValueResponse;
use AsposeCellsCloud::Object::RangesResponse;
use AsposeCellsCloud::Object::Row;
use AsposeCellsCloud::Object::RowResponse;
use AsposeCellsCloud::Object::Rows;
use AsposeCellsCloud::Object::RowsResponse;
use AsposeCellsCloud::Object::SaveResponse;
use AsposeCellsCloud::Object::SaveResultTaskParameter;
use AsposeCellsCloud::Object::Shape;
use AsposeCellsCloud::Object::ShapeOperateParameter;
use AsposeCellsCloud::Object::ShapeResponse;
use AsposeCellsCloud::Object::Shapes;
use AsposeCellsCloud::Object::ShapesResponse;
use AsposeCellsCloud::Object::SingleValueResponse;
use AsposeCellsCloud::Object::SmartMarkerTaskParameter;
use AsposeCellsCloud::Object::SplitResultDocument;
use AsposeCellsCloud::Object::SplitResultResponse;
use AsposeCellsCloud::Object::SplitWorkbookTaskParameter;
use AsposeCellsCloud::Object::SpreadsheetML2003SaveOptions;
use AsposeCellsCloud::Object::Style;
use AsposeCellsCloud::Object::StyleResponse;
use AsposeCellsCloud::Object::SvgSaveOptions;
use AsposeCellsCloud::Object::TextItem;
use AsposeCellsCloud::Object::TextItems;
use AsposeCellsCloud::Object::TextItemsResponse;
use AsposeCellsCloud::Object::TextOptions;
use AsposeCellsCloud::Object::TitleResponse;
use AsposeCellsCloud::Object::TxtSaveOptions;
use AsposeCellsCloud::Object::Validation;
use AsposeCellsCloud::Object::ValidationResponse;
use AsposeCellsCloud::Object::Validations;
use AsposeCellsCloud::Object::ValidationsResponse;
use AsposeCellsCloud::Object::VerticalPageBreakResponse;
use AsposeCellsCloud::Object::VerticalPageBreaks;
use AsposeCellsCloud::Object::VerticalPageBreaksResponse;
use AsposeCellsCloud::Object::WorkbookOperateParameter;
use AsposeCellsCloud::Object::WorkbookReplaceResponse;
use AsposeCellsCloud::Object::WorkbookResponse;
use AsposeCellsCloud::Object::WorkbookSettingsOperateParameter;
use AsposeCellsCloud::Object::WorkbookSettingsResponse;
use AsposeCellsCloud::Object::WorksheetReplaceResponse;
use AsposeCellsCloud::Object::WorksheetResponse;
use AsposeCellsCloud::Object::Worksheets;
use AsposeCellsCloud::Object::WorksheetsResponse;
use AsposeCellsCloud::Object::XlsSaveOptions;
use AsposeCellsCloud::Object::XlsbSaveOptions;
use AsposeCellsCloud::Object::XpsSaveOptions;
use AsposeCellsCloud::Object::AutoShape;
use AsposeCellsCloud::Object::ChartArea;
use AsposeCellsCloud::Object::Legend;
use AsposeCellsCloud::Object::OleObject;
use AsposeCellsCloud::Object::Picture;
use AsposeCellsCloud::Object::Title;

# for displaying the API response data
use Data::Dumper;
use AsposeCellsCloud::;

my $api_instance = AsposeCellsCloud::->new(
);

my $name = 'name_example'; # string | The workbook name.
my $sheet_name = 'sheet_name_example'; # string | The worksheet name.
my $column_index = 56; # int | The column index.
my $columns = 56; # int | The columns.
my $update_reference = 1; # boolean | The update reference.
my $folder = 'folder_example'; # string | The workbook folder.
my $storage = 'storage_example'; # string | storage name.

eval {
    my $result = $api_instance->cells_delete_worksheet_columns(name => $name, sheet_name => $sheet_name, column_index => $column_index, columns => $columns, update_reference => $update_reference, folder => $folder, storage => $storage);
    print Dumper($result);
};
if ($@) {
    warn "Exception when calling CellsApi->cells_delete_worksheet_columns: $@\n";
}

```

# DOCUMENTATION FOR API ENDPOINTS

All URIs are relative to *https://api.aspose.cloud/v1.1/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CellsApi* | [**cells_delete_worksheet_columns**](docs/CellsApi.md#cells_delete_worksheet_columns) | **DELETE** /cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex} | Delete worksheet columns.
*CellsApi* | [**cells_delete_worksheet_row**](docs/CellsApi.md#cells_delete_worksheet_row) | **DELETE** /cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex} | Delete worksheet row.
*CellsApi* | [**cells_delete_worksheet_rows**](docs/CellsApi.md#cells_delete_worksheet_rows) | **DELETE** /cells/{name}/worksheets/{sheetName}/cells/rows | Delete several worksheet rows.
*CellsApi* | [**cells_get_cell_html_string**](docs/CellsApi.md#cells_get_cell_html_string) | **GET** /cells/{name}/worksheets/{sheetName}/cells/{cellName}/htmlstring | Read cell data by cell&#39;s name.
*CellsApi* | [**cells_get_worksheet_cell**](docs/CellsApi.md#cells_get_worksheet_cell) | **GET** /cells/{name}/worksheets/{sheetName}/cells/{cellOrMethodName} | Read cell data by cell&#39;s name.
*CellsApi* | [**cells_get_worksheet_cell_style**](docs/CellsApi.md#cells_get_worksheet_cell_style) | **GET** /cells/{name}/worksheets/{sheetName}/cells/{cellName}/style | Read cell&#39;s style info.
*CellsApi* | [**cells_get_worksheet_cells**](docs/CellsApi.md#cells_get_worksheet_cells) | **GET** /cells/{name}/worksheets/{sheetName}/cells | Get cells info.
*CellsApi* | [**cells_get_worksheet_column**](docs/CellsApi.md#cells_get_worksheet_column) | **GET** /cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex} | Read worksheet column data by column&#39;s index.
*CellsApi* | [**cells_get_worksheet_columns**](docs/CellsApi.md#cells_get_worksheet_columns) | **GET** /cells/{name}/worksheets/{sheetName}/cells/columns | Read worksheet columns info.
*CellsApi* | [**cells_get_worksheet_row**](docs/CellsApi.md#cells_get_worksheet_row) | **GET** /cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex} | Read worksheet row data by row&#39;s index.
*CellsApi* | [**cells_get_worksheet_rows**](docs/CellsApi.md#cells_get_worksheet_rows) | **GET** /cells/{name}/worksheets/{sheetName}/cells/rows | Read worksheet rows info.
*CellsApi* | [**cells_post_cell_calculate**](docs/CellsApi.md#cells_post_cell_calculate) | **POST** /cells/{name}/worksheets/{sheetName}/cells/{cellName}/calculate | Cell calculate formula
*CellsApi* | [**cells_post_cell_characters**](docs/CellsApi.md#cells_post_cell_characters) | **POST** /cells/{name}/worksheets/{sheetName}/cells/{cellName}/characters | Set cell characters 
*CellsApi* | [**cells_post_clear_contents**](docs/CellsApi.md#cells_post_clear_contents) | **POST** /cells/{name}/worksheets/{sheetName}/cells/clearcontents | Clear cells contents.
*CellsApi* | [**cells_post_clear_formats**](docs/CellsApi.md#cells_post_clear_formats) | **POST** /cells/{name}/worksheets/{sheetName}/cells/clearformats | Clear cells contents.
*CellsApi* | [**cells_post_column_style**](docs/CellsApi.md#cells_post_column_style) | **POST** /cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}/style | Set column style
*CellsApi* | [**cells_post_copy_cell_into_cell**](docs/CellsApi.md#cells_post_copy_cell_into_cell) | **POST** /cells/{name}/worksheets/{sheetName}/cells/{destCellName}/copy | Copy cell into cell
*CellsApi* | [**cells_post_copy_worksheet_columns**](docs/CellsApi.md#cells_post_copy_worksheet_columns) | **POST** /cells/{name}/worksheets/{sheetName}/cells/columns/copy | Copy worksheet columns.
*CellsApi* | [**cells_post_copy_worksheet_rows**](docs/CellsApi.md#cells_post_copy_worksheet_rows) | **POST** /cells/{name}/worksheets/{sheetName}/cells/rows/copy | Copy worksheet rows.
*CellsApi* | [**cells_post_group_worksheet_columns**](docs/CellsApi.md#cells_post_group_worksheet_columns) | **POST** /cells/{name}/worksheets/{sheetName}/cells/columns/group | Group worksheet columns.
*CellsApi* | [**cells_post_group_worksheet_rows**](docs/CellsApi.md#cells_post_group_worksheet_rows) | **POST** /cells/{name}/worksheets/{sheetName}/cells/rows/group | Group worksheet rows.
*CellsApi* | [**cells_post_hide_worksheet_columns**](docs/CellsApi.md#cells_post_hide_worksheet_columns) | **POST** /cells/{name}/worksheets/{sheetName}/cells/columns/hide | Hide worksheet columns.
*CellsApi* | [**cells_post_hide_worksheet_rows**](docs/CellsApi.md#cells_post_hide_worksheet_rows) | **POST** /cells/{name}/worksheets/{sheetName}/cells/rows/hide | Hide worksheet rows.
*CellsApi* | [**cells_post_row_style**](docs/CellsApi.md#cells_post_row_style) | **POST** /cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}/style | Set row style.
*CellsApi* | [**cells_post_set_cell_html_string**](docs/CellsApi.md#cells_post_set_cell_html_string) | **POST** /cells/{name}/worksheets/{sheetName}/cells/{cellName}/htmlstring | Set htmlstring value into cell
*CellsApi* | [**cells_post_set_cell_range_value**](docs/CellsApi.md#cells_post_set_cell_range_value) | **POST** /cells/{name}/worksheets/{sheetName}/cells | Set cell range value 
*CellsApi* | [**cells_post_set_worksheet_column_width**](docs/CellsApi.md#cells_post_set_worksheet_column_width) | **POST** /cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex} | Set worksheet column width.
*CellsApi* | [**cells_post_ungroup_worksheet_columns**](docs/CellsApi.md#cells_post_ungroup_worksheet_columns) | **POST** /cells/{name}/worksheets/{sheetName}/cells/columns/ungroup | Ungroup worksheet columns.
*CellsApi* | [**cells_post_ungroup_worksheet_rows**](docs/CellsApi.md#cells_post_ungroup_worksheet_rows) | **POST** /cells/{name}/worksheets/{sheetName}/cells/rows/ungroup | Ungroup worksheet rows.
*CellsApi* | [**cells_post_unhide_worksheet_columns**](docs/CellsApi.md#cells_post_unhide_worksheet_columns) | **POST** /cells/{name}/worksheets/{sheetName}/cells/columns/unhide | Unhide worksheet columns.
*CellsApi* | [**cells_post_unhide_worksheet_rows**](docs/CellsApi.md#cells_post_unhide_worksheet_rows) | **POST** /cells/{name}/worksheets/{sheetName}/cells/rows/unhide | Unhide worksheet rows.
*CellsApi* | [**cells_post_update_worksheet_cell_style**](docs/CellsApi.md#cells_post_update_worksheet_cell_style) | **POST** /cells/{name}/worksheets/{sheetName}/cells/{cellName}/style | Update cell&#39;s style.
*CellsApi* | [**cells_post_update_worksheet_range_style**](docs/CellsApi.md#cells_post_update_worksheet_range_style) | **POST** /cells/{name}/worksheets/{sheetName}/cells/style | Update cell&#39;s range style.
*CellsApi* | [**cells_post_update_worksheet_row**](docs/CellsApi.md#cells_post_update_worksheet_row) | **POST** /cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex} | Update worksheet row.
*CellsApi* | [**cells_post_worksheet_cell_set_value**](docs/CellsApi.md#cells_post_worksheet_cell_set_value) | **POST** /cells/{name}/worksheets/{sheetName}/cells/{cellName} | Set cell value.
*CellsApi* | [**cells_post_worksheet_merge**](docs/CellsApi.md#cells_post_worksheet_merge) | **POST** /cells/{name}/worksheets/{sheetName}/cells/merge | Merge cells.
*CellsApi* | [**cells_post_worksheet_unmerge**](docs/CellsApi.md#cells_post_worksheet_unmerge) | **POST** /cells/{name}/worksheets/{sheetName}/cells/unmerge | Unmerge cells.
*CellsApi* | [**cells_put_insert_worksheet_columns**](docs/CellsApi.md#cells_put_insert_worksheet_columns) | **PUT** /cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex} | Insert worksheet columns.
*CellsApi* | [**cells_put_insert_worksheet_row**](docs/CellsApi.md#cells_put_insert_worksheet_row) | **PUT** /cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex} | Insert new worksheet row.
*CellsApi* | [**cells_put_insert_worksheet_rows**](docs/CellsApi.md#cells_put_insert_worksheet_rows) | **PUT** /cells/{name}/worksheets/{sheetName}/cells/rows | Insert several new worksheet rows.
*CellsAutoFilterApi* | [**cells_auto_filter_delete_worksheet_date_filter**](docs/CellsAutoFilterApi.md#cells_auto_filter_delete_worksheet_date_filter) | **DELETE** /cells/{name}/worksheets/{sheetName}/autoFilter/dateFilter | Removes a date filter.             
*CellsAutoFilterApi* | [**cells_auto_filter_delete_worksheet_filter**](docs/CellsAutoFilterApi.md#cells_auto_filter_delete_worksheet_filter) | **DELETE** /cells/{name}/worksheets/{sheetName}/autoFilter/filter | Delete a filter for a filter column.             
*CellsAutoFilterApi* | [**cells_auto_filter_get_worksheet_auto_filter**](docs/CellsAutoFilterApi.md#cells_auto_filter_get_worksheet_auto_filter) | **GET** /cells/{name}/worksheets/{sheetName}/autoFilter | Get Auto filter Description
*CellsAutoFilterApi* | [**cells_auto_filter_post_worksheet_auto_filter_refresh**](docs/CellsAutoFilterApi.md#cells_auto_filter_post_worksheet_auto_filter_refresh) | **POST** /cells/{name}/worksheets/{sheetName}/autoFilter/refresh | 
*CellsAutoFilterApi* | [**cells_auto_filter_post_worksheet_match_blanks**](docs/CellsAutoFilterApi.md#cells_auto_filter_post_worksheet_match_blanks) | **POST** /cells/{name}/worksheets/{sheetName}/autoFilter/matchBlanks | Match all blank cell in the list.
*CellsAutoFilterApi* | [**cells_auto_filter_post_worksheet_match_non_blanks**](docs/CellsAutoFilterApi.md#cells_auto_filter_post_worksheet_match_non_blanks) | **POST** /cells/{name}/worksheets/{sheetName}/autoFilter/matchNonBlanks | Match all not blank cell in the list.             
*CellsAutoFilterApi* | [**cells_auto_filter_put_worksheet_color_filter**](docs/CellsAutoFilterApi.md#cells_auto_filter_put_worksheet_color_filter) | **PUT** /cells/{name}/worksheets/{sheetName}/autoFilter/colorFilter | 
*CellsAutoFilterApi* | [**cells_auto_filter_put_worksheet_custom_filter**](docs/CellsAutoFilterApi.md#cells_auto_filter_put_worksheet_custom_filter) | **PUT** /cells/{name}/worksheets/{sheetName}/autoFilter/custom | Filters a list with a custom criteria.             
*CellsAutoFilterApi* | [**cells_auto_filter_put_worksheet_date_filter**](docs/CellsAutoFilterApi.md#cells_auto_filter_put_worksheet_date_filter) | **PUT** /cells/{name}/worksheets/{sheetName}/autoFilter/dateFilter | add date filter in worksheet 
*CellsAutoFilterApi* | [**cells_auto_filter_put_worksheet_dynamic_filter**](docs/CellsAutoFilterApi.md#cells_auto_filter_put_worksheet_dynamic_filter) | **PUT** /cells/{name}/worksheets/{sheetName}/autoFilter/dynamicFilter | 
*CellsAutoFilterApi* | [**cells_auto_filter_put_worksheet_filter**](docs/CellsAutoFilterApi.md#cells_auto_filter_put_worksheet_filter) | **PUT** /cells/{name}/worksheets/{sheetName}/autoFilter/filter | Adds a filter for a filter column.             
*CellsAutoFilterApi* | [**cells_auto_filter_put_worksheet_filter_top10**](docs/CellsAutoFilterApi.md#cells_auto_filter_put_worksheet_filter_top10) | **PUT** /cells/{name}/worksheets/{sheetName}/autoFilter/filterTop10 | Filter the top 10 item in the list
*CellsAutoFilterApi* | [**cells_auto_filter_put_worksheet_icon_filter**](docs/CellsAutoFilterApi.md#cells_auto_filter_put_worksheet_icon_filter) | **PUT** /cells/{name}/worksheets/{sheetName}/autoFilter/iconFilter | Adds an icon filter.
*CellsAutoshapesApi* | [**cells_autoshapes_get_worksheet_autoshape**](docs/CellsAutoshapesApi.md#cells_autoshapes_get_worksheet_autoshape) | **GET** /cells/{name}/worksheets/{sheetName}/autoshapes/{autoshapeNumber} | Get autoshape info.
*CellsAutoshapesApi* | [**cells_autoshapes_get_worksheet_autoshapes**](docs/CellsAutoshapesApi.md#cells_autoshapes_get_worksheet_autoshapes) | **GET** /cells/{name}/worksheets/{sheetName}/autoshapes | Get worksheet autoshapes info.
*CellsChartAreaApi* | [**cells_chart_area_get_chart_area**](docs/CellsChartAreaApi.md#cells_chart_area_get_chart_area) | **GET** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/chartArea | Get chart area info.
*CellsChartAreaApi* | [**cells_chart_area_get_chart_area_border**](docs/CellsChartAreaApi.md#cells_chart_area_get_chart_area_border) | **GET** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/chartArea/border | Get chart area border info.
*CellsChartAreaApi* | [**cells_chart_area_get_chart_area_fill_format**](docs/CellsChartAreaApi.md#cells_chart_area_get_chart_area_fill_format) | **GET** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/chartArea/fillFormat | Get chart area fill format info.
*CellsChartsApi* | [**cells_charts_delete_worksheet_chart_legend**](docs/CellsChartsApi.md#cells_charts_delete_worksheet_chart_legend) | **DELETE** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend | Hide legend in chart
*CellsChartsApi* | [**cells_charts_delete_worksheet_chart_title**](docs/CellsChartsApi.md#cells_charts_delete_worksheet_chart_title) | **DELETE** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title | Hide title in chart
*CellsChartsApi* | [**cells_charts_delete_worksheet_clear_charts**](docs/CellsChartsApi.md#cells_charts_delete_worksheet_clear_charts) | **DELETE** /cells/{name}/worksheets/{sheetName}/charts | Clear the charts.
*CellsChartsApi* | [**cells_charts_delete_worksheet_delete_chart**](docs/CellsChartsApi.md#cells_charts_delete_worksheet_delete_chart) | **DELETE** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex} | Delete worksheet chart by index.
*CellsChartsApi* | [**cells_charts_get_worksheet_chart**](docs/CellsChartsApi.md#cells_charts_get_worksheet_chart) | **GET** /cells/{name}/worksheets/{sheetName}/charts/{chartNumber} | Get chart info.
*CellsChartsApi* | [**cells_charts_get_worksheet_chart_legend**](docs/CellsChartsApi.md#cells_charts_get_worksheet_chart_legend) | **GET** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend | Get chart legend
*CellsChartsApi* | [**cells_charts_get_worksheet_chart_title**](docs/CellsChartsApi.md#cells_charts_get_worksheet_chart_title) | **GET** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title | Get chart title
*CellsChartsApi* | [**cells_charts_get_worksheet_charts**](docs/CellsChartsApi.md#cells_charts_get_worksheet_charts) | **GET** /cells/{name}/worksheets/{sheetName}/charts | Get worksheet charts info.
*CellsChartsApi* | [**cells_charts_post_worksheet_chart**](docs/CellsChartsApi.md#cells_charts_post_worksheet_chart) | **POST** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex} | Update chart propreties
*CellsChartsApi* | [**cells_charts_post_worksheet_chart_legend**](docs/CellsChartsApi.md#cells_charts_post_worksheet_chart_legend) | **POST** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend | Update chart legend
*CellsChartsApi* | [**cells_charts_post_worksheet_chart_title**](docs/CellsChartsApi.md#cells_charts_post_worksheet_chart_title) | **POST** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title | Update chart title
*CellsChartsApi* | [**cells_charts_put_worksheet_add_chart**](docs/CellsChartsApi.md#cells_charts_put_worksheet_add_chart) | **PUT** /cells/{name}/worksheets/{sheetName}/charts | Add new chart to worksheet.
*CellsChartsApi* | [**cells_charts_put_worksheet_chart_legend**](docs/CellsChartsApi.md#cells_charts_put_worksheet_chart_legend) | **PUT** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend | Show legend in chart
*CellsChartsApi* | [**cells_charts_put_worksheet_chart_title**](docs/CellsChartsApi.md#cells_charts_put_worksheet_chart_title) | **PUT** /cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title | Add chart title / Set chart title visible
*CellsConditionalFormattingsApi* | [**cells_conditional_formattings_delete_worksheet_conditional_formatting**](docs/CellsConditionalFormattingsApi.md#cells_conditional_formattings_delete_worksheet_conditional_formatting) | **DELETE** /cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index} | Remove conditional formatting
*CellsConditionalFormattingsApi* | [**cells_conditional_formattings_delete_worksheet_conditional_formatting_area**](docs/CellsConditionalFormattingsApi.md#cells_conditional_formattings_delete_worksheet_conditional_formatting_area) | **DELETE** /cells/{name}/worksheets/{sheetName}/conditionalFormattings/area | Remove cell area from conditional formatting.
*CellsConditionalFormattingsApi* | [**cells_conditional_formattings_delete_worksheet_conditional_formattings**](docs/CellsConditionalFormattingsApi.md#cells_conditional_formattings_delete_worksheet_conditional_formattings) | **DELETE** /cells/{name}/worksheets/{sheetName}/conditionalFormattings | Clear all condition formattings
*CellsConditionalFormattingsApi* | [**cells_conditional_formattings_get_worksheet_conditional_formatting**](docs/CellsConditionalFormattingsApi.md#cells_conditional_formattings_get_worksheet_conditional_formatting) | **GET** /cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index} | Get conditional formatting
*CellsConditionalFormattingsApi* | [**cells_conditional_formattings_get_worksheet_conditional_formattings**](docs/CellsConditionalFormattingsApi.md#cells_conditional_formattings_get_worksheet_conditional_formattings) | **GET** /cells/{name}/worksheets/{sheetName}/conditionalFormattings | Get conditional formattings 
*CellsConditionalFormattingsApi* | [**cells_conditional_formattings_put_worksheet_conditional_formatting**](docs/CellsConditionalFormattingsApi.md#cells_conditional_formattings_put_worksheet_conditional_formatting) | **PUT** /cells/{name}/worksheets/{sheetName}/conditionalFormattings | Add a condition formatting.
*CellsConditionalFormattingsApi* | [**cells_conditional_formattings_put_worksheet_format_condition**](docs/CellsConditionalFormattingsApi.md#cells_conditional_formattings_put_worksheet_format_condition) | **PUT** /cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index} | Add a format condition.
*CellsConditionalFormattingsApi* | [**cells_conditional_formattings_put_worksheet_format_condition_area**](docs/CellsConditionalFormattingsApi.md#cells_conditional_formattings_put_worksheet_format_condition_area) | **PUT** /cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}/area | add a cell area for format condition             
*CellsConditionalFormattingsApi* | [**cells_conditional_formattings_put_worksheet_format_condition_condition**](docs/CellsConditionalFormattingsApi.md#cells_conditional_formattings_put_worksheet_format_condition_condition) | **PUT** /cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}/condition | Add a condition for format condition.
*CellsHypelinksApi* | [**cells_hypelinks_delete_worksheet_hyperlink**](docs/CellsHypelinksApi.md#cells_hypelinks_delete_worksheet_hyperlink) | **DELETE** /cells/{name}/worksheets/{sheetName}/hyperlinks/{hyperlinkIndex} | Delete worksheet hyperlink by index.
*CellsHypelinksApi* | [**cells_hypelinks_delete_worksheet_hyperlinks**](docs/CellsHypelinksApi.md#cells_hypelinks_delete_worksheet_hyperlinks) | **DELETE** /cells/{name}/worksheets/{sheetName}/hyperlinks | Delete all hyperlinks in worksheet.
*CellsHypelinksApi* | [**cells_hypelinks_get_worksheet_hyperlink**](docs/CellsHypelinksApi.md#cells_hypelinks_get_worksheet_hyperlink) | **GET** /cells/{name}/worksheets/{sheetName}/hyperlinks/{hyperlinkIndex} | Get worksheet hyperlink by index.
*CellsHypelinksApi* | [**cells_hypelinks_get_worksheet_hyperlinks**](docs/CellsHypelinksApi.md#cells_hypelinks_get_worksheet_hyperlinks) | **GET** /cells/{name}/worksheets/{sheetName}/hyperlinks | Get worksheet hyperlinks.
*CellsHypelinksApi* | [**cells_hypelinks_post_worksheet_hyperlink**](docs/CellsHypelinksApi.md#cells_hypelinks_post_worksheet_hyperlink) | **POST** /cells/{name}/worksheets/{sheetName}/hyperlinks/{hyperlinkIndex} | Update worksheet hyperlink by index.
*CellsHypelinksApi* | [**cells_hypelinks_put_worksheet_hyperlink**](docs/CellsHypelinksApi.md#cells_hypelinks_put_worksheet_hyperlink) | **PUT** /cells/{name}/worksheets/{sheetName}/hyperlinks | Add worksheet hyperlink.
*CellsListObjectsApi* | [**cells_list_objects_delete_worksheet_list_object**](docs/CellsListObjectsApi.md#cells_list_objects_delete_worksheet_list_object) | **DELETE** /cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex} | Delete worksheet list object by index
*CellsListObjectsApi* | [**cells_list_objects_delete_worksheet_list_objects**](docs/CellsListObjectsApi.md#cells_list_objects_delete_worksheet_list_objects) | **DELETE** /cells/{name}/worksheets/{sheetName}/listobjects | Delete worksheet list objects
*CellsListObjectsApi* | [**cells_list_objects_get_worksheet_list_object**](docs/CellsListObjectsApi.md#cells_list_objects_get_worksheet_list_object) | **GET** /cells/{name}/worksheets/{sheetName}/listobjects/{listobjectindex} | Get worksheet list object info by index.
*CellsListObjectsApi* | [**cells_list_objects_get_worksheet_list_objects**](docs/CellsListObjectsApi.md#cells_list_objects_get_worksheet_list_objects) | **GET** /cells/{name}/worksheets/{sheetName}/listobjects | Get worksheet listobjects info.
*CellsListObjectsApi* | [**cells_list_objects_post_worksheet_list_object**](docs/CellsListObjectsApi.md#cells_list_objects_post_worksheet_list_object) | **POST** /cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex} | Update  list object 
*CellsListObjectsApi* | [**cells_list_objects_post_worksheet_list_object_convert_to_range**](docs/CellsListObjectsApi.md#cells_list_objects_post_worksheet_list_object_convert_to_range) | **POST** /cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}/ConvertToRange | 
*CellsListObjectsApi* | [**cells_list_objects_post_worksheet_list_object_sort_table**](docs/CellsListObjectsApi.md#cells_list_objects_post_worksheet_list_object_sort_table) | **POST** /cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}/sort | 
*CellsListObjectsApi* | [**cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table**](docs/CellsListObjectsApi.md#cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table) | **POST** /cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}/SummarizeWithPivotTable | 
*CellsListObjectsApi* | [**cells_list_objects_put_worksheet_list_object**](docs/CellsListObjectsApi.md#cells_list_objects_put_worksheet_list_object) | **PUT** /cells/{name}/worksheets/{sheetName}/listobjects | Add a list object into worksheet.
*CellsOleObjectsApi* | [**cells_ole_objects_delete_worksheet_ole_object**](docs/CellsOleObjectsApi.md#cells_ole_objects_delete_worksheet_ole_object) | **DELETE** /cells/{name}/worksheets/{sheetName}/oleobjects/{oleObjectIndex} | Delete OLE object.
*CellsOleObjectsApi* | [**cells_ole_objects_delete_worksheet_ole_objects**](docs/CellsOleObjectsApi.md#cells_ole_objects_delete_worksheet_ole_objects) | **DELETE** /cells/{name}/worksheets/{sheetName}/oleobjects | Delete all OLE objects.
*CellsOleObjectsApi* | [**cells_ole_objects_get_worksheet_ole_object**](docs/CellsOleObjectsApi.md#cells_ole_objects_get_worksheet_ole_object) | **GET** /cells/{name}/worksheets/{sheetName}/oleobjects/{objectNumber} | Get OLE object info.
*CellsOleObjectsApi* | [**cells_ole_objects_get_worksheet_ole_objects**](docs/CellsOleObjectsApi.md#cells_ole_objects_get_worksheet_ole_objects) | **GET** /cells/{name}/worksheets/{sheetName}/oleobjects | Get worksheet OLE objects info.
*CellsOleObjectsApi* | [**cells_ole_objects_post_update_worksheet_ole_object**](docs/CellsOleObjectsApi.md#cells_ole_objects_post_update_worksheet_ole_object) | **POST** /cells/{name}/worksheets/{sheetName}/oleobjects/{oleObjectIndex} | Update OLE object.
*CellsOleObjectsApi* | [**cells_ole_objects_put_worksheet_ole_object**](docs/CellsOleObjectsApi.md#cells_ole_objects_put_worksheet_ole_object) | **PUT** /cells/{name}/worksheets/{sheetName}/oleobjects | Add OLE object
*CellsPageBreaksApi* | [**cells_page_breaks_delete_horizontal_page_break**](docs/CellsPageBreaksApi.md#cells_page_breaks_delete_horizontal_page_break) | **DELETE** /cells/{name}/worksheets/{sheetName}/horizontalpagebreaks/{index} | 
*CellsPageBreaksApi* | [**cells_page_breaks_delete_horizontal_page_breaks**](docs/CellsPageBreaksApi.md#cells_page_breaks_delete_horizontal_page_breaks) | **DELETE** /cells/{name}/worksheets/{sheetName}/horizontalpagebreaks | 
*CellsPageBreaksApi* | [**cells_page_breaks_delete_vertical_page_break**](docs/CellsPageBreaksApi.md#cells_page_breaks_delete_vertical_page_break) | **DELETE** /cells/{name}/worksheets/{sheetName}/verticalpagebreaks/{index} | 
*CellsPageBreaksApi* | [**cells_page_breaks_delete_vertical_page_breaks**](docs/CellsPageBreaksApi.md#cells_page_breaks_delete_vertical_page_breaks) | **DELETE** /cells/{name}/worksheets/{sheetName}/verticalpagebreaks | 
*CellsPageBreaksApi* | [**cells_page_breaks_get_horizontal_page_break**](docs/CellsPageBreaksApi.md#cells_page_breaks_get_horizontal_page_break) | **GET** /cells/{name}/worksheets/{sheetName}/horizontalpagebreaks/{index} | 
*CellsPageBreaksApi* | [**cells_page_breaks_get_horizontal_page_breaks**](docs/CellsPageBreaksApi.md#cells_page_breaks_get_horizontal_page_breaks) | **GET** /cells/{name}/worksheets/{sheetName}/horizontalpagebreaks | 
*CellsPageBreaksApi* | [**cells_page_breaks_get_vertical_page_break**](docs/CellsPageBreaksApi.md#cells_page_breaks_get_vertical_page_break) | **GET** /cells/{name}/worksheets/{sheetName}/verticalpagebreaks/{index} | 
*CellsPageBreaksApi* | [**cells_page_breaks_get_vertical_page_breaks**](docs/CellsPageBreaksApi.md#cells_page_breaks_get_vertical_page_breaks) | **GET** /cells/{name}/worksheets/{sheetName}/verticalpagebreaks | 
*CellsPageBreaksApi* | [**cells_page_breaks_put_horizontal_page_break**](docs/CellsPageBreaksApi.md#cells_page_breaks_put_horizontal_page_break) | **PUT** /cells/{name}/worksheets/{sheetName}/horizontalpagebreaks | 
*CellsPageBreaksApi* | [**cells_page_breaks_put_vertical_page_break**](docs/CellsPageBreaksApi.md#cells_page_breaks_put_vertical_page_break) | **PUT** /cells/{name}/worksheets/{sheetName}/verticalpagebreaks | 
*CellsPageSetupApi* | [**cells_page_setup_delete_header_footer**](docs/CellsPageSetupApi.md#cells_page_setup_delete_header_footer) | **DELETE** /cells/{name}/worksheets/{sheetName}/pagesetup/clearheaderfooter | clear header footer
*CellsPageSetupApi* | [**cells_page_setup_get_footer**](docs/CellsPageSetupApi.md#cells_page_setup_get_footer) | **GET** /cells/{name}/worksheets/{sheetName}/pagesetup/footer | get page footer information
*CellsPageSetupApi* | [**cells_page_setup_get_header**](docs/CellsPageSetupApi.md#cells_page_setup_get_header) | **GET** /cells/{name}/worksheets/{sheetName}/pagesetup/header | get page header information
*CellsPageSetupApi* | [**cells_page_setup_get_page_setup**](docs/CellsPageSetupApi.md#cells_page_setup_get_page_setup) | **GET** /cells/{name}/worksheets/{sheetName}/pagesetup | Get Page Setup information.             
*CellsPageSetupApi* | [**cells_page_setup_post_footer**](docs/CellsPageSetupApi.md#cells_page_setup_post_footer) | **POST** /cells/{name}/worksheets/{sheetName}/pagesetup/footer | update  page footer information 
*CellsPageSetupApi* | [**cells_page_setup_post_header**](docs/CellsPageSetupApi.md#cells_page_setup_post_header) | **POST** /cells/{name}/worksheets/{sheetName}/pagesetup/header | update  page header information 
*CellsPageSetupApi* | [**cells_page_setup_post_page_setup**](docs/CellsPageSetupApi.md#cells_page_setup_post_page_setup) | **POST** /cells/{name}/worksheets/{sheetName}/pagesetup | Update Page Setup information.
*CellsPicturesApi* | [**cells_pictures_delete_worksheet_picture**](docs/CellsPicturesApi.md#cells_pictures_delete_worksheet_picture) | **DELETE** /cells/{name}/worksheets/{sheetName}/pictures/{pictureIndex} | Delete a picture object in worksheet
*CellsPicturesApi* | [**cells_pictures_delete_worksheet_pictures**](docs/CellsPicturesApi.md#cells_pictures_delete_worksheet_pictures) | **DELETE** /cells/{name}/worksheets/{sheetName}/pictures | Delete all pictures in worksheet.
*CellsPicturesApi* | [**cells_pictures_get_worksheet_picture**](docs/CellsPicturesApi.md#cells_pictures_get_worksheet_picture) | **GET** /cells/{name}/worksheets/{sheetName}/pictures/{pictureIndex} | GRead worksheet picture by number.
*CellsPicturesApi* | [**cells_pictures_get_worksheet_pictures**](docs/CellsPicturesApi.md#cells_pictures_get_worksheet_pictures) | **GET** /cells/{name}/worksheets/{sheetName}/pictures | Read worksheet pictures.
*CellsPicturesApi* | [**cells_pictures_post_worksheet_picture**](docs/CellsPicturesApi.md#cells_pictures_post_worksheet_picture) | **POST** /cells/{name}/worksheets/{sheetName}/pictures/{pictureIndex} | Update worksheet picture by index.
*CellsPicturesApi* | [**cells_pictures_put_worksheet_add_picture**](docs/CellsPicturesApi.md#cells_pictures_put_worksheet_add_picture) | **PUT** /cells/{name}/worksheets/{sheetName}/pictures | Add a new worksheet picture.
*CellsPivotTablesApi* | [**cells_pivot_tables_delete_pivot_table_field**](docs/CellsPivotTablesApi.md#cells_pivot_tables_delete_pivot_table_field) | **DELETE** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField | Delete pivot field into into pivot table
*CellsPivotTablesApi* | [**cells_pivot_tables_delete_worksheet_pivot_table**](docs/CellsPivotTablesApi.md#cells_pivot_tables_delete_worksheet_pivot_table) | **DELETE** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex} | Delete worksheet pivot table by index
*CellsPivotTablesApi* | [**cells_pivot_tables_delete_worksheet_pivot_table_filter**](docs/CellsPivotTablesApi.md#cells_pivot_tables_delete_worksheet_pivot_table_filter) | **DELETE** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters/{fieldIndex} | delete  pivot filter for piovt table             
*CellsPivotTablesApi* | [**cells_pivot_tables_delete_worksheet_pivot_table_filters**](docs/CellsPivotTablesApi.md#cells_pivot_tables_delete_worksheet_pivot_table_filters) | **DELETE** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters | delete all pivot filters for piovt table
*CellsPivotTablesApi* | [**cells_pivot_tables_delete_worksheet_pivot_tables**](docs/CellsPivotTablesApi.md#cells_pivot_tables_delete_worksheet_pivot_tables) | **DELETE** /cells/{name}/worksheets/{sheetName}/pivottables | Delete worksheet pivot tables
*CellsPivotTablesApi* | [**cells_pivot_tables_get_pivot_table_field**](docs/CellsPivotTablesApi.md#cells_pivot_tables_get_pivot_table_field) | **GET** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField | Get pivot field into into pivot table
*CellsPivotTablesApi* | [**cells_pivot_tables_get_worksheet_pivot_table**](docs/CellsPivotTablesApi.md#cells_pivot_tables_get_worksheet_pivot_table) | **GET** /cells/{name}/worksheets/{sheetName}/pivottables/{pivottableIndex} | Get worksheet pivottable info by index.
*CellsPivotTablesApi* | [**cells_pivot_tables_get_worksheet_pivot_table_filter**](docs/CellsPivotTablesApi.md#cells_pivot_tables_get_worksheet_pivot_table_filter) | **GET** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters/{filterIndex} | 
*CellsPivotTablesApi* | [**cells_pivot_tables_get_worksheet_pivot_table_filters**](docs/CellsPivotTablesApi.md#cells_pivot_tables_get_worksheet_pivot_table_filters) | **GET** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters | 
*CellsPivotTablesApi* | [**cells_pivot_tables_get_worksheet_pivot_tables**](docs/CellsPivotTablesApi.md#cells_pivot_tables_get_worksheet_pivot_tables) | **GET** /cells/{name}/worksheets/{sheetName}/pivottables | Get worksheet pivottables info.
*CellsPivotTablesApi* | [**cells_pivot_tables_post_pivot_table_cell_style**](docs/CellsPivotTablesApi.md#cells_pivot_tables_post_pivot_table_cell_style) | **POST** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/Format | Update cell style for pivot table
*CellsPivotTablesApi* | [**cells_pivot_tables_post_pivot_table_field_hide_item**](docs/CellsPivotTablesApi.md#cells_pivot_tables_post_pivot_table_field_hide_item) | **POST** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField/Hide | 
*CellsPivotTablesApi* | [**cells_pivot_tables_post_pivot_table_field_move_to**](docs/CellsPivotTablesApi.md#cells_pivot_tables_post_pivot_table_field_move_to) | **POST** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField/Move | 
*CellsPivotTablesApi* | [**cells_pivot_tables_post_pivot_table_style**](docs/CellsPivotTablesApi.md#cells_pivot_tables_post_pivot_table_style) | **POST** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/FormatAll | Update style for pivot table
*CellsPivotTablesApi* | [**cells_pivot_tables_post_worksheet_pivot_table_calculate**](docs/CellsPivotTablesApi.md#cells_pivot_tables_post_worksheet_pivot_table_calculate) | **POST** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/Calculate | Calculates pivottable&#39;s data to cells.
*CellsPivotTablesApi* | [**cells_pivot_tables_post_worksheet_pivot_table_move**](docs/CellsPivotTablesApi.md#cells_pivot_tables_post_worksheet_pivot_table_move) | **POST** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/Move | 
*CellsPivotTablesApi* | [**cells_pivot_tables_put_pivot_table_field**](docs/CellsPivotTablesApi.md#cells_pivot_tables_put_pivot_table_field) | **PUT** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField | Add pivot field into into pivot table
*CellsPivotTablesApi* | [**cells_pivot_tables_put_worksheet_pivot_table**](docs/CellsPivotTablesApi.md#cells_pivot_tables_put_worksheet_pivot_table) | **PUT** /cells/{name}/worksheets/{sheetName}/pivottables | Add a pivot table into worksheet.
*CellsPivotTablesApi* | [**cells_pivot_tables_put_worksheet_pivot_table_filter**](docs/CellsPivotTablesApi.md#cells_pivot_tables_put_worksheet_pivot_table_filter) | **PUT** /cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters | Add pivot filter for piovt table index
*CellsPropertiesApi* | [**cells_properties_delete_document_properties**](docs/CellsPropertiesApi.md#cells_properties_delete_document_properties) | **DELETE** /cells/{name}/documentproperties | Delete all custom document properties and clean built-in ones.
*CellsPropertiesApi* | [**cells_properties_delete_document_property**](docs/CellsPropertiesApi.md#cells_properties_delete_document_property) | **DELETE** /cells/{name}/documentproperties/{propertyName} | Delete document property.
*CellsPropertiesApi* | [**cells_properties_get_document_properties**](docs/CellsPropertiesApi.md#cells_properties_get_document_properties) | **GET** /cells/{name}/documentproperties | Read document properties.
*CellsPropertiesApi* | [**cells_properties_get_document_property**](docs/CellsPropertiesApi.md#cells_properties_get_document_property) | **GET** /cells/{name}/documentproperties/{propertyName} | Read document property by name.
*CellsPropertiesApi* | [**cells_properties_put_document_property**](docs/CellsPropertiesApi.md#cells_properties_put_document_property) | **PUT** /cells/{name}/documentproperties/{propertyName} | Set/create document property.
*CellsRangesApi* | [**cells_ranges_get_worksheet_cells_range_value**](docs/CellsRangesApi.md#cells_ranges_get_worksheet_cells_range_value) | **GET** /cells/{name}/worksheets/{sheetName}/ranges/value | Get cells list in a range by range name or row column indexes  
*CellsRangesApi* | [**cells_ranges_post_worksheet_cells_range_column_width**](docs/CellsRangesApi.md#cells_ranges_post_worksheet_cells_range_column_width) | **POST** /cells/{name}/worksheets/{sheetName}/ranges/columnWidth | Set column width of range
*CellsRangesApi* | [**cells_ranges_post_worksheet_cells_range_merge**](docs/CellsRangesApi.md#cells_ranges_post_worksheet_cells_range_merge) | **POST** /cells/{name}/worksheets/{sheetName}/ranges/merge | Combines a range of cells into a single cell.              
*CellsRangesApi* | [**cells_ranges_post_worksheet_cells_range_move_to**](docs/CellsRangesApi.md#cells_ranges_post_worksheet_cells_range_move_to) | **POST** /cells/{name}/worksheets/{sheetName}/ranges/moveto | Move the current range to the dest range.             
*CellsRangesApi* | [**cells_ranges_post_worksheet_cells_range_outline_border**](docs/CellsRangesApi.md#cells_ranges_post_worksheet_cells_range_outline_border) | **POST** /cells/{name}/worksheets/{sheetName}/ranges/outlineBorder | Sets outline border around a range of cells.
*CellsRangesApi* | [**cells_ranges_post_worksheet_cells_range_row_height**](docs/CellsRangesApi.md#cells_ranges_post_worksheet_cells_range_row_height) | **POST** /cells/{name}/worksheets/{sheetName}/ranges/rowHeight | set row height of range
*CellsRangesApi* | [**cells_ranges_post_worksheet_cells_range_style**](docs/CellsRangesApi.md#cells_ranges_post_worksheet_cells_range_style) | **POST** /cells/{name}/worksheets/{sheetName}/ranges/style | Sets the style of the range.             
*CellsRangesApi* | [**cells_ranges_post_worksheet_cells_range_unmerge**](docs/CellsRangesApi.md#cells_ranges_post_worksheet_cells_range_unmerge) | **POST** /cells/{name}/worksheets/{sheetName}/ranges/unmerge | Unmerges merged cells of this range.             
*CellsRangesApi* | [**cells_ranges_post_worksheet_cells_range_value**](docs/CellsRangesApi.md#cells_ranges_post_worksheet_cells_range_value) | **POST** /cells/{name}/worksheets/{sheetName}/ranges/value | Puts a value into the range, if appropriate the value will be converted to other data type and cell&#39;s number format will be reset.             
*CellsRangesApi* | [**cells_ranges_post_worksheet_cells_ranges**](docs/CellsRangesApi.md#cells_ranges_post_worksheet_cells_ranges) | **POST** /cells/{name}/worksheets/{sheetName}/ranges | copy range in the worksheet
*CellsSaveAsApi* | [**cells_save_as_post_document_save_as**](docs/CellsSaveAsApi.md#cells_save_as_post_document_save_as) | **POST** /cells/{name}/SaveAs | Convert document and save result to storage.
*CellsShapesApi* | [**cells_shapes_delete_worksheet_shape**](docs/CellsShapesApi.md#cells_shapes_delete_worksheet_shape) | **DELETE** /cells/{name}/worksheets/{sheetName}/shapes/{shapeindex} | Delete a shape in worksheet
*CellsShapesApi* | [**cells_shapes_delete_worksheet_shapes**](docs/CellsShapesApi.md#cells_shapes_delete_worksheet_shapes) | **DELETE** /cells/{name}/worksheets/{sheetName}/shapes | delete all shapes in worksheet
*CellsShapesApi* | [**cells_shapes_get_worksheet_shape**](docs/CellsShapesApi.md#cells_shapes_get_worksheet_shape) | **GET** /cells/{name}/worksheets/{sheetName}/shapes/{shapeindex} | Get worksheet shape
*CellsShapesApi* | [**cells_shapes_get_worksheet_shapes**](docs/CellsShapesApi.md#cells_shapes_get_worksheet_shapes) | **GET** /cells/{name}/worksheets/{sheetName}/shapes | Get worksheet shapes 
*CellsShapesApi* | [**cells_shapes_post_worksheet_shape**](docs/CellsShapesApi.md#cells_shapes_post_worksheet_shape) | **POST** /cells/{name}/worksheets/{sheetName}/shapes/{shapeindex} | Update a shape in worksheet
*CellsShapesApi* | [**cells_shapes_put_worksheet_shape**](docs/CellsShapesApi.md#cells_shapes_put_worksheet_shape) | **PUT** /cells/{name}/worksheets/{sheetName}/shapes | Add shape in worksheet
*CellsTaskApi* | [**cells_task_post_run_task**](docs/CellsTaskApi.md#cells_task_post_run_task) | **POST** /cells/task/runtask | Run tasks  
*CellsWorkbookApi* | [**cells_workbook_delete_decrypt_document**](docs/CellsWorkbookApi.md#cells_workbook_delete_decrypt_document) | **DELETE** /cells/{name}/encryption | Decrypt document.
*CellsWorkbookApi* | [**cells_workbook_delete_document_unprotect_from_changes**](docs/CellsWorkbookApi.md#cells_workbook_delete_document_unprotect_from_changes) | **DELETE** /cells/{name}/writeProtection | Unprotect document from changes.
*CellsWorkbookApi* | [**cells_workbook_delete_unprotect_document**](docs/CellsWorkbookApi.md#cells_workbook_delete_unprotect_document) | **DELETE** /cells/{name}/protection | Unprotect document.
*CellsWorkbookApi* | [**cells_workbook_delete_workbook_name**](docs/CellsWorkbookApi.md#cells_workbook_delete_workbook_name) | **DELETE** /cells/{name}/names/{nameName} | Clean workbook&#39;s names.
*CellsWorkbookApi* | [**cells_workbook_delete_workbook_names**](docs/CellsWorkbookApi.md#cells_workbook_delete_workbook_names) | **DELETE** /cells/{name}/names | Clean workbook&#39;s names.
*CellsWorkbookApi* | [**cells_workbook_get_workbook**](docs/CellsWorkbookApi.md#cells_workbook_get_workbook) | **GET** /cells/{name} | Read workbook info or export.
*CellsWorkbookApi* | [**cells_workbook_get_workbook_default_style**](docs/CellsWorkbookApi.md#cells_workbook_get_workbook_default_style) | **GET** /cells/{name}/defaultstyle | Read workbook default style info.
*CellsWorkbookApi* | [**cells_workbook_get_workbook_name**](docs/CellsWorkbookApi.md#cells_workbook_get_workbook_name) | **GET** /cells/{name}/names/{nameName} | Read workbook&#39;s name.
*CellsWorkbookApi* | [**cells_workbook_get_workbook_name_value**](docs/CellsWorkbookApi.md#cells_workbook_get_workbook_name_value) | **GET** /cells/{name}/names/{nameName}/value | Get workbook&#39;s name value.
*CellsWorkbookApi* | [**cells_workbook_get_workbook_names**](docs/CellsWorkbookApi.md#cells_workbook_get_workbook_names) | **GET** /cells/{name}/names | Read workbook&#39;s names.
*CellsWorkbookApi* | [**cells_workbook_get_workbook_settings**](docs/CellsWorkbookApi.md#cells_workbook_get_workbook_settings) | **GET** /cells/{name}/settings | Get Workbook Settings DTO
*CellsWorkbookApi* | [**cells_workbook_get_workbook_text_items**](docs/CellsWorkbookApi.md#cells_workbook_get_workbook_text_items) | **GET** /cells/{name}/textItems | Read workbook&#39;s text items.
*CellsWorkbookApi* | [**cells_workbook_post_autofit_workbook_rows**](docs/CellsWorkbookApi.md#cells_workbook_post_autofit_workbook_rows) | **POST** /cells/{name}/autofitrows | Autofit workbook rows.
*CellsWorkbookApi* | [**cells_workbook_post_encrypt_document**](docs/CellsWorkbookApi.md#cells_workbook_post_encrypt_document) | **POST** /cells/{name}/encryption | Encript document.
*CellsWorkbookApi* | [**cells_workbook_post_import_data**](docs/CellsWorkbookApi.md#cells_workbook_post_import_data) | **POST** /cells/{name}/importdata | 
*CellsWorkbookApi* | [**cells_workbook_post_protect_document**](docs/CellsWorkbookApi.md#cells_workbook_post_protect_document) | **POST** /cells/{name}/protection | Protect document.
*CellsWorkbookApi* | [**cells_workbook_post_workbook_calculate_formula**](docs/CellsWorkbookApi.md#cells_workbook_post_workbook_calculate_formula) | **POST** /cells/{name}/calculateformula | Calculate all formulas in workbook.
*CellsWorkbookApi* | [**cells_workbook_post_workbook_get_smart_marker_result**](docs/CellsWorkbookApi.md#cells_workbook_post_workbook_get_smart_marker_result) | **POST** /cells/{name}/smartmarker | Smart marker processing result.
*CellsWorkbookApi* | [**cells_workbook_post_workbook_settings**](docs/CellsWorkbookApi.md#cells_workbook_post_workbook_settings) | **POST** /cells/{name}/settings | Update Workbook setting 
*CellsWorkbookApi* | [**cells_workbook_post_workbook_split**](docs/CellsWorkbookApi.md#cells_workbook_post_workbook_split) | **POST** /cells/{name}/split | Split workbook.
*CellsWorkbookApi* | [**cells_workbook_post_workbooks_merge**](docs/CellsWorkbookApi.md#cells_workbook_post_workbooks_merge) | **POST** /cells/{name}/merge | Merge workbooks.
*CellsWorkbookApi* | [**cells_workbook_post_workbooks_text_replace**](docs/CellsWorkbookApi.md#cells_workbook_post_workbooks_text_replace) | **POST** /cells/{name}/replaceText | Replace text.
*CellsWorkbookApi* | [**cells_workbook_post_workbooks_text_search**](docs/CellsWorkbookApi.md#cells_workbook_post_workbooks_text_search) | **POST** /cells/{name}/findText | Search text.
*CellsWorkbookApi* | [**cells_workbook_put_convert_workbook**](docs/CellsWorkbookApi.md#cells_workbook_put_convert_workbook) | **PUT** /cells/convert | Convert workbook from request content to some format.
*CellsWorkbookApi* | [**cells_workbook_put_document_protect_from_changes**](docs/CellsWorkbookApi.md#cells_workbook_put_document_protect_from_changes) | **PUT** /cells/{name}/writeProtection | Protect document from changes.
*CellsWorkbookApi* | [**cells_workbook_put_workbook_create**](docs/CellsWorkbookApi.md#cells_workbook_put_workbook_create) | **PUT** /cells/{name} | Create new workbook using deferent methods.
*CellsWorksheetValidationsApi* | [**cells_worksheet_validations_delete_worksheet_validation**](docs/CellsWorksheetValidationsApi.md#cells_worksheet_validations_delete_worksheet_validation) | **DELETE** /cells/{name}/worksheets/{sheetName}/validations/{validationIndex} | Delete worksheet validation by index.
*CellsWorksheetValidationsApi* | [**cells_worksheet_validations_get_worksheet_validation**](docs/CellsWorksheetValidationsApi.md#cells_worksheet_validations_get_worksheet_validation) | **GET** /cells/{name}/worksheets/{sheetName}/validations/{validationIndex} | Get worksheet validation by index.
*CellsWorksheetValidationsApi* | [**cells_worksheet_validations_get_worksheet_validations**](docs/CellsWorksheetValidationsApi.md#cells_worksheet_validations_get_worksheet_validations) | **GET** /cells/{name}/worksheets/{sheetName}/validations | Get worksheet validations.
*CellsWorksheetValidationsApi* | [**cells_worksheet_validations_post_worksheet_validation**](docs/CellsWorksheetValidationsApi.md#cells_worksheet_validations_post_worksheet_validation) | **POST** /cells/{name}/worksheets/{sheetName}/validations/{validationIndex} | Update worksheet validation by index.
*CellsWorksheetValidationsApi* | [**cells_worksheet_validations_put_worksheet_validation**](docs/CellsWorksheetValidationsApi.md#cells_worksheet_validations_put_worksheet_validation) | **PUT** /cells/{name}/worksheets/{sheetName}/validations | Add worksheet validation at index.
*CellsWorksheetsApi* | [**cells_worksheets_delete_unprotect_worksheet**](docs/CellsWorksheetsApi.md#cells_worksheets_delete_unprotect_worksheet) | **DELETE** /cells/{name}/worksheets/{sheetName}/protection | Unprotect worksheet.
*CellsWorksheetsApi* | [**cells_worksheets_delete_worksheet**](docs/CellsWorksheetsApi.md#cells_worksheets_delete_worksheet) | **DELETE** /cells/{name}/worksheets/{sheetName} | Delete worksheet.
*CellsWorksheetsApi* | [**cells_worksheets_delete_worksheet_background**](docs/CellsWorksheetsApi.md#cells_worksheets_delete_worksheet_background) | **DELETE** /cells/{name}/worksheets/{sheetName}/background | Set worksheet background image.
*CellsWorksheetsApi* | [**cells_worksheets_delete_worksheet_comment**](docs/CellsWorksheetsApi.md#cells_worksheets_delete_worksheet_comment) | **DELETE** /cells/{name}/worksheets/{sheetName}/comments/{cellName} | Delete worksheet&#39;s cell comment.
*CellsWorksheetsApi* | [**cells_worksheets_delete_worksheet_comments**](docs/CellsWorksheetsApi.md#cells_worksheets_delete_worksheet_comments) | **DELETE** /cells/{name}/worksheets/{sheetName}/comments | Delete all comments for worksheet.
*CellsWorksheetsApi* | [**cells_worksheets_delete_worksheet_freeze_panes**](docs/CellsWorksheetsApi.md#cells_worksheets_delete_worksheet_freeze_panes) | **DELETE** /cells/{name}/worksheets/{sheetName}/freezepanes | Unfreeze panes
*CellsWorksheetsApi* | [**cells_worksheets_get_named_ranges**](docs/CellsWorksheetsApi.md#cells_worksheets_get_named_ranges) | **GET** /cells/{name}/worksheets/ranges | Read worksheets ranges info.
*CellsWorksheetsApi* | [**cells_worksheets_get_worksheet**](docs/CellsWorksheetsApi.md#cells_worksheets_get_worksheet) | **GET** /cells/{name}/worksheets/{sheetName} | Read worksheet info or export.
*CellsWorksheetsApi* | [**cells_worksheets_get_worksheet_calculate_formula**](docs/CellsWorksheetsApi.md#cells_worksheets_get_worksheet_calculate_formula) | **GET** /cells/{name}/worksheets/{sheetName}/formulaResult | Calculate formula value.
*CellsWorksheetsApi* | [**cells_worksheets_get_worksheet_comment**](docs/CellsWorksheetsApi.md#cells_worksheets_get_worksheet_comment) | **GET** /cells/{name}/worksheets/{sheetName}/comments/{cellName} | Get worksheet comment by cell name.
*CellsWorksheetsApi* | [**cells_worksheets_get_worksheet_comments**](docs/CellsWorksheetsApi.md#cells_worksheets_get_worksheet_comments) | **GET** /cells/{name}/worksheets/{sheetName}/comments | Get worksheet comments.
*CellsWorksheetsApi* | [**cells_worksheets_get_worksheet_merged_cell**](docs/CellsWorksheetsApi.md#cells_worksheets_get_worksheet_merged_cell) | **GET** /cells/{name}/worksheets/{sheetName}/mergedCells/{mergedCellIndex} | Get worksheet merged cell by its index.
*CellsWorksheetsApi* | [**cells_worksheets_get_worksheet_merged_cells**](docs/CellsWorksheetsApi.md#cells_worksheets_get_worksheet_merged_cells) | **GET** /cells/{name}/worksheets/{sheetName}/mergedCells | Get worksheet merged cells.
*CellsWorksheetsApi* | [**cells_worksheets_get_worksheet_text_items**](docs/CellsWorksheetsApi.md#cells_worksheets_get_worksheet_text_items) | **GET** /cells/{name}/worksheets/{sheetName}/textItems | Get worksheet text items.
*CellsWorksheetsApi* | [**cells_worksheets_get_worksheets**](docs/CellsWorksheetsApi.md#cells_worksheets_get_worksheets) | **GET** /cells/{name}/worksheets | Read worksheets info.
*CellsWorksheetsApi* | [**cells_worksheets_post_autofit_worksheet_columns**](docs/CellsWorksheetsApi.md#cells_worksheets_post_autofit_worksheet_columns) | **POST** /cells/{name}/worksheets/{sheetName}/autofitcolumns | 
*CellsWorksheetsApi* | [**cells_worksheets_post_autofit_worksheet_row**](docs/CellsWorksheetsApi.md#cells_worksheets_post_autofit_worksheet_row) | **POST** /cells/{name}/worksheets/{sheetName}/autofitrow | 
*CellsWorksheetsApi* | [**cells_worksheets_post_autofit_worksheet_rows**](docs/CellsWorksheetsApi.md#cells_worksheets_post_autofit_worksheet_rows) | **POST** /cells/{name}/worksheets/{sheetName}/autofitrows | Autofit worksheet rows.
*CellsWorksheetsApi* | [**cells_worksheets_post_copy_worksheet**](docs/CellsWorksheetsApi.md#cells_worksheets_post_copy_worksheet) | **POST** /cells/{name}/worksheets/{sheetName}/copy | 
*CellsWorksheetsApi* | [**cells_worksheets_post_move_worksheet**](docs/CellsWorksheetsApi.md#cells_worksheets_post_move_worksheet) | **POST** /cells/{name}/worksheets/{sheetName}/position | Move worksheet.
*CellsWorksheetsApi* | [**cells_worksheets_post_rename_worksheet**](docs/CellsWorksheetsApi.md#cells_worksheets_post_rename_worksheet) | **POST** /cells/{name}/worksheets/{sheetName}/rename | Rename worksheet
*CellsWorksheetsApi* | [**cells_worksheets_post_update_worksheet_property**](docs/CellsWorksheetsApi.md#cells_worksheets_post_update_worksheet_property) | **POST** /cells/{name}/worksheets/{sheetName} | Update worksheet property
*CellsWorksheetsApi* | [**cells_worksheets_post_update_worksheet_zoom**](docs/CellsWorksheetsApi.md#cells_worksheets_post_update_worksheet_zoom) | **POST** /cells/{name}/worksheets/{sheetName}/zoom | 
*CellsWorksheetsApi* | [**cells_worksheets_post_worksheet_comment**](docs/CellsWorksheetsApi.md#cells_worksheets_post_worksheet_comment) | **POST** /cells/{name}/worksheets/{sheetName}/comments/{cellName} | Update worksheet&#39;s cell comment.
*CellsWorksheetsApi* | [**cells_worksheets_post_worksheet_range_sort**](docs/CellsWorksheetsApi.md#cells_worksheets_post_worksheet_range_sort) | **POST** /cells/{name}/worksheets/{sheetName}/sort | Sort worksheet range.
*CellsWorksheetsApi* | [**cells_worksheets_post_worksheet_text_search**](docs/CellsWorksheetsApi.md#cells_worksheets_post_worksheet_text_search) | **POST** /cells/{name}/worksheets/{sheetName}/findText | Search text.
*CellsWorksheetsApi* | [**cells_worksheets_post_worsheet_text_replace**](docs/CellsWorksheetsApi.md#cells_worksheets_post_worsheet_text_replace) | **POST** /cells/{name}/worksheets/{sheetName}/replaceText | Replace text.
*CellsWorksheetsApi* | [**cells_worksheets_put_add_new_worksheet**](docs/CellsWorksheetsApi.md#cells_worksheets_put_add_new_worksheet) | **PUT** /cells/{name}/worksheets/{sheetName} | Add new worksheet.
*CellsWorksheetsApi* | [**cells_worksheets_put_change_visibility_worksheet**](docs/CellsWorksheetsApi.md#cells_worksheets_put_change_visibility_worksheet) | **PUT** /cells/{name}/worksheets/{sheetName}/visible | Change worksheet visibility.
*CellsWorksheetsApi* | [**cells_worksheets_put_protect_worksheet**](docs/CellsWorksheetsApi.md#cells_worksheets_put_protect_worksheet) | **PUT** /cells/{name}/worksheets/{sheetName}/protection | Protect worksheet.
*CellsWorksheetsApi* | [**cells_worksheets_put_worksheet_background**](docs/CellsWorksheetsApi.md#cells_worksheets_put_worksheet_background) | **PUT** /cells/{name}/worksheets/{sheetName}/background | Set worksheet background image.
*CellsWorksheetsApi* | [**cells_worksheets_put_worksheet_comment**](docs/CellsWorksheetsApi.md#cells_worksheets_put_worksheet_comment) | **PUT** /cells/{name}/worksheets/{sheetName}/comments/{cellName} | Add worksheet&#39;s cell comment.
*CellsWorksheetsApi* | [**cells_worksheets_put_worksheet_freeze_panes**](docs/CellsWorksheetsApi.md#cells_worksheets_put_worksheet_freeze_panes) | **PUT** /cells/{name}/worksheets/{sheetName}/freezepanes | Set freeze panes
*OAuthApi* | [**o_auth_post**](docs/OAuthApi.md#o_auth_post) | **POST** /oauth2/token | Get Access token


# DOCUMENTATION FOR MODELS
 - [AsposeCellsCloud::Object::AboveAverage](docs/AboveAverage.md)
 - [AsposeCellsCloud::Object::AccessTokenResponse](docs/AccessTokenResponse.md)
 - [AsposeCellsCloud::Object::Area](docs/Area.md)
 - [AsposeCellsCloud::Object::AutoFitterOptions](docs/AutoFitterOptions.md)
 - [AsposeCellsCloud::Object::Border](docs/Border.md)
 - [AsposeCellsCloud::Object::CalculationOptions](docs/CalculationOptions.md)
 - [AsposeCellsCloud::Object::CellArea](docs/CellArea.md)
 - [AsposeCellsCloud::Object::CellValue](docs/CellValue.md)
 - [AsposeCellsCloud::Object::CellsColor](docs/CellsColor.md)
 - [AsposeCellsCloud::Object::Color](docs/Color.md)
 - [AsposeCellsCloud::Object::ColorFilter](docs/ColorFilter.md)
 - [AsposeCellsCloud::Object::ColorFilterRequest](docs/ColorFilterRequest.md)
 - [AsposeCellsCloud::Object::ColorScale](docs/ColorScale.md)
 - [AsposeCellsCloud::Object::ConditionalFormattingIcon](docs/ConditionalFormattingIcon.md)
 - [AsposeCellsCloud::Object::ConditionalFormattingValue](docs/ConditionalFormattingValue.md)
 - [AsposeCellsCloud::Object::CopyOptions](docs/CopyOptions.md)
 - [AsposeCellsCloud::Object::CreatePivotTableRequest](docs/CreatePivotTableRequest.md)
 - [AsposeCellsCloud::Object::CustomFilter](docs/CustomFilter.md)
 - [AsposeCellsCloud::Object::CustomParserConfig](docs/CustomParserConfig.md)
 - [AsposeCellsCloud::Object::DataBar](docs/DataBar.md)
 - [AsposeCellsCloud::Object::DataBarBorder](docs/DataBarBorder.md)
 - [AsposeCellsCloud::Object::DataSorter](docs/DataSorter.md)
 - [AsposeCellsCloud::Object::DynamicFilter](docs/DynamicFilter.md)
 - [AsposeCellsCloud::Object::FileSource](docs/FileSource.md)
 - [AsposeCellsCloud::Object::FillFormat](docs/FillFormat.md)
 - [AsposeCellsCloud::Object::FilterColumn](docs/FilterColumn.md)
 - [AsposeCellsCloud::Object::Font](docs/Font.md)
 - [AsposeCellsCloud::Object::FontSetting](docs/FontSetting.md)
 - [AsposeCellsCloud::Object::GradientFill](docs/GradientFill.md)
 - [AsposeCellsCloud::Object::GradientFillStop](docs/GradientFillStop.md)
 - [AsposeCellsCloud::Object::HorizontalPageBreak](docs/HorizontalPageBreak.md)
 - [AsposeCellsCloud::Object::IconFilter](docs/IconFilter.md)
 - [AsposeCellsCloud::Object::IconSet](docs/IconSet.md)
 - [AsposeCellsCloud::Object::ImportOption](docs/ImportOption.md)
 - [AsposeCellsCloud::Object::Line](docs/Line.md)
 - [AsposeCellsCloud::Object::Link](docs/Link.md)
 - [AsposeCellsCloud::Object::LinkElement](docs/LinkElement.md)
 - [AsposeCellsCloud::Object::ListColumn](docs/ListColumn.md)
 - [AsposeCellsCloud::Object::MultipleFilter](docs/MultipleFilter.md)
 - [AsposeCellsCloud::Object::MultipleFilters](docs/MultipleFilters.md)
 - [AsposeCellsCloud::Object::NegativeBarFormat](docs/NegativeBarFormat.md)
 - [AsposeCellsCloud::Object::OperateObject](docs/OperateObject.md)
 - [AsposeCellsCloud::Object::OperateObjectPosition](docs/OperateObjectPosition.md)
 - [AsposeCellsCloud::Object::OperateParameter](docs/OperateParameter.md)
 - [AsposeCellsCloud::Object::PageSection](docs/PageSection.md)
 - [AsposeCellsCloud::Object::PasswordRequest](docs/PasswordRequest.md)
 - [AsposeCellsCloud::Object::PasteOptions](docs/PasteOptions.md)
 - [AsposeCellsCloud::Object::PatternFill](docs/PatternFill.md)
 - [AsposeCellsCloud::Object::PdfSecurityOptions](docs/PdfSecurityOptions.md)
 - [AsposeCellsCloud::Object::PicFormatOption](docs/PicFormatOption.md)
 - [AsposeCellsCloud::Object::PivotField](docs/PivotField.md)
 - [AsposeCellsCloud::Object::PivotFilter](docs/PivotFilter.md)
 - [AsposeCellsCloud::Object::PivotItem](docs/PivotItem.md)
 - [AsposeCellsCloud::Object::PivotTableFieldRequest](docs/PivotTableFieldRequest.md)
 - [AsposeCellsCloud::Object::ProtectSheetParameter](docs/ProtectSheetParameter.md)
 - [AsposeCellsCloud::Object::Range](docs/Range.md)
 - [AsposeCellsCloud::Object::RangeCopyRequest](docs/RangeCopyRequest.md)
 - [AsposeCellsCloud::Object::RangeSetOutlineBorderRequest](docs/RangeSetOutlineBorderRequest.md)
 - [AsposeCellsCloud::Object::RangeSetStyleRequest](docs/RangeSetStyleRequest.md)
 - [AsposeCellsCloud::Object::Ranges](docs/Ranges.md)
 - [AsposeCellsCloud::Object::ResultDestination](docs/ResultDestination.md)
 - [AsposeCellsCloud::Object::SaaSposeResponse](docs/SaaSposeResponse.md)
 - [AsposeCellsCloud::Object::SaveOptions](docs/SaveOptions.md)
 - [AsposeCellsCloud::Object::SaveResult](docs/SaveResult.md)
 - [AsposeCellsCloud::Object::ShadowEffect](docs/ShadowEffect.md)
 - [AsposeCellsCloud::Object::SingleValue](docs/SingleValue.md)
 - [AsposeCellsCloud::Object::SolidFill](docs/SolidFill.md)
 - [AsposeCellsCloud::Object::SortKey](docs/SortKey.md)
 - [AsposeCellsCloud::Object::SplitResult](docs/SplitResult.md)
 - [AsposeCellsCloud::Object::TaskData](docs/TaskData.md)
 - [AsposeCellsCloud::Object::TaskDescription](docs/TaskDescription.md)
 - [AsposeCellsCloud::Object::TaskParameter](docs/TaskParameter.md)
 - [AsposeCellsCloud::Object::TextureFill](docs/TextureFill.md)
 - [AsposeCellsCloud::Object::ThemeColor](docs/ThemeColor.md)
 - [AsposeCellsCloud::Object::TilePicOption](docs/TilePicOption.md)
 - [AsposeCellsCloud::Object::Top10](docs/Top10.md)
 - [AsposeCellsCloud::Object::Top10Filter](docs/Top10Filter.md)
 - [AsposeCellsCloud::Object::ValueType](docs/ValueType.md)
 - [AsposeCellsCloud::Object::VerticalPageBreak](docs/VerticalPageBreak.md)
 - [AsposeCellsCloud::Object::Workbook](docs/Workbook.md)
 - [AsposeCellsCloud::Object::WorkbookEncryptionRequest](docs/WorkbookEncryptionRequest.md)
 - [AsposeCellsCloud::Object::WorkbookProtectionRequest](docs/WorkbookProtectionRequest.md)
 - [AsposeCellsCloud::Object::WorkbookSettings](docs/WorkbookSettings.md)
 - [AsposeCellsCloud::Object::Worksheet](docs/Worksheet.md)
 - [AsposeCellsCloud::Object::WorksheetMovingRequest](docs/WorksheetMovingRequest.md)
 - [AsposeCellsCloud::Object::AutoFilter](docs/AutoFilter.md)
 - [AsposeCellsCloud::Object::AutoFilterResponse](docs/AutoFilterResponse.md)
 - [AsposeCellsCloud::Object::AutoShapeResponse](docs/AutoShapeResponse.md)
 - [AsposeCellsCloud::Object::AutoShapes](docs/AutoShapes.md)
 - [AsposeCellsCloud::Object::AutoShapesResponse](docs/AutoShapesResponse.md)
 - [AsposeCellsCloud::Object::Cell](docs/Cell.md)
 - [AsposeCellsCloud::Object::CellResponse](docs/CellResponse.md)
 - [AsposeCellsCloud::Object::Cells](docs/Cells.md)
 - [AsposeCellsCloud::Object::CellsDocumentProperties](docs/CellsDocumentProperties.md)
 - [AsposeCellsCloud::Object::CellsDocumentPropertiesResponse](docs/CellsDocumentPropertiesResponse.md)
 - [AsposeCellsCloud::Object::CellsDocumentProperty](docs/CellsDocumentProperty.md)
 - [AsposeCellsCloud::Object::CellsDocumentPropertyResponse](docs/CellsDocumentPropertyResponse.md)
 - [AsposeCellsCloud::Object::CellsObjectOperateTaskParameter](docs/CellsObjectOperateTaskParameter.md)
 - [AsposeCellsCloud::Object::CellsResponse](docs/CellsResponse.md)
 - [AsposeCellsCloud::Object::Chart](docs/Chart.md)
 - [AsposeCellsCloud::Object::ChartAreaResponse](docs/ChartAreaResponse.md)
 - [AsposeCellsCloud::Object::ChartFrame](docs/ChartFrame.md)
 - [AsposeCellsCloud::Object::ChartOperateParameter](docs/ChartOperateParameter.md)
 - [AsposeCellsCloud::Object::Charts](docs/Charts.md)
 - [AsposeCellsCloud::Object::ChartsResponse](docs/ChartsResponse.md)
 - [AsposeCellsCloud::Object::Column](docs/Column.md)
 - [AsposeCellsCloud::Object::ColumnResponse](docs/ColumnResponse.md)
 - [AsposeCellsCloud::Object::Columns](docs/Columns.md)
 - [AsposeCellsCloud::Object::ColumnsResponse](docs/ColumnsResponse.md)
 - [AsposeCellsCloud::Object::Comment](docs/Comment.md)
 - [AsposeCellsCloud::Object::CommentResponse](docs/CommentResponse.md)
 - [AsposeCellsCloud::Object::Comments](docs/Comments.md)
 - [AsposeCellsCloud::Object::CommentsResponse](docs/CommentsResponse.md)
 - [AsposeCellsCloud::Object::ConditionalFormatting](docs/ConditionalFormatting.md)
 - [AsposeCellsCloud::Object::ConditionalFormattingResponse](docs/ConditionalFormattingResponse.md)
 - [AsposeCellsCloud::Object::ConditionalFormattings](docs/ConditionalFormattings.md)
 - [AsposeCellsCloud::Object::ConditionalFormattingsResponse](docs/ConditionalFormattingsResponse.md)
 - [AsposeCellsCloud::Object::ConvertTaskParameter](docs/ConvertTaskParameter.md)
 - [AsposeCellsCloud::Object::DifSaveOptions](docs/DifSaveOptions.md)
 - [AsposeCellsCloud::Object::FillFormatResponse](docs/FillFormatResponse.md)
 - [AsposeCellsCloud::Object::FormatCondition](docs/FormatCondition.md)
 - [AsposeCellsCloud::Object::HorizontalPageBreakResponse](docs/HorizontalPageBreakResponse.md)
 - [AsposeCellsCloud::Object::HorizontalPageBreaks](docs/HorizontalPageBreaks.md)
 - [AsposeCellsCloud::Object::HorizontalPageBreaksResponse](docs/HorizontalPageBreaksResponse.md)
 - [AsposeCellsCloud::Object::HtmlSaveOptions](docs/HtmlSaveOptions.md)
 - [AsposeCellsCloud::Object::Hyperlink](docs/Hyperlink.md)
 - [AsposeCellsCloud::Object::HyperlinkResponse](docs/HyperlinkResponse.md)
 - [AsposeCellsCloud::Object::Hyperlinks](docs/Hyperlinks.md)
 - [AsposeCellsCloud::Object::HyperlinksResponse](docs/HyperlinksResponse.md)
 - [AsposeCellsCloud::Object::ImageSaveOptions](docs/ImageSaveOptions.md)
 - [AsposeCellsCloud::Object::ImportBatchDataOption](docs/ImportBatchDataOption.md)
 - [AsposeCellsCloud::Object::ImportCSVDataOption](docs/ImportCSVDataOption.md)
 - [AsposeCellsCloud::Object::ImportDataTaskParameter](docs/ImportDataTaskParameter.md)
 - [AsposeCellsCloud::Object::ImportDoubleArrayOption](docs/ImportDoubleArrayOption.md)
 - [AsposeCellsCloud::Object::ImportIntArrayOption](docs/ImportIntArrayOption.md)
 - [AsposeCellsCloud::Object::ImportStringArrayOption](docs/ImportStringArrayOption.md)
 - [AsposeCellsCloud::Object::LegendResponse](docs/LegendResponse.md)
 - [AsposeCellsCloud::Object::LineFormat](docs/LineFormat.md)
 - [AsposeCellsCloud::Object::LineResponse](docs/LineResponse.md)
 - [AsposeCellsCloud::Object::ListObject](docs/ListObject.md)
 - [AsposeCellsCloud::Object::ListObjectOperateParameter](docs/ListObjectOperateParameter.md)
 - [AsposeCellsCloud::Object::ListObjectResponse](docs/ListObjectResponse.md)
 - [AsposeCellsCloud::Object::ListObjects](docs/ListObjects.md)
 - [AsposeCellsCloud::Object::ListObjectsResponse](docs/ListObjectsResponse.md)
 - [AsposeCellsCloud::Object::MHtmlSaveOptions](docs/MHtmlSaveOptions.md)
 - [AsposeCellsCloud::Object::MergedCell](docs/MergedCell.md)
 - [AsposeCellsCloud::Object::MergedCellResponse](docs/MergedCellResponse.md)
 - [AsposeCellsCloud::Object::MergedCells](docs/MergedCells.md)
 - [AsposeCellsCloud::Object::MergedCellsResponse](docs/MergedCellsResponse.md)
 - [AsposeCellsCloud::Object::Name](docs/Name.md)
 - [AsposeCellsCloud::Object::NameResponse](docs/NameResponse.md)
 - [AsposeCellsCloud::Object::Names](docs/Names.md)
 - [AsposeCellsCloud::Object::NamesResponse](docs/NamesResponse.md)
 - [AsposeCellsCloud::Object::OdsSaveOptions](docs/OdsSaveOptions.md)
 - [AsposeCellsCloud::Object::OleObjectResponse](docs/OleObjectResponse.md)
 - [AsposeCellsCloud::Object::OleObjects](docs/OleObjects.md)
 - [AsposeCellsCloud::Object::OleObjectsResponse](docs/OleObjectsResponse.md)
 - [AsposeCellsCloud::Object::OoxmlSaveOptions](docs/OoxmlSaveOptions.md)
 - [AsposeCellsCloud::Object::PageBreakOperateParameter](docs/PageBreakOperateParameter.md)
 - [AsposeCellsCloud::Object::PageSectionsResponse](docs/PageSectionsResponse.md)
 - [AsposeCellsCloud::Object::PageSetup](docs/PageSetup.md)
 - [AsposeCellsCloud::Object::PageSetupOperateParameter](docs/PageSetupOperateParameter.md)
 - [AsposeCellsCloud::Object::PageSetupResponse](docs/PageSetupResponse.md)
 - [AsposeCellsCloud::Object::PdfSaveOptions](docs/PdfSaveOptions.md)
 - [AsposeCellsCloud::Object::PictureResponse](docs/PictureResponse.md)
 - [AsposeCellsCloud::Object::Pictures](docs/Pictures.md)
 - [AsposeCellsCloud::Object::PicturesResponse](docs/PicturesResponse.md)
 - [AsposeCellsCloud::Object::PivotFieldResponse](docs/PivotFieldResponse.md)
 - [AsposeCellsCloud::Object::PivotFilterResponse](docs/PivotFilterResponse.md)
 - [AsposeCellsCloud::Object::PivotFiltersResponse](docs/PivotFiltersResponse.md)
 - [AsposeCellsCloud::Object::PivotTable](docs/PivotTable.md)
 - [AsposeCellsCloud::Object::PivotTableOperateParameter](docs/PivotTableOperateParameter.md)
 - [AsposeCellsCloud::Object::PivotTableResponse](docs/PivotTableResponse.md)
 - [AsposeCellsCloud::Object::PivotTables](docs/PivotTables.md)
 - [AsposeCellsCloud::Object::PivotTablesResponse](docs/PivotTablesResponse.md)
 - [AsposeCellsCloud::Object::RangeValueResponse](docs/RangeValueResponse.md)
 - [AsposeCellsCloud::Object::RangesResponse](docs/RangesResponse.md)
 - [AsposeCellsCloud::Object::Row](docs/Row.md)
 - [AsposeCellsCloud::Object::RowResponse](docs/RowResponse.md)
 - [AsposeCellsCloud::Object::Rows](docs/Rows.md)
 - [AsposeCellsCloud::Object::RowsResponse](docs/RowsResponse.md)
 - [AsposeCellsCloud::Object::SaveResponse](docs/SaveResponse.md)
 - [AsposeCellsCloud::Object::SaveResultTaskParameter](docs/SaveResultTaskParameter.md)
 - [AsposeCellsCloud::Object::Shape](docs/Shape.md)
 - [AsposeCellsCloud::Object::ShapeOperateParameter](docs/ShapeOperateParameter.md)
 - [AsposeCellsCloud::Object::ShapeResponse](docs/ShapeResponse.md)
 - [AsposeCellsCloud::Object::Shapes](docs/Shapes.md)
 - [AsposeCellsCloud::Object::ShapesResponse](docs/ShapesResponse.md)
 - [AsposeCellsCloud::Object::SingleValueResponse](docs/SingleValueResponse.md)
 - [AsposeCellsCloud::Object::SmartMarkerTaskParameter](docs/SmartMarkerTaskParameter.md)
 - [AsposeCellsCloud::Object::SplitResultDocument](docs/SplitResultDocument.md)
 - [AsposeCellsCloud::Object::SplitResultResponse](docs/SplitResultResponse.md)
 - [AsposeCellsCloud::Object::SplitWorkbookTaskParameter](docs/SplitWorkbookTaskParameter.md)
 - [AsposeCellsCloud::Object::SpreadsheetML2003SaveOptions](docs/SpreadsheetML2003SaveOptions.md)
 - [AsposeCellsCloud::Object::Style](docs/Style.md)
 - [AsposeCellsCloud::Object::StyleResponse](docs/StyleResponse.md)
 - [AsposeCellsCloud::Object::SvgSaveOptions](docs/SvgSaveOptions.md)
 - [AsposeCellsCloud::Object::TextItem](docs/TextItem.md)
 - [AsposeCellsCloud::Object::TextItems](docs/TextItems.md)
 - [AsposeCellsCloud::Object::TextItemsResponse](docs/TextItemsResponse.md)
 - [AsposeCellsCloud::Object::TextOptions](docs/TextOptions.md)
 - [AsposeCellsCloud::Object::TitleResponse](docs/TitleResponse.md)
 - [AsposeCellsCloud::Object::TxtSaveOptions](docs/TxtSaveOptions.md)
 - [AsposeCellsCloud::Object::Validation](docs/Validation.md)
 - [AsposeCellsCloud::Object::ValidationResponse](docs/ValidationResponse.md)
 - [AsposeCellsCloud::Object::Validations](docs/Validations.md)
 - [AsposeCellsCloud::Object::ValidationsResponse](docs/ValidationsResponse.md)
 - [AsposeCellsCloud::Object::VerticalPageBreakResponse](docs/VerticalPageBreakResponse.md)
 - [AsposeCellsCloud::Object::VerticalPageBreaks](docs/VerticalPageBreaks.md)
 - [AsposeCellsCloud::Object::VerticalPageBreaksResponse](docs/VerticalPageBreaksResponse.md)
 - [AsposeCellsCloud::Object::WorkbookOperateParameter](docs/WorkbookOperateParameter.md)
 - [AsposeCellsCloud::Object::WorkbookReplaceResponse](docs/WorkbookReplaceResponse.md)
 - [AsposeCellsCloud::Object::WorkbookResponse](docs/WorkbookResponse.md)
 - [AsposeCellsCloud::Object::WorkbookSettingsOperateParameter](docs/WorkbookSettingsOperateParameter.md)
 - [AsposeCellsCloud::Object::WorkbookSettingsResponse](docs/WorkbookSettingsResponse.md)
 - [AsposeCellsCloud::Object::WorksheetReplaceResponse](docs/WorksheetReplaceResponse.md)
 - [AsposeCellsCloud::Object::WorksheetResponse](docs/WorksheetResponse.md)
 - [AsposeCellsCloud::Object::Worksheets](docs/Worksheets.md)
 - [AsposeCellsCloud::Object::WorksheetsResponse](docs/WorksheetsResponse.md)
 - [AsposeCellsCloud::Object::XlsSaveOptions](docs/XlsSaveOptions.md)
 - [AsposeCellsCloud::Object::XlsbSaveOptions](docs/XlsbSaveOptions.md)
 - [AsposeCellsCloud::Object::XpsSaveOptions](docs/XpsSaveOptions.md)
 - [AsposeCellsCloud::Object::AutoShape](docs/AutoShape.md)
 - [AsposeCellsCloud::Object::ChartArea](docs/ChartArea.md)
 - [AsposeCellsCloud::Object::Legend](docs/Legend.md)
 - [AsposeCellsCloud::Object::OleObject](docs/OleObject.md)
 - [AsposeCellsCloud::Object::Picture](docs/Picture.md)
 - [AsposeCellsCloud::Object::Title](docs/Title.md)


# DOCUMENTATION FOR AUTHORIZATION

## appsid

- **Type**: API key
- **API key parameter name**: appsid
- **Location**: URL query string

## oauth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: 
- **Scopes**: 
  - **write:pets**: modify pets in your account

## signature

- **Type**: API key
- **API key parameter name**: signature
- **Location**: URL query string

