=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

use Test::More;
use Test::Exception;

use AsposeSlidesCloud::SlidesApi;
use AsposeSlidesCloud::TestUtils;

use strict;
use warnings;

my $utils = AsposeSlidesCloud::TestUtils->new();

#
# copy_file test
#
{
    my %params = ('src_path' => $utils->get_param_value('copy_file', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('copy_file', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('copy_file', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('copy_file', 'dest_storage_name', 'string'), 'version_id' => $utils->get_param_value('copy_file', 'version_id', 'string'));
    $utils->initialize('copy_file', '');
    eval {
        my $result = $utils->{api}->copy_file(%params);
    };
    if ($@) {
        fail("copy_file raised an exception: $@");
    }
    pass();
}

{
    my %params = ('src_path' => $utils->get_param_value('copy_file', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('copy_file', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('copy_file', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('copy_file', 'dest_storage_name', 'string'), 'version_id' => $utils->get_param_value('copy_file', 'version_id', 'string'));
    $params{ src_path } = $utils->invalidize_param_value('copy_file', 'src_path', $params{ src_path });
    $utils->initialize('copy_file', 'src_path', $params{ src_path });

    eval {
        my $result = $utils->{api}->copy_file(%params);
    };
    if ($@) {
        $utils->assert_error('copy_file', 'src_path', $params{ src_path }, $@);
    } else {
        $utils->assert_no_error('copy_file', 'src_path');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('copy_file', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('copy_file', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('copy_file', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('copy_file', 'dest_storage_name', 'string'), 'version_id' => $utils->get_param_value('copy_file', 'version_id', 'string'));
    $params{ dest_path } = $utils->invalidize_param_value('copy_file', 'dest_path', $params{ dest_path });
    $utils->initialize('copy_file', 'dest_path', $params{ dest_path });

    eval {
        my $result = $utils->{api}->copy_file(%params);
    };
    if ($@) {
        $utils->assert_error('copy_file', 'dest_path', $params{ dest_path }, $@);
    } else {
        $utils->assert_no_error('copy_file', 'dest_path');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('copy_file', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('copy_file', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('copy_file', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('copy_file', 'dest_storage_name', 'string'), 'version_id' => $utils->get_param_value('copy_file', 'version_id', 'string'));
    $params{ src_storage_name } = $utils->invalidize_param_value('copy_file', 'src_storage_name', $params{ src_storage_name });
    $utils->initialize('copy_file', 'src_storage_name', $params{ src_storage_name });

    eval {
        my $result = $utils->{api}->copy_file(%params);
    };
    if ($@) {
        $utils->assert_error('copy_file', 'src_storage_name', $params{ src_storage_name }, $@);
    } else {
        $utils->assert_no_error('copy_file', 'src_storage_name');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('copy_file', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('copy_file', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('copy_file', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('copy_file', 'dest_storage_name', 'string'), 'version_id' => $utils->get_param_value('copy_file', 'version_id', 'string'));
    $params{ dest_storage_name } = $utils->invalidize_param_value('copy_file', 'dest_storage_name', $params{ dest_storage_name });
    $utils->initialize('copy_file', 'dest_storage_name', $params{ dest_storage_name });

    eval {
        my $result = $utils->{api}->copy_file(%params);
    };
    if ($@) {
        $utils->assert_error('copy_file', 'dest_storage_name', $params{ dest_storage_name }, $@);
    } else {
        $utils->assert_no_error('copy_file', 'dest_storage_name');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('copy_file', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('copy_file', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('copy_file', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('copy_file', 'dest_storage_name', 'string'), 'version_id' => $utils->get_param_value('copy_file', 'version_id', 'string'));
    $params{ version_id } = $utils->invalidize_param_value('copy_file', 'version_id', $params{ version_id });
    $utils->initialize('copy_file', 'version_id', $params{ version_id });

    eval {
        my $result = $utils->{api}->copy_file(%params);
    };
    if ($@) {
        $utils->assert_error('copy_file', 'version_id', $params{ version_id }, $@);
    } else {
        $utils->assert_no_error('copy_file', 'version_id');
    }
}

#
# copy_folder test
#
{
    my %params = ('src_path' => $utils->get_param_value('copy_folder', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('copy_folder', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('copy_folder', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('copy_folder', 'dest_storage_name', 'string'));
    $utils->initialize('copy_folder', '');
    eval {
        my $result = $utils->{api}->copy_folder(%params);
    };
    if ($@) {
        fail("copy_folder raised an exception: $@");
    }
    pass();
}

{
    my %params = ('src_path' => $utils->get_param_value('copy_folder', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('copy_folder', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('copy_folder', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('copy_folder', 'dest_storage_name', 'string'));
    $params{ src_path } = $utils->invalidize_param_value('copy_folder', 'src_path', $params{ src_path });
    $utils->initialize('copy_folder', 'src_path', $params{ src_path });

    eval {
        my $result = $utils->{api}->copy_folder(%params);
    };
    if ($@) {
        $utils->assert_error('copy_folder', 'src_path', $params{ src_path }, $@);
    } else {
        $utils->assert_no_error('copy_folder', 'src_path');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('copy_folder', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('copy_folder', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('copy_folder', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('copy_folder', 'dest_storage_name', 'string'));
    $params{ dest_path } = $utils->invalidize_param_value('copy_folder', 'dest_path', $params{ dest_path });
    $utils->initialize('copy_folder', 'dest_path', $params{ dest_path });

    eval {
        my $result = $utils->{api}->copy_folder(%params);
    };
    if ($@) {
        $utils->assert_error('copy_folder', 'dest_path', $params{ dest_path }, $@);
    } else {
        $utils->assert_no_error('copy_folder', 'dest_path');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('copy_folder', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('copy_folder', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('copy_folder', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('copy_folder', 'dest_storage_name', 'string'));
    $params{ src_storage_name } = $utils->invalidize_param_value('copy_folder', 'src_storage_name', $params{ src_storage_name });
    $utils->initialize('copy_folder', 'src_storage_name', $params{ src_storage_name });

    eval {
        my $result = $utils->{api}->copy_folder(%params);
    };
    if ($@) {
        $utils->assert_error('copy_folder', 'src_storage_name', $params{ src_storage_name }, $@);
    } else {
        $utils->assert_no_error('copy_folder', 'src_storage_name');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('copy_folder', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('copy_folder', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('copy_folder', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('copy_folder', 'dest_storage_name', 'string'));
    $params{ dest_storage_name } = $utils->invalidize_param_value('copy_folder', 'dest_storage_name', $params{ dest_storage_name });
    $utils->initialize('copy_folder', 'dest_storage_name', $params{ dest_storage_name });

    eval {
        my $result = $utils->{api}->copy_folder(%params);
    };
    if ($@) {
        $utils->assert_error('copy_folder', 'dest_storage_name', $params{ dest_storage_name }, $@);
    } else {
        $utils->assert_no_error('copy_folder', 'dest_storage_name');
    }
}

#
# create_folder test
#
{
    my %params = ('path' => $utils->get_param_value('create_folder', 'path', 'string'), 'storage_name' => $utils->get_param_value('create_folder', 'storage_name', 'string'));
    $utils->initialize('create_folder', '');
    eval {
        my $result = $utils->{api}->create_folder(%params);
    };
    if ($@) {
        fail("create_folder raised an exception: $@");
    }
    pass();
}

{
    my %params = ('path' => $utils->get_param_value('create_folder', 'path', 'string'), 'storage_name' => $utils->get_param_value('create_folder', 'storage_name', 'string'));
    $params{ path } = $utils->invalidize_param_value('create_folder', 'path', $params{ path });
    $utils->initialize('create_folder', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->create_folder(%params);
    };
    if ($@) {
        $utils->assert_error('create_folder', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('create_folder', 'path');
    }
}

{
    my %params = ('path' => $utils->get_param_value('create_folder', 'path', 'string'), 'storage_name' => $utils->get_param_value('create_folder', 'storage_name', 'string'));
    $params{ storage_name } = $utils->invalidize_param_value('create_folder', 'storage_name', $params{ storage_name });
    $utils->initialize('create_folder', 'storage_name', $params{ storage_name });

    eval {
        my $result = $utils->{api}->create_folder(%params);
    };
    if ($@) {
        $utils->assert_error('create_folder', 'storage_name', $params{ storage_name }, $@);
    } else {
        $utils->assert_no_error('create_folder', 'storage_name');
    }
}

#
# delete_file test
#
{
    my %params = ('path' => $utils->get_param_value('delete_file', 'path', 'string'), 'storage_name' => $utils->get_param_value('delete_file', 'storage_name', 'string'), 'version_id' => $utils->get_param_value('delete_file', 'version_id', 'string'));
    $utils->initialize('delete_file', '');
    eval {
        my $result = $utils->{api}->delete_file(%params);
    };
    if ($@) {
        fail("delete_file raised an exception: $@");
    }
    pass();
}

{
    my %params = ('path' => $utils->get_param_value('delete_file', 'path', 'string'), 'storage_name' => $utils->get_param_value('delete_file', 'storage_name', 'string'), 'version_id' => $utils->get_param_value('delete_file', 'version_id', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_file', 'path', $params{ path });
    $utils->initialize('delete_file', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_file(%params);
    };
    if ($@) {
        $utils->assert_error('delete_file', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_file', 'path');
    }
}

{
    my %params = ('path' => $utils->get_param_value('delete_file', 'path', 'string'), 'storage_name' => $utils->get_param_value('delete_file', 'storage_name', 'string'), 'version_id' => $utils->get_param_value('delete_file', 'version_id', 'string'));
    $params{ storage_name } = $utils->invalidize_param_value('delete_file', 'storage_name', $params{ storage_name });
    $utils->initialize('delete_file', 'storage_name', $params{ storage_name });

    eval {
        my $result = $utils->{api}->delete_file(%params);
    };
    if ($@) {
        $utils->assert_error('delete_file', 'storage_name', $params{ storage_name }, $@);
    } else {
        $utils->assert_no_error('delete_file', 'storage_name');
    }
}

{
    my %params = ('path' => $utils->get_param_value('delete_file', 'path', 'string'), 'storage_name' => $utils->get_param_value('delete_file', 'storage_name', 'string'), 'version_id' => $utils->get_param_value('delete_file', 'version_id', 'string'));
    $params{ version_id } = $utils->invalidize_param_value('delete_file', 'version_id', $params{ version_id });
    $utils->initialize('delete_file', 'version_id', $params{ version_id });

    eval {
        my $result = $utils->{api}->delete_file(%params);
    };
    if ($@) {
        $utils->assert_error('delete_file', 'version_id', $params{ version_id }, $@);
    } else {
        $utils->assert_no_error('delete_file', 'version_id');
    }
}

#
# delete_folder test
#
{
    my %params = ('path' => $utils->get_param_value('delete_folder', 'path', 'string'), 'storage_name' => $utils->get_param_value('delete_folder', 'storage_name', 'string'), 'recursive' => $utils->get_param_value('delete_folder', 'recursive', 'boolean'));
    $utils->initialize('delete_folder', '');
    eval {
        my $result = $utils->{api}->delete_folder(%params);
    };
    if ($@) {
        fail("delete_folder raised an exception: $@");
    }
    pass();
}

{
    my %params = ('path' => $utils->get_param_value('delete_folder', 'path', 'string'), 'storage_name' => $utils->get_param_value('delete_folder', 'storage_name', 'string'), 'recursive' => $utils->get_param_value('delete_folder', 'recursive', 'boolean'));
    $params{ path } = $utils->invalidize_param_value('delete_folder', 'path', $params{ path });
    $utils->initialize('delete_folder', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_folder(%params);
    };
    if ($@) {
        $utils->assert_error('delete_folder', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_folder', 'path');
    }
}

{
    my %params = ('path' => $utils->get_param_value('delete_folder', 'path', 'string'), 'storage_name' => $utils->get_param_value('delete_folder', 'storage_name', 'string'), 'recursive' => $utils->get_param_value('delete_folder', 'recursive', 'boolean'));
    $params{ storage_name } = $utils->invalidize_param_value('delete_folder', 'storage_name', $params{ storage_name });
    $utils->initialize('delete_folder', 'storage_name', $params{ storage_name });

    eval {
        my $result = $utils->{api}->delete_folder(%params);
    };
    if ($@) {
        $utils->assert_error('delete_folder', 'storage_name', $params{ storage_name }, $@);
    } else {
        $utils->assert_no_error('delete_folder', 'storage_name');
    }
}

{
    my %params = ('path' => $utils->get_param_value('delete_folder', 'path', 'string'), 'storage_name' => $utils->get_param_value('delete_folder', 'storage_name', 'string'), 'recursive' => $utils->get_param_value('delete_folder', 'recursive', 'boolean'));
    $params{ recursive } = $utils->invalidize_param_value('delete_folder', 'recursive', $params{ recursive });
    $utils->initialize('delete_folder', 'recursive', $params{ recursive });

    eval {
        my $result = $utils->{api}->delete_folder(%params);
    };
    if ($@) {
        $utils->assert_error('delete_folder', 'recursive', $params{ recursive }, $@);
    } else {
        $utils->assert_no_error('delete_folder', 'recursive');
    }
}

#
# delete_notes_slide test
#
{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide', 'storage', 'string'));
    $utils->initialize('delete_notes_slide', '');
    eval {
        my $result = $utils->{api}->delete_notes_slide(%params);
    };
    if ($@) {
        fail("delete_notes_slide raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_notes_slide', 'name', $params{ name });
    $utils->initialize('delete_notes_slide', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_notes_slide', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_notes_slide', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_notes_slide', 'password', $params{ password });
    $utils->initialize('delete_notes_slide', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_notes_slide', 'folder', $params{ folder });
    $utils->initialize('delete_notes_slide', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_notes_slide', 'storage', $params{ storage });
    $utils->initialize('delete_notes_slide', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide', 'storage');
    }
}

#
# delete_notes_slide_paragraph test
#
{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraph', 'storage', 'string'));
    $utils->initialize('delete_notes_slide_paragraph', '');
    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraph(%params);
    };
    if ($@) {
        fail("delete_notes_slide_paragraph raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraph', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_notes_slide_paragraph', 'name', $params{ name });
    $utils->initialize('delete_notes_slide_paragraph', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraph', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraph', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraph', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_notes_slide_paragraph', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_notes_slide_paragraph', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraph', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraph', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraph', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_notes_slide_paragraph', 'path', $params{ path });
    $utils->initialize('delete_notes_slide_paragraph', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraph', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraph', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraph', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('delete_notes_slide_paragraph', 'shape_index', $params{ shape_index });
    $utils->initialize('delete_notes_slide_paragraph', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraph', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraph', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraph', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('delete_notes_slide_paragraph', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('delete_notes_slide_paragraph', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraph', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraph', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraph', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_notes_slide_paragraph', 'password', $params{ password });
    $utils->initialize('delete_notes_slide_paragraph', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraph', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraph', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraph', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_notes_slide_paragraph', 'folder', $params{ folder });
    $utils->initialize('delete_notes_slide_paragraph', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraph', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraph', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraph', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_notes_slide_paragraph', 'storage', $params{ storage });
    $utils->initialize('delete_notes_slide_paragraph', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraph', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraph', 'storage');
    }
}

#
# delete_notes_slide_paragraphs test
#
{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_notes_slide_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraphs', 'storage', 'string'));
    $utils->initialize('delete_notes_slide_paragraphs', '');
    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraphs(%params);
    };
    if ($@) {
        fail("delete_notes_slide_paragraphs raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_notes_slide_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraphs', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_notes_slide_paragraphs', 'name', $params{ name });
    $utils->initialize('delete_notes_slide_paragraphs', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraphs', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraphs', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_notes_slide_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraphs', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_notes_slide_paragraphs', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_notes_slide_paragraphs', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraphs', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraphs', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_notes_slide_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraphs', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_notes_slide_paragraphs', 'path', $params{ path });
    $utils->initialize('delete_notes_slide_paragraphs', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraphs', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraphs', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_notes_slide_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraphs', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('delete_notes_slide_paragraphs', 'shape_index', $params{ shape_index });
    $utils->initialize('delete_notes_slide_paragraphs', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraphs', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraphs', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_notes_slide_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraphs', 'storage', 'string'));
    $params{ paragraphs } = $utils->invalidize_param_value('delete_notes_slide_paragraphs', 'paragraphs', $params{ paragraphs });
    $utils->initialize('delete_notes_slide_paragraphs', 'paragraphs', $params{ paragraphs });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraphs', 'paragraphs', $params{ paragraphs }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraphs', 'paragraphs');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_notes_slide_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraphs', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_notes_slide_paragraphs', 'password', $params{ password });
    $utils->initialize('delete_notes_slide_paragraphs', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraphs', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraphs', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_notes_slide_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraphs', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_notes_slide_paragraphs', 'folder', $params{ folder });
    $utils->initialize('delete_notes_slide_paragraphs', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraphs', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraphs', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_notes_slide_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_paragraphs', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_notes_slide_paragraphs', 'storage', $params{ storage });
    $utils->initialize('delete_notes_slide_paragraphs', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_notes_slide_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_paragraphs', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_paragraphs', 'storage');
    }
}

#
# delete_notes_slide_portion test
#
{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_notes_slide_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portion', 'storage', 'string'));
    $utils->initialize('delete_notes_slide_portion', '');
    eval {
        my $result = $utils->{api}->delete_notes_slide_portion(%params);
    };
    if ($@) {
        fail("delete_notes_slide_portion raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_notes_slide_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portion', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_notes_slide_portion', 'name', $params{ name });
    $utils->initialize('delete_notes_slide_portion', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portion', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portion', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_notes_slide_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portion', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_notes_slide_portion', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_notes_slide_portion', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portion', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portion', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_notes_slide_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portion', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_notes_slide_portion', 'path', $params{ path });
    $utils->initialize('delete_notes_slide_portion', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portion', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portion', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_notes_slide_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portion', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('delete_notes_slide_portion', 'shape_index', $params{ shape_index });
    $utils->initialize('delete_notes_slide_portion', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portion', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portion', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_notes_slide_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portion', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('delete_notes_slide_portion', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('delete_notes_slide_portion', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portion', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portion', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_notes_slide_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portion', 'storage', 'string'));
    $params{ portion_index } = $utils->invalidize_param_value('delete_notes_slide_portion', 'portion_index', $params{ portion_index });
    $utils->initialize('delete_notes_slide_portion', 'portion_index', $params{ portion_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portion', 'portion_index', $params{ portion_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portion', 'portion_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_notes_slide_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portion', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_notes_slide_portion', 'password', $params{ password });
    $utils->initialize('delete_notes_slide_portion', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portion', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portion', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_notes_slide_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portion', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_notes_slide_portion', 'folder', $params{ folder });
    $utils->initialize('delete_notes_slide_portion', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portion', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portion', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_notes_slide_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portion', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_notes_slide_portion', 'storage', $params{ storage });
    $utils->initialize('delete_notes_slide_portion', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portion', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portion', 'storage');
    }
}

#
# delete_notes_slide_portions test
#
{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_notes_slide_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portions', 'storage', 'string'));
    $utils->initialize('delete_notes_slide_portions', '');
    eval {
        my $result = $utils->{api}->delete_notes_slide_portions(%params);
    };
    if ($@) {
        fail("delete_notes_slide_portions raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_notes_slide_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portions', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_notes_slide_portions', 'name', $params{ name });
    $utils->initialize('delete_notes_slide_portions', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portions', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portions', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_notes_slide_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portions', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_notes_slide_portions', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_notes_slide_portions', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portions', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portions', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_notes_slide_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portions', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_notes_slide_portions', 'path', $params{ path });
    $utils->initialize('delete_notes_slide_portions', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portions', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portions', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_notes_slide_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portions', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('delete_notes_slide_portions', 'shape_index', $params{ shape_index });
    $utils->initialize('delete_notes_slide_portions', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portions', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portions', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_notes_slide_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portions', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('delete_notes_slide_portions', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('delete_notes_slide_portions', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portions', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portions', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_notes_slide_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portions', 'storage', 'string'));
    $params{ portions } = $utils->invalidize_param_value('delete_notes_slide_portions', 'portions', $params{ portions });
    $utils->initialize('delete_notes_slide_portions', 'portions', $params{ portions });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portions', 'portions', $params{ portions }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portions', 'portions');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_notes_slide_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portions', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_notes_slide_portions', 'password', $params{ password });
    $utils->initialize('delete_notes_slide_portions', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portions', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portions', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_notes_slide_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portions', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_notes_slide_portions', 'folder', $params{ folder });
    $utils->initialize('delete_notes_slide_portions', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portions', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portions', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_notes_slide_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_notes_slide_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_portions', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_notes_slide_portions', 'storage', $params{ storage });
    $utils->initialize('delete_notes_slide_portions', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_notes_slide_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_portions', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_portions', 'storage');
    }
}

#
# delete_notes_slide_shape test
#
{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shape', 'storage', 'string'));
    $utils->initialize('delete_notes_slide_shape', '');
    eval {
        my $result = $utils->{api}->delete_notes_slide_shape(%params);
    };
    if ($@) {
        fail("delete_notes_slide_shape raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shape', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_notes_slide_shape', 'name', $params{ name });
    $utils->initialize('delete_notes_slide_shape', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shape', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shape', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shape', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_notes_slide_shape', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_notes_slide_shape', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shape', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shape', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shape', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_notes_slide_shape', 'path', $params{ path });
    $utils->initialize('delete_notes_slide_shape', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shape', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shape', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shape', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('delete_notes_slide_shape', 'shape_index', $params{ shape_index });
    $utils->initialize('delete_notes_slide_shape', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shape', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shape', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shape', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_notes_slide_shape', 'password', $params{ password });
    $utils->initialize('delete_notes_slide_shape', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shape', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shape', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shape', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_notes_slide_shape', 'folder', $params{ folder });
    $utils->initialize('delete_notes_slide_shape', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shape', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shape', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shape', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_notes_slide_shape', 'storage', $params{ storage });
    $utils->initialize('delete_notes_slide_shape', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shape', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shape', 'storage');
    }
}

#
# delete_notes_slide_shapes test
#
{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_notes_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shapes', 'storage', 'string'));
    $utils->initialize('delete_notes_slide_shapes', '');
    eval {
        my $result = $utils->{api}->delete_notes_slide_shapes(%params);
    };
    if ($@) {
        fail("delete_notes_slide_shapes raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_notes_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shapes', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_notes_slide_shapes', 'name', $params{ name });
    $utils->initialize('delete_notes_slide_shapes', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shapes', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shapes', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_notes_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shapes', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_notes_slide_shapes', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_notes_slide_shapes', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shapes', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shapes', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_notes_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shapes', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_notes_slide_shapes', 'path', $params{ path });
    $utils->initialize('delete_notes_slide_shapes', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shapes', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shapes', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_notes_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shapes', 'storage', 'string'));
    $params{ shapes } = $utils->invalidize_param_value('delete_notes_slide_shapes', 'shapes', $params{ shapes });
    $utils->initialize('delete_notes_slide_shapes', 'shapes', $params{ shapes });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shapes', 'shapes', $params{ shapes }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shapes', 'shapes');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_notes_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shapes', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_notes_slide_shapes', 'password', $params{ password });
    $utils->initialize('delete_notes_slide_shapes', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shapes', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shapes', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_notes_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shapes', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_notes_slide_shapes', 'folder', $params{ folder });
    $utils->initialize('delete_notes_slide_shapes', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shapes', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shapes', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_notes_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_notes_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_notes_slide_shapes', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_notes_slide_shapes', 'storage', $params{ storage });
    $utils->initialize('delete_notes_slide_shapes', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_notes_slide_shapes', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_notes_slide_shapes', 'storage');
    }
}

#
# delete_paragraph test
#
{
    my %params = ('name' => $utils->get_param_value('delete_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraph', 'storage', 'string'));
    $utils->initialize('delete_paragraph', '');
    eval {
        my $result = $utils->{api}->delete_paragraph(%params);
    };
    if ($@) {
        fail("delete_paragraph raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraph', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_paragraph', 'name', $params{ name });
    $utils->initialize('delete_paragraph', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraph', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_paragraph', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraph', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_paragraph', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_paragraph', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraph', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_paragraph', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraph', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_paragraph', 'path', $params{ path });
    $utils->initialize('delete_paragraph', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraph', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_paragraph', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraph', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('delete_paragraph', 'shape_index', $params{ shape_index });
    $utils->initialize('delete_paragraph', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->delete_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraph', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('delete_paragraph', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraph', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('delete_paragraph', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('delete_paragraph', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->delete_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraph', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('delete_paragraph', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraph', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_paragraph', 'password', $params{ password });
    $utils->initialize('delete_paragraph', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraph', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_paragraph', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraph', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_paragraph', 'folder', $params{ folder });
    $utils->initialize('delete_paragraph', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraph', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_paragraph', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('delete_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraph', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_paragraph', 'storage', $params{ storage });
    $utils->initialize('delete_paragraph', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraph', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_paragraph', 'storage');
    }
}

#
# delete_paragraphs test
#
{
    my %params = ('name' => $utils->get_param_value('delete_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraphs', 'storage', 'string'));
    $utils->initialize('delete_paragraphs', '');
    eval {
        my $result = $utils->{api}->delete_paragraphs(%params);
    };
    if ($@) {
        fail("delete_paragraphs raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraphs', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_paragraphs', 'name', $params{ name });
    $utils->initialize('delete_paragraphs', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraphs', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_paragraphs', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraphs', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_paragraphs', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_paragraphs', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraphs', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_paragraphs', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraphs', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_paragraphs', 'path', $params{ path });
    $utils->initialize('delete_paragraphs', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraphs', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_paragraphs', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraphs', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('delete_paragraphs', 'shape_index', $params{ shape_index });
    $utils->initialize('delete_paragraphs', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->delete_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraphs', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('delete_paragraphs', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraphs', 'storage', 'string'));
    $params{ paragraphs } = $utils->invalidize_param_value('delete_paragraphs', 'paragraphs', $params{ paragraphs });
    $utils->initialize('delete_paragraphs', 'paragraphs', $params{ paragraphs });

    eval {
        my $result = $utils->{api}->delete_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraphs', 'paragraphs', $params{ paragraphs }, $@);
    } else {
        $utils->assert_no_error('delete_paragraphs', 'paragraphs');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraphs', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_paragraphs', 'password', $params{ password });
    $utils->initialize('delete_paragraphs', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraphs', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_paragraphs', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraphs', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_paragraphs', 'folder', $params{ folder });
    $utils->initialize('delete_paragraphs', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraphs', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_paragraphs', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_paragraphs', 'shape_index', 'int'), 'paragraphs' => $utils->get_param_value('delete_paragraphs', 'paragraphs', 'string'), 'password' => $utils->get_param_value('delete_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('delete_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_paragraphs', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_paragraphs', 'storage', $params{ storage });
    $utils->initialize('delete_paragraphs', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('delete_paragraphs', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_paragraphs', 'storage');
    }
}

#
# delete_portion test
#
{
    my %params = ('name' => $utils->get_param_value('delete_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portion', 'storage', 'string'));
    $utils->initialize('delete_portion', '');
    eval {
        my $result = $utils->{api}->delete_portion(%params);
    };
    if ($@) {
        fail("delete_portion raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portion', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_portion', 'name', $params{ name });
    $utils->initialize('delete_portion', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portion', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_portion', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portion', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_portion', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_portion', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portion', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_portion', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portion', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_portion', 'path', $params{ path });
    $utils->initialize('delete_portion', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portion', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_portion', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portion', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('delete_portion', 'shape_index', $params{ shape_index });
    $utils->initialize('delete_portion', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->delete_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portion', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('delete_portion', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portion', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('delete_portion', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('delete_portion', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->delete_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portion', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('delete_portion', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portion', 'storage', 'string'));
    $params{ portion_index } = $utils->invalidize_param_value('delete_portion', 'portion_index', $params{ portion_index });
    $utils->initialize('delete_portion', 'portion_index', $params{ portion_index });

    eval {
        my $result = $utils->{api}->delete_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portion', 'portion_index', $params{ portion_index }, $@);
    } else {
        $utils->assert_no_error('delete_portion', 'portion_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portion', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_portion', 'password', $params{ password });
    $utils->initialize('delete_portion', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portion', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_portion', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portion', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_portion', 'folder', $params{ folder });
    $utils->initialize('delete_portion', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portion', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_portion', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('delete_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('delete_portion', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portion', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_portion', 'storage', $params{ storage });
    $utils->initialize('delete_portion', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_portion(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portion', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_portion', 'storage');
    }
}

#
# delete_portions test
#
{
    my %params = ('name' => $utils->get_param_value('delete_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portions', 'storage', 'string'));
    $utils->initialize('delete_portions', '');
    eval {
        my $result = $utils->{api}->delete_portions(%params);
    };
    if ($@) {
        fail("delete_portions raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portions', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_portions', 'name', $params{ name });
    $utils->initialize('delete_portions', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portions', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_portions', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portions', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_portions', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_portions', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portions', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_portions', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portions', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_portions', 'path', $params{ path });
    $utils->initialize('delete_portions', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portions', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_portions', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portions', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('delete_portions', 'shape_index', $params{ shape_index });
    $utils->initialize('delete_portions', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->delete_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portions', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('delete_portions', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portions', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('delete_portions', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('delete_portions', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->delete_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portions', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('delete_portions', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portions', 'storage', 'string'));
    $params{ portions } = $utils->invalidize_param_value('delete_portions', 'portions', $params{ portions });
    $utils->initialize('delete_portions', 'portions', $params{ portions });

    eval {
        my $result = $utils->{api}->delete_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portions', 'portions', $params{ portions }, $@);
    } else {
        $utils->assert_no_error('delete_portions', 'portions');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portions', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_portions', 'password', $params{ password });
    $utils->initialize('delete_portions', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portions', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_portions', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portions', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_portions', 'folder', $params{ folder });
    $utils->initialize('delete_portions', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portions', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_portions', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('delete_portions', 'paragraph_index', 'int'), 'portions' => $utils->get_param_value('delete_portions', 'portions', 'string'), 'password' => $utils->get_param_value('delete_portions', 'password', 'string'), 'folder' => $utils->get_param_value('delete_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_portions', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_portions', 'storage', $params{ storage });
    $utils->initialize('delete_portions', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_portions(%params);
    };
    if ($@) {
        $utils->assert_error('delete_portions', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_portions', 'storage');
    }
}

#
# delete_slide_animation test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation', 'storage', 'string'));
    $utils->initialize('delete_slide_animation', '');
    eval {
        my $result = $utils->{api}->delete_slide_animation(%params);
    };
    if ($@) {
        fail("delete_slide_animation raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slide_animation', 'name', $params{ name });
    $utils->initialize('delete_slide_animation', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_slide_animation', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_slide_animation', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slide_animation', 'password', $params{ password });
    $utils->initialize('delete_slide_animation', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slide_animation', 'folder', $params{ folder });
    $utils->initialize('delete_slide_animation', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slide_animation', 'storage', $params{ storage });
    $utils->initialize('delete_slide_animation', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation', 'storage');
    }
}

#
# delete_slide_animation_effect test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_effect', 'storage', 'string'));
    $utils->initialize('delete_slide_animation_effect', '');
    eval {
        my $result = $utils->{api}->delete_slide_animation_effect(%params);
    };
    if ($@) {
        fail("delete_slide_animation_effect raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_effect', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slide_animation_effect', 'name', $params{ name });
    $utils->initialize('delete_slide_animation_effect', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_effect', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_effect', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_effect', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_slide_animation_effect', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_slide_animation_effect', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_effect', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_effect', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_effect', 'storage', 'string'));
    $params{ effect_index } = $utils->invalidize_param_value('delete_slide_animation_effect', 'effect_index', $params{ effect_index });
    $utils->initialize('delete_slide_animation_effect', 'effect_index', $params{ effect_index });

    eval {
        my $result = $utils->{api}->delete_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_effect', 'effect_index', $params{ effect_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_effect', 'effect_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_effect', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slide_animation_effect', 'password', $params{ password });
    $utils->initialize('delete_slide_animation_effect', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_effect', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_effect', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_effect', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slide_animation_effect', 'folder', $params{ folder });
    $utils->initialize('delete_slide_animation_effect', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_effect', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_effect', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_effect', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slide_animation_effect', 'storage', $params{ storage });
    $utils->initialize('delete_slide_animation_effect', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_effect', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_effect', 'storage');
    }
}

#
# delete_slide_animation_interactive_sequence test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'sequence_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'storage', 'string'));
    $utils->initialize('delete_slide_animation_interactive_sequence', '');
    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        fail("delete_slide_animation_interactive_sequence raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'sequence_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence', 'name', $params{ name });
    $utils->initialize('delete_slide_animation_interactive_sequence', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'sequence_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_slide_animation_interactive_sequence', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'sequence_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'storage', 'string'));
    $params{ sequence_index } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence', 'sequence_index', $params{ sequence_index });
    $utils->initialize('delete_slide_animation_interactive_sequence', 'sequence_index', $params{ sequence_index });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence', 'sequence_index', $params{ sequence_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence', 'sequence_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'sequence_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence', 'password', $params{ password });
    $utils->initialize('delete_slide_animation_interactive_sequence', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'sequence_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence', 'folder', $params{ folder });
    $utils->initialize('delete_slide_animation_interactive_sequence', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'sequence_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence', 'storage', $params{ storage });
    $utils->initialize('delete_slide_animation_interactive_sequence', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence', 'storage');
    }
}

#
# delete_slide_animation_interactive_sequence_effect test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $utils->initialize('delete_slide_animation_interactive_sequence_effect', '');
    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        fail("delete_slide_animation_interactive_sequence_effect raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence_effect', 'name', $params{ name });
    $utils->initialize('delete_slide_animation_interactive_sequence_effect', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence_effect', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence_effect', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence_effect', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_slide_animation_interactive_sequence_effect', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence_effect', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence_effect', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ sequence_index } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence_effect', 'sequence_index', $params{ sequence_index });
    $utils->initialize('delete_slide_animation_interactive_sequence_effect', 'sequence_index', $params{ sequence_index });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence_effect', 'sequence_index', $params{ sequence_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence_effect', 'sequence_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ effect_index } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence_effect', 'effect_index', $params{ effect_index });
    $utils->initialize('delete_slide_animation_interactive_sequence_effect', 'effect_index', $params{ effect_index });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence_effect', 'effect_index', $params{ effect_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence_effect', 'effect_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence_effect', 'password', $params{ password });
    $utils->initialize('delete_slide_animation_interactive_sequence_effect', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence_effect', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence_effect', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence_effect', 'folder', $params{ folder });
    $utils->initialize('delete_slide_animation_interactive_sequence_effect', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence_effect', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence_effect', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequence_effect', 'storage', $params{ storage });
    $utils->initialize('delete_slide_animation_interactive_sequence_effect', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequence_effect', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequence_effect', 'storage');
    }
}

#
# delete_slide_animation_interactive_sequences test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'storage', 'string'));
    $utils->initialize('delete_slide_animation_interactive_sequences', '');
    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequences(%params);
    };
    if ($@) {
        fail("delete_slide_animation_interactive_sequences raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequences', 'name', $params{ name });
    $utils->initialize('delete_slide_animation_interactive_sequences', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequences(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequences', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequences', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequences', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_slide_animation_interactive_sequences', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequences(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequences', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequences', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequences', 'password', $params{ password });
    $utils->initialize('delete_slide_animation_interactive_sequences', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequences(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequences', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequences', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequences', 'folder', $params{ folder });
    $utils->initialize('delete_slide_animation_interactive_sequences', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequences(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequences', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequences', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_interactive_sequences', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slide_animation_interactive_sequences', 'storage', $params{ storage });
    $utils->initialize('delete_slide_animation_interactive_sequences', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slide_animation_interactive_sequences(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_interactive_sequences', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_interactive_sequences', 'storage');
    }
}

#
# delete_slide_animation_main_sequence test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_main_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_main_sequence', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_main_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_main_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_main_sequence', 'storage', 'string'));
    $utils->initialize('delete_slide_animation_main_sequence', '');
    eval {
        my $result = $utils->{api}->delete_slide_animation_main_sequence(%params);
    };
    if ($@) {
        fail("delete_slide_animation_main_sequence raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_main_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_main_sequence', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_main_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_main_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_main_sequence', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slide_animation_main_sequence', 'name', $params{ name });
    $utils->initialize('delete_slide_animation_main_sequence', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slide_animation_main_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_main_sequence', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_main_sequence', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_main_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_main_sequence', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_main_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_main_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_main_sequence', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_slide_animation_main_sequence', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_slide_animation_main_sequence', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_slide_animation_main_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_main_sequence', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_main_sequence', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_main_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_main_sequence', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_main_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_main_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_main_sequence', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slide_animation_main_sequence', 'password', $params{ password });
    $utils->initialize('delete_slide_animation_main_sequence', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slide_animation_main_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_main_sequence', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_main_sequence', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_main_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_main_sequence', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_main_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_main_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_main_sequence', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slide_animation_main_sequence', 'folder', $params{ folder });
    $utils->initialize('delete_slide_animation_main_sequence', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slide_animation_main_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_main_sequence', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_main_sequence', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_animation_main_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_animation_main_sequence', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_animation_main_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_animation_main_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_animation_main_sequence', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slide_animation_main_sequence', 'storage', $params{ storage });
    $utils->initialize('delete_slide_animation_main_sequence', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slide_animation_main_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_animation_main_sequence', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slide_animation_main_sequence', 'storage');
    }
}

#
# delete_slide_by_index test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slide_by_index', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_by_index', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_by_index', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_by_index', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_by_index', 'storage', 'string'));
    $utils->initialize('delete_slide_by_index', '');
    eval {
        my $result = $utils->{api}->delete_slide_by_index(%params);
    };
    if ($@) {
        fail("delete_slide_by_index raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_by_index', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_by_index', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_by_index', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_by_index', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_by_index', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slide_by_index', 'name', $params{ name });
    $utils->initialize('delete_slide_by_index', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slide_by_index(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_by_index', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slide_by_index', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_by_index', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_by_index', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_by_index', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_by_index', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_by_index', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_slide_by_index', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_slide_by_index', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_slide_by_index(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_by_index', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_by_index', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_by_index', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_by_index', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_by_index', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_by_index', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_by_index', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slide_by_index', 'password', $params{ password });
    $utils->initialize('delete_slide_by_index', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slide_by_index(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_by_index', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slide_by_index', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_by_index', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_by_index', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_by_index', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_by_index', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_by_index', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slide_by_index', 'folder', $params{ folder });
    $utils->initialize('delete_slide_by_index', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slide_by_index(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_by_index', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slide_by_index', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_by_index', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_by_index', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slide_by_index', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_by_index', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_by_index', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slide_by_index', 'storage', $params{ storage });
    $utils->initialize('delete_slide_by_index', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slide_by_index(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_by_index', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slide_by_index', 'storage');
    }
}

#
# delete_slide_shape test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shape', 'storage', 'string'));
    $utils->initialize('delete_slide_shape', '');
    eval {
        my $result = $utils->{api}->delete_slide_shape(%params);
    };
    if ($@) {
        fail("delete_slide_shape raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shape', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slide_shape', 'name', $params{ name });
    $utils->initialize('delete_slide_shape', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shape', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shape', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shape', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_slide_shape', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_slide_shape', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shape', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shape', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shape', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_slide_shape', 'path', $params{ path });
    $utils->initialize('delete_slide_shape', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shape', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shape', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shape', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('delete_slide_shape', 'shape_index', $params{ shape_index });
    $utils->initialize('delete_slide_shape', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->delete_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shape', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shape', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shape', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slide_shape', 'password', $params{ password });
    $utils->initialize('delete_slide_shape', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shape', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shape', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shape', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slide_shape', 'folder', $params{ folder });
    $utils->initialize('delete_slide_shape', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shape', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shape', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('delete_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('delete_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shape', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slide_shape', 'storage', $params{ storage });
    $utils->initialize('delete_slide_shape', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shape', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shape', 'storage');
    }
}

#
# delete_slide_shapes test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shapes', 'storage', 'string'));
    $utils->initialize('delete_slide_shapes', '');
    eval {
        my $result = $utils->{api}->delete_slide_shapes(%params);
    };
    if ($@) {
        fail("delete_slide_shapes raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shapes', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slide_shapes', 'name', $params{ name });
    $utils->initialize('delete_slide_shapes', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shapes', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shapes', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shapes', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_slide_shapes', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_slide_shapes', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shapes', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shapes', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shapes', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('delete_slide_shapes', 'path', $params{ path });
    $utils->initialize('delete_slide_shapes', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->delete_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shapes', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shapes', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shapes', 'storage', 'string'));
    $params{ shapes } = $utils->invalidize_param_value('delete_slide_shapes', 'shapes', $params{ shapes });
    $utils->initialize('delete_slide_shapes', 'shapes', $params{ shapes });

    eval {
        my $result = $utils->{api}->delete_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shapes', 'shapes', $params{ shapes }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shapes', 'shapes');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shapes', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slide_shapes', 'password', $params{ password });
    $utils->initialize('delete_slide_shapes', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shapes', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shapes', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shapes', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slide_shapes', 'folder', $params{ folder });
    $utils->initialize('delete_slide_shapes', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shapes', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shapes', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('delete_slide_shapes', 'path', 'string'), 'shapes' => $utils->get_param_value('delete_slide_shapes', 'shapes', 'string'), 'password' => $utils->get_param_value('delete_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slide_shapes', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slide_shapes', 'storage', $params{ storage });
    $utils->initialize('delete_slide_shapes', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slide_shapes', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slide_shapes', 'storage');
    }
}

#
# delete_slides_clean_slides_list test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slides_clean_slides_list', 'name', 'string'), 'slides' => $utils->get_param_value('delete_slides_clean_slides_list', 'slides', 'string'), 'password' => $utils->get_param_value('delete_slides_clean_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_clean_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_clean_slides_list', 'storage', 'string'));
    $utils->initialize('delete_slides_clean_slides_list', '');
    eval {
        my $result = $utils->{api}->delete_slides_clean_slides_list(%params);
    };
    if ($@) {
        fail("delete_slides_clean_slides_list raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_clean_slides_list', 'name', 'string'), 'slides' => $utils->get_param_value('delete_slides_clean_slides_list', 'slides', 'string'), 'password' => $utils->get_param_value('delete_slides_clean_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_clean_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_clean_slides_list', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slides_clean_slides_list', 'name', $params{ name });
    $utils->initialize('delete_slides_clean_slides_list', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slides_clean_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_clean_slides_list', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slides_clean_slides_list', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_clean_slides_list', 'name', 'string'), 'slides' => $utils->get_param_value('delete_slides_clean_slides_list', 'slides', 'string'), 'password' => $utils->get_param_value('delete_slides_clean_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_clean_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_clean_slides_list', 'storage', 'string'));
    $params{ slides } = $utils->invalidize_param_value('delete_slides_clean_slides_list', 'slides', $params{ slides });
    $utils->initialize('delete_slides_clean_slides_list', 'slides', $params{ slides });

    eval {
        my $result = $utils->{api}->delete_slides_clean_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_clean_slides_list', 'slides', $params{ slides }, $@);
    } else {
        $utils->assert_no_error('delete_slides_clean_slides_list', 'slides');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_clean_slides_list', 'name', 'string'), 'slides' => $utils->get_param_value('delete_slides_clean_slides_list', 'slides', 'string'), 'password' => $utils->get_param_value('delete_slides_clean_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_clean_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_clean_slides_list', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slides_clean_slides_list', 'password', $params{ password });
    $utils->initialize('delete_slides_clean_slides_list', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slides_clean_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_clean_slides_list', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slides_clean_slides_list', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_clean_slides_list', 'name', 'string'), 'slides' => $utils->get_param_value('delete_slides_clean_slides_list', 'slides', 'string'), 'password' => $utils->get_param_value('delete_slides_clean_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_clean_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_clean_slides_list', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slides_clean_slides_list', 'folder', $params{ folder });
    $utils->initialize('delete_slides_clean_slides_list', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slides_clean_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_clean_slides_list', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slides_clean_slides_list', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_clean_slides_list', 'name', 'string'), 'slides' => $utils->get_param_value('delete_slides_clean_slides_list', 'slides', 'string'), 'password' => $utils->get_param_value('delete_slides_clean_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_clean_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_clean_slides_list', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slides_clean_slides_list', 'storage', $params{ storage });
    $utils->initialize('delete_slides_clean_slides_list', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slides_clean_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_clean_slides_list', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slides_clean_slides_list', 'storage');
    }
}

#
# delete_slides_document_properties test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slides_document_properties', 'name', 'string'), 'password' => $utils->get_param_value('delete_slides_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_document_properties', 'storage', 'string'));
    $utils->initialize('delete_slides_document_properties', '');
    eval {
        my $result = $utils->{api}->delete_slides_document_properties(%params);
    };
    if ($@) {
        fail("delete_slides_document_properties raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_document_properties', 'name', 'string'), 'password' => $utils->get_param_value('delete_slides_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_document_properties', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slides_document_properties', 'name', $params{ name });
    $utils->initialize('delete_slides_document_properties', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slides_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_document_properties', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slides_document_properties', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_document_properties', 'name', 'string'), 'password' => $utils->get_param_value('delete_slides_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_document_properties', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slides_document_properties', 'password', $params{ password });
    $utils->initialize('delete_slides_document_properties', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slides_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_document_properties', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slides_document_properties', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_document_properties', 'name', 'string'), 'password' => $utils->get_param_value('delete_slides_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_document_properties', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slides_document_properties', 'folder', $params{ folder });
    $utils->initialize('delete_slides_document_properties', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slides_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_document_properties', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slides_document_properties', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_document_properties', 'name', 'string'), 'password' => $utils->get_param_value('delete_slides_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_document_properties', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slides_document_properties', 'storage', $params{ storage });
    $utils->initialize('delete_slides_document_properties', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slides_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_document_properties', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slides_document_properties', 'storage');
    }
}

#
# delete_slides_document_property test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slides_document_property', 'name', 'string'), 'property_name' => $utils->get_param_value('delete_slides_document_property', 'property_name', 'string'), 'password' => $utils->get_param_value('delete_slides_document_property', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_document_property', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_document_property', 'storage', 'string'));
    $utils->initialize('delete_slides_document_property', '');
    eval {
        my $result = $utils->{api}->delete_slides_document_property(%params);
    };
    if ($@) {
        fail("delete_slides_document_property raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_document_property', 'name', 'string'), 'property_name' => $utils->get_param_value('delete_slides_document_property', 'property_name', 'string'), 'password' => $utils->get_param_value('delete_slides_document_property', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_document_property', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_document_property', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slides_document_property', 'name', $params{ name });
    $utils->initialize('delete_slides_document_property', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slides_document_property(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_document_property', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slides_document_property', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_document_property', 'name', 'string'), 'property_name' => $utils->get_param_value('delete_slides_document_property', 'property_name', 'string'), 'password' => $utils->get_param_value('delete_slides_document_property', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_document_property', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_document_property', 'storage', 'string'));
    $params{ property_name } = $utils->invalidize_param_value('delete_slides_document_property', 'property_name', $params{ property_name });
    $utils->initialize('delete_slides_document_property', 'property_name', $params{ property_name });

    eval {
        my $result = $utils->{api}->delete_slides_document_property(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_document_property', 'property_name', $params{ property_name }, $@);
    } else {
        $utils->assert_no_error('delete_slides_document_property', 'property_name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_document_property', 'name', 'string'), 'property_name' => $utils->get_param_value('delete_slides_document_property', 'property_name', 'string'), 'password' => $utils->get_param_value('delete_slides_document_property', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_document_property', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_document_property', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slides_document_property', 'password', $params{ password });
    $utils->initialize('delete_slides_document_property', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slides_document_property(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_document_property', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slides_document_property', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_document_property', 'name', 'string'), 'property_name' => $utils->get_param_value('delete_slides_document_property', 'property_name', 'string'), 'password' => $utils->get_param_value('delete_slides_document_property', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_document_property', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_document_property', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slides_document_property', 'folder', $params{ folder });
    $utils->initialize('delete_slides_document_property', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slides_document_property(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_document_property', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slides_document_property', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_document_property', 'name', 'string'), 'property_name' => $utils->get_param_value('delete_slides_document_property', 'property_name', 'string'), 'password' => $utils->get_param_value('delete_slides_document_property', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_document_property', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_document_property', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slides_document_property', 'storage', $params{ storage });
    $utils->initialize('delete_slides_document_property', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slides_document_property(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_document_property', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slides_document_property', 'storage');
    }
}

#
# delete_slides_slide_background test
#
{
    my %params = ('name' => $utils->get_param_value('delete_slides_slide_background', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slides_slide_background', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slides_slide_background', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_slide_background', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_slide_background', 'storage', 'string'));
    $utils->initialize('delete_slides_slide_background', '');
    eval {
        my $result = $utils->{api}->delete_slides_slide_background(%params);
    };
    if ($@) {
        fail("delete_slides_slide_background raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_slide_background', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slides_slide_background', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slides_slide_background', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_slide_background', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_slide_background', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('delete_slides_slide_background', 'name', $params{ name });
    $utils->initialize('delete_slides_slide_background', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->delete_slides_slide_background(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_slide_background', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('delete_slides_slide_background', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_slide_background', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slides_slide_background', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slides_slide_background', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_slide_background', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_slide_background', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('delete_slides_slide_background', 'slide_index', $params{ slide_index });
    $utils->initialize('delete_slides_slide_background', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->delete_slides_slide_background(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_slide_background', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('delete_slides_slide_background', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_slide_background', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slides_slide_background', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slides_slide_background', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_slide_background', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_slide_background', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('delete_slides_slide_background', 'password', $params{ password });
    $utils->initialize('delete_slides_slide_background', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->delete_slides_slide_background(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_slide_background', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('delete_slides_slide_background', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_slide_background', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slides_slide_background', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slides_slide_background', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_slide_background', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_slide_background', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('delete_slides_slide_background', 'folder', $params{ folder });
    $utils->initialize('delete_slides_slide_background', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->delete_slides_slide_background(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_slide_background', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('delete_slides_slide_background', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('delete_slides_slide_background', 'name', 'string'), 'slide_index' => $utils->get_param_value('delete_slides_slide_background', 'slide_index', 'int'), 'password' => $utils->get_param_value('delete_slides_slide_background', 'password', 'string'), 'folder' => $utils->get_param_value('delete_slides_slide_background', 'folder', 'string'), 'storage' => $utils->get_param_value('delete_slides_slide_background', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('delete_slides_slide_background', 'storage', $params{ storage });
    $utils->initialize('delete_slides_slide_background', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->delete_slides_slide_background(%params);
    };
    if ($@) {
        $utils->assert_error('delete_slides_slide_background', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('delete_slides_slide_background', 'storage');
    }
}

#
# download_file test
#
{
    my %params = ('path' => $utils->get_param_value('download_file', 'path', 'string'), 'storage_name' => $utils->get_param_value('download_file', 'storage_name', 'string'), 'version_id' => $utils->get_param_value('download_file', 'version_id', 'string'));
    $utils->initialize('download_file', '');
    eval {
        my $result = $utils->{api}->download_file(%params);
    };
    if ($@) {
        fail("download_file raised an exception: $@");
    }
    pass();
}

{
    my %params = ('path' => $utils->get_param_value('download_file', 'path', 'string'), 'storage_name' => $utils->get_param_value('download_file', 'storage_name', 'string'), 'version_id' => $utils->get_param_value('download_file', 'version_id', 'string'));
    $params{ path } = $utils->invalidize_param_value('download_file', 'path', $params{ path });
    $utils->initialize('download_file', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->download_file(%params);
    };
    if ($@) {
        $utils->assert_error('download_file', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('download_file', 'path');
    }
}

{
    my %params = ('path' => $utils->get_param_value('download_file', 'path', 'string'), 'storage_name' => $utils->get_param_value('download_file', 'storage_name', 'string'), 'version_id' => $utils->get_param_value('download_file', 'version_id', 'string'));
    $params{ storage_name } = $utils->invalidize_param_value('download_file', 'storage_name', $params{ storage_name });
    $utils->initialize('download_file', 'storage_name', $params{ storage_name });

    eval {
        my $result = $utils->{api}->download_file(%params);
    };
    if ($@) {
        $utils->assert_error('download_file', 'storage_name', $params{ storage_name }, $@);
    } else {
        $utils->assert_no_error('download_file', 'storage_name');
    }
}

{
    my %params = ('path' => $utils->get_param_value('download_file', 'path', 'string'), 'storage_name' => $utils->get_param_value('download_file', 'storage_name', 'string'), 'version_id' => $utils->get_param_value('download_file', 'version_id', 'string'));
    $params{ version_id } = $utils->invalidize_param_value('download_file', 'version_id', $params{ version_id });
    $utils->initialize('download_file', 'version_id', $params{ version_id });

    eval {
        my $result = $utils->{api}->download_file(%params);
    };
    if ($@) {
        $utils->assert_error('download_file', 'version_id', $params{ version_id }, $@);
    } else {
        $utils->assert_no_error('download_file', 'version_id');
    }
}

#
# get_disc_usage test
#
{
    my %params = ('storage_name' => $utils->get_param_value('get_disc_usage', 'storage_name', 'string'));
    $utils->initialize('get_disc_usage', '');
    eval {
        my $result = $utils->{api}->get_disc_usage(%params);
    };
    if ($@) {
        fail("get_disc_usage raised an exception: $@");
    }
    pass();
}

{
    my %params = ('storage_name' => $utils->get_param_value('get_disc_usage', 'storage_name', 'string'));
    $params{ storage_name } = $utils->invalidize_param_value('get_disc_usage', 'storage_name', $params{ storage_name });
    $utils->initialize('get_disc_usage', 'storage_name', $params{ storage_name });

    eval {
        my $result = $utils->{api}->get_disc_usage(%params);
    };
    if ($@) {
        $utils->assert_error('get_disc_usage', 'storage_name', $params{ storage_name }, $@);
    } else {
        $utils->assert_no_error('get_disc_usage', 'storage_name');
    }
}

#
# get_file_versions test
#
{
    my %params = ('path' => $utils->get_param_value('get_file_versions', 'path', 'string'), 'storage_name' => $utils->get_param_value('get_file_versions', 'storage_name', 'string'));
    $utils->initialize('get_file_versions', '');
    eval {
        my $result = $utils->{api}->get_file_versions(%params);
    };
    if ($@) {
        fail("get_file_versions raised an exception: $@");
    }
    pass();
}

{
    my %params = ('path' => $utils->get_param_value('get_file_versions', 'path', 'string'), 'storage_name' => $utils->get_param_value('get_file_versions', 'storage_name', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_file_versions', 'path', $params{ path });
    $utils->initialize('get_file_versions', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_file_versions(%params);
    };
    if ($@) {
        $utils->assert_error('get_file_versions', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_file_versions', 'path');
    }
}

{
    my %params = ('path' => $utils->get_param_value('get_file_versions', 'path', 'string'), 'storage_name' => $utils->get_param_value('get_file_versions', 'storage_name', 'string'));
    $params{ storage_name } = $utils->invalidize_param_value('get_file_versions', 'storage_name', $params{ storage_name });
    $utils->initialize('get_file_versions', 'storage_name', $params{ storage_name });

    eval {
        my $result = $utils->{api}->get_file_versions(%params);
    };
    if ($@) {
        $utils->assert_error('get_file_versions', 'storage_name', $params{ storage_name }, $@);
    } else {
        $utils->assert_no_error('get_file_versions', 'storage_name');
    }
}

#
# get_files_list test
#
{
    my %params = ('path' => $utils->get_param_value('get_files_list', 'path', 'string'), 'storage_name' => $utils->get_param_value('get_files_list', 'storage_name', 'string'));
    $utils->initialize('get_files_list', '');
    eval {
        my $result = $utils->{api}->get_files_list(%params);
    };
    if ($@) {
        fail("get_files_list raised an exception: $@");
    }
    pass();
}

{
    my %params = ('path' => $utils->get_param_value('get_files_list', 'path', 'string'), 'storage_name' => $utils->get_param_value('get_files_list', 'storage_name', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_files_list', 'path', $params{ path });
    $utils->initialize('get_files_list', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_files_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_files_list', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_files_list', 'path');
    }
}

{
    my %params = ('path' => $utils->get_param_value('get_files_list', 'path', 'string'), 'storage_name' => $utils->get_param_value('get_files_list', 'storage_name', 'string'));
    $params{ storage_name } = $utils->invalidize_param_value('get_files_list', 'storage_name', $params{ storage_name });
    $utils->initialize('get_files_list', 'storage_name', $params{ storage_name });

    eval {
        my $result = $utils->{api}->get_files_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_files_list', 'storage_name', $params{ storage_name }, $@);
    } else {
        $utils->assert_no_error('get_files_list', 'storage_name');
    }
}

#
# get_layout_slide test
#
{
    my %params = ('name' => $utils->get_param_value('get_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_layout_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_layout_slide', 'storage', 'string'));
    $utils->initialize('get_layout_slide', '');
    eval {
        my $result = $utils->{api}->get_layout_slide(%params);
    };
    if ($@) {
        fail("get_layout_slide raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_layout_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_layout_slide', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_layout_slide', 'name', $params{ name });
    $utils->initialize('get_layout_slide', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_layout_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_layout_slide', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_layout_slide', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_layout_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_layout_slide', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_layout_slide', 'slide_index', $params{ slide_index });
    $utils->initialize('get_layout_slide', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_layout_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_layout_slide', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_layout_slide', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_layout_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_layout_slide', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_layout_slide', 'password', $params{ password });
    $utils->initialize('get_layout_slide', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_layout_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_layout_slide', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_layout_slide', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_layout_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_layout_slide', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_layout_slide', 'folder', $params{ folder });
    $utils->initialize('get_layout_slide', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_layout_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_layout_slide', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_layout_slide', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_layout_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_layout_slide', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_layout_slide', 'storage', $params{ storage });
    $utils->initialize('get_layout_slide', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_layout_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_layout_slide', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_layout_slide', 'storage');
    }
}

#
# get_layout_slides_list test
#
{
    my %params = ('name' => $utils->get_param_value('get_layout_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_layout_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_layout_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_layout_slides_list', 'storage', 'string'));
    $utils->initialize('get_layout_slides_list', '');
    eval {
        my $result = $utils->{api}->get_layout_slides_list(%params);
    };
    if ($@) {
        fail("get_layout_slides_list raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_layout_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_layout_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_layout_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_layout_slides_list', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_layout_slides_list', 'name', $params{ name });
    $utils->initialize('get_layout_slides_list', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_layout_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_layout_slides_list', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_layout_slides_list', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_layout_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_layout_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_layout_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_layout_slides_list', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_layout_slides_list', 'password', $params{ password });
    $utils->initialize('get_layout_slides_list', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_layout_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_layout_slides_list', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_layout_slides_list', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_layout_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_layout_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_layout_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_layout_slides_list', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_layout_slides_list', 'folder', $params{ folder });
    $utils->initialize('get_layout_slides_list', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_layout_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_layout_slides_list', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_layout_slides_list', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_layout_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_layout_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_layout_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_layout_slides_list', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_layout_slides_list', 'storage', $params{ storage });
    $utils->initialize('get_layout_slides_list', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_layout_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_layout_slides_list', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_layout_slides_list', 'storage');
    }
}

#
# get_master_slide test
#
{
    my %params = ('name' => $utils->get_param_value('get_master_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_master_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_master_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_master_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_master_slide', 'storage', 'string'));
    $utils->initialize('get_master_slide', '');
    eval {
        my $result = $utils->{api}->get_master_slide(%params);
    };
    if ($@) {
        fail("get_master_slide raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_master_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_master_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_master_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_master_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_master_slide', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_master_slide', 'name', $params{ name });
    $utils->initialize('get_master_slide', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_master_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_master_slide', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_master_slide', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_master_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_master_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_master_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_master_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_master_slide', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_master_slide', 'slide_index', $params{ slide_index });
    $utils->initialize('get_master_slide', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_master_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_master_slide', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_master_slide', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_master_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_master_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_master_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_master_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_master_slide', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_master_slide', 'password', $params{ password });
    $utils->initialize('get_master_slide', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_master_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_master_slide', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_master_slide', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_master_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_master_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_master_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_master_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_master_slide', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_master_slide', 'folder', $params{ folder });
    $utils->initialize('get_master_slide', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_master_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_master_slide', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_master_slide', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_master_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_master_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_master_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_master_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_master_slide', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_master_slide', 'storage', $params{ storage });
    $utils->initialize('get_master_slide', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_master_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_master_slide', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_master_slide', 'storage');
    }
}

#
# get_master_slides_list test
#
{
    my %params = ('name' => $utils->get_param_value('get_master_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_master_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_master_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_master_slides_list', 'storage', 'string'));
    $utils->initialize('get_master_slides_list', '');
    eval {
        my $result = $utils->{api}->get_master_slides_list(%params);
    };
    if ($@) {
        fail("get_master_slides_list raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_master_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_master_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_master_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_master_slides_list', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_master_slides_list', 'name', $params{ name });
    $utils->initialize('get_master_slides_list', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_master_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_master_slides_list', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_master_slides_list', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_master_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_master_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_master_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_master_slides_list', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_master_slides_list', 'password', $params{ password });
    $utils->initialize('get_master_slides_list', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_master_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_master_slides_list', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_master_slides_list', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_master_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_master_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_master_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_master_slides_list', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_master_slides_list', 'folder', $params{ folder });
    $utils->initialize('get_master_slides_list', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_master_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_master_slides_list', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_master_slides_list', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_master_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_master_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_master_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_master_slides_list', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_master_slides_list', 'storage', $params{ storage });
    $utils->initialize('get_master_slides_list', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_master_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_master_slides_list', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_master_slides_list', 'storage');
    }
}

#
# get_notes_slide test
#
{
    my %params = ('name' => $utils->get_param_value('get_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide', 'storage', 'string'));
    $utils->initialize('get_notes_slide', '');
    eval {
        my $result = $utils->{api}->get_notes_slide(%params);
    };
    if ($@) {
        fail("get_notes_slide raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_notes_slide', 'name', $params{ name });
    $utils->initialize('get_notes_slide', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_notes_slide', 'slide_index', $params{ slide_index });
    $utils->initialize('get_notes_slide', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_notes_slide', 'password', $params{ password });
    $utils->initialize('get_notes_slide', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_notes_slide', 'folder', $params{ folder });
    $utils->initialize('get_notes_slide', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_notes_slide', 'storage', $params{ storage });
    $utils->initialize('get_notes_slide', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide', 'storage');
    }
}

#
# get_notes_slide_shape test
#
{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape', 'storage', 'string'));
    $utils->initialize('get_notes_slide_shape', '');
    eval {
        my $result = $utils->{api}->get_notes_slide_shape(%params);
    };
    if ($@) {
        fail("get_notes_slide_shape raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_notes_slide_shape', 'name', $params{ name });
    $utils->initialize('get_notes_slide_shape', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_notes_slide_shape', 'slide_index', $params{ slide_index });
    $utils->initialize('get_notes_slide_shape', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_notes_slide_shape', 'path', $params{ path });
    $utils->initialize('get_notes_slide_shape', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('get_notes_slide_shape', 'shape_index', $params{ shape_index });
    $utils->initialize('get_notes_slide_shape', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_notes_slide_shape', 'password', $params{ password });
    $utils->initialize('get_notes_slide_shape', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_notes_slide_shape', 'folder', $params{ folder });
    $utils->initialize('get_notes_slide_shape', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_notes_slide_shape', 'storage', $params{ storage });
    $utils->initialize('get_notes_slide_shape', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape', 'storage');
    }
}

#
# get_notes_slide_shape_paragraph test
#
{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'storage', 'string'));
    $utils->initialize('get_notes_slide_shape_paragraph', '');
    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraph(%params);
    };
    if ($@) {
        fail("get_notes_slide_shape_paragraph raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_notes_slide_shape_paragraph', 'name', $params{ name });
    $utils->initialize('get_notes_slide_shape_paragraph', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraph', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraph', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_notes_slide_shape_paragraph', 'slide_index', $params{ slide_index });
    $utils->initialize('get_notes_slide_shape_paragraph', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraph', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraph', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_notes_slide_shape_paragraph', 'path', $params{ path });
    $utils->initialize('get_notes_slide_shape_paragraph', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraph', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraph', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('get_notes_slide_shape_paragraph', 'shape_index', $params{ shape_index });
    $utils->initialize('get_notes_slide_shape_paragraph', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraph', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraph', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('get_notes_slide_shape_paragraph', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('get_notes_slide_shape_paragraph', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraph', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraph', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_notes_slide_shape_paragraph', 'password', $params{ password });
    $utils->initialize('get_notes_slide_shape_paragraph', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraph', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraph', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_notes_slide_shape_paragraph', 'folder', $params{ folder });
    $utils->initialize('get_notes_slide_shape_paragraph', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraph', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraph', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraph', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_notes_slide_shape_paragraph', 'storage', $params{ storage });
    $utils->initialize('get_notes_slide_shape_paragraph', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraph', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraph', 'storage');
    }
}

#
# get_notes_slide_shape_paragraphs test
#
{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'storage', 'string'));
    $utils->initialize('get_notes_slide_shape_paragraphs', '');
    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraphs(%params);
    };
    if ($@) {
        fail("get_notes_slide_shape_paragraphs raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_notes_slide_shape_paragraphs', 'name', $params{ name });
    $utils->initialize('get_notes_slide_shape_paragraphs', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraphs', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraphs', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_notes_slide_shape_paragraphs', 'slide_index', $params{ slide_index });
    $utils->initialize('get_notes_slide_shape_paragraphs', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraphs', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraphs', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_notes_slide_shape_paragraphs', 'path', $params{ path });
    $utils->initialize('get_notes_slide_shape_paragraphs', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraphs', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraphs', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('get_notes_slide_shape_paragraphs', 'shape_index', $params{ shape_index });
    $utils->initialize('get_notes_slide_shape_paragraphs', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraphs', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraphs', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_notes_slide_shape_paragraphs', 'password', $params{ password });
    $utils->initialize('get_notes_slide_shape_paragraphs', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraphs', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraphs', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_notes_slide_shape_paragraphs', 'folder', $params{ folder });
    $utils->initialize('get_notes_slide_shape_paragraphs', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraphs', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraphs', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_paragraphs', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_notes_slide_shape_paragraphs', 'storage', $params{ storage });
    $utils->initialize('get_notes_slide_shape_paragraphs', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_paragraphs', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_paragraphs', 'storage');
    }
}

#
# get_notes_slide_shape_portion test
#
{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portion', 'storage', 'string'));
    $utils->initialize('get_notes_slide_shape_portion', '');
    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portion(%params);
    };
    if ($@) {
        fail("get_notes_slide_shape_portion raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portion', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_notes_slide_shape_portion', 'name', $params{ name });
    $utils->initialize('get_notes_slide_shape_portion', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portion', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portion', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portion', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_notes_slide_shape_portion', 'slide_index', $params{ slide_index });
    $utils->initialize('get_notes_slide_shape_portion', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portion', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portion', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portion', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_notes_slide_shape_portion', 'path', $params{ path });
    $utils->initialize('get_notes_slide_shape_portion', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portion', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portion', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portion', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('get_notes_slide_shape_portion', 'shape_index', $params{ shape_index });
    $utils->initialize('get_notes_slide_shape_portion', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portion', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portion', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portion', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('get_notes_slide_shape_portion', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('get_notes_slide_shape_portion', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portion', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portion', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portion', 'storage', 'string'));
    $params{ portion_index } = $utils->invalidize_param_value('get_notes_slide_shape_portion', 'portion_index', $params{ portion_index });
    $utils->initialize('get_notes_slide_shape_portion', 'portion_index', $params{ portion_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portion', 'portion_index', $params{ portion_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portion', 'portion_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portion', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_notes_slide_shape_portion', 'password', $params{ password });
    $utils->initialize('get_notes_slide_shape_portion', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portion', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portion', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portion', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_notes_slide_shape_portion', 'folder', $params{ folder });
    $utils->initialize('get_notes_slide_shape_portion', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portion', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portion', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_notes_slide_shape_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portion', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_notes_slide_shape_portion', 'storage', $params{ storage });
    $utils->initialize('get_notes_slide_shape_portion', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portion', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portion', 'storage');
    }
}

#
# get_notes_slide_shape_portions test
#
{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portions', 'storage', 'string'));
    $utils->initialize('get_notes_slide_shape_portions', '');
    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portions(%params);
    };
    if ($@) {
        fail("get_notes_slide_shape_portions raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portions', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_notes_slide_shape_portions', 'name', $params{ name });
    $utils->initialize('get_notes_slide_shape_portions', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portions', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portions', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portions', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_notes_slide_shape_portions', 'slide_index', $params{ slide_index });
    $utils->initialize('get_notes_slide_shape_portions', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portions', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portions', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portions', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_notes_slide_shape_portions', 'path', $params{ path });
    $utils->initialize('get_notes_slide_shape_portions', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portions', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portions', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portions', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('get_notes_slide_shape_portions', 'shape_index', $params{ shape_index });
    $utils->initialize('get_notes_slide_shape_portions', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portions', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portions', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portions', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('get_notes_slide_shape_portions', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('get_notes_slide_shape_portions', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portions', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portions', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portions', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_notes_slide_shape_portions', 'password', $params{ password });
    $utils->initialize('get_notes_slide_shape_portions', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portions', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portions', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portions', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_notes_slide_shape_portions', 'folder', $params{ folder });
    $utils->initialize('get_notes_slide_shape_portions', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portions', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portions', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shape_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shape_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_notes_slide_shape_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_notes_slide_shape_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shape_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shape_portions', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_notes_slide_shape_portions', 'storage', $params{ storage });
    $utils->initialize('get_notes_slide_shape_portions', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_notes_slide_shape_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shape_portions', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shape_portions', 'storage');
    }
}

#
# get_notes_slide_shapes test
#
{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shapes', 'storage', 'string'));
    $utils->initialize('get_notes_slide_shapes', '');
    eval {
        my $result = $utils->{api}->get_notes_slide_shapes(%params);
    };
    if ($@) {
        fail("get_notes_slide_shapes raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shapes', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_notes_slide_shapes', 'name', $params{ name });
    $utils->initialize('get_notes_slide_shapes', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shapes', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shapes', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shapes', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_notes_slide_shapes', 'slide_index', $params{ slide_index });
    $utils->initialize('get_notes_slide_shapes', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shapes', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shapes', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shapes', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_notes_slide_shapes', 'path', $params{ path });
    $utils->initialize('get_notes_slide_shapes', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shapes', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shapes', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shapes', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_notes_slide_shapes', 'password', $params{ password });
    $utils->initialize('get_notes_slide_shapes', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shapes', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shapes', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shapes', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_notes_slide_shapes', 'folder', $params{ folder });
    $utils->initialize('get_notes_slide_shapes', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shapes', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shapes', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_notes_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_notes_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_shapes', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_notes_slide_shapes', 'storage', $params{ storage });
    $utils->initialize('get_notes_slide_shapes', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_notes_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_shapes', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_shapes', 'storage');
    }
}

#
# get_notes_slide_with_format test
#
{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_with_format', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_with_format', 'slide_index', 'int'), 'format' => $utils->get_param_value('get_notes_slide_with_format', 'format', 'string'), 'width' => $utils->get_param_value('get_notes_slide_with_format', 'width', 'int'), 'height' => $utils->get_param_value('get_notes_slide_with_format', 'height', 'int'), 'password' => $utils->get_param_value('get_notes_slide_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_with_format', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('get_notes_slide_with_format', 'fonts_folder', 'string'));
    $utils->initialize('get_notes_slide_with_format', '');
    eval {
        my $result = $utils->{api}->get_notes_slide_with_format(%params);
    };
    if ($@) {
        fail("get_notes_slide_with_format raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_with_format', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_with_format', 'slide_index', 'int'), 'format' => $utils->get_param_value('get_notes_slide_with_format', 'format', 'string'), 'width' => $utils->get_param_value('get_notes_slide_with_format', 'width', 'int'), 'height' => $utils->get_param_value('get_notes_slide_with_format', 'height', 'int'), 'password' => $utils->get_param_value('get_notes_slide_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_with_format', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('get_notes_slide_with_format', 'fonts_folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_notes_slide_with_format', 'name', $params{ name });
    $utils->initialize('get_notes_slide_with_format', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_notes_slide_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_with_format', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_with_format', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_with_format', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_with_format', 'slide_index', 'int'), 'format' => $utils->get_param_value('get_notes_slide_with_format', 'format', 'string'), 'width' => $utils->get_param_value('get_notes_slide_with_format', 'width', 'int'), 'height' => $utils->get_param_value('get_notes_slide_with_format', 'height', 'int'), 'password' => $utils->get_param_value('get_notes_slide_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_with_format', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('get_notes_slide_with_format', 'fonts_folder', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_notes_slide_with_format', 'slide_index', $params{ slide_index });
    $utils->initialize('get_notes_slide_with_format', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_notes_slide_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_with_format', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_with_format', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_with_format', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_with_format', 'slide_index', 'int'), 'format' => $utils->get_param_value('get_notes_slide_with_format', 'format', 'string'), 'width' => $utils->get_param_value('get_notes_slide_with_format', 'width', 'int'), 'height' => $utils->get_param_value('get_notes_slide_with_format', 'height', 'int'), 'password' => $utils->get_param_value('get_notes_slide_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_with_format', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('get_notes_slide_with_format', 'fonts_folder', 'string'));
    $params{ format } = $utils->invalidize_param_value('get_notes_slide_with_format', 'format', $params{ format });
    $utils->initialize('get_notes_slide_with_format', 'format', $params{ format });

    eval {
        my $result = $utils->{api}->get_notes_slide_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_with_format', 'format', $params{ format }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_with_format', 'format');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_with_format', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_with_format', 'slide_index', 'int'), 'format' => $utils->get_param_value('get_notes_slide_with_format', 'format', 'string'), 'width' => $utils->get_param_value('get_notes_slide_with_format', 'width', 'int'), 'height' => $utils->get_param_value('get_notes_slide_with_format', 'height', 'int'), 'password' => $utils->get_param_value('get_notes_slide_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_with_format', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('get_notes_slide_with_format', 'fonts_folder', 'string'));
    $params{ width } = $utils->invalidize_param_value('get_notes_slide_with_format', 'width', $params{ width });
    $utils->initialize('get_notes_slide_with_format', 'width', $params{ width });

    eval {
        my $result = $utils->{api}->get_notes_slide_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_with_format', 'width', $params{ width }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_with_format', 'width');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_with_format', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_with_format', 'slide_index', 'int'), 'format' => $utils->get_param_value('get_notes_slide_with_format', 'format', 'string'), 'width' => $utils->get_param_value('get_notes_slide_with_format', 'width', 'int'), 'height' => $utils->get_param_value('get_notes_slide_with_format', 'height', 'int'), 'password' => $utils->get_param_value('get_notes_slide_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_with_format', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('get_notes_slide_with_format', 'fonts_folder', 'string'));
    $params{ height } = $utils->invalidize_param_value('get_notes_slide_with_format', 'height', $params{ height });
    $utils->initialize('get_notes_slide_with_format', 'height', $params{ height });

    eval {
        my $result = $utils->{api}->get_notes_slide_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_with_format', 'height', $params{ height }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_with_format', 'height');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_with_format', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_with_format', 'slide_index', 'int'), 'format' => $utils->get_param_value('get_notes_slide_with_format', 'format', 'string'), 'width' => $utils->get_param_value('get_notes_slide_with_format', 'width', 'int'), 'height' => $utils->get_param_value('get_notes_slide_with_format', 'height', 'int'), 'password' => $utils->get_param_value('get_notes_slide_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_with_format', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('get_notes_slide_with_format', 'fonts_folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_notes_slide_with_format', 'password', $params{ password });
    $utils->initialize('get_notes_slide_with_format', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_notes_slide_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_with_format', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_with_format', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_with_format', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_with_format', 'slide_index', 'int'), 'format' => $utils->get_param_value('get_notes_slide_with_format', 'format', 'string'), 'width' => $utils->get_param_value('get_notes_slide_with_format', 'width', 'int'), 'height' => $utils->get_param_value('get_notes_slide_with_format', 'height', 'int'), 'password' => $utils->get_param_value('get_notes_slide_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_with_format', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('get_notes_slide_with_format', 'fonts_folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_notes_slide_with_format', 'folder', $params{ folder });
    $utils->initialize('get_notes_slide_with_format', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_notes_slide_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_with_format', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_with_format', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_with_format', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_with_format', 'slide_index', 'int'), 'format' => $utils->get_param_value('get_notes_slide_with_format', 'format', 'string'), 'width' => $utils->get_param_value('get_notes_slide_with_format', 'width', 'int'), 'height' => $utils->get_param_value('get_notes_slide_with_format', 'height', 'int'), 'password' => $utils->get_param_value('get_notes_slide_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_with_format', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('get_notes_slide_with_format', 'fonts_folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_notes_slide_with_format', 'storage', $params{ storage });
    $utils->initialize('get_notes_slide_with_format', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_notes_slide_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_with_format', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_with_format', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_notes_slide_with_format', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_notes_slide_with_format', 'slide_index', 'int'), 'format' => $utils->get_param_value('get_notes_slide_with_format', 'format', 'string'), 'width' => $utils->get_param_value('get_notes_slide_with_format', 'width', 'int'), 'height' => $utils->get_param_value('get_notes_slide_with_format', 'height', 'int'), 'password' => $utils->get_param_value('get_notes_slide_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_notes_slide_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_notes_slide_with_format', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('get_notes_slide_with_format', 'fonts_folder', 'string'));
    $params{ fonts_folder } = $utils->invalidize_param_value('get_notes_slide_with_format', 'fonts_folder', $params{ fonts_folder });
    $utils->initialize('get_notes_slide_with_format', 'fonts_folder', $params{ fonts_folder });

    eval {
        my $result = $utils->{api}->get_notes_slide_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_notes_slide_with_format', 'fonts_folder', $params{ fonts_folder }, $@);
    } else {
        $utils->assert_no_error('get_notes_slide_with_format', 'fonts_folder');
    }
}

#
# get_paragraph_portion test
#
{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_paragraph_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portion', 'storage', 'string'));
    $utils->initialize('get_paragraph_portion', '');
    eval {
        my $result = $utils->{api}->get_paragraph_portion(%params);
    };
    if ($@) {
        fail("get_paragraph_portion raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_paragraph_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portion', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_paragraph_portion', 'name', $params{ name });
    $utils->initialize('get_paragraph_portion', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_paragraph_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portion', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portion', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_paragraph_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portion', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_paragraph_portion', 'slide_index', $params{ slide_index });
    $utils->initialize('get_paragraph_portion', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_paragraph_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portion', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portion', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_paragraph_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portion', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_paragraph_portion', 'path', $params{ path });
    $utils->initialize('get_paragraph_portion', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_paragraph_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portion', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portion', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_paragraph_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portion', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('get_paragraph_portion', 'shape_index', $params{ shape_index });
    $utils->initialize('get_paragraph_portion', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->get_paragraph_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portion', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portion', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_paragraph_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portion', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('get_paragraph_portion', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('get_paragraph_portion', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->get_paragraph_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portion', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portion', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_paragraph_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portion', 'storage', 'string'));
    $params{ portion_index } = $utils->invalidize_param_value('get_paragraph_portion', 'portion_index', $params{ portion_index });
    $utils->initialize('get_paragraph_portion', 'portion_index', $params{ portion_index });

    eval {
        my $result = $utils->{api}->get_paragraph_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portion', 'portion_index', $params{ portion_index }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portion', 'portion_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_paragraph_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portion', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_paragraph_portion', 'password', $params{ password });
    $utils->initialize('get_paragraph_portion', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_paragraph_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portion', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portion', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_paragraph_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portion', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_paragraph_portion', 'folder', $params{ folder });
    $utils->initialize('get_paragraph_portion', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_paragraph_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portion', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portion', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portion', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('get_paragraph_portion', 'portion_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portion', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portion', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_paragraph_portion', 'storage', $params{ storage });
    $utils->initialize('get_paragraph_portion', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_paragraph_portion(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portion', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portion', 'storage');
    }
}

#
# get_paragraph_portions test
#
{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portions', 'storage', 'string'));
    $utils->initialize('get_paragraph_portions', '');
    eval {
        my $result = $utils->{api}->get_paragraph_portions(%params);
    };
    if ($@) {
        fail("get_paragraph_portions raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portions', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_paragraph_portions', 'name', $params{ name });
    $utils->initialize('get_paragraph_portions', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_paragraph_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portions', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portions', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portions', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_paragraph_portions', 'slide_index', $params{ slide_index });
    $utils->initialize('get_paragraph_portions', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_paragraph_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portions', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portions', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portions', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_paragraph_portions', 'path', $params{ path });
    $utils->initialize('get_paragraph_portions', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_paragraph_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portions', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portions', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portions', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('get_paragraph_portions', 'shape_index', $params{ shape_index });
    $utils->initialize('get_paragraph_portions', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->get_paragraph_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portions', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portions', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portions', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('get_paragraph_portions', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('get_paragraph_portions', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->get_paragraph_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portions', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portions', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portions', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_paragraph_portions', 'password', $params{ password });
    $utils->initialize('get_paragraph_portions', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_paragraph_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portions', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portions', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portions', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_paragraph_portions', 'folder', $params{ folder });
    $utils->initialize('get_paragraph_portions', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_paragraph_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portions', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portions', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_paragraph_portions', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_paragraph_portions', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_paragraph_portions', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_paragraph_portions', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_paragraph_portions', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_paragraph_portions', 'password', 'string'), 'folder' => $utils->get_param_value('get_paragraph_portions', 'folder', 'string'), 'storage' => $utils->get_param_value('get_paragraph_portions', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_paragraph_portions', 'storage', $params{ storage });
    $utils->initialize('get_paragraph_portions', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_paragraph_portions(%params);
    };
    if ($@) {
        $utils->assert_error('get_paragraph_portions', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_paragraph_portions', 'storage');
    }
}

#
# get_slide_animation test
#
{
    my %params = ('name' => $utils->get_param_value('get_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_animation', 'slide_index', 'int'), 'shape_index' => $utils->get_param_value('get_slide_animation', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_animation', 'storage', 'string'));
    $utils->initialize('get_slide_animation', '');
    eval {
        my $result = $utils->{api}->get_slide_animation(%params);
    };
    if ($@) {
        fail("get_slide_animation raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_animation', 'slide_index', 'int'), 'shape_index' => $utils->get_param_value('get_slide_animation', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_animation', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slide_animation', 'name', $params{ name });
    $utils->initialize('get_slide_animation', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_animation', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slide_animation', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_animation', 'slide_index', 'int'), 'shape_index' => $utils->get_param_value('get_slide_animation', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_animation', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slide_animation', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slide_animation', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_animation', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slide_animation', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_animation', 'slide_index', 'int'), 'shape_index' => $utils->get_param_value('get_slide_animation', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_animation', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('get_slide_animation', 'shape_index', $params{ shape_index });
    $utils->initialize('get_slide_animation', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->get_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_animation', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('get_slide_animation', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_animation', 'slide_index', 'int'), 'shape_index' => $utils->get_param_value('get_slide_animation', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_animation', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slide_animation', 'password', $params{ password });
    $utils->initialize('get_slide_animation', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_animation', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slide_animation', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_animation', 'slide_index', 'int'), 'shape_index' => $utils->get_param_value('get_slide_animation', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_animation', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slide_animation', 'folder', $params{ folder });
    $utils->initialize('get_slide_animation', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_animation', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slide_animation', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_animation', 'slide_index', 'int'), 'shape_index' => $utils->get_param_value('get_slide_animation', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_animation', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slide_animation', 'storage', $params{ storage });
    $utils->initialize('get_slide_animation', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_animation', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slide_animation', 'storage');
    }
}

#
# get_slide_shape test
#
{
    my %params = ('name' => $utils->get_param_value('get_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape', 'storage', 'string'));
    $utils->initialize('get_slide_shape', '');
    eval {
        my $result = $utils->{api}->get_slide_shape(%params);
    };
    if ($@) {
        fail("get_slide_shape raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slide_shape', 'name', $params{ name });
    $utils->initialize('get_slide_shape', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slide_shape', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slide_shape', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_slide_shape', 'path', $params{ path });
    $utils->initialize('get_slide_shape', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('get_slide_shape', 'shape_index', $params{ shape_index });
    $utils->initialize('get_slide_shape', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->get_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slide_shape', 'password', $params{ password });
    $utils->initialize('get_slide_shape', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slide_shape', 'folder', $params{ folder });
    $utils->initialize('get_slide_shape', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slide_shape', 'storage', $params{ storage });
    $utils->initialize('get_slide_shape', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slide_shape(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape', 'storage');
    }
}

#
# get_slide_shape_paragraph test
#
{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraph', 'storage', 'string'));
    $utils->initialize('get_slide_shape_paragraph', '');
    eval {
        my $result = $utils->{api}->get_slide_shape_paragraph(%params);
    };
    if ($@) {
        fail("get_slide_shape_paragraph raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraph', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slide_shape_paragraph', 'name', $params{ name });
    $utils->initialize('get_slide_shape_paragraph', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraph', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraph', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraph', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slide_shape_paragraph', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slide_shape_paragraph', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraph', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraph', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraph', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_slide_shape_paragraph', 'path', $params{ path });
    $utils->initialize('get_slide_shape_paragraph', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraph', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraph', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraph', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('get_slide_shape_paragraph', 'shape_index', $params{ shape_index });
    $utils->initialize('get_slide_shape_paragraph', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraph', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraph', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraph', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('get_slide_shape_paragraph', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('get_slide_shape_paragraph', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraph', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraph', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraph', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slide_shape_paragraph', 'password', $params{ password });
    $utils->initialize('get_slide_shape_paragraph', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraph', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraph', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraph', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slide_shape_paragraph', 'folder', $params{ folder });
    $utils->initialize('get_slide_shape_paragraph', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraph', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraph', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraph', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('get_slide_shape_paragraph', 'paragraph_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraph', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slide_shape_paragraph', 'storage', $params{ storage });
    $utils->initialize('get_slide_shape_paragraph', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraph', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraph', 'storage');
    }
}

#
# get_slide_shape_paragraphs test
#
{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraphs', 'storage', 'string'));
    $utils->initialize('get_slide_shape_paragraphs', '');
    eval {
        my $result = $utils->{api}->get_slide_shape_paragraphs(%params);
    };
    if ($@) {
        fail("get_slide_shape_paragraphs raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraphs', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slide_shape_paragraphs', 'name', $params{ name });
    $utils->initialize('get_slide_shape_paragraphs', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraphs', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraphs', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraphs', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slide_shape_paragraphs', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slide_shape_paragraphs', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraphs', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraphs', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraphs', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_slide_shape_paragraphs', 'path', $params{ path });
    $utils->initialize('get_slide_shape_paragraphs', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraphs', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraphs', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraphs', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('get_slide_shape_paragraphs', 'shape_index', $params{ shape_index });
    $utils->initialize('get_slide_shape_paragraphs', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraphs', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraphs', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraphs', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slide_shape_paragraphs', 'password', $params{ password });
    $utils->initialize('get_slide_shape_paragraphs', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraphs', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraphs', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraphs', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slide_shape_paragraphs', 'folder', $params{ folder });
    $utils->initialize('get_slide_shape_paragraphs', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraphs', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraphs', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shape_paragraphs', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shape_paragraphs', 'path', 'string'), 'shape_index' => $utils->get_param_value('get_slide_shape_paragraphs', 'shape_index', 'int'), 'password' => $utils->get_param_value('get_slide_shape_paragraphs', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shape_paragraphs', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shape_paragraphs', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slide_shape_paragraphs', 'storage', $params{ storage });
    $utils->initialize('get_slide_shape_paragraphs', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slide_shape_paragraphs(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shape_paragraphs', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slide_shape_paragraphs', 'storage');
    }
}

#
# get_slide_shapes test
#
{
    my %params = ('name' => $utils->get_param_value('get_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shapes', 'storage', 'string'));
    $utils->initialize('get_slide_shapes', '');
    eval {
        my $result = $utils->{api}->get_slide_shapes(%params);
    };
    if ($@) {
        fail("get_slide_shapes raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shapes', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slide_shapes', 'name', $params{ name });
    $utils->initialize('get_slide_shapes', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shapes', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slide_shapes', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shapes', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slide_shapes', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slide_shapes', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shapes', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slide_shapes', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shapes', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('get_slide_shapes', 'path', $params{ path });
    $utils->initialize('get_slide_shapes', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->get_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shapes', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('get_slide_shapes', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shapes', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slide_shapes', 'password', $params{ password });
    $utils->initialize('get_slide_shapes', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shapes', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slide_shapes', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shapes', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slide_shapes', 'folder', $params{ folder });
    $utils->initialize('get_slide_shapes', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shapes', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slide_shapes', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slide_shapes', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slide_shapes', 'slide_index', 'int'), 'path' => $utils->get_param_value('get_slide_shapes', 'path', 'string'), 'password' => $utils->get_param_value('get_slide_shapes', 'password', 'string'), 'folder' => $utils->get_param_value('get_slide_shapes', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slide_shapes', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slide_shapes', 'storage', $params{ storage });
    $utils->initialize('get_slide_shapes', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slide_shapes(%params);
    };
    if ($@) {
        $utils->assert_error('get_slide_shapes', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slide_shapes', 'storage');
    }
}

#
# get_slides_api_info test
#
{
    my %params = ();
    $utils->initialize('get_slides_api_info', '');
    eval {
        my $result = $utils->{api}->get_slides_api_info(%params);
    };
    if ($@) {
        fail("get_slides_api_info raised an exception: $@");
    }
    pass();
}

#
# get_slides_document test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_document', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_document', 'password', 'string'), 'storage' => $utils->get_param_value('get_slides_document', 'storage', 'string'), 'folder' => $utils->get_param_value('get_slides_document', 'folder', 'string'));
    $utils->initialize('get_slides_document', '');
    eval {
        my $result = $utils->{api}->get_slides_document(%params);
    };
    if ($@) {
        fail("get_slides_document raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_document', 'password', 'string'), 'storage' => $utils->get_param_value('get_slides_document', 'storage', 'string'), 'folder' => $utils->get_param_value('get_slides_document', 'folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_document', 'name', $params{ name });
    $utils->initialize('get_slides_document', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_document(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_document', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_document', 'password', 'string'), 'storage' => $utils->get_param_value('get_slides_document', 'storage', 'string'), 'folder' => $utils->get_param_value('get_slides_document', 'folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_document', 'password', $params{ password });
    $utils->initialize('get_slides_document', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_document(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_document', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_document', 'password', 'string'), 'storage' => $utils->get_param_value('get_slides_document', 'storage', 'string'), 'folder' => $utils->get_param_value('get_slides_document', 'folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_document', 'storage', $params{ storage });
    $utils->initialize('get_slides_document', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_document(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_document', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_document', 'password', 'string'), 'storage' => $utils->get_param_value('get_slides_document', 'storage', 'string'), 'folder' => $utils->get_param_value('get_slides_document', 'folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_document', 'folder', $params{ folder });
    $utils->initialize('get_slides_document', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_document(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_document', 'folder');
    }
}

#
# get_slides_document_properties test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_document_properties', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_document_properties', 'storage', 'string'));
    $utils->initialize('get_slides_document_properties', '');
    eval {
        my $result = $utils->{api}->get_slides_document_properties(%params);
    };
    if ($@) {
        fail("get_slides_document_properties raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document_properties', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_document_properties', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_document_properties', 'name', $params{ name });
    $utils->initialize('get_slides_document_properties', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document_properties', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_document_properties', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document_properties', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_document_properties', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_document_properties', 'password', $params{ password });
    $utils->initialize('get_slides_document_properties', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document_properties', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_document_properties', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document_properties', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_document_properties', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_document_properties', 'folder', $params{ folder });
    $utils->initialize('get_slides_document_properties', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document_properties', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_document_properties', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document_properties', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_document_properties', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_document_properties', 'storage', $params{ storage });
    $utils->initialize('get_slides_document_properties', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document_properties', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_document_properties', 'storage');
    }
}

#
# get_slides_document_property test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_document_property', 'name', 'string'), 'property_name' => $utils->get_param_value('get_slides_document_property', 'property_name', 'string'), 'password' => $utils->get_param_value('get_slides_document_property', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_document_property', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_document_property', 'storage', 'string'));
    $utils->initialize('get_slides_document_property', '');
    eval {
        my $result = $utils->{api}->get_slides_document_property(%params);
    };
    if ($@) {
        fail("get_slides_document_property raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document_property', 'name', 'string'), 'property_name' => $utils->get_param_value('get_slides_document_property', 'property_name', 'string'), 'password' => $utils->get_param_value('get_slides_document_property', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_document_property', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_document_property', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_document_property', 'name', $params{ name });
    $utils->initialize('get_slides_document_property', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_document_property(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document_property', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_document_property', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document_property', 'name', 'string'), 'property_name' => $utils->get_param_value('get_slides_document_property', 'property_name', 'string'), 'password' => $utils->get_param_value('get_slides_document_property', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_document_property', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_document_property', 'storage', 'string'));
    $params{ property_name } = $utils->invalidize_param_value('get_slides_document_property', 'property_name', $params{ property_name });
    $utils->initialize('get_slides_document_property', 'property_name', $params{ property_name });

    eval {
        my $result = $utils->{api}->get_slides_document_property(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document_property', 'property_name', $params{ property_name }, $@);
    } else {
        $utils->assert_no_error('get_slides_document_property', 'property_name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document_property', 'name', 'string'), 'property_name' => $utils->get_param_value('get_slides_document_property', 'property_name', 'string'), 'password' => $utils->get_param_value('get_slides_document_property', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_document_property', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_document_property', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_document_property', 'password', $params{ password });
    $utils->initialize('get_slides_document_property', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_document_property(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document_property', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_document_property', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document_property', 'name', 'string'), 'property_name' => $utils->get_param_value('get_slides_document_property', 'property_name', 'string'), 'password' => $utils->get_param_value('get_slides_document_property', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_document_property', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_document_property', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_document_property', 'folder', $params{ folder });
    $utils->initialize('get_slides_document_property', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_document_property(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document_property', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_document_property', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_document_property', 'name', 'string'), 'property_name' => $utils->get_param_value('get_slides_document_property', 'property_name', 'string'), 'password' => $utils->get_param_value('get_slides_document_property', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_document_property', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_document_property', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_document_property', 'storage', $params{ storage });
    $utils->initialize('get_slides_document_property', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_document_property(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_document_property', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_document_property', 'storage');
    }
}

#
# get_slides_image_with_default_format test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_default_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_default_format', 'index', 'int'), 'password' => $utils->get_param_value('get_slides_image_with_default_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_default_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_default_format', 'storage', 'string'));
    $utils->initialize('get_slides_image_with_default_format', '');
    eval {
        my $result = $utils->{api}->get_slides_image_with_default_format(%params);
    };
    if ($@) {
        fail("get_slides_image_with_default_format raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_default_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_default_format', 'index', 'int'), 'password' => $utils->get_param_value('get_slides_image_with_default_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_default_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_default_format', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_image_with_default_format', 'name', $params{ name });
    $utils->initialize('get_slides_image_with_default_format', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_image_with_default_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_image_with_default_format', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_image_with_default_format', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_default_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_default_format', 'index', 'int'), 'password' => $utils->get_param_value('get_slides_image_with_default_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_default_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_default_format', 'storage', 'string'));
    $params{ index } = $utils->invalidize_param_value('get_slides_image_with_default_format', 'index', $params{ index });
    $utils->initialize('get_slides_image_with_default_format', 'index', $params{ index });

    eval {
        my $result = $utils->{api}->get_slides_image_with_default_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_image_with_default_format', 'index', $params{ index }, $@);
    } else {
        $utils->assert_no_error('get_slides_image_with_default_format', 'index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_default_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_default_format', 'index', 'int'), 'password' => $utils->get_param_value('get_slides_image_with_default_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_default_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_default_format', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_image_with_default_format', 'password', $params{ password });
    $utils->initialize('get_slides_image_with_default_format', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_image_with_default_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_image_with_default_format', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_image_with_default_format', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_default_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_default_format', 'index', 'int'), 'password' => $utils->get_param_value('get_slides_image_with_default_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_default_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_default_format', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_image_with_default_format', 'folder', $params{ folder });
    $utils->initialize('get_slides_image_with_default_format', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_image_with_default_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_image_with_default_format', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_image_with_default_format', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_default_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_default_format', 'index', 'int'), 'password' => $utils->get_param_value('get_slides_image_with_default_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_default_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_default_format', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_image_with_default_format', 'storage', $params{ storage });
    $utils->initialize('get_slides_image_with_default_format', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_image_with_default_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_image_with_default_format', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_image_with_default_format', 'storage');
    }
}

#
# get_slides_image_with_format test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_format', 'index', 'int'), 'format' => $utils->get_param_value('get_slides_image_with_format', 'format', 'string'), 'password' => $utils->get_param_value('get_slides_image_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_format', 'storage', 'string'));
    $utils->initialize('get_slides_image_with_format', '');
    eval {
        my $result = $utils->{api}->get_slides_image_with_format(%params);
    };
    if ($@) {
        fail("get_slides_image_with_format raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_format', 'index', 'int'), 'format' => $utils->get_param_value('get_slides_image_with_format', 'format', 'string'), 'password' => $utils->get_param_value('get_slides_image_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_format', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_image_with_format', 'name', $params{ name });
    $utils->initialize('get_slides_image_with_format', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_image_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_image_with_format', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_image_with_format', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_format', 'index', 'int'), 'format' => $utils->get_param_value('get_slides_image_with_format', 'format', 'string'), 'password' => $utils->get_param_value('get_slides_image_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_format', 'storage', 'string'));
    $params{ index } = $utils->invalidize_param_value('get_slides_image_with_format', 'index', $params{ index });
    $utils->initialize('get_slides_image_with_format', 'index', $params{ index });

    eval {
        my $result = $utils->{api}->get_slides_image_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_image_with_format', 'index', $params{ index }, $@);
    } else {
        $utils->assert_no_error('get_slides_image_with_format', 'index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_format', 'index', 'int'), 'format' => $utils->get_param_value('get_slides_image_with_format', 'format', 'string'), 'password' => $utils->get_param_value('get_slides_image_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_format', 'storage', 'string'));
    $params{ format } = $utils->invalidize_param_value('get_slides_image_with_format', 'format', $params{ format });
    $utils->initialize('get_slides_image_with_format', 'format', $params{ format });

    eval {
        my $result = $utils->{api}->get_slides_image_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_image_with_format', 'format', $params{ format }, $@);
    } else {
        $utils->assert_no_error('get_slides_image_with_format', 'format');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_format', 'index', 'int'), 'format' => $utils->get_param_value('get_slides_image_with_format', 'format', 'string'), 'password' => $utils->get_param_value('get_slides_image_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_format', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_image_with_format', 'password', $params{ password });
    $utils->initialize('get_slides_image_with_format', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_image_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_image_with_format', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_image_with_format', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_format', 'index', 'int'), 'format' => $utils->get_param_value('get_slides_image_with_format', 'format', 'string'), 'password' => $utils->get_param_value('get_slides_image_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_format', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_image_with_format', 'folder', $params{ folder });
    $utils->initialize('get_slides_image_with_format', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_image_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_image_with_format', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_image_with_format', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_image_with_format', 'name', 'string'), 'index' => $utils->get_param_value('get_slides_image_with_format', 'index', 'int'), 'format' => $utils->get_param_value('get_slides_image_with_format', 'format', 'string'), 'password' => $utils->get_param_value('get_slides_image_with_format', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_image_with_format', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_image_with_format', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_image_with_format', 'storage', $params{ storage });
    $utils->initialize('get_slides_image_with_format', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_image_with_format(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_image_with_format', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_image_with_format', 'storage');
    }
}

#
# get_slides_images test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_images', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_images', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_images', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_images', 'storage', 'string'));
    $utils->initialize('get_slides_images', '');
    eval {
        my $result = $utils->{api}->get_slides_images(%params);
    };
    if ($@) {
        fail("get_slides_images raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_images', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_images', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_images', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_images', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_images', 'name', $params{ name });
    $utils->initialize('get_slides_images', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_images(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_images', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_images', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_images', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_images', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_images', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_images', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_images', 'password', $params{ password });
    $utils->initialize('get_slides_images', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_images(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_images', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_images', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_images', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_images', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_images', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_images', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_images', 'folder', $params{ folder });
    $utils->initialize('get_slides_images', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_images(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_images', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_images', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_images', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_images', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_images', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_images', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_images', 'storage', $params{ storage });
    $utils->initialize('get_slides_images', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_images(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_images', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_images', 'storage');
    }
}

#
# get_slides_placeholder test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholder', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholder', 'slide_index', 'int'), 'placeholder_index' => $utils->get_param_value('get_slides_placeholder', 'placeholder_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholder', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholder', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholder', 'storage', 'string'));
    $utils->initialize('get_slides_placeholder', '');
    eval {
        my $result = $utils->{api}->get_slides_placeholder(%params);
    };
    if ($@) {
        fail("get_slides_placeholder raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholder', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholder', 'slide_index', 'int'), 'placeholder_index' => $utils->get_param_value('get_slides_placeholder', 'placeholder_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholder', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholder', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholder', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_placeholder', 'name', $params{ name });
    $utils->initialize('get_slides_placeholder', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_placeholder(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_placeholder', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_placeholder', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholder', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholder', 'slide_index', 'int'), 'placeholder_index' => $utils->get_param_value('get_slides_placeholder', 'placeholder_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholder', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholder', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholder', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slides_placeholder', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slides_placeholder', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slides_placeholder(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_placeholder', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slides_placeholder', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholder', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholder', 'slide_index', 'int'), 'placeholder_index' => $utils->get_param_value('get_slides_placeholder', 'placeholder_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholder', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholder', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholder', 'storage', 'string'));
    $params{ placeholder_index } = $utils->invalidize_param_value('get_slides_placeholder', 'placeholder_index', $params{ placeholder_index });
    $utils->initialize('get_slides_placeholder', 'placeholder_index', $params{ placeholder_index });

    eval {
        my $result = $utils->{api}->get_slides_placeholder(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_placeholder', 'placeholder_index', $params{ placeholder_index }, $@);
    } else {
        $utils->assert_no_error('get_slides_placeholder', 'placeholder_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholder', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholder', 'slide_index', 'int'), 'placeholder_index' => $utils->get_param_value('get_slides_placeholder', 'placeholder_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholder', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholder', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholder', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_placeholder', 'password', $params{ password });
    $utils->initialize('get_slides_placeholder', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_placeholder(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_placeholder', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_placeholder', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholder', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholder', 'slide_index', 'int'), 'placeholder_index' => $utils->get_param_value('get_slides_placeholder', 'placeholder_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholder', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholder', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholder', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_placeholder', 'folder', $params{ folder });
    $utils->initialize('get_slides_placeholder', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_placeholder(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_placeholder', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_placeholder', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholder', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholder', 'slide_index', 'int'), 'placeholder_index' => $utils->get_param_value('get_slides_placeholder', 'placeholder_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholder', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholder', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholder', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_placeholder', 'storage', $params{ storage });
    $utils->initialize('get_slides_placeholder', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_placeholder(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_placeholder', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_placeholder', 'storage');
    }
}

#
# get_slides_placeholders test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholders', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholders', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholders', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholders', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholders', 'storage', 'string'));
    $utils->initialize('get_slides_placeholders', '');
    eval {
        my $result = $utils->{api}->get_slides_placeholders(%params);
    };
    if ($@) {
        fail("get_slides_placeholders raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholders', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholders', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholders', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholders', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholders', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_placeholders', 'name', $params{ name });
    $utils->initialize('get_slides_placeholders', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_placeholders(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_placeholders', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_placeholders', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholders', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholders', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholders', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholders', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholders', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slides_placeholders', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slides_placeholders', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slides_placeholders(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_placeholders', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slides_placeholders', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholders', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholders', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholders', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholders', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholders', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_placeholders', 'password', $params{ password });
    $utils->initialize('get_slides_placeholders', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_placeholders(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_placeholders', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_placeholders', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholders', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholders', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholders', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholders', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholders', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_placeholders', 'folder', $params{ folder });
    $utils->initialize('get_slides_placeholders', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_placeholders(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_placeholders', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_placeholders', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_placeholders', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_placeholders', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_placeholders', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_placeholders', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_placeholders', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_placeholders', 'storage', $params{ storage });
    $utils->initialize('get_slides_placeholders', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_placeholders(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_placeholders', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_placeholders', 'storage');
    }
}

#
# get_slides_presentation_text_items test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_presentation_text_items', 'name', 'string'), 'with_empty' => $utils->get_param_value('get_slides_presentation_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_presentation_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_presentation_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_presentation_text_items', 'storage', 'string'));
    $utils->initialize('get_slides_presentation_text_items', '');
    eval {
        my $result = $utils->{api}->get_slides_presentation_text_items(%params);
    };
    if ($@) {
        fail("get_slides_presentation_text_items raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_presentation_text_items', 'name', 'string'), 'with_empty' => $utils->get_param_value('get_slides_presentation_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_presentation_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_presentation_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_presentation_text_items', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_presentation_text_items', 'name', $params{ name });
    $utils->initialize('get_slides_presentation_text_items', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_presentation_text_items(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_presentation_text_items', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_presentation_text_items', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_presentation_text_items', 'name', 'string'), 'with_empty' => $utils->get_param_value('get_slides_presentation_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_presentation_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_presentation_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_presentation_text_items', 'storage', 'string'));
    $params{ with_empty } = $utils->invalidize_param_value('get_slides_presentation_text_items', 'with_empty', $params{ with_empty });
    $utils->initialize('get_slides_presentation_text_items', 'with_empty', $params{ with_empty });

    eval {
        my $result = $utils->{api}->get_slides_presentation_text_items(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_presentation_text_items', 'with_empty', $params{ with_empty }, $@);
    } else {
        $utils->assert_no_error('get_slides_presentation_text_items', 'with_empty');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_presentation_text_items', 'name', 'string'), 'with_empty' => $utils->get_param_value('get_slides_presentation_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_presentation_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_presentation_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_presentation_text_items', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_presentation_text_items', 'password', $params{ password });
    $utils->initialize('get_slides_presentation_text_items', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_presentation_text_items(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_presentation_text_items', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_presentation_text_items', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_presentation_text_items', 'name', 'string'), 'with_empty' => $utils->get_param_value('get_slides_presentation_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_presentation_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_presentation_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_presentation_text_items', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_presentation_text_items', 'folder', $params{ folder });
    $utils->initialize('get_slides_presentation_text_items', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_presentation_text_items(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_presentation_text_items', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_presentation_text_items', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_presentation_text_items', 'name', 'string'), 'with_empty' => $utils->get_param_value('get_slides_presentation_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_presentation_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_presentation_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_presentation_text_items', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_presentation_text_items', 'storage', $params{ storage });
    $utils->initialize('get_slides_presentation_text_items', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_presentation_text_items(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_presentation_text_items', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_presentation_text_items', 'storage');
    }
}

#
# get_slides_slide test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide', 'storage', 'string'));
    $utils->initialize('get_slides_slide', '');
    eval {
        my $result = $utils->{api}->get_slides_slide(%params);
    };
    if ($@) {
        fail("get_slides_slide raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_slide', 'name', $params{ name });
    $utils->initialize('get_slides_slide', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slides_slide', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slides_slide', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slides_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_slide', 'password', $params{ password });
    $utils->initialize('get_slides_slide', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_slide', 'folder', $params{ folder });
    $utils->initialize('get_slides_slide', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_slide', 'storage', $params{ storage });
    $utils->initialize('get_slides_slide', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_slide(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide', 'storage');
    }
}

#
# get_slides_slide_background test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_background', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_background', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_background', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_background', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_background', 'storage', 'string'));
    $utils->initialize('get_slides_slide_background', '');
    eval {
        my $result = $utils->{api}->get_slides_slide_background(%params);
    };
    if ($@) {
        fail("get_slides_slide_background raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_background', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_background', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_background', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_background', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_background', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_slide_background', 'name', $params{ name });
    $utils->initialize('get_slides_slide_background', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_slide_background(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_background', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_background', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_background', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_background', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_background', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_background', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_background', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slides_slide_background', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slides_slide_background', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slides_slide_background(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_background', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_background', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_background', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_background', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_background', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_background', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_background', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_slide_background', 'password', $params{ password });
    $utils->initialize('get_slides_slide_background', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_slide_background(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_background', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_background', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_background', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_background', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_background', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_background', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_background', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_slide_background', 'folder', $params{ folder });
    $utils->initialize('get_slides_slide_background', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_slide_background(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_background', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_background', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_background', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_background', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_background', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_background', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_background', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_slide_background', 'storage', $params{ storage });
    $utils->initialize('get_slides_slide_background', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_slide_background(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_background', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_background', 'storage');
    }
}

#
# get_slides_slide_comments test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_comments', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_comments', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_comments', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_comments', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_comments', 'storage', 'string'));
    $utils->initialize('get_slides_slide_comments', '');
    eval {
        my $result = $utils->{api}->get_slides_slide_comments(%params);
    };
    if ($@) {
        fail("get_slides_slide_comments raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_comments', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_comments', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_comments', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_comments', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_comments', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_slide_comments', 'name', $params{ name });
    $utils->initialize('get_slides_slide_comments', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_slide_comments(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_comments', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_comments', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_comments', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_comments', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_comments', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_comments', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_comments', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slides_slide_comments', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slides_slide_comments', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slides_slide_comments(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_comments', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_comments', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_comments', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_comments', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_comments', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_comments', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_comments', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_slide_comments', 'password', $params{ password });
    $utils->initialize('get_slides_slide_comments', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_slide_comments(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_comments', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_comments', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_comments', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_comments', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_comments', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_comments', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_comments', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_slide_comments', 'folder', $params{ folder });
    $utils->initialize('get_slides_slide_comments', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_slide_comments(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_comments', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_comments', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_comments', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_comments', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_comments', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_comments', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_comments', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_slide_comments', 'storage', $params{ storage });
    $utils->initialize('get_slides_slide_comments', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_slide_comments(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_comments', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_comments', 'storage');
    }
}

#
# get_slides_slide_images test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_images', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_images', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_images', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_images', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_images', 'storage', 'string'));
    $utils->initialize('get_slides_slide_images', '');
    eval {
        my $result = $utils->{api}->get_slides_slide_images(%params);
    };
    if ($@) {
        fail("get_slides_slide_images raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_images', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_images', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_images', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_images', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_images', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_slide_images', 'name', $params{ name });
    $utils->initialize('get_slides_slide_images', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_slide_images(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_images', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_images', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_images', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_images', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_images', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_images', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_images', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slides_slide_images', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slides_slide_images', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slides_slide_images(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_images', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_images', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_images', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_images', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_images', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_images', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_images', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_slide_images', 'password', $params{ password });
    $utils->initialize('get_slides_slide_images', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_slide_images(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_images', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_images', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_images', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_images', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_images', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_images', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_images', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_slide_images', 'folder', $params{ folder });
    $utils->initialize('get_slides_slide_images', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_slide_images(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_images', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_images', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_images', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_images', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_slide_images', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_images', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_images', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_slide_images', 'storage', $params{ storage });
    $utils->initialize('get_slides_slide_images', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_slide_images(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_images', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_images', 'storage');
    }
}

#
# get_slides_slide_text_items test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_text_items', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_text_items', 'slide_index', 'int'), 'with_empty' => $utils->get_param_value('get_slides_slide_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_slide_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_text_items', 'storage', 'string'));
    $utils->initialize('get_slides_slide_text_items', '');
    eval {
        my $result = $utils->{api}->get_slides_slide_text_items(%params);
    };
    if ($@) {
        fail("get_slides_slide_text_items raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_text_items', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_text_items', 'slide_index', 'int'), 'with_empty' => $utils->get_param_value('get_slides_slide_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_slide_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_text_items', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_slide_text_items', 'name', $params{ name });
    $utils->initialize('get_slides_slide_text_items', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_slide_text_items(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_text_items', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_text_items', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_text_items', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_text_items', 'slide_index', 'int'), 'with_empty' => $utils->get_param_value('get_slides_slide_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_slide_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_text_items', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slides_slide_text_items', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slides_slide_text_items', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slides_slide_text_items(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_text_items', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_text_items', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_text_items', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_text_items', 'slide_index', 'int'), 'with_empty' => $utils->get_param_value('get_slides_slide_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_slide_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_text_items', 'storage', 'string'));
    $params{ with_empty } = $utils->invalidize_param_value('get_slides_slide_text_items', 'with_empty', $params{ with_empty });
    $utils->initialize('get_slides_slide_text_items', 'with_empty', $params{ with_empty });

    eval {
        my $result = $utils->{api}->get_slides_slide_text_items(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_text_items', 'with_empty', $params{ with_empty }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_text_items', 'with_empty');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_text_items', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_text_items', 'slide_index', 'int'), 'with_empty' => $utils->get_param_value('get_slides_slide_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_slide_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_text_items', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_slide_text_items', 'password', $params{ password });
    $utils->initialize('get_slides_slide_text_items', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_slide_text_items(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_text_items', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_text_items', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_text_items', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_text_items', 'slide_index', 'int'), 'with_empty' => $utils->get_param_value('get_slides_slide_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_slide_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_text_items', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_slide_text_items', 'folder', $params{ folder });
    $utils->initialize('get_slides_slide_text_items', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_slide_text_items(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_text_items', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_text_items', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slide_text_items', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_slide_text_items', 'slide_index', 'int'), 'with_empty' => $utils->get_param_value('get_slides_slide_text_items', 'with_empty', 'boolean'), 'password' => $utils->get_param_value('get_slides_slide_text_items', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slide_text_items', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slide_text_items', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_slide_text_items', 'storage', $params{ storage });
    $utils->initialize('get_slides_slide_text_items', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_slide_text_items(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slide_text_items', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_slide_text_items', 'storage');
    }
}

#
# get_slides_slides_list test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slides_list', 'storage', 'string'));
    $utils->initialize('get_slides_slides_list', '');
    eval {
        my $result = $utils->{api}->get_slides_slides_list(%params);
    };
    if ($@) {
        fail("get_slides_slides_list raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slides_list', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_slides_list', 'name', $params{ name });
    $utils->initialize('get_slides_slides_list', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slides_list', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_slides_list', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slides_list', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_slides_list', 'password', $params{ password });
    $utils->initialize('get_slides_slides_list', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slides_list', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_slides_list', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slides_list', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_slides_list', 'folder', $params{ folder });
    $utils->initialize('get_slides_slides_list', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slides_list', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_slides_list', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_slides_list', 'name', 'string'), 'password' => $utils->get_param_value('get_slides_slides_list', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_slides_list', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_slides_list', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_slides_list', 'storage', $params{ storage });
    $utils->initialize('get_slides_slides_list', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_slides_list(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_slides_list', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_slides_list', 'storage');
    }
}

#
# get_slides_theme test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_theme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme', 'storage', 'string'));
    $utils->initialize('get_slides_theme', '');
    eval {
        my $result = $utils->{api}->get_slides_theme(%params);
    };
    if ($@) {
        fail("get_slides_theme raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_theme', 'name', $params{ name });
    $utils->initialize('get_slides_theme', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_theme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slides_theme', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slides_theme', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slides_theme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_theme', 'password', $params{ password });
    $utils->initialize('get_slides_theme', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_theme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_theme', 'folder', $params{ folder });
    $utils->initialize('get_slides_theme', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_theme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_theme', 'storage', $params{ storage });
    $utils->initialize('get_slides_theme', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_theme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme', 'storage');
    }
}

#
# get_slides_theme_color_scheme test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_color_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_color_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_color_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_color_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_color_scheme', 'storage', 'string'));
    $utils->initialize('get_slides_theme_color_scheme', '');
    eval {
        my $result = $utils->{api}->get_slides_theme_color_scheme(%params);
    };
    if ($@) {
        fail("get_slides_theme_color_scheme raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_color_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_color_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_color_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_color_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_color_scheme', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_theme_color_scheme', 'name', $params{ name });
    $utils->initialize('get_slides_theme_color_scheme', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_theme_color_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_color_scheme', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_color_scheme', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_color_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_color_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_color_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_color_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_color_scheme', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slides_theme_color_scheme', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slides_theme_color_scheme', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slides_theme_color_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_color_scheme', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_color_scheme', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_color_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_color_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_color_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_color_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_color_scheme', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_theme_color_scheme', 'password', $params{ password });
    $utils->initialize('get_slides_theme_color_scheme', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_theme_color_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_color_scheme', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_color_scheme', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_color_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_color_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_color_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_color_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_color_scheme', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_theme_color_scheme', 'folder', $params{ folder });
    $utils->initialize('get_slides_theme_color_scheme', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_theme_color_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_color_scheme', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_color_scheme', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_color_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_color_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_color_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_color_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_color_scheme', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_theme_color_scheme', 'storage', $params{ storage });
    $utils->initialize('get_slides_theme_color_scheme', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_theme_color_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_color_scheme', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_color_scheme', 'storage');
    }
}

#
# get_slides_theme_font_scheme test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_font_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_font_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_font_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_font_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_font_scheme', 'storage', 'string'));
    $utils->initialize('get_slides_theme_font_scheme', '');
    eval {
        my $result = $utils->{api}->get_slides_theme_font_scheme(%params);
    };
    if ($@) {
        fail("get_slides_theme_font_scheme raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_font_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_font_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_font_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_font_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_font_scheme', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_theme_font_scheme', 'name', $params{ name });
    $utils->initialize('get_slides_theme_font_scheme', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_theme_font_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_font_scheme', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_font_scheme', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_font_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_font_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_font_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_font_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_font_scheme', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slides_theme_font_scheme', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slides_theme_font_scheme', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slides_theme_font_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_font_scheme', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_font_scheme', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_font_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_font_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_font_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_font_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_font_scheme', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_theme_font_scheme', 'password', $params{ password });
    $utils->initialize('get_slides_theme_font_scheme', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_theme_font_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_font_scheme', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_font_scheme', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_font_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_font_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_font_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_font_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_font_scheme', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_theme_font_scheme', 'folder', $params{ folder });
    $utils->initialize('get_slides_theme_font_scheme', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_theme_font_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_font_scheme', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_font_scheme', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_font_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_font_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_font_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_font_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_font_scheme', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_theme_font_scheme', 'storage', $params{ storage });
    $utils->initialize('get_slides_theme_font_scheme', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_theme_font_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_font_scheme', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_font_scheme', 'storage');
    }
}

#
# get_slides_theme_format_scheme test
#
{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_format_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_format_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_format_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_format_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_format_scheme', 'storage', 'string'));
    $utils->initialize('get_slides_theme_format_scheme', '');
    eval {
        my $result = $utils->{api}->get_slides_theme_format_scheme(%params);
    };
    if ($@) {
        fail("get_slides_theme_format_scheme raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_format_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_format_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_format_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_format_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_format_scheme', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('get_slides_theme_format_scheme', 'name', $params{ name });
    $utils->initialize('get_slides_theme_format_scheme', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->get_slides_theme_format_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_format_scheme', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_format_scheme', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_format_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_format_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_format_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_format_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_format_scheme', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('get_slides_theme_format_scheme', 'slide_index', $params{ slide_index });
    $utils->initialize('get_slides_theme_format_scheme', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->get_slides_theme_format_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_format_scheme', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_format_scheme', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_format_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_format_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_format_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_format_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_format_scheme', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('get_slides_theme_format_scheme', 'password', $params{ password });
    $utils->initialize('get_slides_theme_format_scheme', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->get_slides_theme_format_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_format_scheme', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_format_scheme', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_format_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_format_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_format_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_format_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_format_scheme', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('get_slides_theme_format_scheme', 'folder', $params{ folder });
    $utils->initialize('get_slides_theme_format_scheme', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->get_slides_theme_format_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_format_scheme', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_format_scheme', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('get_slides_theme_format_scheme', 'name', 'string'), 'slide_index' => $utils->get_param_value('get_slides_theme_format_scheme', 'slide_index', 'int'), 'password' => $utils->get_param_value('get_slides_theme_format_scheme', 'password', 'string'), 'folder' => $utils->get_param_value('get_slides_theme_format_scheme', 'folder', 'string'), 'storage' => $utils->get_param_value('get_slides_theme_format_scheme', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('get_slides_theme_format_scheme', 'storage', $params{ storage });
    $utils->initialize('get_slides_theme_format_scheme', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->get_slides_theme_format_scheme(%params);
    };
    if ($@) {
        $utils->assert_error('get_slides_theme_format_scheme', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('get_slides_theme_format_scheme', 'storage');
    }
}

#
# move_file test
#
{
    my %params = ('src_path' => $utils->get_param_value('move_file', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('move_file', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('move_file', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('move_file', 'dest_storage_name', 'string'), 'version_id' => $utils->get_param_value('move_file', 'version_id', 'string'));
    $utils->initialize('move_file', '');
    eval {
        my $result = $utils->{api}->move_file(%params);
    };
    if ($@) {
        fail("move_file raised an exception: $@");
    }
    pass();
}

{
    my %params = ('src_path' => $utils->get_param_value('move_file', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('move_file', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('move_file', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('move_file', 'dest_storage_name', 'string'), 'version_id' => $utils->get_param_value('move_file', 'version_id', 'string'));
    $params{ src_path } = $utils->invalidize_param_value('move_file', 'src_path', $params{ src_path });
    $utils->initialize('move_file', 'src_path', $params{ src_path });

    eval {
        my $result = $utils->{api}->move_file(%params);
    };
    if ($@) {
        $utils->assert_error('move_file', 'src_path', $params{ src_path }, $@);
    } else {
        $utils->assert_no_error('move_file', 'src_path');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('move_file', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('move_file', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('move_file', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('move_file', 'dest_storage_name', 'string'), 'version_id' => $utils->get_param_value('move_file', 'version_id', 'string'));
    $params{ dest_path } = $utils->invalidize_param_value('move_file', 'dest_path', $params{ dest_path });
    $utils->initialize('move_file', 'dest_path', $params{ dest_path });

    eval {
        my $result = $utils->{api}->move_file(%params);
    };
    if ($@) {
        $utils->assert_error('move_file', 'dest_path', $params{ dest_path }, $@);
    } else {
        $utils->assert_no_error('move_file', 'dest_path');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('move_file', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('move_file', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('move_file', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('move_file', 'dest_storage_name', 'string'), 'version_id' => $utils->get_param_value('move_file', 'version_id', 'string'));
    $params{ src_storage_name } = $utils->invalidize_param_value('move_file', 'src_storage_name', $params{ src_storage_name });
    $utils->initialize('move_file', 'src_storage_name', $params{ src_storage_name });

    eval {
        my $result = $utils->{api}->move_file(%params);
    };
    if ($@) {
        $utils->assert_error('move_file', 'src_storage_name', $params{ src_storage_name }, $@);
    } else {
        $utils->assert_no_error('move_file', 'src_storage_name');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('move_file', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('move_file', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('move_file', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('move_file', 'dest_storage_name', 'string'), 'version_id' => $utils->get_param_value('move_file', 'version_id', 'string'));
    $params{ dest_storage_name } = $utils->invalidize_param_value('move_file', 'dest_storage_name', $params{ dest_storage_name });
    $utils->initialize('move_file', 'dest_storage_name', $params{ dest_storage_name });

    eval {
        my $result = $utils->{api}->move_file(%params);
    };
    if ($@) {
        $utils->assert_error('move_file', 'dest_storage_name', $params{ dest_storage_name }, $@);
    } else {
        $utils->assert_no_error('move_file', 'dest_storage_name');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('move_file', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('move_file', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('move_file', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('move_file', 'dest_storage_name', 'string'), 'version_id' => $utils->get_param_value('move_file', 'version_id', 'string'));
    $params{ version_id } = $utils->invalidize_param_value('move_file', 'version_id', $params{ version_id });
    $utils->initialize('move_file', 'version_id', $params{ version_id });

    eval {
        my $result = $utils->{api}->move_file(%params);
    };
    if ($@) {
        $utils->assert_error('move_file', 'version_id', $params{ version_id }, $@);
    } else {
        $utils->assert_no_error('move_file', 'version_id');
    }
}

#
# move_folder test
#
{
    my %params = ('src_path' => $utils->get_param_value('move_folder', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('move_folder', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('move_folder', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('move_folder', 'dest_storage_name', 'string'));
    $utils->initialize('move_folder', '');
    eval {
        my $result = $utils->{api}->move_folder(%params);
    };
    if ($@) {
        fail("move_folder raised an exception: $@");
    }
    pass();
}

{
    my %params = ('src_path' => $utils->get_param_value('move_folder', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('move_folder', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('move_folder', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('move_folder', 'dest_storage_name', 'string'));
    $params{ src_path } = $utils->invalidize_param_value('move_folder', 'src_path', $params{ src_path });
    $utils->initialize('move_folder', 'src_path', $params{ src_path });

    eval {
        my $result = $utils->{api}->move_folder(%params);
    };
    if ($@) {
        $utils->assert_error('move_folder', 'src_path', $params{ src_path }, $@);
    } else {
        $utils->assert_no_error('move_folder', 'src_path');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('move_folder', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('move_folder', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('move_folder', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('move_folder', 'dest_storage_name', 'string'));
    $params{ dest_path } = $utils->invalidize_param_value('move_folder', 'dest_path', $params{ dest_path });
    $utils->initialize('move_folder', 'dest_path', $params{ dest_path });

    eval {
        my $result = $utils->{api}->move_folder(%params);
    };
    if ($@) {
        $utils->assert_error('move_folder', 'dest_path', $params{ dest_path }, $@);
    } else {
        $utils->assert_no_error('move_folder', 'dest_path');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('move_folder', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('move_folder', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('move_folder', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('move_folder', 'dest_storage_name', 'string'));
    $params{ src_storage_name } = $utils->invalidize_param_value('move_folder', 'src_storage_name', $params{ src_storage_name });
    $utils->initialize('move_folder', 'src_storage_name', $params{ src_storage_name });

    eval {
        my $result = $utils->{api}->move_folder(%params);
    };
    if ($@) {
        $utils->assert_error('move_folder', 'src_storage_name', $params{ src_storage_name }, $@);
    } else {
        $utils->assert_no_error('move_folder', 'src_storage_name');
    }
}

{
    my %params = ('src_path' => $utils->get_param_value('move_folder', 'src_path', 'string'), 'dest_path' => $utils->get_param_value('move_folder', 'dest_path', 'string'), 'src_storage_name' => $utils->get_param_value('move_folder', 'src_storage_name', 'string'), 'dest_storage_name' => $utils->get_param_value('move_folder', 'dest_storage_name', 'string'));
    $params{ dest_storage_name } = $utils->invalidize_param_value('move_folder', 'dest_storage_name', $params{ dest_storage_name });
    $utils->initialize('move_folder', 'dest_storage_name', $params{ dest_storage_name });

    eval {
        my $result = $utils->{api}->move_folder(%params);
    };
    if ($@) {
        $utils->assert_error('move_folder', 'dest_storage_name', $params{ dest_storage_name }, $@);
    } else {
        $utils->assert_no_error('move_folder', 'dest_storage_name');
    }
}

#
# object_exists test
#
{
    my %params = ('path' => $utils->get_param_value('object_exists', 'path', 'string'), 'storage_name' => $utils->get_param_value('object_exists', 'storage_name', 'string'), 'version_id' => $utils->get_param_value('object_exists', 'version_id', 'string'));
    $utils->initialize('object_exists', '');
    eval {
        my $result = $utils->{api}->object_exists(%params);
    };
    if ($@) {
        fail("object_exists raised an exception: $@");
    }
    pass();
}

{
    my %params = ('path' => $utils->get_param_value('object_exists', 'path', 'string'), 'storage_name' => $utils->get_param_value('object_exists', 'storage_name', 'string'), 'version_id' => $utils->get_param_value('object_exists', 'version_id', 'string'));
    $params{ path } = $utils->invalidize_param_value('object_exists', 'path', $params{ path });
    $utils->initialize('object_exists', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->object_exists(%params);
    };
    if ($@) {
        $utils->assert_error('object_exists', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('object_exists', 'path');
    }
}

{
    my %params = ('path' => $utils->get_param_value('object_exists', 'path', 'string'), 'storage_name' => $utils->get_param_value('object_exists', 'storage_name', 'string'), 'version_id' => $utils->get_param_value('object_exists', 'version_id', 'string'));
    $params{ storage_name } = $utils->invalidize_param_value('object_exists', 'storage_name', $params{ storage_name });
    $utils->initialize('object_exists', 'storage_name', $params{ storage_name });

    eval {
        my $result = $utils->{api}->object_exists(%params);
    };
    if ($@) {
        $utils->assert_error('object_exists', 'storage_name', $params{ storage_name }, $@);
    } else {
        $utils->assert_no_error('object_exists', 'storage_name');
    }
}

{
    my %params = ('path' => $utils->get_param_value('object_exists', 'path', 'string'), 'storage_name' => $utils->get_param_value('object_exists', 'storage_name', 'string'), 'version_id' => $utils->get_param_value('object_exists', 'version_id', 'string'));
    $params{ version_id } = $utils->invalidize_param_value('object_exists', 'version_id', $params{ version_id });
    $utils->initialize('object_exists', 'version_id', $params{ version_id });

    eval {
        my $result = $utils->{api}->object_exists(%params);
    };
    if ($@) {
        $utils->assert_error('object_exists', 'version_id', $params{ version_id }, $@);
    } else {
        $utils->assert_no_error('object_exists', 'version_id');
    }
}

#
# post_add_new_paragraph test
#
{
    my %params = ('name' => $utils->get_param_value('post_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_paragraph', 'position', 'int'));
    $utils->initialize('post_add_new_paragraph', '');
    eval {
        my $result = $utils->{api}->post_add_new_paragraph(%params);
    };
    if ($@) {
        fail("post_add_new_paragraph raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_paragraph', 'position', 'int'));
    $params{ name } = $utils->invalidize_param_value('post_add_new_paragraph', 'name', $params{ name });
    $utils->initialize('post_add_new_paragraph', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_paragraph', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_add_new_paragraph', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_paragraph', 'position', 'int'));
    $params{ slide_index } = $utils->invalidize_param_value('post_add_new_paragraph', 'slide_index', $params{ slide_index });
    $utils->initialize('post_add_new_paragraph', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_paragraph', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_add_new_paragraph', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_paragraph', 'position', 'int'));
    $params{ path } = $utils->invalidize_param_value('post_add_new_paragraph', 'path', $params{ path });
    $utils->initialize('post_add_new_paragraph', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->post_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_paragraph', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('post_add_new_paragraph', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_paragraph', 'position', 'int'));
    $params{ shape_index } = $utils->invalidize_param_value('post_add_new_paragraph', 'shape_index', $params{ shape_index });
    $utils->initialize('post_add_new_paragraph', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->post_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_paragraph', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('post_add_new_paragraph', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_paragraph', 'position', 'int'));
    $params{ dto } = $utils->invalidize_param_value('post_add_new_paragraph', 'dto', $params{ dto });
    $utils->initialize('post_add_new_paragraph', 'dto', $params{ dto });

    eval {
        my $result = $utils->{api}->post_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_paragraph', 'dto', $params{ dto }, $@);
    } else {
        $utils->assert_no_error('post_add_new_paragraph', 'dto');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_paragraph', 'position', 'int'));
    $params{ password } = $utils->invalidize_param_value('post_add_new_paragraph', 'password', $params{ password });
    $utils->initialize('post_add_new_paragraph', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_paragraph', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_add_new_paragraph', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_paragraph', 'position', 'int'));
    $params{ folder } = $utils->invalidize_param_value('post_add_new_paragraph', 'folder', $params{ folder });
    $utils->initialize('post_add_new_paragraph', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_paragraph', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_add_new_paragraph', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_paragraph', 'position', 'int'));
    $params{ storage } = $utils->invalidize_param_value('post_add_new_paragraph', 'storage', $params{ storage });
    $utils->initialize('post_add_new_paragraph', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_paragraph', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_add_new_paragraph', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_paragraph', 'position', 'int'));
    $params{ position } = $utils->invalidize_param_value('post_add_new_paragraph', 'position', $params{ position });
    $utils->initialize('post_add_new_paragraph', 'position', $params{ position });

    eval {
        my $result = $utils->{api}->post_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_paragraph', 'position', $params{ position }, $@);
    } else {
        $utils->assert_no_error('post_add_new_paragraph', 'position');
    }
}

#
# post_add_new_portion test
#
{
    my %params = ('name' => $utils->get_param_value('post_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_portion', 'position', 'int'));
    $utils->initialize('post_add_new_portion', '');
    eval {
        my $result = $utils->{api}->post_add_new_portion(%params);
    };
    if ($@) {
        fail("post_add_new_portion raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_portion', 'position', 'int'));
    $params{ name } = $utils->invalidize_param_value('post_add_new_portion', 'name', $params{ name });
    $utils->initialize('post_add_new_portion', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_portion', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_add_new_portion', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_portion', 'position', 'int'));
    $params{ slide_index } = $utils->invalidize_param_value('post_add_new_portion', 'slide_index', $params{ slide_index });
    $utils->initialize('post_add_new_portion', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_portion', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_add_new_portion', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_portion', 'position', 'int'));
    $params{ path } = $utils->invalidize_param_value('post_add_new_portion', 'path', $params{ path });
    $utils->initialize('post_add_new_portion', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->post_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_portion', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('post_add_new_portion', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_portion', 'position', 'int'));
    $params{ shape_index } = $utils->invalidize_param_value('post_add_new_portion', 'shape_index', $params{ shape_index });
    $utils->initialize('post_add_new_portion', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->post_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_portion', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('post_add_new_portion', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_portion', 'position', 'int'));
    $params{ paragraph_index } = $utils->invalidize_param_value('post_add_new_portion', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('post_add_new_portion', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->post_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_portion', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('post_add_new_portion', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_portion', 'position', 'int'));
    $params{ dto } = $utils->invalidize_param_value('post_add_new_portion', 'dto', $params{ dto });
    $utils->initialize('post_add_new_portion', 'dto', $params{ dto });

    eval {
        my $result = $utils->{api}->post_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_portion', 'dto', $params{ dto }, $@);
    } else {
        $utils->assert_no_error('post_add_new_portion', 'dto');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_portion', 'position', 'int'));
    $params{ password } = $utils->invalidize_param_value('post_add_new_portion', 'password', $params{ password });
    $utils->initialize('post_add_new_portion', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_portion', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_add_new_portion', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_portion', 'position', 'int'));
    $params{ folder } = $utils->invalidize_param_value('post_add_new_portion', 'folder', $params{ folder });
    $utils->initialize('post_add_new_portion', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_portion', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_add_new_portion', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_portion', 'position', 'int'));
    $params{ storage } = $utils->invalidize_param_value('post_add_new_portion', 'storage', $params{ storage });
    $utils->initialize('post_add_new_portion', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_portion', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_add_new_portion', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_add_new_portion', 'position', 'int'));
    $params{ position } = $utils->invalidize_param_value('post_add_new_portion', 'position', $params{ position });
    $utils->initialize('post_add_new_portion', 'position', $params{ position });

    eval {
        my $result = $utils->{api}->post_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_portion', 'position', $params{ position }, $@);
    } else {
        $utils->assert_no_error('post_add_new_portion', 'position');
    }
}

#
# post_add_new_shape test
#
{
    my %params = ('name' => $utils->get_param_value('post_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_add_new_shape', 'position', 'int'));
    $utils->initialize('post_add_new_shape', '');
    eval {
        my $result = $utils->{api}->post_add_new_shape(%params);
    };
    if ($@) {
        fail("post_add_new_shape raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_add_new_shape', 'position', 'int'));
    $params{ name } = $utils->invalidize_param_value('post_add_new_shape', 'name', $params{ name });
    $utils->initialize('post_add_new_shape', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_shape', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_add_new_shape', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_add_new_shape', 'position', 'int'));
    $params{ slide_index } = $utils->invalidize_param_value('post_add_new_shape', 'slide_index', $params{ slide_index });
    $utils->initialize('post_add_new_shape', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_shape', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_add_new_shape', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_add_new_shape', 'position', 'int'));
    $params{ path } = $utils->invalidize_param_value('post_add_new_shape', 'path', $params{ path });
    $utils->initialize('post_add_new_shape', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->post_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_shape', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('post_add_new_shape', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_add_new_shape', 'position', 'int'));
    $params{ dto } = $utils->invalidize_param_value('post_add_new_shape', 'dto', $params{ dto });
    $utils->initialize('post_add_new_shape', 'dto', $params{ dto });

    eval {
        my $result = $utils->{api}->post_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_shape', 'dto', $params{ dto }, $@);
    } else {
        $utils->assert_no_error('post_add_new_shape', 'dto');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_add_new_shape', 'position', 'int'));
    $params{ password } = $utils->invalidize_param_value('post_add_new_shape', 'password', $params{ password });
    $utils->initialize('post_add_new_shape', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_shape', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_add_new_shape', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_add_new_shape', 'position', 'int'));
    $params{ folder } = $utils->invalidize_param_value('post_add_new_shape', 'folder', $params{ folder });
    $utils->initialize('post_add_new_shape', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_shape', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_add_new_shape', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_add_new_shape', 'position', 'int'));
    $params{ storage } = $utils->invalidize_param_value('post_add_new_shape', 'storage', $params{ storage });
    $utils->initialize('post_add_new_shape', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_shape', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_add_new_shape', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_add_new_shape', 'position', 'int'));
    $params{ shape_to_clone } = $utils->invalidize_param_value('post_add_new_shape', 'shape_to_clone', $params{ shape_to_clone });
    $utils->initialize('post_add_new_shape', 'shape_to_clone', $params{ shape_to_clone });

    eval {
        my $result = $utils->{api}->post_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_shape', 'shape_to_clone', $params{ shape_to_clone }, $@);
    } else {
        $utils->assert_no_error('post_add_new_shape', 'shape_to_clone');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_add_new_shape', 'position', 'int'));
    $params{ position } = $utils->invalidize_param_value('post_add_new_shape', 'position', $params{ position });
    $utils->initialize('post_add_new_shape', 'position', $params{ position });

    eval {
        my $result = $utils->{api}->post_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_new_shape', 'position', $params{ position }, $@);
    } else {
        $utils->assert_no_error('post_add_new_shape', 'position');
    }
}

#
# post_add_notes_slide test
#
{
    my %params = ('name' => $utils->get_param_value('post_add_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_notes_slide', 'slide_index', 'int'), 'dto' => $utils->get_param_value('post_add_notes_slide', 'dto', 'NotesSlide'), 'password' => $utils->get_param_value('post_add_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_notes_slide', 'storage', 'string'));
    $utils->initialize('post_add_notes_slide', '');
    eval {
        my $result = $utils->{api}->post_add_notes_slide(%params);
    };
    if ($@) {
        fail("post_add_notes_slide raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_add_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_notes_slide', 'slide_index', 'int'), 'dto' => $utils->get_param_value('post_add_notes_slide', 'dto', 'NotesSlide'), 'password' => $utils->get_param_value('post_add_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_notes_slide', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_add_notes_slide', 'name', $params{ name });
    $utils->initialize('post_add_notes_slide', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_add_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_notes_slide', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_add_notes_slide', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_notes_slide', 'slide_index', 'int'), 'dto' => $utils->get_param_value('post_add_notes_slide', 'dto', 'NotesSlide'), 'password' => $utils->get_param_value('post_add_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_notes_slide', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('post_add_notes_slide', 'slide_index', $params{ slide_index });
    $utils->initialize('post_add_notes_slide', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_add_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_notes_slide', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_add_notes_slide', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_notes_slide', 'slide_index', 'int'), 'dto' => $utils->get_param_value('post_add_notes_slide', 'dto', 'NotesSlide'), 'password' => $utils->get_param_value('post_add_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_notes_slide', 'storage', 'string'));
    $params{ dto } = $utils->invalidize_param_value('post_add_notes_slide', 'dto', $params{ dto });
    $utils->initialize('post_add_notes_slide', 'dto', $params{ dto });

    eval {
        my $result = $utils->{api}->post_add_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_notes_slide', 'dto', $params{ dto }, $@);
    } else {
        $utils->assert_no_error('post_add_notes_slide', 'dto');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_notes_slide', 'slide_index', 'int'), 'dto' => $utils->get_param_value('post_add_notes_slide', 'dto', 'NotesSlide'), 'password' => $utils->get_param_value('post_add_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_notes_slide', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_add_notes_slide', 'password', $params{ password });
    $utils->initialize('post_add_notes_slide', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_add_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_notes_slide', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_add_notes_slide', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_notes_slide', 'slide_index', 'int'), 'dto' => $utils->get_param_value('post_add_notes_slide', 'dto', 'NotesSlide'), 'password' => $utils->get_param_value('post_add_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_notes_slide', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_add_notes_slide', 'folder', $params{ folder });
    $utils->initialize('post_add_notes_slide', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_add_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_notes_slide', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_add_notes_slide', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_add_notes_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_add_notes_slide', 'slide_index', 'int'), 'dto' => $utils->get_param_value('post_add_notes_slide', 'dto', 'NotesSlide'), 'password' => $utils->get_param_value('post_add_notes_slide', 'password', 'string'), 'folder' => $utils->get_param_value('post_add_notes_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('post_add_notes_slide', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_add_notes_slide', 'storage', $params{ storage });
    $utils->initialize('post_add_notes_slide', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_add_notes_slide(%params);
    };
    if ($@) {
        $utils->assert_error('post_add_notes_slide', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_add_notes_slide', 'storage');
    }
}

#
# post_copy_layout_slide_from_source_presentation test
#
{
    my %params = ('name' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_storage', 'string'), 'password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'storage', 'string'));
    $utils->initialize('post_copy_layout_slide_from_source_presentation', '');
    eval {
        my $result = $utils->{api}->post_copy_layout_slide_from_source_presentation(%params);
    };
    if ($@) {
        fail("post_copy_layout_slide_from_source_presentation raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_storage', 'string'), 'password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_copy_layout_slide_from_source_presentation', 'name', $params{ name });
    $utils->initialize('post_copy_layout_slide_from_source_presentation', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_copy_layout_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_layout_slide_from_source_presentation', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_copy_layout_slide_from_source_presentation', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_storage', 'string'), 'password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'storage', 'string'));
    $params{ clone_from } = $utils->invalidize_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from', $params{ clone_from });
    $utils->initialize('post_copy_layout_slide_from_source_presentation', 'clone_from', $params{ clone_from });

    eval {
        my $result = $utils->{api}->post_copy_layout_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_layout_slide_from_source_presentation', 'clone_from', $params{ clone_from }, $@);
    } else {
        $utils->assert_no_error('post_copy_layout_slide_from_source_presentation', 'clone_from');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_storage', 'string'), 'password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'storage', 'string'));
    $params{ clone_from_position } = $utils->invalidize_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_position', $params{ clone_from_position });
    $utils->initialize('post_copy_layout_slide_from_source_presentation', 'clone_from_position', $params{ clone_from_position });

    eval {
        my $result = $utils->{api}->post_copy_layout_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_layout_slide_from_source_presentation', 'clone_from_position', $params{ clone_from_position }, $@);
    } else {
        $utils->assert_no_error('post_copy_layout_slide_from_source_presentation', 'clone_from_position');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_storage', 'string'), 'password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'storage', 'string'));
    $params{ clone_from_password } = $utils->invalidize_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_password', $params{ clone_from_password });
    $utils->initialize('post_copy_layout_slide_from_source_presentation', 'clone_from_password', $params{ clone_from_password });

    eval {
        my $result = $utils->{api}->post_copy_layout_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_layout_slide_from_source_presentation', 'clone_from_password', $params{ clone_from_password }, $@);
    } else {
        $utils->assert_no_error('post_copy_layout_slide_from_source_presentation', 'clone_from_password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_storage', 'string'), 'password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'storage', 'string'));
    $params{ clone_from_storage } = $utils->invalidize_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_storage', $params{ clone_from_storage });
    $utils->initialize('post_copy_layout_slide_from_source_presentation', 'clone_from_storage', $params{ clone_from_storage });

    eval {
        my $result = $utils->{api}->post_copy_layout_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_layout_slide_from_source_presentation', 'clone_from_storage', $params{ clone_from_storage }, $@);
    } else {
        $utils->assert_no_error('post_copy_layout_slide_from_source_presentation', 'clone_from_storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_storage', 'string'), 'password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_copy_layout_slide_from_source_presentation', 'password', $params{ password });
    $utils->initialize('post_copy_layout_slide_from_source_presentation', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_copy_layout_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_layout_slide_from_source_presentation', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_copy_layout_slide_from_source_presentation', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_storage', 'string'), 'password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_copy_layout_slide_from_source_presentation', 'folder', $params{ folder });
    $utils->initialize('post_copy_layout_slide_from_source_presentation', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_copy_layout_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_layout_slide_from_source_presentation', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_copy_layout_slide_from_source_presentation', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'clone_from_storage', 'string'), 'password' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_layout_slide_from_source_presentation', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_copy_layout_slide_from_source_presentation', 'storage', $params{ storage });
    $utils->initialize('post_copy_layout_slide_from_source_presentation', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_copy_layout_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_layout_slide_from_source_presentation', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_copy_layout_slide_from_source_presentation', 'storage');
    }
}

#
# post_copy_master_slide_from_source_presentation test
#
{
    my %params = ('name' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_storage', 'string'), 'apply_to_all' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'apply_to_all', 'boolean'), 'password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'storage', 'string'));
    $utils->initialize('post_copy_master_slide_from_source_presentation', '');
    eval {
        my $result = $utils->{api}->post_copy_master_slide_from_source_presentation(%params);
    };
    if ($@) {
        fail("post_copy_master_slide_from_source_presentation raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_storage', 'string'), 'apply_to_all' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'apply_to_all', 'boolean'), 'password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_copy_master_slide_from_source_presentation', 'name', $params{ name });
    $utils->initialize('post_copy_master_slide_from_source_presentation', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_copy_master_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_master_slide_from_source_presentation', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_copy_master_slide_from_source_presentation', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_storage', 'string'), 'apply_to_all' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'apply_to_all', 'boolean'), 'password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'storage', 'string'));
    $params{ clone_from } = $utils->invalidize_param_value('post_copy_master_slide_from_source_presentation', 'clone_from', $params{ clone_from });
    $utils->initialize('post_copy_master_slide_from_source_presentation', 'clone_from', $params{ clone_from });

    eval {
        my $result = $utils->{api}->post_copy_master_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_master_slide_from_source_presentation', 'clone_from', $params{ clone_from }, $@);
    } else {
        $utils->assert_no_error('post_copy_master_slide_from_source_presentation', 'clone_from');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_storage', 'string'), 'apply_to_all' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'apply_to_all', 'boolean'), 'password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'storage', 'string'));
    $params{ clone_from_position } = $utils->invalidize_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_position', $params{ clone_from_position });
    $utils->initialize('post_copy_master_slide_from_source_presentation', 'clone_from_position', $params{ clone_from_position });

    eval {
        my $result = $utils->{api}->post_copy_master_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_master_slide_from_source_presentation', 'clone_from_position', $params{ clone_from_position }, $@);
    } else {
        $utils->assert_no_error('post_copy_master_slide_from_source_presentation', 'clone_from_position');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_storage', 'string'), 'apply_to_all' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'apply_to_all', 'boolean'), 'password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'storage', 'string'));
    $params{ clone_from_password } = $utils->invalidize_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_password', $params{ clone_from_password });
    $utils->initialize('post_copy_master_slide_from_source_presentation', 'clone_from_password', $params{ clone_from_password });

    eval {
        my $result = $utils->{api}->post_copy_master_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_master_slide_from_source_presentation', 'clone_from_password', $params{ clone_from_password }, $@);
    } else {
        $utils->assert_no_error('post_copy_master_slide_from_source_presentation', 'clone_from_password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_storage', 'string'), 'apply_to_all' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'apply_to_all', 'boolean'), 'password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'storage', 'string'));
    $params{ clone_from_storage } = $utils->invalidize_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_storage', $params{ clone_from_storage });
    $utils->initialize('post_copy_master_slide_from_source_presentation', 'clone_from_storage', $params{ clone_from_storage });

    eval {
        my $result = $utils->{api}->post_copy_master_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_master_slide_from_source_presentation', 'clone_from_storage', $params{ clone_from_storage }, $@);
    } else {
        $utils->assert_no_error('post_copy_master_slide_from_source_presentation', 'clone_from_storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_storage', 'string'), 'apply_to_all' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'apply_to_all', 'boolean'), 'password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'storage', 'string'));
    $params{ apply_to_all } = $utils->invalidize_param_value('post_copy_master_slide_from_source_presentation', 'apply_to_all', $params{ apply_to_all });
    $utils->initialize('post_copy_master_slide_from_source_presentation', 'apply_to_all', $params{ apply_to_all });

    eval {
        my $result = $utils->{api}->post_copy_master_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_master_slide_from_source_presentation', 'apply_to_all', $params{ apply_to_all }, $@);
    } else {
        $utils->assert_no_error('post_copy_master_slide_from_source_presentation', 'apply_to_all');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_storage', 'string'), 'apply_to_all' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'apply_to_all', 'boolean'), 'password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_copy_master_slide_from_source_presentation', 'password', $params{ password });
    $utils->initialize('post_copy_master_slide_from_source_presentation', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_copy_master_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_master_slide_from_source_presentation', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_copy_master_slide_from_source_presentation', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_storage', 'string'), 'apply_to_all' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'apply_to_all', 'boolean'), 'password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_copy_master_slide_from_source_presentation', 'folder', $params{ folder });
    $utils->initialize('post_copy_master_slide_from_source_presentation', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_copy_master_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_master_slide_from_source_presentation', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_copy_master_slide_from_source_presentation', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'name', 'string'), 'clone_from' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from', 'string'), 'clone_from_position' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_position', 'int'), 'clone_from_password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_password', 'string'), 'clone_from_storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'clone_from_storage', 'string'), 'apply_to_all' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'apply_to_all', 'boolean'), 'password' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'password', 'string'), 'folder' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'folder', 'string'), 'storage' => $utils->get_param_value('post_copy_master_slide_from_source_presentation', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_copy_master_slide_from_source_presentation', 'storage', $params{ storage });
    $utils->initialize('post_copy_master_slide_from_source_presentation', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_copy_master_slide_from_source_presentation(%params);
    };
    if ($@) {
        $utils->assert_error('post_copy_master_slide_from_source_presentation', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_copy_master_slide_from_source_presentation', 'storage');
    }
}

#
# post_notes_slide_add_new_paragraph test
#
{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'position', 'int'));
    $utils->initialize('post_notes_slide_add_new_paragraph', '');
    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_paragraph(%params);
    };
    if ($@) {
        fail("post_notes_slide_add_new_paragraph raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'position', 'int'));
    $params{ name } = $utils->invalidize_param_value('post_notes_slide_add_new_paragraph', 'name', $params{ name });
    $utils->initialize('post_notes_slide_add_new_paragraph', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_paragraph', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_paragraph', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'position', 'int'));
    $params{ slide_index } = $utils->invalidize_param_value('post_notes_slide_add_new_paragraph', 'slide_index', $params{ slide_index });
    $utils->initialize('post_notes_slide_add_new_paragraph', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_paragraph', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_paragraph', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'position', 'int'));
    $params{ path } = $utils->invalidize_param_value('post_notes_slide_add_new_paragraph', 'path', $params{ path });
    $utils->initialize('post_notes_slide_add_new_paragraph', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_paragraph', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_paragraph', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'position', 'int'));
    $params{ shape_index } = $utils->invalidize_param_value('post_notes_slide_add_new_paragraph', 'shape_index', $params{ shape_index });
    $utils->initialize('post_notes_slide_add_new_paragraph', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_paragraph', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_paragraph', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'position', 'int'));
    $params{ dto } = $utils->invalidize_param_value('post_notes_slide_add_new_paragraph', 'dto', $params{ dto });
    $utils->initialize('post_notes_slide_add_new_paragraph', 'dto', $params{ dto });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_paragraph', 'dto', $params{ dto }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_paragraph', 'dto');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'position', 'int'));
    $params{ password } = $utils->invalidize_param_value('post_notes_slide_add_new_paragraph', 'password', $params{ password });
    $utils->initialize('post_notes_slide_add_new_paragraph', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_paragraph', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_paragraph', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'position', 'int'));
    $params{ folder } = $utils->invalidize_param_value('post_notes_slide_add_new_paragraph', 'folder', $params{ folder });
    $utils->initialize('post_notes_slide_add_new_paragraph', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_paragraph', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_paragraph', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'position', 'int'));
    $params{ storage } = $utils->invalidize_param_value('post_notes_slide_add_new_paragraph', 'storage', $params{ storage });
    $utils->initialize('post_notes_slide_add_new_paragraph', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_paragraph', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_paragraph', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'shape_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_paragraph', 'position', 'int'));
    $params{ position } = $utils->invalidize_param_value('post_notes_slide_add_new_paragraph', 'position', $params{ position });
    $utils->initialize('post_notes_slide_add_new_paragraph', 'position', $params{ position });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_paragraph(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_paragraph', 'position', $params{ position }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_paragraph', 'position');
    }
}

#
# post_notes_slide_add_new_portion test
#
{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_notes_slide_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_portion', 'position', 'int'));
    $utils->initialize('post_notes_slide_add_new_portion', '');
    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_portion(%params);
    };
    if ($@) {
        fail("post_notes_slide_add_new_portion raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_notes_slide_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_portion', 'position', 'int'));
    $params{ name } = $utils->invalidize_param_value('post_notes_slide_add_new_portion', 'name', $params{ name });
    $utils->initialize('post_notes_slide_add_new_portion', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_portion', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_portion', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_notes_slide_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_portion', 'position', 'int'));
    $params{ slide_index } = $utils->invalidize_param_value('post_notes_slide_add_new_portion', 'slide_index', $params{ slide_index });
    $utils->initialize('post_notes_slide_add_new_portion', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_portion', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_portion', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_notes_slide_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_portion', 'position', 'int'));
    $params{ path } = $utils->invalidize_param_value('post_notes_slide_add_new_portion', 'path', $params{ path });
    $utils->initialize('post_notes_slide_add_new_portion', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_portion', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_portion', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_notes_slide_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_portion', 'position', 'int'));
    $params{ shape_index } = $utils->invalidize_param_value('post_notes_slide_add_new_portion', 'shape_index', $params{ shape_index });
    $utils->initialize('post_notes_slide_add_new_portion', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_portion', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_portion', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_notes_slide_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_portion', 'position', 'int'));
    $params{ paragraph_index } = $utils->invalidize_param_value('post_notes_slide_add_new_portion', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('post_notes_slide_add_new_portion', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_portion', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_portion', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_notes_slide_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_portion', 'position', 'int'));
    $params{ dto } = $utils->invalidize_param_value('post_notes_slide_add_new_portion', 'dto', $params{ dto });
    $utils->initialize('post_notes_slide_add_new_portion', 'dto', $params{ dto });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_portion', 'dto', $params{ dto }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_portion', 'dto');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_notes_slide_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_portion', 'position', 'int'));
    $params{ password } = $utils->invalidize_param_value('post_notes_slide_add_new_portion', 'password', $params{ password });
    $utils->initialize('post_notes_slide_add_new_portion', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_portion', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_portion', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_notes_slide_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_portion', 'position', 'int'));
    $params{ folder } = $utils->invalidize_param_value('post_notes_slide_add_new_portion', 'folder', $params{ folder });
    $utils->initialize('post_notes_slide_add_new_portion', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_portion', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_portion', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_notes_slide_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_portion', 'position', 'int'));
    $params{ storage } = $utils->invalidize_param_value('post_notes_slide_add_new_portion', 'storage', $params{ storage });
    $utils->initialize('post_notes_slide_add_new_portion', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_portion', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_portion', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_portion', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_portion', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('post_notes_slide_add_new_portion', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_portion', 'dto', 'Portion'), 'password' => $utils->get_param_value('post_notes_slide_add_new_portion', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_portion', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_portion', 'storage', 'string'), 'position' => $utils->get_param_value('post_notes_slide_add_new_portion', 'position', 'int'));
    $params{ position } = $utils->invalidize_param_value('post_notes_slide_add_new_portion', 'position', $params{ position });
    $utils->initialize('post_notes_slide_add_new_portion', 'position', $params{ position });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_portion(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_portion', 'position', $params{ position }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_portion', 'position');
    }
}

#
# post_notes_slide_add_new_shape test
#
{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_notes_slide_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_notes_slide_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_notes_slide_add_new_shape', 'position', 'int'));
    $utils->initialize('post_notes_slide_add_new_shape', '');
    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_shape(%params);
    };
    if ($@) {
        fail("post_notes_slide_add_new_shape raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_notes_slide_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_notes_slide_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_notes_slide_add_new_shape', 'position', 'int'));
    $params{ name } = $utils->invalidize_param_value('post_notes_slide_add_new_shape', 'name', $params{ name });
    $utils->initialize('post_notes_slide_add_new_shape', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_shape', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_shape', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_notes_slide_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_notes_slide_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_notes_slide_add_new_shape', 'position', 'int'));
    $params{ slide_index } = $utils->invalidize_param_value('post_notes_slide_add_new_shape', 'slide_index', $params{ slide_index });
    $utils->initialize('post_notes_slide_add_new_shape', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_shape', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_shape', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_notes_slide_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_notes_slide_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_notes_slide_add_new_shape', 'position', 'int'));
    $params{ path } = $utils->invalidize_param_value('post_notes_slide_add_new_shape', 'path', $params{ path });
    $utils->initialize('post_notes_slide_add_new_shape', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_shape', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_shape', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_notes_slide_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_notes_slide_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_notes_slide_add_new_shape', 'position', 'int'));
    $params{ dto } = $utils->invalidize_param_value('post_notes_slide_add_new_shape', 'dto', $params{ dto });
    $utils->initialize('post_notes_slide_add_new_shape', 'dto', $params{ dto });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_shape', 'dto', $params{ dto }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_shape', 'dto');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_notes_slide_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_notes_slide_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_notes_slide_add_new_shape', 'position', 'int'));
    $params{ password } = $utils->invalidize_param_value('post_notes_slide_add_new_shape', 'password', $params{ password });
    $utils->initialize('post_notes_slide_add_new_shape', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_shape', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_shape', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_notes_slide_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_notes_slide_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_notes_slide_add_new_shape', 'position', 'int'));
    $params{ folder } = $utils->invalidize_param_value('post_notes_slide_add_new_shape', 'folder', $params{ folder });
    $utils->initialize('post_notes_slide_add_new_shape', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_shape', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_shape', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_notes_slide_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_notes_slide_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_notes_slide_add_new_shape', 'position', 'int'));
    $params{ storage } = $utils->invalidize_param_value('post_notes_slide_add_new_shape', 'storage', $params{ storage });
    $utils->initialize('post_notes_slide_add_new_shape', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_shape', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_shape', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_notes_slide_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_notes_slide_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_notes_slide_add_new_shape', 'position', 'int'));
    $params{ shape_to_clone } = $utils->invalidize_param_value('post_notes_slide_add_new_shape', 'shape_to_clone', $params{ shape_to_clone });
    $utils->initialize('post_notes_slide_add_new_shape', 'shape_to_clone', $params{ shape_to_clone });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_shape', 'shape_to_clone', $params{ shape_to_clone }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_shape', 'shape_to_clone');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_add_new_shape', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_add_new_shape', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_add_new_shape', 'path', 'string'), 'dto' => $utils->get_param_value('post_notes_slide_add_new_shape', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('post_notes_slide_add_new_shape', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_add_new_shape', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_add_new_shape', 'storage', 'string'), 'shape_to_clone' => $utils->get_param_value('post_notes_slide_add_new_shape', 'shape_to_clone', 'int'), 'position' => $utils->get_param_value('post_notes_slide_add_new_shape', 'position', 'int'));
    $params{ position } = $utils->invalidize_param_value('post_notes_slide_add_new_shape', 'position', $params{ position });
    $utils->initialize('post_notes_slide_add_new_shape', 'position', $params{ position });

    eval {
        my $result = $utils->{api}->post_notes_slide_add_new_shape(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_add_new_shape', 'position', $params{ position }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_add_new_shape', 'position');
    }
}

#
# post_notes_slide_shape_save_as test
#
{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $utils->initialize('post_notes_slide_shape_save_as', '');
    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        fail("post_notes_slide_shape_save_as raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'name', $params{ name });
    $utils->initialize('post_notes_slide_shape_save_as', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'slide_index', $params{ slide_index });
    $utils->initialize('post_notes_slide_shape_save_as', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ path } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'path', $params{ path });
    $utils->initialize('post_notes_slide_shape_save_as', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'shape_index', $params{ shape_index });
    $utils->initialize('post_notes_slide_shape_save_as', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ format } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'format', $params{ format });
    $utils->initialize('post_notes_slide_shape_save_as', 'format', $params{ format });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'format', $params{ format }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'format');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ options } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'options', $params{ options });
    $utils->initialize('post_notes_slide_shape_save_as', 'options', $params{ options });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'options', $params{ options }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'options');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'password', $params{ password });
    $utils->initialize('post_notes_slide_shape_save_as', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'folder', $params{ folder });
    $utils->initialize('post_notes_slide_shape_save_as', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'storage', $params{ storage });
    $utils->initialize('post_notes_slide_shape_save_as', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ scale_x } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'scale_x', $params{ scale_x });
    $utils->initialize('post_notes_slide_shape_save_as', 'scale_x', $params{ scale_x });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'scale_x', $params{ scale_x }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'scale_x');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ scale_y } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'scale_y', $params{ scale_y });
    $utils->initialize('post_notes_slide_shape_save_as', 'scale_y', $params{ scale_y });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'scale_y', $params{ scale_y }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'scale_y');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ bounds } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'bounds', $params{ bounds });
    $utils->initialize('post_notes_slide_shape_save_as', 'bounds', $params{ bounds });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'bounds', $params{ bounds }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'bounds');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_notes_slide_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ fonts_folder } = $utils->invalidize_param_value('post_notes_slide_shape_save_as', 'fonts_folder', $params{ fonts_folder });
    $utils->initialize('post_notes_slide_shape_save_as', 'fonts_folder', $params{ fonts_folder });

    eval {
        my $result = $utils->{api}->post_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_notes_slide_shape_save_as', 'fonts_folder', $params{ fonts_folder }, $@);
    } else {
        $utils->assert_no_error('post_notes_slide_shape_save_as', 'fonts_folder');
    }
}

#
# post_presentation_merge test
#
{
    my %params = ('name' => $utils->get_param_value('post_presentation_merge', 'name', 'string'), 'request' => $utils->get_param_value('post_presentation_merge', 'request', 'PresentationsMergeRequest'), 'password' => $utils->get_param_value('post_presentation_merge', 'password', 'string'), 'storage' => $utils->get_param_value('post_presentation_merge', 'storage', 'string'), 'folder' => $utils->get_param_value('post_presentation_merge', 'folder', 'string'));
    $utils->initialize('post_presentation_merge', '');
    eval {
        my $result = $utils->{api}->post_presentation_merge(%params);
    };
    if ($@) {
        fail("post_presentation_merge raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_presentation_merge', 'name', 'string'), 'request' => $utils->get_param_value('post_presentation_merge', 'request', 'PresentationsMergeRequest'), 'password' => $utils->get_param_value('post_presentation_merge', 'password', 'string'), 'storage' => $utils->get_param_value('post_presentation_merge', 'storage', 'string'), 'folder' => $utils->get_param_value('post_presentation_merge', 'folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_presentation_merge', 'name', $params{ name });
    $utils->initialize('post_presentation_merge', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_presentation_merge(%params);
    };
    if ($@) {
        $utils->assert_error('post_presentation_merge', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_presentation_merge', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_presentation_merge', 'name', 'string'), 'request' => $utils->get_param_value('post_presentation_merge', 'request', 'PresentationsMergeRequest'), 'password' => $utils->get_param_value('post_presentation_merge', 'password', 'string'), 'storage' => $utils->get_param_value('post_presentation_merge', 'storage', 'string'), 'folder' => $utils->get_param_value('post_presentation_merge', 'folder', 'string'));
    $params{ request } = $utils->invalidize_param_value('post_presentation_merge', 'request', $params{ request });
    $utils->initialize('post_presentation_merge', 'request', $params{ request });

    eval {
        my $result = $utils->{api}->post_presentation_merge(%params);
    };
    if ($@) {
        $utils->assert_error('post_presentation_merge', 'request', $params{ request }, $@);
    } else {
        $utils->assert_no_error('post_presentation_merge', 'request');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_presentation_merge', 'name', 'string'), 'request' => $utils->get_param_value('post_presentation_merge', 'request', 'PresentationsMergeRequest'), 'password' => $utils->get_param_value('post_presentation_merge', 'password', 'string'), 'storage' => $utils->get_param_value('post_presentation_merge', 'storage', 'string'), 'folder' => $utils->get_param_value('post_presentation_merge', 'folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_presentation_merge', 'password', $params{ password });
    $utils->initialize('post_presentation_merge', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_presentation_merge(%params);
    };
    if ($@) {
        $utils->assert_error('post_presentation_merge', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_presentation_merge', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_presentation_merge', 'name', 'string'), 'request' => $utils->get_param_value('post_presentation_merge', 'request', 'PresentationsMergeRequest'), 'password' => $utils->get_param_value('post_presentation_merge', 'password', 'string'), 'storage' => $utils->get_param_value('post_presentation_merge', 'storage', 'string'), 'folder' => $utils->get_param_value('post_presentation_merge', 'folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_presentation_merge', 'storage', $params{ storage });
    $utils->initialize('post_presentation_merge', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_presentation_merge(%params);
    };
    if ($@) {
        $utils->assert_error('post_presentation_merge', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_presentation_merge', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_presentation_merge', 'name', 'string'), 'request' => $utils->get_param_value('post_presentation_merge', 'request', 'PresentationsMergeRequest'), 'password' => $utils->get_param_value('post_presentation_merge', 'password', 'string'), 'storage' => $utils->get_param_value('post_presentation_merge', 'storage', 'string'), 'folder' => $utils->get_param_value('post_presentation_merge', 'folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_presentation_merge', 'folder', $params{ folder });
    $utils->initialize('post_presentation_merge', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_presentation_merge(%params);
    };
    if ($@) {
        $utils->assert_error('post_presentation_merge', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_presentation_merge', 'folder');
    }
}

#
# post_shape_save_as test
#
{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $utils->initialize('post_shape_save_as', '');
    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        fail("post_shape_save_as raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_shape_save_as', 'name', $params{ name });
    $utils->initialize('post_shape_save_as', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('post_shape_save_as', 'slide_index', $params{ slide_index });
    $utils->initialize('post_shape_save_as', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ path } = $utils->invalidize_param_value('post_shape_save_as', 'path', $params{ path });
    $utils->initialize('post_shape_save_as', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('post_shape_save_as', 'shape_index', $params{ shape_index });
    $utils->initialize('post_shape_save_as', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ format } = $utils->invalidize_param_value('post_shape_save_as', 'format', $params{ format });
    $utils->initialize('post_shape_save_as', 'format', $params{ format });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'format', $params{ format }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'format');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ options } = $utils->invalidize_param_value('post_shape_save_as', 'options', $params{ options });
    $utils->initialize('post_shape_save_as', 'options', $params{ options });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'options', $params{ options }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'options');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_shape_save_as', 'password', $params{ password });
    $utils->initialize('post_shape_save_as', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_shape_save_as', 'folder', $params{ folder });
    $utils->initialize('post_shape_save_as', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_shape_save_as', 'storage', $params{ storage });
    $utils->initialize('post_shape_save_as', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ scale_x } = $utils->invalidize_param_value('post_shape_save_as', 'scale_x', $params{ scale_x });
    $utils->initialize('post_shape_save_as', 'scale_x', $params{ scale_x });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'scale_x', $params{ scale_x }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'scale_x');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ scale_y } = $utils->invalidize_param_value('post_shape_save_as', 'scale_y', $params{ scale_y });
    $utils->initialize('post_shape_save_as', 'scale_y', $params{ scale_y });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'scale_y', $params{ scale_y }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'scale_y');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ bounds } = $utils->invalidize_param_value('post_shape_save_as', 'bounds', $params{ bounds });
    $utils->initialize('post_shape_save_as', 'bounds', $params{ bounds });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'bounds', $params{ bounds }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'bounds');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('post_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('post_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('post_shape_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('post_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('post_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('post_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('post_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('post_shape_save_as', 'fonts_folder', 'string'));
    $params{ fonts_folder } = $utils->invalidize_param_value('post_shape_save_as', 'fonts_folder', $params{ fonts_folder });
    $utils->initialize('post_shape_save_as', 'fonts_folder', $params{ fonts_folder });

    eval {
        my $result = $utils->{api}->post_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_shape_save_as', 'fonts_folder', $params{ fonts_folder }, $@);
    } else {
        $utils->assert_no_error('post_shape_save_as', 'fonts_folder');
    }
}

#
# post_slide_animation_effect test
#
{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_effect', 'slide_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_effect', 'storage', 'string'));
    $utils->initialize('post_slide_animation_effect', '');
    eval {
        my $result = $utils->{api}->post_slide_animation_effect(%params);
    };
    if ($@) {
        fail("post_slide_animation_effect raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_effect', 'slide_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_effect', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slide_animation_effect', 'name', $params{ name });
    $utils->initialize('post_slide_animation_effect', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_effect', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_effect', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_effect', 'slide_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_effect', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('post_slide_animation_effect', 'slide_index', $params{ slide_index });
    $utils->initialize('post_slide_animation_effect', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_effect', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_effect', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_effect', 'slide_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_effect', 'storage', 'string'));
    $params{ effect } = $utils->invalidize_param_value('post_slide_animation_effect', 'effect', $params{ effect });
    $utils->initialize('post_slide_animation_effect', 'effect', $params{ effect });

    eval {
        my $result = $utils->{api}->post_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_effect', 'effect', $params{ effect }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_effect', 'effect');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_effect', 'slide_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_effect', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slide_animation_effect', 'password', $params{ password });
    $utils->initialize('post_slide_animation_effect', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_effect', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_effect', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_effect', 'slide_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_effect', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slide_animation_effect', 'folder', $params{ folder });
    $utils->initialize('post_slide_animation_effect', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_effect', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_effect', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_effect', 'slide_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_effect', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slide_animation_effect', 'storage', $params{ storage });
    $utils->initialize('post_slide_animation_effect', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_effect', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_effect', 'storage');
    }
}

#
# post_slide_animation_interactive_sequence test
#
{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'sequence', 'InteractiveSequence'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'storage', 'string'));
    $utils->initialize('post_slide_animation_interactive_sequence', '');
    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        fail("post_slide_animation_interactive_sequence raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'sequence', 'InteractiveSequence'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence', 'name', $params{ name });
    $utils->initialize('post_slide_animation_interactive_sequence', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'sequence', 'InteractiveSequence'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence', 'slide_index', $params{ slide_index });
    $utils->initialize('post_slide_animation_interactive_sequence', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'sequence', 'InteractiveSequence'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'storage', 'string'));
    $params{ sequence } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence', 'sequence', $params{ sequence });
    $utils->initialize('post_slide_animation_interactive_sequence', 'sequence', $params{ sequence });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence', 'sequence', $params{ sequence }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence', 'sequence');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'sequence', 'InteractiveSequence'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence', 'password', $params{ password });
    $utils->initialize('post_slide_animation_interactive_sequence', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'sequence', 'InteractiveSequence'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence', 'folder', $params{ folder });
    $utils->initialize('post_slide_animation_interactive_sequence', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'slide_index', 'int'), 'sequence' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'sequence', 'InteractiveSequence'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence', 'storage', $params{ storage });
    $utils->initialize('post_slide_animation_interactive_sequence', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence', 'storage');
    }
}

#
# post_slide_animation_interactive_sequence_effect test
#
{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $utils->initialize('post_slide_animation_interactive_sequence_effect', '');
    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        fail("post_slide_animation_interactive_sequence_effect raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence_effect', 'name', $params{ name });
    $utils->initialize('post_slide_animation_interactive_sequence_effect', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence_effect', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence_effect', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence_effect', 'slide_index', $params{ slide_index });
    $utils->initialize('post_slide_animation_interactive_sequence_effect', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence_effect', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence_effect', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ sequence_index } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence_effect', 'sequence_index', $params{ sequence_index });
    $utils->initialize('post_slide_animation_interactive_sequence_effect', 'sequence_index', $params{ sequence_index });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence_effect', 'sequence_index', $params{ sequence_index }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence_effect', 'sequence_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ effect } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence_effect', 'effect', $params{ effect });
    $utils->initialize('post_slide_animation_interactive_sequence_effect', 'effect', $params{ effect });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence_effect', 'effect', $params{ effect }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence_effect', 'effect');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence_effect', 'password', $params{ password });
    $utils->initialize('post_slide_animation_interactive_sequence_effect', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence_effect', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence_effect', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence_effect', 'folder', $params{ folder });
    $utils->initialize('post_slide_animation_interactive_sequence_effect', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence_effect', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence_effect', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slide_animation_interactive_sequence_effect', 'storage', $params{ storage });
    $utils->initialize('post_slide_animation_interactive_sequence_effect', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_animation_interactive_sequence_effect', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slide_animation_interactive_sequence_effect', 'storage');
    }
}

#
# post_slide_save_as test
#
{
    my %params = ('name' => $utils->get_param_value('post_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('post_slide_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('post_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('post_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('post_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('post_slide_save_as', 'fonts_folder', 'string'));
    $utils->initialize('post_slide_save_as', '');
    eval {
        my $result = $utils->{api}->post_slide_save_as(%params);
    };
    if ($@) {
        fail("post_slide_save_as raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('post_slide_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('post_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('post_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('post_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('post_slide_save_as', 'fonts_folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slide_save_as', 'name', $params{ name });
    $utils->initialize('post_slide_save_as', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_save_as', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slide_save_as', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('post_slide_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('post_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('post_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('post_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('post_slide_save_as', 'fonts_folder', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('post_slide_save_as', 'slide_index', $params{ slide_index });
    $utils->initialize('post_slide_save_as', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_save_as', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_slide_save_as', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('post_slide_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('post_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('post_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('post_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('post_slide_save_as', 'fonts_folder', 'string'));
    $params{ format } = $utils->invalidize_param_value('post_slide_save_as', 'format', $params{ format });
    $utils->initialize('post_slide_save_as', 'format', $params{ format });

    eval {
        my $result = $utils->{api}->post_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_save_as', 'format', $params{ format }, $@);
    } else {
        $utils->assert_no_error('post_slide_save_as', 'format');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('post_slide_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('post_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('post_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('post_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('post_slide_save_as', 'fonts_folder', 'string'));
    $params{ options } = $utils->invalidize_param_value('post_slide_save_as', 'options', $params{ options });
    $utils->initialize('post_slide_save_as', 'options', $params{ options });

    eval {
        my $result = $utils->{api}->post_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_save_as', 'options', $params{ options }, $@);
    } else {
        $utils->assert_no_error('post_slide_save_as', 'options');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('post_slide_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('post_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('post_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('post_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('post_slide_save_as', 'fonts_folder', 'string'));
    $params{ width } = $utils->invalidize_param_value('post_slide_save_as', 'width', $params{ width });
    $utils->initialize('post_slide_save_as', 'width', $params{ width });

    eval {
        my $result = $utils->{api}->post_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_save_as', 'width', $params{ width }, $@);
    } else {
        $utils->assert_no_error('post_slide_save_as', 'width');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('post_slide_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('post_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('post_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('post_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('post_slide_save_as', 'fonts_folder', 'string'));
    $params{ height } = $utils->invalidize_param_value('post_slide_save_as', 'height', $params{ height });
    $utils->initialize('post_slide_save_as', 'height', $params{ height });

    eval {
        my $result = $utils->{api}->post_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_save_as', 'height', $params{ height }, $@);
    } else {
        $utils->assert_no_error('post_slide_save_as', 'height');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('post_slide_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('post_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('post_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('post_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('post_slide_save_as', 'fonts_folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slide_save_as', 'password', $params{ password });
    $utils->initialize('post_slide_save_as', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_save_as', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slide_save_as', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('post_slide_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('post_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('post_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('post_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('post_slide_save_as', 'fonts_folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slide_save_as', 'folder', $params{ folder });
    $utils->initialize('post_slide_save_as', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_save_as', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slide_save_as', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('post_slide_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('post_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('post_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('post_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('post_slide_save_as', 'fonts_folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slide_save_as', 'storage', $params{ storage });
    $utils->initialize('post_slide_save_as', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_save_as', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slide_save_as', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('post_slide_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('post_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('post_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('post_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('post_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('post_slide_save_as', 'fonts_folder', 'string'));
    $params{ fonts_folder } = $utils->invalidize_param_value('post_slide_save_as', 'fonts_folder', $params{ fonts_folder });
    $utils->initialize('post_slide_save_as', 'fonts_folder', $params{ fonts_folder });

    eval {
        my $result = $utils->{api}->post_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slide_save_as', 'fonts_folder', $params{ fonts_folder }, $@);
    } else {
        $utils->assert_no_error('post_slide_save_as', 'fonts_folder');
    }
}

#
# post_slides_add test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_add', 'name', 'string'), 'position' => $utils->get_param_value('post_slides_add', 'position', 'int'), 'password' => $utils->get_param_value('post_slides_add', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_add', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_add', 'storage', 'string'), 'layout_alias' => $utils->get_param_value('post_slides_add', 'layout_alias', 'string'));
    $utils->initialize('post_slides_add', '');
    eval {
        my $result = $utils->{api}->post_slides_add(%params);
    };
    if ($@) {
        fail("post_slides_add raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_add', 'name', 'string'), 'position' => $utils->get_param_value('post_slides_add', 'position', 'int'), 'password' => $utils->get_param_value('post_slides_add', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_add', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_add', 'storage', 'string'), 'layout_alias' => $utils->get_param_value('post_slides_add', 'layout_alias', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_add', 'name', $params{ name });
    $utils->initialize('post_slides_add', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_add(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_add', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_add', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_add', 'name', 'string'), 'position' => $utils->get_param_value('post_slides_add', 'position', 'int'), 'password' => $utils->get_param_value('post_slides_add', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_add', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_add', 'storage', 'string'), 'layout_alias' => $utils->get_param_value('post_slides_add', 'layout_alias', 'string'));
    $params{ position } = $utils->invalidize_param_value('post_slides_add', 'position', $params{ position });
    $utils->initialize('post_slides_add', 'position', $params{ position });

    eval {
        my $result = $utils->{api}->post_slides_add(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_add', 'position', $params{ position }, $@);
    } else {
        $utils->assert_no_error('post_slides_add', 'position');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_add', 'name', 'string'), 'position' => $utils->get_param_value('post_slides_add', 'position', 'int'), 'password' => $utils->get_param_value('post_slides_add', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_add', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_add', 'storage', 'string'), 'layout_alias' => $utils->get_param_value('post_slides_add', 'layout_alias', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_add', 'password', $params{ password });
    $utils->initialize('post_slides_add', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_add(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_add', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_add', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_add', 'name', 'string'), 'position' => $utils->get_param_value('post_slides_add', 'position', 'int'), 'password' => $utils->get_param_value('post_slides_add', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_add', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_add', 'storage', 'string'), 'layout_alias' => $utils->get_param_value('post_slides_add', 'layout_alias', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_add', 'folder', $params{ folder });
    $utils->initialize('post_slides_add', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_add(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_add', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_add', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_add', 'name', 'string'), 'position' => $utils->get_param_value('post_slides_add', 'position', 'int'), 'password' => $utils->get_param_value('post_slides_add', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_add', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_add', 'storage', 'string'), 'layout_alias' => $utils->get_param_value('post_slides_add', 'layout_alias', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_add', 'storage', $params{ storage });
    $utils->initialize('post_slides_add', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_add(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_add', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_add', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_add', 'name', 'string'), 'position' => $utils->get_param_value('post_slides_add', 'position', 'int'), 'password' => $utils->get_param_value('post_slides_add', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_add', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_add', 'storage', 'string'), 'layout_alias' => $utils->get_param_value('post_slides_add', 'layout_alias', 'string'));
    $params{ layout_alias } = $utils->invalidize_param_value('post_slides_add', 'layout_alias', $params{ layout_alias });
    $utils->initialize('post_slides_add', 'layout_alias', $params{ layout_alias });

    eval {
        my $result = $utils->{api}->post_slides_add(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_add', 'layout_alias', $params{ layout_alias }, $@);
    } else {
        $utils->assert_no_error('post_slides_add', 'layout_alias');
    }
}

#
# post_slides_convert test
#
{
    my %params = ('format' => $utils->get_param_value('post_slides_convert', 'format', 'string'), 'document' => $utils->get_param_value('post_slides_convert', 'document', 'File'), 'password' => $utils->get_param_value('post_slides_convert', 'password', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_convert', 'fonts_folder', 'string'));
    $utils->initialize('post_slides_convert', '');
    eval {
        my $result = $utils->{api}->post_slides_convert(%params);
    };
    if ($@) {
        fail("post_slides_convert raised an exception: $@");
    }
    pass();
}

{
    my %params = ('format' => $utils->get_param_value('post_slides_convert', 'format', 'string'), 'document' => $utils->get_param_value('post_slides_convert', 'document', 'File'), 'password' => $utils->get_param_value('post_slides_convert', 'password', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_convert', 'fonts_folder', 'string'));
    $params{ format } = $utils->invalidize_param_value('post_slides_convert', 'format', $params{ format });
    $utils->initialize('post_slides_convert', 'format', $params{ format });

    eval {
        my $result = $utils->{api}->post_slides_convert(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_convert', 'format', $params{ format }, $@);
    } else {
        $utils->assert_no_error('post_slides_convert', 'format');
    }
}

{
    my %params = ('format' => $utils->get_param_value('post_slides_convert', 'format', 'string'), 'document' => $utils->get_param_value('post_slides_convert', 'document', 'File'), 'password' => $utils->get_param_value('post_slides_convert', 'password', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_convert', 'fonts_folder', 'string'));
    $params{ document } = $utils->invalidize_param_value('post_slides_convert', 'document', $params{ document });
    $utils->initialize('post_slides_convert', 'document', $params{ document });

    eval {
        my $result = $utils->{api}->post_slides_convert(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_convert', 'document', $params{ document }, $@);
    } else {
        $utils->assert_no_error('post_slides_convert', 'document');
    }
}

{
    my %params = ('format' => $utils->get_param_value('post_slides_convert', 'format', 'string'), 'document' => $utils->get_param_value('post_slides_convert', 'document', 'File'), 'password' => $utils->get_param_value('post_slides_convert', 'password', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_convert', 'fonts_folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_convert', 'password', $params{ password });
    $utils->initialize('post_slides_convert', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_convert(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_convert', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_convert', 'password');
    }
}

{
    my %params = ('format' => $utils->get_param_value('post_slides_convert', 'format', 'string'), 'document' => $utils->get_param_value('post_slides_convert', 'document', 'File'), 'password' => $utils->get_param_value('post_slides_convert', 'password', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_convert', 'fonts_folder', 'string'));
    $params{ fonts_folder } = $utils->invalidize_param_value('post_slides_convert', 'fonts_folder', $params{ fonts_folder });
    $utils->initialize('post_slides_convert', 'fonts_folder', $params{ fonts_folder });

    eval {
        my $result = $utils->{api}->post_slides_convert(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_convert', 'fonts_folder', $params{ fonts_folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_convert', 'fonts_folder');
    }
}

#
# post_slides_copy test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_copy', 'name', 'string'), 'slide_to_copy' => $utils->get_param_value('post_slides_copy', 'slide_to_copy', 'int'), 'position' => $utils->get_param_value('post_slides_copy', 'position', 'int'), 'source' => $utils->get_param_value('post_slides_copy', 'source', 'string'), 'source_password' => $utils->get_param_value('post_slides_copy', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_copy', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_copy', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_copy', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_copy', 'storage', 'string'));
    $utils->initialize('post_slides_copy', '');
    eval {
        my $result = $utils->{api}->post_slides_copy(%params);
    };
    if ($@) {
        fail("post_slides_copy raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_copy', 'name', 'string'), 'slide_to_copy' => $utils->get_param_value('post_slides_copy', 'slide_to_copy', 'int'), 'position' => $utils->get_param_value('post_slides_copy', 'position', 'int'), 'source' => $utils->get_param_value('post_slides_copy', 'source', 'string'), 'source_password' => $utils->get_param_value('post_slides_copy', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_copy', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_copy', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_copy', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_copy', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_copy', 'name', $params{ name });
    $utils->initialize('post_slides_copy', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_copy(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_copy', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_copy', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_copy', 'name', 'string'), 'slide_to_copy' => $utils->get_param_value('post_slides_copy', 'slide_to_copy', 'int'), 'position' => $utils->get_param_value('post_slides_copy', 'position', 'int'), 'source' => $utils->get_param_value('post_slides_copy', 'source', 'string'), 'source_password' => $utils->get_param_value('post_slides_copy', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_copy', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_copy', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_copy', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_copy', 'storage', 'string'));
    $params{ slide_to_copy } = $utils->invalidize_param_value('post_slides_copy', 'slide_to_copy', $params{ slide_to_copy });
    $utils->initialize('post_slides_copy', 'slide_to_copy', $params{ slide_to_copy });

    eval {
        my $result = $utils->{api}->post_slides_copy(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_copy', 'slide_to_copy', $params{ slide_to_copy }, $@);
    } else {
        $utils->assert_no_error('post_slides_copy', 'slide_to_copy');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_copy', 'name', 'string'), 'slide_to_copy' => $utils->get_param_value('post_slides_copy', 'slide_to_copy', 'int'), 'position' => $utils->get_param_value('post_slides_copy', 'position', 'int'), 'source' => $utils->get_param_value('post_slides_copy', 'source', 'string'), 'source_password' => $utils->get_param_value('post_slides_copy', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_copy', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_copy', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_copy', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_copy', 'storage', 'string'));
    $params{ position } = $utils->invalidize_param_value('post_slides_copy', 'position', $params{ position });
    $utils->initialize('post_slides_copy', 'position', $params{ position });

    eval {
        my $result = $utils->{api}->post_slides_copy(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_copy', 'position', $params{ position }, $@);
    } else {
        $utils->assert_no_error('post_slides_copy', 'position');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_copy', 'name', 'string'), 'slide_to_copy' => $utils->get_param_value('post_slides_copy', 'slide_to_copy', 'int'), 'position' => $utils->get_param_value('post_slides_copy', 'position', 'int'), 'source' => $utils->get_param_value('post_slides_copy', 'source', 'string'), 'source_password' => $utils->get_param_value('post_slides_copy', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_copy', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_copy', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_copy', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_copy', 'storage', 'string'));
    $params{ source } = $utils->invalidize_param_value('post_slides_copy', 'source', $params{ source });
    $utils->initialize('post_slides_copy', 'source', $params{ source });

    eval {
        my $result = $utils->{api}->post_slides_copy(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_copy', 'source', $params{ source }, $@);
    } else {
        $utils->assert_no_error('post_slides_copy', 'source');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_copy', 'name', 'string'), 'slide_to_copy' => $utils->get_param_value('post_slides_copy', 'slide_to_copy', 'int'), 'position' => $utils->get_param_value('post_slides_copy', 'position', 'int'), 'source' => $utils->get_param_value('post_slides_copy', 'source', 'string'), 'source_password' => $utils->get_param_value('post_slides_copy', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_copy', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_copy', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_copy', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_copy', 'storage', 'string'));
    $params{ source_password } = $utils->invalidize_param_value('post_slides_copy', 'source_password', $params{ source_password });
    $utils->initialize('post_slides_copy', 'source_password', $params{ source_password });

    eval {
        my $result = $utils->{api}->post_slides_copy(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_copy', 'source_password', $params{ source_password }, $@);
    } else {
        $utils->assert_no_error('post_slides_copy', 'source_password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_copy', 'name', 'string'), 'slide_to_copy' => $utils->get_param_value('post_slides_copy', 'slide_to_copy', 'int'), 'position' => $utils->get_param_value('post_slides_copy', 'position', 'int'), 'source' => $utils->get_param_value('post_slides_copy', 'source', 'string'), 'source_password' => $utils->get_param_value('post_slides_copy', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_copy', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_copy', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_copy', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_copy', 'storage', 'string'));
    $params{ source_storage } = $utils->invalidize_param_value('post_slides_copy', 'source_storage', $params{ source_storage });
    $utils->initialize('post_slides_copy', 'source_storage', $params{ source_storage });

    eval {
        my $result = $utils->{api}->post_slides_copy(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_copy', 'source_storage', $params{ source_storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_copy', 'source_storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_copy', 'name', 'string'), 'slide_to_copy' => $utils->get_param_value('post_slides_copy', 'slide_to_copy', 'int'), 'position' => $utils->get_param_value('post_slides_copy', 'position', 'int'), 'source' => $utils->get_param_value('post_slides_copy', 'source', 'string'), 'source_password' => $utils->get_param_value('post_slides_copy', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_copy', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_copy', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_copy', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_copy', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_copy', 'password', $params{ password });
    $utils->initialize('post_slides_copy', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_copy(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_copy', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_copy', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_copy', 'name', 'string'), 'slide_to_copy' => $utils->get_param_value('post_slides_copy', 'slide_to_copy', 'int'), 'position' => $utils->get_param_value('post_slides_copy', 'position', 'int'), 'source' => $utils->get_param_value('post_slides_copy', 'source', 'string'), 'source_password' => $utils->get_param_value('post_slides_copy', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_copy', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_copy', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_copy', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_copy', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_copy', 'folder', $params{ folder });
    $utils->initialize('post_slides_copy', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_copy(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_copy', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_copy', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_copy', 'name', 'string'), 'slide_to_copy' => $utils->get_param_value('post_slides_copy', 'slide_to_copy', 'int'), 'position' => $utils->get_param_value('post_slides_copy', 'position', 'int'), 'source' => $utils->get_param_value('post_slides_copy', 'source', 'string'), 'source_password' => $utils->get_param_value('post_slides_copy', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_copy', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_copy', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_copy', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_copy', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_copy', 'storage', $params{ storage });
    $utils->initialize('post_slides_copy', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_copy(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_copy', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_copy', 'storage');
    }
}

#
# post_slides_document test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_document', 'name', 'string'), 'data' => $utils->get_param_value('post_slides_document', 'data', 'File'), 'input_password' => $utils->get_param_value('post_slides_document', 'input_password', 'string'), 'password' => $utils->get_param_value('post_slides_document', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document', 'folder', 'string'));
    $utils->initialize('post_slides_document', '');
    eval {
        my $result = $utils->{api}->post_slides_document(%params);
    };
    if ($@) {
        fail("post_slides_document raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document', 'name', 'string'), 'data' => $utils->get_param_value('post_slides_document', 'data', 'File'), 'input_password' => $utils->get_param_value('post_slides_document', 'input_password', 'string'), 'password' => $utils->get_param_value('post_slides_document', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document', 'folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_document', 'name', $params{ name });
    $utils->initialize('post_slides_document', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_document(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_document', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document', 'name', 'string'), 'data' => $utils->get_param_value('post_slides_document', 'data', 'File'), 'input_password' => $utils->get_param_value('post_slides_document', 'input_password', 'string'), 'password' => $utils->get_param_value('post_slides_document', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document', 'folder', 'string'));
    $params{ data } = $utils->invalidize_param_value('post_slides_document', 'data', $params{ data });
    $utils->initialize('post_slides_document', 'data', $params{ data });

    eval {
        my $result = $utils->{api}->post_slides_document(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document', 'data', $params{ data }, $@);
    } else {
        $utils->assert_no_error('post_slides_document', 'data');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document', 'name', 'string'), 'data' => $utils->get_param_value('post_slides_document', 'data', 'File'), 'input_password' => $utils->get_param_value('post_slides_document', 'input_password', 'string'), 'password' => $utils->get_param_value('post_slides_document', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document', 'folder', 'string'));
    $params{ input_password } = $utils->invalidize_param_value('post_slides_document', 'input_password', $params{ input_password });
    $utils->initialize('post_slides_document', 'input_password', $params{ input_password });

    eval {
        my $result = $utils->{api}->post_slides_document(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document', 'input_password', $params{ input_password }, $@);
    } else {
        $utils->assert_no_error('post_slides_document', 'input_password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document', 'name', 'string'), 'data' => $utils->get_param_value('post_slides_document', 'data', 'File'), 'input_password' => $utils->get_param_value('post_slides_document', 'input_password', 'string'), 'password' => $utils->get_param_value('post_slides_document', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document', 'folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_document', 'password', $params{ password });
    $utils->initialize('post_slides_document', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_document(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_document', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document', 'name', 'string'), 'data' => $utils->get_param_value('post_slides_document', 'data', 'File'), 'input_password' => $utils->get_param_value('post_slides_document', 'input_password', 'string'), 'password' => $utils->get_param_value('post_slides_document', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document', 'folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_document', 'storage', $params{ storage });
    $utils->initialize('post_slides_document', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_document(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_document', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document', 'name', 'string'), 'data' => $utils->get_param_value('post_slides_document', 'data', 'File'), 'input_password' => $utils->get_param_value('post_slides_document', 'input_password', 'string'), 'password' => $utils->get_param_value('post_slides_document', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document', 'folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_document', 'folder', $params{ folder });
    $utils->initialize('post_slides_document', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_document(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_document', 'folder');
    }
}

#
# post_slides_document_from_html test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_html', 'name', 'string'), 'html' => $utils->get_param_value('post_slides_document_from_html', 'html', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_html', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_html', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_html', 'folder', 'string'));
    $utils->initialize('post_slides_document_from_html', '');
    eval {
        my $result = $utils->{api}->post_slides_document_from_html(%params);
    };
    if ($@) {
        fail("post_slides_document_from_html raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_html', 'name', 'string'), 'html' => $utils->get_param_value('post_slides_document_from_html', 'html', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_html', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_html', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_html', 'folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_document_from_html', 'name', $params{ name });
    $utils->initialize('post_slides_document_from_html', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_document_from_html(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_html', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_html', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_html', 'name', 'string'), 'html' => $utils->get_param_value('post_slides_document_from_html', 'html', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_html', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_html', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_html', 'folder', 'string'));
    $params{ html } = $utils->invalidize_param_value('post_slides_document_from_html', 'html', $params{ html });
    $utils->initialize('post_slides_document_from_html', 'html', $params{ html });

    eval {
        my $result = $utils->{api}->post_slides_document_from_html(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_html', 'html', $params{ html }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_html', 'html');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_html', 'name', 'string'), 'html' => $utils->get_param_value('post_slides_document_from_html', 'html', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_html', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_html', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_html', 'folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_document_from_html', 'password', $params{ password });
    $utils->initialize('post_slides_document_from_html', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_document_from_html(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_html', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_html', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_html', 'name', 'string'), 'html' => $utils->get_param_value('post_slides_document_from_html', 'html', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_html', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_html', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_html', 'folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_document_from_html', 'storage', $params{ storage });
    $utils->initialize('post_slides_document_from_html', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_document_from_html(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_html', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_html', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_html', 'name', 'string'), 'html' => $utils->get_param_value('post_slides_document_from_html', 'html', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_html', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_html', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_html', 'folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_document_from_html', 'folder', $params{ folder });
    $utils->initialize('post_slides_document_from_html', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_document_from_html(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_html', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_html', 'folder');
    }
}

#
# post_slides_document_from_source test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_source', 'name', 'string'), 'source_path' => $utils->get_param_value('post_slides_document_from_source', 'source_path', 'string'), 'source_password' => $utils->get_param_value('post_slides_document_from_source', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_document_from_source', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_source', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_source', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_source', 'folder', 'string'));
    $utils->initialize('post_slides_document_from_source', '');
    eval {
        my $result = $utils->{api}->post_slides_document_from_source(%params);
    };
    if ($@) {
        fail("post_slides_document_from_source raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_source', 'name', 'string'), 'source_path' => $utils->get_param_value('post_slides_document_from_source', 'source_path', 'string'), 'source_password' => $utils->get_param_value('post_slides_document_from_source', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_document_from_source', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_source', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_source', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_source', 'folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_document_from_source', 'name', $params{ name });
    $utils->initialize('post_slides_document_from_source', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_document_from_source(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_source', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_source', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_source', 'name', 'string'), 'source_path' => $utils->get_param_value('post_slides_document_from_source', 'source_path', 'string'), 'source_password' => $utils->get_param_value('post_slides_document_from_source', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_document_from_source', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_source', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_source', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_source', 'folder', 'string'));
    $params{ source_path } = $utils->invalidize_param_value('post_slides_document_from_source', 'source_path', $params{ source_path });
    $utils->initialize('post_slides_document_from_source', 'source_path', $params{ source_path });

    eval {
        my $result = $utils->{api}->post_slides_document_from_source(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_source', 'source_path', $params{ source_path }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_source', 'source_path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_source', 'name', 'string'), 'source_path' => $utils->get_param_value('post_slides_document_from_source', 'source_path', 'string'), 'source_password' => $utils->get_param_value('post_slides_document_from_source', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_document_from_source', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_source', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_source', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_source', 'folder', 'string'));
    $params{ source_password } = $utils->invalidize_param_value('post_slides_document_from_source', 'source_password', $params{ source_password });
    $utils->initialize('post_slides_document_from_source', 'source_password', $params{ source_password });

    eval {
        my $result = $utils->{api}->post_slides_document_from_source(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_source', 'source_password', $params{ source_password }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_source', 'source_password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_source', 'name', 'string'), 'source_path' => $utils->get_param_value('post_slides_document_from_source', 'source_path', 'string'), 'source_password' => $utils->get_param_value('post_slides_document_from_source', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_document_from_source', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_source', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_source', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_source', 'folder', 'string'));
    $params{ source_storage } = $utils->invalidize_param_value('post_slides_document_from_source', 'source_storage', $params{ source_storage });
    $utils->initialize('post_slides_document_from_source', 'source_storage', $params{ source_storage });

    eval {
        my $result = $utils->{api}->post_slides_document_from_source(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_source', 'source_storage', $params{ source_storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_source', 'source_storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_source', 'name', 'string'), 'source_path' => $utils->get_param_value('post_slides_document_from_source', 'source_path', 'string'), 'source_password' => $utils->get_param_value('post_slides_document_from_source', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_document_from_source', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_source', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_source', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_source', 'folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_document_from_source', 'password', $params{ password });
    $utils->initialize('post_slides_document_from_source', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_document_from_source(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_source', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_source', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_source', 'name', 'string'), 'source_path' => $utils->get_param_value('post_slides_document_from_source', 'source_path', 'string'), 'source_password' => $utils->get_param_value('post_slides_document_from_source', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_document_from_source', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_source', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_source', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_source', 'folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_document_from_source', 'storage', $params{ storage });
    $utils->initialize('post_slides_document_from_source', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_document_from_source(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_source', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_source', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_source', 'name', 'string'), 'source_path' => $utils->get_param_value('post_slides_document_from_source', 'source_path', 'string'), 'source_password' => $utils->get_param_value('post_slides_document_from_source', 'source_password', 'string'), 'source_storage' => $utils->get_param_value('post_slides_document_from_source', 'source_storage', 'string'), 'password' => $utils->get_param_value('post_slides_document_from_source', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_source', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_source', 'folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_document_from_source', 'folder', $params{ folder });
    $utils->initialize('post_slides_document_from_source', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_document_from_source(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_source', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_source', 'folder');
    }
}

#
# post_slides_document_from_template test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_template', 'name', 'string'), 'template_path' => $utils->get_param_value('post_slides_document_from_template', 'template_path', 'string'), 'data' => $utils->get_param_value('post_slides_document_from_template', 'data', 'string'), 'template_password' => $utils->get_param_value('post_slides_document_from_template', 'template_password', 'string'), 'template_storage' => $utils->get_param_value('post_slides_document_from_template', 'template_storage', 'string'), 'is_image_data_embedded' => $utils->get_param_value('post_slides_document_from_template', 'is_image_data_embedded', 'boolean'), 'password' => $utils->get_param_value('post_slides_document_from_template', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_template', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_template', 'folder', 'string'));
    $utils->initialize('post_slides_document_from_template', '');
    eval {
        my $result = $utils->{api}->post_slides_document_from_template(%params);
    };
    if ($@) {
        fail("post_slides_document_from_template raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_template', 'name', 'string'), 'template_path' => $utils->get_param_value('post_slides_document_from_template', 'template_path', 'string'), 'data' => $utils->get_param_value('post_slides_document_from_template', 'data', 'string'), 'template_password' => $utils->get_param_value('post_slides_document_from_template', 'template_password', 'string'), 'template_storage' => $utils->get_param_value('post_slides_document_from_template', 'template_storage', 'string'), 'is_image_data_embedded' => $utils->get_param_value('post_slides_document_from_template', 'is_image_data_embedded', 'boolean'), 'password' => $utils->get_param_value('post_slides_document_from_template', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_template', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_template', 'folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_document_from_template', 'name', $params{ name });
    $utils->initialize('post_slides_document_from_template', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_document_from_template(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_template', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_template', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_template', 'name', 'string'), 'template_path' => $utils->get_param_value('post_slides_document_from_template', 'template_path', 'string'), 'data' => $utils->get_param_value('post_slides_document_from_template', 'data', 'string'), 'template_password' => $utils->get_param_value('post_slides_document_from_template', 'template_password', 'string'), 'template_storage' => $utils->get_param_value('post_slides_document_from_template', 'template_storage', 'string'), 'is_image_data_embedded' => $utils->get_param_value('post_slides_document_from_template', 'is_image_data_embedded', 'boolean'), 'password' => $utils->get_param_value('post_slides_document_from_template', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_template', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_template', 'folder', 'string'));
    $params{ template_path } = $utils->invalidize_param_value('post_slides_document_from_template', 'template_path', $params{ template_path });
    $utils->initialize('post_slides_document_from_template', 'template_path', $params{ template_path });

    eval {
        my $result = $utils->{api}->post_slides_document_from_template(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_template', 'template_path', $params{ template_path }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_template', 'template_path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_template', 'name', 'string'), 'template_path' => $utils->get_param_value('post_slides_document_from_template', 'template_path', 'string'), 'data' => $utils->get_param_value('post_slides_document_from_template', 'data', 'string'), 'template_password' => $utils->get_param_value('post_slides_document_from_template', 'template_password', 'string'), 'template_storage' => $utils->get_param_value('post_slides_document_from_template', 'template_storage', 'string'), 'is_image_data_embedded' => $utils->get_param_value('post_slides_document_from_template', 'is_image_data_embedded', 'boolean'), 'password' => $utils->get_param_value('post_slides_document_from_template', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_template', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_template', 'folder', 'string'));
    $params{ data } = $utils->invalidize_param_value('post_slides_document_from_template', 'data', $params{ data });
    $utils->initialize('post_slides_document_from_template', 'data', $params{ data });

    eval {
        my $result = $utils->{api}->post_slides_document_from_template(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_template', 'data', $params{ data }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_template', 'data');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_template', 'name', 'string'), 'template_path' => $utils->get_param_value('post_slides_document_from_template', 'template_path', 'string'), 'data' => $utils->get_param_value('post_slides_document_from_template', 'data', 'string'), 'template_password' => $utils->get_param_value('post_slides_document_from_template', 'template_password', 'string'), 'template_storage' => $utils->get_param_value('post_slides_document_from_template', 'template_storage', 'string'), 'is_image_data_embedded' => $utils->get_param_value('post_slides_document_from_template', 'is_image_data_embedded', 'boolean'), 'password' => $utils->get_param_value('post_slides_document_from_template', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_template', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_template', 'folder', 'string'));
    $params{ template_password } = $utils->invalidize_param_value('post_slides_document_from_template', 'template_password', $params{ template_password });
    $utils->initialize('post_slides_document_from_template', 'template_password', $params{ template_password });

    eval {
        my $result = $utils->{api}->post_slides_document_from_template(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_template', 'template_password', $params{ template_password }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_template', 'template_password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_template', 'name', 'string'), 'template_path' => $utils->get_param_value('post_slides_document_from_template', 'template_path', 'string'), 'data' => $utils->get_param_value('post_slides_document_from_template', 'data', 'string'), 'template_password' => $utils->get_param_value('post_slides_document_from_template', 'template_password', 'string'), 'template_storage' => $utils->get_param_value('post_slides_document_from_template', 'template_storage', 'string'), 'is_image_data_embedded' => $utils->get_param_value('post_slides_document_from_template', 'is_image_data_embedded', 'boolean'), 'password' => $utils->get_param_value('post_slides_document_from_template', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_template', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_template', 'folder', 'string'));
    $params{ template_storage } = $utils->invalidize_param_value('post_slides_document_from_template', 'template_storage', $params{ template_storage });
    $utils->initialize('post_slides_document_from_template', 'template_storage', $params{ template_storage });

    eval {
        my $result = $utils->{api}->post_slides_document_from_template(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_template', 'template_storage', $params{ template_storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_template', 'template_storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_template', 'name', 'string'), 'template_path' => $utils->get_param_value('post_slides_document_from_template', 'template_path', 'string'), 'data' => $utils->get_param_value('post_slides_document_from_template', 'data', 'string'), 'template_password' => $utils->get_param_value('post_slides_document_from_template', 'template_password', 'string'), 'template_storage' => $utils->get_param_value('post_slides_document_from_template', 'template_storage', 'string'), 'is_image_data_embedded' => $utils->get_param_value('post_slides_document_from_template', 'is_image_data_embedded', 'boolean'), 'password' => $utils->get_param_value('post_slides_document_from_template', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_template', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_template', 'folder', 'string'));
    $params{ is_image_data_embedded } = $utils->invalidize_param_value('post_slides_document_from_template', 'is_image_data_embedded', $params{ is_image_data_embedded });
    $utils->initialize('post_slides_document_from_template', 'is_image_data_embedded', $params{ is_image_data_embedded });

    eval {
        my $result = $utils->{api}->post_slides_document_from_template(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_template', 'is_image_data_embedded', $params{ is_image_data_embedded }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_template', 'is_image_data_embedded');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_template', 'name', 'string'), 'template_path' => $utils->get_param_value('post_slides_document_from_template', 'template_path', 'string'), 'data' => $utils->get_param_value('post_slides_document_from_template', 'data', 'string'), 'template_password' => $utils->get_param_value('post_slides_document_from_template', 'template_password', 'string'), 'template_storage' => $utils->get_param_value('post_slides_document_from_template', 'template_storage', 'string'), 'is_image_data_embedded' => $utils->get_param_value('post_slides_document_from_template', 'is_image_data_embedded', 'boolean'), 'password' => $utils->get_param_value('post_slides_document_from_template', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_template', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_template', 'folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_document_from_template', 'password', $params{ password });
    $utils->initialize('post_slides_document_from_template', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_document_from_template(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_template', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_template', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_template', 'name', 'string'), 'template_path' => $utils->get_param_value('post_slides_document_from_template', 'template_path', 'string'), 'data' => $utils->get_param_value('post_slides_document_from_template', 'data', 'string'), 'template_password' => $utils->get_param_value('post_slides_document_from_template', 'template_password', 'string'), 'template_storage' => $utils->get_param_value('post_slides_document_from_template', 'template_storage', 'string'), 'is_image_data_embedded' => $utils->get_param_value('post_slides_document_from_template', 'is_image_data_embedded', 'boolean'), 'password' => $utils->get_param_value('post_slides_document_from_template', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_template', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_template', 'folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_document_from_template', 'storage', $params{ storage });
    $utils->initialize('post_slides_document_from_template', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_document_from_template(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_template', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_template', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_document_from_template', 'name', 'string'), 'template_path' => $utils->get_param_value('post_slides_document_from_template', 'template_path', 'string'), 'data' => $utils->get_param_value('post_slides_document_from_template', 'data', 'string'), 'template_password' => $utils->get_param_value('post_slides_document_from_template', 'template_password', 'string'), 'template_storage' => $utils->get_param_value('post_slides_document_from_template', 'template_storage', 'string'), 'is_image_data_embedded' => $utils->get_param_value('post_slides_document_from_template', 'is_image_data_embedded', 'boolean'), 'password' => $utils->get_param_value('post_slides_document_from_template', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_document_from_template', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_document_from_template', 'folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_document_from_template', 'folder', $params{ folder });
    $utils->initialize('post_slides_document_from_template', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_document_from_template(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_document_from_template', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_document_from_template', 'folder');
    }
}

#
# post_slides_pipeline test
#
{
    my %params = ('pipeline' => $utils->get_param_value('post_slides_pipeline', 'pipeline', 'Pipeline'));
    $utils->initialize('post_slides_pipeline', '');
    eval {
        my $result = $utils->{api}->post_slides_pipeline(%params);
    };
    if ($@) {
        fail("post_slides_pipeline raised an exception: $@");
    }
    pass();
}

{
    my %params = ('pipeline' => $utils->get_param_value('post_slides_pipeline', 'pipeline', 'Pipeline'));
    $params{ pipeline } = $utils->invalidize_param_value('post_slides_pipeline', 'pipeline', $params{ pipeline });
    $utils->initialize('post_slides_pipeline', 'pipeline', $params{ pipeline });

    eval {
        my $result = $utils->{api}->post_slides_pipeline(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_pipeline', 'pipeline', $params{ pipeline }, $@);
    } else {
        $utils->assert_no_error('post_slides_pipeline', 'pipeline');
    }
}

#
# post_slides_presentation_replace_text test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_presentation_replace_text', 'name', 'string'), 'old_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_presentation_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_presentation_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_presentation_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_presentation_replace_text', 'storage', 'string'));
    $utils->initialize('post_slides_presentation_replace_text', '');
    eval {
        my $result = $utils->{api}->post_slides_presentation_replace_text(%params);
    };
    if ($@) {
        fail("post_slides_presentation_replace_text raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_presentation_replace_text', 'name', 'string'), 'old_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_presentation_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_presentation_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_presentation_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_presentation_replace_text', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_presentation_replace_text', 'name', $params{ name });
    $utils->initialize('post_slides_presentation_replace_text', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_presentation_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_presentation_replace_text', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_presentation_replace_text', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_presentation_replace_text', 'name', 'string'), 'old_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_presentation_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_presentation_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_presentation_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_presentation_replace_text', 'storage', 'string'));
    $params{ old_value } = $utils->invalidize_param_value('post_slides_presentation_replace_text', 'old_value', $params{ old_value });
    $utils->initialize('post_slides_presentation_replace_text', 'old_value', $params{ old_value });

    eval {
        my $result = $utils->{api}->post_slides_presentation_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_presentation_replace_text', 'old_value', $params{ old_value }, $@);
    } else {
        $utils->assert_no_error('post_slides_presentation_replace_text', 'old_value');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_presentation_replace_text', 'name', 'string'), 'old_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_presentation_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_presentation_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_presentation_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_presentation_replace_text', 'storage', 'string'));
    $params{ new_value } = $utils->invalidize_param_value('post_slides_presentation_replace_text', 'new_value', $params{ new_value });
    $utils->initialize('post_slides_presentation_replace_text', 'new_value', $params{ new_value });

    eval {
        my $result = $utils->{api}->post_slides_presentation_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_presentation_replace_text', 'new_value', $params{ new_value }, $@);
    } else {
        $utils->assert_no_error('post_slides_presentation_replace_text', 'new_value');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_presentation_replace_text', 'name', 'string'), 'old_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_presentation_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_presentation_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_presentation_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_presentation_replace_text', 'storage', 'string'));
    $params{ ignore_case } = $utils->invalidize_param_value('post_slides_presentation_replace_text', 'ignore_case', $params{ ignore_case });
    $utils->initialize('post_slides_presentation_replace_text', 'ignore_case', $params{ ignore_case });

    eval {
        my $result = $utils->{api}->post_slides_presentation_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_presentation_replace_text', 'ignore_case', $params{ ignore_case }, $@);
    } else {
        $utils->assert_no_error('post_slides_presentation_replace_text', 'ignore_case');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_presentation_replace_text', 'name', 'string'), 'old_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_presentation_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_presentation_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_presentation_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_presentation_replace_text', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_presentation_replace_text', 'password', $params{ password });
    $utils->initialize('post_slides_presentation_replace_text', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_presentation_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_presentation_replace_text', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_presentation_replace_text', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_presentation_replace_text', 'name', 'string'), 'old_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_presentation_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_presentation_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_presentation_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_presentation_replace_text', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_presentation_replace_text', 'folder', $params{ folder });
    $utils->initialize('post_slides_presentation_replace_text', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_presentation_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_presentation_replace_text', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_presentation_replace_text', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_presentation_replace_text', 'name', 'string'), 'old_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_presentation_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_presentation_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_presentation_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_presentation_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_presentation_replace_text', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_presentation_replace_text', 'storage', $params{ storage });
    $utils->initialize('post_slides_presentation_replace_text', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_presentation_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_presentation_replace_text', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_presentation_replace_text', 'storage');
    }
}

#
# post_slides_reorder test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_reorder', 'slide_index', 'int'), 'new_position' => $utils->get_param_value('post_slides_reorder', 'new_position', 'int'), 'password' => $utils->get_param_value('post_slides_reorder', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder', 'storage', 'string'));
    $utils->initialize('post_slides_reorder', '');
    eval {
        my $result = $utils->{api}->post_slides_reorder(%params);
    };
    if ($@) {
        fail("post_slides_reorder raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_reorder', 'slide_index', 'int'), 'new_position' => $utils->get_param_value('post_slides_reorder', 'new_position', 'int'), 'password' => $utils->get_param_value('post_slides_reorder', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_reorder', 'name', $params{ name });
    $utils->initialize('post_slides_reorder', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_reorder(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_reorder', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_reorder', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_reorder', 'slide_index', 'int'), 'new_position' => $utils->get_param_value('post_slides_reorder', 'new_position', 'int'), 'password' => $utils->get_param_value('post_slides_reorder', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('post_slides_reorder', 'slide_index', $params{ slide_index });
    $utils->initialize('post_slides_reorder', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_slides_reorder(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_reorder', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_slides_reorder', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_reorder', 'slide_index', 'int'), 'new_position' => $utils->get_param_value('post_slides_reorder', 'new_position', 'int'), 'password' => $utils->get_param_value('post_slides_reorder', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder', 'storage', 'string'));
    $params{ new_position } = $utils->invalidize_param_value('post_slides_reorder', 'new_position', $params{ new_position });
    $utils->initialize('post_slides_reorder', 'new_position', $params{ new_position });

    eval {
        my $result = $utils->{api}->post_slides_reorder(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_reorder', 'new_position', $params{ new_position }, $@);
    } else {
        $utils->assert_no_error('post_slides_reorder', 'new_position');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_reorder', 'slide_index', 'int'), 'new_position' => $utils->get_param_value('post_slides_reorder', 'new_position', 'int'), 'password' => $utils->get_param_value('post_slides_reorder', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_reorder', 'password', $params{ password });
    $utils->initialize('post_slides_reorder', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_reorder(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_reorder', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_reorder', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_reorder', 'slide_index', 'int'), 'new_position' => $utils->get_param_value('post_slides_reorder', 'new_position', 'int'), 'password' => $utils->get_param_value('post_slides_reorder', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_reorder', 'folder', $params{ folder });
    $utils->initialize('post_slides_reorder', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_reorder(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_reorder', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_reorder', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_reorder', 'slide_index', 'int'), 'new_position' => $utils->get_param_value('post_slides_reorder', 'new_position', 'int'), 'password' => $utils->get_param_value('post_slides_reorder', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_reorder', 'storage', $params{ storage });
    $utils->initialize('post_slides_reorder', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_reorder(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_reorder', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_reorder', 'storage');
    }
}

#
# post_slides_reorder_many test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder_many', 'name', 'string'), 'old_positions' => $utils->get_param_value('post_slides_reorder_many', 'old_positions', 'string'), 'new_positions' => $utils->get_param_value('post_slides_reorder_many', 'new_positions', 'string'), 'password' => $utils->get_param_value('post_slides_reorder_many', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder_many', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder_many', 'storage', 'string'));
    $utils->initialize('post_slides_reorder_many', '');
    eval {
        my $result = $utils->{api}->post_slides_reorder_many(%params);
    };
    if ($@) {
        fail("post_slides_reorder_many raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder_many', 'name', 'string'), 'old_positions' => $utils->get_param_value('post_slides_reorder_many', 'old_positions', 'string'), 'new_positions' => $utils->get_param_value('post_slides_reorder_many', 'new_positions', 'string'), 'password' => $utils->get_param_value('post_slides_reorder_many', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder_many', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder_many', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_reorder_many', 'name', $params{ name });
    $utils->initialize('post_slides_reorder_many', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_reorder_many(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_reorder_many', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_reorder_many', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder_many', 'name', 'string'), 'old_positions' => $utils->get_param_value('post_slides_reorder_many', 'old_positions', 'string'), 'new_positions' => $utils->get_param_value('post_slides_reorder_many', 'new_positions', 'string'), 'password' => $utils->get_param_value('post_slides_reorder_many', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder_many', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder_many', 'storage', 'string'));
    $params{ old_positions } = $utils->invalidize_param_value('post_slides_reorder_many', 'old_positions', $params{ old_positions });
    $utils->initialize('post_slides_reorder_many', 'old_positions', $params{ old_positions });

    eval {
        my $result = $utils->{api}->post_slides_reorder_many(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_reorder_many', 'old_positions', $params{ old_positions }, $@);
    } else {
        $utils->assert_no_error('post_slides_reorder_many', 'old_positions');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder_many', 'name', 'string'), 'old_positions' => $utils->get_param_value('post_slides_reorder_many', 'old_positions', 'string'), 'new_positions' => $utils->get_param_value('post_slides_reorder_many', 'new_positions', 'string'), 'password' => $utils->get_param_value('post_slides_reorder_many', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder_many', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder_many', 'storage', 'string'));
    $params{ new_positions } = $utils->invalidize_param_value('post_slides_reorder_many', 'new_positions', $params{ new_positions });
    $utils->initialize('post_slides_reorder_many', 'new_positions', $params{ new_positions });

    eval {
        my $result = $utils->{api}->post_slides_reorder_many(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_reorder_many', 'new_positions', $params{ new_positions }, $@);
    } else {
        $utils->assert_no_error('post_slides_reorder_many', 'new_positions');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder_many', 'name', 'string'), 'old_positions' => $utils->get_param_value('post_slides_reorder_many', 'old_positions', 'string'), 'new_positions' => $utils->get_param_value('post_slides_reorder_many', 'new_positions', 'string'), 'password' => $utils->get_param_value('post_slides_reorder_many', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder_many', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder_many', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_reorder_many', 'password', $params{ password });
    $utils->initialize('post_slides_reorder_many', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_reorder_many(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_reorder_many', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_reorder_many', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder_many', 'name', 'string'), 'old_positions' => $utils->get_param_value('post_slides_reorder_many', 'old_positions', 'string'), 'new_positions' => $utils->get_param_value('post_slides_reorder_many', 'new_positions', 'string'), 'password' => $utils->get_param_value('post_slides_reorder_many', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder_many', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder_many', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_reorder_many', 'folder', $params{ folder });
    $utils->initialize('post_slides_reorder_many', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_reorder_many(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_reorder_many', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_reorder_many', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_reorder_many', 'name', 'string'), 'old_positions' => $utils->get_param_value('post_slides_reorder_many', 'old_positions', 'string'), 'new_positions' => $utils->get_param_value('post_slides_reorder_many', 'new_positions', 'string'), 'password' => $utils->get_param_value('post_slides_reorder_many', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_reorder_many', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_reorder_many', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_reorder_many', 'storage', $params{ storage });
    $utils->initialize('post_slides_reorder_many', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_reorder_many(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_reorder_many', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_reorder_many', 'storage');
    }
}

#
# post_slides_save_as test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_save_as', 'name', 'string'), 'format' => $utils->get_param_value('post_slides_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slides_save_as', 'options', 'ExportOptions'), 'password' => $utils->get_param_value('post_slides_save_as', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_save_as', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_save_as', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_save_as', 'fonts_folder', 'string'));
    $utils->initialize('post_slides_save_as', '');
    eval {
        my $result = $utils->{api}->post_slides_save_as(%params);
    };
    if ($@) {
        fail("post_slides_save_as raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_save_as', 'name', 'string'), 'format' => $utils->get_param_value('post_slides_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slides_save_as', 'options', 'ExportOptions'), 'password' => $utils->get_param_value('post_slides_save_as', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_save_as', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_save_as', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_save_as', 'fonts_folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_save_as', 'name', $params{ name });
    $utils->initialize('post_slides_save_as', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_save_as', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_save_as', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_save_as', 'name', 'string'), 'format' => $utils->get_param_value('post_slides_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slides_save_as', 'options', 'ExportOptions'), 'password' => $utils->get_param_value('post_slides_save_as', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_save_as', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_save_as', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_save_as', 'fonts_folder', 'string'));
    $params{ format } = $utils->invalidize_param_value('post_slides_save_as', 'format', $params{ format });
    $utils->initialize('post_slides_save_as', 'format', $params{ format });

    eval {
        my $result = $utils->{api}->post_slides_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_save_as', 'format', $params{ format }, $@);
    } else {
        $utils->assert_no_error('post_slides_save_as', 'format');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_save_as', 'name', 'string'), 'format' => $utils->get_param_value('post_slides_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slides_save_as', 'options', 'ExportOptions'), 'password' => $utils->get_param_value('post_slides_save_as', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_save_as', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_save_as', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_save_as', 'fonts_folder', 'string'));
    $params{ options } = $utils->invalidize_param_value('post_slides_save_as', 'options', $params{ options });
    $utils->initialize('post_slides_save_as', 'options', $params{ options });

    eval {
        my $result = $utils->{api}->post_slides_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_save_as', 'options', $params{ options }, $@);
    } else {
        $utils->assert_no_error('post_slides_save_as', 'options');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_save_as', 'name', 'string'), 'format' => $utils->get_param_value('post_slides_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slides_save_as', 'options', 'ExportOptions'), 'password' => $utils->get_param_value('post_slides_save_as', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_save_as', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_save_as', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_save_as', 'fonts_folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_save_as', 'password', $params{ password });
    $utils->initialize('post_slides_save_as', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_save_as', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_save_as', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_save_as', 'name', 'string'), 'format' => $utils->get_param_value('post_slides_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slides_save_as', 'options', 'ExportOptions'), 'password' => $utils->get_param_value('post_slides_save_as', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_save_as', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_save_as', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_save_as', 'fonts_folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_save_as', 'storage', $params{ storage });
    $utils->initialize('post_slides_save_as', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_save_as', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_save_as', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_save_as', 'name', 'string'), 'format' => $utils->get_param_value('post_slides_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slides_save_as', 'options', 'ExportOptions'), 'password' => $utils->get_param_value('post_slides_save_as', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_save_as', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_save_as', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_save_as', 'fonts_folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_save_as', 'folder', $params{ folder });
    $utils->initialize('post_slides_save_as', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_save_as', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_save_as', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_save_as', 'name', 'string'), 'format' => $utils->get_param_value('post_slides_save_as', 'format', 'string'), 'options' => $utils->get_param_value('post_slides_save_as', 'options', 'ExportOptions'), 'password' => $utils->get_param_value('post_slides_save_as', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_save_as', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_save_as', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_save_as', 'fonts_folder', 'string'));
    $params{ fonts_folder } = $utils->invalidize_param_value('post_slides_save_as', 'fonts_folder', $params{ fonts_folder });
    $utils->initialize('post_slides_save_as', 'fonts_folder', $params{ fonts_folder });

    eval {
        my $result = $utils->{api}->post_slides_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_save_as', 'fonts_folder', $params{ fonts_folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_save_as', 'fonts_folder');
    }
}

#
# post_slides_set_document_properties test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_set_document_properties', 'name', 'string'), 'properties' => $utils->get_param_value('post_slides_set_document_properties', 'properties', 'DocumentProperties'), 'password' => $utils->get_param_value('post_slides_set_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_set_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_set_document_properties', 'storage', 'string'));
    $utils->initialize('post_slides_set_document_properties', '');
    eval {
        my $result = $utils->{api}->post_slides_set_document_properties(%params);
    };
    if ($@) {
        fail("post_slides_set_document_properties raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_set_document_properties', 'name', 'string'), 'properties' => $utils->get_param_value('post_slides_set_document_properties', 'properties', 'DocumentProperties'), 'password' => $utils->get_param_value('post_slides_set_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_set_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_set_document_properties', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_set_document_properties', 'name', $params{ name });
    $utils->initialize('post_slides_set_document_properties', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_set_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_set_document_properties', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_set_document_properties', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_set_document_properties', 'name', 'string'), 'properties' => $utils->get_param_value('post_slides_set_document_properties', 'properties', 'DocumentProperties'), 'password' => $utils->get_param_value('post_slides_set_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_set_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_set_document_properties', 'storage', 'string'));
    $params{ properties } = $utils->invalidize_param_value('post_slides_set_document_properties', 'properties', $params{ properties });
    $utils->initialize('post_slides_set_document_properties', 'properties', $params{ properties });

    eval {
        my $result = $utils->{api}->post_slides_set_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_set_document_properties', 'properties', $params{ properties }, $@);
    } else {
        $utils->assert_no_error('post_slides_set_document_properties', 'properties');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_set_document_properties', 'name', 'string'), 'properties' => $utils->get_param_value('post_slides_set_document_properties', 'properties', 'DocumentProperties'), 'password' => $utils->get_param_value('post_slides_set_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_set_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_set_document_properties', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_set_document_properties', 'password', $params{ password });
    $utils->initialize('post_slides_set_document_properties', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_set_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_set_document_properties', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_set_document_properties', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_set_document_properties', 'name', 'string'), 'properties' => $utils->get_param_value('post_slides_set_document_properties', 'properties', 'DocumentProperties'), 'password' => $utils->get_param_value('post_slides_set_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_set_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_set_document_properties', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_set_document_properties', 'folder', $params{ folder });
    $utils->initialize('post_slides_set_document_properties', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_set_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_set_document_properties', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_set_document_properties', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_set_document_properties', 'name', 'string'), 'properties' => $utils->get_param_value('post_slides_set_document_properties', 'properties', 'DocumentProperties'), 'password' => $utils->get_param_value('post_slides_set_document_properties', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_set_document_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_set_document_properties', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_set_document_properties', 'storage', $params{ storage });
    $utils->initialize('post_slides_set_document_properties', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_set_document_properties(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_set_document_properties', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_set_document_properties', 'storage');
    }
}

#
# post_slides_slide_replace_text test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_slide_replace_text', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_slide_replace_text', 'slide_index', 'int'), 'old_value' => $utils->get_param_value('post_slides_slide_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_slide_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_slide_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_slide_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_slide_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_slide_replace_text', 'storage', 'string'));
    $utils->initialize('post_slides_slide_replace_text', '');
    eval {
        my $result = $utils->{api}->post_slides_slide_replace_text(%params);
    };
    if ($@) {
        fail("post_slides_slide_replace_text raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_slide_replace_text', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_slide_replace_text', 'slide_index', 'int'), 'old_value' => $utils->get_param_value('post_slides_slide_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_slide_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_slide_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_slide_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_slide_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_slide_replace_text', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_slide_replace_text', 'name', $params{ name });
    $utils->initialize('post_slides_slide_replace_text', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_slide_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_slide_replace_text', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_slide_replace_text', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_slide_replace_text', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_slide_replace_text', 'slide_index', 'int'), 'old_value' => $utils->get_param_value('post_slides_slide_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_slide_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_slide_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_slide_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_slide_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_slide_replace_text', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('post_slides_slide_replace_text', 'slide_index', $params{ slide_index });
    $utils->initialize('post_slides_slide_replace_text', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->post_slides_slide_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_slide_replace_text', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('post_slides_slide_replace_text', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_slide_replace_text', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_slide_replace_text', 'slide_index', 'int'), 'old_value' => $utils->get_param_value('post_slides_slide_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_slide_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_slide_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_slide_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_slide_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_slide_replace_text', 'storage', 'string'));
    $params{ old_value } = $utils->invalidize_param_value('post_slides_slide_replace_text', 'old_value', $params{ old_value });
    $utils->initialize('post_slides_slide_replace_text', 'old_value', $params{ old_value });

    eval {
        my $result = $utils->{api}->post_slides_slide_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_slide_replace_text', 'old_value', $params{ old_value }, $@);
    } else {
        $utils->assert_no_error('post_slides_slide_replace_text', 'old_value');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_slide_replace_text', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_slide_replace_text', 'slide_index', 'int'), 'old_value' => $utils->get_param_value('post_slides_slide_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_slide_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_slide_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_slide_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_slide_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_slide_replace_text', 'storage', 'string'));
    $params{ new_value } = $utils->invalidize_param_value('post_slides_slide_replace_text', 'new_value', $params{ new_value });
    $utils->initialize('post_slides_slide_replace_text', 'new_value', $params{ new_value });

    eval {
        my $result = $utils->{api}->post_slides_slide_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_slide_replace_text', 'new_value', $params{ new_value }, $@);
    } else {
        $utils->assert_no_error('post_slides_slide_replace_text', 'new_value');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_slide_replace_text', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_slide_replace_text', 'slide_index', 'int'), 'old_value' => $utils->get_param_value('post_slides_slide_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_slide_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_slide_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_slide_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_slide_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_slide_replace_text', 'storage', 'string'));
    $params{ ignore_case } = $utils->invalidize_param_value('post_slides_slide_replace_text', 'ignore_case', $params{ ignore_case });
    $utils->initialize('post_slides_slide_replace_text', 'ignore_case', $params{ ignore_case });

    eval {
        my $result = $utils->{api}->post_slides_slide_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_slide_replace_text', 'ignore_case', $params{ ignore_case }, $@);
    } else {
        $utils->assert_no_error('post_slides_slide_replace_text', 'ignore_case');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_slide_replace_text', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_slide_replace_text', 'slide_index', 'int'), 'old_value' => $utils->get_param_value('post_slides_slide_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_slide_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_slide_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_slide_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_slide_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_slide_replace_text', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_slide_replace_text', 'password', $params{ password });
    $utils->initialize('post_slides_slide_replace_text', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_slide_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_slide_replace_text', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_slide_replace_text', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_slide_replace_text', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_slide_replace_text', 'slide_index', 'int'), 'old_value' => $utils->get_param_value('post_slides_slide_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_slide_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_slide_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_slide_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_slide_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_slide_replace_text', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_slide_replace_text', 'folder', $params{ folder });
    $utils->initialize('post_slides_slide_replace_text', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_slide_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_slide_replace_text', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_slide_replace_text', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_slide_replace_text', 'name', 'string'), 'slide_index' => $utils->get_param_value('post_slides_slide_replace_text', 'slide_index', 'int'), 'old_value' => $utils->get_param_value('post_slides_slide_replace_text', 'old_value', 'string'), 'new_value' => $utils->get_param_value('post_slides_slide_replace_text', 'new_value', 'string'), 'ignore_case' => $utils->get_param_value('post_slides_slide_replace_text', 'ignore_case', 'boolean'), 'password' => $utils->get_param_value('post_slides_slide_replace_text', 'password', 'string'), 'folder' => $utils->get_param_value('post_slides_slide_replace_text', 'folder', 'string'), 'storage' => $utils->get_param_value('post_slides_slide_replace_text', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_slide_replace_text', 'storage', $params{ storage });
    $utils->initialize('post_slides_slide_replace_text', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_slide_replace_text(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_slide_replace_text', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_slide_replace_text', 'storage');
    }
}

#
# post_slides_split test
#
{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $utils->initialize('post_slides_split', '');
    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        fail("post_slides_split raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('post_slides_split', 'name', $params{ name });
    $utils->initialize('post_slides_split', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_split', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('post_slides_split', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $params{ options } = $utils->invalidize_param_value('post_slides_split', 'options', $params{ options });
    $utils->initialize('post_slides_split', 'options', $params{ options });

    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_split', 'options', $params{ options }, $@);
    } else {
        $utils->assert_no_error('post_slides_split', 'options');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $params{ format } = $utils->invalidize_param_value('post_slides_split', 'format', $params{ format });
    $utils->initialize('post_slides_split', 'format', $params{ format });

    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_split', 'format', $params{ format }, $@);
    } else {
        $utils->assert_no_error('post_slides_split', 'format');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $params{ width } = $utils->invalidize_param_value('post_slides_split', 'width', $params{ width });
    $utils->initialize('post_slides_split', 'width', $params{ width });

    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_split', 'width', $params{ width }, $@);
    } else {
        $utils->assert_no_error('post_slides_split', 'width');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $params{ height } = $utils->invalidize_param_value('post_slides_split', 'height', $params{ height });
    $utils->initialize('post_slides_split', 'height', $params{ height });

    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_split', 'height', $params{ height }, $@);
    } else {
        $utils->assert_no_error('post_slides_split', 'height');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $params{ to } = $utils->invalidize_param_value('post_slides_split', 'to', $params{ to });
    $utils->initialize('post_slides_split', 'to', $params{ to });

    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_split', 'to', $params{ to }, $@);
    } else {
        $utils->assert_no_error('post_slides_split', 'to');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $params{ from } = $utils->invalidize_param_value('post_slides_split', 'from', $params{ from });
    $utils->initialize('post_slides_split', 'from', $params{ from });

    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_split', 'from', $params{ from }, $@);
    } else {
        $utils->assert_no_error('post_slides_split', 'from');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $params{ dest_folder } = $utils->invalidize_param_value('post_slides_split', 'dest_folder', $params{ dest_folder });
    $utils->initialize('post_slides_split', 'dest_folder', $params{ dest_folder });

    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_split', 'dest_folder', $params{ dest_folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_split', 'dest_folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('post_slides_split', 'password', $params{ password });
    $utils->initialize('post_slides_split', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_split', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('post_slides_split', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('post_slides_split', 'storage', $params{ storage });
    $utils->initialize('post_slides_split', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_split', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('post_slides_split', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('post_slides_split', 'folder', $params{ folder });
    $utils->initialize('post_slides_split', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_split', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_split', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('post_slides_split', 'name', 'string'), 'options' => $utils->get_param_value('post_slides_split', 'options', 'ExportOptions'), 'format' => $utils->get_param_value('post_slides_split', 'format', 'string'), 'width' => $utils->get_param_value('post_slides_split', 'width', 'int'), 'height' => $utils->get_param_value('post_slides_split', 'height', 'int'), 'to' => $utils->get_param_value('post_slides_split', 'to', 'int'), 'from' => $utils->get_param_value('post_slides_split', 'from', 'int'), 'dest_folder' => $utils->get_param_value('post_slides_split', 'dest_folder', 'string'), 'password' => $utils->get_param_value('post_slides_split', 'password', 'string'), 'storage' => $utils->get_param_value('post_slides_split', 'storage', 'string'), 'folder' => $utils->get_param_value('post_slides_split', 'folder', 'string'), 'fonts_folder' => $utils->get_param_value('post_slides_split', 'fonts_folder', 'string'));
    $params{ fonts_folder } = $utils->invalidize_param_value('post_slides_split', 'fonts_folder', $params{ fonts_folder });
    $utils->initialize('post_slides_split', 'fonts_folder', $params{ fonts_folder });

    eval {
        my $result = $utils->{api}->post_slides_split(%params);
    };
    if ($@) {
        $utils->assert_error('post_slides_split', 'fonts_folder', $params{ fonts_folder }, $@);
    } else {
        $utils->assert_no_error('post_slides_split', 'fonts_folder');
    }
}

#
# put_layout_slide test
#
{
    my %params = ('name' => $utils->get_param_value('put_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_layout_slide', 'slide_index', 'int'), 'slide_dto' => $utils->get_param_value('put_layout_slide', 'slide_dto', 'LayoutSlide'), 'password' => $utils->get_param_value('put_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('put_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('put_layout_slide', 'storage', 'string'));
    $utils->initialize('put_layout_slide', '');
    eval {
        my $result = $utils->{api}->put_layout_slide(%params);
    };
    if ($@) {
        fail("put_layout_slide raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('put_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_layout_slide', 'slide_index', 'int'), 'slide_dto' => $utils->get_param_value('put_layout_slide', 'slide_dto', 'LayoutSlide'), 'password' => $utils->get_param_value('put_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('put_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('put_layout_slide', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('put_layout_slide', 'name', $params{ name });
    $utils->initialize('put_layout_slide', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->put_layout_slide(%params);
    };
    if ($@) {
        $utils->assert_error('put_layout_slide', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('put_layout_slide', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_layout_slide', 'slide_index', 'int'), 'slide_dto' => $utils->get_param_value('put_layout_slide', 'slide_dto', 'LayoutSlide'), 'password' => $utils->get_param_value('put_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('put_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('put_layout_slide', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('put_layout_slide', 'slide_index', $params{ slide_index });
    $utils->initialize('put_layout_slide', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->put_layout_slide(%params);
    };
    if ($@) {
        $utils->assert_error('put_layout_slide', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('put_layout_slide', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_layout_slide', 'slide_index', 'int'), 'slide_dto' => $utils->get_param_value('put_layout_slide', 'slide_dto', 'LayoutSlide'), 'password' => $utils->get_param_value('put_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('put_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('put_layout_slide', 'storage', 'string'));
    $params{ slide_dto } = $utils->invalidize_param_value('put_layout_slide', 'slide_dto', $params{ slide_dto });
    $utils->initialize('put_layout_slide', 'slide_dto', $params{ slide_dto });

    eval {
        my $result = $utils->{api}->put_layout_slide(%params);
    };
    if ($@) {
        $utils->assert_error('put_layout_slide', 'slide_dto', $params{ slide_dto }, $@);
    } else {
        $utils->assert_no_error('put_layout_slide', 'slide_dto');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_layout_slide', 'slide_index', 'int'), 'slide_dto' => $utils->get_param_value('put_layout_slide', 'slide_dto', 'LayoutSlide'), 'password' => $utils->get_param_value('put_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('put_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('put_layout_slide', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('put_layout_slide', 'password', $params{ password });
    $utils->initialize('put_layout_slide', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->put_layout_slide(%params);
    };
    if ($@) {
        $utils->assert_error('put_layout_slide', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('put_layout_slide', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_layout_slide', 'slide_index', 'int'), 'slide_dto' => $utils->get_param_value('put_layout_slide', 'slide_dto', 'LayoutSlide'), 'password' => $utils->get_param_value('put_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('put_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('put_layout_slide', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('put_layout_slide', 'folder', $params{ folder });
    $utils->initialize('put_layout_slide', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->put_layout_slide(%params);
    };
    if ($@) {
        $utils->assert_error('put_layout_slide', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('put_layout_slide', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_layout_slide', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_layout_slide', 'slide_index', 'int'), 'slide_dto' => $utils->get_param_value('put_layout_slide', 'slide_dto', 'LayoutSlide'), 'password' => $utils->get_param_value('put_layout_slide', 'password', 'string'), 'folder' => $utils->get_param_value('put_layout_slide', 'folder', 'string'), 'storage' => $utils->get_param_value('put_layout_slide', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('put_layout_slide', 'storage', $params{ storage });
    $utils->initialize('put_layout_slide', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->put_layout_slide(%params);
    };
    if ($@) {
        $utils->assert_error('put_layout_slide', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('put_layout_slide', 'storage');
    }
}

#
# put_notes_slide_shape_save_as test
#
{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $utils->initialize('put_notes_slide_shape_save_as', '');
    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        fail("put_notes_slide_shape_save_as raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'name', $params{ name });
    $utils->initialize('put_notes_slide_shape_save_as', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'slide_index', $params{ slide_index });
    $utils->initialize('put_notes_slide_shape_save_as', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ path } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'path', $params{ path });
    $utils->initialize('put_notes_slide_shape_save_as', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'shape_index', $params{ shape_index });
    $utils->initialize('put_notes_slide_shape_save_as', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ format } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'format', $params{ format });
    $utils->initialize('put_notes_slide_shape_save_as', 'format', $params{ format });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'format', $params{ format }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'format');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ out_path } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'out_path', $params{ out_path });
    $utils->initialize('put_notes_slide_shape_save_as', 'out_path', $params{ out_path });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'out_path', $params{ out_path }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'out_path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ options } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'options', $params{ options });
    $utils->initialize('put_notes_slide_shape_save_as', 'options', $params{ options });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'options', $params{ options }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'options');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'password', $params{ password });
    $utils->initialize('put_notes_slide_shape_save_as', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'folder', $params{ folder });
    $utils->initialize('put_notes_slide_shape_save_as', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'storage', $params{ storage });
    $utils->initialize('put_notes_slide_shape_save_as', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ scale_x } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'scale_x', $params{ scale_x });
    $utils->initialize('put_notes_slide_shape_save_as', 'scale_x', $params{ scale_x });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'scale_x', $params{ scale_x }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'scale_x');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ scale_y } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'scale_y', $params{ scale_y });
    $utils->initialize('put_notes_slide_shape_save_as', 'scale_y', $params{ scale_y });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'scale_y', $params{ scale_y }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'scale_y');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ bounds } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'bounds', $params{ bounds });
    $utils->initialize('put_notes_slide_shape_save_as', 'bounds', $params{ bounds });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'bounds', $params{ bounds }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'bounds');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_notes_slide_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_notes_slide_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_notes_slide_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_notes_slide_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_notes_slide_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_notes_slide_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_notes_slide_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_notes_slide_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_notes_slide_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_notes_slide_shape_save_as', 'fonts_folder', 'string'));
    $params{ fonts_folder } = $utils->invalidize_param_value('put_notes_slide_shape_save_as', 'fonts_folder', $params{ fonts_folder });
    $utils->initialize('put_notes_slide_shape_save_as', 'fonts_folder', $params{ fonts_folder });

    eval {
        my $result = $utils->{api}->put_notes_slide_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_notes_slide_shape_save_as', 'fonts_folder', $params{ fonts_folder }, $@);
    } else {
        $utils->assert_no_error('put_notes_slide_shape_save_as', 'fonts_folder');
    }
}

#
# put_presentation_merge test
#
{
    my %params = ('name' => $utils->get_param_value('put_presentation_merge', 'name', 'string'), 'request' => $utils->get_param_value('put_presentation_merge', 'request', 'OrderedMergeRequest'), 'password' => $utils->get_param_value('put_presentation_merge', 'password', 'string'), 'storage' => $utils->get_param_value('put_presentation_merge', 'storage', 'string'), 'folder' => $utils->get_param_value('put_presentation_merge', 'folder', 'string'));
    $utils->initialize('put_presentation_merge', '');
    eval {
        my $result = $utils->{api}->put_presentation_merge(%params);
    };
    if ($@) {
        fail("put_presentation_merge raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('put_presentation_merge', 'name', 'string'), 'request' => $utils->get_param_value('put_presentation_merge', 'request', 'OrderedMergeRequest'), 'password' => $utils->get_param_value('put_presentation_merge', 'password', 'string'), 'storage' => $utils->get_param_value('put_presentation_merge', 'storage', 'string'), 'folder' => $utils->get_param_value('put_presentation_merge', 'folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('put_presentation_merge', 'name', $params{ name });
    $utils->initialize('put_presentation_merge', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->put_presentation_merge(%params);
    };
    if ($@) {
        $utils->assert_error('put_presentation_merge', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('put_presentation_merge', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_presentation_merge', 'name', 'string'), 'request' => $utils->get_param_value('put_presentation_merge', 'request', 'OrderedMergeRequest'), 'password' => $utils->get_param_value('put_presentation_merge', 'password', 'string'), 'storage' => $utils->get_param_value('put_presentation_merge', 'storage', 'string'), 'folder' => $utils->get_param_value('put_presentation_merge', 'folder', 'string'));
    $params{ request } = $utils->invalidize_param_value('put_presentation_merge', 'request', $params{ request });
    $utils->initialize('put_presentation_merge', 'request', $params{ request });

    eval {
        my $result = $utils->{api}->put_presentation_merge(%params);
    };
    if ($@) {
        $utils->assert_error('put_presentation_merge', 'request', $params{ request }, $@);
    } else {
        $utils->assert_no_error('put_presentation_merge', 'request');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_presentation_merge', 'name', 'string'), 'request' => $utils->get_param_value('put_presentation_merge', 'request', 'OrderedMergeRequest'), 'password' => $utils->get_param_value('put_presentation_merge', 'password', 'string'), 'storage' => $utils->get_param_value('put_presentation_merge', 'storage', 'string'), 'folder' => $utils->get_param_value('put_presentation_merge', 'folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('put_presentation_merge', 'password', $params{ password });
    $utils->initialize('put_presentation_merge', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->put_presentation_merge(%params);
    };
    if ($@) {
        $utils->assert_error('put_presentation_merge', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('put_presentation_merge', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_presentation_merge', 'name', 'string'), 'request' => $utils->get_param_value('put_presentation_merge', 'request', 'OrderedMergeRequest'), 'password' => $utils->get_param_value('put_presentation_merge', 'password', 'string'), 'storage' => $utils->get_param_value('put_presentation_merge', 'storage', 'string'), 'folder' => $utils->get_param_value('put_presentation_merge', 'folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('put_presentation_merge', 'storage', $params{ storage });
    $utils->initialize('put_presentation_merge', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->put_presentation_merge(%params);
    };
    if ($@) {
        $utils->assert_error('put_presentation_merge', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('put_presentation_merge', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_presentation_merge', 'name', 'string'), 'request' => $utils->get_param_value('put_presentation_merge', 'request', 'OrderedMergeRequest'), 'password' => $utils->get_param_value('put_presentation_merge', 'password', 'string'), 'storage' => $utils->get_param_value('put_presentation_merge', 'storage', 'string'), 'folder' => $utils->get_param_value('put_presentation_merge', 'folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('put_presentation_merge', 'folder', $params{ folder });
    $utils->initialize('put_presentation_merge', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->put_presentation_merge(%params);
    };
    if ($@) {
        $utils->assert_error('put_presentation_merge', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('put_presentation_merge', 'folder');
    }
}

#
# put_set_paragraph_portion_properties test
#
{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_portion_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_portion_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'portion_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_portion_properties', 'dto', 'Portion'), 'password' => $utils->get_param_value('put_set_paragraph_portion_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_portion_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_portion_properties', 'storage', 'string'));
    $utils->initialize('put_set_paragraph_portion_properties', '');
    eval {
        my $result = $utils->{api}->put_set_paragraph_portion_properties(%params);
    };
    if ($@) {
        fail("put_set_paragraph_portion_properties raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_portion_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_portion_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'portion_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_portion_properties', 'dto', 'Portion'), 'password' => $utils->get_param_value('put_set_paragraph_portion_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_portion_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_portion_properties', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('put_set_paragraph_portion_properties', 'name', $params{ name });
    $utils->initialize('put_set_paragraph_portion_properties', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->put_set_paragraph_portion_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_portion_properties', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_portion_properties', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_portion_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_portion_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'portion_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_portion_properties', 'dto', 'Portion'), 'password' => $utils->get_param_value('put_set_paragraph_portion_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_portion_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_portion_properties', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('put_set_paragraph_portion_properties', 'slide_index', $params{ slide_index });
    $utils->initialize('put_set_paragraph_portion_properties', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->put_set_paragraph_portion_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_portion_properties', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_portion_properties', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_portion_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_portion_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'portion_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_portion_properties', 'dto', 'Portion'), 'password' => $utils->get_param_value('put_set_paragraph_portion_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_portion_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_portion_properties', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('put_set_paragraph_portion_properties', 'path', $params{ path });
    $utils->initialize('put_set_paragraph_portion_properties', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->put_set_paragraph_portion_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_portion_properties', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_portion_properties', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_portion_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_portion_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'portion_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_portion_properties', 'dto', 'Portion'), 'password' => $utils->get_param_value('put_set_paragraph_portion_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_portion_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_portion_properties', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('put_set_paragraph_portion_properties', 'shape_index', $params{ shape_index });
    $utils->initialize('put_set_paragraph_portion_properties', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->put_set_paragraph_portion_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_portion_properties', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_portion_properties', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_portion_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_portion_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'portion_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_portion_properties', 'dto', 'Portion'), 'password' => $utils->get_param_value('put_set_paragraph_portion_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_portion_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_portion_properties', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('put_set_paragraph_portion_properties', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('put_set_paragraph_portion_properties', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->put_set_paragraph_portion_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_portion_properties', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_portion_properties', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_portion_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_portion_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'portion_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_portion_properties', 'dto', 'Portion'), 'password' => $utils->get_param_value('put_set_paragraph_portion_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_portion_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_portion_properties', 'storage', 'string'));
    $params{ portion_index } = $utils->invalidize_param_value('put_set_paragraph_portion_properties', 'portion_index', $params{ portion_index });
    $utils->initialize('put_set_paragraph_portion_properties', 'portion_index', $params{ portion_index });

    eval {
        my $result = $utils->{api}->put_set_paragraph_portion_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_portion_properties', 'portion_index', $params{ portion_index }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_portion_properties', 'portion_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_portion_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_portion_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'portion_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_portion_properties', 'dto', 'Portion'), 'password' => $utils->get_param_value('put_set_paragraph_portion_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_portion_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_portion_properties', 'storage', 'string'));
    $params{ dto } = $utils->invalidize_param_value('put_set_paragraph_portion_properties', 'dto', $params{ dto });
    $utils->initialize('put_set_paragraph_portion_properties', 'dto', $params{ dto });

    eval {
        my $result = $utils->{api}->put_set_paragraph_portion_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_portion_properties', 'dto', $params{ dto }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_portion_properties', 'dto');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_portion_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_portion_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'portion_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_portion_properties', 'dto', 'Portion'), 'password' => $utils->get_param_value('put_set_paragraph_portion_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_portion_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_portion_properties', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('put_set_paragraph_portion_properties', 'password', $params{ password });
    $utils->initialize('put_set_paragraph_portion_properties', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->put_set_paragraph_portion_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_portion_properties', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_portion_properties', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_portion_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_portion_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'portion_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_portion_properties', 'dto', 'Portion'), 'password' => $utils->get_param_value('put_set_paragraph_portion_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_portion_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_portion_properties', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('put_set_paragraph_portion_properties', 'folder', $params{ folder });
    $utils->initialize('put_set_paragraph_portion_properties', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->put_set_paragraph_portion_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_portion_properties', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_portion_properties', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_portion_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_portion_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'paragraph_index', 'int'), 'portion_index' => $utils->get_param_value('put_set_paragraph_portion_properties', 'portion_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_portion_properties', 'dto', 'Portion'), 'password' => $utils->get_param_value('put_set_paragraph_portion_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_portion_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_portion_properties', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('put_set_paragraph_portion_properties', 'storage', $params{ storage });
    $utils->initialize('put_set_paragraph_portion_properties', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->put_set_paragraph_portion_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_portion_properties', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_portion_properties', 'storage');
    }
}

#
# put_set_paragraph_properties test
#
{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_properties', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_properties', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('put_set_paragraph_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_properties', 'storage', 'string'));
    $utils->initialize('put_set_paragraph_properties', '');
    eval {
        my $result = $utils->{api}->put_set_paragraph_properties(%params);
    };
    if ($@) {
        fail("put_set_paragraph_properties raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_properties', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_properties', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('put_set_paragraph_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_properties', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('put_set_paragraph_properties', 'name', $params{ name });
    $utils->initialize('put_set_paragraph_properties', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->put_set_paragraph_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_properties', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_properties', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_properties', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_properties', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('put_set_paragraph_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_properties', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('put_set_paragraph_properties', 'slide_index', $params{ slide_index });
    $utils->initialize('put_set_paragraph_properties', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->put_set_paragraph_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_properties', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_properties', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_properties', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_properties', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('put_set_paragraph_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_properties', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('put_set_paragraph_properties', 'path', $params{ path });
    $utils->initialize('put_set_paragraph_properties', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->put_set_paragraph_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_properties', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_properties', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_properties', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_properties', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('put_set_paragraph_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_properties', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('put_set_paragraph_properties', 'shape_index', $params{ shape_index });
    $utils->initialize('put_set_paragraph_properties', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->put_set_paragraph_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_properties', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_properties', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_properties', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_properties', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('put_set_paragraph_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_properties', 'storage', 'string'));
    $params{ paragraph_index } = $utils->invalidize_param_value('put_set_paragraph_properties', 'paragraph_index', $params{ paragraph_index });
    $utils->initialize('put_set_paragraph_properties', 'paragraph_index', $params{ paragraph_index });

    eval {
        my $result = $utils->{api}->put_set_paragraph_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_properties', 'paragraph_index', $params{ paragraph_index }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_properties', 'paragraph_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_properties', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_properties', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('put_set_paragraph_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_properties', 'storage', 'string'));
    $params{ dto } = $utils->invalidize_param_value('put_set_paragraph_properties', 'dto', $params{ dto });
    $utils->initialize('put_set_paragraph_properties', 'dto', $params{ dto });

    eval {
        my $result = $utils->{api}->put_set_paragraph_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_properties', 'dto', $params{ dto }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_properties', 'dto');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_properties', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_properties', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('put_set_paragraph_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_properties', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('put_set_paragraph_properties', 'password', $params{ password });
    $utils->initialize('put_set_paragraph_properties', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->put_set_paragraph_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_properties', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_properties', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_properties', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_properties', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('put_set_paragraph_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_properties', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('put_set_paragraph_properties', 'folder', $params{ folder });
    $utils->initialize('put_set_paragraph_properties', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->put_set_paragraph_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_properties', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_properties', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_set_paragraph_properties', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_set_paragraph_properties', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_set_paragraph_properties', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_set_paragraph_properties', 'shape_index', 'int'), 'paragraph_index' => $utils->get_param_value('put_set_paragraph_properties', 'paragraph_index', 'int'), 'dto' => $utils->get_param_value('put_set_paragraph_properties', 'dto', 'Paragraph'), 'password' => $utils->get_param_value('put_set_paragraph_properties', 'password', 'string'), 'folder' => $utils->get_param_value('put_set_paragraph_properties', 'folder', 'string'), 'storage' => $utils->get_param_value('put_set_paragraph_properties', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('put_set_paragraph_properties', 'storage', $params{ storage });
    $utils->initialize('put_set_paragraph_properties', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->put_set_paragraph_properties(%params);
    };
    if ($@) {
        $utils->assert_error('put_set_paragraph_properties', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('put_set_paragraph_properties', 'storage');
    }
}

#
# put_shape_save_as test
#
{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $utils->initialize('put_shape_save_as', '');
    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        fail("put_shape_save_as raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('put_shape_save_as', 'name', $params{ name });
    $utils->initialize('put_shape_save_as', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('put_shape_save_as', 'slide_index', $params{ slide_index });
    $utils->initialize('put_shape_save_as', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ path } = $utils->invalidize_param_value('put_shape_save_as', 'path', $params{ path });
    $utils->initialize('put_shape_save_as', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('put_shape_save_as', 'shape_index', $params{ shape_index });
    $utils->initialize('put_shape_save_as', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ format } = $utils->invalidize_param_value('put_shape_save_as', 'format', $params{ format });
    $utils->initialize('put_shape_save_as', 'format', $params{ format });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'format', $params{ format }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'format');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ out_path } = $utils->invalidize_param_value('put_shape_save_as', 'out_path', $params{ out_path });
    $utils->initialize('put_shape_save_as', 'out_path', $params{ out_path });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'out_path', $params{ out_path }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'out_path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ options } = $utils->invalidize_param_value('put_shape_save_as', 'options', $params{ options });
    $utils->initialize('put_shape_save_as', 'options', $params{ options });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'options', $params{ options }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'options');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('put_shape_save_as', 'password', $params{ password });
    $utils->initialize('put_shape_save_as', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('put_shape_save_as', 'folder', $params{ folder });
    $utils->initialize('put_shape_save_as', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('put_shape_save_as', 'storage', $params{ storage });
    $utils->initialize('put_shape_save_as', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ scale_x } = $utils->invalidize_param_value('put_shape_save_as', 'scale_x', $params{ scale_x });
    $utils->initialize('put_shape_save_as', 'scale_x', $params{ scale_x });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'scale_x', $params{ scale_x }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'scale_x');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ scale_y } = $utils->invalidize_param_value('put_shape_save_as', 'scale_y', $params{ scale_y });
    $utils->initialize('put_shape_save_as', 'scale_y', $params{ scale_y });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'scale_y', $params{ scale_y }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'scale_y');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ bounds } = $utils->invalidize_param_value('put_shape_save_as', 'bounds', $params{ bounds });
    $utils->initialize('put_shape_save_as', 'bounds', $params{ bounds });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'bounds', $params{ bounds }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'bounds');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_shape_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_shape_save_as', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_shape_save_as', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_shape_save_as', 'shape_index', 'int'), 'format' => $utils->get_param_value('put_shape_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_shape_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_shape_save_as', 'options', 'IShapeExportOptions'), 'password' => $utils->get_param_value('put_shape_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_shape_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_shape_save_as', 'storage', 'string'), 'scale_x' => $utils->get_param_value('put_shape_save_as', 'scale_x', 'double'), 'scale_y' => $utils->get_param_value('put_shape_save_as', 'scale_y', 'double'), 'bounds' => $utils->get_param_value('put_shape_save_as', 'bounds', 'string'), 'fonts_folder' => $utils->get_param_value('put_shape_save_as', 'fonts_folder', 'string'));
    $params{ fonts_folder } = $utils->invalidize_param_value('put_shape_save_as', 'fonts_folder', $params{ fonts_folder });
    $utils->initialize('put_shape_save_as', 'fonts_folder', $params{ fonts_folder });

    eval {
        my $result = $utils->{api}->put_shape_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_shape_save_as', 'fonts_folder', $params{ fonts_folder }, $@);
    } else {
        $utils->assert_no_error('put_shape_save_as', 'fonts_folder');
    }
}

#
# put_slide_animation test
#
{
    my %params = ('name' => $utils->get_param_value('put_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation', 'slide_index', 'int'), 'animation' => $utils->get_param_value('put_slide_animation', 'animation', 'SlideAnimation'), 'password' => $utils->get_param_value('put_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation', 'storage', 'string'));
    $utils->initialize('put_slide_animation', '');
    eval {
        my $result = $utils->{api}->put_slide_animation(%params);
    };
    if ($@) {
        fail("put_slide_animation raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation', 'slide_index', 'int'), 'animation' => $utils->get_param_value('put_slide_animation', 'animation', 'SlideAnimation'), 'password' => $utils->get_param_value('put_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('put_slide_animation', 'name', $params{ name });
    $utils->initialize('put_slide_animation', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->put_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation', 'slide_index', 'int'), 'animation' => $utils->get_param_value('put_slide_animation', 'animation', 'SlideAnimation'), 'password' => $utils->get_param_value('put_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('put_slide_animation', 'slide_index', $params{ slide_index });
    $utils->initialize('put_slide_animation', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->put_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation', 'slide_index', 'int'), 'animation' => $utils->get_param_value('put_slide_animation', 'animation', 'SlideAnimation'), 'password' => $utils->get_param_value('put_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation', 'storage', 'string'));
    $params{ animation } = $utils->invalidize_param_value('put_slide_animation', 'animation', $params{ animation });
    $utils->initialize('put_slide_animation', 'animation', $params{ animation });

    eval {
        my $result = $utils->{api}->put_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation', 'animation', $params{ animation }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation', 'animation');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation', 'slide_index', 'int'), 'animation' => $utils->get_param_value('put_slide_animation', 'animation', 'SlideAnimation'), 'password' => $utils->get_param_value('put_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('put_slide_animation', 'password', $params{ password });
    $utils->initialize('put_slide_animation', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->put_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation', 'slide_index', 'int'), 'animation' => $utils->get_param_value('put_slide_animation', 'animation', 'SlideAnimation'), 'password' => $utils->get_param_value('put_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('put_slide_animation', 'folder', $params{ folder });
    $utils->initialize('put_slide_animation', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->put_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation', 'slide_index', 'int'), 'animation' => $utils->get_param_value('put_slide_animation', 'animation', 'SlideAnimation'), 'password' => $utils->get_param_value('put_slide_animation', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('put_slide_animation', 'storage', $params{ storage });
    $utils->initialize('put_slide_animation', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->put_slide_animation(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation', 'storage');
    }
}

#
# put_slide_animation_effect test
#
{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_effect', 'storage', 'string'));
    $utils->initialize('put_slide_animation_effect', '');
    eval {
        my $result = $utils->{api}->put_slide_animation_effect(%params);
    };
    if ($@) {
        fail("put_slide_animation_effect raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_effect', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('put_slide_animation_effect', 'name', $params{ name });
    $utils->initialize('put_slide_animation_effect', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->put_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_effect', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_effect', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_effect', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('put_slide_animation_effect', 'slide_index', $params{ slide_index });
    $utils->initialize('put_slide_animation_effect', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->put_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_effect', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_effect', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_effect', 'storage', 'string'));
    $params{ effect_index } = $utils->invalidize_param_value('put_slide_animation_effect', 'effect_index', $params{ effect_index });
    $utils->initialize('put_slide_animation_effect', 'effect_index', $params{ effect_index });

    eval {
        my $result = $utils->{api}->put_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_effect', 'effect_index', $params{ effect_index }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_effect', 'effect_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_effect', 'storage', 'string'));
    $params{ effect } = $utils->invalidize_param_value('put_slide_animation_effect', 'effect', $params{ effect });
    $utils->initialize('put_slide_animation_effect', 'effect', $params{ effect });

    eval {
        my $result = $utils->{api}->put_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_effect', 'effect', $params{ effect }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_effect', 'effect');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_effect', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('put_slide_animation_effect', 'password', $params{ password });
    $utils->initialize('put_slide_animation_effect', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->put_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_effect', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_effect', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_effect', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('put_slide_animation_effect', 'folder', $params{ folder });
    $utils->initialize('put_slide_animation_effect', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->put_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_effect', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_effect', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_effect', 'slide_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_effect', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('put_slide_animation_effect', 'storage', $params{ storage });
    $utils->initialize('put_slide_animation_effect', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->put_slide_animation_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_effect', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_effect', 'storage');
    }
}

#
# put_slide_animation_interactive_sequence_effect test
#
{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $utils->initialize('put_slide_animation_interactive_sequence_effect', '');
    eval {
        my $result = $utils->{api}->put_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        fail("put_slide_animation_interactive_sequence_effect raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('put_slide_animation_interactive_sequence_effect', 'name', $params{ name });
    $utils->initialize('put_slide_animation_interactive_sequence_effect', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->put_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_interactive_sequence_effect', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_interactive_sequence_effect', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('put_slide_animation_interactive_sequence_effect', 'slide_index', $params{ slide_index });
    $utils->initialize('put_slide_animation_interactive_sequence_effect', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->put_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_interactive_sequence_effect', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_interactive_sequence_effect', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ sequence_index } = $utils->invalidize_param_value('put_slide_animation_interactive_sequence_effect', 'sequence_index', $params{ sequence_index });
    $utils->initialize('put_slide_animation_interactive_sequence_effect', 'sequence_index', $params{ sequence_index });

    eval {
        my $result = $utils->{api}->put_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_interactive_sequence_effect', 'sequence_index', $params{ sequence_index }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_interactive_sequence_effect', 'sequence_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ effect_index } = $utils->invalidize_param_value('put_slide_animation_interactive_sequence_effect', 'effect_index', $params{ effect_index });
    $utils->initialize('put_slide_animation_interactive_sequence_effect', 'effect_index', $params{ effect_index });

    eval {
        my $result = $utils->{api}->put_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_interactive_sequence_effect', 'effect_index', $params{ effect_index }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_interactive_sequence_effect', 'effect_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ effect } = $utils->invalidize_param_value('put_slide_animation_interactive_sequence_effect', 'effect', $params{ effect });
    $utils->initialize('put_slide_animation_interactive_sequence_effect', 'effect', $params{ effect });

    eval {
        my $result = $utils->{api}->put_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_interactive_sequence_effect', 'effect', $params{ effect }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_interactive_sequence_effect', 'effect');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('put_slide_animation_interactive_sequence_effect', 'password', $params{ password });
    $utils->initialize('put_slide_animation_interactive_sequence_effect', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->put_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_interactive_sequence_effect', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_interactive_sequence_effect', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('put_slide_animation_interactive_sequence_effect', 'folder', $params{ folder });
    $utils->initialize('put_slide_animation_interactive_sequence_effect', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->put_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_interactive_sequence_effect', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_interactive_sequence_effect', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'slide_index', 'int'), 'sequence_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'sequence_index', 'int'), 'effect_index' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect_index', 'int'), 'effect' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'effect', 'Effect'), 'password' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_animation_interactive_sequence_effect', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('put_slide_animation_interactive_sequence_effect', 'storage', $params{ storage });
    $utils->initialize('put_slide_animation_interactive_sequence_effect', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->put_slide_animation_interactive_sequence_effect(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_animation_interactive_sequence_effect', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('put_slide_animation_interactive_sequence_effect', 'storage');
    }
}

#
# put_slide_save_as test
#
{
    my %params = ('name' => $utils->get_param_value('put_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('put_slide_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slide_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('put_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('put_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('put_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('put_slide_save_as', 'fonts_folder', 'string'));
    $utils->initialize('put_slide_save_as', '');
    eval {
        my $result = $utils->{api}->put_slide_save_as(%params);
    };
    if ($@) {
        fail("put_slide_save_as raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('put_slide_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slide_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('put_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('put_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('put_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('put_slide_save_as', 'fonts_folder', 'string'));
    $params{ name } = $utils->invalidize_param_value('put_slide_save_as', 'name', $params{ name });
    $utils->initialize('put_slide_save_as', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->put_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_save_as', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('put_slide_save_as', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('put_slide_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slide_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('put_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('put_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('put_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('put_slide_save_as', 'fonts_folder', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('put_slide_save_as', 'slide_index', $params{ slide_index });
    $utils->initialize('put_slide_save_as', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->put_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_save_as', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('put_slide_save_as', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('put_slide_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slide_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('put_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('put_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('put_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('put_slide_save_as', 'fonts_folder', 'string'));
    $params{ format } = $utils->invalidize_param_value('put_slide_save_as', 'format', $params{ format });
    $utils->initialize('put_slide_save_as', 'format', $params{ format });

    eval {
        my $result = $utils->{api}->put_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_save_as', 'format', $params{ format }, $@);
    } else {
        $utils->assert_no_error('put_slide_save_as', 'format');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('put_slide_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slide_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('put_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('put_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('put_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('put_slide_save_as', 'fonts_folder', 'string'));
    $params{ out_path } = $utils->invalidize_param_value('put_slide_save_as', 'out_path', $params{ out_path });
    $utils->initialize('put_slide_save_as', 'out_path', $params{ out_path });

    eval {
        my $result = $utils->{api}->put_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_save_as', 'out_path', $params{ out_path }, $@);
    } else {
        $utils->assert_no_error('put_slide_save_as', 'out_path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('put_slide_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slide_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('put_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('put_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('put_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('put_slide_save_as', 'fonts_folder', 'string'));
    $params{ options } = $utils->invalidize_param_value('put_slide_save_as', 'options', $params{ options });
    $utils->initialize('put_slide_save_as', 'options', $params{ options });

    eval {
        my $result = $utils->{api}->put_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_save_as', 'options', $params{ options }, $@);
    } else {
        $utils->assert_no_error('put_slide_save_as', 'options');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('put_slide_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slide_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('put_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('put_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('put_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('put_slide_save_as', 'fonts_folder', 'string'));
    $params{ width } = $utils->invalidize_param_value('put_slide_save_as', 'width', $params{ width });
    $utils->initialize('put_slide_save_as', 'width', $params{ width });

    eval {
        my $result = $utils->{api}->put_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_save_as', 'width', $params{ width }, $@);
    } else {
        $utils->assert_no_error('put_slide_save_as', 'width');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('put_slide_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slide_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('put_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('put_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('put_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('put_slide_save_as', 'fonts_folder', 'string'));
    $params{ height } = $utils->invalidize_param_value('put_slide_save_as', 'height', $params{ height });
    $utils->initialize('put_slide_save_as', 'height', $params{ height });

    eval {
        my $result = $utils->{api}->put_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_save_as', 'height', $params{ height }, $@);
    } else {
        $utils->assert_no_error('put_slide_save_as', 'height');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('put_slide_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slide_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('put_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('put_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('put_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('put_slide_save_as', 'fonts_folder', 'string'));
    $params{ password } = $utils->invalidize_param_value('put_slide_save_as', 'password', $params{ password });
    $utils->initialize('put_slide_save_as', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->put_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_save_as', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('put_slide_save_as', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('put_slide_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slide_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('put_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('put_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('put_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('put_slide_save_as', 'fonts_folder', 'string'));
    $params{ folder } = $utils->invalidize_param_value('put_slide_save_as', 'folder', $params{ folder });
    $utils->initialize('put_slide_save_as', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->put_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_save_as', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('put_slide_save_as', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('put_slide_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slide_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('put_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('put_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('put_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('put_slide_save_as', 'fonts_folder', 'string'));
    $params{ storage } = $utils->invalidize_param_value('put_slide_save_as', 'storage', $params{ storage });
    $utils->initialize('put_slide_save_as', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->put_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_save_as', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('put_slide_save_as', 'storage');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_save_as', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_save_as', 'slide_index', 'int'), 'format' => $utils->get_param_value('put_slide_save_as', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slide_save_as', 'out_path', 'string'), 'options' => $utils->get_param_value('put_slide_save_as', 'options', 'ExportOptions'), 'width' => $utils->get_param_value('put_slide_save_as', 'width', 'int'), 'height' => $utils->get_param_value('put_slide_save_as', 'height', 'int'), 'password' => $utils->get_param_value('put_slide_save_as', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_save_as', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_save_as', 'storage', 'string'), 'fonts_folder' => $utils->get_param_value('put_slide_save_as', 'fonts_folder', 'string'));
    $params{ fonts_folder } = $utils->invalidize_param_value('put_slide_save_as', 'fonts_folder', $params{ fonts_folder });
    $utils->initialize('put_slide_save_as', 'fonts_folder', $params{ fonts_folder });

    eval {
        my $result = $utils->{api}->put_slide_save_as(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_save_as', 'fonts_folder', $params{ fonts_folder }, $@);
    } else {
        $utils->assert_no_error('put_slide_save_as', 'fonts_folder');
    }
}

#
# put_slide_shape_info test
#
{
    my %params = ('name' => $utils->get_param_value('put_slide_shape_info', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_shape_info', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_slide_shape_info', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_slide_shape_info', 'shape_index', 'int'), 'dto' => $utils->get_param_value('put_slide_shape_info', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('put_slide_shape_info', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_shape_info', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_shape_info', 'storage', 'string'));
    $utils->initialize('put_slide_shape_info', '');
    eval {
        my $result = $utils->{api}->put_slide_shape_info(%params);
    };
    if ($@) {
        fail("put_slide_shape_info raised an exception: $@");
    }
    pass();
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_shape_info', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_shape_info', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_slide_shape_info', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_slide_shape_info', 'shape_index', 'int'), 'dto' => $utils->get_param_value('put_slide_shape_info', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('put_slide_shape_info', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_shape_info', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_shape_info', 'storage', 'string'));
    $params{ name } = $utils->invalidize_param_value('put_slide_shape_info', 'name', $params{ name });
    $utils->initialize('put_slide_shape_info', 'name', $params{ name });

    eval {
        my $result = $utils->{api}->put_slide_shape_info(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_shape_info', 'name', $params{ name }, $@);
    } else {
        $utils->assert_no_error('put_slide_shape_info', 'name');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_shape_info', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_shape_info', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_slide_shape_info', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_slide_shape_info', 'shape_index', 'int'), 'dto' => $utils->get_param_value('put_slide_shape_info', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('put_slide_shape_info', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_shape_info', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_shape_info', 'storage', 'string'));
    $params{ slide_index } = $utils->invalidize_param_value('put_slide_shape_info', 'slide_index', $params{ slide_index });
    $utils->initialize('put_slide_shape_info', 'slide_index', $params{ slide_index });

    eval {
        my $result = $utils->{api}->put_slide_shape_info(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_shape_info', 'slide_index', $params{ slide_index }, $@);
    } else {
        $utils->assert_no_error('put_slide_shape_info', 'slide_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_shape_info', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_shape_info', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_slide_shape_info', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_slide_shape_info', 'shape_index', 'int'), 'dto' => $utils->get_param_value('put_slide_shape_info', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('put_slide_shape_info', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_shape_info', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_shape_info', 'storage', 'string'));
    $params{ path } = $utils->invalidize_param_value('put_slide_shape_info', 'path', $params{ path });
    $utils->initialize('put_slide_shape_info', 'path', $params{ path });

    eval {
        my $result = $utils->{api}->put_slide_shape_info(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_shape_info', 'path', $params{ path }, $@);
    } else {
        $utils->assert_no_error('put_slide_shape_info', 'path');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_shape_info', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_shape_info', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_slide_shape_info', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_slide_shape_info', 'shape_index', 'int'), 'dto' => $utils->get_param_value('put_slide_shape_info', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('put_slide_shape_info', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_shape_info', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_shape_info', 'storage', 'string'));
    $params{ shape_index } = $utils->invalidize_param_value('put_slide_shape_info', 'shape_index', $params{ shape_index });
    $utils->initialize('put_slide_shape_info', 'shape_index', $params{ shape_index });

    eval {
        my $result = $utils->{api}->put_slide_shape_info(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_shape_info', 'shape_index', $params{ shape_index }, $@);
    } else {
        $utils->assert_no_error('put_slide_shape_info', 'shape_index');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_shape_info', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_shape_info', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_slide_shape_info', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_slide_shape_info', 'shape_index', 'int'), 'dto' => $utils->get_param_value('put_slide_shape_info', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('put_slide_shape_info', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_shape_info', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_shape_info', 'storage', 'string'));
    $params{ dto } = $utils->invalidize_param_value('put_slide_shape_info', 'dto', $params{ dto });
    $utils->initialize('put_slide_shape_info', 'dto', $params{ dto });

    eval {
        my $result = $utils->{api}->put_slide_shape_info(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_shape_info', 'dto', $params{ dto }, $@);
    } else {
        $utils->assert_no_error('put_slide_shape_info', 'dto');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_shape_info', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_shape_info', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_slide_shape_info', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_slide_shape_info', 'shape_index', 'int'), 'dto' => $utils->get_param_value('put_slide_shape_info', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('put_slide_shape_info', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_shape_info', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_shape_info', 'storage', 'string'));
    $params{ password } = $utils->invalidize_param_value('put_slide_shape_info', 'password', $params{ password });
    $utils->initialize('put_slide_shape_info', 'password', $params{ password });

    eval {
        my $result = $utils->{api}->put_slide_shape_info(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_shape_info', 'password', $params{ password }, $@);
    } else {
        $utils->assert_no_error('put_slide_shape_info', 'password');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_shape_info', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_shape_info', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_slide_shape_info', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_slide_shape_info', 'shape_index', 'int'), 'dto' => $utils->get_param_value('put_slide_shape_info', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('put_slide_shape_info', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_shape_info', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_shape_info', 'storage', 'string'));
    $params{ folder } = $utils->invalidize_param_value('put_slide_shape_info', 'folder', $params{ folder });
    $utils->initialize('put_slide_shape_info', 'folder', $params{ folder });

    eval {
        my $result = $utils->{api}->put_slide_shape_info(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_shape_info', 'folder', $params{ folder }, $@);
    } else {
        $utils->assert_no_error('put_slide_shape_info', 'folder');
    }
}

{
    my %params = ('name' => $utils->get_param_value('put_slide_shape_info', 'name', 'string'), 'slide_index' => $utils->get_param_value('put_slide_shape_info', 'slide_index', 'int'), 'path' => $utils->get_param_value('put_slide_shape_info', 'path', 'string'), 'shape_index' => $utils->get_param_value('put_slide_shape_info', 'shape_index', 'int'), 'dto' => $utils->get_param_value('put_slide_shape_info', 'dto', 'ShapeBase'), 'password' => $utils->get_param_value('put_slide_shape_info', 'password', 'string'), 'folder' => $utils->get_param_value('put_slide_shape_info', 'folder', 'string'), 'storage' => $utils->get_param_value('put_slide_shape_info', 'storage', 'string'));
    $params{ storage } = $utils->invalidize_param_value('put_slide_shape_info', 'storage', $params{ storage });
    $utils->initialize('put_slide_shape_info', 'storage', $params{ storage });

    eval {
        my $result = $utils->{api}->put_slide_shape_info(%params);
    };
    if ($@) {
        $utils->assert_error('put_slide_shape_info', 'storage', $params{ storage }, $@);
    } else {
        $utils->assert_no_error('put_slide_shape_info', 'storage');
    }
}

#
# put_slides_convert test
#
{
    my %params = ('format' => $utils->get_param_value('put_slides_convert', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slides_convert', 'out_path', 'string'), 'document' => $utils->get_param_value('put_slides_convert', 'document', 'File'), 'password' => $utils->get_param_value('put_slides_convert', 'password', 'string'), 'fonts_folder' => $utils->get_param_value('put_slides_convert', 'fonts_folder', 'string'));
    $utils->initialize('put_slides_convert', '');
    eval {
        my $result = $utils->{api}->put_slides_convert(%params);
    };
    if ($@) {
        fail("put_slides_convert raised an exception: $@");
    }
    pass();
}

{
    my %params = ('format' => $utils->get_param_value('put_slides_convert', 'format', 'string'), 'out_path' => $utils->get_param_value('put_slides_convert', 'out_path', 'string'), 'document' => $utils->get_param_value('put_slides_convert', 'document', 'File'), 'password' => $utils->get_param_value('put_slides_convert', 'password', 'string'), 'fonts_folder' => $utils->get_param_value('put_slides_convert', 'fonts_folder', 'string'));
    $params{ format } = $utils->invalidize_param_value('put_slides_convert', 'format', $params{ format });
    $utils->initialize('put_slides_convert', 'format', $params{ format });

    eval {
        my $result = $utils->{api}->put_slides_convert(%params);
    };
    if ($@) {
        $utils->assert_error('put_slides_convert', 'format', $params{ format }, $@);
    } else {
        $utils->assert_no_error('