#!/usr/bin/perl
#
# camel.t
#
# See Acme::EyeDrops,
# <http://search.cpan.org/~asavige/Acme-EyeDrops-1.51/lib/Acme/EyeDrops.pm>.
#
# $Writestamp: 2007-12-03 23:45:37 andreas$
# $Compile: perl -M'constant standalone => 1' camel.t$

use warnings;
use strict;
use constant;
use Test;

BEGIN { plan tests => 2 }
BEGIN { unshift @INC, '../lib' if $constant::declared{'main::standalone'} }

use Data::Rlist;

#########################

{
	my %foo =
	(
	 'Acme::EyeDrops' =>
	 {
	  -camel => <<'CAMEL',
											   ''=~('(?{'.(                
					('`')|                   '%').('['^'-').               
				 ('`'|'!').                ('`'|',').'"\\$~='              
		  .('['^'+')  .('`'|              '/').('['^'+').'||'.             
		 "'"."'".';'.('`'|'/'            ).('['^'+').('`'|'%').            
		 ('`'|'.').('\\$%;').(          '['^'"').(',!-~,#,,').(            
		   '['^'(').',(.).,\\'        .'$+,'.('`'|"'").('['^'(')           
				.',\\$~&&(\\$'      .'_='.('['^')').('`'|('%')).(          
			   '['^'-').('`'|     '%').('['^')').('['^'(').(('`')|         
			  '%').')'.("\`"|   '&').('`'|'/').('['^"\)").'\\@~='.(        
			 '`'|"'").("\["^   ')').('`'|'%').('['^'+').('\\$|--,(').      
			 "'"."'".(')').(  '['^'#').('^'^('`'|'/')).(':'&'=').',<'.     
			 ('^'^('`'|'.')  ).'>;\\@;='.('`'|'-').('`'|'!').('['^'+')     
			 .'~~'.('['^')'  ).('`'|'%').('['^'-').('`'|'%').('['^')').    
			 ('['^'(').('`'|'%').','.('['^')').('`'|'%').('['^'-').('`'    
			 |'%').('['^')').('['^'(').('`'|'%').'\\@~;'.('`'|'-').('`'|   
			  '!').('['^'+').'\\{'.('['^'(').('['^'"').('['^'(').(('[')^   
			  '/').('`'|'%').('`'|'-').'\\$^'.('`'^'/').'=~'.('{'^"\,").(  
			   '`'|')').('`'|'.').'?'.('`'^'#').('`'^',').('{'^'(').(':'). 
				"'".('`'|'#').('`'|',').('`'|'%').('`'|'!').('['^')')."'". 
				 ';(\\$-=\\$_%'.('^'^('`'|'-')).')||(--\\$|,'.('`'|'-' ).( 
				  '`'|'!').('['^'+').'\\$_='.('['^')').('`'|'%').('['  ^(( 
				   '-'))).('`'|'%').('['^')').('['^'(').('`' |('%')).  ',' 
					 .'\\@~,\\@;);'.('['^'+').('['^(')')).(  '`'|')'   ).( 
					  "\`"| '.').('['^'/').'\\$\\"'.("\["^   ('#')).   '(' 
							.'\\$=/'.('^'^('`'|'-')).'*'.    (('`')|   '!' 
							).("\`"|    '"').('['^ "\(").     '\\$|'   .+  
							('*').(     '^'^('`'   |','))     .'-\\'  .+   
							'$-),'.     '\\$_,'.   '\\$'       .'/'.  (    
							('`')|      ('&')).(   '`'|         '/')       
							.('['^     ')').'\\'   .'$'         .'-'       
							 .'&'.     (('^')^(    '`'|         '/')       
							 ).'?'     .'\\@;'     .':'         .''.       
							 '\\'     .'@~;'       .''.         ('['       
							 ^'('     ).(          '`'|         ',')       
							 .''.      (((         '`'          ))|        
							 '%'        ).(       '`'           |((        
							 '%'         )))     .+(            '['        
							 ^((          '+'   )))              .+        
							 ((             '!')).               ((        
							 ((              '\\')               ))        
							 ).             '$%\\}'.             ((        
							(((            '\\' )))))            .+        
						   '$'           .'%..'  .''.           (((        
						  '^')         )^("\`"|   '/'          )).(        
						"\^"^(                                ('`')|       
					  ('/'))).                               '"})');      
CAMEL

	  -buffy => <<'BUFFY'
						''=~('(?{'.(
					 '`'|'%').('['^'-'
				   ).('`'|'!').('`'|','
				  ).+               ( '"'
				 ).(                (  '`'
				)|+                 (   '/'
			   )).                  (   '['
			  ^((                  (     '+'
			 )))              ).('`'      |((
			 '%'          ))).      (     '`'
			|((       '.')           )     ).+
			(((     ((                (     (((
			(((    (                   (    (((
			(((   (                     '\\')))
		   )))    )                      ) )  )
		   )   )))) ))))))      .'$[;'     .  (
		   (  (  ((                        (  (
		   (  (      ( (( (     ( (( (     (   (
		   (  (       '`')       ))))      )   )
		   )   )                        )))    )
		   )    )))                     )      )
		   )|      (       (   (        (     ((
		   '#'      )        )          )    )))
			).(('`')|                   ('(')).(
			'`'|'/').    ('['^'+')     .',(\\$'
			.'=='.('['     ^'"')     . '==='.+(
			'`'|'#').')'            .  '>\\$-'
			.'&&(\\$-=\\'          .   '$=)'.(
			'`'|'&').('`' |      (     '/')).(
			'['^')').'\\'     .        '@:=<' .
			('^'^(('`')|              "\.")).   (
			'>').(';').(              '!'^'+'     )
			 .('['^'+').             ('['^')'     ).('`'|
			 ')').("\`"|             "\.").(      (      ('['))^
	   "\/").'\\$\\"'.(            ( "\[")^       (             (
	  (    ( "\#"))))). (        (   '-'))        .              (
	 (     ( ('(')))).(   (   (     '['))         ^              (
	 (     '"'))).'--'       .     '-'.           (              (
	 (    '`'))|'#').        (                    (               (
	 (     '-')))).          (                    (               (
	 (     ( '\\'                                 )               )
	 )     )                                      )               .
	 (     (                                      (               (
	 (     (                                      (      (         (
	 (     (                                      (      (         (
	 (     (                                      (     (          (
	 (     (                                      (     (          (
	 (     '$'))))))))))))))))))))))))).'-).'.('['^    (           (
	 (    ')')))).('`'|'%').('['^'-').('`'|'%').(('[')^            (
	 (    ')'))).('['^'(').('`'|'%').'.\\$/'.('`'|'&').(           (
	 (   '`'))|'/').('['^')').'\\@:'.('!'^'+').'"})');$:=          (
	 (   '.'))^'~';$~='@'|'(';$^=')'^'[';$/='`'|'.';$,='('         ;
BUFFY
	 }
	);


	my $obj = new Data::Rlist(-data => \%foo);
	my $bar = KeelhaulData(\%foo);
	ok(not CompareData(\%foo, $bar));
	ok(not CompareData(\%foo, $obj->keelhaul));
}

### Local Variables:
### buffer-file-coding-system: iso-latin-1
### End:
