#  Package
#
package WebMod::Err;


#  Compiler Pragma
#
use strict qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;


#  All done, init finished
#
#------------------------------------------------------------------------------


#  Create the Makefile
#
WriteMakefile(

    NAME				   =>	'WebMod::Err',
    VERSION_FROM			   => 	'VERSION.pm',

    PM					   =>	{
	'Err.pm'			   =>	'$(INST_LIBDIR)/Err.pm',
	'VERSION.pm'			   =>	'$(INST_LIBDIR)/Err/VERSION.pm',
	'LICENSE'			   =>	'$(INST_LIBDIR)/Err/LICENSE',
	'Constant.pm'			   =>	'$(INST_LIBDIR)/Err/Constant.pm',
    },

    'dist'				   =>	{
	COMPRESS			   =>	'gzip -9f',
	SUFFIX				   =>	'.gz',
    },

    'depend'				   =>	{
	Makefile			   =>	'$(VERSION_FROM)',
    },

    'macro'				 =>  {
        COPYRIGHT			 =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				 =>  'GPL: GNU General Public License',
    	statl				 =>  'g',
    },


    ($] >= 5.005 ?
      (#ABSTRACT_FROM 			 => 'Err.pm',
       AUTHOR     			 => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
    ),

   );

