#! perl
# Copyright (C) 2001-2005, Parrot Foundation.
# $Id: integer.t 36833 2009-02-17 20:09:26Z allison $

use strict;
use warnings;
use lib qw( . lib ../lib ../../lib );
use Test::More;
use Parrot::Config;

use Parrot::Test tests => 5;

=head1 NAME

t/native_pbc/integer.t - Integers

=head1 SYNOPSIS

        % prove t/native_pbc/integer.t

=head1 DESCRIPTION

Tests word-size/float-type/endian-ness for different architectures.

These tests usually only work on releases, not on svn checkouts
and if every release has updated native pbc test files.

See F<tools/dev/mk_native_pbc> to create the platform-specific native pbcs.

=head1 PLATFORMS

  _1   i386 32 bit opcode_t, 32 bit intval   (linux-gcc-ix86, freebsd-gcc, cygwin)
  _2   i386 32 bit opcode_t, 32 bit intval, 12 bit long double (linux-gcc-ix86)
  _3   PPC BE 32 bit opcode_t, 32 bit intval (darwin-ppc)
  _4   x86_64 12-bit double 64 bit opcode_t   (linux-gcc-x86_64 -m96bit-long-double)
  _5   x86_64 16 bit long double 64 bit opcode_t (linux-gcc-x86_64, solaris-cc-64int)
  _6   big-endian 64-bit                     (MIPS irix or similar)

=cut

=begin comment

See t/native_pbc/number.t for additional comments.
See tools/dev/mk_native_pbc to create the platform-specific native pbcs.

Test files on different architectures are generated by:

  $ parrot -o i.pbc -a - <<EOF
  print 0x10203040
  end
  EOF
  $ mv i.pbc t/native_pbc/integer_${N}.pbc

The output of

  $ pbc_dump -h i.pbc

should be included for reference.

On test failures please add the output of

  $ ./pbc_dump -h t/native_pbc/number_${N}.pbc

into your report. We need your wordsize/floattype/endianess.

=cut

# execute the file t/native_pbc/integer_1.pbc
#
# any ordinary intel 386 linux, cygwin, mingw, MSWin32, ...
# HEADER => [
#         wordsize  = 4   (interpreter's wordsize/INTVAL = 4/4)
#         byteorder = 0   (interpreter's byteorder       = 0)
#         floattype = 0   (interpreter's NUMVAL_SIZE     = 8)
#         parrot-version 0.9.0, bytecode-version 3.34
#         UUID type = 0, UUID size = 0
#         no endianize, no opcode, no numval transform
#         dirformat = 1
# ]
TODO: {
    local $TODO;
    if ($PConfig{ptrsize} == 8) {
        $TODO = "Known problem on 64bit with reading 32bit dirs. See TT #254"
    } elsif ($PConfig{DEVEL}) {
        $TODO = "devel versions are not guaranteed to succeed";
    }

pbc_output_is( undef, '270544960', "i386 32 bit opcode_t, 32 bit intval" )
    or diag "May need to regenerate t/native_pbc/integer_1.pbc; read test file";

# HEADER => [
#         wordsize  = 4   (interpreter's wordsize/INTVAL = 4/4)
#         byteorder = 0   (interpreter's byteorder       = 0)
#         floattype = 1   (interpreter's NUMVAL_SIZE     = 12)
#         parrot-version 0.9.0, bytecode-version 3.34
#         UUID type = 0, UUID size = 0
#         no endianize, no opcode, no numval transform
#         dirformat = 1
# ]
pbc_output_is( undef, '270544960', "i386 32 bit opcode_t, 32 bit intval 12-byte long double" )
    or diag "May need to regenerate t/native_pbc/integer_2.pbc; read test file";

# darwin/ppc:
# HEADER => [
#         wordsize  = 4   (interpreter's wordsize/INTVAL = 4/4)
#         byteorder = 1   (interpreter's byteorder       = 1)
#         floattype = 0   (interpreter's NUMVAL_SIZE     = 8)
#         parrot-version 0.9.0, bytecode-version 3.34
#         UUID type = 0, UUID size = 0
#         no endianize, no opcode, no numval transform
#         dirformat = 1
# ]

pbc_output_is(undef, '270544960', "PPC BE 32 bit opcode_t, 32 bit intval")
    or diag "May need to regenerate t/native_pbc/integer_3.pbc; read test file";

}

TODO: {
    local $TODO;
    if ($PConfig{ptrsize} == 4) {
        $TODO = "Known problem on 32bit with reading 64bit dirs. See TT #254"
    } elsif ($PConfig{DEVEL}) {
        $TODO = "devel versions are not guaranteed to succeed";
    }

# any ordinary 64-bit intel unix:
# HEADER => [
#         wordsize  = 8   (interpreter's wordsize/INTVAL = 8/8)
#         byteorder = 0   (interpreter's byteorder       = 0)
#         floattype = 0   (interpreter's NUMVAL_SIZE     = 8)
#         parrot-version 0.9.0, bytecode-version 3.34
#         UUID type = 0, UUID size = 0
#         no endianize, no opcode, no numval transform
#         dirformat = 1
# ]

pbc_output_is(undef, '270544960', "i86_64 LE 64 bit opcode_t, 64 bit intval")
    or diag "May need to regenerate t/native_pbc/integer_4.pbc; read test file";

# HEADER => [
#         wordsize  = 8   (interpreter's wordsize/INTVAL = 8/8)
#         byteorder = 0   (interpreter's byteorder       = 0)
#         floattype = 2   (interpreter's NUMVAL_SIZE     = 16)
#         parrot-version 0.9.0, bytecode-version 3.34
#         UUID type = 0, UUID size = 0
#         no endianize, no opcode, no numval transform
#         dirformat = 1
# ]

pbc_output_is(undef, '270544960', "i86_64 LE 64 bit opcode_t, 64 bit intval, 16-byte long double")
    or diag "May need to regenerate t/native_pbc/integer_5.pbc; read test file";

# Formerly following tests had been set up:
# pbc_output_is(undef, '270544960', "big-endian 64-bit (irix)");
#    or diag "May need to regenerate t/native_pbc/integer_6.pbc; read test file";

}

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
