use utf8;
use strict;

${Lingua::Identify::languages{'_versions'}{'hi'}} = '0.03';

${Lingua::Identify::languages{'_names'}{'hi'}} = 'hindi';

${Lingua::Identify::languages{'_sets'}{'hi'}} = '';


=head1 NAME

Lingua::Identify::HI - Meta-information on Hindi

=head1 SYNOPSIS

Nothing here is meant for public consumption. This module is to be
loaded by Lingua::Identify.

=head1 DESCRIPTION

Automatically generated. Do not change this module yourself unless
you know what you're doing.

=head1 SEE ALSO

Lingua::Identify(3).

=head1 AUTHOR

Jose Castro, C<< <cog@cpan.org> >>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2010 by Alberto Simoes

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.4 or,
at your option, any later version of Perl 5 you may have available.

=cut

${Lingua::Identify::languages{'prefixes1'}{'hi'}} = {
  'क'	=> 0.167642440577547,
  'स'	=> 0.0920453749074262,
  'ह'	=> 0.0820805482264654,
  'म'	=> 0.0691988173279263,
  'प'	=> 0.0679714446441661,
  'ज'	=> 0.0387380032843584,
  'अ'	=> 0.0385353352640461,
  'व'	=> 0.0372416693026137,
  'ब'	=> 0.032885253912724,
  'न'	=> 0.0321181459853738,
  'द'	=> 0.02952134359427,
  'र'	=> 0.0254471481578992,
  'उ'	=> 0.0238788386175389,
  'भ'	=> 0.0234791848578577,
  'ल'	=> 0.0225359262212642,
  'इ'	=> 0.0217536655447319,
  'ग'	=> 0.0210054985538595,
  'य'	=> 0.019677738906767,
  'आ'	=> 0.0177665984161589,
  'औ'	=> 0.0177116697003733,
};

${Lingua::Identify::languages{'prefixes2'}{'hi'}} = {
  'मे'	=> 0.0443889782215076,
  'प्'	=> 0.0310957512339901,
  'वि'	=> 0.0197891750199332,
  'है'	=> 0.0180478556171551,
  'सं'	=> 0.0160505382623606,
  'कर'	=> 0.015015879872961,
  'स्'	=> 0.0149252139316219,
  'रा'	=> 0.0145492169395978,
  'सा'	=> 0.0144718842249262,
  'जा'	=> 0.0142798857609139,
  'भा'	=> 0.0138532225075533,
  'कि'	=> 0.0132318941448468,
  'लि'	=> 0.0127838977288182,
  'सम'	=> 0.0121305696221097,
  'इस'	=> 0.0119572376754319,
  'का'	=> 0.0118479052167583,
  'हो'	=> 0.0111759105927153,
  'बा'	=> 0.010978578838036,
  'अन'	=> 0.00971725559528857,
  'नि'	=> 0.0095359237126103,
};

${Lingua::Identify::languages{'prefixes3'}{'hi'}} = {
  'प्र'	=> 0.0395677051962985,
  'भार'	=> 0.0104275036959974,
  'अपन'	=> 0.0100681706181898,
  'जात'	=> 0.00990390406833488,
  'किय'	=> 0.00981492635383015,
  'राज'	=> 0.00963697092482068,
  'होत'	=> 0.00868901604336637,
  'कार'	=> 0.0075870612714231,
  'करन'	=> 0.00748781689755243,
  'हिन'	=> 0.00693341729179215,
  'विश'	=> 0.00658092865356185,
  'द्व'	=> 0.00640639544434102,
  'स्थ'	=> 0.00638586212560915,
  'सकत'	=> 0.00626950665279527,
  'उनक'	=> 0.00612235120188359,
  'इसक'	=> 0.00610866232272902,
  'नही'	=> 0.00610524010294037,
  'करत'	=> 0.00602995126759021,
  'वर्'	=> 0.00597177353118327,
  'श्र'	=> 0.00587937359688989,
};

${Lingua::Identify::languages{'prefixes4'}{'hi'}} = {
  'हिन्'	=> 0.0103033539298701,
  'प्रा'	=> 0.00805553436570295,
  'द्वा'	=> 0.00785719734533527,
  'उन्ह'	=> 0.00714521829786152,
  'प्रत'	=> 0.00659089175375696,
  'प्रक'	=> 0.00632644239326671,
  'विश्'	=> 0.00616878988989753,
  'राज्'	=> 0.00586365601240878,
  'निर्'	=> 0.00585348488315915,
  'प्रद'	=> 0.00576194471991253,
  'भारत'	=> 0.00565514786279147,
  'संस्'	=> 0.00561954891041778,
  'श्रे'	=> 0.00523304599893203,
  'कार्'	=> 0.00517710478805909,
  'उत्त'	=> 0.0050143667200651,
  'स्था'	=> 0.00486179978132072,
  'क्षे'	=> 0.00478043074732372,
  'पूर्'	=> 0.0047295751010756,
  'प्रस'	=> 0.00435832888346429,
  'प्रय'	=> 0.00413456403997254,
};

${Lingua::Identify::languages{'suffixes1'}{'hi'}} = {
  'े'	=> 0.141635387826061,
  'ा'	=> 0.127761596527575,
  'ी'	=> 0.10703991697693,
  'ं'	=> 0.0885188032860773,
  'र'	=> 0.0827655166405957,
  'न'	=> 0.0414755532661927,
  'त'	=> 0.0342356537119872,
  'ै'	=> 0.0330956015195646,
  'क'	=> 0.0325028501304811,
  'ो'	=> 0.0300030679145377,
  'य'	=> 0.0259882661737803,
  'ि'	=> 0.0207841741060438,
  'ल'	=> 0.0197520670547642,
  'म'	=> 0.0185211136908527,
  'स'	=> 0.0172257719971366,
  'ण'	=> 0.0135726811679286,
  'द'	=> 0.0134136041178231,
  'ह'	=> 0.0129269040954765,
  'ग'	=> 0.0106846751987516,
  'ई'	=> 0.0100370043518936,
};

${Lingua::Identify::languages{'suffixes2'}{'hi'}} = {
  'ें'	=> 0.0525493541636119,
  'ों'	=> 0.0339540649702075,
  'या'	=> 0.0285394366760421,
  'ता'	=> 0.0278382809688212,
  'ने'	=> 0.0271397912528826,
  'ार'	=> 0.0203415134832509,
  'ैं'	=> 0.0179234593902878,
  '्य'	=> 0.0178861355123369,
  'ान'	=> 0.0165344779322572,
  'ना'	=> 0.0154307575414228,
  'ित'	=> 0.0150681827270425,
  'िक'	=> 0.0141510817259628,
  'ते'	=> 0.012772764233061,
  'री'	=> 0.011967634865834,
  'ती'	=> 0.011405110705288,
  'के'	=> 0.0105759874165211,
  '्र'	=> 0.0105306655647236,
  'से'	=> 0.0101867526893187,
  'रा'	=> 0.009525586851331,
  'ति'	=> 0.00931230754875432,
};

${Lingua::Identify::languages{'suffixes3'}{'hi'}} = {
  'िया'	=> 0.0203612479474548,
  'यों'	=> 0.00949644225506295,
  'त्र'	=> 0.00902435686918446,
  'कार'	=> 0.00878831417624521,
  'ारत'	=> 0.0082820197044335,
  'ाता'	=> 0.0076559934318555,
  'हीं'	=> 0.00717706622879037,
  'सके'	=> 0.00642104542966612,
  'ारा'	=> 0.00626710454296661,
  'रने'	=> 0.0061576354679803,
  'नों'	=> 0.00608921729611385,
  'पने'	=> 0.00583264915161467,
  'ाने'	=> 0.00524767378215654,
  'रों'	=> 0.00523741105637657,
  'िये'	=> 0.00495689655172414,
  '्दी'	=> 0.00492952928297756,
  'में'	=> 0.00488847837985769,
  'ाओं'	=> 0.00462164750957854,
  'कता'	=> 0.00448823207443897,
  'ाया'	=> 0.00434113300492611,
};

${Lingua::Identify::languages{'suffixes4'}{'hi'}} = {
  'ियों'	=> 0.00960213199879973,
  'वारा'	=> 0.00698290637412714,
  'न्दी'	=> 0.00630139912421233,
  'ाज्य'	=> 0.00580298337427463,
  'रकार'	=> 0.0055792048743026,
  'रतीय'	=> 0.00502484449937189,
  'रेणी'	=> 0.00494855637438143,
  'समें'	=> 0.00487226824939097,
  'ोंने'	=> 0.00424670562446916,
  '्हें'	=> 0.00403309887449586,
  'ुसार'	=> 0.00386526499951684,
  '्थान'	=> 0.00373811812453274,
  'ेत्र'	=> 0.00353976899955753,
  'जीशन'	=> 0.00349908199956261,
  'क्ति'	=> 0.00346856674956643,
  'ियाँ'	=> 0.00344313737456961,
  'ूर्ण'	=> 0.00343296562457088,
  'िश्व'	=> 0.00328547524958932,
  'ाप्त'	=> 0.00326513174959186,
  'हिला'	=> 0.00325495999959313,
};

${Lingua::Identify::languages{'smallwords'}{'hi'}} = {
  'के'	=> 0.0414106436890531,
  'में'	=> 0.0296908622036111,
  'की'	=> 0.0221904267850755,
  'का'	=> 0.0179972994686957,
  'से'	=> 0.017396140974476,
  'और'	=> 0.0166432882807803,
  'है'	=> 0.0157368686197139,
  'को'	=> 0.0144240583254833,
  'है।'	=> 0.0122329198886078,
  'एक'	=> 0.00908479705750708,
  'पर'	=> 0.0086559332096058,
  'भी'	=> 0.00736746889800719,
  'ने'	=> 0.00729443095011134,
  'हैं।'	=> 0.00599847556693366,
  'यह'	=> 0.00591794654745875,
  'इस'	=> 0.00511078358481485,
  'हैं'	=> 0.00503961840481376,
  'कर'	=> 0.00478492197112566,
  'ही'	=> 0.00466881036165021,
  'कि'	=> 0.00453022553743757,
};

${Lingua::Identify::languages{'ngrams2'}{'hi'}} = {
  'के' => 0.0197696345644857,
  'है' => 0.01698834718371,
  'का' => 0.0164067224605949,
  'ार' => 0.016223826011519,
  'ें' => 0.0148790816215697,
  'मे' => 0.0144712435627107,
  'या' => 0.0133023880950529,
  'रा' => 0.01188686768458,
  'ने' => 0.0114699198409011,
  'की' => 0.0106780693142504,
  'ान' => 0.0105463278107015,
  'से' => 0.0102113680304015,
  'ता' => 0.0101581108268391,
  'ों' => 0.00988621878759976,
  'िय' => 0.00920298492610913,
  'िक' => 0.00805375053344798,
  'वा' => 0.00798647827631659,
  'ना' => 0.00789327817008249,
  'कर' => 0.00784142247187704,
  'को' => 0.00762699215227075,
  'वि' => 0.00716589688984939,
  'मा' => 0.0069717883979182,
  'कि' => 0.00686737624882887,
  'ित' => 0.00652821195245814,
  'पर' => 0.00642800431943951,
  'और' => 0.00632639518106398,
  'सा' => 0.00620446421501335,
  'जा' => 0.00579031938204826,
  'ला' => 0.00576859604901625,
  'रत' => 0.00573005465170139,
  'भा' => 0.00565927863117775,
  'ाल' => 0.00545956411781895,
  'हा' => 0.00535585272140806,
  'ति' => 0.0052227097125022,
  'इस' => 0.00517996379911663,
  'ात' => 0.00514352465983713,
  'री' => 0.00511969906876977,
  'हो' => 0.00507555165002729,
  'रि' => 0.00504962380092457,
  'ैं' => 0.00495291993129821,
  'लि' => 0.00485481455631494,
  'बा' => 0.00472937982687204,
  'ती' => 0.00470905799919694,
  'ाम' => 0.00468593316080802,
  'नि' => 0.00463197520456723,
  'सं' => 0.00460254359207225,
  'यो' => 0.00451214649655195,
  'था' => 0.00448411638941387,
  'सक' => 0.00429911768230256,
  'िन' => 0.00429841692962411,
};

${Lingua::Identify::languages{'ngrams3'}{'hi'}} = {
  'में' => 0.0212231371543885,
  'िया' => 0.00907190741095055,
  'हैं' => 0.00796123350986189,
  'कार' => 0.00701180587393671,
  'मान' => 0.0045160987549141,
  'ारत' => 0.00440057904255818,
  'भार' => 0.00434161585604319,
  'राज' => 0.0042152661706539,
  'यों' => 0.00379530388302666,
  'किय' => 0.00362322764482983,
  'जात' => 0.00362202431449279,
  'अपन' => 0.00354019785157402,
  'वार' => 0.00314189551001351,
  'होत' => 0.00307450901113923,
  'ियो' => 0.0030059191819279,
  'ाता' => 0.00297944591451301,
  'ारा' => 0.00297944591451301,
  'िका' => 0.00297824258417597,
  'पुर' => 0.00286031621114597,
  'लिए' => 0.0027905230515976,
  'करन' => 0.00263288677744526,
  'पूर' => 0.0026076168403674,
  'नही' => 0.00257272026059322,
  'हीं' => 0.00252458704711159,
  'गया' => 0.0025161637347523,
  'हिन' => 0.00251496040441526,
  'देश' => 0.00247645383362995,
  'सके' => 0.00247043718194475,
  'लिय' => 0.00241147399542975,
  'रने' => 0.0023657474426222,
  'विश' => 0.00234288416621843,
  'योग' => 0.00226466769431077,
  'रिक' => 0.00225865104262557,
  'सकत' => 0.0022093144988069,
  'िला' => 0.002182841231392,
  'उनक' => 0.00216238461566231,
  'दिय' => 0.00216238461566231,
  'नों' => 0.00216118128532527,
  'इसक' => 0.00215275797296598,
  'रूप' => 0.00214914798195486,
  'धिक' => 0.00213831800892149,
  'जिस' => 0.00213831800892149,
  'बाद' => 0.00212989469656221,
  'करत' => 0.00212026805386588,
  'पने' => 0.00205167822465455,
  'अनु' => 0.00204445824263231,
  'रका' => 0.00203483159993598,
  'महा' => 0.00202159496622853,
  'निक' => 0.00197586841342098,
  'रती' => 0.00197105509207282,
};

${Lingua::Identify::languages{'ngrams4'}{'hi'}} = {
  'भारत' => 0.00767578068818717,
  'किया' => 0.006217625752034,
  'ियों' => 0.00419523787397027,
  'नहीं' => 0.00393856720235606,
  'करने' => 0.00378146704990253,
  'जाता' => 0.00375491491145968,
  'अपने' => 0.00370402331277755,
  'दिया' => 0.00322387214260268,
  'वारा' => 0.00319732000415983,
  'अधिक' => 0.00287205630823492,
  'रकार' => 0.00283886613518136,
  'होता' => 0.00272159419039211,
  'लिये' => 0.00248262494440646,
  'ारती' => 0.00231003604452794,
  'कारण' => 0.00230118533171365,
  'सकता' => 0.00229454729710294,
  'इसके' => 0.00226799515866009,
  'रतीय' => 0.00225693176764224,
  'रेणी' => 0.00215293589207441,
  'होने' => 0.00213523446644584,
  'समें' => 0.00212859643183513,
  'अपनी' => 0.00203345126908158,
  'बहुत' => 0.00192724271531018,
  'ाहित' => 0.00188962718584948,
  'उनके' => 0.0018807764730352,
  'अकबर' => 0.00186307504740663,
  'ोंने' => 0.00184758629998163,
  'होंन' => 0.00183873558716735,
  'अनुस' => 0.00178784398848522,
  'साहि' => 0.0017745679192638,
  'हिला' => 0.0017059748949531,
  'ुसार' => 0.00168163543471382,
  'नुसा' => 0.00168163543471382,
  'भाषा' => 0.00167278472189954,
  'करते' => 0.00166614668728883,
  'होती' => 0.00166393400908526,
  'सबसे' => 0.00163959454884598,
  'महिल' => 0.00163738187064241,
  'रिया' => 0.0015997663411817,
  'ोजीश' => 0.00159312830657099,
  'जीशन' => 0.00159312830657099,
  'पोजी' => 0.00159312830657099,
  'किसी' => 0.00156657616812814,
  'जैसे' => 0.00153781135148172,
  'गंगा' => 0.00152010992585315,
  'ियाँ' => 0.00150683385663173,
  'सरका' => 0.00150240850022459,
  'परिव' => 0.00148028171818888,
  'पुरु' => 0.00146258029256031,
  'करता' => 0.00146258029256031,
};

${Lingua::Identify::languages{'letters'}{'hi'}} = {
  'ा' => 0.0924164573524215,
  'क' => 0.0706452290677796,
  'र' => 0.0698931303542266,
  'े' => 0.0590571786031497,
  'न' => 0.0441699217817338,
  'स' => 0.0428877725462481,
  'ि' => 0.0426513986648457,
  'त' => 0.0398402208066318,
  'ी' => 0.0380905765612614,
  'ह' => 0.0360926203596703,
  'ं' => 0.0358930157487083,
  'म' => 0.0353166454964807,
  'य' => 0.0295037581059528,
  'प' => 0.0273491743627456,
  'ल' => 0.0252595337465499,
  'व' => 0.0252084387863276,
  'ो' => 0.0247170676268062,
  'द' => 0.0215424947711232,
  'ज' => 0.0176167782478726,
  'ु' => 0.0158876674911897,
  'ब' => 0.0154493013838616,
  'ै' => 0.0147473425845454,
  'ग' => 0.0146523155089918,
  'श' => 0.0108951646021756,
  'अ' => 0.00980832227071734,
  'भ' => 0.00957433600427861,
  'थ' => 0.00778935505744602,
  'ट' => 0.00727315270230262,
  'ू' => 0.00716475498295243,
  'च' => 0.00714899672419227,
  'ध' => 0.0071375361723667,
  'ए' => 0.0070081274413363,
  'ष' => 0.00690163981395704,
  'इ' => 0.00643796498801417,
  'उ' => 0.00642698195918133,
  'ण' => 0.00599100346681693,
  'आ' => 0.00541463321458928,
  'ड' => 0.00529334237443533,
  'ख' => 0.0048392180083471,
  'औ' => 0.00447104778095065,
  'ई' => 0.00330350406372067,
  'फ' => 0.00313493844728624,
  'e' => 0.00217463970890198,
  'ृ' => 0.00211399428882501,
  'a' => 0.00187905297640081,
  'i' => 0.00178163828588347,
  'ँ' => 0.00162071303733275,
  'छ' => 0.0016140277154345,
  'ौ' => 0.00161068505448537,
  'r' => 0.00156866303112495,
  'n' => 0.00142683870228351,
  't' => 0.00142015338038527,
  'o' => 0.00137860888001757,
  'ओ' => 0.00133324419570802,
  's' => 0.0013165308909624,
  'ठ' => 0.00128501437344208,
  'घ' => 0.00109305013036378,
  'l' => 0.0009550459854642,
  'c' => 0.000937855157725844,
  'ॉ' => 0.000871956984728815,
  'ढ' => 0.000669009712817672,
  'm' => 0.000631762919384568,
  'p' => 0.000575892729234913,
  'u' => 0.000565387223394806,
  'h' => 0.000564909700402074,
  'ञ' => 0.00056395465441661,
  'd' => 0.000546286303685522,
  'g' => 0.000482775745652153,
  'झ' => 0.000411147296742338,
  'ऐ' => 0.000363394997469128,
  'ः' => 0.000342861508781648,
  'ऊ' => 0.000316597744181382,
  'y' => 0.000313255083232258,
  'f' => 0.000312300037246793,
  'b' => 0.000302272054399419,
  'v' => 0.000293199117537509,
  'ऑ' => 0.000253087186148013,
  'w' => 0.000225390852569551,
  'k' => 0.000200559656947482,
  'ॊ' => 0.00016140277154345,
  'ऋ' => 0.000155194972637933,
  'x' => 0.000102667443437402,
  'j' => 5.15724832150668e-05,
  'ऍ' => 4.96623912441384e-05,
  'z' => 3.29490864985149e-05,
  'q' => 3.05614715348544e-05,
  'ङ' => 2.48311956220692e-05,
  'ॅ' => 2.29211036511408e-05,
  'ळ' => 1.9100919709284e-05,
  'ا' => 7.6403678837136e-06,
  'ऱ' => 7.6403678837136e-06,
  'ॠ' => 7.6403678837136e-06,
  'ل' => 7.6403678837136e-06,
  'ऎ' => 5.7302759127852e-06,
  'μ' => 5.7302759127852e-06,
  'م' => 3.8201839418568e-06,
  'ऽ' => 3.8201839418568e-06,
  'ॐ' => 3.8201839418568e-06,
  'á' => 3.8201839418568e-06,
  'স' => 3.8201839418568e-06,
  'ু' => 3.8201839418568e-06,
  'ñ' => 3.8201839418568e-06,
  'ó' => 3.3426609491247e-06,
  'í' => 1.9100919709284e-06,
  'ऌ' => 1.9100919709284e-06,
  'ī' => 1.9100919709284e-06,
  'ন' => 1.9100919709284e-06,
  'র' => 1.9100919709284e-06,
  'ت' => 1.9100919709284e-06,
  'é' => 1.9100919709284e-06,
  'া' => 1.9100919709284e-06,
  'ऩ' => 1.9100919709284e-06,
  'ॄ' => 1.9100919709284e-06,
  'إ' => 1.9100919709284e-06,
  'س' => 1.9100919709284e-06,
  'চ' => 1.9100919709284e-06,
  'ü' => 1.9100919709284e-06,
  '中' => 1.9100919709284e-06,
  'ر' => 1.9100919709284e-06,
  'ষ' => 1.9100919709284e-06,
  'দ' => 1.9100919709284e-06,
  'ভ' => 1.9100919709284e-06,
  'ā' => 1.9100919709284e-06,
  '國' => 1.9100919709284e-06,
  'ॡ' => 1.9100919709284e-06,
  'ব' => 1.9100919709284e-06,
  'ن' => 1.9100919709284e-06,
  'ج' => 1.9100919709284e-06,
  'آ' => 1.9100919709284e-06,
  '秦' => 1.9100919709284e-06,
  'ऒ' => 1.9100919709284e-06,
  'ॆ' => 1.9100919709284e-06,
  'ح' => 1.9100919709284e-06,
  'ق' => 1.9100919709284e-06,
};
