use v6;

use Test;
use lib <lib>;

use HTML::BoreDOM;

plan 2;

my ($html, $expect);

$html = h("a", :href<http://www.example.com/?a=foo&b=bar&c=baz>);
$expect = Q:to<EOF>;
<a href="http://www.example.com/?a=foo&b=bar&c=baz"></a>
EOF

is $html, $expect, "attrs aren't escaped";

$html = h("p", "a > b && b < c");
$expect = Q:to<EOF>;
<p>a &gt; b &amp;&amp; b &lt; c</p>
EOF

is $html, $expect, "raw HTML is escaped";

done-testing;
