package main;
use Evo::Base -strict;
use Promises6 'deferred';
use Test::More tests => 2;
use Promises6::Util ':const';

my $count;
my $bldr = Promises6::Builder->singleton;
my $resolver;
my $deferred;
my $thenable;

# resolved circular
$count    = 0;
$thenable = ThenableCircularA->single;
$resolver = $bldr->resolver;
$deferred = $bldr->deferred;
$resolver->resolve($deferred, $thenable);
is $deferred->state, REJECTED, 'right state';
is $count, 1, 'called only once';

# thenables thet eventually cause circular recursion
{

  package ThenableCircularA;
  sub single { state $o = bless {}, shift }

  sub then {
    die "recursion" if ++$count > 1;
    $_[1]->(ThenableCircularB->single);
  }

  package ThenableCircularB;
  sub single { state $o = bless {}, shift }
  sub then { $_[1]->(ThenableCircularA->single) }
}
