package Promises6::Evo::Deferred;
use Evo::Base 'Promises6::Deferred';

sub send_msg($self, @args) {
  my $train = $self->builder->train;
  $train->asap(sub { $self->SUPER::send_msg(@args) });
}

1;

# ABSTRACT: A deferred class

__END__

=pod

=encoding UTF-8

=head1 NAME

Promises6::Evo::Deferred - A deferred class

=head1 VERSION

version 0.005

=head1 METHODS

=head2 send_msg

Provide an ability to send messages in the next tick, avoiding
a recursion and memory usage

=head1 AUTHOR

alexbyk <alexbyk.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
