package Evo::Io::Handle;
use Evo '-Comp::Out *; Symbol gensym';

with '-Io::Handle::Role';

sub open_nb($mode, $expr, @list) {
  my $fh = Evo::Io::Handle::init(gensym());
  open($fh, $mode, $expr, @list) || die "open: $!";    ## no critic
  $fh->handle_non_blocking(1);
}

sub open_nb_anon {
  my $fh = Evo::Io::Handle::init(gensym());
  open($fh, '>', undef);
  $fh->handle_non_blocking(1);
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Io::Handle

=head1 VERSION

version 0.0201

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
