package Evo::Lib;
use Evo '-Export *', -Util;
use Time::HiRes qw(CLOCK_MONOTONIC);

PATCH: {
  no warnings 'once';
  *Evo::Lib::debug        = *Evo::Util::debug{CODE};
  *Evo::Lib::monkey_patch = *Evo::Util::monkey_patch{CODE};
}

export qw(debug monkey_patch);


my $HAS_M_TIME = eval { Time::HiRes::clock_gettime(CLOCK_MONOTONIC); 1; };

export_anon steady_time => $HAS_M_TIME
  ? sub { Time::HiRes::clock_gettime(CLOCK_MONOTONIC); }
  : \&Time::HiRes::time;

sub ws_combine : Export {
  return unless @_;
  return $_[0] if @_ == 1;
  my @wrappers = reverse @_;
  sub {
    my $w = $_[0];
    $w = $_->($w) for @wrappers;
    $w;
  };
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Lib

=head1 VERSION

version 0.0186

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
