package Evo::Loop::Role::Zone;
use Evo '-Comp::Role *';
use Evo::Lib '*';
use Carp 'croak';

has zone_data => sub { {} };

# calls callback with passed ws, and combines prev + passed for wcb
sub zone : Role {
  my ($self, $fn) = (shift, pop);
  my $data = $self->zone_data;
  local $data->{w} = ws_combine($data->{w} ? ($data->{w}) : (), @_);
  $fn->();
}

sub zone_cb($self, $cb) : Role {
  my $data = $self->zone_data;
  my $w    = $data->{w};

  # restore(or restore empty) in zcb
  $w and return sub {
    local $data->{w} = $w;
    $w->($cb)->(@_);
  };
  sub {
    local $data->{w};
    $cb->(@_);
  };
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Loop::Role::Zone

=head1 VERSION

version 0.0181

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
