use Evo '-Lib *', '-Want *';
use Test::More;

DIE: {
  local $@ = 'prev';
  my $fired;
  my ($res, $err) = eval_context_run WANT_LIST, sub {
    $fired++;
    die "foo\n";
  };
  is $@, 'prev';
  ok !$res;
  ok !context_result($res);
  is $fired, 1;
}


my $want;
my @args = (22, 23);
my ($res, $err) = eval_context_run WANT_SCALAR, @args, sub {
  $_++ for @_;
  $want = wantarray;
  @_;
};

is_deeply \@args, [23, 24];
is context_result($res), 2;
want_is_scalar($want);

## don't return (undef)!
($res, $err) = eval_context_run WANT_VOID, sub { };
my @arr = context_result($res);
is @arr, 0;

done_testing;
