use Evo;
use Test::More;

STRICT: {

  no strict;    ## no critic
  no warnings;
  $sfswiojsdfs = 3;
  is $sfswiojsdfs, 3;

ENABLE_STRICT: {
    local $@;
    eval 'use Evo; $foo';    ## no critic
    like $@, qr/Global symbol "\$foo"/i;
  }

}

STRICT_IMPLICIT: {

  no strict;                 ## no critic
  no warnings;
  $sfswiojsdfs = 3;
  is $sfswiojsdfs, 3;

ENABLE_STRICT: {
    local $@;
    eval 'use Evo -Default; $foo';    ## no critic
    like $@, qr/Global symbol "\$foo"/i;
  }

}


FEATURE: {
  no feature ':5.16';
  my $outer;
  local $@;
  eval 'my $sub = sub  { $outer =  __SUB__; }';    ## no critic
  like $@, qr/__SUB__/;

ENABLE_FEATURE: {
    use Evo;
    my $outer;
    my $sub = sub { $outer = __SUB__; };
    $sub->();
    is $outer, $sub;

  }

}


done_testing;
