package main;
use Evo::Base -strict;
use Test::More;
use Test::Fatal;

my (@destroyed, @created, $fired);

FOO: {
  my $m = MyManager->new();
  $m->asap(
    sub {
      use Data::Dumper;
      $m->asap(sub { $fired++ });
    }
  );
}

ok $fired;
ok scalar @created;
is_deeply [sort @created], [sort @destroyed];

{

  package MyManager;
  use Evo::Base 'Evo::Manager';
  sub new { my $self = shift; push @created, $self; $self->SUPER::new(@_) }
  sub DESTROY { my $self = shift; push @destroyed, ref $self; }
}

done_testing;

