use Evo::Base -strict;
use Evo::Guard;
use Test::Fatal;
use Test::Spec;

describe 'guard' => sub {
  my (@args, $fired);
  my $cb = sub { @args = @_; $fired++ };
  before each => sub { ($fired, @args) = () };

  it 'must fire when out of scope' => sub {
  SCOPE: {
      my $guard = Evo::Guard->new($cb);
    }
    is $fired, 1;
    ok !@args;
  };

  it 'must fire when out of scope' => sub {
    like exception {
      my $guard = Evo::Guard->new($cb);
      die 'SuperError';
    }, qr/SuperError/;

    is $fired, 1;
    like shift @args, qr/SuperError/;
  };


};

runtests unless caller;
