use Evo::Base -strict;
use Test::More;
use Railway::Builder;
use Test::Fatal;

ok my $bldr = Railway::Builder->new;


like exception { $bldr->build_train->start }, qr/no stations/,
  'not started without stations';

like exception {
  my $t = $bldr->build_train;
  $t->way->add(sub($train) { $train->power(0) });
  $t->start;
  $t->start;
}, qr/already started/, 'not started without stations';

like exception {
  my $t = $bldr->build_train;
  $t->way->add(sub { });
  $t->run;
}, qr/no power/, 'not started without stations';

like exception {
  my $t = $bldr->build_train;
  $t->way->add(sub { });
  $t->power(1)->power(1);
}, qr/same power/i, 'not started without stations';

like exception {
  my $t = $bldr->build_train->depart
}, qr/start train first/i, 'not started without stations';

done_testing;


1;
