package main;
use Evo::Base -strict;
use Evo;
use Test::More;
use Benchmark ':all';

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 500_000 * $ENV{TEST_EVO_PERF};
my $N      = 1000_000;

my $sender = Evo::Base->new;
my $me     = Evo::Base->new;
Evo::mdn_subscribe $me, $sender, 0, sub { };

my $t = timeit($N, sub { Evo::mdn_broadcast $sender, 'foo'; });

diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;

