use Evo::Base -strict;
use Evo::Manager;
use Evo;
use Benchmark ':all';
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};


my $EXPECT = 1 * $ENV{TEST_EVO_PERF};
my $N      = 10;
my $L      = 100_000;

# 50_000, 5


my $t = timeit(
  $N,

  sub {
    my $k;
    foreach my $n (1 .. $L) {
      Evo::asap(
        sub {
          Evo::asap(
            sub {
              Evo::asap(sub { $k = $n });
            }
          );

        }
      );
    }

    ok $k == $L, "$k = $L";
  }

);

diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";


done_testing;
