package main;
use Evo::Base -strict;
use Test::More tests => 4;
use Evo::Spy;

my (@destroyed, @created, $fired);

{

  package MySpy;
  use Evo::Base 'Evo::Spy';
  sub new { my $self = shift->SUPER::new(@_); push @created, "$self"; $self; }
  sub DESTROY { my $self = shift; push @destroyed, "$self"; }
}

FOO: {
  my $sub = sub { $fired++ };
  MySpy::->new(origin => $sub)->code->();
  MySpy::->new->origin($sub)->code->();
  MySpy::->new(origin => $sub)->();
}

is $fired, 3;
ok scalar @destroyed;
is_deeply [sort @destroyed], [sort @created];
is_deeply(MySpy::->_all_store, {});


done_testing;


