use Evo::Base -strict;
use Evo::Spy;
use Test::Spec;
use Evo::Base -strict;

describe 'spy', sub {
  my ($i, $spy);
  before each => sub {
    $i = 0;
    $spy = Evo::Spy->new(origin => sub { $i++; });
  };

  it 'must store one arg', sub {
    $spy->('foo');
    is_deeply $spy->calls->[0]->{args}, ['foo'];
    $spy->code->('foo');
    is_deeply $spy->calls->[1]->{args}, ['foo'];
  };
  it 'must store many args', sub {
    $spy->('foo', 'bar');
    is_deeply $spy->calls->[0]->{args}, ['foo', 'bar'];
    $spy->code->('foo', 'bar');
    is_deeply $spy->calls->[1]->{args}, ['foo', 'bar'];
  };
  it 'must store no args as empty array', sub {
    $spy->();
    is_deeply $spy->calls->[0]->{args}, [];
    $spy->code->();
    is_deeply $spy->calls->[1]->{args}, [];
  };

};

runtests unless caller;
