package main;
use Evo::Base -strict;
use Evo;
use Test::More;
use Benchmark ':all';

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 15 * $ENV{TEST_EVO_PERF};
my $N      = 100;
my $n      = 100;
my $k      = 100;

my $sender = Evo::Base->new;
my $I;

my $t = timeit(
  $N,
  sub {
    my @senders     = map { Evo::Base->new } 1 .. $n;
    my @subscribers = map { Evo::Base->new } 1 .. $k;

    foreach my $snd (@senders) {
      Evo::mdn_subscribe $_, $snd, sub { $I++ }
        for @subscribers;
    }

    Evo::mdn_broadcast $_, 'foo' for @senders;
  }
);

ok $I == $n * $k * $N, "$I = $n x $k x $N";
diag "$I: $N(iters) x $n(senders) x $k(subscriberds); " . timestr $t;

my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;
