package Evo::Guard;
use Evo::Base -strict;

sub new {
  my $class = shift;
  Carp::croak "You have to save Evo::Guard object to the variable"
    unless defined wantarray;
  bless {@_}, $class;
}

sub DESTROY {
  my $self = shift;

  if ($self->{error}) {
    my $error = delete $self->{error};
    $@ and eval { $error->(); 1 } || Carp::carp $@;
  }

  (delete $self->{always})->() if $self->{always};
}

1;

# ABSTRACT: A guard

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Guard - A guard

=head1 VERSION

version 0.0156

=head1 SYNOPSIS

  use Evo::Base -strict;
  use Evo::Guard;
  my $guard = Evo::Guard->new(
    error  => sub { say "error" },
    always => sub { say "done" }
  );
  undef $guard;

=head2 Arguments

=head1 DESCRIPTION

Executes a code when no refs are pointed to this object.
The behavoiur is the same as L<Guard/"guard">, but this module is pure
perl (and about 70-80% slower). But that doesn't really matter at all

=head1 METHODS

=head2 new

Creates a guard object. It will raise an exception if you forget to save it
in somewhere.

If an error callback will thrown an exception (but this is surely a bug in 
your code), always callback will be executed too

=head3 error

A callback that will be always executed.

=head3 always

A callback that will be executed if an unhandled exception was trown in the
same scope

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
