use Evo::Base -strict;
use Railway::Builder;
use Benchmark ':all';
use Time::Piece;
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my ($start, $end, $dur);
my $bldr1 = Railway::Builder->new;
my $train = $bldr1->build_train;

my $N = 200_000;

# pure 500_000, 2, 10

$start = localtime;
foreach my $n (1 .. $N) {
  $train->way->add(sub {@_})->add(sub {"foo $n"})->add(sub {"bad"});
}
$end = localtime;
$dur = $end - $start;
diag "Build $N:, $dur";

$start = localtime;
$train->start();
$end = localtime;
$dur = $end - $start;
diag "Run $N:, $dur";

ok($dur < 10, 'less than 10 seconds');

done_testing;
