use Evo::Base -strict;
use Evo;
use Time::Piece;
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my ($start, $end, $dur);
my $m = Evo::Manager->singleton;


my $N = 100_000;

# pure  100_000, 1, 18

$start = localtime;
foreach my $n (1 .. $N) {
  Evo::asap(sub { $m->dsl_depth == 1 or die; });
}
$end = localtime;
$dur = $end - $start;
diag "Asap $N:, $dur";


ok($dur < 10, 'less than 10 seconds');
done_testing;
