package Evo::Train;
use Evo::Base 'Railway::Train';
use Evo::Manager;

#sub dispatch($self) {
#  $self->power(1);
#  do { $self->depart; $self->run } unless $self->is_current;    #nb
#}

# always current train
sub is_current($self) {
  return unless $self->manager->check_current('train');
  $self->manager->current('train') == $self;
}

#sub asap($self, @stations) {
#  $self->way->add($_) for @stations;
#  $self->start unless $self->is_current;
#}

1;

# ABSTRACT: A train, running engine

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Train - A train, running engine

=head1 VERSION

version 0.013

=head1 SYNOPSIS

  use Evo::Manager;
  my $mngr  = Evo::Manager->new;
  my $train = $mngr->build_train;

  our $foo = 'Non blocking';

  # will print Non blocking
  $train->asap(
    sub {
      local $foo = 'Blocking';
      $train->asap(sub { say $foo });
    }
  );

=head1 DESCRIPTION

This is a subclass of L<Railway::Train>

=head1 METHODS

=head2 is_current

  my $bool = $self->is_current;

Returns true if we are in this train, false otherwise

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
