use Evo::Base -strict;
use Railway::Builder;
use Guard;
use Benchmark ':all';
use Time::Piece;

my ($start, $end, $dur);
my $bldr1  = Railway::Builder->new;
my $train = $bldr1->build_train;

my $N = 500_000;

# pure 500_000, 2, 10

$start = localtime;
foreach my $n (1 .. $N) {
  $train->way->add(sub {@_})->add(sub {"foo $n"})->add(sub {"bad"});
}
$end = localtime;
$dur = $end - $start;
say "Build $N:, $dur";

$start = localtime;
$train->start();
$end = localtime;
$dur = $end - $start;
say "Run $N:, $dur";

