use 5.010_001;
use strict;
use warnings;

#use File::Basename;
#use File::Spec::Functions;


use Test::More;

use Text::Table::Read::RelationOn::Tiny;

use constant RELATION_ON => "Text::Table::Read::RelationOn::Tiny"; # to make calls shorter.

sub err_like(&$);
#use constant TEST_DIR => catdir(dirname(__FILE__), 'test-data');

{
  note("Constructor args");
  err_like {RELATION_ON->new(foo => 1)}                 qr/foo\b.*unexpected argument/;
  err_like {RELATION_ON->new(inc => [])}                qr/\binc must be a scalar/;
  err_like {RELATION_ON->new(noinc => [])}              qr/\bnoinc must be a scalar/;
  err_like {RELATION_ON->new(inc => 'x', noinc => 'x')} qr/\binc and noinc must be different/;
}

{
  note("get() args");
  my $obj = RELATION_ON->new();
  err_like {$obj->get(1, 2)} qr/Wrong number of arguments/;
  err_like {$obj->get({})}   qr/Invalid argument/;

  note("Accessor args");
  err_like {$obj->inc(1)}       qr/Unexpected arguments/;
  err_like {$obj->noinc(1)}     qr/Unexpected arguments/;
  err_like {$obj->matrix(1)}    qr/Unexpected arguments/;
  err_like {$obj->elems(1)}     qr/Unexpected arguments/;
  err_like {$obj->elem_ids(1)}  qr/Unexpected arguments/;
}

{
  note("Data error: wrong header");
  my $obj = RELATION_ON->new();
  err_like {$obj->get("foo|\n")}         qr/'foo\|': Wrong header format/;
  err_like {$obj->get("| |foo|foo|\n")}  qr/'foo': duplicate name in header/;
}

{
  note("Data error: other");
  my $obj = RELATION_ON->new();
  err_like {$obj->get("|.|foo|\nbar")}         qr/Wrong row format: 'bar'/;
  err_like {$obj->get("|.|foo|\n|bar|X|")}     qr/'bar': not in header/;
  err_like {$obj->get("|.|D|\n|D|X|\n|D|X|")}  qr/'D': duplicate element/;
  err_like {$obj->get("|.|foo|\n|foo|U|")}     qr/'U': unexpected entry/;
  err_like {$obj->get("|.|E|1|2|\n|E|X| |\n")}   qr/'1', '2': no rows for these elements/;
}


#--------------------------------------------------------------------------------------------------

#
# err_like CODEREF, MSGREGEX
#
# Check if CODEREF fails with error message matching MSGREGEX.
#
sub err_like(&$) {
  my ($sub, $re) = @_;
  local $Test::Builder::Level = $Test::Builder::Level + 1;
  eval {$sub->()};
  if ($@) {
    like($@, $re, "Error message ok");
  } else {
    fail("Coded did not produce error");
    return "";
  }
}

#==================================================================================================
done_testing();
