package Algorithm::Easing::Backdraft;

use Moo;

use Math::Trig qw(:pi);

use constant EPSILON => 0.000001;

extends 'Algorithm::Easing::Ease';

use namespace::clean;

sub ease_in  {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    my $s = 1.70158;
    my $post_fix = $t /= $d;
    return $c * ($post_fix) * $t * (($s + 1)*$t - $s) + $b;
}

sub ease_out  {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    my $s = 1.70158;
    return $c * (($t = $t / $d - 1) * $t * (($s + 1) * $t + $s) + 1) + $b;
}

sub ease_both  {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    my $s = 1.70158;
    if (($t /= $d / 2) < 1) {
        return $c / 2 * ($t * $t * ((($s *= (1.525)) + 1 )* $t - $s)) + $b;
    }
    my $post_fix = $t-= 2;
    return $c / 2 * (($post_fix) * $t * ((($s *= (1.525)) + 1) * $t + $s) + 2) + $b;
}

1;

__END__
