use Test::More tests => 183;

use IO::File 1.03;

BEGIN { use_ok Data::Entropy::Source; }

my $rawsource = IO::File->new("t/test0.entropy", "r") or die $!;
my $source = Data::Entropy::Source->new($rawsource, "getc");
ok $source;

my $nbits;
for($nbits = 1; <DATA>; $nbits++) {
	chop;
	is $source->get_bits($nbits), pack("h*", $_);
}

eval { $source->get_bits($nbits); };
like $@, qr/\Aentropy source failed:/;

__DATA__
10
00
40
e0
d0
c3
b4
aa
1710
2510
df30
f690
e050
97f1
82f2
6969
8f0600
e4ab20
392970
330480
9a0830
9104e2
e49800
799eb3
127e2710
093e3910
73224e30
b322ad60
802571c1
da60b0e0
8ef185f2
09ff56c1
dcdebc4710
e2ec56a720
b0d3a76940
cc023a1d30
ccb6bf6cc0
b77a0423d0
59f0e00911
253b85cd8d
3214ac73da00
35c1eef68920
af740597b630
103a67759cf0
1fb07a4669c0
9c424a95cec2
0b4830d92ff4
4d43f5f52618
8052be94045600
0532773a08e230
8b139e707c7350
2fe835d47ffad0
e34484277c3ca0
ad893e3008f7e3
516123ca4e1036
00a73dbd4ff564
74d93f4d54f1bf10
63ef6e92cb5fb610
82095fc80da9cc60
95050a38376925b0
600fdcc1a433b310
88e5f2c487102b60
6341fc1ef2207143
08080fc32b3280f9
68f6a813d90ff2d610
11e5cf4326efd8f830
bc5372b6326f8bd270
980810b13e1ab75090
85c58314d8f92f2921
559d88c0eb671dd442
9acf3babe0c20748a2
5296e4038e00557ac7
d799a58a3a2a0b025210
68bf1f50c44cff187a30
d03006f3d9d58f945a00
16927e0d7682c35ab1e0
b481745d9bf8e81eacb1
f3cc919880befeae96d2
a86c79476b5f6297d133
5cedccb0b44f95d262a3
586181f4a4b372be72cb10
2c63857b7dd52ae9363b30
41e3c3f8195e0187d43670
165b81b07e5bae45057a10
8d084ce93bf6fdeda5d7d1
70dfc76cea619cf8931c03
44cf51fec3d062a0ae2b04
0c2d569d37c249f1c28c2b
e192f92e9d2bb48cb7bd1b00
09bffaffadb47b648390d620
90866203666a42c24bf3f130
484646f263cae9c96309f2b0
ec71c1e1b40415566ec390a0
ba5579f3d4beb002d06406d0
7898d9deaba29badf044f0b4
9a3d4bb3b5c72cdd4581bda6
c045696f3ff072194c49bb0810
46302186a9066a4827dbc6c910
b5e4e20d2172f3deab79383700
c9ddc9315a58f5ab4f3ade4680
c49ce392ac3b00d2c99966abb0
b27ea60014eb75fe0d0c4b84d3
d359539565becb1a9925939701
79f74c8be06bf215186ceb8d3f
e4097117799c183c35f577014f10
c913e1b0bd762d20bb7589fbe710
10c16382179e1c6f044b55d67160
5bf481eaadf5f4656ee8d72742d0
4a08e0110a5dfc78c55e57fedd81
9e2fee97cb0e34c609a11068c1c2
9a15350dc0c6e11a6421ad3ecad1
76706cb429c64edf750377d9fb2a
597c9a43e53cd24564804d68b69000
a6cc6b23ffbac9a97abb95886d1200
383ae49fcfc9b6bae7a3f89d2a5a00
1e5e97a92b28eceab6922045032340
3f7050a3979bb01eb5c0ffac607831
f4bbd24d3638795fea41ef0cf28773
474b149665ca207f3efdf7da3e8566
2141b103ac5ecf0c7c20d1e66ce435
0ed4acb43f81bfddddad4a7e40693e00
9e6cbd9bc8168026b6354f25410d9120
b96c013228085f28b34610826674d870
197ef6e9989326524ac5bc9f83b318a0
19a5993ab4d1ac2c535d6ed76f46b091
22900c377cfe5a9bf216f7e464ed78f3
7c50d5b2722a35c51f903b558cdb2f41
13c2150b6ca7789e8577bb0d9afb1004
bfb88c10a10afb38d0bdd4bff2dd94e700
e6a465b603f65fb5ff2e142934a6d87010
f2f073b4a0ccb8f5bb85cfffe0fae52220
bee8447d2a913664acee9b1774ccdf8200
31b34a6b37361742f51d4b0762ecbd8a01
1ee7af3f595dfe33709d92115b76ff7ee3
aded30b8fc284a81adc1173ad48ec4e191
b3ba5fb44fcc857f9bfe9c0466e75fbe51
933c98a6df1a7922f2f228ce506a865f3000
12c207c2e0798830fa6a5a1ff85d433b6d20
4aec7af96b156cde4204097894c66ce8e960
c8533a9ba4674dc7ec680fd3222d013a1640
c6375acd14a97183bee2b3e98960221613e0
4f82c5458b8ab1918349cc20891e6dde4181
dcb17a469448fa4ae0e723b086e08b05d935
04ea4d4b7f0a96134c06e233768ddbd6bc83
209259da3f156b57b843095ced20a79e031900
a5182a50f919956873976de0d95f5ce0555f10
79f103ee5b9617cd690a06c5d78a501932d350
be87e2080c6dd7784003d15f45247432b55620
80e78aa0119790d8200a3fd06911895531bc71
92d17bca4361318a3de9ad7f0a83eebf473be2
20c5522606c64451b9e18a7bb0ebcf63e00040
fc4bd8b5d6ed5fd0d53bfb6691e189f6acae5b
55f5fd758f5140c33e4920ebee37c129d8ec2a00
6e6e2182c191f464b7c4480194cb669318b35f00
b0b5ba083a59d3a189e069baade752a70d03b050
9b07da697d1f024a951c355e64b8ccf0863176f0
77bf57024d3944fd1d7714ff19128df8c1bc7240
2ae12bc33b442abf18b8f98b03b13d8433d1b932
3236a7d327ca788011419135c947b209fccd4e10
738aeb1b6b7e27dfb512b7ac8f29ae265d4b4b4b
eab2cef5581fd5e4804d17866609b586835542d700
da46c808f4092185a7930df13961f926eca70da520
5e15d5814b8f6cea417b0c68e4360e3cd52318e210
54ec0b2397ad3f7e939d9d418352c04dbc502c1890
387cc88c0b25aab332a6f9e9ee4548a6e8915ffcf0
b6d7e6a09633cfbbacd65195ae6de23e30fc83fa73
f6f0fe7bd4a4801d781094754c1086f18891d87691
dc6b6dac6d733176ddb1f67233a5ead9a10f372480
5c56c592e9a7b860222ca5d341dfd9c5d81bd3c71400
09fda5bcd6d5eff9c17ba9de7a2775f5c674713be130
120958f6b7e075926f0a9d1f26040cf2cb50c3b36e40
ef347a971670bb6d126101f1902c9479c2f10d5aa6e0
9655b18890a62132a500092e4b7762e56b5d302bb211
8339391546b773124da99bf9cde2d1cc84ce0a527ee1
797c197e31c8e6edb925c5697f3d8dc5df08575c40c0
dadf44f63c7fe16f64fa3a81dc78f1b77c56c0e44123
b7959a80a6e25165b7a7b968eccdef72baaaf699ac3d00
ef65f2984b7ad99e89d3aa1ae4dc94d3052bbd291bee30
bffd476ea3515dd1da9020927c9ccd64df76273c96e930
c8eb4d3d7e51d7c83f35de3fff19cdfd779136f6e42020
