package Pcore::Handle::Pg;

use Pcore qw[-class];
use DBD::Pg;

with qw[Pcore::DBD];

has '+h_disconnect_on' => ( isa => Enum [ 'PID_CHANGE', 'BEFORE_FORK', 'REQ_FINISH' ], default => 'PID_CHANGE' );

has addr     => ( is => 'ro', isa => Str, required => 1 );    # use unix:/var/lib/mysql/mysql.sock as default unix socket
has schema   => ( is => 'ro', isa => Str, required => 1 );
has username => ( is => 'ro', isa => Str, required => 1 );
has password => ( is => 'ro', isa => Str, required => 1 );

# H
around h_connect => sub {
    my $orig = shift;
    my $self = shift;

    my $h = $self->$orig;

    return $h;
};

# DBD
sub _build__connection {
    my $self = shift;

    my $attr = P->hash->merge( $self->_default_attr, {} );

    my $addr = P->uri( $self->addr );

    my $host = $addr->host;

    my $port = $addr->port;

    return [ q[dbi:Pg:dbname=] . $self->schema . qq[;host=$host;port=$port], $self->username, $self->password, $attr ];
}

1;
__END__
=pod

=encoding utf8

=cut
